<?php

// Version 1.7 01/06/2019

session_start();
require("../concc/dbinfo.php");


$dataPOST = trim(file_get_contents('php://input'));
$myfile = fopen("dataFromApp/general.txt", "w") or die("Unable to open file!");
fwrite($myfile, $dataPOST);

fclose($myfile);




$dataPOST = str_replace('&', '&amp;', $dataPOST); 

$dataPOST = str_replace('<br>', '', $dataPOST); 
$dataPOST = str_replace('<p dir=ltr>', '', $dataPOST); 
$dataPOST = str_replace('<b>', '', $dataPOST);
$dataPOST = str_replace('</b>', '', $dataPOST);
$dataPOST = str_replace('</p>', '', $dataPOST);

$xmlData = simplexml_load_string($dataPOST);



$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");




$fileName=$xmlData->deviceID['devID'];
$myfile = fopen("dataFromApp/$fileName.txt", "w") or die("Unable to open file!");
fwrite($myfile, $dataPOST);

fclose($myfile);

$validID=false;
$stm = $db->prepare("SELECT expiry_date,status FROM Devices WHERE device_id='$fileName'");
$stm-> execute();
$stm-> bind_result($expiryDate,$status);
while ($stm->fetch()) {
   
$validID=true;
   

}
$stm-> close();


if(!$validID)
{
    return;
}

$myfile = fopen("dataFromApp/error.txt", "w") or die("Unable to open file!");
fwrite($myfile, "ERROR Reporting:");
fclose($myfile);

$devID = $xmlData->deviceID['devID'];
$appURL = $xmlData->deviceID['url'];
$currURL = $_SERVER["HTTP_HOST"].$_SERVER['REQUEST_URI'];
$androidID = $xmlData->deviceID['androidID'];
$companyCode = $xmlData->deviceID['companyCode'];
$displayPrefix = $xmlData->deviceID['displayPrefix'];
$databasePrefix = $xmlData->deviceID['databasePrefix'];
$activationCode = $xmlData->deviceID['activationCode'];
$isActivation   = $xmlData->deviceID['activation'];

$appURL = str_replace('https://','',$appURL);
$appURL = str_replace('http://' ,'',$appURL);

$authError = new stdClass();

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(strcmp("$appURL","$currURL")!=0){
    $authError->code = '1';
    $authError->name = 'Domain Mismatch';
    $authError->details = "App URL Call [$appURL] - Server URL Call [$currURL]";
    $myfile = fopen("dataFromApp/error.txt", "a") or die("Unable to open file!");
    fwrite($myfile, "\n".json_encode($authError));
    fclose($myfile);
    http_response_code(403);
    echo "Forbidden: Access Denied";
    exit();
} else {

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT count(company_id) FROM Companies WHERE company_code = '$companyCode' LIMIT 1");
    $stm->execute();
    $stm->bind_result($companiesCount);
    while ($stm->fetch()) {}
    $stm->close();

    if($companiesCount > 0){

        $stm = $db->prepare("SELECT count(device_id) FROM Devices WHERE display_prefix = '$displayPrefix' AND device_id = '$devID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($devicesCount);
        while ($stm->fetch()) {}
        $stm->close();

        if($devicesCount == 0){
            $authError->code = '2';
            $authError->name = 'Device Mismatch';
            $authError->details = "Device [ID:$devID][PREFIX:$displayPrefix] does not exist in Database";
            http_response_code(403);
            echo "Forbidden: Access Denied";
            $myfile = fopen("dataFromApp/error.txt", "a") or die("Unable to open file!");
            fwrite($myfile, "\n".json_encode($authError));
            fclose($myfile);
            exit();
        }

    } else if(strcmp($isActivation,'CopYes')==0){

        $stm = $db->prepare("SELECT count(device_id) FROM Devices WHERE activation_code = '$activationCode' AND device_id = '$devID' LIMIT 1");
        $stm->execute();
        $stm->bind_result($devicesCount);
        while ($stm->fetch()) {}
        $stm->close();

        if($devicesCount == 0){
            $authError->code = '3';
            $authError->name = 'Activation Device Mismatch';
            $authError->details = "Activation Device [ID:$devID][PREFIX:$displayPrefix] does not exist in Database";
            http_response_code(403);
            echo "Forbidden: Access Denied";
            $myfile = fopen("dataFromApp/error.txt", "a") or die("Unable to open file!");
            fwrite($myfile, "\n".json_encode($authError));
            fclose($myfile);
            exit();
        }

    } else {
        $authError->code = '4';
        $authError->name = 'Company Mismatch';
        $authError->details = "Company [CODE:$companyCode] does not exist in Database";
        http_response_code(403);
        echo "Forbidden: Access Denied";
        $myfile = fopen("dataFromApp/error.txt", "a") or die("Unable to open file!");
        fwrite($myfile, "\n".json_encode($authError));
        fclose($myfile);
        exit();
    }


}
$myfile = fopen("dataFromApp/error.txt", "a") or die("Unable to open file!");
fwrite($myfile, "\nNo Errors.");
fclose($myfile);
//CustomerGroups ------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->CustomerGroups as $s) {


    $groupID = $s['group_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM CustomerGroups WHERE group_id='$groupID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $groupCode=$s['group_code'];
        $name=$s['name'];
        $description=$s['description'];
        $creationDate=$s['creation_date'];
        $stmt = $db->prepare("REPLACE INTO CustomerGroups (group_id,group_code,name,description,creation_date,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('issss',$groupID,$groupCode,$name,$description,$creationDate);
        $stmt->execute();
        $stmt->close();
    }

}




//Customers ----------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Customers as $s) {


    $customerID = $s['customer_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Customers WHERE customer_id='$customerID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
$balance=0;
    if($executeCommand)
    {

        $stm2 = $db->prepare("SELECT balance FROM Customers WHERE customer_id='$customerID'");
        $stm2-> execute();
        $stm2-> bind_result($balance12);
        while ($stm2->fetch()) {

       
            $balance=$balance12;
        }
        $stm2-> close();

        $customerCode=$s['customer_code'];
        $name=$s['customer_company_name'];
        $reportName=$s['customer_report_name'];
        $logo=$s['logo'];
        $registrationCode=$s['registration_code'];
        $mobile=$s['mobile'];
        $website=$s['website'];
        $email=$s['email'];
        $description=$s['description'];
        $typeOfBusiness=$s['type_of_business'];
        $ticCode=$s['tic_code'];
        $vatCode=$s['vat_code'];
        $creditLimit=$s['credit_limit'];
        $typeOfCustomer=$s['customer_type'];

        $stmt = $db->prepare("REPLACE INTO Customers (customer_id,customer_code,customer_company_name,customer_report_name,logo,registration_code,mobile,website,email,description,type_of_business,tic_code,vat_code,credit_limit,customer_type,balance,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('issssssssssssssd',$customerID,$customerCode,$name,$reportName,$logo,$registrationCode,$mobile,$website,$email,$description,$typeOfBusiness,$ticCode,$vatCode,$creditLimit,$typeOfCustomer,$balance);
        $stmt->execute();
        $stmt->close();
    }

}


//Customer_CustomersGroup-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Customer_CustomersGroup as $s) {


    $groupID = $s['group_id'];
    $customerID=$s['customer_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Customer_CustomersGroup WHERE group_id='$groupID' AND customer_id='$customerID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $addedDate=$s['added_date'];
        $salepersonID=$s['salesperson_id'];

        $stmt = $db->prepare("REPLACE INTO Customer_CustomersGroup (group_id,customer_id,added_date,salesperson_id,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('iisi',$groupID,$customerID,$addedDate,$salepersonID);
        $stmt->execute();
        $stmt->close();
    }

}


//CustomerAddress----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->CustomerAddress as $s) {


    $customerAddressID= $s['customer_address_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM CustomerAddress WHERE customer_address_id='$customerAddressID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $addressCode=$s['address_code'];
        $customerID=$s['customer_id'];
        $country=$s['country'];
        $city=$s['city'];
        $addressLine1=$s['address_line_1'];
        $addressLine2=$s['address_line_2'];
        $postcode=$s['postcode'];
        $region=$s['region'];
        $lat=$s['lat'];
        $lng=$s['lng'];
        $pobox=$s['pobox'];
        $landline=$s['landline'];
        $fax=$s['fax'];
        $primaryAddress=$s['primary_address'];

        $stmt = $db->prepare("REPLACE INTO CustomerAddress (customer_address_id,address_code,customer_id,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,landline,fax,primary_address,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isissssssssssss',$customerAddressID,$addressCode,$customerID,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$landline,$fax,$primaryAddress);
        $stmt->execute();
        $stmt->close();
    }

}



//Contact_Person---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Contact_Person as $s) {


    $contactPersonID= $s['contact_person_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Contact_Person WHERE contact_person_id='$contactPersonID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $firstName=$s['first_name'];
        $lastName=$s['last_name'];
        $position=$s['position'];
        $landline=$s['landline'];
        $mobile=$s['mobile'];
        $fax=$s['fax'];
        $email=$s['email'];
        $customerID=$s['customer_id'];
        $notes=$s['notes'];


        $stmt = $db->prepare("REPLACE INTO Contact_Person (contact_person_id,first_name,last_name,position,landline,mobile,fax,email,customer_id,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isssssssis',$contactPersonID,$firstName,$lastName,$position,$landline,$mobile,$fax,$email,$customerID,$notes);
        $stmt->execute();
        $stmt->close();
    }

}


//Categories-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Categories as $s) {


    $categoryID= $s['category_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Categories WHERE category_id='$categoryID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $categoryCode=$s['category_code'];
        $name=$s['name'];
        $description=$s['description'];
        $creationDate=$s['creation_date'];
        $allowSubcategories=$s['allow_subcategories'];
        $allowItems=$s['allow_items'];


        $stmt = $db->prepare("REPLACE INTO Categories (category_id,category_code,name,description,creation_date,allow_subcategories,allow_items,timestamp) VALUES(?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('issssss',$categoryID,$categoryCode,$name,$description,$creationDate,$allowSubcategories,$allowItems);
        $stmt->execute();
        $stmt->close();
    }

}


//Vats--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Vats as $s) {


    $vatID= $s['vat_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Vats WHERE vat_id='$vatID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $vatCode=$s['vat_code'];
        $displayName=$s['vat_display_name'];
        $percentage=$s['percentage'];

        $stmt = $db->prepare("REPLACE INTO Vats (vat_id,vat_code,vat_display_name,percentage,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('issd',$vatID,$vatCode,$displayName,$percentage);
        $stmt->execute();
        $stmt->close();
    }

}




//Items--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Items as $s) {


    $itemID= $s['item_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Items WHERE item_id='$itemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $itemCode=$s['item_code'];
        $itemSku=$s['item_sku'];
        $companyID=$s['company_id'];
        $vatID=$s['vat_id'];
        $subunits=$s['subunits'];
        $salesUnits=$s['sales_units'];
        $manufacturerID=$s['manufacturer_id'];
        $name=$s['name'];
        $shortDescription=$s['short_description'];
        $longDescription=$s['long_description'];
        $thumb=$s['thumbnail_url'];
        $reorderLevel=$s['reorder_level'];
        $targetQTY=$s['target_qty'];
        $bundled=$s['bundled'];
        $maxStock=$s['max_stock'];
        $minStock=$s['min_stock'];
        $packing=$s['packing'];
        $stockControl=$s['stock_control'];
        $sellable=$s['sellable'];
        $weight=$s['weight'];
        $cbm=$s['cbm'];
        $status=$s['status'];

        $stmt = $db->prepare("REPLACE INTO Items (item_id,item_code,item_sku,company_id,vat_id,subunits,sales_units,manufacturer_id,name,short_description,long_description,thumbnail_url,reorder_level,target_qty,bundled,max_stock,min_stock,packing,stock_control,sellable,weight,cbm,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('issiidsissssdisdddsssss',$itemID,$itemCode,$itemSku,$companyID,$vatID,$subunits,$salesUnits,$manufacturerID,$name,$shortDescription,$longDescription,$thumb,$reorderLevel,$targetQTY,$bundled,$maxStock,$minStock,$packing,$stockControl,$sellable,$weight,$cbm,$status);
        $stmt->execute();
        $stmt->close();
    }

}


//Item_Barcode--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Item_Barcode as $s) {


    $itemID= $s['item_id'];
    $barcode= $s['barcode'];
    $defaultBarcode = $s['default_barcode'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Item_Barcode WHERE item_id='$itemID' AND barcode='$barcode'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO Item_Barcode (item_id,barcode,default_barcode,timestamp) VALUES(?,?,?,NOW())");
        $stmt->bind_param('iss',$itemID,$barcode,$defaultBarcode);
        $stmt->execute();
        $stmt->close();
    }

}





//PriceTypes-----------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->PriceTypes as $s) {


    $priceTypeID= $s['pricetype_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM PriceTypes WHERE pricetype_id='$priceTypeID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $priceCode=$s['price_code'];
        $name=$s['name'];
        $allowDiscount=$s['allow_discount'];
        $defaultType=$s['default_type'];

        $stmt = $db->prepare("REPLACE INTO PriceTypes (pricetype_id,price_code,name,allow_discount,default_type,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('issss',$priceTypeID,$priceCode,$name,$allowDiscount,$defaultType);
        $stmt->execute();
        $stmt->close();
    }

}


//Prices--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Prices as $s) {


    $itemID= $s['item_id'];
    $pricetypeID= $s['pricetype_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Prices WHERE item_id='$itemID' AND pricetype_id='$pricetypeID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $price=$s['price'];
        $allowDiscount=$s['allow_discount'];
        $incVat=$s['inc_vat'];

        $stmt = $db->prepare("REPLACE INTO Prices (item_id,pricetype_id,price,allow_discount,inc_vat,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iisss',$itemID,$pricetypeID,$price,$allowDiscount,$incVat);
        $stmt->execute();
        $stmt->close();
    }

}



//Category_Item--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Category_Item as $s) {


    $itemID= $s['item_id'];
    $categoryID= $s['category_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Category_Item WHERE item_id='$itemID' AND category_id='$categoryID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Category_Item (category_id,item_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$categoryID,$itemID);
        $stmt->execute();
        $stmt->close();
    }

}






//Warehouses---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouses as $s) {


    $warehouseID= $s['warehouse_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Warehouses WHERE warehouse_id='$warehouseID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $warehouseCode=$s['warehouse_code'];
        $companyID=$s['company_id'];
        $name=$s['name'];
        $type=$s['type'];
        $landline=$s['landline'];
        $fax=$s['fax'];
        $email=$s['email'];
        $country=$s['country'];
        $city=$s['city'];
        $addressLine1=$s['address_line_1'];
        $addressLine2=$s['address_line_2'];
        $postcode=$s['postcode'];
        $region=$s['region'];
        $lat=$s['lat'];
        $lng=$s['lng'];
        $pobox=$s['pobox'];
        $salespersonID=$s['salesperson_id'];

        $stmt = $db->prepare("REPLACE INTO Warehouses (warehouse_id,warehouse_code,company_id,name,type,landline,fax,email,country,city,address_line_1,address_line_2,postcode,region,lat,lng,pobox,salesperson_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isissssssssssssssi',$warehouseID,$warehouseCode,$companyID,$name,$type,$landline,$fax,$email,$country,$city,$addressLine1,$addressLine2,$postcode,$region,$lat,$lng,$pobox,$salespersonID);
        $stmt->execute();
        $stmt->close();
    }

}




//Stock--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Stock as $s) {


    $warehouseID= $s['warehouse_id'];
    $itemID= $s['item_id'];
    $batchnumber=$s['batch_number'];

    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Stock WHERE item_id='$itemID' AND batch_number='$batchnumber' AND warehouse_id='$warehouseID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $available=$s['available'];
        $reserved=$s['reserved'];
        $delivered=$s['delivered'];
        $onOrder=$s['on_order'];
        $requested=$s['requested'];
        $sold=$s['sold'];
        $expiryDate=$s['expiry_date'];

        $stmt = $db->prepare("REPLACE INTO Stock (warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iisdddddds',$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate);
        $stmt->execute();
        $stmt->close();
    }

}





//PaymentTypes-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->PaymentTypes as $s) {


    $paymentTypeID= $s['paymenttype_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM PaymentTypes WHERE paymenttype_id='$paymentTypeID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $pamentTypeCode=$s['paymenttype_code'];
        $name=$s['name'];

        $stmt = $db->prepare("REPLACE INTO PaymentTypes (paymenttype_id,paymenttype_code,name,timestamp) VALUES(?,?,?,NOW())");
        $stmt->bind_param('iss',$paymentTypeID,$pamentTypeCode,$name);
        $stmt->execute();
        $stmt->close();
    }

}

// Order_Item---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Order_Item as $s) {


    $orderItemID= $s['order_item_id'];
    $orderID= $s['order_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Order_Item WHERE order_item_id='$orderItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($orderID,'Orders'))
    {
        $executeCommand = false;
    }


    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $qty= $s['qty'];
        $qtyDelivered= $s['qty_delivered'];
        $qtyInvoiced= $s['qty_invoiced'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $pricetypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];

        if(isset($s['description']))
        {
            $description= $s['description'];
        }
        else
        {
            $description= "";

        }

        $promotionID= $s['promotion_id'];
        $promotionNumber= $s['promotion_number'];
        $masterItem= $s['master_item'];

        $stmt = $db->prepare("REPLACE INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,promotion_id,promotion_number,master_item,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiddddddddiissss',$orderItemID,$orderID,$itemID,$qty,$qtyDelivered,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description,$promotionID,$promotionNumber,$masterItem);
        $stmt->execute();
        $stmt->close();
    }

}

// Orders-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Orders as $s) {


    $orderID= $s['order_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Orders WHERE order_id='$orderID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if(docIsLocked($orderID,'Orders'))
    {
         $executeCommand = false;
    }

    if($executeCommand)
    {

        $orderCode= $s['order_code'];
        $companyID=$s['company_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $paymentTypeID= $s['paymenttype_id'];

        $dateTime = new DateTime($s['order_date']);
        $orderDate= date_format($dateTime, 'Y-m-d' );

        $subtotal= $s['subtotal'];
        $grandTotal= $s['grand_total'];
        $vatAmount= $s['vat_amount'];
        $discountAmount= $s['discount_amount'];
        $printCount= $s['print_count'];
        $orderAddressID= $s['order_address_id'];
        $deliveryAddressID= $s['delivery_address_id'];
        $tenderID= $s['tender_id'];
        $vatIE= $s['vat_i_or_e'];



        if(isset($s['delivery_date']))
        {
            $dateTime = new DateTime($s['delivery_date']);
            $deliveryDate= date_format($dateTime, 'Y-m-d' );
        }
        else
        {
            $deliveryDate= "";

        }

        $depositAmount= $s['deposit_amount'];

        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details= "";

        }

        $status= $s['status'];
        $currencyID= $s['currency_id'];
        $globalDiscountPercentage= $s['global_discount_percentage'];
        $deliveryMethod= $s['delivery_method'];

        $stmt = $db->prepare("REPLACE INTO Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,currency_id,global_discount_percentage,delivery_method,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiisddddiiiissdssids',$orderID,$orderCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$printCount,$orderAddressID,$deliveryAddressID,$tenderID,$vatIE,$deliveryDate,$depositAmount,$details,$status,$currencyID,$globalDiscountPercentage,$deliveryMethod);
        $stmt->execute();
        $stmt->close();
        
         
        $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$orderID AND table_name='Orders'";
        
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();

        
    }

}

// Invoice_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Invoice_Item as $s) {


    $invoiceItemID= $s['invoice_item_id'];
    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Invoice_Item WHERE invoice_item_id='$invoiceItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($invoiceID,'Invoices'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $batchNumber= $s['batch_number'];
        $warehouseID= $s['warehouse_id'];
        $qty= $s['qty'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $priceTypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];
        $serialnumber= $s['serialnumber'];
        if(isset($s['description']))
        {
            $description= $s['description'];
        }
        else
        {
            $description= "";

        }
        $cost= $s['cost'];
        $promotionID= $s['promotion_id'];
        $promotionNumber= $s['promotion_number'];
        $masterItem= $s['master_item'];
        $stmt = $db->prepare("REPLACE INTO Invoice_Item (invoice_item_id,invoice_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,promotion_id,promotion_number,master_item,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisiddddddiissdsss',$invoiceItemID,$invoiceID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$cost,$promotionID,$promotionNumber,$masterItem);
        $stmt->execute();
        $stmt->close();
    }

}

// Invoices-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Invoices as $s) {


    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Invoices WHERE invoice_id='$invoiceID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($invoiceID,'Invoices'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {

        $invoiceCode= $s['invoice_code'];
        $companyID=$s['company_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $paymentTypeID= $s['paymenttype_id'];
        $orderID= $s['order_id'];
        $tenderID= $s['tender_id'];
        $subtotal= $s['subtotal'];
        $grandTotal= $s['grand_total'];
        $vatAmount= $s['vat_amount'];
        $vatIorE= $s['vat_i_e'];
        $discountAmount= $s['discount_amount'];
        $invoiceAddressID= $s['invoice_address_id'];
        $deliveryAdressID= $s['delivery_address_id'];
        $printCount= $s['print_count'];
        if($s['invoice_date']!="null" && isset($s['invoice_date']) )
        {
            $dateTime = new DateTime($s['invoice_date']);
            $invoiceDATE= date_format($dateTime, 'Y-m-d' );
        }
        else
        {
            $invoiceDATE="";
        }
        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details= "";

        }
        $invoiceType= $s['invoice_type'];


        if($s['due_date']!="null" && !is_null($s['due_date']))
        {
            $dateTime = new DateTime($s['due_date']);
            $dueDate=date_format($dateTime, 'Y-m-d' );
        }
        else
        {$dueDate="";
        }
        $status= $s['status'];
        $currencyID= $s['currency_id'];
        $globalDiscountPercentage= $s['global_discount_percentage'];


        $stmt = $db->prepare("REPLACE INTO Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,invoice_address_id,delivery_address_id,print_count,invoice_date,details,invoice_type,due_date,status,currency_id,global_discount_percentage,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiiidddsdiiisssssid',$invoiceID,$invoiceCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$tenderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$invoiceAddressID,$deliveryAdressID,$printCount,$invoiceDATE,$details,$invoiceType,$dueDate,$status,$currencyID,$globalDiscountPercentage);
        $stmt->execute();
        $stmt->close();
        
       
        
        
        
           $deleteID = getNextKey("Deletes", "delete_id");
       $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$invoiceID AND table_name='Invoices'";
        
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
        
        
        
        
    }

}

// Receipt_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Receipt_Item as $s) {


    $receiptItemID= $s['receipt_item_id'];
    $receiptID= $s['receipt_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Receipt_Item WHERE receipt_item_id='$receiptItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($receiptID,'Receipts'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {


        $amount= $s['amount'];
        $paymentMethod= $s['payment_method'];
        $cashDiscount= $s['cash_discount'];

        if(isset($s['bank'])&&$s['bank']!="null")
        {
            $bank= $s['bank'];
        }
        else
        {
            $bank= " ";
        }
        if(isset($s['branch'])&&$s['branch']!="null")
        {
            $branch= $s['branch'];
        }
        else
        {
            $branch= " ";
        }
        if(isset($s['cheque_number'])&&$s['cheque_number']!="")
        {
            $chequeNumber= $s['cheque_number'];

        }
        else
        {
            $chequeNumber= " ";
        }
        if(isset($s['cheque_date'])&&$s['cheque_date']!="0000-00-00"&&$s['cheque_date']!="null")
        {
            $dateTime = new DateTime($s['cheque_date']);
            $chequeDate=date_format($dateTime, 'Y-m-d' );

        }
        else
        {
            $chequeDate= " ";
        }



        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= "";
        }



        $stmt = $db->prepare("REPLACE INTO Receipt_Item (receipt_item_id,receipt_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iidsdsssss',$receiptItemID,$receiptID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$notes);
        $stmt->execute();
        $stmt->close();


    }

}

// Receipts-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Receipts as $s) {


    $receiptID= $s['receipt_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Receipts WHERE receipt_id='$receiptID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
     if(docIsLocked($receiptID,'Receipts'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {

        $recieptCode= $s['receipt_code'];
        $customerID=$s['customer_id'];
        $companyID= $s['company_id'];
        $salepersonID= $s['salesperson_id'];
        $orderID= $s['order_id'];
        $invoiceID= $s['invoice_id'];
        $addressID= $s['address_id'];
        $amount= $s['amount'];
        $paymentMethod= $s['payment_method'];
        $cashDiscount= $s['cash_discount'];
        $printCount= $s['print_count'];

        if(isset($s['bank'])&&$s['bank']!="null")
        {
            $bank= $s['bank'];
        }
        else
        {
            $bank= " ";
        }
        if(isset($s['branch'])&&$s['branch']!="null")
        {
            $branch= $s['branch'];
        }
        else
        {
            $branch= " ";
        }
        if(isset($s['cheque_number'])&&$s['cheque_number']!="")
        {
            $chequeNumber= $s['cheque_number'];

        }
        else
        {
            $chequeNumber= " ";
        }
        if(isset($s['cheque_date'])&&$s['cheque_date']!="0000-00-00"&&$s['cheque_date']!="null")
        {
            $dateTime = new DateTime($s['cheque_date']);
            $chequeDate=date_format($dateTime, 'Y-m-d' );

        }
        else
        {
            $chequeDate= " ";
        }

        if(isset($s['receipt_date'])&&$s['receipt_date']!="0000-00-00")
        {
            $dateTime = new DateTime($s['receipt_date']);
            $receiptDate=date_format($dateTime, 'Y-m-d' );

        }
        else
        {
            $receiptDate= " ";
        }



        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= "";
        }



        $stmt = $db->prepare("REPLACE INTO Receipts (receipt_id,receipt_code,customer_id,company_id,salesperson_id,order_id,invoice_id,address_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,receipt_date,notes,print_count,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiiidsdssssssi',$receiptID,$recieptCode,$customerID,$companyID,$salepersonID,$orderID,$invoiceID,$addressID,$amount,$paymentMethod,$cashDiscount,$bank,$branch,$chequeNumber,$chequeDate,$receiptDate,$notes,$printCount);
        $stmt->execute();
        $stmt->close();
        
    
        
        
        
            
           $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$receiptID AND table_name='Receipts'";
        
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}

// Return_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Return_Item as $s) {


    $returnItemID= $s['return_item_id'];
    $returnID= $s['return_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Return_Item WHERE return_item_id='$returnItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($returnID,'Returns'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $batchNumber= $s['batch_number'];
        $warehouseID= $s['warehouse_id'];
        $qty= $s['qty'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $priceTypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];
        $serialnumber= $s['serialnumber'];
        $description= $s['description'];
        $status= $s['status'];
        $cost= $s['cost'];


        $stmt = $db->prepare("REPLACE INTO Return_Item (return_item_id,return_id,item_id,batch_number,warehouse_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,status,cost,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisiddddddiisssd',$returnItemID,$returnID,$itemID,$batchNumber,$warehouseID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$status,$cost);
        $stmt->execute();
        $stmt->close();
    }

}


// Returns-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Returns as $s) {


    $returnID= $s['return_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Returns WHERE return_id='$returnID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
  if(docIsLocked($returnID,'Returns'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {

        $returnCode= $s['return_code'];
        $companyID=$s['company_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $paymentTypeID= $s['paymenttype_id'];
        $orderID= $s['order_id'];
        $subtotal= $s['subtotal'];
        $grandTotal= $s['grand_total'];
        $vatAmount= $s['vat_amount'];
        $vatIorE= $s['vat_i_e'];
        $discountAmount= $s['discount_amount'];
        $returnAddressID= $s['return_address_id'];
        $printCount= $s['print_count'];
        $returnDate= $s['return_date'];
        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details= "";
        }
        $status= $s['status'];
        $currencyID= $s['currency_id'];
        $globalDiscountPercentage= $s['global_discount_percentage'];
$returnType =$s['return_type'];
        $stmt = $db->prepare("REPLACE INTO Returns (return_id,return_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,return_address_id,print_count,return_date,details,status,currency_id,global_discount_percentage,return_type,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiidddsdiisssids',$returnID,$returnCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$returnAddressID,$printCount,$returnDate,$details,$status,$currencyID,$globalDiscountPercentage,$returnType);
        $stmt->execute();
        $stmt->close();
        
        
        
             $deleteID = getNextKey("Deletes", "delete_id");
         $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$returnID AND table_name='Returns'";
        
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}



// Tender_Item--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Tender_Item as $s) {


    $tenderItemID= $s['tender_item_id'];
    $tender_id= $s['tender_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Tender_Item WHERE tender_item_id='$tenderItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($tenderID,'Tenders'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $qty= $s['qty'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $pricetypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];
        if(isset($s['description']))
        {
            $description= $s['description'];
        }
        else
        {
            $description="";		}

        $promotionID= $s['promotion_id'];
        $promotionNumber= $s['promotion_number'];
        $masterItem= $s['master_item'];



        $stmt = $db->prepare("REPLACE INTO Tender_Item (tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,promotion_id,promotion_number,master_item,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiddddddiisiis',$tenderItemID,$tender_id,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description,$promotionID,$promotionNumber,$masterItem);
        $stmt->execute();
        $stmt->close();
    }

}

// Tenders----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Tenders as $s) {


    $tenderID= $s['tender_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Tenders WHERE tender_id='$tenderID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($tenderID,'Tenders'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {

        $tenderCode= $s['tender_code'];
        $companyID=$s['company_id'];
        $salespersonID= $s['salesperson_id'];
        $customerID= $s['customer_id'];

        if($s['tender_date']!="null" && isset($s['tender_date']) )
        {
            $dateTime = new DateTime($s['tender_date']);
            $tenderDate= date_format($dateTime, 'Y-m-d' );
        }



        $validUntil=$s['valid_until'];

        $name= $s['name'];
        $addressLine1= $s['address_line_1'];
        $addressLine2= $s['address_line_2'];
        $city= $s['city'];
        $country= $s['country'];
        $region= $s['region'];
        $subtotal= $s['subtotal'];
        $grandTotal= $s['grand_total'];
        $vatAmount= $s['vat_amount'];
        $discountAmount= $s['discount_amount'];
        $status= $s['status'];
        $vatIE= $s['vat_i_e'];
        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details="";
        }
        $printCount= $s['print_count'];
        $details= $s['details'];
        $currencyID= $s['currency_id'];
        $deliveryMethod= $s['delivery_method'];
        $globalDiscountPercentage= $s['global_discount_percentage'];

        $stmt = $db->prepare("REPLACE INTO Tenders (tender_id,tender_code,company_id,salesperson_id,customer_id,tender_date,valid_until,name,address_line_1,address_line_2,city,country,region,subtotal,grand_total,vat_amount,discount_amount,status,vat_i_e,print_count,details,currency_id,delivery_method,global_discount_percentage,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiissssssssddddssisisd',$tenderID,$tenderCode,$companyID,$salespersonID,$customerID,$tenderDate,$validUntil,$name,$addressLine1,$addressLine2,$city,$country,$region,$subtotal,$grandTotal,$vatAmount,$discountAmount,$status,$vatIE,$printCount,$details,$currencyID,$deliveryMethod,$globalDiscountPercentage);
        $stmt->execute();
        $stmt->close();
        
     
        
             $deleteID = getNextKey("Deletes", "delete_id");
         $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$tenderID AND table_name='Tenders'";
        
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}

// Waybill_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Waybill_Item as $s) {


    $waybillItemID= $s['waybill_item_id'];
    $waybillID= $s['waybill_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Waybill_Item WHERE waybill_item_id='$waybillItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($waybillID,'Waybills'))
    {
        $executeCommand = false;
    }
    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $batchNumber= $s['batch_number'];
        $warehouseID= $s['warehouse_id'];
        $qty= $s['qty'];
        $qtyInvoiced= $s['qty_invoiced'];
        $unitPrice= $s['unit_price'];
        $lineDiscount= $s['line_discount'];
        $globalDiscount= $s['global_discount'];
        $lineDiscountPercentage= $s['line_discount_percentage'];
        $vatAmount= $s['vat_amount'];
        $priceTypeID= $s['pricetype_id'];
        $vatID= $s['vat_id'];
        $serialnumber= $s['serialnumber'];
        if(isset($s['description']))
        {

            $description= $s['description'];
        }
        else
        {

            $description= "";
        }
        $cost= $s['cost'];
        $stmt = $db->prepare("REPLACE INTO Waybill_Item (waybill_item_id,waybill_id,item_id,batch_number,warehouse_id,qty,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,serialnumber,description,cost,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisidddddddiissd',$waybillItemID,$waybillID,$itemID,$batchNumber,$warehouseID,$qty,$qtyInvoiced,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$priceTypeID,$vatID,$serialnumber,$description,$cost);
        $stmt->execute();
        $stmt->close();
    }

}

// Waybills-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Waybills as $s) {


    $waybillID= $s['waybill_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Waybills WHERE waybill_id='$waybillID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($waybillID,'Waybills'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {

        $waybillCode= $s['waybill_code'];
        $companyID=$s['company_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $paymentTypeID= $s['paymenttype_id'];
        $orderID= $s['order_id'];
        $tenderID= $s['tender_id'];
        $subtotal= $s['subtotal'];
        $grandTotal= $s['grand_total'];
        $vatAmount= $s['vat_amount'];
        $vatIorE= $s['vat_i_e'];
        $discountAmount= $s['discount_amount'];
        $waybillAddressID= $s['waybill_address_id'];
        $deliveryAdressID= $s['delivery_address_id'];
        $printCount= $s['print_count'];
        if($s['waybill_date']!="null" && isset($s['waybill_date']) )
        {
            $dateTime = new DateTime($s['waybill_date']);
            $waybillDATE= date_format($dateTime, 'Y-m-d' );
        }
        else
        {
            $waybillDATE="";
        }
        if(isset($s['details']))
        {

            $details= $s['details'];
        }
        else
        {

            $details= "";
        }
        $status= $s['status'];
        $currencyID= $s['currency_id'];
        $globalDiscountPercentage= $s['global_discount_percentage'];

        $stmt = $db->prepare("REPLACE INTO Waybills (waybill_id,waybill_code,company_id,customer_id,salesperson_id,paymenttype_id,order_id,tender_id,subtotal,grand_total,vat_amount,vat_i_e,discount_amount,waybill_address_id,delivery_address_id,print_count,waybill_date,details,status,currency_id,global_discount_percentage,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiiidddsdiiisssid',$waybillID,$waybillCode,$companyID,$customerID,$salespersonID,$paymentTypeID,$orderID,$tenderID,$subtotal,$grandTotal,$vatAmount,$vatIorE,$discountAmount,$waybillAddressID,$deliveryAdressID,$printCount,$waybillDATE,$details,$status,$currencyID,$globalDiscountPercentage);
        $stmt->execute();
        $stmt->close();
        
         
           $deleteID = getNextKey("Deletes", "delete_id");
        
         $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$waybillID AND table_name='Waybills'";
        
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}

//Warehouse_Transactions-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouse_Transactions as $s) {


    $warehouseTransactionID= $s['warehouse_transaction_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Warehouse_Transactions WHERE warehouse_transaction_id='$warehouseTransactionID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($warehouseTransactionID,'Warehouse_Transactions'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {
        $warehouseTransactionCode= $s['warehouse_transaction_code'];
        $warehouseFrom= $s['warehouse_id_from'];
        $warehouseTo= $s['warehouse_id_to'];
        $companyID=$s['company_id'];
        $salespersonID= $s['salesperson_id'];
        $type= $s['type'];
        if($s['transaction_date']!="null" && isset($s['transaction_date']) )
        {
            $dateTime = new DateTime($s['transaction_date']);
            $transactionDate= date_format($dateTime, 'Y-m-d' );
        }
        else
        {
            $transactionDate="";
        }
        $details= $s['details'];



        $stmt = $db->prepare("REPLACE INTO Warehouse_Transactions (warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiisss',$warehouseTransactionID,$warehouseTransactionCode,$warehouseFrom,$warehouseTo,$companyID,$salespersonID,$type,$transactionDate,$details);
        $stmt->execute();
        $stmt->close();

        $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$warehouseTransactionID AND table_name='Warehouse_Transactions'";

        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();

    }

}


// Warehouse_Transaction_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouse_Transaction_Item as $s) {


    $warehouseTransactionItemID= $s['warehouse_transaction_item_id'];
    $warehouseTransactionID= $s['warehouse_transaction_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Warehouse_Transaction_Item WHERE warehouse_transaction_item_id='$warehouseTransactionItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();
    if(docIsLocked($warehouseTransactionID,'Warehouse_Transactions'))
    {
         $executeCommand = false;
    }
    if($executeCommand)
    {


        $itemID=$s['item_id'];
        $batchNumber= $s['batch_number'];
        $warehouseID= $s['warehouse_id'];
        $qty= $s['qty'];
        $serialnumber= $s['serialnumber'];
        $itemCondition= $s['item_condition'];
        $notes= $s['notes'];


        $stmt = $db->prepare("REPLACE INTO Warehouse_Transaction_Item (warehouse_transaction_item_id,warehouse_transaction_id,item_id,batch_number,warehouse_id,qty,serialnumber,item_condition,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisidsss',$warehouseTransactionItemID,$warehouseTransactionID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$itemCondition,$notes);
        $stmt->execute();
        $stmt->close();
    }

}

//Item_Images-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Item_Images as $s) {


    $imageID= $s['item_image_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Item_Images WHERE item_image_id='$imageID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $itemID=$s['item_id'];
        $imageUrl=$s['image_url'];
        $imageName=$s['image_name'];
        $imageOrder=$s['image_order'];



        $stmt = $db->prepare("REPLACE INTO Item_Images (item_image_id,item_id,image_url,image_name,image_order,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iisss',$imageID,$itemID,$imageUrl,$imageName,$imageOrder);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("UPDATE Items SET thumbnail_url=? WHERE item_id=?");
        $stmt->bind_param('si',$imageName,$itemID);
        $stmt->execute();
        $stmt->close();
    }

}



//Tender_Order-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Tender_Order as $s) {


    $tenderID= $s['tender_id'];
    $orderID= $s['order_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Tender_Order WHERE tender_id='$tenderID' AND order_id ='$orderID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Tender_Order (tender_id,order_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$tenderID,$orderID);
        $stmt->execute();
        $stmt->close();
    }

}

//Tender_Waybill-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Tender_Waybill as $s) {


    $tenderID= $s['tender_id'];
    $waybillID= $s['waybill_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Tender_Waybill WHERE tender_id='$tenderID' AND waybill_id ='$waybillID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Tender_Waybill (tender_id,waybill_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$tenderID,$waybillID);
        $stmt->execute();
        $stmt->close();
    }

}

//Tender_Invoice-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Tender_Invoice as $s) {


    $tenderID= $s['tender_id'];
    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Tender_Invoice WHERE tender_id='$tenderID' AND invoice_id ='$invoiceID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Tender_Invoice (tender_id,invoice_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$tenderID,$invoiceID);
        $stmt->execute();
        $stmt->close();
    }

}

//Order_Waybill-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Order_Waybill as $s) {


    $orderID= $s['order_id'];
    $waybillID= $s['waybill_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Order_Waybill WHERE order_id='$orderID' AND waybill_id ='$waybillID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Order_Waybill (order_id,waybill_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$orderID,$waybillID);
        $stmt->execute();
        $stmt->close();
    }

}

//Order_Invoice-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Order_Invoice as $s) {


    $orderID= $s['order_id'];
    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Order_Invoice WHERE order_id='$orderID' AND invoice_id ='$invoiceID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Order_Invoice (order_id,invoice_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$orderID,$invoiceID);
        $stmt->execute();
        $stmt->close();
    }

}

//Waybill_Invoice-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Waybill_Invoice as $s) {


    $waybillID= $s['waybill_id'];
    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Waybill_Invoice WHERE waybill_id='$waybillID' AND invoice_id ='$invoiceID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Waybill_Invoice (waybill_id,invoice_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$waybillID,$invoiceID);
        $stmt->execute();
        $stmt->close();
    }

}

//Waybill_Return-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Waybill_Return as $s) {


    $waybillID= $s['waybill_id'];
    $returnID= $s['return_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Waybill_Return WHERE waybill_id='$waybillID' AND return_id ='$returnID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Waybill_Return (waybill_id,return_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$waybillID,$returnID);
        $stmt->execute();
        $stmt->close();
    }

}

//Invoice_Return-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Invoice_Return as $s) {


    $returnID= $s['return_id'];
    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Invoice_Return WHERE invoice_id='$invoiceID' AND return_id ='$returnID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stmt = $db->prepare("REPLACE INTO Invoice_Return (return_id,invoice_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$returnID,$invoiceID);
        $stmt->execute();
        $stmt->close();
    }

}

//Invoice_Receipt-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Invoice_Receipt as $s) {


    $receiptID= $s['receipt_id'];
    $invoiceID= $s['invoice_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Invoice_Receipt WHERE receipt_id='$receiptID' AND invoice_id ='$invoiceID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $amount= $s['amount'];
        $stmt = $db->prepare("REPLACE INTO Invoice_Receipt (receipt_id,invoice_id,amount,timestamp) VALUES(?,?,?,NOW())");
        $stmt->bind_param('iid',$receiptID,$invoiceID,$amount);
        $stmt->execute();
        $stmt->close();
    }

}




//Visits---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Visits as $s) {


    $visitID= $s['visit_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Visits WHERE visit_id='$visitID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $visitCode= $s['visit_code'];
        $customerID= $s['customer_id'];
        $companyID= $s['company_id'];
        $salespersonID= $s['salesperson_id'];
        $notes= $s['notes'];
        $visitDate= $s['visit_date'];

        $stmt = $db->prepare("REPLACE INTO Visits (visit_id,visit_code,customer_id,company_id,salesperson_id,notes,visit_date,timestamp) VALUES(?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('sssssss',$visitID,$visitCode,$customerID,$companyID,$salespersonID,$notes,$visitDate);
        $stmt->execute();
        $stmt->close();
    }

}



//Schedules---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Schedules as $s) {


    $scheduleID= $s['schedule_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Schedules WHERE schedule_id='$scheduleID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $name= $s['name'];
        $creationDate= $s['creation_date'];
        $creatorID= $s['creator_id'];
        $type= $s['type'];
        $date= $s['date'];
        $repeatPeriod= $s['repeat_period'];
        $day= $s['day'];
        $week= $s['week'];
        $month= $s['month'];
        $notes= $s['notes'];



        $stmt = $db->prepare("REPLACE INTO Schedules (schedule_id,name,creation_date,creator_id,type,date,repeat_period,day,week,month,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('ississsssss',$scheduleID,$name,$creationDate,$creatorID,$type,$date,$repeatPeriod,$day,$week,$month,$notes);
        $stmt->execute();
        $stmt->close();
    }

}

//Schedule_Customer---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Schedule_Customer as $s) {


    $scheduleCustomerID= $s['schedule_customer_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Schedule_Customer WHERE schedule_customer_id='$scheduleCustomerID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $scheduleID= $s['schedule_id'];
        $customerID= $s['customer_id'];
        $position= $s['position'];
        $appoimentTime= $s['appointment_time'];





        $stmt = $db->prepare("REPLACE INTO Schedule_Customer (schedule_customer_id,schedule_id,customer_id,position,appointment_time,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiss',$scheduleCustomerID,$scheduleID,$customerID,$position,$appoimentTime);
        $stmt->execute();
        $stmt->close();
    }

}


//Schedule_Objects---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Schedule_Objects as $s) {


    $scheduleObjectID= $s['schedule_object_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Schedule_Objects WHERE schedule_object_id='$scheduleObjectID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $scheduleID= $s['schedule_id'];
        $date= $s['date'];
        $startTime= $s['start_time'];
        $endTime= $s['end_time'];
        $salespersonID= $s['salesperson_id'];
        $status= $s['status'];

        $startKm= $s['start_km'];
        $endKm= $s['end_km'];

        $stmt = $db->prepare("REPLACE INTO Schedule_Objects (schedule_object_id,schedule_id,date,start_time,end_time,salesperson_id,status,start_km,end_km,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iisssisss',$scheduleObjectID,$scheduleID,$date,$startTime,$endTime,$salespersonID,$status,$startKm,$endKm);
        $stmt->execute();
        $stmt->close();
    }

}


//Schedule_Object_Actions---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Schedule_Object_Actions as $s) {


    $scheduleObjectActionID= $s['schedule_object_action_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Schedule_Object_Actions WHERE schedule_object_action_id='$scheduleObjectActionID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $scheduleObjectID= $s['schedule_object_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $actionType= $s['action_type'];
        $actionID= $s['action_id'];
        $date= $s['date'];
        $lat= $s['lat'];
        $lng= $s['lng'];




        $stmt = $db->prepare("REPLACE INTO Schedule_Object_Actions (schedule_object_action_id,schedule_object_id,customer_id,salesperson_id,action_type,action_id,date,lat,lng,timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiisssdd',$scheduleObjectActionID,$scheduleObjectID,$customerID,$salespersonID,$actionType,$actionID,$date,$lat,$lng);
        $stmt->execute();
        $stmt->close();
    }

}



//Schedule_Object_Customer---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Schedule_Object_Customer as $s) {


    $scheduleObjectCustomerID= $s['schedule_object_customer_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Schedule_Object_Customer WHERE schedule_object_customer_id='$scheduleObjectCustomerID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $scheduleObjectID= $s['schedule_object_id'];
        $customerID= $s['customer_id'];
        $position= $s['position'];
        $visit= $s['visit'];
        $appoimentTime= $s['appointment_time'];





        $stmt = $db->prepare("REPLACE INTO Schedule_Object_Customer (schedule_object_customer_id,schedule_object_id,customer_id,position,visit,appointment_time,timestamp) VALUES(?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisss',$scheduleObjectCustomerID,$scheduleObjectID,$customerID,$position,$visit,$appoimentTime);
        $stmt->execute();
        $stmt->close();
    }

}

//Schedule_Salesperson---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Schedule_Salesperson as $s) {


    $scheduleID= $s['schedule_id'];
    $salespersonID= $s['salesperson_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Schedule_Salesperson WHERE schedule_id='$scheduleID' AND salesperson_id= '$salespersonID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {


        $stmt = $db->prepare("REPLACE INTO Schedule_Salesperson (schedule_id,salesperson_id,timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$scheduleID,$salespersonID);
        $stmt->execute();
        $stmt->close();
    }

}


//GPS_Log---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->GPS_Log as $s) {


    $gpsLogID= $s['gps_log_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM GPS_Log WHERE gps_log_id='$gpsLogID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $salespersonID= $s['salesperson_id'];
        $deviceID= $s['device_id'];
        $scheduleObjectActionID= $s['schedule_object_action_id'];
        $lat= $s['lat'];
        $lng= $s['lng'];
        $time= $s['time'];




        $stmt = $db->prepare("REPLACE INTO GPS_Log (gps_log_id,salesperson_id,device_id,schedule_object_action_id,lat,lng,time,timestamp) VALUES(?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiidds',$gpsLogID,$salespersonID,$deviceID,$scheduleObjectActionID,$lat,$lng,$time);
        $stmt->execute();
        $stmt->close();
    }

}


//Stock_Updates---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Stock_Updates as $s) {

    $stockUpdateID =$s['stock_update_id'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT COUNT(stock_update_id) FROM Stock_Updates WHERE stock_update_id='$stockUpdateID'");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter >0)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $warehouseID= $s['warehouse_id'];
        $itemID= $s['item_id'];
        $batchnumber=$s['batch_number'];

        $available=$s['available'];
        $reserved=$s['reserved'];
        $delivered=$s['delivered'];
        $onOrder=$s['on_order'];
        $requested=$s['requested'];
        $sold=$s['sold'];
        $expiryDate=$s['expiry_date'];

        $actionType=$s['action_type'];
        $actionID=$s['action_id'];
        $actionCode=$s['action_code'];
        $reason=$s['reason'];
        $fromActionType=$s['from_action_type'];
        $fromActionID=$s['from_action_id'];
        $fromActionCode=$s['from_action_code'];
        $fromActionQty=$s['from_action_qty'];
        $fromActionField=$s['from_action_field'];


        $stmt = $db->prepare("INSERT INTO Stock (warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())
			ON DUPLICATE KEY UPDATE available=available+?,reserved=reserved+?,delivered=delivered+?,on_order=on_order+?,requested=requested+?,sold=sold+?");
        $stmt->bind_param('iisddddddsdddddd',$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate,$available,$reserved,$delivered,$onOrder,$requested,$sold);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("REPLACE INTO Stock_Updates (stock_update_id,warehouse_id,item_id,batch_number,available,reserved,delivered,on_order,requested,sold,expiry_date,action_type,action_id,action_code,reason,from_action_type,from_action_id,from_action_code,from_action_qty,from_action_field,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisddddddssssssssss',$stockUpdateID,$warehouseID,$itemID,$batchnumber,$available,$reserved,$delivered,$onOrder,$requested,$sold,$expiryDate,$actionType,$actionID,$actionCode,$reason,$fromActionType,$fromActionID,$fromActionCode,$fromActionQty,$fromActionField);
        $stmt->execute();
        $stmt->close();



    }




}

// Customer_Stock_Taking_Item-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Customer_Stock_Taking_Item as $s) {


    $stockTakingItemID= $s['customer_stock_taking_item_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Customer_Stock_Taking_Item WHERE customer_stock_taking_item_id='$stockTakingItemID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stockTakingID= $s['customer_stock_taking_id'];
        $itemID=$s['item_id'];
        $batchNumber= $s['batch_number'];
        $warehouseID= $s['warehouse_id'];
        $qty= $s['qty'];
        $serialnumber= $s['serialnumber'];
        $description= $s['description'];



        $stmt = $db->prepare("REPLACE INTO Customer_Stock_Taking_Item (customer_stock_taking_item_id,customer_stock_taking_id,item_id,batch_number,warehouse_id,qty,serialnumber,description,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisidss',$stockTakingItemID,$stockTakingID,$itemID,$batchNumber,$warehouseID,$qty,$serialnumber,$description);
        $stmt->execute();
        $stmt->close();
    }

}

// Customer_Stock_Taking-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Customer_Stock_Taking as $s) {


    $stockTakingID= $s['customer_stock_taking_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Customer_Stock_Taking WHERE customer_stock_taking_id='$stockTakingID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $stockTakingCode= $s['customer_stock_taking_code'];
        $companyID=$s['company_id'];
        $customerID= $s['customer_id'];
        $salespersonID= $s['salesperson_id'];
        $addressID= $s['address_id'];
        $printCount= $s['print_count'];
        $date= $s['date'];
        if(isset($s['details']))
        {
            $details= $s['details'];
        }
        else
        {
            $details= "";
        }
        $addOverride= $s['add_override'];

        $stmt = $db->prepare("REPLACE INTO Customer_Stock_Taking (customer_stock_taking_id,customer_stock_taking_code,company_id,customer_id,salesperson_id,address_id,print_count,date,details,add_override,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiisss',$stockTakingID,$stockTakingCode,$companyID,$customerID,$salespersonID,$addressID,$printCount,$date,$details,$addOverride);
        $stmt->execute();
        $stmt->close();
        
         $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$stockTakingID AND table_name='Customer_Stock_Taking'";
        $stmt = $db->prepare("INSERT INTO Deletes (statement) VALUES(?)");
        $stmt->bind_param('s',$dstatement);
        $stmt->execute();
        $stmt->close();
    }

}

//Customer_Updates---------------------------------------------------------------------------------------------------------------------------

foreach($xmlData->Customer_Updates as $s) {

    $customerUpdateID =$s['customer_update_id'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT COUNT(id) FROM Customer_Updates WHERE id='$customerUpdateID'");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter >0)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $customerID= $s['customer_id'];
        $amount= $s['amount'];
        $stmt = $db->prepare("UPDATE Customers SET balance = balance+? WHERE customer_id=?");
        $stmt->bind_param('ds',$amount,$customerID);
        $stmt->execute();
        $stmt->close();

        $stmt = $db->prepare("INSERT INTO Customer_Updates(id,customer_id,amount,timestamp) VALUES(?,?,?,NOW())");
        $stmt->bind_param('iid',$customerUpdateID,$customerID,$amount);
        $stmt->execute();
        $stmt->close();



    }




}

// CRM_Posts-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->CRM_Posts as $s) {


    $postID= $s['post_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM CRM_Posts WHERE post_id='$postID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $customerID= $s['customer_id'];
        $salespersonID=$s['salesperson_id'];
        $crmTypeID= $s['crm_type_id'];
        $postDate= $s['post_date'];
        $postText= $s['post_text'];
        $editable= $s['editable'];
        $lastEditTime= $s['last_edit_time'];
 $value= $s['value'];
$status= $s['status'];

        $stmt = $db->prepare("REPLACE INTO CRM_Posts (post_id,customer_id,salesperson_id,crm_type_id,post_date,post_text,editable,last_edit_time,value,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiissssss',$postID,$customerID,$salespersonID,$crmTypeID,$postDate,$postText,$editable,$lastEditTime,$value,$status);
        $stmt->execute();
        $stmt->close();
    }

}


// CRM_Post_Attachments-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->CRM_Post_Attachments as $s) {


    $postAttachmentID= $s['post_attachment_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM CRM_Post_Attachments WHERE post_attachment_id='$postAttachmentID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $postID= $s['post_id'];        
        $type= $s['type'];
        $url= $s['url'];
        



        $stmt = $db->prepare("REPLACE INTO CRM_Post_Attachments (post_attachment_id,post_id,type,url,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('iiss',$postAttachmentID,$postID,$type,$url);
        $stmt->execute();
        $stmt->close();
    }

}
// Service_Calls-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Service_Call as $s) {

    $serviceCallID= $s['service_call_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Service_Call WHERE service_call_id='$serviceCallID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if(docIsLocked($serviceCallID,'Service_Call'))
    {
        $executeCommand = false;
    }

    if($executeCommand)
    {
        $serviceCallID= $s['service_call_id'];
        $serviceCallCode= $s['service_call_code'];
        $salespersonID= $s['salesperson_id'];
        $assignTo= $s['assign_to'];
        $customerID= $s['customer_id'];
        $customerAddressID= $s['customer_address_id'];
        $itemID= $s['item_id'];
        $serialNumberID= $s['serial_number_id'];
        $sourceID= $s['source_id'];
        $typeID= $s['type_id'];
        $statusID= $s['status_id'];
        $scPriorityID= $s['priority_id'];
        $topic= $s['topic'];
        $details= $s['details'];
        $sourceName= $s['source_name'];
        $sourceDetails= $s['source_details'];
        $date= $s['date'];
        $dueDate= $s['due_date'];
        $scheduleStartDate= $s['schedule_start_date'];
        $scheduleEndDate= $s['schedule_end_date'];
        $parentID= $s['parent_id'];
        $progress= $s['progress'];
        $assignTo2= $s['assign_to_2'];

        if(strcmp($parentID,'')==0){$parentID=0;}
        if(strcmp($progress,'')==0){$progress=0;}
        if(strcmp($assignTo2,'')==0){$assignTo2=0;}

        $stmt = $db->prepare("REPLACE INTO Service_Call (service_call_id, service_call_code, salesperson_id, assign_to, customer_id, customer_address_id, item_id, serial_number_id, source_id, type_id, status_id, priority_id, topic, details, source_name, source_details, date, due_date, schedule_start_date, schedule_end_date, parent_id, progress, assign_to_2, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiiiiiiissssssssiii',$serviceCallID,$serviceCallCode,$salespersonID,$assignTo,$customerID,$customerAddressID,$itemID,$serialNumberID,$sourceID,$typeID,$statusID,$scPriorityID,$topic,$details,$sourceName,$sourceDetails,$date,$dueDate,$scheduleStartDate,$scheduleEndDate,$parentID,$progress,$assignTo2);
        $stmt->execute();

        $stmt->close();

        $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$serviceCallID AND table_name='Service_Call'";

        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();
    }
}

// SC_Referred_To-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SC_Referred_To as $s) {

    $serviceCallID= $s['service_call_id'];
    $salespersonID= $s['salesperson_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM SC_Referred_To WHERE service_call_id='$serviceCallID' AND salesperson_id='$salespersonID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $serviceCallID= $s['service_call_id'];
        $salespersonID= $s['salesperson_id'];
        $addedTime= $s['added_time'];
        $addedByID= $s['added_by_id'];


        $stmt = $db->prepare("REPLACE INTO SC_Referred_To (service_call_id, salesperson_id, added_time, added_by_id, timestamp) VALUES (?,?,?,?,NOW())");
        $stmt->bind_param('iisi',$serviceCallID,$salespersonID,$addedTime,$addedByID);
        $stmt->execute();
        $stmt->close();
    }
}


// Service_Call_Reply-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Service_Call_Reply as $s) {

    $serviceCallReplyID= $s['service_call_reply_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Service_Call_Reply WHERE service_call_reply_id='$serviceCallReplyID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $serviceCallID= $s['service_call_id'];        
        $salesPersonID= $s['salesperson_id'];
        $statusID= $s['status_id'];
        
        $date= $s['date'];
        $replyTypeID= $s['reply_type_id'];
        $details= $s['details'];
        $documentID= $s['document_id'];
        $documentType= $s['document_type'];
        $salesPersonTo= $s['salesperson_to'];
        $emailResponse= $s['email_response'];
        $priorityID= $s['priority_id'];

        $stmt = $db->prepare("REPLACE INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiisisisisi',$serviceCallReplyID,$serviceCallID,$salesPersonID,$statusID,$date,$replyTypeID,$details,$documentID,$documentType,$salesPersonTo,$emailResponse,$priorityID);
        $stmt->execute();
        $stmt->close();
        
        if($replyTypeID==4 && strcmp($statusID,'')!=0 && $statusID > 0)
        {
             $stmt = $db->prepare("UPDATE Service_Call SET status_id=? WHERE service_call_id=?");
        $stmt->bind_param('ii',$statusID,$serviceCallID);
        $stmt->execute();
        $stmt->close();
        }
        
         else if($replyTypeID==7)
        {
             $stmt = $db->prepare("UPDATE Service_Call SET priority_id=? WHERE service_call_id=?");
        $stmt->bind_param('ii',$priorityID,$serviceCallID);
        $stmt->execute();
        $stmt->close();
        }
         else if($replyTypeID==5)
        {
             $stmt = $db->prepare("UPDATE Service_Call SET assign_to=? WHERE service_call_id=?");
        $stmt->bind_param('ii',$salesPersonTo,$serviceCallID);
        $stmt->execute();
        $stmt->close();
        }
    }
}

// Service_Call_Reply_Attachments-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Service_Call_Reply_Attachments as $s) {

    $serviceCallAttachmentID= $s['sc_attachment_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Service_Call_Reply_Attachments WHERE sc_attachment_id='$serviceCallAttachmentID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $serviceCallReplyID= $s['service_call_reply_id'];        
        $attachmentName= $s['attachment_name'];
        $attachmentUrl= $s['attachment_url'];
        $attachmentOrder= $s['attachment_order'];

        $stmt = $db->prepare("REPLACE INTO Service_Call_Reply_Attachments (sc_attachment_id,service_call_reply_id,attachment_name,attachment_url,attachment_order,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iissi',$serviceCallAttachmentID,$serviceCallReplyID,$attachmentName,$attachmentUrl,$attachmentOrder);
        $stmt->execute();
        $stmt->close();
    }
}

// Service_Call_Hierarchy-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Service_Call_Hierarchy as $s) {

    $parentID= $s['parent_id'];
    $childID = $s['child_id'];
    $linkType = $s['link_type'];
    $linkDate = $s['link_date'];
    $active = $s['active'];
    $details = $s['details'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Service_Call_Hierarchy WHERE parent_id='$parentID' AND child_id='$childID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO Service_Call_Hierarchy (parent_id, child_id, link_type, link_date, active, details, timestamp) VALUES(?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iissss',$parentID,$childID,$linkType,$linkDate,$active,$details);
        $stmt->execute();
        $stmt->close();
    }
}


//  ZA_Custom_Form_Object-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->ZA_Custom_Form_Object as $s) {


    $customFormObjectID= $s['custom_form_object_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM ZA_Custom_Form_Object WHERE custom_form_object_id='$customFormObjectID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $customFormID= $s['custom_form_id'];        
        $customFormCode= $s['custom_form_code'];
        $linkedTableID= $s['linked_table_id'];
        $salespersonID= $s['salesperson_id'];
       



        $stmt = $db->prepare("REPLACE INTO ZA_Custom_Form_Object (custom_form_object_id,custom_form_id,custom_form_code,linked_table_id,salesperson_id,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iisii',$customFormObjectID,$customFormID,$customFormCode,$linkedTableID,$salespersonID);
        $stmt->execute();
        $stmt->close();
    }

}




// ZA_Custom_Field_Object-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->ZA_Custom_Field_Object as $s) {


    $customFiledObjectID= $s['custom_field_object_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM ZA_Custom_Field_Object WHERE custom_field_object_id='$customFiledObjectID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $customFieldID= $s['custom_field_id'];        
        $customFormObjectID= $s['custom_form_object_id'];
        $value= $s['value'];
        
       



        $stmt = $db->prepare("REPLACE INTO ZA_Custom_Field_Object (custom_field_object_id,custom_field_id,custom_form_object_id,value,timestamp) VALUES(?,?,?,?,NOW())");
        $stmt->bind_param('iiis',$customFiledObjectID,$customFieldID,$customFormObjectID,$value);
        $stmt->execute();
        $stmt->close();
    }

}


// SC_Filters-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SC_Filters as $s) {


    $filterID= $s['filter_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM SC_Filters WHERE filter_id='$filterID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        $filterName= $s['filter_name'];        
        $position= $s['position'];
        $salespersonID= $s['salesperson_id'];
        $whereClause= $s['where_clause'];
        $active= $s['active'];
        $defeultFilter= $s['default_filter'];
        $isCalendar= $s['is_calendar'];
        $createDateFrom= $s['create_date_from'];
        $createDateTo= $s['create_date_to'];
        $scheduleDateFrom= $s['schedule_date_from'];
        $scheduleDateTo= $s['schedule_date_to'];


        $stmt = $db->prepare("REPLACE INTO SC_Filters (filter_id, filter_name, position, salesperson_id, create_date_from, create_date_to, schedule_date_from, schedule_date_to, where_clause, active, default_filter, is_calendar, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiissssssss',$filterID,$filterName,$position,$salespersonID,$createDateFrom,$createDateTo,$scheduleDateFrom,$scheduleDateTo,$whereClause,$active,$defeultFilter,$isCalendar);
        $stmt->execute();
        $stmt->close();
    }

}

// SC_Filter_Salesperson-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SC_Filter_Salesperson as $s) {
    $filterID= $s['filter_id'];
    $salespersonID= $s['salesperson_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM SC_Filter_Salesperson WHERE filter_id='$filterID' AND salesperson_id='$salespersonID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO SC_Filter_Salesperson (filter_id, salesperson_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$filterID,$salespersonID);
        $stmt->execute();
        $stmt->close();
    }
}

// SC_Filter_Priority-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SC_Filter_Priority as $s) {
    $filterID= $s['filter_id'];
    $priorityID= $s['priority_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM SC_Filter_Priority WHERE filter_id='$filterID' AND priority_id='$priorityID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO SC_Filter_Priority (filter_id, priority_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$filterID,$priorityID);
        $stmt->execute();
        $stmt->close();
    }
}

// SC_Filter_Status-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SC_Filter_Status as $s) {
    $filterID= $s['filter_id'];
    $statusID= $s['status_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM SC_Filter_Status WHERE filter_id='$filterID' AND status_id='$statusID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO SC_Filter_Status (filter_id, status_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$filterID,$statusID);
        $stmt->execute();
        $stmt->close();
    }
}

// SC_Filter_Type-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SC_Filter_Type as $s) {
    $filterID= $s['filter_id'];
    $typeID= $s['type_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM SC_Filter_Type WHERE filter_id='$filterID' AND type_id='$typeID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stmt = $db->prepare("REPLACE INTO SC_Filter_Type (filter_id, type_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$filterID,$typeID);
        $stmt->execute();
        $stmt->close();
    }
}


// SalesPersons-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->SalesPersons as $s) {


    $salespersonID= $s['salesperson_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM SalesPersons WHERE salesperson_id='$salespersonID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $warehouseID= $s['default_warehouse_id'];
        $salespersonUserName= $s['username'];
        $salespersonPassword= $s['password'];

        $stmt = $db->prepare("UPDATE SalesPersons SET default_warehouse_id=?, username=?, password=? WHERE salesperson_id=?");
        $stmt->bind_param('issi',$warehouseID,$salespersonUserName,$salespersonPassword,$salespersonID);
        $stmt->execute();
        $stmt->close();
    }

}

//Cancelled_Actions  --------------------------------------


foreach($xmlData->Cancelled_Actions as $s) { 
	

       $cancelledID= $s['cancelled_id'];	 
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
             
       $stm = $db->prepare("SELECT timestamp FROM Cancelled_Actions  WHERE cancelled_id='$cancelledID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    			         $type= $s['type'];
                         $code= $s['code'];
	                     $customerID= $s['customer_id'];
                         $salespersonID= $s['salesperson_id'];
                         $timestamp= $s['timestamp'];
                      
						 
    	        
         $stmt = $db->prepare("REPLACE INTO Cancelled_Actions  (cancelled_id,type,code,customer_id,salesperson_id,timestamp) VALUES(?,?,?,?,?,NOW())");
 		$stmt->bind_param('issii',$cancelledID,$type,$code,$customerID,$salespersonID);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
}

//Transactions-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Transactions as $s) {


    $transactionID = $s['transaction_id']; 
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Transactions WHERE transaction_id='$transactionID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    //----------
    $accountID=$s['account_id'];
    $actionCode=$s['action_code'];
    $transactionCode=$s['transaction_code'];
    $sign=$s['sign'];
    $stm = $db->prepare("SELECT transaction_id  FROM Transactions WHERE sign='$sign' AND action_code='$actionCode' AND transaction_code='$transactionCode' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($transactionIDDB);
    while ($stm->fetch()) {
        if($transactionIDDB != $transactionID)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $stm = $db->prepare("SELECT cancelled_id FROM Cancelled_Actions WHERE code='$actionCode' LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($canceledActionID);
        while ($stm->fetch()) {
            if($canceledActionID > 0)
            {
                $executeCommand = false;
            }
        }
        $stm-> close();
    }
    //---------
    if($executeCommand)
    {

        $transactionCode=$s['transaction_code'];
        $journalID=$s['journal_id'];
		$companyID=$s['company_id'];
		$accountID=$s['account_id'];
		$transactionTypeID=$s['transaction_type_id'];
		$year=$s['year'];
		$periodID=$s['period_id'];
		$userID=$s['user_id'];
		$transactionDate=$s['transaction_date'];
		$entryDate=$s['entry_date'];
		$actionCode=$s['action_code'];
		$sign=$s['sign'];
		$amount=$s['amount'];
		$outstandingAmount=$s['outstanding_amount'];
		$vatAmount=$s['vat_amount'];
		$vatIo=$s['vat_i_o'];
		$datails=$s['details'];

        $stmt = $db->prepare("REPLACE INTO Transactions (transaction_id,transaction_code,journal_id,company_id,account_id,transaction_type_id,year,period_id,user_id,transaction_date,entry_date,action_code,sign,amount,outstanding_amount,vat_amount,vat_i_o,details,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiiiiisssidddss',$transactionID,$transactionCode,$journalID,$companyID,$accountID,$transactionTypeID,$year,$periodID,$userID,$transactionDate,$entryDate,$actionCode,$sign,$amount,$outstandingAmount,$vatAmount,$vatIo,$datails);
        $stmt->execute();
        $stmt->close();
    }

}
//ZE_Z_Report
foreach($xmlData->ZE_Z_Report as $s) {


    $lockID = $s['lock_id']; 
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM ZE_Z_Report WHERE lock_id='$lockID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $documentID=$s['document_id'];
        $documentType=$s['document_type'];
		$lockNumber=$s['lock_number'];
    	$zDate=$s['z_date'];
    	$startZ=$s['start_z_time'];
    	$salespersonID=$s['salesperson_id'];
    	$subTotal=$s['subtotal'];
    	$discountAmount=$s['discount_amount'];
    	$vatAmount=$s['vat_amount'];
    	$grandTotal=$s['grand_total'];
    	
    	
    	
    	
    	
	
        $stmt = $db->prepare("REPLACE INTO ZE_Z_Report (lock_id,document_id,document_type,lock_number,z_date,start_z_time,salesperson_id,subtotal,discount_amount,vat_amount,grand_total,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iissssidddd',$lockID,$documentID,$documentType,$lockNumber,$zDate,$startZ,$salespersonID,$subTotal,$discountAmount,$vatAmount,$grandTotal);
        $stmt->execute();
        $stmt->close();

        $deleteID = getNextKey("Deletes", "delete_id");
        $dstatement="DELETE FROM Unsent_Records WHERE table_row_id=$lockID AND table_name='ZE_Z_Report'";

        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is',$deleteID,$dstatement);
        $stmt->execute();
        $stmt->close();

    }

}







//ChartOfAccounts  --------------------------------------


foreach($xmlData->ChartOfAccounts as $s) { 
	

       $accountID= $s['account_id'];	 
       $timestampApp = $s['timestamp'];
       $executeCommand = true;
       
             
       $stm = $db->prepare("SELECT timestamp FROM ChartOfAccounts  WHERE account_id='$accountID'");
	$stm-> execute();
	$stm-> bind_result($timestampDB);
	while ($stm->fetch()) {
		if($timestampDB >=$timestampApp)
		{
		
			$executeCommand = false;
		}
	}
	$stm-> close();
    
    	if($executeCommand)
    	{
    			         $accountCode= $s['account_code'];
                         $accountName= $s['account_name'];
	                     $typeID= $s['type_id'];
                         $localCurrencyID= $s['local_currency_id'];
                         $timestamp= $s['timestamp'];
                      
						 
    	        
         $stmt = $db->prepare("REPLACE INTO ChartOfAccounts  (account_id,account_code,account_name,type_id,local_currency_id,timestamp) VALUES(?,?,?,?,?,NOW())");
 		$stmt->bind_param('issii',$accountID,$accountCode,$accountName,$typeID,$localCurrencyID);
 		$stmt->execute(); 		
 		$stmt->close();    	
    	}
   
}

// Serial_Number_Location-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Serial_Number_Location as $s) {


    $serialNumberID = $s['serial_number_id'];
    $customerID = $s['customer_id'];
    $contractID = $s['contract_id'];
    $serviceCallID = $s['service_call_id'];
    $lat = $s['lat'];
    $lng = $s['lng'];
    $locationDate = $s['location_date'];
    $type = $s['type'];
    $reason = $s['reason'];
    $notes = $s['notes'];
    $salespersonID = $s['salesperson_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Serial_Number_Location WHERE serial_number_id='$serialNumberID' AND customer_id='$customerID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        if(isset($s['reason'])&&$s['reason']!="null")
        {
            $reason= $s['reason'];
        }
        else
        {
            $reason= "";
        }

        if(isset($s['type'])&&$s['type']!="null")
        {
            $type= $s['type'];
        }
        else
        {
            $type= "";
        }

        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= "";
        }




        $stmt = $db->prepare("REPLACE INTO Serial_Number_Location (serial_number_id,customer_id,contract_id,service_call_id,lat,lng,location_date,type,reason,notes,salesperson_id,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiiddssssi',$serialNumberID,$customerID,$contractID,$serviceCallID,$lat,$lng,$locationDate,$type,$reason,$notes,$salespersonID);
        $stmt->execute();
        $stmt->close();


    }

}

// Contracts-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Contracts as $s) {


    $contractID = $s['contract_id'];
    $customerID = $s['customer_id'];
    $customerAddressID = $s['customer_address_id'];
    $itemID = $s['item_id'];
    $serialNumberID = $s['serial_number_id'];
    $salesPersonID = $s['salesperson_id'];
    $contractTypeID = $s['contract_type_id'];
    $transactionLogID = $s['serial_number_transaction_log_id'];
    $startDate = $s['start_date'];
    $endDate = $s['end_date'];
    $price = $s['price'];
    $dueDate = $s['due_date'];
    $valid = $s['valid'];
    $paymentTypeID = $s['payment_type_id'];
    $paymentDate = $s['payment_date'];
    $wayOfPaymentID = $s['way_of_payment_id'];
    $technicianID = $s['technician_id'];
    $attachmentID = $s['attachment_id'];
    $notes = $s['notes'];
    $troubleshootingID = $s['troubleshooting_id'];
    $dateOfPurchase = $s['date_of_purchase'];
    $price2 = $s['price2'];
    $price3 = $s['price3'];
    $total1 = $s['total1'];
    $total2 = $s['total2'];


    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Contracts WHERE contract_id='$contractID' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= "";
        }




        $stmt = $db->prepare("REPLACE INTO Contracts(contract_id, customer_id, customer_address_id, item_id, serial_number_id, salesperson_id, contract_type_id, serial_number_transaction_log_id, start_date, end_date, price, due_date, valid, payment_type_id, payment_date, way_of_payment_id, technician_id, attachment_id, notes, troubleshooting_id, date_of_purchase, price2, price3, total1, total2, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiiiiiissdssisiiisisdddd',$contractID,$customerID,$customerAddressID,$itemID,$serialNumberID,$salesPersonID,$contractTypeID,$transactionLogID,$startDate,$endDate,$price,$dueDate,$valid,$paymentTypeID,$paymentDate,$wayOfPaymentID,$technicianID,$attachmentID,$notes,$troubleshootingID,$dateOfPurchase,$price2,$price3,$total1,$total2);
        $stmt->execute();
        $stmt->close();


    }

}

// Contracts_Attachments-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Contracts_Attachments as $s) {


    $contractAttachmentID = $s['contract_attachment_id'];
    $contractID = $s['contract_id'];
    $type = $s['type'];
    $url = $s['url'];
    $attachmentOrder = $s['attachment_order'];

    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Contracts_Attachments WHERE contract_attachment_id='$contractAttachmentID' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['attachment_order'])&&$s['attachment_order']!="null")
        {
            $attachmentOrder= $s['attachment_order'];
        }
        else
        {
            $attachmentOrder= 0;
        }




        $stmt = $db->prepare("REPLACE INTO Contracts_Attachments(contract_attachment_id, contract_id, type, url, attachment_order,  timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('iissi',$contractAttachmentID,$contractID,$type,$url,$attachmentOrder);
        $stmt->execute();
        $stmt->close();


    }

}

// Serial_Numbers-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Serial_Numbers as $s) {


    $serialNumberID = $s['serial_number_id'];
    $serialNumber = $s['serial_number'];
    $itemID = $s['item_id'];
    $desription_1 = $s['desription_1'];
    $desription_2 = $s['desription_2'];
    $details_1 = $s['details_1'];
    $details_2 = $s['details_2'];
    $notes = $s['notes'];
    $status = $s['status'];

    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Serial_Numbers WHERE serial_number_id='$serialNumberID' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['serial_number'])&&$s['serial_number']!="null")
        {
            $serialNumber= $s['serial_number'];
        }
        else
        {
            $serialNumber= '';
        }
        if(isset($s['desription_1'])&&$s['desription_1']!="null")
        {
            $desription_1= $s['desription_1'];
        }
        else
        {
            $desription_1= '';
        }
        if(isset($s['desription_2'])&&$s['desription_2']!="null")
        {
            $desription_2= $s['desription_2'];
        }
        else
        {
            $desription_2= '';
        }
        if(isset($s['details_1'])&&$s['details_1']!="null")
        {
            $details_1= $s['details_1'];
        }
        else
        {
            $details_1= '';
        }
        if(isset($s['details_2'])&&$s['details_2']!="null")
        {
            $details_2= $s['details_2'];
        }
        else
        {
            $details_2= '';
        }
        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= '';
        }
        if(isset($s['status'])&&$s['status']!="null")
        {
            $status= $s['status'];
        }
        else
        {
            $status= '';
        }




        $stmt = $db->prepare("REPLACE INTO Serial_Numbers(serial_number_id, serial_number, item_id, desription_1, desription_2, details_1, details_2, notes, status, timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isissssss',$serialNumberID,$serialNumber,$itemID,$desription_1,$desription_2,$details_1,$details_2,$notes,$status);
        $stmt->execute();
        $stmt->close();


    }

}

// Serial_Number_Transaction_Log-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Serial_Number_Transaction_Log as $s) {


    $serial_number_transaction_log_id = $s['serial_number_transaction_log_id'];
    $serial_number_id = $s['serial_number_id'];
    $customer_id= $s['customer_id'];
    $customer_address_id = $s['customer_address_id'];
    $warehouse_id = $s['warehouse_id'];
    $entry_date = $s['entry_date'];
    $start_date = $s['start_date'];
    $end_date = $s['end_date'];
    $action_id = $s['action_id'];
    $action_type = $s['action_type'];
    $description = $s['description'];
    $notes = $s['notes'];
    $serial_number_transaction_type_id = $s['serial_number_transaction_type_id'];
    $status = $s['status'];

    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Serial_Number_Transaction_Log WHERE serial_number_transaction_log_id='$serial_number_transaction_log_id' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['description'])&&$s['description']!="null")
        {
            $description= $s['description'];
        }
        else
        {
            $description= '';
        }
        if(isset($s['action_type'])&&$s['action_type']!="null")
        {
            $action_type= $s['action_type'];
        }
        else
        {
            $action_type= '';
        }
        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= '';
        }
        if(isset($s['status'])&&$s['status']!="null")
        {
            $status= $s['status'];
        }
        else
        {
            $status= '';
        }




        $stmt = $db->prepare("REPLACE INTO Serial_Number_Transaction_Log(serial_number_transaction_log_id, serial_number_id, customer_id, customer_address_id, warehouse_id, entry_date, start_date, end_date, action_id, action_type, description, notes, serial_number_transaction_type_id, status, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiiisssisssis',$serial_number_transaction_log_id, $serial_number_id, $customer_id, $customer_address_id, $warehouse_id, $entry_date, $start_date, $end_date, $action_id, $action_type, $description, $notes, $serial_number_transaction_type_id, $status);
        $stmt->execute();
        $stmt->close();


    }

}

// Customer_GDPR-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Customer_GDPR as $s) {


    $customer_gdpr_id = $s['customer_gdpr_id'];
    $customer_id = $s['customer_id'];
    $gdpr_status = $s['gdpr_status'];
    $last_action_salesperson_id = $s['last_action_salesperson_id'];
    $status_changed_date = $s['status_changed_date'];
    $reason = $s['reason'];


    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Customer_GDPR WHERE customer_gdpr_id='$customer_gdpr_id' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['gdpr_status'])&&$s['gdpr_status']!="null")
        {
            $gdpr_status= $s['gdpr_status'];
        }
        else
        {
            $gdpr_status= '';
        }
        if(isset($s['reason'])&&$s['reason']!="null")
        {
            $reason= $s['reason'];
        }
        else
        {
            $reason= '';
        }


        $stmt = $db->prepare("REPLACE INTO Customer_GDPR(customer_gdpr_id,customer_id,gdpr_status,last_action_salesperson_id,status_changed_date,reason,timestamp)VALUES(?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iisiss',$customer_gdpr_id,$customer_id,$gdpr_status,$last_action_salesperson_id,$status_changed_date,$reason);
        $stmt->execute();
        $stmt->close();


    }

}

// Allow_Categories_Customers-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Allow_Categories_Customers as $s) {


    $customer_id = $s['customer_id'];
    $category_id = $s['category_id'];
    $cycle_type = $s['cycle_type'];
    $visit_cycle_in_days = $s['visit_cycle_in_days'];
    $last_visit_date = $s['last_visit_date'];
    $last_action_date = $s['last_action_date'];
    $rating = $s['rating'];
    $target = $s['target'];
    $notes = $s['notes'];


    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Allow_Categories_Customers WHERE customer_id='$customer_id' AND category_id='$category_id' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['last_visit_date'])&&$s['last_visit_date']!="null")
        {
            $last_visit_date= $s['last_visit_date'];
        }
        else
        {
            $gdpr_status= '';
        }
        if(isset($s['last_action_date'])&&$s['last_action_date']!="null")
        {
            $last_action_date= $s['last_action_date'];
        }
        else
        {
            $last_action_date= '';
        }
        if(isset($s['cycle_type'])&&$s['cycle_type']!="null")
        {
            $cycle_type= $s['cycle_type'];
        }
        else
        {
            $cycle_type= '';
        }
        if(isset($s['rating'])&&$s['rating']!="null")
        {
            $rating= $s['rating'];
        }
        else
        {
            $rating= '';
        }
        if(isset($s['target'])&&$s['target']!="null")
        {
            $target= $s['target'];
        }
        else
        {
            $target= '';
        }
        if(isset($s['notes'])&&$s['notes']!="null")
        {
            $notes= $s['notes'];
        }
        else
        {
            $notes= '';
        }


        $stmt = $db->prepare("UPDATE Allow_Categories_Customers SET last_visit_date=?, last_action_date=?, timestamp=NOW() WHERE customer_id=? AND category_id=?");
        $stmt->bind_param('ssii', $last_visit_date, $last_action_date, $customer_id, $category_id);
        $stmt->execute();
        $stmt->close();


    }

}

// Customer_Payment_Terms-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Customer_Payment_Terms as $s) {


    $customer_id = $s['customer_id'];
    $payment_term_days = $s['payment_term_days'];
    $payment_term_text = $s['payment_term_text'];


    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Customer_Payment_Terms WHERE customer_id='$customer_id' ");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {



        if(isset($s['payment_term_text'])&&$s['payment_term_text']!="null")
        {
            $payment_term_text= $s['payment_term_text'];
        }
        else
        {
            $payment_term_text= '';
        }



        $stmt = $db->prepare("REPLACE INTO Customer_Payment_Terms(customer_id, payment_term_days, payment_term_text,timestamp)VALUES(?,?,?,NOW())");
        $stmt->bind_param('iis',$customer_id, $payment_term_days, $payment_term_text);
        $stmt->execute();
        $stmt->close();


    }

}

//Action_Attachments-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Action_Attachments as $s) {


    $actionAttachmentID= $s['action_attachment_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;


    $stm = $db->prepare("SELECT timestamp FROM Action_Attachments WHERE action_attachment_id='$actionAttachmentID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {

        $actionType= $s['action_type'];
        $actionID= $s['action_id'];
        $attachmentURL= $s['attachment_url'];
        $name= $s['name'];



        $stmt = $db->prepare("REPLACE INTO Action_Attachments (action_attachment_id, action_type, action_id, attachment_url, name,timestamp) VALUES(?,?,?,?,?,NOW())");
        $stmt->bind_param('issss',$actionAttachmentID,$actionType,$actionID,$attachmentURL,$name);
        $stmt->execute();
        $stmt->close();

    }

}

//Invoice_Suggested_Ordering-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Invoice_Suggested_Ordering as $s) {

    $suggestedOrderingID = $s['suggested_ordering_id'];
    $timestampApp = $s['timestamp'];
    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Invoice_Suggested_Ordering WHERE suggested_ordering_id='$suggestedOrderingID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand)
    {
        $itemID = $s['item_id'];
        $customerID = $s['customer_id'];
        $invoiceID = $s['invoice_id'];
        $returnID = $s['return_id'];
        $customerStockTakingID = $s['customer_stock_taking_id'];
        $date = $s['date'];
        $customerStock = $s['customer_stock'];
        $returnQty = $s['return_qty'];
        $suggestedQty = $s['suggested_qty'];
        $invoicedQty = $s['invoiced_qty'];
        $customerSales = $s['customer_sales'];
        $offer = $s['offer'];

        $stmt = $db->prepare("REPLACE INTO Invoice_Suggested_Ordering (suggested_ordering_id, item_id, customer_id, invoice_id,return_id,customer_stock_taking_id, date, customer_stock, return_qty, suggested_qty, invoiced_qty, customer_sales, offer,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiiiisddddds',$suggestedOrderingID,$itemID,$customerID,$invoiceID,$returnID,$customerStockTakingID,$date,$customerStock,$returnQty,$suggestedQty,$invoicedQty,$customerSales,$offer);
        $stmt->execute();
        $stmt->close();

    }

}

//Dynamic Custom Tables (UDT) -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
$customTables = array();
$stm = $db->prepare("SELECT custom_table_id, custom_table_name FROM ZA_Custom_Tables WHERE NOT linked_table='' AND status = 'yes' AND update_app = 'yes'");
$stm-> execute();
$stm->bind_result($customTableID, $customTableName);
while ($stm->fetch()) {
    $line = new stdClass();
    $line->id = $customTableID;
    $line->table = $customTableName;
    array_push($customTables,$line);
}
$stm-> close();

foreach($customTables as $customTable) {

    $customTableName = $customTable->table;

    foreach ($xmlData->$customTableName as $s) {

        $id = $s['id'];
        $timestampApp = $s['timestamp'];
        $executeCommand = true;

        $stm = $db->prepare("SELECT timestamp FROM $customTableName WHERE id='$id'");
        $stm-> execute();
        $stm-> bind_result($timestampDB);
        while ($stm->fetch()) {
            if($timestampDB >=$timestampApp) {
                $executeCommand = false;
            }
        }
        $stm-> close();

        if($executeCommand) {

            $customTableFields = array('id');
            $stm = $db->prepare("SELECT custom_table_field FROM ZA_Custom_Table_Fields WHERE custom_table_id='$customTable->id' ");
            $stm-> execute();
            $stm->bind_result($customTableField);
            while ($stm->fetch()) {array_push($customTableFields,$customTableField);}
            $stm-> close();
            array_push($customTableFields,'timestamp');


            $customTableFieldsValues = array();
            foreach ($customTableFields as $customTableField) {
                array_push($customTableFieldsValues,"".$s["$customTableField"]);
            }

            $stm1 = $db->prepare("REPLACE INTO ".$customTable->table." (".implode(',',$customTableFields).") VALUES (".str_repeat('?,',count($customTableFields)-1)."?)");
            $stm1->bind_param(str_repeat('s',count($customTableFields)),...$customTableFieldsValues);
            $stm1->execute();
            $stm1->close();



        }
    }
}
//Dynamic Custom Tables (UDT)/-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------

//------------------------ZE_Rebates_Transactions-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->ZE_Rebates_Transactions as $s) {
    $rebateTransactionID = $s['rebate_transaction_id'];
    $timestampApp= $s['timestamp'];

    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM ZE_Rebates_Transactions WHERE rebate_transaction_id='$rebateTransactionID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand){
        $paidValue= $s['paid_value'];
        $stmt = $db->prepare("UPDATE ZE_Rebates_Transactions SET paid_value=? WHERE rebate_transaction_id=?");
        $stmt->bind_param('di',$paidValue,$rebateTransactionID);
        $stmt->execute();
        $stmt->close();
    }

}

//----------------Supervisor_Month_Planning-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Supervisor_Month_Planning as $s) {
    $monthYear = $s['month_year'];
    $salesPersonID = $s['salesperson_id'];
    $timestampApp= $s['timestamp'];

    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Supervisor_Month_Planning WHERE month_year='$monthYear' AND salesperson_id='$salesPersonID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp)
        {

            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand){

        $submitted= $s['submitted'];
        $routeControlPlanned= $s['route_control_planned'];
        $workWithPlanned= $s['work_with_planned'];
        $routeControlCompleted= $s['route_control_completed'];
        $workWithCompleted= $s['work_with_completed'];
        $initialSubmission= $s['initial_submission'];
        $finalSubmission= $s['final_submission'];

        $stmt = $db->prepare("REPLACE INTO Supervisor_Month_Planning (month_year, salesperson_id, submitted, route_control_planned, work_with_planned, route_control_completed, work_with_completed, initial_submission, final_submission, timestamp) VALUES(?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('sisiiiiss',$monthYear,$salesPersonID,$submitted,$routeControlPlanned,$workWithPlanned,$routeControlCompleted,$workWithCompleted,$initialSubmission,$finalSubmission);
        $stmt->execute();
        $stmt->close();
    }

}


//----------------Warehouse_Transactions_Request_Transactions--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach($xmlData->Warehouse_Transactions_Request_Transactions as $s) {
    $requestID = $s['request_id'];
    $transactionID = $s['transaction_id'];
    $timestampApp= $s['timestamp'];

    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM Warehouse_Transactions_Request_Transactions WHERE request_id='$requestID' AND transaction_id='$transactionID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp) {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand){

        $salesPersonID= $s['salesperson_id'];
        $transactionDate= $s['transaction_date'];
        $notes= $s['notes'];
        $status= $s['status'];

        $stmt = $db->prepare("REPLACE INTO Warehouse_Transactions_Request_Transactions (request_id, transaction_id, salesperson_id, transaction_date, notes, status, timestamp) VALUES(?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiisss',$requestID,$transactionID,$salesPersonID,$transactionDate,$notes,$status);
        $stmt->execute();
        $stmt->close();

    }



}

//-----------------SC_Filter_CustomerGroups--------------------------------------------------------------------------------------------------------------------------------------------------------------------------
foreach ($xmlData->SC_Filter_CustomerGroups as $s) {
    $filterID = $s['filter_id'];
    $groupID = $s['group_id'];
    $timestampApp= $s['timestamp'];

    $executeCommand = true;

    $stm = $db->prepare("SELECT timestamp FROM SC_Filter_CustomerGroups WHERE filter_id='$filterID' AND group_id='$groupID'");
    $stm-> execute();
    $stm-> bind_result($timestampDB);
    while ($stm->fetch()) {
        if($timestampDB >=$timestampApp) {
            $executeCommand = false;
        }
    }
    $stm-> close();

    if($executeCommand){
        $stmt = $db->prepare("REPLACE INTO SC_Filter_CustomerGroups (filter_id, group_id, timestamp) VALUES(?,?,NOW())");
        $stmt->bind_param('ii',$filterID,$groupID);
        $stmt->execute();
        $stmt->close();
    }

}

foreach($xmlData->deviceID as $s) {


    $devID= $s['devID'];
    $setTime=$s['servertime'];
    if(isset($setTime))
    {
         $db1 = new mysqli(localhost,$username,$password,$database);
         if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
             exit();
         } 
         $db1->set_charset("greek");
         $stmt1 = $db1->prepare("UPDATE Devices SET last_update_from= (? - INTERVAL 1 MINUTE) WHERE device_id='$devID'");
         $stmt1->bind_param('s',$setTime);
         $stmt1->execute();
         $stmt1->close();
    }


}


function getNextKey($tableName,$idName)
{
    require("../concc/dbinfo.php");
 $z=0;
 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("greek");



 $likeVar = $prefix."%";
 $stm1 = $db1->prepare("SELECT $idName FROM $tableName WHERE $idName LIKE '$likeVar' ORDER BY $idName DESC LIMIT 1");
 $stm1-> execute();
 $stm1-> bind_result($nextID);
 while ($stm1->fetch()) {

  $z = substr($nextID,4,strlen($nextID));
  $z+=1;


 }
 $stm1->close();


 return $prefix.$z;


}


function docIsLocked($documentID,$documentType)
{
    require("../concc/dbinfo.php");
    $contains=false;

    $db1 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm1 = $db1->prepare("SELECT COUNT(*) FROM ZD_Lock_Document WHERE document_id='$documentID' AND document_type='$documentType'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        if($counter>0)
        {
            $contains=true;
        }

    }
    $stm1->close();
    return $contains;
}




?>