<?php
session_start();

include_once("headerImports.php");
include_once("../param.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$stm = $db->prepare("SELECT allow_anonymous,css_theme,footer,primary_language FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($anonymous,$cssTheme,$footerLabel,$primaryLanguage);

while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();


if(!isset($_SESSION['companyID']))
{

    $_SESSION['companyID']=1;
}

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}


global $username, $password, $database;
$companyID=$_SESSION['companyID'];
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");



if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($alter_full_html) && strcmp($alter_full_html,'')!=0 )
{
    $full_html=$alter_full_html;
}

?>




<body id="home" class="wide">
<!-- PRELOADER -->
<div id="preloader">
    <div id="preloader-status">
        <div class="spinner">
            <div class="rect1"></div>
            <div class="rect2"></div>
            <div class="rect3"></div>
            <div class="rect4"></div>
            <div class="rect5"></div>
        </div>
        <div id="preloader-title">Loading</div>
    </div>
</div>
<!-- /PRELOADER -->

<!-- WRAPPER -->
<div class="wrapper">

    <!-- Popup: Shopping cart items -->
    <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div id='cartItems' class="container">

            </div>
        </div>
    </div>

    <!-- HEADER -->
    <?php
    $topmenu = "topMenu$cssTheme.php";

    if(strcmp($topmenu,"topMenu2.php")==0){
        echo '<header class="header fixed" style="border: 0px;">';
    } else {
        echo '<header class="header fixed" >';
    }

    include_once("$topmenu");
    if(strcmp($topmenu,"topMenu.php")==0) {
        include_once("navigationMenu.php");
    }
    ?>
    </header>

    <!-- /HEADER -->

    <!-- CONTENT AREA -->
    <div class="content-area" style="min-height:600px;">

        <!-- BREADCRUMBS -->
        <section class="page-section breadcrumbs">
            <div class="container" style="height:80px;">
                <div class="page-header">
                    <h2> Account Deletion Process </h2>
                </div>
                <ul class="breadcrumb"></ul>
            </div>
        </section>
        <section class="page-section breadcrumbs">
            <div class="container" style="height:100px;">
                <div class="page-header">
                    <h4> This page describes the account deletion process available to all users of the system </h4>
                </div>
                <ul class="breadcrumb"></ul>
            </div>
        </section>
        <!-- /BREADCRUMBS -->

        <!-- PAGE -->
        <section class="page-section">
            <div class="container">
                <div class="wpb_text_column wpb_content_element " style="

                    margin-bottom: 35px; color: rgb(102, 102, 102); font-family: Raleway, sans-serif; font-size: 14px; background-color: #ffffff;
                    padding: 15px;border-radius: 25px;
                    box-shadow: rgba(99, 99, 99, 0.2) 0px 2px 8px 0px;
                    ">
                    <div class="wpb_wrapper" style="margin-bottom: 0px;">
                        <p>The account deletion process is irreversible and will result in the permanent deletion of all account data.
                            When a deletion request is made, the user account is deactivated immediately.
                            The user will no longer be able to access the account or use any of the app's features.
                            The account and all associated data, including profile information, preferences, and uploaded content, will be permanently deleted from our servers in 30 days.
                            The 30 day period is maintained in order to give the user a chance to request an activation of the account in case the deletion request was made in error.
                        </p>
                    </div>
                </div>

                <div class="row">

                    <div class="col-xs-12 col-sm-8 col-md-9 col-lg-3">
                        <center><h3>STEP 1 : My Account</h3></center>
                        <center><img src='assets/img/accountDeletionSteps/stepDelition.jpg' alt='STEP 1' width="250" height="auto" /></center>
                    </div>
                    <div class="col-xs-12 col-sm-8 col-md-9 col-lg-1"></div>
                    <div class="col-xs-12 col-sm-8 col-md-9 col-lg-3">
                        <center><h3>STEP 2 : Close Account</h3></center>
                        <center><img src='assets/img/accountDeletionSteps/stepDelition1.jpg' alt='STEP 2' width="250" height="auto"/></center>
                    </div>
                    <div class="col-xs-12 col-sm-8 col-md-9 col-lg-1"></div>
                    <div class="col-xs-12 col-sm-8 col-md-9 col-lg-3">
                        <center><h3>STEP 3 : Confirm</h3></center>
                        <center><img src='assets/img/accountDeletionSteps/stepDelition2.jpg' alt='STEP 2' width="250" height="auto"/></center>
                    </div>
                    <div class="col-xs-12 col-sm-8 col-md-9 col-lg-2"></div>
                </div>



            </div>
        </section>
        <!-- /PAGE -->

    </div>
    <!-- /CONTENT AREA -->

    <!-- FOOTER -->
    <?php
    if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
    if(strcmp($topmenu,"topMenu2.php")==0 || strcmp($topmenu,"topMenu3.php")==0) {
        echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: whitesmoke;border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
    } else {
        echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
    }
    ?>

    <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

</div>
<!-- /WRAPPER -->

<!-- JS Global -->
<script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="assets/plugins/superfish/js/superfish.min.js"></script>
<script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
<script src="assets/plugins/owl-carousel2/owl.carousel.min.js"></script>
<script src="assets/plugins/jquery.sticky.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.smoothscroll.min.js"></script>
<script src="assets/plugins/smooth-scrollbar.min.js"></script>

<!-- JS Page Level -->
<script src="assets/js/theme.js"></script>

<!--[if (gte IE 9)|!(IE)]><!-->
<script src="assets/plugins/jquery.cookie.js"></script>
<script src="assets/js/waitMe.min.js"></script>
<!--<![endif]-->

<script>
    jQuery(document).ready(function () {

        initThemeParameters();

        getRelatedItems($('#relatedCategory').val());
        addButtonListenersProductDetails();
        setItemsCartCounter();


    });

    function assignTrigger(start)
    {
        $('.img-carousel').trigger('to.owl.carousel', [start, 300]);
    }

    function setItemsCartCounter()
    {


        $("#modalCartButtonText").html( $('#cartCounter').val());
    }

</script>

</body>
</html>