'use strict';

// Cache
var body = $('body');
var mainSlider = $('.main-slider-box');
var imageCarousel = $('.img-carousel');
var imageCarouselSize = $('.img-carousel > .item').size();
var partnersCarousel = $('.partners');
var testimonialsCarousel = $('#testimonials');
var topProductsCarousel = $('#top-products-carousel');
var featuredProductsCarousel = $('#featured-products-carousel');
var sidebarProductsCarousel = $('#sidebar-products-carousel');
var sidebarProductsCarouselTop = $('#sidebar-products-carousel-top');
var sidebarProductsCarouselNew = $('#sidebar-products-carousel-new');
var sidebarProductsCarouselNewTop = $('#sidebar-products-carousel-new-top');
var hotDealsCarousel = $('#hot-deals-carousel');
var owlCarouselSelector = $('.owl-carousel');
var isotopeContainer = $('.isotope');
var isotopeFiltrable = $('#filtrable a');
var toTop = $('#to-top');
var hover = $('.thumbnail');
var navigation = $('.navigation');
var superfishMenu = $('ul.sf-menu');
var priceSliderRange = $('#slider-range');

var recordsPerPage = 96;
var pageNumber=1;

$.ajaxRequestArray = [];

// Slide in/out with fade animation function
jQuery.fn.slideFadeToggle  = function(speed, easing, callback) {
    return this.animate({opacity: 'toggle', height: 'toggle'}, speed, easing, callback);
};
//
jQuery.fn.slideFadeIn  = function(speed, easing, callback) {
    return this.animate({opacity: 'show', height: 'show'}, speed, easing, callback);
};
jQuery.fn.slideFadeOut  = function(speed, easing, callback) {
    return this.animate({opacity: 'hide', height: 'hide'}, speed, easing, callback);
};

function initThemeParameters()
{
    // Prevent empty links
    // ---------------------------------------------------------------------------------------
    $('a[href=#]').click(function (event) {
        event.preventDefault();
    });
    // Sticky header/menu
    // ---------------------------------------------------------------------------------------
    if ($().sticky) {
        $('.header.fixed').sticky({topSpacing:0});
        //$('#kotsios').sticky({topSpacing:166,zIndex:-1,center:true,responsiveWidth:true});
        //$('.header.fixed').on('sticky-start', function() { console.log("Started"); });
        //$('.header.fixed').on('sticky-end', function() { console.log("Ended"); });
    }
    // SuperFish menu
    // ---------------------------------------------------------------------------------------
    if ($().superfish) {
        superfishMenu.superfish();
    }
    $('ul.sf-menu a').click(function () {
        body.scrollspy('refresh');
    });
    // Fixed menu toggle
    $('.menu-toggle').on('click', function () {
        if (navigation.hasClass('opened')) {
            navigation.removeClass('opened').addClass('closed');
        } else {
            navigation.removeClass('closed').addClass('opened');
        }
    });
    $('.menu-toggle-close').on('click', function () {
        if (navigation.hasClass('opened')) {
            navigation.removeClass('opened').addClass('closed');
        } else {
            navigation.removeClass('closed').addClass('opened');
        }
    });
    // Smooth scrolling
    // ----------------------------------------------------------------------------------------
    $('.sf-menu a, .scroll-to').click(function () {

        $('.sf-menu a').removeClass('active');
        $(this).addClass('active');
        $('html, body').animate({
            scrollTop: $($(this).attr('href')).offset().top
        }, {
            duration: 1200,
            easing: 'easeInOutExpo'
        });
        return false;
    });
    // BootstrapSelect
    // ---------------------------------------------------------------------------------------
    if ($().selectpicker) {
        $('.selectpicker').selectpicker();
    }
    // prettyPhoto
    // ---------------------------------------------------------------------------------------
    //if ($().prettyPhoto) {
    //    $("a[data-gal^='prettyPhoto']").prettyPhoto({
    //        theme: 'dark_square'
    //    });
    //}
    // Scroll totop button
    // ---------------------------------------------------------------------------------------
    $(window).scroll(function () {

        if ($(this).scrollTop() > 1) {
            toTop.css({bottom: '15px'});
        } else {
            toTop.css({bottom: '-100px'});
        }
    });
    toTop.click(function () {
        $('html, body').animate({scrollTop: '0px'}, 800);
        return false;
    });
    // Add hover class for correct view on mobile devices
    // ---------------------------------------------------------------------------------------
    hover.hover(
        function () {
            $(this).addClass('hover');
        },
        function () {
            $(this).removeClass('hover');
        }
    );
    // Sliders
    // ---------------------------------------------------------------------------------------
    if ($().owlCarousel) {
        var owl = $('.owl-carousel');
        owl.on('changed.owl.carousel', function(e) {
            // update prettyPhoto
            if ($().prettyPhoto) {
                $("a[data-gal^='prettyPhoto']").prettyPhoto({
                    theme: 'dark_square'
                });
            }
        });

        // Main slider
        if (mainSlider.length) {
            mainSlider.owlCarousel({
                //items: 1,
                autoplay: true,
                autoplayHoverPause: true,
                loop: true,
                margin: 0,
                dots: true,
                nav: true,
                autoHeight: true,
                animateOut: 'fadeOutLeft',
                animateIn: 'fadeInRight',
                navText: [
                    "<center><i class='fa fa-angle-left car-arrow'></i></center>",
                    "<center><i class='fa fa-angle-right car-arrow'></i></center>"
                ],
                responsiveRefreshRate: 100,
                responsive: {
                    0: {items: 1},
                    479: {items: 1},
                    768: {items: 1},
                    991: {items: 1},
                    1024: {items: 1}
                },

            });

            $('.caption-subtitle').removeClass('animation-caption-subtitle');
            $('.caption-title').removeClass('animation-caption-title');
            $('.slide-img').removeClass('animation-img');
            $('.caption-icon').removeClass('animation-caption-icon');

            mainSlider.find('.owl-item.active').find('.caption-subtitle').addClass('animation-caption-subtitle');
            mainSlider.find('.owl-item.active').find('.caption-title').addClass('animation-caption-title');
            mainSlider.find('.owl-item.active').find('.slide-img').addClass('animation-img');
            mainSlider.find('.owl-item.active').find('.caption-icon').addClass('animation-caption-icon');


            mainSlider.on('changed.owl.carousel', function(event) {
                var currentItem = $('.owl-item').eq(event.item.index);

                $('.caption-subtitle').removeClass('animation-caption-subtitle');
                currentItem.find('.caption-subtitle').addClass('animation-caption-subtitle');

                $('.caption-title').removeClass('animation-caption-title');
                currentItem.find('.caption-title').addClass('animation-caption-title');

                $('.slide-img').removeClass('animation-img');
                currentItem.find('.slide-img').addClass('animation-img');

                $('.caption-icon').removeClass('animation-caption-icon');
                currentItem.find('.caption-icon').addClass('animation-caption-icon');
            });
        }
        // Top products carousel
        if (topProductsCarousel.length) {
            topProductsCarousel.owlCarousel({
                autoplay: false,
                loop: true,
                margin: 30,
                dots: false,
                nav: true,
                navText: [
                    "<i class='fa fa-angle-left car-arrow'></i>",
                    "<i class='fa fa-angle-right car-arrow'></i>"
                ],
                responsive: {
                    0: {items: 1},
                    479: {items: 2},
                    768: {items: 3},
                    991: {items: 4},
                    1024: {items: 5},
                    1280: {items: 6}
                }
            });
        }
        // Featured products carousel
        if (featuredProductsCarousel.length) {
            featuredProductsCarousel.owlCarousel({
                autoplay: false,
                loop: true,
                margin: 30,
                dots: false,
                nav: true,
                navText: [
                    "<i class='fa fa-angle-left car-arrow'></i>",
                    "<i class='fa fa-angle-right car-arrow'></i>"
                ],
                responsive: {
                    0: {items: 1},
                    479: {items: 1},
                    768: {items: 2},
                    991: {items: 3},
                    1024: {items: 4}
                }
            });
        }
        // Sidebar products carousel

        // Partners carousel
        if (partnersCarousel.length) {
            partnersCarousel.owlCarousel({
                autoplay: true,
                autoplayHoverPause: true,
                loop: true,
                margin: 5,
                dots: false,
                nav: true,
                slideBy:1,
                navText: [
                    "<i class='fa fa-angle-left car-arrow'></i>",
                    "<i class='fa fa-angle-right car-arrow'></i>"
                ],
                responsive: {
                    0: {items: 1},
                    479: {items: 2},
                    768: {items: 3},
                    991: {items: 4},
                    1024: {items: 5},
                    1280: {items: 6}
                }
            });
        }
        // Testimonials carousel
        if (testimonialsCarousel.length) {
            testimonialsCarousel.owlCarousel({
                autoplay: true,
                loop: true,
                margin: 0,
                dots: true,
                nav: false,
                navText: [
                    "<i class='fa fa-angle-left car-arrow'></i>",
                    "<i class='fa fa-angle-right car-arrow'></i>"
                ],
                responsive: {
                    0: {items: 1},
                    479: {items: 1},
                    768: {items: 1},
                    991: {items: 1},
                    1024: {items: 1},
                    1280: {items: 1}
                }
            });
        }
        // Images carousel
        if (imageCarousel.length) {
            imageCarousel.owlCarousel({
                autoplay: false,
                loop: imageCarouselSize > 1 ? true : false,
                margin: 0,
                dots: true,
                nav: imageCarouselSize > 1 ? true : false,
                navText: [
                    "<i class='fa fa-angle-left car-arrow'></i>",
                    "<i class='fa fa-angle-right car-arrow'></i>"
                ],
                responsiveRefreshRate: 100,
                responsive: {
                    0: {items: 1},
                    479: {items: 1},
                    768: {items: 1},
                    991: {items: 1},
                    1024: {items: 1}
                }
            });
        }
    }


    // Price range / need jquery ui
    // ---------------------------------------------------------------------------------------
    if ($.ui) {
        if ($(priceSliderRange).length) {
            $(priceSliderRange).slider({
                range: true,
                min: 0,
                max: 500,
                values: [75, 300],
                slide: function (event, ui) {
                    $("#amount").val("$" + ui.values[0] + " - $" + ui.values[1]);
                }
            });
            $("#amount").val(
                "$" + $("#slider-range").slider("values", 0) +
                " - $" + $("#slider-range").slider("values", 1)
            );
        }
    }
    // Shop categories widget slide in/out
    // ---------------------------------------------------------------------------------------
    // $('.shop-categories .arrow').click(
    //     function () {
    //
    //         $(this).parent().parent().find('ul.children').removeClass('active');
    //         $(this).parent().parent().find('.fa-angle-up').addClass('fa-angle-down').removeClass('fa-angle-up');
    //         if ($(this).parent().find('ul.children').is(":visible")) {
    //             //$(this).find('.fa-angle-up').addClass('fa-angle-down').removeClass('fa-angle-up');
    //             //$(this).parent().find('ul.children').removeClass('active');
    //         }
    //         else {
    //             $(this).find('.fa-angle-down').addClass('fa-angle-up').removeClass('fa-angle-down');
    //             $(this).parent().find('ul.children').addClass('active');
    //         }
    //         $(this).parent().parent().find('ul.children').each(function () {
    //             if (!$(this).hasClass('active')) {
    //                 $(this).slideFadeOut();
    //             }
    //             else {
    //                 $(this).slideFadeIn();
    //             }
    //         });
    //     }
    // );
    // $('.shop-categories ul.children').each(function () {
    //     if (!$(this).hasClass('active')) {
    //         $(this).hide();
    //     }
    // });
}

jQuery(window).load(function () {
    // Preloader
    $('#status').fadeOut();
    $('#preloader').delay(200).fadeOut(200);
    // Isotope
    if ($().isotope) {
        isotopeContainer.isotope({ // initialize isotope
            itemSelector: '.isotope-item' // options...
            //,transitionDuration: 0 // disable transition
        });
        isotopeFiltrable.click(function () { // filter items when filter link is clicked
            var selector = $(this).attr('data-filter');
            isotopeFiltrable.parent().removeClass('current');
            $(this).parent().addClass('current');
            isotopeContainer.isotope({filter: selector});
            return false;
        });
        isotopeContainer.isotope('reLayout'); // layout/reLayout
    }
    // Scroll to hash
    if (location.hash != '') {
        var hash = '#' + window.location.hash.substr(1);
        if (hash.length) {
            body.delay(0).animate({
                scrollTop: jQuery(hash).offset().top
            }, {
                duration: 1200,
                easing: "easeInOutExpo"
            });
        }
    }
    // OwlSliders
    if ($().owlCarousel) {
        // Hot deal carousel
        // must initialized after counters
        if (hotDealsCarousel.length) {
            hotDealsCarousel.owlCarousel({
                autoplay: false,
                loop: true,
                margin: 30,
                dots: true,
                nav: false,
                navText: [
                    "<i class='fa fa-angle-left car-arrow'></i>",
                    "<i class='fa fa-angle-right car-arrow'></i>"
                ],
                responsive: {
                    0: {items: 1},
                    479: {items: 1},
                    768: {items: 1},
                    991: {items: 1},
                    1024: {items: 1}
                }
            });
        }
    }
    // Refresh owl carousels/sliders
    owlCarouselSelector.trigger('refresh');
    owlCarouselSelector.trigger('refresh.owl.carousel');
});

jQuery(window).resize(function () {
    // Refresh owl carousels/sliders
    owlCarouselSelector.trigger('refresh');
    owlCarouselSelector.trigger('refresh.owl.carousel');
    // Refresh isotope
    if ($().isotope) {
        isotopeContainer.isotope('reLayout'); // layout/relayout on window resize
    }
    if ($().sticky) {
        $('.header.fixed').sticky('update');
        //  $('#kotsios').sticky('update');
    }
});

jQuery(window).scroll(function () {
    // Refresh owl carousels/sliders
    owlCarouselSelector.trigger('refresh');
    owlCarouselSelector.trigger('refresh.owl.carousel');
    if ($().sticky) {
        $('.header.fixed').sticky('update');
        //  $('#kotsios').sticky('update');
    }

    var $scrollingDiv = $("#scrollingDiv");

    $(window).scroll(function(){
        $scrollingDiv
            .stop()
            .animate({"marginTop": ($(window).scrollTop() )}, "slow" );
    });
});


