<?php
// Andreas Spanos @ 10/07/2019 Changed Query to limit items to allowed items
// Andreas Spanos @ 11/07/2019 Changed Query to limit items to Active only

include_once("../param.php");
require_once("./dbaccess/dbhelper.php");

/**
 * Created by PhpStorm.
 * User: hp
 * Date: 14/09/2015
 * Time: 13:18
 */
session_start();
$userID = $_SESSION['userID'];

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("UTF8");

$stm = $db->prepare("SELECT show_non_stock_items FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($show_non_stock_items);
while ($stm->fetch()) {}
$stm-> close();

$nonStockItemsQueryFilter = '';
if(strcmp("$show_non_stock_items",'no')==0){
    $stm = $db->prepare("SELECT get_stock_from,stock_from_warehouse FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($getStockFrom,$fromWarehouses);
    while ($stm->fetch()) {}
    $stm-> close();

    if(strcmp($getStockFrom,'both')==0){$getStockFrom = "available+reserved";}
    else if(strcmp($getStockFrom,'ignoreReserved')==0){$getStockFrom = "available";}
    else {$getStockFrom = 'available-reserved';}

    if(strcmp($fromWarehouses,'all')==0){$whFilter = "1=1";}
    else if(strcmp($fromWarehouses,'')==0){$whFilter = "1=1";}
    else {$whFilter = " warehouse_id IN($fromWarehouses) ";}

    $nonStockItemsQueryFilter .= " AND Items.item_id IN (SELECT item_id FROM Stock WHERE $whFilter GROUP BY item_id HAVING SUM($getStockFrom) > 0 ) ";

}

if(strlen($_GET['term']) > 2) {
    $keyword = '%' . $_GET['term'] . '%';
    $result = array();

    $categoriesImplode = implode(',',getB2BCategories($db));

    if (strcmp($categoriesImplode,'')!=0) {

        $restriction = "AND Items.item_id  IN(SELECT DISTINCT(item_id) FROM Category_Item WHERE Category_Item.category_id IN ($categoriesImplode) ) $nonStockItemsQueryFilter";
    } else {
        $restriction = " AND 0=1 ";
    }

    if (strcmp($categoriesImplode,'')!=0) {
        $restrictionCategory = "category_id IN ($categoriesImplode)";
    } else {
        $restrictionCategory = " AND 0=1 ";
    }

    if(is_numeric($_GET['term'])){
        $barcodeItems = array();
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT DISTINCT(Items.item_id) FROM Item_Barcode,Items WHERE Item_Barcode.item_id=Items.item_id AND barcode LIKE '$keyword' $restriction LIMIT 10");
        $stm->execute();
        $stm->bind_result($barcodeItem);
        while ($stm->fetch()) {
            array_push($barcodeItems,$barcodeItem);
        }
        $stm->close();
        $barcodeItemsFilter = implode(',',$barcodeItems);

        if(strcmp($barcodeItemsFilter,'')!=0){$restriction .= " OR Items.item_id IN ($barcodeItemsFilter) AND NOT status='inactive' AND NOT sellable='no' $nonStockItemsQueryFilter";}
    }

    //------- Customer Synonyms ----------------

    $customerID = $_SESSION['customerID'];
    if($customerID>0){
        $customerSynonymItems = array();
        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT DISTINCT(item_id) FROM Customer_Item_Synonyms WHERE customer_id=? AND (code_synonym LIKE ? OR name_synonym LIKE ? )");
        $stm->bind_param('iss', $customerID,$keyword, $keyword);
        $stm->execute();
        $stm->bind_result($customerSynonymItem);
        while ($stm->fetch()) {
            array_push($customerSynonymItems,$customerSynonymItem);
        }
        $stm->close();
        $customerSynonymItemsFilter = implode(',',$customerSynonymItems);

        if(strcmp($customerSynonymItemsFilter,'')!=0){$restriction .= " OR Items.item_id IN ($customerSynonymItemsFilter) AND NOT status='inactive' AND NOT sellable='no' $nonStockItemsQueryFilter";}
    }

    //----------------- End --------------------


    $keyword_tokens = explode(' ', $_GET['term']);
    $final_text = implode(' ',$keyword_tokens);
    $statement = "SELECT item_id,name, CONCAT( item_code,' - ',name),thumbnail_url FROM Items WHERE NOT status = 'inactive' AND NOT sellable = 'no' $restriction $nonStockItemsQueryFilter AND( item_code LIKE \"%";
    $statement.= implode("%\" AND item_code LIKE \"%", $keyword_tokens)    ."%\" OR name LIKE \"%";
    $statement.= implode("%\" AND name LIKE \"%", $keyword_tokens) ."%\" OR item_sku LIKE \"%";
    $statement.= implode("%\" AND item_sku LIKE \"%", $keyword_tokens) ."%\"  OR short_description LIKE \"%";
    $statement.= implode("%\" AND short_description LIKE \"%", $keyword_tokens) ."%\"";
    $statement.=") ORDER BY sellable DESC, CASE";
    $statement.=" WHEN item_code = \"$final_text\" THEN 1";
    $statement.=" WHEN name = \"$final_text\" THEN 1";
    $statement.=" WHEN item_sku = \"$final_text\" THEN 1";
    $statement.=" WHEN item_code LIKE \"$final_text%\" THEN 2";
    $statement.=" WHEN name LIKE \"$final_text%\" THEN 2";
    $statement.=" WHEN name LIKE \"%$final_text%\" THEN 3";
    $statement.=" WHEN short_description LIKE '$final_text%' THEN 2";
    $statement.=" WHEN short_description LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN item_code LIKE \"%$final_text%\" THEN 3  WHEN item_code LIKE \"%";
    $statement.=  implode("%\"THEN 4 WHEN item_code LIKE \"%", $keyword_tokens)."%\" THEN 4 ";
    $statement.=" WHEN name LIKE \"$final_text%\" THEN 2";
    $statement.=" WHEN name LIKE \"%$final_text%\" THEN 3  WHEN name LIKE \"%";
    $statement.=  implode("%\"THEN 4 WHEN name LIKE \"%", $keyword_tokens)."%\" THEN 4 ";
    $statement.=" ELSE 6 END,item_code LIMIT 10 OFFSET 0";


    $result = array();
    $db->set_charset("utf8");
//    $stm = $db->prepare("SELECT item_id,name, CONCAT( item_code,' - ',name),thumbnail_url FROM Items WHERE (Items.item_code LIKE ? OR Items.name LIKE ? OR Items.item_sku LIKE ?) AND NOT status = 'inactive' AND NOT sellable = 'no' $restriction $nonStockItemsQueryFilter LIMIT 10 ");
//    $stm->bind_param('sss', $keyword, $keyword, $keyword);
    $stm = $db->prepare("$statement");
    $stm->execute();
    $stm->bind_result($itemID, $name, $label, $thumbnail_url);
    while ($stm->fetch()) {

        $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".jpg";

        $z = "//" . HTML_PATH . "/cop/media/productImages/$thumbnail_url.jpg";
        $rz = ROOT . "/media/productImages/$thumbnail_url.jpg";
        if (!file_exists("../" . $rz) && !file_exists($rz)) {
            $z = "//" . HTML_PATH . "/cop/media/productImages/$thumbnail_url.png";
            $rz = ROOT . "/media/productImages/$thumbnail_url.png";
        }

        if (!file_exists($rz)) {
            $imageUrl = "./assets/img/noimage.jpg";
        }

        if($customerID > 0) {
            $name = getCustomerSynonym($customerID,$itemID,'name',$name);
        }

        $row = new stdClass();
        $row->id = $itemID;
        $row->name = $name;
        $row->label = $label;
        $row->image = $imageUrl;
        array_push($result, $row);
    }
    $stm->close();

    $categoriesArray = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT category_id,category_code,name FROM Categories WHERE name LIKE ? AND $restrictionCategory  LIMIT 10 ");
    $stm->bind_param('s', $keyword);
    $stm->execute();
    $stm->bind_result($categoryID,$categoryCode,$categoryName);
    while ($stm->fetch()) {
        $categorieObj = new stdClass();
        $categorieObj->id = $categoryID;
        $categorieObj->name = $categoryName;
        $categorieObj->code = $categoryCode;
        array_push($categoriesArray, $categorieObj);
    }
    $stm->close();



    if(count($result) ==0){
        $resultTitle = 'No Products Found';
    } else {
        $resultTitle = 'Products';
    }

    $function_result = array();
    $function_result['value'] = ' ';
    $function_result['id'] = '';
    $function_result['type'] = "title";
    $function_result['label'] = $resultTitle;
    $output[] = $function_result;

    foreach ($result as $row) {

        $function_result = array();
        $function_result['value'] = $row->name;
        $function_result['id'] = $row->id;
        $function_result['type'] = "item";
        $function_result['label'] = '<div style="cursor: pointer;"><img src="' . $row->image . '" width="40" height="40" style="margin:2px;border-radius:20%;object-fit: cover;object-position: 50% 30%;" /><span style="display: inline-block;width: 69%;vertical-align: middle;line-height:1;margin-left: 7px;">' . $row->name . '</span></div>';
        $output[] = $function_result;
    }

    if(count($categoriesArray) ==0){
        $categoriesTitle = 'No Categories Found';
    } else {
        $categoriesTitle = 'Categories';
    }

    $function_result = array();
    $function_result['value'] = ' ';
    $function_result['id'] = '';
    $function_result['type'] = "title";
    $function_result['label'] = $categoriesTitle;
    $output[] = $function_result;


    foreach ($categoriesArray as $categorieObj) {
        $function_result = array();
        $function_result['value'] = ' ';
        $function_result['id'] = $categorieObj->id;
        $function_result['type'] = "category";
        $function_result['label'] = '<div style="cursor: pointer;"><span style="display: inline-block;width: 69%;vertical-align: middle;line-height:1;margin-left: 7px;"><a style="font-weight:bold;font-size:13px;" class="selectCategoryStandard pointer" data-index=' . $categorieObj->id . '>' . $categorieObj->name . '</a></span></div>';
        $output[] = $function_result;
    }



    echo json_encode($output);

}



function getB2BCategories($db){

    $categoriesArray = array();
    $counterOfCategories = 0;
    $categoryID = 0;

    if(isset($_SESSION['userID'])) {
        $user=$_SESSION['userID'];
        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();
        if($counterOfCategories>0)
        {
            $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }
    } else {
        $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}

?>

