<?php
include_once("headerImports.php");


if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}

include('../langs/'.$_SESSION['lang'].'.php');

$loginTitle = $langu['login_page_login_title'];
$welcomeMessage = $langu['change_password_text'];
$usernameHint = $langu['login_page_username_hint'];
$passwordHint = $langu['login_page_password_hint'];
$loginButton = $langu['login_page_login_button'];

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme,footer FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($cssTheme,$footerLabel);

while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}



?>


    <body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- HEADER -->
                <?php

                $topmenu = "topMenuCheckout$cssTheme.php";

                if(strcmp($topmenu,"topMenuCheckout2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenuCheckout.php")==0) {
//                    include_once("navigationMenu.php");
                }

                ?>
            </header>

            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area" style="background-image: url('assets/img/loginBackground.jpg');">

                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6 col-md-offset-3 col-sm-offset-3" style="background-color: white; padding: 20px;" >
                                <h3 class="block-title text-center" style="margin-bottom:0px">
                                    <span><?php echo "$welcomeMessage"; ?></span>
                                </h3>

                                    <div class="row form-login">
                                        <div class="col-md-12 hello-text-wrap">
                                            <span class="hello-text text-thin"><?php echo "$passwordChangeTitle"; ?></span>
                                        </div>

                                        <div class="col-md-12">
                                            <label><?php echo $langu['old_password']; ?> <span class="inline"  id="oldMissMatchText"></span></label>
                                            <div class="form-group">
                                                <input type="password" class="form-control" name="oldPass" id="oldPass" required>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label><?php echo $langu['new_password']; ?> <span id="password-strength-text"></span><span class="inline" id="missMatchText"></span></label>
                                            <div class="form-group">
                                                <input type="password" class="form-control" name="newPass" id="newPass" required>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <label><?php echo $langu['confirm_password']; ?></label>
                                            <div class="form-group">
                                                <input type="password" class="form-control" name="confirmPass" id="confirmPass" required>
                                            </div>
                                        </div>

                                        <input type="hidden" name="passScore" id="passScore" required>

                                        <div class="col-md-6">
                                            <button type="button" class="btn btn-theme btn-block" name="redirect" id="redirect" onclick="skipSubmit()">
                                                <?php echo $langu['skip_password_change']; ?>
                                            </button>
                                        </div>

                                        <div class="col-md-6">
                                            <button type="button" class="btn btn-theme btn-block" name="submitPass" id="submitPass" onclick="submitButton()">
                                                <?php echo $langu['pass_button_submit']; ?>
                                            </button>
                                        </div>
                                    </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <header class="header fixed" >

            </header>
            <!-- /CONTENT AREA -->
            <div class="container" style="margin-top:60px;">


            <div class="row">
                <div class="col-md-4">
                    <h2 class="block-title"><span>Instant Orders</span></h2>
                    <p>Select the products you would like to order from an interactive catalogue and complete your order in a matter of seconds</p>
                </div>
                <div class="col-md-4">
                    <h2 class="block-title"><span>Complete Order History</span></h2>
                    <p>All the orders you have already placed will be available 24/7. Feel free to verify and print the orders.</p>
                </div>
                <div class="col-md-4">
                    <h2 class="block-title"><span>All Product Catalogues</span></h2>
                    <p>The products we sell are available for ordering at any time. You will also see the correct pricing based on your login credentials</p>
                </div>
            </div>

                </div>

            <!-- Modal -->
            <div class="modal fade" id="successModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                            <h4 class="modal-title" style="margin-left:10px;"><strong style="padding-left:5px;">&nbsp; <?php echo $langu['new_password']; ?></strong></h4>
                        </div>

                        <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                            <br><br>
                            <center>
                                <h4 class="modal-title" style="margin-left:10px;"><strong style="padding-left:5px;">&nbsp; <?php echo $langu['password_changed_succesfully']; ?></strong></h4>
                            </center>
                            <br><br>
                        </div>

                        <footer class="modal-footer" >

                        </footer>
                    </div><!-- /.modal-content -->
                </div><!-- /.modal-dialog -->
            </div><!-- /.modal -->

            <!-- FOOTER -->
            <?php
            if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
            if(strcmp($topmenu,"topMenuCheckout2.php")==0 || strcmp($topmenu,"topMenuCheckout3.php")==0) {
                echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: whitesmoke;border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            } else {
                echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            }
            ?>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->



        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>
        <script src="assets/plugins/zxcvbn_4_2_0/zxcvbn.js"></script>
        <!--<script src="https://cdnjs.cloudflare.com/ajax/libs/zxcvbn/4.2.0/zxcvbn.js"></script>-->

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>

        <!--<![endif]-->
        <script type="text/javascript">

            function submitButton(){
                $('#missMatchText').text('');
                $('#oldMissMatchText').text('');
                $('#confirmPass').css('border-color','');
                $('#newPass').css('border-color','');

                var oldIdentifier = $('#oldPass').val();
                var newIdentifier = $('#newPass').val();
                var confirmIdentifier = $('#confirmPass').val();
                var score = $('#passScore').val();


                if(newIdentifier.localeCompare(confirmIdentifier) != 0){
                   $('#missMatchText').text(' <?php echo $langu['Password_mismatch']?>');
                    $('#password-strength-text').text('');
                    $('#confirmPass').css('border-color','#b22222');
                    $('#newPass').css('border-color','#b22222');
                } else  if(newIdentifier.localeCompare('') == 0){
                    $('#missMatchText').text(' <?php echo $langu['Empty_password']?>');
                    $('#password-strength-text').text('');
                    $('#newPass').css('border-color','#b22222');
                } else  if(score <= 0){
                    $('#missMatchText').text(' <?php echo $langu['weak_password']?>');
                    $('#password-strength-text').text('');
                    $('#newPass').css('border-color','#b22222');
                }else  if(oldIdentifier.localeCompare('') == 0){
                    $('#oldPass').css('border-color','#b22222');
                    $('#oldMissMatchText').text(" <?php echo $langu['Password_mismatch']?>");
                } else {

                    $.ajax({
                        type: "POST",
                        url: './dbaccess/b2b_change_identifier.php',
                        data: {
                            'oldIdentifier':oldIdentifier,
                            'newIdentifier':newIdentifier
                        },
                        success: function (result) {
                            if(result == true){
                                $('#successModal').modal('toggle');
                                setTimeout( function () {
                                    window.location.replace("login.php");
                                }, 3000 );
                            } else {

                                $('#oldPass').css('border-color','#b22222');
                                $('#oldMissMatchText').text(" <?php echo $langu['Password_mismatch']?>");
                            }
                        }
                    });
                }


            }

            function skipSubmit(){
                window.location.replace("index.php");
            }

            jQuery(document).ready(function () {

                var cookies = document.cookie.split(";");
                for(var i=0; i < cookies.length; i++) {
                    var equals = cookies[i].indexOf("=");
                    var name = equals > -1 ? cookies[i].substr(0, equals) : cookies[i];
                    document.cookie = name + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT";
                }


                var strength = {
                    0: "<span class='inline' style='color: firebrick'>Very Weak</span>",
                    1: "<span class='inline' style='color: darkorange'>Weak</span>",
                    2: "<span class='inline' style='color: green'>Good</span>",
                    3: "<span class='inline' style='color: darkgreen'>Strong</span>",
                    4: "<span class='inline' style='color: darkgreen'>Very Strong</span>"
                };

                var password = document.getElementById('newPass');
                var text = document.getElementById('password-strength-text');

                password.addEventListener('input', function() {
                    $('#missMatchText').text('');
                    var val = password.value;
                    var result = zxcvbn(val);


                    // Update the text indicator
                    if (val !== "") {
                        text.innerHTML =  strength[result.score];
                        $('#passScore').val(result.score);
                    } else {
                        text.innerHTML = "";
                    }
                });
            });



        </script>


    </body>
</html>