<?php
include_once("headerImports.php");

$edit = false;
if(isset($_POST['edit'])){
    $isEdit = trim($_POST['edit']);
    if(strcmp($isEdit,'yes')==0){
        $edit = true;
    }
}

$isInactive = false;
if(isset($_GET['in']))
{
   $isInactive = true;
}

$activated = false;
if(isset($_GET['activated'])){
    $active = trim($_GET['activated']);
    if(strcmp($active,'yes')==0){
        $activated = true;
    }
}

if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}

if(isset($_SESSION['B2C']))
{
    $isB2C =  $_SESSION['B2C'];
} else {
    redirect('login.php');
}

include('../langs/'.$_SESSION['lang'].'.php');


global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT use_as_b2c,css_theme,footer,custom_delivery_time_slots FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($hasB2C,$cssTheme,$footerLabel,$customDeliveryTimeslots);
while ($stm->fetch()) {
    if(strcmp($hasB2C,'yes')!=0){
        redirect('login.php');
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();

$stm = $db->prepare("SELECT customer_activation_method FROM B2C_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($activationMethod);
while ($stm->fetch()) {}
$stm-> close();

$checkedBox = "checked";
$deleteButtonHide = "display:none";
if($edit){
    $customerID = $_SESSION['customerID'];
    $stm = $db->prepare("SELECT COUNT(customer_address_id) FROM CustomerAddress WHERE customer_id='$customerID' AND NOT primary_address='deleted'");
    $stm-> execute();
    $stm-> bind_result($counter);
    while ($stm->fetch()) {
        if($counter > 1){
            $disableCheckBox='';
            $deleteButtonHide='';
        } else {
            $disableCheckBox = "disabled readonly";
        }
    }
    $stm-> close();

    $customerAddressID = trim($_POST['customerAddressID']);
    $stm = $db->prepare("SELECT country,city,address_line_1,address_line_2,postcode,primary_address,lat,lng FROM CustomerAddress WHERE customer_address_id='$customerAddressID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($country, $city, $street, $area, $postcode, $primary,$lat,$lng);
    while ($stm->fetch()) {}
    $stm-> close();
    if(strcmp($primary,'yes')!=0){$checkedBox = "";}
}

$cityTitle  = $langu['city_title'];
$areaTitle  = $langu['area_title'];
$streetTitle  = $langu['street_address_title'];
$postCodeTitle  = $langu['postcode_title'];
$countryTitle = $langu['country_title'];
$userAddressTitle =  $langu['user_address_title'];
$primaryTitle = $langu['primary_button'];
$findAddressHint = $langu['find_your_location'];
$addAddressTitle = $langu['add_address_button'];
$confirmationNotice = $langu['address_added_notice'];
$addressDeletedNotice = $langu['address_deleted_notice'];
$deleteNotice = $langu['delete_address_notice'];
$deleteConfirmationNotice = $langu['delete_address_confirmation_notice'];

if($edit){
    $confirmationNotice = $langu['address_saved_notice'];
}

$requiredFieldTitle   = "<i class='fa fa-asterisk' style='color: #d68170;font-size: 12px;'>&nbsp;".$langu['required_field_notice']."</i>";

$confirmationBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$confirmationNotice</h2></center><br><br><a href='myAddress.php' class='btn btn-theme'>".$langu['account_order_history_back_to_account_button']."</a></div>";

$deleteConfirmationBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$deleteConfirmationNotice</h2></center><br><br><a href='myAddress.php' class='btn btn-theme'>".$langu['account_order_history_back_to_account_button']."</a></div>";

function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

?>
<body id="home" class="wide">
<!-- PRELOADER -->
<div id="preloader">
    <div id="preloader-status">
        <div class="spinner">
            <div class="rect1"></div>
            <div class="rect2"></div>
            <div class="rect3"></div>
            <div class="rect4"></div>
            <div class="rect5"></div>
        </div>
        <div id="preloader-title">Loading</div>
    </div>
</div>
<!-- /PRELOADER -->

<!-- WRAPPER -->
<div class="wrapper">

    <!-- HEADER -->
        <?php
        $topmenu = "topMenuCheckout$cssTheme.php";

        if(strcmp($topmenu,"topMenuCheckout2.php")==0){
            echo '<header class="header fixed" style="border: 0px;">';
        } else {
            echo '<header class="header fixed" >';
        }

        include_once("$topmenu");
        if(strcmp($topmenu,"topMenu.php")==0) {
            include_once("navigationMenu.php");
        }
        ?>
    </header>
    <!-- /HEADER -->

    <!-- CONTENT AREA -->
    <div class="content-area" style="background-image: url('assets/img/loginBackground.jpg');">

        <!-- PAGE -->
        <section class="page-section color">
            <div class="container">
                <div class="row">
                    <div class="col-sm-9 col-md-offset-2 " id='registrationForm' style="background-color: white;padding: 20px;">
<!--                        <h1 class="" style="text-align:center;font-size:40px;font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif; color:black;margin-bottom:30px;font-weight: bold">--><?php //echo "$registerTitle";?><!--</h1>-->
                            <div class="row">

                                    <br><h3 class="block-title"><span><?php echo "$addAddressTitle";?></span></h3>

                                    <input id="search" class="controls form-control" type="text" placeholder="<?php echo "$findAddressHint";?>" style="height: 35px;">
                                    <div class='google_maps' style='height:420px;margin-bottom:10px;' id='map' ></div>

                                    <div class="form-group">

                                        <table style="display: none;">
                                            <tr>
                                                <td>

                                                    <input name="lat" id="lat" class="form-control" type="number" placeholder="<?php echo "Lat";?>" value="<?php echo $lat?>" >
                                                </td>
                                                <td style="width: 2%"></td>
                                                <td>

                                                    <input name="lng" id="lng" class="form-control" type="number" placeholder="<?php echo "Lng";?>" value="<?php echo $lng?>">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class="form-group">
                                        <?php echo "&nbsp;&nbsp;$countryTitle";?>
                                        <select name="country" id="country" class="form-control" required>
                                            <option selected>Cyprus</option>
                                        </select>
                                    </div>

                                    <div class="form-group">

                                        <table style="width: 100%">
                                            <tr>
                                                <td>
                                                    <?php echo "&nbsp;&nbsp;$cityTitle $requiredFieldTitle";?>
<!--                                                    <input name="city" id="city" class="form-control" type="text" placeholder="--><?php //echo "$cityTitle";?><!--" value="--><?php //echo $city?><!--" required>-->
                                                    <?php

                                                    if(strcmp($customDeliveryTimeslots,'city') == 0) {
                                                        echo "<select name='city' id='city' class='form-control' required>";
                                                        $hasSelectedCity = false;
                                                        $cityOptions = '';
                                                        $stm = $db->prepare("SELECT zip_code_region FROM ZZ_Zip_Codes WHERE NOT zip_code_region LIKE 'all' ORDER BY zip_code_region ASC");
                                                        $stm-> execute();
                                                        $stm-> bind_result($cityOption);
                                                        while ($stm->fetch()) {
                                                            if(strcmp($city,$cityOption) == 0) {
                                                                $cityOptions .= "<option selected value='$cityOption'>$cityOption</option>";
                                                                $hasSelectedCity = true;
                                                            } else {
                                                                $cityOptions .= "<option value='$cityOption'>$cityOption</option>";
                                                            }

                                                        }
                                                        $stm-> close();
                                                        if($hasSelectedCity) {
                                                            $cityOptions = "<option disabled value=''>Select City</option>".$cityOptions;
                                                        } else {
                                                            $cityOptions = "<option selected disabled value=''>Select City</option>".$cityOptions;
                                                        }
                                                        echo $cityOptions;
                                                    } else {
                                                        echo "<input name='city' id='city' class='form-control' type='text' placeholder='$cityTitle' required>";
                                                    }

                                                    ?>
                                                </td>
                                                <td style="width: 2%"></td>
                                                <td>
                                                    <?php echo "&nbsp;&nbsp;$areaTitle";?>
                                                    <input name="area" id="area" class="form-control" type="text" placeholder="<?php echo "$areaTitle";?>" value="<?php echo $area?>">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class="form-group"><?php echo "&nbsp;&nbsp;$streetTitle $requiredFieldTitle";?><input name="streetAddress" id="streetAddress" class="form-control" type="text" placeholder="<?php echo "$streetTitle";?>" value="<?php echo $street?>" required></div>

                                    <div class="form-group"><?php echo "&nbsp;&nbsp;$postCodeTitle $requiredFieldTitle";?><input name="postcode" id="postcode" class="form-control" type="number" placeholder="<?php echo "$postCodeTitle";?>" value="<?php echo $postcode?>" required></div>

                                    <div class="form-group" >
                                        <center>
                                        <table>
                                            <tr>
                                                <td>
                                                    <input name="preselected" id="preselected" type="checkbox" value="yes" style="height: 30px;width: 30px;display: inline" <?php echo "$checkedBox $disableCheckBox"?> />
                                                </td>
                                                <td style="font-size: 14px;font-weight: bold">
                                                    <?php echo "&nbsp;&nbsp;$primaryTitle";?>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <center><span id='postcodeNotDeliverable' class="form-control" style='border-color:firebrick;display:none;'><i class='fa fa-asterisk' style='color: fireBrick;font-size: 14px;'>&nbsp;<b><?php echo $langu['not_delivering_in_area'];?></b></i></span></center>
                                    <input type="hidden" id="postcodeNotDeliverableInput" value="1">
                                </div>


                                <?php
                                if($edit) {
                                    echo '<div class="col-md-2" ><button type="button" class="btn btn-danger btn-block" onclick="deleteAddress()" style=" height: 43px;font-weight: bolder;'.$deleteButtonHide.'">' . $deleteNotice . '</button></div>
                                          <div class="col-md-1"></div>
                                          <div class="col-md-6">
                                            <input type="button" class="btn btn-theme btn-block" id="validateRegistrationButton" onclick="validateAddress()" value="' . $addAddressTitle . '"/>
                                          </div>';
                                } else {
                                    echo '
                                          <div class="col-md-6 col-md-offset-3">
                                            <input type="button" class="btn btn-theme btn-block" id="validateRegistrationButton" onclick="validateAddress()" value="' . $addAddressTitle . '"/>
                                          </div>';
                                }
                                ?>

                            </div>
                    </div>
                </div>
            </div>
        </section>
        <!-- /PAGE -->

    </div>
    <header class="header fixed" >

    </header>
    <!-- /CONTENT AREA -->
    <div class="container" style="margin-top:60px;">


        <div class="row">
<!--            <div class="col-md-4">-->
<!--                <h2 class="block-title"><span>Instant Orders</span></h2>-->
<!--                <p>Select the products you would like to order from an interactive catalogue and complete your order in a matter of seconds</p>-->
<!--            </div>-->
<!--            <div class="col-md-4">-->
<!--                <h2 class="block-title"><span>Complete Order History</span></h2>-->
<!--                <p>All the orders you have already placed will be available 24/7. Feel free to verify and print the orders.</p>-->
<!--            </div>-->
<!--            <div class="col-md-4">-->
<!--                <h2 class="block-title"><span>All Product Catalogues</span></h2>-->
<!--                <p>The products we sell are available for ordering at any time. You will also see the correct pricing based on your login credentials</p>-->
<!--            </div>-->
        </div>

    </div>

    <!-- FOOTER -->
    <?php
    if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
    if(strcmp($topmenu,"topMenu2.php")==0 || strcmp($topmenu,"topMenu3.php")==0) {
        echo '<footer class="footer" style="border: 0px;" >
                                <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                    <div class="container" style="width: 100%" >
                                        <div class="row" >
                
                                            <div class="col-sm-6 footer-copyright-outer" >
                                                <div class="copyright footer-copyright-text" style="color: whitesmoke;border-color: transparent">
                                                     '.$footerLabel.'
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </footer>';
    } else {
        echo '<footer class="footer">
                                <div class="footer-meta footer-custom">
                                    <div class="container">
                                        <div class="row">
                
                                            <div class="col-sm-6 footer-copyright-outer" >
                                                <div class="copyright footer-copyright-text" >
                                                    '.$footerLabel.'
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </footer>';
    }
    ?>
    <!-- /FOOTER -->

    <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

</div>
<!-- /WRAPPER -->



<!-- JS Global -->
<script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="assets/plugins/superfish/js/superfish.min.js"></script>
<script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
<script src="assets/plugins/jquery.sticky.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.smoothscroll.min.js"></script>
<script src="assets/plugins/smooth-scrollbar.min.js"></script>

<!-- JS Page Level -->
<script src="assets/js/theme.js"></script>

<!--[if (gte IE 9)|!(IE)]><!-->
<script src="assets/plugins/jquery.cookie.js"></script>

<!--<![endif]-->
<script type="text/javascript">

    function deleteAddress(){
        var customerAddressID = '<?php echo $customerAddressID?>';

        $.ajax({
            type: "POST",
            url: './dbaccess/removeAddress.php',
            data: {
                'customerAddressID': '<?php echo $customerAddressID?>'
            },
            success: function (result) {
                if(result == 1) {
                    $('#registrationForm').html("<?php echo $deleteConfirmationBox ?>");
                    scrollIntoView('#registrationForm');
                }
            }
        });
    }

    function scrollIntoView(element){

        var offset = $(element).offset();

        offset.left -= 20;
        offset.top -= 80;

        $('html, body').animate({
            scrollTop: offset.top,
            scrollLeft: offset.left
        });
    }
    
    function validateAddress(){

        $("input").css("border-color", "");


        var validation           = true;
        var scrolled             = false;

        if(validation) {
            if (!$('#lat').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#search');
                }
                validation = false;
                $('#search').css("border-color", "firebrick");
            }
            if (!$('#country').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#country');
                }
                validation = false;
                $('#country').css("border-color", "firebrick");
            }
            if (!$('#city').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#city');
                }
                validation = false;
                $('#city').css("border-color", "firebrick");
            }
            if (!$('#streetAddress').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#streetAddress');
                }
                validation = false;
                $('#streetAddress').css("border-color", "firebrick");
            }
            if (!$('#postcode').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#postcode');
                }
                validation = false;
                $('#postcode').css("border-color", "firebrick");
            }

        }
        var customTimeslotsValidation = $('#postcodeNotDeliverableInput').val();
        if(customTimeslotsValidation == 1) {
            registerAddress(validation);
        }
    }

    function registerAddress(validation){
        if(validation){

            var country              = $('#country').val();
            var city                 = $('#city').val();
            var area                 = $('#area').val();
            var streetAddress        = $('#streetAddress').val();
            var postcode             = $('#postcode').val();
            var lat                  = $('#lat').val();
            var lng                  = $('#lng').val();
            var preselected          = "";
            var register             = true;

            if($('#preselected').prop('checked') === true){
                preselected = "yes";
            } else {
                preselected = "no";
            }

            $.ajax({
                type: "POST",
                <?php
                    if($edit){
                        echo "url: './dbaccess/editCustomerAddress.php',";
                    } else {
                        echo "url: './dbaccess/addCustomerAddress.php',";
                    }
                ?>

                data: {
                    'country': country,
                    'city': city,
                    'area': area,
                    'streetAddress': streetAddress,
                    'postcode': postcode,
                    'preselected': preselected,
                    'lat': lat,
                    'lng': lng,
                    'register': register
                    <?php
                    if($edit)
                        echo ",'customerAddressID': '$customerAddressID'";
                    ?>
                },
                success: function (result) {
                    $('#registrationForm').html("<?php echo $confirmationBox ?>");
                    scrollIntoView('#registrationForm');
                }
            });
        }
    }

    jQuery(document).ready(function () {

        // var cookies = document.cookie.split(";");
        // for(var i=0; i < cookies.length; i++) {
        //     var equals = cookies[i].indexOf("=");
        //     var name = equals > -1 ? cookies[i].substr(0, equals) : cookies[i];
        //     document.cookie = name + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT";
        // }
        var isInactive = "<?php echo $isInactive?>";

        if(isInactive){
            $('#registrationForm').html("<?php echo $inactiveBox ?>");
            scrollIntoView('#registrationForm');
        }



        $('#city').on('change',function () {
            customTimeslotDeliveryValidation();
        });

        $('#postcode').on('change',function () {

            customTimeslotDeliveryValidation();
        });


    });

    function customTimeslotDeliveryValidation(){
        $('#postcodeNotDeliverableInput').val(0);
        var postCode = $('#postcode').val();
        var city = $('#city').val();
        $.ajax({
            type: "POST",
            url: './dbaccess/b2c_zip_code_validation.php',
            data: {'postCode': postCode,'city':city},
            success: function (result) {
                $('#postcodeNotDeliverableInput').val(result);
                if(result == 0){
                    $('#postcodeNotDeliverable').show();
                    $('#validateRegistrationButton').hide();
                    scrollIntoView('#postcodeNotDeliverable');
                    return false;
                } else {
                    $('#postcodeNotDeliverable').hide();
                    $('#validateRegistrationButton').show();
                    return true;
                }
            }
        });
    }

    let map;
    let service;
    let infowindow;

    function initAutocomplete() {
        var map = new google.maps.Map(document.getElementById('map'), {
            center: {lat: -33.8688, lng: 151.2195},
            zoom: 13,
            mapTypeId: "roadmap",
            // mapTypeControl: false,
            disableDefaultUI: true,
        });

        var input = document.getElementById('search');
        map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);

        var autocomplete = new google.maps.places.Autocomplete(input);
        autocomplete.bindTo('bounds', map);

        var infowindow = new google.maps.InfoWindow();

        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                (position) => {
                    const pos = {
                        <?php
                        if($lat > 0 && $lng > 0){
                            echo "lat: $lat,
                                  lng: $lng,";
                        } else {
                            echo "lat: position.coords.latitude,
                                  lng: position.coords.longitude,";
                        }
                        ?>
                    };

                    map.setCenter(pos);
                },
                () => {
                    handleLocationError(true, infowindow, map.getCenter());
                }
            );
        }

        var marker = new google.maps.Marker({
            map: map,
            anchorPoint: new google.maps.Point(0, -29),
            draggable: true,
        });
        <?php
        if($lat > 0 && $lng > 0){
            echo  "var marker = new google.maps.Marker({
                        position: { lat: $lat , lng: $lng },
                        map: map,
                        draggable: true,
                    });";
        }
        ?>


        autocomplete.addListener('place_changed', function() {
            infowindow.close();
            marker.setVisible(false);
            var place = autocomplete.getPlace();
            if (!place.geometry) {
                window.alert("Autocomplete's returned place contains no geometry");
                return;
            }

// If the place has a geometry, then present it on a map.
            if (place.geometry.viewport) {
                map.fitBounds(place.geometry.viewport);
            } else {
                map.setCenter(place.geometry.location);
                map.setZoom(17);
            }
            // marker.setIcon(({
            //     url: place.icon,
            //     size: new google.maps.Size(71, 71),
            //     origin: new google.maps.Point(0, 0),
            //     anchor: new google.maps.Point(17, 34),
            //     scaledSize: new google.maps.Size(35, 35)
            // }));
            marker.setPosition(place.geometry.location);
            marker.setVisible(true);
            var location = place.geometry.location;

            $('#lat').val(location.lat());
            $('#lng').val(location.lng());
            fillInAddress();
        });

        marker.addListener('mouseout', function() {
            var newLat = marker.getPosition().lat();
            var newLng = marker.getPosition().lng();
            $('#lat').val(newLat);
            $('#lat').trigger('change');
            $('#lng').val(newLng);
            $('#lng').trigger('change');
        });

        function fillInAddress() {
            var componentForm = {
                street_number: 'short_name',
                route: 'long_name',
                locality: 'long_name',
                administrative_area_level_1: 'short_name',
                postal_code: 'short_name',
                country: 'long_name'
            };

            var place = autocomplete.getPlace();

            for (var i = 0; i < place.address_components.length; i++) {

                var addressType = place.address_components[i].types[0];
                if (componentForm[addressType]) {

                    if (addressType == 'street_number') {
                        var streetNumber = place.address_components[i][componentForm[addressType]];
                    }

                    if (addressType == 'route') {
                        var route = place.address_components[i][componentForm[addressType]];
                    }

                    if (addressType == 'locality') {
                        var locality = place.address_components[i][componentForm[addressType]];
                    }

                    if (addressType == 'administrative_area_level_1') {
                        var state = place.address_components[i][componentForm[addressType]];
                    }

                    if (addressType == 'postal_code') {
                        var zipcode = place.address_components[i][componentForm[addressType]];
                    }
                    if (addressType == 'country') {
                        var country = place.address_components[i][componentForm[addressType]];
                    }

                }

            }

            if(streetNumber == null){streetNumber='';}
            if(route == null){route='';}
            if(locality == null){locality='';}
            if(state == null){state='';}
            if(zipcode == null){zipcode='';}
            if(country == null){country='';}

            $('#streetAddress').val(streetNumber + ' ' + route)
            $('#city').val(state)
            $('#area').val(locality)
            $('#postcode').val(zipcode)

            var o = new Option(country, country);
            $(o).html(country);
            $("#country").append(o);
            $("#country").val(country);
            $("#country").trigger('change');
            $('#search').val('');
        }
    }

</script>

<script src='https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs&language=en&callback=initAutocomplete&libraries=places&v=weekly' async></script>


</body>
</html>