<?php
session_start();
require_once('../../param.php');
require_once("../dbaccess/dbhelper.php");
include_once('emailOrder.php');

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$isAnonymous=true;
$db->set_charset("utf8");
$stmt = $db->prepare("SELECT b2b_user_id,B2B_User.customer_id,show_stock,show_prices,login_times,acceptance1,Customers.type_of_business FROM  B2B_User, Customers WHERE Customers.customer_id=B2B_User.customer_id AND b2b_user_id = ? AND b2b_user_id > 0");
$stmt->bind_param("s",$_GET['urds']);
$stmt->execute();
$stmt->bind_result($userID,$customerID,$showStock,$showPrices,$loginTimes,$acceptance1,$typeOfBussiness);
if ($stmt->fetch())
{   $isAnonymous=false;
    if(strcmp($typeOfBussiness,'Inactive')!=0){
        $_SESSION['customerID'] = $customerID;
        $_SESSION['companyID'] = "1";
        $_SESSION['orderID'] = getAvailableOrderID($customerID,$userID);
        $_SESSION['userID'] = $userID;
        if(strcmp($showStock,'yes')==0) {
            $_SESSION['showStock'] = true;
        }
        else{
            $_SESSION['showStock'] = false;
        }

        if(strcmp($showPrices,'yes')==0) {
            $_SESSION['showPrices'] = true;
        }
        else{
            $_SESSION['showPrices'] = false;
        }

        if(strcmp($acceptance1,'')==0) {
            $loginTimes=0;
        }

        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");


        $stm2 = $db2->prepare("SELECT subunits_1_force_integer  FROM B2B_Configuration");
        $stm2-> execute();
        $stm2-> bind_result($subunitsForce);

        while ($stm2->fetch()) {
            if(strcmp($subunitsForce,"yes")==0)
            {
                $_SESSION['subunitsForce'] = true;
            }
            else{
                $_SESSION['subunitsForce'] = false;
            }

        }
        $stm2->close();

        $stm2 = $db2->prepare("SELECT COUNT(*)  FROM B2B_Allow_Categories_User WHERE b2b_user_id='$userID'");
        $stm2-> execute();
        $stm2-> bind_result($restrictionCounter);

        while ($stm2->fetch()) {
            if($restrictionCounter>0)
            {
                $_SESSION['restricted'] = true;
            }
            else{
                $_SESSION['restricted'] = false;
            }

        }
        $stm2->close();

        $stm2 = $db2->prepare("SELECT gdpr_confirmation  FROM B2B_Configuration");
        $stm2-> execute();
        $stm2-> bind_result($checkGdpr);

        while ($stm2->fetch()) {
            if(strcmp($checkGdpr,"yes")==0)
            {
                $checkGdpr = true;
            }
            else{
                $checkGdpr = false;
            }

        }
        $stm2->close();


    }
}
$stmt->close();

if($isAnonymous){
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT anonymous_checkout,anonymous_checkout_customer_id FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($anonymous_checkout,$anonymous_checkout_customer_id);
    while ($stm->fetch()) {
        if(strcmp($anonymous_checkout,"yes")==0 && $anonymous_checkout_customer_id > 0)
        {
            $_SESSION['customerID'] = $anonymous_checkout_customer_id;
            $_SESSION['companyID'] = "1";
            $_SESSION['userID'] = 0;
        }

    }
    $stm-> close();
}

$jccOrderID = $_POST['OrderID'];
if(isset($_GET['removeCard'])){
    header("Location: //".HTML_PATH."/cop/b2b/checkout.php?p=1");
} else if (isset($_POST['MerID'])) {
    //Parameters returned from JCC
    $jccMerID = $_POST['MerID'];
    $jccAcqID = $_POST['AcqID'];
    $jccOrderID = $_POST['OrderID'];
    $jccResponseCode = intval($_POST['ResponseCode']);
    $jccReasonCode = intval($_POST['ReasonCode']);
    $jccReasonDescr = $_POST['ReasonCodeDesc'];
    $jccRef = $_POST['ReferenceNo'];
    $jccPaddedCardNo = $_POST['PaddedCardNo'];
    $jccSignature = $_POST['ResponseSignature'];
    $customerID=$_SESSION['customerID'];


    $status = "Payment Failed";
    if ($jccResponseCode == 1 && $jccReasonCode == 1) {
        $jccAuthNo = $_POST['AuthCode'];
        $status = "Placed";
        $paymentComplete = true;
    } else {
        if(strcmp($jccReasonDescr,'')!=0) {$status = "JCC ".$jccReasonDescr;}
        $paymentComplete = false;
    }

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
    $stmt->bind_param('ssi',$status, $jccOrderID,$customerID);
    $stmt->execute();
    $stmt->close();

    if($paymentComplete) {

        $payedStatus = "Placed";
        $db->set_charset("utf8");
        $stmt = $db->prepare("UPDATE Orders SET status=?,timestamp=NOW() WHERE order_code=? AND customer_id=?");
        $stmt->bind_param('ssi',$payedStatus, $jccOrderID,$customerID);
        $stmt->execute();
        $stmt->close();

        $companyID = 0;
        $salespersonID = $_SESSION['userID'];
        $invoiceID = 0;
        $receiptAddress = 0;
        $amount = 0;
        $cashDiscount = 0;
        $bank = 'JCC Online';
        $branch = "$jccAuthNo";
        $chequeNumber = "$jccPaddedCardNo";
        $chequeDate = date('Y-m-d');


        $receiptDate = date('Y-m-d');
        $paymentMethod ="JCC Online";
        $notes = "For Online Order $jccOrderID";
        $receiptStatus = "Confirmed";

        $stm = $db->prepare("SELECT order_id,delivery_address_id,grand_total FROM Orders WHERE order_code=? AND customer_id=?");
        $stm-> bind_param('si', $jccOrderID,$customerID);
        $stm-> execute();
        $stm-> bind_result($orderID,$receiptAddress,$amount);
        while ($stm->fetch()) {}
        $stm->close();

        $stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
        $stm-> execute();
        $stm-> bind_result($defaultSalesPerson);
        while ($stm->fetch()) {
            if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
                $salespersonID = $defaultSalesPerson;
            } else {
                $salespersonID = 0;
            }
        }
        $stm->close();

        if($amount > 0) {

        $receiptID   = getNextKey("Receipts","receipt_id");
        $receiptCode = getReceiptPrefix("CLOUD").getNextReceiptCode("CLOUD");
        $db->set_charset("utf8");
        $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isiiiiiidsdsssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes,$receiptStatus);
        $stmt->execute();
//        echo $stmt->error;
        $stmt->close();
        setNextReceiptCode("CLOUD");

//        echo "INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes,status) VALUES($receiptID, '$receiptCode', $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, '$paymentMethod', $cashDiscount, '$bank', '$branch', '$chequeNumber', '$chequeDate', '$receiptDate', '$notes','$receiptStatus')<br>";


        $detailsTra="Online Payment Receipt $receiptCode";
        $sign = -1;
        $payment -= $cashDiscount;
        $transactionID = getNextKey("Transactions", "transaction_id");
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
        $stmt->execute();
        $stmt->close();

        updateCustomerBalance($customerID, $amount);
        }
        sendEmail($orderID, $receiptID);
        $pFlag = 1;
    } else {
        $pFlag = 0;
    }


    if(strcmp($_POST['HashValue'],'')!=0){
        $hashValue = "".$_POST['HashValue'];
        $paddedCardNo = "".$_POST['PaddedCardNo'];

        $stmt = $db->prepare("INSERT INTO B2B_User_Cards (user_id, customer_id, padded_card_number, hash_value) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE hash_value=?");
        $stmt->bind_param('iisss', $userID,$customerID,$paddedCardNo,$hashValue,$hashValue);
        $stmt->execute();
        $stmt->close();

    }

//    foreach ($_POST as $key => $value){
//        echo "$key => $value<br>";
//    }
    header("Location: //".HTML_PATH."/cop/b2b/viewsingleorder.php?p=$pFlag&Order=$jccOrderID");

} else {
    header("Location: //".HTML_PATH."/cop/b2b/checkout.php?p=1");

}


function updateCustomerBalance($customerID,$amount)
{
    global $username;
    global $password;
    global $database;
    $db = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}

?>