<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$itemID=$_POST['itemID'];
$orderItemID=$_POST['orderItemID'];
$qty =$_POST['qty'];

if(strcmp($orderID,'')==0){
    $orderID = getAvailableOrderID(0,0,session_id());
    $_SESSION['orderID'] = $orderID;
    $_SESSION['customerID'] = 0;
    $_SESSION['userID'] = 0;

}

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$addItemByUnits = true;
$stm = $db->prepare("SELECT primary_language,show_prices,show_prices_with_vat,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$showPricesIncludingVAT,$orderQtyBySubunits);
while ($stm->fetch()) {
    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }
}
$stm-> close();


if($addItemByUnits) {
    $qty = $qty * floatval(getSubUnits($itemID));
}

if($qty==0) {removeItemFromDropShip($orderItemID,$orderID);}
else{ insertItemInCart($itemID,$orderID,$qty,$customerID); }



if(strcmp($showPricesIncludingVAT,"yes")==0){
    $includeVatOnPrice = true;
} else {
    $includeVatOnPrice = false;
}


$count = 0;
$itemCounter = 0;
$subtotal = 0;
$netTotalLabel = $langu['column_total_label'];
$db->set_charset("utf8");
$stm = $db->prepare("SELECT qty,unit_price,Items.vat_id,Online_Order_Item.item_id FROM Online_Order_Item,Items WHERE  Online_Order_Item.item_id=Items.item_id AND order_id='$orderID'");
$stm->execute();
$stm->bind_result($qty,  $lineUnitPrice,$vatID,$itemID);
while ($stm->fetch()) {


    if($addItemByUnits) {
        $qty = $qty / floatval(getSubUnits($itemID));
    }

    $subtotalLine = $qty * $lineUnitPrice;
    $count += $qty;
    $itemCounter++;

    if($includeVatOnPrice) {
        $vatPercentage = getVatPercentage($vatID);
        $subtotal += $subtotalLine + $subtotalLine * ($vatPercentage / 100);
    } else {
        $subtotal += $subtotalLine;
    }
}
$stm->close();


if(strcmp($showPrices,'no')==0 || $_SESSION['showPrices']==false){
    $showPrices = false;
} else {
    $showPrices = true;
}

if(!isset($_SESSION['lang']))
{
    if(strcmp($primaryLanguage,'')!=0){
        $_SESSION['lang'] = $primaryLanguage;
    } else {
        $_SESSION['lang'] = 'en';
    }
}

include('../langs/'.$_SESSION['lang'].'.php');

$itemsLabel = $langu['item'];
$qtyLabel = $langu['qty'];
$netTotalLabel = $langu['net_total'];

$displaySubTotal = number_format(floatval($subtotal),2);
echo "$counter $itemsLabel - $qtyLabel $count";

if($showPrices){
    echo " $netTotalLabel: $displaySubTotal";
}
?>