<?php
session_start();
$subDirectory = explode('/cop',str_replace($_SERVER['DOCUMENT_ROOT'],'' ,__DIR__ ))[0];

use PHPMailer\PHPMailer\PHPMailer;

//require '../emailer/PHPMailer/Exception.php';
//require '../emailer/PHPMailer/PHPMailer.php';
//require '../emailer/PHPMailer/SMTP.php';

require_once '../emailer/PHPMailer8/vendor/autoload.php';

include_once("../../param.php");


$_SESSION['fpErrorMessage']= "";
 
 $email = filter_var($_POST['username'],FILTER_SANITIZE_EMAIL);
 $email = filter_var($email,FILTER_VALIDATE_EMAIL);
 $fromApp    = trim($_POST['fromApp']);
 
 


 		
 			if(!filter_var($email, FILTER_VALIDATE_EMAIL))
 			{
				$_SESSION['appMessage']="Invalid email address";
                redirect("../forgotpassword.php");
 			}
 			else
 			{
 				if(!isEmailExists($email))
 				{
					$_SESSION['appMessage']="Email address does not exist";
                    redirect("../forgotpassword.php");
 					
 				}
 				else
 				{
 						$token = getToken(20);


						$db = new mysqli(localhost,$username,$password,$database);
						if (mysqli_connect_errno())
						{
							printf("Connect failed: %s\n", mysqli_connect_error());
							exit();
						}
						$db->set_charset("utf8");

						$stmt = $db->prepare("UPDATE B2B_User SET token=? WHERE email=?");
						$stmt->bind_param('ss',$token,$email);
						$stmt->execute();
						$stmt->close();

                        $stm = $db->prepare("SELECT email_host, email_from, email_username, email_password, company_name FROM B2B_Configuration");
                        $stm-> execute();
                        $stm-> bind_result($emailHost,$emailFrom,$emailUsername,$emailPassword,$companyName);
                        while ($stm->fetch()) {}
                        $stm-> close();

						$stm = $db->prepare("SELECT email_template_id, email_text, cc_emails FROM B2B_Email_Templates WHERE email_type = 'Forgot Password'AND default_template = 'yes' AND active = 'yes'");
						$stm-> execute();
						$stm-> bind_result($emailTemplateID, $emailContent, $emailCC);
						while ($stm->fetch()) {}
						$stm-> close();

						$stm = $db->prepare("SELECT username, identifier, CONCAT(first_name, ' ', last_name), token,customer_company_name FROM B2B_User,Customers WHERE Customers.customer_id=B2B_User.customer_id AND B2B_User.email = '$email'");
						$stm-> execute();
						$stm-> bind_result($b2bUsername, $b2bPass, $b2bUser, $token, $customerCompanyName);
						while ($stm->fetch()) {}
						$stm-> close();

						if(empty($emailTemplateID)){

							$emailContent = "<html>
										<head></head>
										<body><div>
											   <br />
											   Dear {b2b_user_name}, <br />
											   <br />
											   You have requested a Password Reset for {company_name} B2B Commerce.<br />
											   To set a new password please follow the link Below.<br />
											   <br />
											   Link: {reset_password_link}<br />
											   <br />
											   If you haven’t requested a new password, please ignore this email. <br />
											   Your account is safe because the person who has made this request<br />
											   will not be able to use your credentials to log into our site.<br />
											   <br />
											   Best Regards,<br />
											   {company_name}
										</body></html>";
							$emailCC      = "";

						} else {
							$emailContent = "<html><head></head><body><div>".$emailContent."</body></html>";
						}

						$passwordLink = "<a href='http://".$_SERVER['HTTP_HOST']."/$subDirectory/cop/b2b/resetpass.php?token=".$token."'>Reset Password</a>";
						$emailSubject =  explode('-', $companyName)[0] . ' - Reset Password Request';

						$actionDetails = "";
						$actionDate = "";
						$grandTotal = "";
						$companyLogo = "";
						$customerCode = "";
						$actionCode = "";

						$emailContent = str_replace("{action_details}"       ,"$actionDetails"      ,"$emailContent");
						$emailContent = str_replace("{action_date}"          ,"$actionDate"         ,"$emailContent");
						$emailContent = str_replace("{grand_total}"          ,"$grandTotal"         ,"$emailContent");
						$emailContent = str_replace("{b2b_user_name}"        ,"$b2bUser"            ,"$emailContent");
						$emailContent = str_replace("{b2b_username}"         ,"$b2bUsername"        ,"$emailContent");
						$emailContent = str_replace("{b2b_user_password}"    ,"$b2bPass"            ,"$emailContent");
						$emailContent = str_replace("{reset_password_link}"  ,"$passwordLink"       ,"$emailContent");
						$emailContent = str_replace("{customer_company_name}","$customerCompanyName","$emailContent");
						$emailContent = str_replace("{company_name}"         ,"$companyName"        ,"$emailContent");
						$emailContent = str_replace("{company_logo}"         ,"$companyLogo"        ,"$emailContent");
						$emailContent = str_replace("{customer_code}"        ,"$customerCode"       ,"$emailContent");
						$emailContent = str_replace("{action_code}"          ,"$actionCode"         ,"$emailContent");

						$mail = new PHPMailer(true);
						$mail->isSMTP();                                      // Set mailer to use SMTP
						$mail->Host = $emailHost;                             // Specify main and backup SMTP servers
						$mail->SMTPAuth = true;                               // Enable SMTP authentication
						$mail->Username = $emailUsername;                     // SMTP username
						$mail->Password = $emailPassword;                     // SMTP password
						$mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
						$mail->Port = 587;                                    // TCP port to connect to
						$mail->CharSet = 'UTF-8';
						$mail->Encoding = "base64";
						$mail->isHTML(true);                                  // Set email format to HTML
						$mail->Subject = $emailSubject;
						$mail->Body = $emailContent;

						//Recipients
						$mail->setFrom($emailFrom, $companyName);
						$mail->addAddress($email, $email);

						$ccArray = explode(';',$emailCC);
						foreach ($ccArray as $cc){
							if(strcmp($cc,'') != 0) {
								$mail->addCC($cc);
							}
						}

						if($mail->send()){
							$_SESSION['appMessage']="We have sent an email to $email which contains instructions on how to reset your password";
							$_SESSION['messagel']="We have sent an email to $email which contains instructions on how to reset your password";
							redirect("../login.php?fp=$email");
						} else {
							$_SESSION['appMessage']= "$mail->ErrorInfo";
							$_SESSION['fpErrorMessage']= $mail->ErrorInfo;
							redirect("../forgotpassword.php");
						}


						

				
				}
		
		
	
			}
	
function redirect($url)
{
	global $fromApp;

	if(strcmp($fromApp,'yes')==0){

		$rawParamArray = explode('&', explode('?', $url)[1]);
		$parameters    = array();

		foreach ($rawParamArray as $parameter) {
			$parameter = explode('=', $parameter);
			$parameters[$parameter[0]] = $parameter[1];
		}

		$response = new stdClass();
		$response->redirectUrl = basename($url);
		$response->function = str_replace('.php','',explode('?',basename($url))[0]);
		$response->parameters = $parameters;
		$response->message = "".$_SESSION['appMessage'];
		$response->sessionID = session_id();

		echo json_encode($response);
	} else {
		if (headers_sent()) {
			die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
		} else {
			header('Location: ' . $url);
			die();
		}
	}
}

function isEmailExists($email)
{
	global $username, $password, $database;
	$db = new mysqli(localhost,$username,$password,$database);
	if (mysqli_connect_errno()) 
	{
		printf("Connect failed: %s\n", mysqli_connect_error());
		exit();
	}
	$numberOfEmail= "";
	$stmt = $db->prepare("SELECT COUNT(*) FROM B2B_User WHERE email = '$email'");
	$stmt->execute();
	$stmt->bind_result($numberOfEmail);
	while ($stmt->fetch()) 
	{
		if($numberOfEmail==0)
		{	
			return false;
		}
		else
		{		
			return true;
		}
	}
}
function crypto_rand_secure($min, $max) {
        $range = $max - $min;
        if ($range < 0) return $min; // not so random...
        $log = log($range, 2);
        $bytes = (int) ($log / 8) + 1; // length in bytes
        $bits = (int) $log + 1; // length in bits
        $filter = (int) (1 << $bits) - 1; // set all lower bits to 1
        do {
            $rnd = hexdec(bin2hex(openssl_random_pseudo_bytes($bytes)));
            $rnd = $rnd & $filter; // discard irrelevant bits
        } while ($rnd >= $range);
        return $min + $rnd;
}

function getToken($length){
    $token = "";
    $codeAlphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    $codeAlphabet.= "abcdefghijklmnopqrstuvwxyz";
    $codeAlphabet.= "0123456789";
    for($i=0;$i<$length;$i++){
        $token .= $codeAlphabet[crypto_rand_secure(0,strlen($codeAlphabet))];
    }
    return $token;
}

?>

