<?php

session_start();

include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");


$categoryID = $_POST['category'];

$sorting = getSorting();
$filters = getCategoryFilters($categoryID);
array_push($filters,$sorting);

if(strcmp($categoryID,'search')!=0 && is_numeric($categoryID)) {
    echo json_encode($filters);
}

function getSorting(){
    if(file_exists('../langs/'.$_SESSION['lang'].'.php')) {
        include('../langs/' . $_SESSION['lang'] . '.php');
    } else {
        include('../langs/en.php');
    }

    $enableSortingByPrice=true;
    if(!isset($_SESSION['customerID'])) {
        $customerID=0;
    }else{
        $customerID=$_SESSION['customerID'];
    }

    global $username, $password, $database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");


    $stm = $db->prepare("SELECT sort_items_by FROM B2B_Page_Catalogue ");
    $stm-> execute();
    $stm-> bind_result($sorting);
    while ($stm->fetch()) {
        if(strcmp($sorting,'')==0){$sorting = "item_code";}
    }
    $stm-> close();

    $stm = $db->prepare("SELECT show_prices,anonymous_order,show_prices_anonymous FROM B2B_Configuration LIMIT 1 ");
    $stm-> execute();
    $stm-> bind_result($showPrices,$anonymousOrder,$showB2BAnonymousPrices);
    while ($stm->fetch()) {
        if(strcmp($anonymousOrder,'yes')==0){
            $allowAnonymousOrder = true;
            if(strcmp($showB2BAnonymousPrices,'yes')==0 && $customerID == 0) {
                $enableSortingByPrice = true;
            } else if(strcmp($showB2BAnonymousPrices,'yes')!=0 && $customerID == 0){
                $enableSortingByPrice = false;
            }
        }

        if(!$allowAnonymousOrder && $customerID == 0 && $enableSortingByPrice == true && strcmp($showB2BAnonymousPrices,'yes')!=0 ){
            $enableSortingByPrice = false;
        }

        if(strcmp($showB2BAnonymousPrices,'yes')==0){
            $enableSortingByPrice = true;
        }

        if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false){
            $enableSortingByPrice=false;
        }
    }
    $stm-> close();

    $sorting = new stdClass();
    $sorting->type   = "sorting";
    $sorting->options= array();

    switch ($sorting){
        case "item_code":
            $name= $langu['sort_by_product_code'];
            break;
        case "name":
            $name= $langu['sort_by_product_name'];
            break;
        case "item_sku":
            $name= $langu['sort_by_product_sku'];
            break;
        case "long_description":
            $name= $langu['sort_by_product_description'];
            break;
        case "Category_Item.position":
            $name= $langu['sort_by_product_category_position'];
            break;
        default:
            $name= "Default";
            break;
    }
    $option1 = new stdClass();
    $option1->name = $name;
    $option1->value = "default";
    $option1->position = 1;
    $sorting->options[] = $option1;

    $option2 = new stdClass();
    $option2->name =$langu['sort_by_newest'];
    $option2->value = "newest";
    $option2->position = 2;
    $sorting->options[] = $option2;


    if($enableSortingByPrice==true){
        $option3 = new stdClass();
        $option3->name =$langu['sort_by_price_desc'];
        $option3->value = "priceDesc";
        $option3->position = 3;

        $option4 = new stdClass();
        $option4->name =$langu['sort_by_price_asc'];
        $option4->value = "priceAsc";
        $option4->position = 4;
        $sorting->options[] = $option3;
        $sorting->options[] = $option4;

    }

    $db->close();

    return $sorting;

}

function getCategoryFilters($categoryID){

    if(file_exists('../langs/'.$_SESSION['lang'].'.php')) {
        include('../langs/' . $_SESSION['lang'] . '.php');
    } else {
        include('../langs/en.php');
    }


    global $username, $password, $database;
    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stm2 = $db2->prepare("SELECT primary_language,theme FROM B2B_Configuration LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($primaryLanguage,$themeColor);
    while ($stm2->fetch()) {

    }
    $stm2-> close();


    $filters = array();
    $stm2 = $db2->prepare("SELECT Filters.filter_id, Filters.filter_code, Filters.name, Filters.description, Filters.type, Filters.class, Filters.css 
                                 FROM Filters,Filter_Category 
                                 WHERE Filters.filter_id=Filter_Category.filter_id 
                                 AND (category_id='$categoryID' OR category_id=1) 
                                 AND Filters.active='yes' 
                                 ORDER BY Filter_Category.position ASC,Filters.position ASC");
    $stm2-> execute();
    $stm2-> bind_result($filterID,$filterCode,$filterName,$filterDescription,$filterType,$filterClass,$filterCss);
    while ($stm2->fetch()) {

        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($filterDescription) && strcmp($filterDescription,'')!=0 )
        {
            $filterName=$filterDescription;
        }

        $filter = new stdClass();
        $filter->id     = $filterID;
        $filter->code   = $filterCode;
        $filter->name   = $filterName;
        $filter->desc   = $filterDescription;
        $filter->type   = $filterType;
        $filter->class  = $filterClass;
        $filter->css    = $filterCss;
        $filter->options= array();
        array_push($filters,$filter);

    }
    $stm2-> close();

    foreach($filters as $filter){
        $filterOptions = array();
        $stm2 = $db2->prepare("SELECT filter_option_id, filter_id, option_name, description,position FROM Filter_Options WHERE filter_id ='$filter->id' AND active='yes' ORDER BY filter_id,position ASC");
        $stm2->execute();
        $stm2->bind_result($filterOptionID,$filterID,$optionName,$optionDescription,$position);
        while ($stm2->fetch()) {
            $filterOption = new stdClass();
            $filterOption->id    = $filterOptionID;
            $filterOption->name  = $optionName;
            $filterOption->desc  = $optionDescription;

            if(strcmp($filter->type,'range')==0 ){
                $filterOption->range = $position;
                $filterOption->position = 0;
            } else {
                $filterOption->range = 0;
                $filterOption->position = $position;
            }



            array_push($filterOptions,$filterOption);

        }

        if(strcmp($filter->type,'price')==0){

            $stm2 = $db2->prepare("SELECT b2b_price_list,b2c_price_list,show_prices_with_vat,use_as_b2c FROM B2B_Configuration LIMIT 1");
            $stm2->execute();
            $stm2->bind_result($b2bPriceList,$b2cPriceList,$priceWithVat,$useAsB2C);
            while ($stm2->fetch()) {}
            $stm2->close();

            $stm2 = $db2->prepare("SELECT pricetype_id FROM PriceTypes WHERE default_type='yes' LIMIT 1 ");
            $stm2->execute();
            $stm2->bind_result($defaultPriceTypeID);
            while ($stm2->fetch()) {}
            $stm2->close();


            $categoryItems = array();
            $stm2 = $db2->prepare("SELECT Category_Item.item_id FROM Category_Item,Items WHERE Category_Item.item_id=Items.item_id AND category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no'");
            $stm2->execute();
            $stm2->bind_result($categoryItemID);
            while ($stm2->fetch()) {array_push($categoryItems,$categoryItemID);}
            $stm2->close();

            $categoryItemsFilter = implode(',',$categoryItems);
            $currencySign = getCurrencySign();
            $priceTypeID = $defaultPriceTypeID;

            if($b2bPriceList > 0 ){$priceTypeID=$b2bPriceList;}
            if($b2cPriceList > 0 && strcmp($useAsB2C,'yes')==0){$priceTypeID=$b2bPriceList;}


            if($priceTypeID > 0 && strcmp($categoryItemsFilter,'')!=0) {

                $stm2 = $db2->prepare("SELECT MAX(price),MIN(price) FROM Prices WHERE pricetype_id='$priceTypeID' AND item_id IN ($categoryItemsFilter) AND price > 0");
                $stm2->execute();
                $stm2->bind_result($maxPrice, $minPrice);
                while ($stm2->fetch()) {}
                $stm2->close();

                if($minPrice < 1){$minPrice = 0;}
                if($maxPrice < 1){$maxPrice = 1;}

                $minRange = round($minPrice);
                $maxRange = round($maxPrice);



            } else {
                $minRange = 1;
                $maxRange = 100;

            }
            $filterOption = new stdClass();
            $filterOption->min = $minRange;
            $filterOption->max = $maxPrice;
            $filterOption->pricetype_id = $priceTypeID;

            array_push($filterOptions,$filterOption);



        }


        $filter->options = $filterOptions;
    }
    $db2->close();

    return $filters;

}

function getSubCategoriesAsFilters($categoryID,$name,$description,$level,$showLevel){
    $result = '';
    if($level <= $showLevel) {

        global $username, $password, $database;

        $db2 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $stm2 = $db2->prepare("SELECT primary_language FROM B2B_Configuration LIMIT 1");
        $stm2-> execute();
        $stm2-> bind_result($primaryLanguage);
        while ($stm2->fetch()) {}
        $stm2-> close();

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT Categories.category_id,name,description FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
        $stm2->execute();
        $stm2->bind_result($subCategoryID, $subName, $descriptionSub);
        while ($stm2->fetch()) {

            if (strcmp($_SESSION['lang'], $primaryLanguage) != 0 && isset($descriptionSub) && strcmp($descriptionSub, '') != 0) {
                $subName = $descriptionSub;
            }

            $subName = ucfirst(strtolower(grstrtolower($subName)));

            $db3 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }

            $stm3 = $db3->prepare("SELECT COUNT(Categories.category_id) FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$subCategoryID\" AND Categories.category_id=Subcategories.subcategory_id");
            $stm3->execute();
            $stm3->bind_result($subCounter);
            while ($stm3->fetch()) {}
            $stm3->close();
            if ($subCounter > 0 && $level < $showLevel) {
                $nextLevel = $level + 1;
                $result .= getSubCategoriesAsFilters($subCategoryID, $subName, $descriptionSub, $nextLevel, $showLevel);
            } else {
                $result .= " <li>
                                    <a style='padding-top:3px;padding-bottom:3px;font-size:13px;text-transform:capitalize;' class='selectCategoryStandard pointer' data-index='$subCategoryID'>$subName
                                    </a>
                                </li>";
            }


        }
        $stm2->close();

    }

    return $result;

}

function uc_without_accents($string, $enc = "utf-8") {
    return strtr(mb_strtoupper($string, $enc),
        array('Ά' => 'Α', 'Έ' => 'Ε', 'Ί' => 'Ι', 'Ή' => 'Η', 'Ύ' => 'Υ',
            'Ό' => 'Ο', 'Ώ' => 'Ω', 'A' => 'A', 'A' => 'A', 'A' => 'A', 'A' => 'A',
            'Y' => 'Y','ΐ' => 'Ϊ'
        ));
}

function grstrtolower($string) {

    $string .= " ";

    $latin_check = '/[\x{0030}-\x{007f}]/u';

    if (preg_match($latin_check, $string))
    {

        $string = strtoupper($string);

    }

    $letters  								= array('α', 'β', 'γ', 'δ', 'ε', 'ζ', 'η', 'θ', 'ι', 'κ', 'λ', 'μ', 'ν', 'ξ', 'ο', 'π', 'ρ', 'σ', 'τ', 'υ', 'φ', 'χ', 'ψ', 'ω');
    $letters_accent 						= array('ά', 'έ', 'ή', 'ί', 'ό', 'ύ', 'ώ');
    $letters_upper_accent 					= array('Ά', 'Έ', 'Ή', 'Ί', 'Ό', 'Ύ', 'Ώ');
    $letters_upper_solvents 				= array('ϊ', 'ϋ');
    $letters_other 							= array('ς');

    $letters_to_uppercase					= array('Α', 'Β', 'Γ', 'Δ', 'Ε', 'Ζ', 'Η', 'Θ', 'Ι', 'Κ', 'Λ', 'Μ', 'Ν', 'Ξ', 'Ο', 'Π', 'Ρ', 'Σ', 'Τ', 'Υ', 'Φ', 'Χ', 'Ψ', 'Ω');
    $letters_accent_to_uppercase 			= array('Ά', 'Έ', 'Ή', 'Ί', 'Ό', 'Ύ', 'Ώ');
    $letters_upper_accent_to_uppercase 		= array('Α', 'Ε', 'Η', 'Ι', 'Ο', 'Υ', 'Ω');
    $letters_upper_solvents_to_uppercase 	= array('Ι', 'Υ');
    $letters_other_to_uppercase 			= array('Σ');

    $lowercase = array_merge($letters, $letters_accent, $letters_upper_accent, $letters_upper_solvents, $letters_other);
    $uppercase = array_merge($letters_to_uppercase, $letters_accent_to_uppercase, $letters_upper_accent_to_uppercase, $letters_upper_solvents_to_uppercase, $letters_other_to_uppercase);

    $uppecase_string = str_replace($uppercase,$lowercase, $string);
    $uppecase_string = str_replace('σ ', 'ς ', $uppecase_string);


    return $uppecase_string;

}

?>