<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");
$currencySign = B2B_CURRENCY_SYMBOL;
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$subunitsForce = $_SESSION['subunitsForce'];
if(isset( $_POST['gridPreference']) && strcmp($_POST['gridPreference'],"")!=0)
{
    $gridPreference = $_POST['gridPreference'];
    $_SESSION['gridPreference'] = $gridPreference;
}
else {
    $gridPreference = $_SESSION['gridPreference'];
}
$popularItemsSelection = $_POST['popularItemsSelection'];
$pageNumber = $_POST['pageNumber'];
$numOfItemsInPage=$_POST['numItemsInPage'];
$offset=($pageNumber-1)*$numOfItemsInPage;

$orderBy = "item_code";
$orderBy2= "item_code";
if(isset($_POST['sorting']))
{
    $orderBy =$_POST['sorting'];
    $orderBy2=$_POST['sorting'];
} else {
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT sort_items_by,include_subcategory_products FROM B2B_Page_Catalogue LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($orderBySelection,$includeSubcategoryProducts);
    while ($stm->fetch()) {
        if(strcmp($orderBySelection,'Category_Item.position')==0){
            $orderBy2 = $orderBySelection;
        }
    }
    $stm->close();
}

$detect = new Mobile_Detect;

if ( $detect->isMobile() ) {
    $gridPreference = "mobile";
}

if ( $detect->isTablet() ) {
    $gridPreference = "tablet";
}

if ( isset($_SESSION['app']) && strcmp($_SESSION['app'],'yes')==0 ) {
    $gridPreference = "app";
}

$extraCredit = false;
$showPricesWithVAT=false;



if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}

include('../langs/'.$_SESSION['lang'].'.php');

$statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE NOT status='inactive' AND NOT sellable='no' LIMIT 50";

//$statement = "SELECT Items.item_id,item_code,item_sku,name FROM Items,Item_Images WHERE NOT status='inactive' AND Items.item_id=Item_Images.item_id LIMIT 50";
$statementCount ="SELECT COUNT(*) FROM Items LIMIT 50";
if(isset($_POST['category']))
{
    $categoryID = $_POST['category'];




    if(strcmp($categoryID,"1")==0)
    {
        $categoryID=10000;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
        $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
    }
    else if(strcmp($categoryID,"2")==0)
    {

        if(false) {
            $categoryID=10000;
            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
            //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
            $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
        } else {

            $db = new mysqli('localhost',$username,$password,$database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT popular_products_from FROM B2B_Page_Catalogue LIMIT 1");
            $stm-> execute();
            $stm-> bind_result($popularItemsSelection);
            while ($stm->fetch()) {}
            $stm->close();

            $categoryID=2;
            switch($popularItemsSelection) {
                case 1:
                    $statement = "SELECT ERP_Popular_Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,ERP_Popular_Items WHERE ERP_Popular_Items.item_id = Items.item_id AND NOT status='inactive' AND NOT sellable='no' AND customer_id='$customerID' GROUP BY ERP_Popular_Items.item_id ORDER BY COUNT(ERP_Popular_Items.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                    $statementCount = "SELECT COUNT(DISTINCT ERP_Popular_Items.item_id) FROM Items,ERP_Popular_Items WHERE ERP_Popular_Items.item_id = Items.item_id AND NOT status='inactive' AND NOT sellable='no' AND customer_id='$customerID'";
                    break;
                case 2:
                    $statement = "SELECT Invoice_Item.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Invoice_Item,Invoices WHERE Invoice_Item.item_id = Items.item_id AND Invoices.invoice_id=Invoice_Item.invoice_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' GROUP BY Invoice_Item.item_id ORDER BY COUNT(Invoice_Item.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                    $statementCount = "SELECT COUNT(DISTINCT Invoice_Item.item_id) FROM Items,Invoice_Item,Invoices WHERE Invoice_Item.item_id = Items.item_id AND Invoices.invoice_id=Invoice_Item.invoice_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID'";
                    break;
                default:
                    $statement = "SELECT Order_Item.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Order_Item,Orders WHERE Order_Item.item_id = Items.item_id AND Orders.order_id=Order_Item.order_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID' GROUP BY Order_Item.item_id ORDER BY COUNT(Order_Item.item_id) DESC  LIMIT $numOfItemsInPage OFFSET $offset ";
                    $statementCount = "SELECT COUNT(DISTINCT Order_Item.item_id) FROM Items,Order_Item,Orders WHERE Order_Item.item_id = Items.item_id AND Orders.order_id=Order_Item.order_id AND NOT Items.status='inactive' AND NOT Items.sellable='no' AND customer_id='$customerID'";

            }

        }
    }
    else if(strcmp($categoryID,"3")==0)
    {
        $categoryID=5;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
        //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
        $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
    }
    else if(strcmp($categoryID,"12")==0)
    {
        $categoryID=12;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE timestamp BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() AND NOT status='inactive' AND NOT sellable='no' ORDER BY $orderBy LIMIT $numOfItemsInPage OFFSET $offset";
        //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
        $statementCount="SELECT COUNT(*) FROM Items  WHERE Items.timestamp BETWEEN CURDATE() - INTERVAL 30 DAY AND CURDATE() AND NOT status='inactive' AND NOT sellable='no'";
    }
    else if(strcmp($categoryID,"-12")==0)
    {
        $categoryID=-12;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Item_Back_In_Stock WHERE Items.item_id = Item_Back_In_Stock.item_id AND NOT status='inactive' AND NOT sellable='no' AND (back_in_stock_date BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW()) ORDER BY $orderBy LIMIT $numOfItemsInPage OFFSET $offset";
        //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
        $statementCount="SELECT COUNT(*) FROM Item_Back_In_Stock,Items  WHERE NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Item_Back_In_Stock.item_id AND (back_in_stock_date BETWEEN DATE_SUB(NOW(), INTERVAL 10 DAY) AND NOW())";
    }
    else if(strcmp($categoryID,"-10")==0)
    {
        $categoryID=-10;
        $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE  NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' ORDER BY item_code LIMIT $numOfItemsInPage OFFSET $offset";
        //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
        $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
    }
    else {

        if (strcmp($includeSubcategoryProducts, 'yes') == 0) {

            $categories = $categoryID.getSubCategoriesID($categoryID);
            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id IN ($categories) GROUP BY Items.item_id ORDER BY $orderBy2  LIMIT $numOfItemsInPage OFFSET $offset";
            //$statement = "SELECT item_id,item_code,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
            $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id IN ($categories) AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";

        } else {

            $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' ORDER BY $orderBy2 LIMIT $numOfItemsInPage OFFSET $offset";
            //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
            $statementCount = "SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";

        }
    }
}
else if(isset($_POST['search']))
{
    if(strcmp(trim(str_replace(' ','',$_POST['text'])),'')==0){return;}
    $text =$_POST['text'];
    $keyword_tokens = trim($_POST['text']);

    $text = str_replace("'","%",$text);
    $keyword_tokens = str_replace("'","%",$keyword_tokens);

    $pageNumber = $_POST['pageNumber'];
    $numOfItemsInPage=$_POST['numItemsInPage'];
    $categorySelect = $_POST['categorySelect'];
    $whereCategory="";
    if($categorySelect>0)
    {
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id=\"$categorySelect\") AND ";
    }

    $allowedCategories="1";
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $userID=  $_SESSION['userID'] ;

    if($userID > 0){
        $stm = $db2->prepare("SELECT category_id FROM B2B_Allow_Categories_User WHERE b2b_user_id='$userID'");
        $stm-> execute();
        $stm-> bind_result($categoryAllowedID);

        while ($stm->fetch()) {
            $allowedCategories.=",$categoryAllowedID";
            $allowedCategories.= getSubCategoriesID($categoryAllowedID);
        }
        $stm-> close();
    } else {
        $stm = $db2->prepare("SELECT category_id FROM B2B_Categories");
        $stm-> execute();
        $stm-> bind_result($categoryAllowedID);

        while ($stm->fetch()) {
            $allowedCategories.=",$categoryAllowedID";
            $allowedCategories.= getSubCategoriesID($categoryAllowedID);
        }
        $stm-> close();
    }


    if(strcmp($allowedCategories,"1")!=0)
    {
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) AND ";
    } else {
        $stm = $db2->prepare("SELECT category_id FROM B2B_Categories");
        $stm-> execute();
        $stm-> bind_result($categoryAllowedID);

        while ($stm->fetch()) {
            $allowedCategories.=",$categoryAllowedID";
            $allowedCategories.= getSubCategoriesID($categoryAllowedID);
        }
        $stm-> close();
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) AND ";
    }




    $offset=($pageNumber-1)*$numOfItemsInPage;


    $keyword_tokens = explode(' ', $keyword_tokens);



    $final_text = implode(' ',$keyword_tokens);

//$statement = "SELECT item_id,item_code,item_sku,name,MATCH(name) AGAINST('$keyword_tokens') AS score FROM Items WHERE NOT status =\"inactive\" AND MATCH(name) AGAINST('$final_text') ORDER BY score DESC  LIMIT $numOfItemsInPage OFFSET $offset";

    $statement  = "SELECT item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" AND( item_code LIKE '%";
    $statement .= implode("%' AND item_code LIKE '%", $keyword_tokens)    ."%' OR name LIKE '%";
    $statement .= implode("%' AND name LIKE '%", $keyword_tokens) ."%' OR item_sku LIKE '%";
    $statement .= implode("%' AND item_sku LIKE '%", $keyword_tokens) ."%'  OR long_description LIKE '%";
    $statement .= implode("%' AND long_description LIKE '%", $keyword_tokens) ."%'  OR short_description LIKE '%";
    $statement .= implode("%' AND short_description LIKE '%", $keyword_tokens) ."%'";
    $statement .=") ORDER BY CASE";
    $statement.=" WHEN item_code = '$final_text' THEN 1";
    $statement.=" WHEN name = '$final_text' THEN 1";
    $statement.=" WHEN item_sku = '$final_text' THEN 1";
    $statement.=" WHEN item_code LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN short_description LIKE '$final_text%' THEN 2";
    $statement.=" WHEN short_description LIKE '%$final_text%' THEN 3";
    $statement.=" WHEN item_code LIKE '%$final_text%' THEN 3  WHEN item_code LIKE '%";
    $statement .= implode("%'THEN 4 WHEN item_code LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statement.=" WHEN name LIKE '$final_text%' THEN 2";
    $statement.=" WHEN name LIKE '%$final_text%' THEN 3  WHEN name LIKE '%";
    $statement .= implode("%'THEN 4 WHEN name LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statement.="  ELSE 6 END,$orderBy LIMIT $numOfItemsInPage OFFSET $offset";


    $statementCount  = "SELECT COUNT(item_id) FROM Items WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" AND( item_code LIKE '%";
    $statementCount .= implode("%' AND item_code LIKE '%", $keyword_tokens)    ."%' OR name LIKE '%";
    $statementCount .= implode("%' AND name LIKE '%", $keyword_tokens) ."%' OR item_sku LIKE '%";
    $statementCount .= implode("%' AND item_sku LIKE '%", $keyword_tokens) ."%'  OR long_description LIKE '%";
    $statementCount .= implode("%' AND long_description LIKE '%", $keyword_tokens) ."%'  OR short_description LIKE '%";
    $statementCount .= implode("%' AND short_description LIKE '%", $keyword_tokens) ."%'";





    $statementCount .=") ORDER BY CASE";
    $statementCount.=" WHEN item_code = '$final_text' THEN 1";
    $statementCount.=" WHEN name = '$final_text' THEN 1";
    $statementCount.=" WHEN item_sku = '$final_text' THEN 1";
    $statementCount.=" WHEN item_code LIKE '$final_text%' THEN 2";
    $statementCount.=" WHEN name LIKE '$final_text%' THEN 2";
    $statementCount.=" WHEN name LIKE '%$final_text%' THEN 3";
    $statementCount.=" WHEN item_code LIKE '%$final_text%' THEN 3  WHEN item_code LIKE '%";
    $statementCount .= implode("%'THEN 4 WHEN item_code LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statementCount.=" WHEN name LIKE '$final_text%' THEN 2";
    $statementCount.=" WHEN name LIKE '%$final_text%' THEN 3  WHEN name LIKE '%";
    $statementCount .= implode("%'THEN 4 WHEN name LIKE '%", $keyword_tokens)."%' THEN 4 ";
    $statementCount.="  ELSE 6 END";


}
else if(isset($_POST['advancedSearch']))
{
    $customTableName = $_POST['custTable'];

    $customTable = " INNER JOIN $customTableName ON (Items.item_id=$customTableName.id) ";

    require_once(ROOT . "backend/core/model/CustomTable.php");
    $custTable = new CustomTable('Items');
    $custTableFields = $custTable->getCustomTableB2BFields($_POST['ctid']);

    $pageNumber = $_POST['pageNumber'];
    $numOfItemsInPage=$_POST['numItemsInPage'];
    $categorySelect = $_POST['categorySelect'];
    $whereCategory="";
    if($categorySelect>0)
    {
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id=\"$categorySelect\") AND ";
    }

    $allowedCategories="1";
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $userID=  $_SESSION['userID'] ;

    if($userID > 0){
        $stm = $db2->prepare("SELECT category_id FROM B2B_Allow_Categories_User WHERE b2b_user_id='$userID'");
        $stm-> execute();
        $stm-> bind_result($categoryAllowedID);

        while ($stm->fetch()) {
            $allowedCategories.=",$categoryAllowedID";
            $allowedCategories.= getSubCategoriesID($categoryAllowedID);
        }
        $stm-> close();
    } else {
        $stm = $db2->prepare("SELECT category_id FROM B2B_Categories");
        $stm-> execute();
        $stm-> bind_result($categoryAllowedID);
        while ($stm->fetch()) {
            $allowedCategories.=",$categoryAllowedID";
            $allowedCategories.= getSubCategoriesID($categoryAllowedID);
        }
        $stm-> close();
    }


    if(strcmp($allowedCategories,"1")!=0 && $categorySelect == '')
    {
        $whereCategory=" item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id IN($allowedCategories)) AND ";
    } else {
        $categoryID = $categorySelect;
    }




    $offset=($pageNumber-1)*$numOfItemsInPage;


    $statement  = "SELECT item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items $customTable WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" ";
    $statementCount  = "SELECT COUNT(item_id) FROM Items $customTable WHERE $whereCategory NOT status =\"inactive\" AND NOT sellable=\"no\" ";

    foreach ($custTableFields as $custTableField) {
        if(strcmp($_POST["$custTableField->customTableField"],'')!=0) {
            $statement .= " AND $customTableName.$custTableField->customTableField='" . $_POST["$custTableField->customTableField"] . "' ";
            $statementCount .= " AND $customTableName.$custTableField->customTableField='" . $_POST["$custTableField->customTableField"] . "' ";
        }
    }

    $statement .= " LIMIT $numOfItemsInPage OFFSET $offset";


}
else{
    $categoryID=10000;
    $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND NOT status='inactive' AND NOT sellable='no' AND category_id='$categoryID' ORDER BY item_code LIMIT $numOfItemsInPage OFFSET $offset";
    //$statement = "SELECT item_id,item_code,item_sku,name FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryID')";
    $statementCount="SELECT COUNT(*) FROM Category_Item,Items  WHERE category_id='$categoryID' AND NOT status='inactive' AND NOT sellable='no' AND Items.item_id = Category_Item.item_id";
}

$result="";

$result = $result . $tableTop;

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$showPrices=true;
$maxStockAlert=true;
$useMaxStockOnItems=false;
$includeVatOnPrice=false;
$isB2C = false;
$showAnonymousPrices = false;
$allowAnonymousOrder = false;
$stm = $db->prepare("SELECT product_code_to_show,use_packing,primary_language,show_prices,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,show_prices_anonymous,b2b_price_list,b2c_price_list,b2b_offer_price_list,b2c_offer_price_list,anonymous_order,use_as_b2c,theme FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($productShow,$usePacking,$primaryLanguage,$showPrices,$useMaxStock,$allowOrderOverStock,$maxStockLimit,$showPricesIncludingVAT,$showB2BAnonymousPrices,$fromB2BPriceList,$fromB2CPriceList,$offerB2BPriceList,$offerB2CPriceList,$anonymousOrder,$useAsB2C,$themeColor);

while ($stm->fetch()) {

    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
        if(strcmp($showB2BAnonymousPrices,'yes')==0 && $customerID == 0) {
            $_SESSION['showPrices'] = true;
        } else if(strcmp($showB2BAnonymousPrices,'yes')!=0 && $customerID == 0){
            $_SESSION['showPrices'] = false;
        }
    }

    if(!$allowAnonymousOrder && $customerID == 0 && $_SESSION['showPrices'] == true && strcmp($showB2BAnonymousPrices,'yes')!=0 ){
        $_SESSION['showPrices'] = false;
    }

    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}

    if(strcmp($showB2BAnonymousPrices,'yes')==0){
        $showAnonymousPrices = true;
        $_SESSION['showPrices'] = true;
    }

    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($allowOrderOverStock,"yes")==0)
    {
        $maxStockAlert=false;
    }
    if(strcmp($useMaxStock,"yes")==0)
    {
        $useMaxStockOnItems=true;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }

    $themeColor = strtolower($themeColor);

}
$stm-> close();

if(strcmp($themeColor,'')!=0){
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
        $themeColor = "firebrick";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
        $themeColor = "goldenrod";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if((strcmp($themeColor, 'black') == 0) || (strcmp($themeColor, 'Black') == 0)){
        $themeColor = "black";
        $textColor = "white";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }

} else {
    $themeColor = "#6796d3";
}

$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,promotion_everywhere FROM B2B_Page_Catalogue");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$promotionsEveryWhere);

while ($stm->fetch()) {

}
$stm-> close();


if(isset($categoryID)) {

    $stm = $db->prepare("SELECT COUNT(category_id),banner_text FROM B2B_Categories_Promotions WHERE category_id='$categoryID'");
    $stm-> execute();
    $stm-> bind_result($counter,$bannetText);

    while ($stm->fetch()) {
        if($counter>0)
        {
            $extraCredit=true;
        }

    }
    $stm-> close();

}
$styleHidden="btn ";
if($extraCredit)
{
    $styleHidden="hidden";
}

$stm = $db->prepare($statementCount);
$stm-> execute();
$stm-> bind_result($count);

while ($stm->fetch()) {
    $result.="<input id='counter' value='$count' type='hidden'/>";
}
$stm-> close();

if(!isset($count))
{


    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");



    $stm2 = $db2->prepare("SELECT category_id FROM B2B_Categories WHERE category_id>1000 ORDER BY position LIMIT 1");
    $stm2-> execute();
    $stm2-> bind_result($categoryID);

    while ($stm2->fetch()) {

    }
    $stm2-> close();

    $statement = "SELECT Items.item_id,item_code,item_sku,name,short_description,long_description,thumbnail_url,sellable FROM Items,Category_Item WHERE Items.item_id = Category_Item.item_id AND category_id='$categoryID' LIMIT $numOfItemsInPage OFFSET $offset";

    $statementCount="SELECT COUNT(*) FROM Category_Item  WHERE category_id='$categoryID'";


    $stm2 = $db2->prepare($statementCount);
    $stm2-> execute();
    $stm2-> bind_result($count);

    while ($stm2->fetch()) {
        $result.="<input id='counter' value='$count' type='hidden'/>";
    }
    $stm2-> close();

    $result.="<input id='counter' value='$count' type='hidden'/>";
}

if($extraCredit)
{
    $result = $result . $bannetText;
}

if(isset($_POST['title']))
{
    $result = $result . $_POST['title'];
}

$testFile=fopen('getItemsStatement.txr', 'w');
fwrite($testFile,"$statement");
fclose($testFile);

$userID=$_SESSION['userID'];
if($userID > 0) {
    $stm = $db->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID'");
    $stm->execute();
    $stm->bind_result($isB2CUser);
    while ($stm->fetch()) {
    }
    $stm->close();

    if (strcmp($isB2CUser, "yes") == 0 && $isB2C) {
        $isB2C = true;
    } else {
        $isB2C = false;
    }
}

$stm = $db->prepare("$statement");
$stm-> execute();
$stm-> bind_result($itemID,$itemCode,$itemSKU,$name,$shortDescription,$longDescription,$thumbnail_url,$b2bAvailable);

$i = 0;
if(isset($_POST['category']))
{
    $categoryID = $_POST['category'];
    $result = $result."<input id='loadedCategory' type='hidden' value='$categoryID'/>";
}
while ($stm->fetch()) {

    if(strcmp($b2bAvailable,'notavailable')==0){
        $notCurrentlyAvailable=$langu['not_available_label'];
        $name ="<span style='color:firebrick;font-size: 14px;'>$notCurrentlyAvailable</span><br>$name";
        $grayImage = "filter: gray; -webkit-filter: grayscale(1); filter: grayscale(1); ";
        $grayBox = '#ffffff';
        $disabledButton = 'disabled readonly';
        $hidePlusMinus = "display:none;";
        $stock = 0;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $grayImage = '';
        $grayBox = '#ffffff';
        $disabledButton = '';
        $hidePlusMinus = "border-radius:10%;padding:12px;width:40px !important;height:40px !important;font-weight:bolder;color:$themeColor;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" '";
        $stock = 0;
    } else {
        $grayImage = '';
        $grayBox = '#ffffff';
        $disabledButton = '';
        $hidePlusMinus = "border-radius:10%;padding-top:12px;width:40px !important;height:40px !important;font-weight:bolder;color:$themeColor;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" '";
        $stock = getStock($itemID);
    }

    $i++;
    $imageUrl = "//" . HTML_PATH . "/cop/media/productImages/" . $thumbnail_url . ".jpg";

    $z = "//" . HTML_PATH . "/cop/media/productImages/$thumbnail_url.jpg";
    $rz = ROOT."/media/productImages/$thumbnail_url.jpg";
    if(!file_exists("../".$rz) && !file_exists($rz))
    {
        $z = "//" . HTML_PATH . "/cop/media/productImages/$thumbnail_url.png";
        $rz = ROOT."/media/productImages/$thumbnail_url.png";
    }

    if(!file_exists($rz))
    {
        $imageUrl = "./assets/img/noimage.jpg";
    }



    if(isset($fromB2BPriceList) && $fromB2BPriceList > 0 && !$isB2C) {
        $b2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2BPriceList,$isB2C);
    }

    if(isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C) {
        $offerB2bPrice = getDefaultPriceFromPriceType($itemID,$customerID, $offerB2BPriceList,$isB2C);
    }

    if(isset($fromB2CPriceList) && $fromB2CPriceList > 0 && $isB2C) {
        $b2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $fromB2CPriceList,$isB2C);
    }

    if(isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C) {
        $offerB2cPrice = getDefaultPriceFromPriceType($itemID,$customerID, $offerB2CPriceList,$isB2C);
    }

    if(isset($b2bPrice) && $b2bPrice > 0){
        $price =  $b2bPrice;
    } else if(isset($b2cPrice) && $b2cPrice > 0){
        $price =  $b2cPrice;
    } else {
        $price = getDefaultPrice($itemID,$customerID);
    }

    if(isset($offerB2BPriceList) && $offerB2BPriceList > 0 && !$isB2C){
        $offerPrice =  $offerB2bPrice;
    } else if(isset($offerB2CPriceList) && $offerB2CPriceList > 0 && $isB2C){
        $offerPrice =  $offerB2cPrice;
    } else {
        $offerPrice = $price;
    }

    if($offerPrice < $price && $offerPrice > 0){
        $hasOffer = true;
    } else {
        $hasOffer = false;
    }

    $price = number_format(floatval($price),2);
    $offerPrice = number_format(floatval($offerPrice),2);


    if($hasOffer){
        $prevPrice = $price;
        $price = $offerPrice;

    } else {
        $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID);
        if($defaultPrice > $price && $defaultPrice > 0 && !$isB2C){
            $prevPrice = number_format(floatval($defaultPrice),2);
        } else {
            $prevPrice = '';
        }

    }

    if($prevPrice > $price && $price > 0){
        $percentDiscount = round((1 - ($price/$prevPrice))*100);
        $discountLabel = "<span style='height: 24px;vertical-align: top;margin-bottom: 0px;font-size: 17px;padding-top: 1px;border-radius: 10%;' class='pull-right btn-theme'><center>-$percentDiscount%</center></span>";
    } else {
        $discountLabel = "";
    }



    $qty = getQtyFromCart($orderID, $itemID);

    $subUnits=getSubUnits($itemID);
    if(strcmp($productShow,'barcode')==0)
    {
        $itemCode = $longDescription;
    }
    if(strcmp($productShow,'sku')==0)
    {
        $itemCode = $itemSKU;
    }
    if(strcmp($productShow,'none')==0){
        $itemCode = '<br>';
    }
    $packing=1;
    if(strcmp($usePacking,'yes')==0)
    {
        $packing = getPacking($itemID);
    }

    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }

    if($showPricesWithVAT) {
        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT Vats.percentage FROM Vats,Items WHERE Vats.vat_id=Items.vat_id AND Items.item_id='$itemID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($vatPercent);
        while ($stm2->fetch()) {
            $vat = (float)$price * ($vatPercent / 100);
            $priceWithVAT =  number_format((float)$price + $vat,2);
            $prevPriceWithVAT =  number_format((float)$prevPrice + $vat,2);
            $inc = $langu['incl_label'];
            $vat = $langu['vat_label'];
            $PriceWithVatText = "<span  style='font-size: 11px;color: #0aa66e '>$currencySign$priceWithVAT &nbsp;$inc $vat</span>";

        }
        $stm2->close();
        if(strcmp($prevPrice,'')!=0 && $prevPrice > 0) {
            if ($includeVatOnPrice) {
                $prevPrice = "<del style='color: gray;'>$currencySign$prevPriceWithVAT</del><br>";
            } else {
                $prevPrice = "<del style='color: gray;'>$currencySign$prevPrice</del><br>";
            }
        } else {
            $prevPrice = "<del></del><br>";
        }

    } else {
        if(strcmp($prevPrice,'')!=0 && $prevPrice > 0) {
            $prevPrice = "<del style='color: gray;'>$currencySign$prevPrice</del><br>";
        } else {
            $prevPrice = "<del></del><br>";
        }
    }

    if($showAnonymousPrices){
        if($price > 0) {
            $pricing = "$currencySign$price<br>$PriceWithVatText";
            if ($includeVatOnPrice) {
                $pricing = "$currencySign$priceWithVAT";
            }

            $anonymousPricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>";
        } else {
            if(strcmp($PriceWithVatText,'')!=0){$PriceWithVatText="<br>";}
            $anonymousPricesText = " <div class='price'><ins><br><br>$PriceWithVatText</ins></div>";
        }
    } else {
        $anonymousPricesText = '';
    }

    if($useMaxStockOnItems) {
        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $itemMaxStock = 0;
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT max_stock,vat_id FROM Items WHERE item_id='$itemID' LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($itemMaxStock, $vatID);
        while ($stm2->fetch()) {}
        $stm2->close();


    }

    if($maxStockLimit > 0 && $maxStockAlert){

        if($maxStockLimit < $stock) {
            $maxstock = $maxStockLimit;
            $isFromLimit = true;
        } else {
            $maxstock = $stock;
            $isFromLimit = false;
        }
        if($maxstock > $itemMaxStock && $useMaxStockOnItems && $itemMaxStock > 0){
            $maxstock = $itemMaxStock;
            $isFromLimit = true;
        }
    }

    if ($maxStockAlert) {
        if($qty > $maxstock && $qty > 0){
            if($isFromLimit){
                $stockTextOverAlert = "<div style='height: 20px;'><span style='color: firebrick;font-weight:bold;margin-top:0px;width: 100%;display:inline-block;' class='insStock'>" . $langu['no_orders_allowed_over'] . " $maxstock " .$langu['pieces'].  "!</span><input type='hidden' id='max$itemID' value='$maxstock'></div>";
            } else {
                $stockTextOverAlert = "<div style='height: 20px;'><span style='color: firebrick;font-weight:bold;margin-top:0px;width: 100%;display:inline-block;' class='insStock'>" . $langu['insufficient_stock'] . "!</span><input type='hidden' id='max$itemID' value='$maxstock'></div>";
            }
        } else {
            $stockTextOverAlert = "<div style='height: 20px;'><span style='color: firebrick;font-weight:bold;margin-top:0px;width: 100%;display:none;' class='insStock'>" . $langu['insufficient_stock'] . "!</span><input type='hidden' id='max$itemID' value='$maxstock'></div>";
        }
    }


    if(($customerID!=0 || $allowAnonymousOrder)&&onAfterCartPromotion($itemID,$customerID)&&(strcmp($extraCredit,"yes")==0||strcmp($promotionsEveryWhere,"yes")==0))
    {
        $mixandmatchButton = $langu['mix_and_match_button'];

        $promotions = getAvailableAfterCartPromotions($itemID,$customerID);
        $promotionText= "<button style='display:inline-block;height:24px;padding-top:2px;padding-bottom:2px;padding-left:5px;padding-right:5px;margin-left:5px;' class=' btn btn-invoice abc' data-toggle='popover-x' data-target='#myPopover1$itemID' data-placement='top'>$mixandmatchButton</button>
                <div id='myPopover1$itemID' class='popover popover-x popover-default' >
                    <div class='arrow'></div>
                    <h3 style='background-color: #008080;padding:10px;color:#ffffff;' class='popover-header popover-title'><span style='margin-left:10px;margin-bottom:10px;' class='close'  data-dismiss='popover-x'>&times;</span>".$langu['available_promotions']."</h3>
                    <div class='popover-body popover-content' style='padding:5px;' >
                       <table style='width:100%'>
                   <thead> 
                 
                      </thead>  <tbody>  ";


        $title="'<div class=\'row\'><div class=\'col-sm-12 col-md-12 col-lg-12\'><h3 style=\'background-color: #008080;padding:10px;color:#ffffff;font-size:16px;margin-bottom:0\' >Mix and Match Info <span onclick=\'getItemsInCategory($categoryID,1,96);\' class=\'btn btn-primary\' style=\'position:absolute;right:20px;top:22px\'>Back to Products</span></h3><table class=\'table table-striped\'><tr><th style=\'color:#222222;font-weight:bold;text-align:right\'>Qty</th><th style=\'color:#222222;font-weight:bold;text-align:right\'>Discount(%)</th><th style=\'color:#222222;font-weight:bold;text-align:right\'>Qty in Cart</th></tr>";

        $firstTime = true;

        foreach ($promotions as $promotion)
        {


            if($firstTime)
            {
                $promotionCategory=$promotion->categoryID;

                $db2 = new mysqli('localhost', $username, $password, $database);
                if (mysqli_connect_errno()) {
                    printf("Connect failed: %s\n", mysqli_connect_error());
                    exit();
                }
                $db2->set_charset("utf8");

                $stm2 = $db2->prepare("SELECT SUM(qty) FROM Online_Order_Item,Items,Category_Item WHERE Category_Item.category_id='$promotionCategory' AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND Online_Order_Item.promotion_number=0");
                $stm2->execute();
                $stm2->bind_result($promoQtyTotal);

                while ($stm2->fetch()) {


                }
                $stm2->close();

                $title.="<tr><td style=\'text-align:right\'>$promotion->qty</td><td style=\'text-align:right\'>$promotion->discount</td><td  style=\'text-align:right;font-weight:bold;color: #222222;\'><span class=\'mix$promotion->categoryID\'>$promoQtyTotal</span></td>";
            }
            else
            {
                $title.="<tr><td style=\'text-align:right\'>$promotion->qty</td><td style=\'text-align:right\'>$promotion->discount</td><td style=\'text-align:right\'></td>";
            }



            $firstTime = false;
        }

        $title.="</table></div></div>'";

        foreach ($promotions as $promotion)
        {



            $promotionText.=" <tr>
                      
                       <td style='padding:5px;'> <a class=\"btn btn-primary center-canvas\" style=\"width:100%\" onclick=\"document.getElementById('myPopover1$itemID').style.display='none';getItemsInCategoryMixAndMatch($promotion->categoryID,1,96,$title);\">$promotion->name</a> </td>                     
                    </tr>";
        }



        $promotionText.="
                    
                    </tbody>
                   </table>
                   
                    </div>
                </div>$discountLabel";
    }
    else  if(($customerID!=0 || $allowAnonymousOrder)&&onPromotion($itemID,$customerID)&&(strcmp($extraCredit,"yes")==0||strcmp($promotionsEveryWhere,"yes")==0))
    {
        $mixandmatchButton = $langu['promotion_button'];

        $promotions = getAvailablePromotions($itemID,$customerID);
        $promotionText= "<button style='display:inline-block;height:24px;padding-top:2px;margin-left:5px;padding-left: 5px; padding-right: 5px;' class=' btn btn-invoice abc' data-toggle='popover-x' data-target='#myPopover1$itemID' data-placement='top'  >$mixandmatchButton</button>
                <div id='myPopover1$itemID' class='popover popover-x popover-default' >
                    <div class='arrow'></div>
                    <h3 style='background-color: #008080;padding:10px;color:#ffffff;' class='popover-header popover-title'><span style='margin-left:10px;margin-bottom:10px;' class='close'  data-dismiss='popover-x'>&times;</span>".$langu['available_promotions']."</h3>
                    <div class='popover-body popover-content' style='padding:5px;' >
                       <table style='width:100%'>
                   <thead> 
                   
                      </thead>  <tbody>  ";


        foreach ($promotions as $promotion)
        {



            $promotionText.=" <tr>
                      
                       <td style='padding:5px;'> <a class=\"btn btn-primary center-canvas\" style=\"width:100%\" onclick=\"document.getElementById('myPopover1$itemID').style.display='none';addPromotionToCart($promotion->id,$itemID);\">$promotion->name</a> </td>                     
                    </tr>";
        }



        $promotionText.="
                    
                    </tbody>
                   </table>
                   
                    </div>
                </div>$discountLabel";
    }
    else{

        $promotionText="<div style='height:24px;'>$discountLabel</div>";

    }




    if (strcmp($gridPreference,'grid')==0) {

        $result = $result . "<div class='col-md-2 col-sm-6 ' id='div$i' style='background-color:$grayBox;margin-top:10px;border: #f4f4f4 1px solid;'>

                                       

                                        <div class='thumbnail no-border no-padding'>
                                        
                                            <div class='media '>
                                            
                                          
                                                  $promotionText                                      
                                          
                                               
                                                <a class='media-link' style='height:100px;' href='#' data-featherlight='$imageUrl'>
                                                    <img class='img-fluid' src='$imageUrl' alt='' style='max-height:100px;width:auto;margin-top:5px;$grayImage' />
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>    

                                            <div class='caption text-center'>
                                                <input type='hidden' value='$itemID'/>
                                          <p style='line-height: 1.5em;    height: 4.6em;
    overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></p>
                                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</p>";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {

            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      <div  style = 'margin-top:10px' >
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >
												
                                           </div >";

            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    } else {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    }
                }
            }

        }

        if($customerID!=0 || $allowAnonymousOrder) {


            if($showPrices)
            {
                $pricing="$currencySign$price<br>$PriceWithVatText";
                if($includeVatOnPrice){
                    $pricing="$currencySign$priceWithVAT";
                }
            }
            else
            {
                $pricing="";
            }


            $pricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>

                                                <div class='buttons'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";


            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .=  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
            else{
                $pricesText .=  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
        }
        else{
            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme' style='padding: 2px;margin-bottom: 8px;display: block;width:auto;' href='product-details.php?code=".$itemID."' $disabledButton>View</a>

                                               </div>";
        }

        $result = $result .$stockText.$pricesText.$stockTextOverAlert.

            "
                                            </div>
                                        </div>
                                    </div>";


    }
    else if (strcmp($gridPreference,'grid1PerRow')==0) {

        $result = $result . "<div class='col-md-12 col-sm-6' id='div$i' style='background-color:$grayBox;margin-top:10px;border: #f4f4f4 1px solid'>
                                        
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='media'>
                                               $promotionText               
                                                <a class='media-link' style='height:350px;' href='#' data-featherlight='$imageUrl'>
                                                    <img class='img-fluid' src='$imageUrl' alt='' style='max-height:350px;width:auto;margin-top:5px;$grayImage' />
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>


                                            <div class='caption text-center'>
                                                <input type='hidden' value='$itemID'/>
                                          <p style='line-height: 1.5em;    height: 4.5em;
    overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></p>
                                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</p>";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {
            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >												
                                       ";
            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "     
                                             <h6 style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></h6>
                                         ";
                    } else {
                        $stockText = "      
                                             <h6 style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></h6>
                                           ";
                    }

                }
            }

        }
        else{

            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder) {
            if($showPrices)
            {
                $pricing="$currencySign$price<br>$PriceWithVatText";
                if($includeVatOnPrice){
                    $pricing="$currencySign$priceWithVAT";
                }
            }
            else
            {
                $pricing="";
            }

            $pricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>

                                                <div class='buttons'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .=  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
            else{
                $pricesText .=  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
        }
        else{
            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme center-canvas' style='padding: 2px;margin-bottom: 8px;width:30%;max-width: 250px;' href='product-details.php?code=".$itemID."' $disabledButton>View</a>

                                               </div>";
        }

        $result = $result .$stockText.$pricesText.$stockTextOverAlert.

            "
                                            </div>
                                        </div>
                                    </div>";


    }
    else if (strcmp($gridPreference,'grid2PerRow')==0) {

        $result = $result . "<div class='col-md-6 col-sm-6' id='div$i' style='background-color:$grayBox;margin-top:10px;border: #f4f4f4 1px solid'>

                                        <div class='thumbnail no-border no-padding'>
                                            <div class='media'>
                                               $promotionText              
                                                <a class='media-link' style='height:200px;' href='#' data-featherlight='$imageUrl'>
                                                    <img class='img-fluid' src='$imageUrl' alt='' style='max-height:200px;width:auto;margin-top:5px;$grayImage' />
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>


                                            <div class='caption text-center'>
                                                <input type='hidden' value='$itemID'/>
                                          <p style='line-height: 1.5em;    height: 4.5em;
    overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></p>
                                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</p>";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {
            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >												
                                       ";
            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "     
                                             <h6 style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></h6>
                                         ";
                    } else {
                        $stockText = "      
                                             <h6 style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></h6>
                                           ";
                    }

                }
            }

        }
        else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder) {

            if($showPrices)
            {
                $pricing="$currencySign$price<br>$PriceWithVatText";
                if($includeVatOnPrice){
                    $pricing="$currencySign$priceWithVAT";
                }
            }
            else {
                $pricing = "";
            }
            $pricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>

                                                <div class='buttons'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .=  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
            else{
                $pricesText .=  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
        }
        else{
            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme' style='padding: 2px;margin-bottom: 8px;width:35%;max-width: 250px;' href='product-details.php?code=".$itemID."' $disabledButton>View</a>

                                               </div>";
        }

        $result = $result .$stockText.$pricesText.$stockTextOverAlert.

            "
                                            </div>
                                        </div>
                                    </div>";


    }
    else if (strcmp($gridPreference,'grid3PerRow')==0) {

        $result = $result . "<div class='col-md-4 col-sm-6' id='div$i' style='background-color:$grayBox;margin-top:10px;border-left: #fbfbfb 5px solid;border-right: #fbfbfb 5px solid;border-bottom: #dbdbdb 1px solid;border-top: #dbdbdb 1px solid;-moz-border-radius: 2px;
    -webkit-border-radius: 2px;
    -khtml-border-radius: 2px;
    border-radius: 2px;
    -webkit-box-shadow: 0 -3px 3px #cccccc inset;
    -moz-box-shadow: 0 -3px 3px #cccccc inset;
    box-shadow: inset 0 -3px 3px  #cccccc ;'
    >
    
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='media'>
                                               $promotionText              
                                                <a class='media-link' style='height:120px;' href='#' data-featherlight='$imageUrl'>
                                                    <img class='img-fluid' src='$imageUrl' alt='' style='max-height:120px;width:auto;margin-top:5px;$grayImage' />
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>


                                            <div class='caption text-center'>
                                                <input type='hidden' value='$itemID'/>
                                          <p style='line-height: 1.5em;    height: 4.5em;
    overflow: hidden;font-size:12px;color:#000;font-weight:bold;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></p>
                                                <p style='white-space:nowrap;font-size:12px;Arial, Helvetica, sans-serif;font-weight:400' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</p>";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {
            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >												
                                       ";
            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "     
                                             <h6 style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></h6>
                                         ";
                    } else {
                        $stockText = "      
                                             <h6 style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></h6>
                                           ";
                    }

                }
            }

        }
        else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder) {
            if($showPrices)
            {
                $pricing="$currencySign$price<br>$PriceWithVatText";
                if($includeVatOnPrice){
                    $pricing="$currencySign$priceWithVAT";
                }
            }
            else
            {
                $pricing="";
            }

            $pricesText = " <div class='price'><ins>$prevPrice$pricing</ins></div>

                                                <div class='buttons'  style='margin-bottom:5px;'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .=  "<input type='number'  onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID'  class='productQtyInput form-control $styleHidden' style='border: #888888 1px solid !important;display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
            else{
                $pricesText .=  "<input type='number'  value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:45px;text-align:center;padding-top:2px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>";
            }
        }
        else{
            $pricesText =" $anonymousPricesText<div class='buttons' style='margin-bottom:5px;'>

                                                 <a class='btn btn-theme' style='padding: 2px;margin-bottom: 8px;width:80%;max-width: 250px;' href='product-details.php?code=".$itemID."' $disabledButton>View</a>

                                               </div>";
        }

        $result = $result .$stockText.$pricesText.$stockTextOverAlert.

            "
                                            </div>
                                        </div>
                                    </div>";


    }
    else if (strcmp($gridPreference,'mobile')==0) {
        $result = $result . "<div class='col-xs-12 col-sm-6' id='div$i' style='background-color:$grayBox;margin-top:10px;padding-bottom:5px;border-bottom: #ddd 1px solid'>
$promotionText
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='col-xs-4' style='margin-top:0;padding-left:3px;padding-right:3px;' >
                                            <div class='media'>                                                             
                                                <a class='media-link' href='#' data-featherlight='$imageUrl'>
                                                    <img src='$imageUrl' alt='' style='max-height:150px;width:auto;$grayImage'/>
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>
                                           </div>
                                           <div class='col-xs-8' style='margin-top:0;padding-top:0' >
                                            <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></h4>
                                            <h6 style='white-space:nowrap;font-size:10px;text-align:left;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</h6>
                                           										
                                           ";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {

            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      <div  style = 'margin-top:10px' >
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >
												
                                           </div >";

            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    } else {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    }

                }
            }


        }else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder)
        {

            if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0)
            {

                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }
                $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);
                $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                if($includeVatOnPrice) {
                    $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                    $recommendedRetailPriceDoubleWithVAT = number_format((float)$recommendedRetailPriceDouble + $vat,2);
                    $recommendedRetailPriceDouble = $recommendedRetailPriceDoubleWithVAT;
                }
                $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);
                $pricesText = "<div  style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:left;margin-top:3px;color:#33aaaa;font-size:12px;'>$prevPrice$pricing</div>
                                                
                                           </div>
                                           <div  style='margin-top:12px;text-align:center'>
                                                    <div class='price' style='text-align:left;color:#4682b4;'>$currencySign$recommendedRetailPriceDouble</div>
                                                
                                           </div>
                                              <div style='margin-top:0' >
                                               <div class='buttons' style='text-align:left;margin-top:8px'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            }
            else {
                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }

                $pricesText = "<div style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:left;color:#4682b4'>$prevPrice$pricing</div>
                                           </div>
                                              <div style='margin-top:0' >
                                              <div class='buttons' style='text-align:left;margin-top:8px'>
                                                
                                                <a class='minusButton $styleHidden' style='width:10px;margin:0;marign-left:5px;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";
            }
            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .= "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:100px;height:36px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:10px;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>
                                              
                                           </div>";
            }
            else{
                $pricesText .= "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:100px;height:36px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton' style='width:10px;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>
                                                
                                           </div>";
            }


        }
        else{

            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme' style='padding: 2px;width:100px' href='product-details.php?code=".$itemID."' id='placeOrderButton' $disabledButton>View</a>

                                               </div>";
        }
        $result = $result .$stockText.$pricesText.$stockTextOverAlert." 
                                            </div>
                                        </div>
                                    </div>
                                    </div>";
    }
    else if (strcmp($gridPreference,'app')==0) {
        $result = $result . "<div class='col-xs-12 col-sm-6' id='div$i' style='background-color:$grayBox;margin-top:10px;padding-bottom:5px;border-bottom: #ddd 1px solid'>
$promotionText
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='col-xs-4' style='margin-top:0;padding-left:3px;padding-right:3px;' >
                                            <div class='media'>                                                             
                                                <a class='media-link' href='#' data-featherlight='$imageUrl'>
                                                    <img src='$imageUrl' alt='' style='max-height:100px;width:auto;$grayImage'/>
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>
                                           </div>
                                           <div class='col-xs-8' style='margin-top:0;padding-top:0' >
                                            <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></h4>
                                            <h6 style='white-space:nowrap;font-size:10px;text-align:left;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</h6>
                                           										
                                           ";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {

            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      <div  style = 'margin-top:10px' >
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >
												
                                           </div >";

            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    } else {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    }

                }
            }


        }else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder)
        {

            if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0)
            {

                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }
                $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);
                $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                if($includeVatOnPrice) {
                    $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                    $recommendedRetailPriceDoubleWithVAT = number_format((float)$recommendedRetailPriceDouble + $vat,2);
                    $recommendedRetailPriceDouble = $recommendedRetailPriceDoubleWithVAT;
                }
                $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);
                $pricesText = "<div  style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:left;margin-top:3px;color:#33aaaa;font-size:12px;'>$prevPrice$pricing</div>
                                                
                                           </div>
                                           <div  style='margin-top:12px;text-align:center'>
                                                    <div class='price' style='text-align:left;color:#4682b4;'>$currencySign$recommendedRetailPriceDouble</div>
                                                
                                           </div>
                                              <div style='margin-top:0' >
                                               <div class='buttons' style='text-align:left;margin-top:8px'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            }
            else {
                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }

                $pricesText = "<div style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:left;color:#4682b4'>$prevPrice$pricing</div>
                                           </div>
                                              <div style='margin-top:0' >
                                              <div class='buttons' style='text-align:left;margin-top:8px'>
                                                
                                                <a class='minusButton $styleHidden' style='width:10px;margin:0;marign-left:5px;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";
            }
            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .= "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:100px;height:36px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:10px;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>
                                              
                                           </div>";
            }
            else{
                $pricesText .= "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:100px;height:36px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton' style='width:10px;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                                </div>
                                                
                                           </div>";
            }


        }
        else{

            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme' style='padding: 2px;width:100px' href='product-details.php?code=".$itemID."' id='placeOrderButton' $disabledButton>View</a>

                                               </div>";
        }
        $result = $result .$stockText.$pricesText.$stockTextOverAlert." 
                                            </div>
                                        </div>
                                    </div>
                                    </div>";
    }
    else if (strcmp($gridPreference,'tablet')==0) {
        $result = $result . "<div class='col-sm-6' id='div$i' style='background-color:$grayBox;margin-top:10px;padding-bottom:5px;border-bottom: #ddd 1px solid'>
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='col-sm-4' style='margin-top:0;padding-left:3px;padding-right:3px;' >
                                            <div class='media'>                                                             
                                                <a class='media-link' href='#' data-featherlight='$imageUrl'>
                                                    <img src='$imageUrl' alt='' style='max-height:200px;width:auto;$grayImage'/>
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>
                                           </div>
                                           <div class='col-sm-8' style='margin-top:0;padding-top:0' >
                                            <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></h4>
                                            <h6 style='white-space:nowrap;font-size:10px;text-align:left;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</h6>
                                           										
                                           ";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {

            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      <div  style = 'margin-top:10px' >
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >
												
                                           </div >";

            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    } else {
                        $stockText = "      <div style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    }

                }
            }


        }else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder)
        {

            if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0)
            {

                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }
                $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);
                if($includeVatOnPrice) {
                    $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                    $recommendedRetailPriceDoubleWithVAT = number_format((float)$recommendedRetailPriceDouble + $vat,2);
                    $recommendedRetailPriceDouble = $recommendedRetailPriceDoubleWithVAT;
                }
                $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);
                $pricesText = "<div  style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:left;margin-top:3px;color:#33aaaa;font-size:12px;'>$prevPrice$pricing</div>
                                                
                                           </div>
                                           <div  style='margin-top:12px;text-align:center'>
                                                    <div class='price' style='text-align:left;color:#4682b4;'>$currencySign$recommendedRetailPriceDouble</div>
                                                
                                           </div>
                                              <div style='margin-top:0' >
                                               <div class='buttons' style='text-align:left;margin-top:8px'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            }
            else {
                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }

                $pricesText = "<div style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:left;color:#4682b4'>$prevPrice$pricing</div>
                                           </div>
                                              <div class='col-sm-3' style='margin-top:0' >
                                              <div class='buttons' style='text-align:left;margin-top:8px'>
                                                
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";
            }
            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .= "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:50%;height:30px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                              $promotionText 
                                                </div>
                                              
                                           </div>";
            }
            else{
                $pricesText .= "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control' style='display:inline;width:50%;height:30px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                               $promotionText 
                                                </div>
                                                
                                           </div>";
            }


        }
        else{

            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme' style='padding: 2px;width:100px' href='product-details.php?code=".$itemID."' id='placeOrderButton' $disabledButton>View</a>

                                               </div>";
        }
        $result = $result .$stockText.$pricesText.$stockTextOverAlert." 
                                            </div>
                                        </div>
                                    </div>
                                    </div>";
    }
    else if (strcmp($gridPreference,'categoryGroup')==0){
        if(strcmp($promotionText,"<div style='height:24px;'></div>")==0){$promotionText='';}
        $stockTextOverAlert = str_replace("<div style='height: 20px;'>",'',$stockTextOverAlert);
        $stockTextOverAlert = str_replace("</div>",'',$stockTextOverAlert);
        if(strcmp($rowColor,'')==0){
            $rowColor = 'background-color:whitesmoke;';
        } else {
            $rowColor = '';
        }
        $nameLength = strlen($name);
        if($nameLength >= 80) {
            $name = substr($name, 0, 79).'...';
        }
        $result = $result . "<div class='col-sm-12 categoryGroupLine' id='div$i' style='margin-top:1px;padding:0px;border-bottom: #ddd 1px solid;$rowColor'>
                                        <div class='thumbnail no-border no-padding categoryGroupLine'>";
        if($showPrices){
            $result = $result . "<div class='col-sm-12 col-md-12 col-lg-7 ' style='margin-top:1px;padding:0px;' >
                                    <h4 style='padding:0px;padding-left:3px;font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title pull-left' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></h4>
                                 </div>";
        } else {
            $result = $result . "<div class='col-sm-12 col-md-12 col-lg-8 ' style='margin-top:1px;padding:0px;' >
                                    <h4 style='padding:0px;padding-left:3px;font-size:12px;color:#000;font-weight:bold;text-align:left;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title pull-left' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></h4>
                                 </div>";
        }


        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {

            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      <div class='col-sm-12 col-md-12 col-lg-1' style = 'margin-top:1px;padding:0px;' >
                                             <h6 style = 'white-space:nowrap;font-size:12px;color:#008080;font-weight:400;padding:0px;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >
												
                                           </div >";

            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "      <div class=' col-sm-12 col-md-12 col-lg-1' style = 'margin-top:1px;padding:0px;text-align: center' >
                                             <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    } else {
                        $stockText = "      <div class='col-sm-12 col-md-12 col-lg-1' style = 'margin-top:1px;padding:0px;text-align: center' >
                                             <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    }

                }
            }

        }else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder)
        {

            if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0)
            {

                if($showPricesWithVAT)
                {
                    $pricing="<br>$currencySign$price ($PriceWithVatText)";

                    if($includeVatOnPrice){
                        $pricing=" - $currencySign$priceWithVAT";
                    }
                    $colSm1=2;
                    $colSm2=3;
                }
                else
                {
                    $pricing="$currencySign$price";
                    $colSm1=2;
                    $colSm2=3;
                }
                $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);
                $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);

                if($showPricesWithVAT) {
                    $pricing = "$currencySign$price<br>($PriceWithVatText)";
                    $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                    $recommendedRetailPriceDoubleWithVAT = number_format((float)$recommendedRetailPriceDouble + $vat,2);
                    $inc = $langu['incl_label'];
                    $vat = $langu['vat_label'];
                    $recommendedPriceWithVatText = "<span  style='font-size: 11px;color: #0aa66e '>($currencySign$recommendedRetailPriceDoubleWithVAT &nbsp;$inc $vat)</span>";
                    if ($includeVatOnPrice) {
                        $recommendedRetailPriceDouble = $recommendedRetailPriceDoubleWithVAT;
                        $pricing="$currencySign$priceWithVAT";

                    } else {
                        $recommendedRetailPriceDouble .= "<br>$recommendedPriceWithVatText";
                    }
                }
                if(strcmp($prevPrice,'<del></del><br>')==0){$prevPrice = '';}
                $pricesText = "<div class='col-sm-12 col-md-12 col-lg-1' style='margin-top:1px;text-align:center;padding:0px;'>
                                                 <div class='price' style='text-align:center;margin: 1px;margin-top: 3px;color:#33aaaa;font-size:13px;'>$prevPrice$pricing</div>
                                                
                                           </div>
                                           <div class='col-sm-$colSm1' style='margin-top:1px;text-align:center'>
                                                    <div class='price' style='text-align:center;color:#4682b4;'>$currencySign$recommendedRetailPriceDouble </div>
                                                
                                           </div>
                                              <div class='col-sm-$colSm2' style='margin-top:0' >
                                               <div class='buttons' style='text-align:left;margin-top:1px'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            }
            else {
                if($showPrices)
                {
                    $pricing="$currencySign$price $PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }
                if(strcmp($prevPrice,'<del></del><br>')==0){$prevPrice = '';}
                $pricesText = "<div class='col-sm-12 col-md-12 col-lg-1' style='margin-top:1px;text-align:center;padding:0px;'>
                                                 <div class='price' style='text-align:right;color:#4682b4;margin: 1px;margin-top: 3px;font-size: 13px;'>$prevPrice$pricing</div>
                                           </div>
                                              <div class='col-sm-12 col-md-12 col-lg-3' style='margin-top:0;padding:0px;' >
                                              <div class='buttons' style='text-align:center;margin-top:1px'>
                                                
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";
            }
            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .= "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:55%;height:30px;text-align:center;margin: 1px;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                              
                                                </div>
                                                </div><div class='col-sm-12 col-md-12 col-lg-1' style='margin-top:1px;text-align: left;padding-left: 0px;' >$promotionText 
                                              
                                           </div>";
            }
            else{
                $pricesText .= "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:55%;height:25px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                               
                                                </div>
                                                </div><div class='col-sm-12 col-md-12 col-lg-1' style='margin-top:1px;text-align: center;padding-left: 0px;' >$promotionText 
                                                
                                           </div>";
            }


        }
        else{

            $pricesText =" $anonymousPricesText<div class='buttons pull-right'>

                                                 <a class='btn btn-theme' style='margin-right:20px;padding: 2px;width:100px' href='product-details.php?code=".$itemID."' id='placeOrderButton' $disabledButton>View</a>

                                               </div>";
        }
        $result = $result .$stockText.$pricesText.$stockTextOverAlert." 
                                            </div>
                                        </div>
                                    </div>";
    }
    else {
        $result = $result . "<div class='col-sm-12' id='div$i' style='background-color:$grayBox;margin-top:10px;padding-bottom:5px;border-bottom: #ddd 1px solid'>
                                        <div class='thumbnail no-border no-padding'>
                                            <div class='col-sm-1' style='margin-top:0;padding-left:0;padding-right:0' >
                                            <div class='media'>
                                                             
                                                <a class='media-link' href='#' data-featherlight='$imageUrl'>
                                                    <img src='$imageUrl' alt='' style='max-height:36px;width:auto;$grayImage'/>
                                                    <span class='icon-view'>
                                                        <strong><i class='fa fa-eye'></i></strong>
                                                    </span>
                                                </a>
                                            </div>
                                           </div>
                                           <div class='col-sm-3' style='margin-top:10px' >
                                            <h4 style='font-size:12px;color:#000;font-weight:bold;text-align:center;font-family:Arial, Helvetica, sans-serif' class='pointer productCode caption-title' data-value='$itemID'><a href='./product-details.php?code=$itemID'>$name</a></h4>
                                           </div>
                                              <div class='col-sm-1' style='margin-top:10px' >
                                                 <h6 style='white-space:nowrap;font-size:10px;text-align:center;font-weight:400;font-family:Arial, Helvetica, sans-serif' class='productCode caption-title pointer' data-value='$itemID' >$itemCode</h6>
												
                                           </div>";

        if($_SESSION['showStock']&&($customerID!=0 || $allowAnonymousOrder)) {

            if(strcmp($numericStock,"yes")==0)
            {
                $stockText="      <div class='col-sm-1' style = 'margin-top:10px' >
                                             <h6 style = 'white-space:nowrap;font-size:14px;color:#008080;font-weight:400;' class='productCode caption-title pointer' data-value = '$itemID' >Stock: $stock </h6 >
												
                                           </div >";

            }
            else
            {
                if(strcmp($numericStock,"dot")==0) {
                    if ($stock > 0) {
                        $stockText = "      <div class='col-sm-1' style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    } else {
                        $stockText = "      <div class='col-sm-1' style = 'margin-top:10px' >
                                             <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span>
                                           </div >";
                    }

                }
            }

        }else{
            $stockText="";
        }

        if($customerID!=0 || $allowAnonymousOrder)
        {

            if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0)
            {

                if($showPricesWithVAT)
                {
                    $pricing="<br>$currencySign$price ($PriceWithVatText)";

                    if($includeVatOnPrice){
                        $pricing=" - $currencySign$priceWithVAT";
                    }
                    $colSm1=2;
                    $colSm2=3;
                }
                else
                {
                    $pricing="$currencySign$price";
                    $colSm1=2;
                    $colSm2=3;
                }
                $recommendedRetailPriceDouble=getPriceFromPriceType($itemID,$recommendedRetailPrice);
                $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);

                if($showPricesWithVAT) {
                    $pricing = "$currencySign$price<br>($PriceWithVatText)";
                    $vat = (float)$recommendedRetailPriceDouble * ($vatPercent / 100);
                    $recommendedRetailPriceDoubleWithVAT = number_format((float)$recommendedRetailPriceDouble + $vat,2);
                    $inc = $langu['incl_label'];
                    $vat = $langu['vat_label'];
                    $recommendedPriceWithVatText = "<span  style='font-size: 11px;color: #0aa66e '>($currencySign$recommendedRetailPriceDoubleWithVAT &nbsp;$inc $vat)</span>";
                    if ($includeVatOnPrice) {
                        $recommendedRetailPriceDouble = $recommendedRetailPriceDoubleWithVAT;
                        $pricing="$currencySign$priceWithVAT";

                    } else {
                        $recommendedRetailPriceDouble .= "<br>$recommendedPriceWithVatText";
                    }
                }

                $pricesText = "<div class='col-sm-1' style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:center;margin-top:3px;color:#33aaaa;font-size:12px;'>$prevPrice$pricing</div>
                                                
                                           </div>
                                           <div class='col-sm-$colSm1' style='margin-top:12px;text-align:center'>
                                                    <div class='price' style='text-align:center;color:#4682b4;'>$currencySign$recommendedRetailPriceDouble </div>
                                                
                                           </div>
                                              <div class='col-sm-$colSm2' style='margin-top:0' >
                                               <div class='buttons' style='text-align:left;margin-top:8px'>
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";

            }
            else {
                if($showPrices)
                {
                    $pricing="$currencySign$price<br>$PriceWithVatText";
                    if($includeVatOnPrice){
                        $pricing="$currencySign$priceWithVAT";
                    }
                }
                else
                {
                    $pricing="";
                }
                $pricesText = "<div class='col-sm-1' style='margin-top:10px;text-align:center'>
                                                 <div class='price' style='text-align:center;color:#4682b4'>$prevPrice$pricing</div>
                                           </div>
                                              <div class='col-sm-4' style='margin-top:0' >
                                              <div class='buttons' style='text-align:left;margin-top:8px'>
                                                
                                                <a class='minusButton $styleHidden' style='width:20%;margin:0;margin-right:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-minus'></i></a>";
            }
            if($subUnits==1 && $subunitsForce)
            {
                $pricesText .= "<input type='number' onkeyup='this.value=this.value.replace(/[^\d]/,\"\")' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:40%;height:30px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                              $promotionText 
                                                </div>
                                              
                                           </div>";
            }
            else{
                $pricesText .= "<input type='number' value='$qty' data-value='$itemID' class='productQtyInput form-control $styleHidden' style='display:inline;width:30%;height:30px;text-align:center;' $disabledButton/>
                                                  <a  class='plusButton $styleHidden' style='width:20%;margin:0;margin-left:5px;color:black;$hidePlusMinus' href='#' data-value='$packing'><i class='fa fa-plus'></i></a>
                                               $promotionText 
                                                </div>
                                                
                                           </div>";
            }


        }
        else{

            $pricesText =" $anonymousPricesText<div class='buttons'>

                                                 <a class='btn btn-theme' style='padding: 2px;width:100px' href='product-details.php?code=".$itemID."' id='placeOrderButton' $disabledButton>View</a>

                                               </div>";
        }
        $result = $result .$stockText.$pricesText.$stockTextOverAlert." 
                                            </div>
                                        </div>
                                    </div>";
    }
}
$stm-> close();
$result = $result . $tableBottom;
echo $result;

function getSubCategoriesID($categoryID){

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {

        global $username,$password,$database;
        $db3 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $stm3 = $db3->prepare("SELECT COUNT(Categories.category_id) FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$subCategoryID\" AND Categories.category_id=Subcategories.subcategory_id");
        $stm3-> execute();
        $stm3-> bind_result($subCounter);
        while ($stm3->fetch()) {}
        $stm3-> close();
        if($subCounter > 0){
            $subCategoriesSt.= getSubCategoriesID($subCategoryID);
        } else {
            if(strcmp($subCategoryID,'')!=0){
                $subCategoriesSt.=",$subCategoryID";

            }
        }
    }
    $stm2-> close();

    return $subCategoriesSt;

}

?>