<?php

session_start();
include_once("../../param.php");
require("dbhelper.php");



$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$currencySign = getCurrencySign();

if(isset($orderID) && $orderID > 0 && isset($customerID) && $customerID > 0){
    $loggedin = 'true';
} else {
    $loggedin = 'false';
}

if(isset($_SESSION['lang'])){
    include('../langs/'.$_SESSION['lang'].'.php');
} else {
    include('../langs/en.php');
}

$cartObject  = new stdClass();
$cartObject->vat  = 0;
$cartObject->subTotal  = 0;
$cartObject->grandTotal  = 0;
$cartObject->items = array();
$cartObject->loggedin = $loggedin;

$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice = false;

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$addItemByUnits = true;
$stm = $db->prepare("SELECT use_packing,theme,primary_language,show_prices,show_prices_with_vat,logo_link,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($usePacking,$themeColor,$primaryLanguage,$showPrices,$showPricesIncludingVAT,$logoLink,$orderQtyBySubunits);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }

    $themeColor = strtolower($themeColor);
}
$stm-> close();

$pendingOrderID = 0;
$pendingOrderCode = '';

if(isset($_SESSION['customerID']) && $_SESSION['customerID'] > 0) {
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT order_id,order_code FROM Orders WHERE customer_id='".$_SESSION['customerID']."' AND status = 'Payment Pending' ORDER BY timestamp DESC LIMIT 1");
    $stm->execute();
    $stm->bind_result($pendingOrderID,$pendingOrderCode);
    while ($stm->fetch()) {
    }
    $stm->close();
}

$i = 0;
$subTotal=0;
$grandTotal=0;
$vatTotal=0;

$stm = $db->prepare("SELECT Online_Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,Items.short_description,Online_Order_Item.qty_picked,Online_Order_Item.qty_delivered,Online_Order_Item.promotion_id,Online_Order_Item.promotion_number FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID'");
$stm-> execute();
$stm-> bind_result($itemID,$qty,$unitPrice,$vatID,$itemCode,$name,$shortDescription,$multiplier,$uomID,$promoID,$promoNumber);
while ($stm->fetch()) {
    $i++;
    $imageUrl = getDefaultImage($itemID);


    $unitPrice = getDefaultPriceInclPriceTypes($itemID,$customerID,false,$qty);
    if($showPricesWithVAT) {
        $vatPercentage = getVatPercentage($vatID);
        $priceInclVAT = $unitPrice + $unitPrice * ($vatPercentage / 100);
        $inc = $langu['incl_label'];
        $vat = $langu['vat_label'];
        $priceInclVATText = "$currencySign".number_format(floatval($priceInclVAT),2)." $inc $vat";
    }
    $price=number_format(floatval($unitPrice),2);


    if($addItemByUnits) {
        $qty = $qty / floatval(getSubUnits($itemID));
        $lineTotal = $unitPrice*$qty;
    } else {
        $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
    }

    $subTotal +=$lineTotal;
    $lineVat = $lineTotal * getVatPercentage($vatID)/100;
    $vatTotal+=$lineVat;

    if((int)$uomID > 0 && (int)$multiplier > 1){
        $uomName = getUomName($uomID);
        $uomQtyDisplay = $qty/$multiplier;
        $name .= " ($uomQtyDisplay $uomName)";
    }

    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }





    if($showPrices)
    {
        $pricing=$price;
        $displayLineTotal = number_format(floatval($lineTotal),2);
        if($includeVatOnPrice){
            $pricing = number_format(floatval($priceInclVAT),2);
            $displayLineTotal = number_format(floatval($lineTotal+$lineVat),2);
            $priceInclVATText = '';

        }
    }
    else
    {
        $pricing="";
        $displayLineTotal= "";
    }

    $packing=1;
    if(strcmp($usePacking,'yes')==0)
    {
        $packing = getPacking($itemID);
    }

    $promoName = '';
    if($promoID > 0){
        $promoName = getPromoName($promoID);
    }

    $cartItemObject = new stdClass();
    $cartItemObject->itemID   = $itemID;
    $cartItemObject->itemName = str_replace("\"","",$name);
    $cartItemObject->itemName = str_replace("\n","",$name);
    $cartItemObject->imageUrl = $imageUrl;
    $cartItemObject->qty      = $qty;
    $cartItemObject->packing  = $packing;
    $cartItemObject->price    = $pricing;
    $cartItemObject->priceInclVATLabel = $priceInclVATText;
    $cartItemObject->total    = $displayLineTotal;
    $cartItemObject->color    = $themeColor;
    $cartItemObject->promoID = $promoID;
    $cartItemObject->promoNumber = $promoNumber;
    $cartItemObject->promoName = $promoName;
    array_push($cartObject->items,$cartItemObject);







}
$stm-> close();

$grandTotal = $subTotal+$vatTotal;
$displaySubTotal = number_format(floatval($subTotal),2);
$displayVatTotal = number_format(floatval($vatTotal),2);
$displayGrandTotal = number_format(floatval($grandTotal),2);

$cartObject->vat = $displayVatTotal;
$cartObject->subTotal = $displaySubTotal;
$cartObject->grandTotal = $displayGrandTotal;
$cartObject->showPrices = $showPrices;
$cartObject->includeVatOnPrice = $includeVatOnPrice;
$cartObject->pendingOrderID = intval($pendingOrderID);
$cartObject->pendingOrderCode = "$pendingOrderCode";



//echo $result;
echo json_encode($cartObject);

function getPromoName($promotionID){
    global $username,$password,$database;
    $db9 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db9->set_charset("utf8");

    $stm9 = $db9->prepare("SELECT promotion_name FROM Promotions WHERE promotion_id='$promotionID' LIMIT 1");
    $stm9-> execute();
    $stm9-> bind_result($promotionNumber);
    while ($stm9->fetch()) {
        return $promotionNumber;
    }
    $stm9-> close();

    return '';
}
?>