<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");
$currencySign = getCurrencySign();
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];
$userID=$_SESSION['userID'];
$detect = new Mobile_Detect;

$isMobile = false;

if ( $detect->isMobile() ) {
    $isMobile = true;
}

if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}

include('../langs/'.$_SESSION['lang'].'.php');

$imageTitle = $langu['column_image_label'];
$quantityTitle = $langu['column_quantity_label'];
$productNameTitle = $langu['column_product_name_label'];
$priceTitle = $langu['column_price_label'];
$totalTitle = $langu['column_total_label'];

$extraCreditTitle = $langu['extra_credit_label'];
$checkoutTitle = $langu['checkout_table_label'];

$subTotalTitle = $langu['subtotal_label'];
$deliveryFeesTitle = $langu['delivery_fees_label'];
$vatTitle = $langu['vat_label'];
$discountTitle = $langu['discount_label'];
$grandTotalTitle = $langu['grand_total_label'];
$vatInfoLabel = $langu['total_includes_vat_of'];


$orderNotesHint = $langu['order_notes_hint'];
$deliveryDate = $langu['order_delivery_date_label'];
$paymentMethodLabel = $langu['payment_method_label'];
$DeliveryMethodLabel = $langu['delivery_method_label'];

$requestQuotationButtonTitle = $langu['request_quotation_button'];
$placeOrderButtonTitle = $langu['place_order_button'];
$placeSplitOrderButtonTitle = $langu['place_special_order_button'];
$placeSplitOrderDisclaimer = $langu['special_order_disclaimer'];
$payOrderButtonTitle = $langu['proceed_with_payment'];

$deliveryAddress = $langu['order_delivery_address'];

$noItemsMessage = $langu['checkout_no_items_message'];

$couponBoxTitle = $langu['coupons_title'];
$couponBoxLabel = $langu['insert_coupon'];
$useCouponButton = $langu['add_button'];


$hasItem=false;
$useMaxStock=false;
$showPrices=true;
$allowQuotation=true;
$allowOrder=true;
$denyOrderOverStock=true;
$splitOrderQuotation = false;
$itemOverStock = false;
$itemOverMaxStock = false;
$overMaxStock=false;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$useCoupons = false;
$isB2C = false;
$usePackingOnItem = false;
$blockOrderOverCreditLimit = false;
$blockCreditOrders = false;
$warnOverCreditLimit = false;
$anonymousCheckout = false;
$hasInactiveItem = false;
$apiOrder = false;

$useLoyalties = false;
$blockLoyaltyItemsBasedOnBalance = false;
$orderWithAttachment = false;
$customTimeslots = false;
$showDiscountBubble = true;
$showPrevPrice = true;

$timezone = 'Europe/Athens';

date_default_timezone_set($timezone);
$timestamp = strtotime(date('H:i'));
$local_time = $timestamp;
$local_time = date('H:i:s', $local_time);


$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$addWatermark = false;
$watermarkCounter = 0;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$stm = $db->prepare("SELECT B2C_User FROM B2B_User WHERE b2b_user_id='$userID' LIMIT 1");
$stm->execute();
$stm->bind_result($isB2CUser);
while ($stm->fetch()) {}
$stm->close();

$B2CUser=false;
$useBillingAddress = false;
$addItemByUnits = true;
if(strcmp($isB2CUser,'yes')==0){$B2CUser=true;}

$stm = $db->prepare("SELECT primary_language,show_prices,allow_quotation,allow_order,delivery_days_after,delay_delivery_after_time,use_max_stock_on_item,minimum_order,allow_order_over_stock,max_stock_limit,show_prices_with_vat,use_as_b2c,use_packing,allow_order_over_credit_limit,anonymous_quotation,anonymous_checkout,anonymous_checkout_customer_id,checkout_cart_from_api,use_loyalty,block_order_for_loyalty,theme,logo_link,weight_fee_item_id,drop_ship_item_id,use_billing_address,minimum_order_qty,order_with_attachment,custom_delivery_time_slots,show_discount_bubble,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$allowQuotation,$allowOrder,$deliveryDaysAfter,$delayDeliveryTime,$useMaxStockOnItem,$minimumOrder,$allowOrderOverStockOnItem,$maxStockLimit,$showPricesIncludingVAT,$useAsB2C,$usePacking,$orderOverCreditLimit,$anonymousQuotationCheck,$anonymousCheckoutCheck,$anonymousCheckoutCustomerID,$checkoutCartFromAPI,$useLoyaltiesOption,$blockLoyaltyItemsBasedOnBalanceOption,$themeColor,$logoLink,$weightFeeItem,$dropShipItemID,$enableBillingAddress,$minimumOrderQty,$allowOrderWithAttachment,$customDeliveryTimeslots,$show_discount_bubble,$orderQtyBySubunits);

while ($stm->fetch()) {

    switch ($show_discount_bubble) {
        case "no":
            $showDiscountBubble = false;
            $showPrevPrice = false;
            break;
        case 'bubble':
            $showDiscountBubble = true;
            $showPrevPrice = false;
            break;
        case 'price':
            $showDiscountBubble = false;
            $showPrevPrice = true;
            break;
        default:
            $showDiscountBubble = true;
            $showPrevPrice = true;
    }

    $themeColor = strtolower($themeColor);

    if(strcmp($enableBillingAddress,'yes')==0){
        $useBillingAddress = true;
    }

    if(strcmp($useLoyaltiesOption,'yes')==0){
        $useLoyalties = true;
    }

    if(strcmp($blockLoyaltyItemsBasedOnBalanceOption,'yes')==0){
        $blockLoyaltyItemsBasedOnBalance = true;
    }

    if(strcmp($checkoutCartFromAPI,'yes')==0){
        $apiOrder = true;
    }

    if(strcmp($usePacking,'yes')==0){
        $usePackingOnItem = true;
    }
    if(strcmp($anonymousCheckoutCheck,'yes')==0 && $anonymousCheckoutCustomerID > 0){
        $anonymousCheckout = true;
    }
    if(strcmp($anonymousQuotationCheck,'yes')==0 && $anonymousCheckoutCustomerID > 0){
        $anonymousQuotation = true;
    }
    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        if(isset($_GET['apiprices']) && strcmp($_GET['apiprices'],'y')==0){
            $showPrices=true;
        } else {
            $showPrices = false;
            $priceTitle = '';
            $totalTitle = '';
        }
    }
    if(strcmp($allowQuotation,"no")==0)
    {
        $allowQuotation=false;
    }
    if(strcmp($allowOrder,"no")==0)
    {
        $allowOrder=false;
    }
    if(strcmp($useMaxStockOnItem,"yes")==0)
    {
        $useMaxStock=true;
    }
    if(strcmp($allowOrderOverStockOnItem,"yes")==0)
    {
        $denyOrderOverStock=false;
    }
    if(strcmp($allowOrderOverStockOnItem,"split")==0 && $allowOrder)
    {
        $splitOrderQuotation=true;
    }

    if(strcmp($allowOrderWithAttachment,"yes")==0)
    {
        $orderWithAttachment=true;
    }

    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }

    if(strcmp($orderOverCreditLimit,'no')==0){
        $warnOverCreditLimit = true;
        $blockOrderOverCreditLimit = true;
    } else if(strcmp($orderOverCreditLimit,'yes')==0){
        $warnOverCreditLimit = false;
        $blockOrderOverCreditLimit = false;
    } else {
        $warnOverCreditLimit = true;
        $blockOrderOverCreditLimit = false;
        if(strcmp($orderOverCreditLimit,'online')==0) {
            if($isB2C){
                $blockCreditOrders = true;
            } else {
                $blockOrderOverCreditLimit = true;
            }
        }
    }

    if(strcmp($customDeliveryTimeslots,'zipcode')==0){
        $customTimeslots = true;
    } else if(strcmp($customDeliveryTimeslots,'city')==0){
        $customTimeslots = true;
    } else {
        $customTimeslots = false;
    }

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }

}
$stm-> close();
$textColor = "white";
if(strcmp($themeColor,'')!=0){
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
        $themeColor = "firebrick";
    }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    }  else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
        $themeColor = "goldenrod";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
        $themeColor = "black";
        $textColor = "white";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }

} else {
    $themeColor = "#6796d3";
}

$stm = $db->prepare("SELECT use_coupons FROM B2C_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($useCouponsFlag);

while ($stm->fetch()) {
    if(strcmp($useCouponsFlag,"yes")==0) { $useCoupons = true; }
}
$stm-> close();

if(strcmp($delayDeliveryTime,'')!=0){
    $delayDeliveryTime .= ":00";
    if(strtotime($local_time)>strtotime($delayDeliveryTime)){
        $deliveryDaysAfter++;
    }
}

if($isMobile){
    $fontSize1 = '11px';
    $fontSize2 = '13px';
    $size1 = '38%';
    $size2 = '11%';
    $size3 = '15%';
} else {
    $fontSize1 = '14px';
    $fontSize2 = '16px';
    $size1 = '38%';
    $size2 = '15%';
    $size3 = '12.5%';

}

$result="<div class='row orders' ><div class='col-md-8' style='padding-left:0px;padding-top:3px;padding-right: 4px;'>

                                <table class='table lightBorder' id='onlineOrderItemsTableLabels' style='margin-bottom:0px;border: 1px solid  #ebebeb;background-color: ghostwhite;color: black;'>
                                        <tr style='display: none;'>
                                            <th style='width: 15%;' class='hidden-xs'>$imageTitle</th>
                                            <th style='display: none;'>onlineOrderItemID</th>
                                            <th style='display: none;'>itemID</th>
                                            <th style='display: none;'>UP</th>
                                            <th style='display: none;'>vatID</th>
                                            <th style='display: none;'>discountAmountLine</th>
                                            <th style='width: 18%;'>$quantityTitle</th>
                                            <th style='width: $size1;'><span style='margin-left: 6px;'>$productNameTitle</span></th>
                                            <th style='text-align: right;width: $size2;padding-right:5px;'><span style='margin-left: 4px;'>$priceTitle</span></th>
                                            <th style='text-align: right;width: $size3;'>$totalTitle&nbsp;&nbsp;&nbsp;&nbsp;</th>
                                             <th style='width: 5%;'></th>
                                        </tr>
                                </table>
                                <table class='table lightBorder notranslate' id='onlineOrderItemsTable' style='overflow:hidden;border: 2px solid ghostwhite;'>
                                    <thead>
                                        <tr style='display: none;'>
                                            <th class='hidden-xs'>Image</th>
                                            <th style='display: none;'>onlineOrderItemID</th>
                                            <th style='display: none;'>itemID</th>
                                            <th style='display: none;'>UP</th>
                                            <th style='display: none;'>vatID</th>
                                            <th style='display: none;'>discountAmountLine</th>
                                            <th>Quantity</th>
                                            <th>Product Name</th>
                                            <th style='text-align: right'>Price</th>
                                            <th style='text-align: right'>Total</th>
                                             <th></th>
                                        </tr>
                                    </thead>
                                    <tbody>";

//MIX AND MATCH


$stm = $db->prepare("SELECT DISTINCT Categories.category_id FROM Categories,Promotions,Promotion_Customer WHERE Categories.category_id=Promotions.item_id AND CURDATE()>= valid_from AND CURDATE()<=valid_until  AND Promotion_Customer.promotion_id=Promotions.promotion_id AND (customer_id='0' OR customer_id='$customerID') AND type=2 ORDER BY category_code");
$stm-> execute();
$stm-> bind_result($categoryID);

$subTotalCategory=0;
while ($stm->fetch()) {

    $db2 = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $stm2 = $db2->prepare("SELECT SUM(qty) FROM Online_Order_Item,Items,Category_Item WHERE Category_Item.category_id='$categoryID' AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND Online_Order_Item.promotion_number=0");
    $stm2->execute();
    $stm2->bind_result($totalQty);

    while ($stm2->fetch()) {


    }
    $stm2->close();


    applyMixAndMatchDiscount($categoryID,$customerID,$totalQty,$orderID);




}
$stm-> close();

//------




$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,stock_warning_qty,show_non_stock_items FROM B2B_Page_Catalogue");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$stockWarningQty,$show_non_stock_items);
while ($stm->fetch()) {

}
$stm-> close();

switch ("$show_non_stock_items") {
    case "no":
        $hideNonStockItems = true;
        $notAvailableNonStockItems = false;
        break;
    case 'notavailable':
        $hideNonStockItems = false;
        $notAvailableNonStockItems = true;
        break;
    default:
        $hideNonStockItems = false;
        $notAvailableNonStockItems = false;
}

if($useLoyalties){

    $stm = $db->prepare("SELECT deposit_amount  FROM Online_Orders WHERE order_id='$orderID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($claimedLoyaltyPointsOfOrder);
    while ($stm->fetch()) {}
    $stm-> close();

    $customerLoyaltyAllowanceObject = getCustomerLoyaltyAllowance($customerID,$userID,$orderID);
    $customerLoyaltyAllowance = $customerLoyaltyAllowanceObject->points;
    $loyaltyItems = $customerLoyaltyAllowanceObject->items;
    $loyaltyPointsLabel = $customerLoyaltyAllowanceObject->name;
    $loyaltyPointsType = $customerLoyaltyAllowanceObject->type;
    $loyaltyPointsMultiplier = $customerLoyaltyAllowanceObject->multiplier;

    if($customerLoyaltyAllowance >0 || $loyaltyPointsType == 1){

    } else {
        $useLoyalties = false;
    }

}

$stm = $db->prepare("SELECT Online_Order_Item.order_item_id,Online_Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,promotion_id,promotion_number,Items.short_description,line_discount_percentage,line_discount,global_discount,master_item,max_stock,packing,Items.status,sellable,Online_Order_Item.qty_picked,Online_Order_Item.qty_delivered,Items.weight,Items.sales_units,Online_Order_Item.description FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID'");
$stm-> execute();
$stm-> bind_result($onlineOrderItemID,$itemID,$qty,$oldUnitPrice,$vatID,$itemCode,$name,$promotionID,$promotionNumber,$shortDescription,$lineDiscountPercentage,$lineDiscountAmount,$globalDiscountAmountLine,$masterItem,$maxStockOfItem,$packing,$status,$b2bAvailable,$multiplier,$uomID,$itemWeight,$itemUom,$itemDescription);

$i = 0;
$subTotal=0;
$grandTotal=0;
$discountTotal = 0;
$vatTotal=0;
$sumOFQties=0;
$sumWeight = 0;
$onlineOrderItemsID = array();
$refreshPrices = false;
while ($stm->fetch()) {

    if($addItemByUnits) {
        $qty = $qty / floatval(getSubUnits($itemID));
    }

    $oldUnitPrice *= getPriceRate();
    $sumWeight += (float)$itemWeight*$qty;

    if(strcmp($status,'inactive')==0){
        $isInactive = true;
    } else {
        $isInactive = false;
    }

    $stock = getStock($itemID);

    if($hideNonStockItems || $notAvailableNonStockItems){
        if($stock <= 0){$isInactive = true;}
    }

    if(strcmp($b2bAvailable,'notavailable')==0){
        $isInactive = true;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $nonStock = true;
    } else {
        $nonStock = false;
    }
    array_push($onlineOrderItemsID,$itemID);
    $i++;
    $hasItem=true;
    $errorPrice=false;
    $errorStock=false;
    $lineDiscountApply=false;
    $imageUrl = getDefaultImage($itemID);
    $defaultPrice = getDefaultPriceFromDefaultPriceType($itemID,$qty);
    $unitPrice = getDefaultPriceInclPriceTypes($itemID,$customerID,false,$qty);

    if(isset($_GET['apiprices']) && strcmp($_GET['apiprices'],'y')==0){
        $defaultPrice = $oldUnitPrice;
        $unitPrice = $oldUnitPrice;
    }

    if($promotionID>0)
    {
        $unitPrice=$oldUnitPrice;
    }
    if($lineDiscountPercentage>0)
    {
        $unitPrice=$oldUnitPrice;
        $lineDiscountApply=true;
    }

    if($nonStock){
        $stock = 0.001;
        $maxStockLimit = 0.001;
    }

    if(!$addItemByUnits) {
        $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
    } else {
        $lineTotal = $unitPrice*$qty;
    }

    $discountTotal += $lineDiscountAmount + $globalDiscountAmountLine;
    $subTotal +=$lineTotal;
    $lineVat = ($lineTotal-$lineDiscountAmount-$globalDiscountAmountLine) * getVatPercentage($vatID)/100;
    $vatTotal+=$lineVat;
    $sumOFQties+=$qty;
    if($unitPrice!=$oldUnitPrice) {


        $oldLineTotal = $oldUnitPrice*$qty;
        $oldLineVat = $oldLineTotal * getVatPercentage($vatID)/100;
        if($showPricesWithVAT) {
            $displayOldLineTotal = "$currencySign" . number_format(floatval($oldLineTotal + $oldLineVat), 2);
        } else {
            $displayOldLineTotal = "$currencySign" . number_format(floatval($oldLineTotal), 2);
        }
        $displayOldLineTotal = "<span style='color:#b22222;'>Price Changed</span> <del style='color: grey;'>$displayOldLineTotal</del> ";
        $errorPrice=true;
        $refreshPrices = true;
    }


    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }


    if($customerID > 0) {
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
        $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
    }


    if($qty>$stock)
    {
        $errorStock=true;
    }

    if($qty>$maxStockLimit)
    {
        $overMaxStock=true;
    }

    if(!$itemOverStock && $errorStock)
    {
        $itemOverStock = true;
    }
    if(!$itemOverMaxStock && $overMaxStock)
    {
        $itemOverMaxStock = true;
    }

    if($showPrices)
    {
        $displayDefaultPrice = number_format(floatval($defaultPrice),2);
        $displayunitPrice= number_format(floatval($unitPrice),2);
        $displayLineTotal= number_format(floatval($lineTotal),2);

        if($showPricesWithVAT){

            $inc = $langu['incl_label'];
            $vat = $langu['vat_label'];
            $PriceWithVatText = "";

            $displayDefaultPriceIncVat= "<br><span  style='font-size: 11px;color: #0aa66e;text-align: right;'>$currencySign".number_format(floatval($defaultPrice +$defaultPrice*getVatPercentage($vatID)/100),2)." &nbsp;$inc $vat</span>";
            $displayunitPriceIncVat= "<br><span  style='font-size: 11px;color: #0aa66e;text-align: right;'>$currencySign".number_format(floatval($unitPrice +$unitPrice*getVatPercentage($vatID)/100),2)." &nbsp;$inc $vat</span>";
            $displayLineTotalIncVat= "<br><span  style='font-size: 11px;color: #0aa66e '>$currencySign".number_format(floatval($lineTotal + $lineVat),2)." &nbsp;$inc $vat</span>";

            $displayLineTotal= "$currencySign".number_format(floatval($lineTotal + $lineVat),2);
            $displayunitPrice= "$currencySign".number_format(floatval($unitPrice),2);

            if($includeVatOnPrice){
                $displayunitPriceIncVat='';
                $displayunitPrice= "$currencySign".number_format(floatval($unitPrice+$unitPrice*getVatPercentage($vatID)/100),2);
                $displayDefaultPrice= "$currencySign".number_format(floatval($defaultPrice+$defaultPrice*getVatPercentage($vatID)/100),2);
            }
        }

    }
    else
    {
        $displayunitPrice= "";
        $displayLineTotal="";

    }
    $qtyTextDisable="";

    if($denyOrderOverStock && $maxStockLimit > 0){
        if($maxStockOfItem > $maxStockLimit || $maxStockOfItem == 0){
            $maxStockOfItem = $maxStockLimit;
        }

    }

    if($useMaxStock && $maxStockOfItem > 0 && $maxStockOfItem < $qty){
        $overMaxStock = true;
    } else if (!$useMaxStock && $maxStockLimit > 0 && $maxStockLimit < $qty) {
        $maxStockOfItem = $maxStockLimit;
        $overMaxStock = true;
    } else {
        $overMaxStock = false;

    }


    if($promotionNumber!=0 &&strcmp($masterItem,"no")==0)
    {
        $qtyTextDisable="disabled";
    }


    if($lineDiscountApply)
    {
        $displayunitPrice.=" <span style='color:#b22222'>(-$lineDiscountPercentage%)</span>";
    }

    if($defaultPrice > $unitPrice && $showDiscountBubble){
        $percentDiscount = round((1 - ($unitPrice/$defaultPrice))*100);
        $displayunitPrice.=" <span style='color:#b22222'>(-$percentDiscount%)</span>";
    }

    if(!$showPrices)
    {
        $displayunitPrice= "";
        $displayLineTotal="";
    }

    if($overMaxStock && $denyOrderOverStock){
        $overMessage ="<br/><b style='color: #b22222'>".$langu['no_orders_allowed_over']." $maxStockOfItem ".$langu['pieces']."!</b>";
        $overStyle = "color: #b22222;border-color: #b22222;";
    } else {$overMessage = '';$overStyle = '';}

    if($useLoyalties && $blockLoyaltyItemsBasedOnBalance){
        if($customerLoyaltyAllowance < 0 && in_array($onlineOrderItemID,$loyaltyItems)){
            $customerLoyaltyAllowanceDisplay = abs($customerLoyaltyAllowance);
            $overMessage = "<br><b style='color: firebrick'>".$langu['missing']." $customerLoyaltyAllowanceDisplay $loyaltyPointsLabel</b>";
        }
    }

    if($usePackingOnItem){
        $packingAttribute= "data-packing='$packing'";
        $packingAttributeButtons= "data-value='$packing'";
    } else {
        $packingAttribute='';
        $packingAttributeButtons='';
    }

    if((int)$uomID > 0 && (int)$multiplier > 1){
        $uomName = getUomName($uomID);
        $uomQtyDisplay = $qty/$multiplier;
        $name .= " ($uomQtyDisplay $uomName)";
    }

    $watermarkCounter++;

    $itemCodeUrl = urlencode(str_replace('/','--CP2F--',$itemCode));

    if($addWatermark) {


        if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
        if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
        if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.3';}
        if(strcmp($imageUrl,'./assets/img/noimage.jpg')!=0) {
            $watermarks .= "
            watermark(['$imageUrl','$watermarkURL'])
            .image(watermark.image.$watermarkPosition($watermarkOpacity))
            .then(function (img) {
                img.id = 'watermark-img-cart-checkout-$itemID-$watermarkCounter';
                img.style.cssText = document.getElementById('media-link-img-cart-checkout-$itemID-$watermarkCounter').style.cssText;
                img.className = document.getElementById('media-link-img-cart-checkout-$itemID-$watermarkCounter').className;
                document.getElementById('media-link-img-cart-checkout-$itemID-$watermarkCounter').remove();
                document.getElementById('media-link-cart-checkout-$itemID-$watermarkCounter').appendChild(img);
                document.getElementById('media-link-cart-checkout-$itemID-$watermarkCounter').href = './products/$itemCodeUrl';
                delete document.getElementById('media-link-cart-checkout-$itemID-$watermarkCounter').dataset.featherlight;
    
            });
    
            ";
        }

        $imageUrl = './assets/img/noimage.jpg';
    }
    if($itemID == $dropShipItemID){
        $descriptionLabel = $langu['account_view_order_product_name'];

        $result = $result . "  <tr class='itemRow' style='border-bottom: 8px solid transparent;background-clip: padding-box;background-color: ghostwhite;'>
                             <td class='image' style='position: relative;width: 12%;padding: 6px;'>
                                 <a class='media-link'  id='media-link-cart-checkout-$itemID-$watermarkCounter' style='height: 100px;width:100px;border-radius: 15px;display: flex;justify-content: center;align-items: center !important;'>
                                    <img class='' style='width: auto;height: 100%;border-radius: 15px;' id='media-link-img-cart-checkout-$itemID-$watermarkCounter' src='$imageUrl' alt='' />
                                 </a>
                             </td>
                             <td style='display: none;'><input type='hidden' value='$onlineOrderItemID'></td>
                             <td style='display: none;'><input type='hidden' value='$itemID'></td>
                             <td style='display: none;'><input type='hidden' value='$unitPrice'></td>
                             <td style='display: none;'><input type='hidden' value='$vatID'></td>
                             <td style='display: none;'><input type='hidden' value='$globalDiscountAmountLine'></td>
                             <td class='quantity' style='position: relative;width: 22%;display:none;'>
                                <div class='pull-left' style='border: 1px solid transparent;padding-top: 5px;padding-bottom: 7px;'>
                                <label style='text-transform: none;font-weight: bold;font-size:16px;color: $themeColor;'>$itemUom:&nbsp;</label>
                                 <input value='$qty' type='number' class='input ' onchange='checkoutDropshipProductQuantityChanged($onlineOrderItemID,$itemID, $(this).val());setTimeout(function(){refreshCartInCheckout();}, 100);' data-value='$itemID' $packingAttribute style='border: 1px solid $themeColor;padding: 5px;max-width:55px;text-align:center;$overStyle' $qtyTextDisable>
                                 
                                 </div>
                             </td>
                             <td class='description' style='font-weight:300;font-family: Arial, Helvetica, sans-serif;font-size:$fontSize1;position: relative;'>
                                <span style='border: 1px solid transparent;padding-top: 5px;padding-bottom: 7px;'>
                                    <label style='text-transform: none;font-weight: bold;font-size:16px;color: $themeColor;'>$itemUom:&nbsp;</label>
                                    <input value='$qty' type='number' class='input ' onchange='checkoutDropshipProductQuantityChanged($onlineOrderItemID,$itemID, $(this).val());setTimeout(function(){refreshCartInCheckout();}, 100);' data-value='$itemID' $packingAttribute style='border: 1px solid $themeColor;padding: 5px;max-width:55px;text-align:center;$overStyle' $qtyTextDisable>
                                </span>
                                 
                                <input type='text' class='input' placeholder='$descriptionLabel' onchange='checkoutDropshipProductDescriptionChanged($onlineOrderItemID,$itemID, $(this).val());setTimeout(function(){refreshCartInCheckout();}, 100);' value='$itemDescription' style='color:black;font-weight: bold;border: 1px solid $themeColor;padding: 5px;margin: 5px;'>
                                
                                                ";
    } else {
        $maxInputWidth = strlen($qty)*15/1.3;
        if($maxInputWidth < 30){$maxInputWidth = 30;}
        $result = $result . "  <tr class='itemRow' style='border-bottom: 8px solid transparent;background-clip: padding-box;background-color: ghostwhite;'>
                             <td class='image' style='position: relative;width: 12%;'>
                                 <a class='media-link' id='media-link-cart-checkout-$itemID-$watermarkCounter' style='height: 100px;width:100px;border-radius: 15px;display: flex;justify-content: center;align-items: center !important;'>
                                    <img class='' style='width: auto;height: 100%;border-radius: 10px;' id='media-link-img-cart-checkout-$itemID-$watermarkCounter' src='$imageUrl' alt='' />
                                 </a>
                             </td>
                             <td style='display: none;'><input type='hidden' value='$onlineOrderItemID'></td>
                             <td style='display: none;'><input type='hidden' value='$itemID'></td>
                             <td style='display: none;'><input type='hidden' value='$unitPrice'></td>
                             <td style='display: none;'><input type='hidden' value='$vatID'></td>
                             <td style='display: none;'><input type='hidden' value='$globalDiscountAmountLine'></td>
                             <td class='quantity' style='position: relative;width: 22%;display: none;'>
                                <span style='border: 1px solid $themeColor;padding-top: 5px;padding-bottom: 7px;'>
                                 <a class='minusButton hidden-xs' href='#' $packingAttributeButtons onclick='setTimeout(function(){refreshCartInCheckout();}, 100);'>
                                    <i class='fa fa-minus'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" style='margin: 0px !important;border-radius: 0%;font-size: 14px;padding-top: 7px;padding-bottom: 7px;padding-right:4px;padding-left:4px;border: 1px solid transparent;color:$themeColor;margin-top: -3px;'></i>
                                 </a>
                                 <input value='$qty' type='number' class='input quantityInCheckout' data-value='$itemID' $packingAttribute style='border-color:transparent !important;max-width:55px;text-align:center;$overStyle' $qtyTextDisable>
                                 <a class='plusButton hidden-xs' href='#' $packingAttributeButtons onclick='setTimeout(function(){refreshCartInCheckout();}, 100);'>
                                    <i class='fa fa-plus'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" style='margin: 0px !important;border-radius: 0%;font-size: 14px;padding-top: 7px;padding-bottom: 7px;padding-right:4px;padding-left:4px;border: 1px solid transparent;color:$themeColor;margin-top: -3px;'></i>
                                 </a>
                                 </span>
                             </td>
                             <td class='description' style='font-weight:300;font-family: Arial, Helvetica, sans-serif;font-size:$fontSize1;position: relative;'>
                                        <div  style='margin-bottom:5px;'>
                                        <h4 style='color:#222; font-size:$fontSize2;font-family: Arial, Helvetica, sans-serif;font-weight:bold;'>$name</h4>
                                        <!--$itemCode-->
                                        </div>  
                                        <h4 style='color:#4682B4 !important; font-size:$fontSize1;font-family: Arial, Helvetica, sans-serif;font-weight:bold;text-align: left;margin-bottom:5px;'>$displayunitPrice $displayunitPriceIncVat</h4> 

                                        <div class='media-heading item-title' style='font-size:14px;display:block;text-transform: none;margin-bottom:0px;'><b class='hidden-xs'>Qty: &nbsp;</b>
                                            <a class='minusButton' href='#' $packingAttributeButtons onclick='setTimeout(function(){refreshCartInCheckout();}, 100);'>
                                                <i class='fa fa-minus'  onMouseOut=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOver=\"this.style.background='';this.style.color='$themeColor'\" style='border-radius: 50%;font-size: 13px;padding-top: 5px;padding-bottom: 3px;padding-left:5px;padding-right:5px;border: 2px solid $themeColor;color:white;background-color:$themeColor;margin-top: 0px;'></i>
                                            </a>
                                            <input value='$qty' type='number' class='input quantityInCheckout' data-value='$itemID' $packingAttribute style='border-color:transparent !important;max-width:".$maxInputWidth."px;text-align:center;' $qtyTextDisable>
                                            <a class='plusButton' href='#' $packingAttributeButtons onclick='setTimeout(function(){refreshCartInCheckout();}, 100);'>
                                                <i class='fa fa-plus'  onMouseOut=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOver=\"this.style.background='';this.style.color='$themeColor'\" style='text-decoration:none;border-radius: 50%;font-size: 13px;padding-top: 5px;padding-bottom: 3px;padding-left:5px;padding-right:6px;border: 2px solid $themeColor;color:white;background-color:$themeColor;margin-top: 0px;'></i>
                                            </a>
                                        </div>";

        if($isInactive){
            $hasInactiveItem = true;
            $result = $result . "<br/><b style='color: #b22222'>".$langu['product_not_available']."</b></td>";
        } else {
            if (strcmp($_SESSION['showStock'], 'yes') == 0 || $_SESSION['showStock'] == true) {
                if ($errorStock) {

                    if (strcmp($numericStock, "yes") == 0) {
                        if ($stock > $stockWarningQty && $stock > 0) {
                            $result = $result . " <b style='color:#b22222'>Stock: $stockWarningQty+</b> <br><b style='color: #b22222'>" . $langu['insufficient_stock'] . "!</b>
                                           $overMessage</td>";
                        } else {
                            $result = $result . " <b style='color:#b22222'>Stock: $stock</b> <br><b style='color: #b22222'>" . $langu['insufficient_stock'] . "!</b>
                                           $overMessage</td>";
                        }
                    } else {
                        $result = $result . "   <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span> <b style='color: #b22222'>" . $langu['insufficient_stock'] . "!</b>
                                           $overMessage</td>";
                    }


                } else {
                    if (strcmp($numericStock, "yes") == 0) {
                        if ($stock > $stockWarningQty && $stock > 0) {
                            $result = $result . "   <b style='color:#008080'>Stock: $stockWarningQty+</b>
                                           $overMessage</td>";
                        } else {
                            $result = $result . "   <b style='color:#008080'>Stock: $stock</b>
                                           $overMessage</td>";
                        }
                    } else if(strcmp($numericStock, "dot") == 0) {
                        if ($stock < $stockWarningQty && $stock > 0) {
                            $result = $result . "    <span style='height: 8px;width: 8px;background-color: #B98502FF;border-radius: 50%;display:inline-block;' class='dot'></span><b style='color: #B98502FF;font-size: 12px;'> $stock Remaining</b>
                                           $overMessage</td>";
                        } else {
                            $result = $result . "    <span style='height: 8px;width: 8px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span><b style='color: #008080'> In Stock</b>
                                           $overMessage</td>";
                        }
                    }

                }
            } else {
                if ($errorStock && $denyOrderOverStock) {
                    $result = $result . "   <span style='height: 8px;width: 8px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span> <b style='color: #b22222'>" . $langu['insufficient_stock'] . "!</b>
                                           $overMessage</td>";
                }
            }
        }
    }




    $result.= "
                                            <td class='total' style='width: 20%;display: none;'><h4 style='color:#222; font-size:$fontSize1;font-family: Arial, Helvetica, sans-serif;font-weight:bold;text-align: right;margin-top: 13px'>$displayunitPrice $displayunitPriceIncVat</h4></td>";

    if($itemID == $dropShipItemID){
        $result .= "
                                            <td class='total' style='position: relative;width: 15%;text-align:right;color:#222; font-size:15px;font-family: Arial, Tahoma, sans-serif;font-weight:bold;vertical-align: bottom;'>$displayLineTotal</td>
                                            <td style='padding:5px;position: relative;'> 
                                               <a style='cursor: pointer;display: block;position: absolute;bottom: 5px;right: 6.5px;' href='#' onclick='checkoutDropshipProductQuantityChanged($onlineOrderItemID,$itemID, 0);setTimeout(function(){refreshCartInCheckout();}, 100);'><i class='fa fa-trash' style='font-size: 20px;' onMouseOver=\"this.style.color='firebrick'\"  onMouseOut=\"this.style.color='$themeColor'\"></i></a>
                                            </td>
                                        </tr>";
    } else {
        if ($errorPrice) {
            $result .= "
                                            <td class='total' style='position: relative;width: 15%;text-align:right;font-size:$fontSize1;vertical-align: bottom;'>$displayOldLineTotal$displayLineTotal</td>
                                             <td style='padding:5px;position: relative;'> 
                                               <a class='pull-right hidden-xs' style='cursor: pointer;display: block;' href='products/$itemCodeUrl'  ><i class='fa fa-eye' style='font-size: 18px;margin-top: 2px;'></i></a>
                                               <a class='pull-right hidden-xs' style='cursor: pointer;display: block;position: absolute;bottom: 7px;right: 6.5px;' onclick='removeItemFromCartInCheckout($itemID,$promotionID,$promotionNumber);'><i class='fa fa-trash' style='font-size: 20px;' onMouseOver=\"this.style.color='firebrick'\"  onMouseOut=\"this.style.color='$themeColor'\"></i></a>
                                            </td>
                                        </tr>";
        } else {
            $result .= "
                                            <td class='total' style='position: relative;width: 15%;text-align:right;color:#222; font-size:15px;font-family: Arial, Tahoma, sans-serif;font-weight:bold;vertical-align: bottom;'>$displayLineTotal</td>
                                            <td style='padding:5px;position: relative;'> 
                                               <a class='pull-right hidden-xs' style='cursor: pointer;display: block;' href='products/$itemCodeUrl'  ><i class='fa fa-eye' style='font-size: 18px;margin-top: 2px;'></i></a>
                                               <a class='pull-right hidden-xs' style='cursor: pointer;display: block;position: absolute;bottom: 7px;right: 6.5px;' onclick='removeItemFromCartInCheckout($itemID,$promotionID,$promotionNumber);'><i class='fa fa-trash' style='font-size: 20px;' onMouseOver=\"this.style.color='firebrick'\"  onMouseOut=\"this.style.color='$themeColor'\"></i></a>
                                            </td>
                                        </tr>";
        }
    }



}
$stm-> close();

if($i == 0) {
    $result = $result . "<tr class='itemRow'><td>$noItemsMessage</td></tr>";
}
if($dropShipItemID > 0) {
    $addBoxLabel = $langu['checkout_add_box_label'];
    $addBoxElement = "<button type='button' class='btn btn-theme' onclick='dropshipQuantityChanged($dropShipItemID, 1);setTimeout(function(){refreshCartInCheckout();}, 100);'>$addBoxLabel</button>";
}



$result = $result."

                                    </tbody>
                                </table>
                                $addBoxElement
                            </div>";

$deliveryFeeAndNotes=getDeliveryCost($subTotal,$sumOFQties,$customerID);
$deliveryFee=$deliveryFeeAndNotes[0];
$deliveryFeeNote=$deliveryFeeAndNotes[1];
$deliveryFeeItemID = $deliveryFeeAndNotes[2];
if(strcmp($deliveryFeeNote,'')!=0){
    $deliveryFeeNote = "<center><div style='margin-top:-25px;padding: 0 3px;'>$deliveryFeeNote</div></center>";
}
if($deliveryFeeItemID > 0) {
    $deliveryFeeVatID = getItemVatID($deliveryFeeItemID, $db);

    if($includeVatOnPrice){
        $deliveryFeeItemVatAmountLine = $deliveryFee * getVatPercentage($deliveryFeeVatID) / 100;
        $deliveryFee += $deliveryFeeItemVatAmountLine;
        $vatTotal += $deliveryFeeItemVatAmountLine;
        $subTotal -=$deliveryFeeItemVatAmountLine;
    } else {
        $deliveryFeeItemVatAmountLine = $deliveryFee * getVatPercentage($deliveryFeeVatID) / 100;
        $vatTotal += $deliveryFeeItemVatAmountLine;
        $subTotal -=$deliveryFeeItemVatAmountLine;
    }
}

if(strcmp($deliveryFee,'')==0){$deliveryFee = 0;}
$grandTotal = $subTotal+$vatTotal-$discountTotal+(float)$deliveryFee;


// ------------- WEIGHT FEE ------------------------
if($weightFeeItem > 0) {
    $stm = $db->prepare("SELECT item_id,name,vat_id,sales_units FROM Items WHERE item_id='$weightFeeItem' LIMIT 1");
    $stm->execute();
    $stm->bind_result($weightFeeItemID, $weightFeesTitle, $weightFeeItemVatID, $weightFeeItemUOM);
    while ($stm->fetch()) {}
    $stm->close();

    $wfiUnitPrice = getDefaultPriceInclPriceTypes($weightFeeItemID, $customerID);
    $wfiVatPercent = getVatPercentage($weightFeeItemVatID) / 100;

    $weightFeePrice     = $wfiUnitPrice * $sumWeight;
    $weightFeeVat       = $weightFeePrice * getVatPercentage($weightFeeItemVatID) / 100;
    $vatTotal   += (float)$weightFeeVat;

    if ($includeVatOnPrice) {
        $weightFeeItemDisplayPrice = $currencySign . number_format(floatval($wfiUnitPrice + $wfiUnitPrice*$wfiVatPercent), 2);
        $weightFeePriceDisplay = number_format(floatval($weightFeePrice + $weightFeePrice*$wfiVatPercent), 2);
    } else {

        $weightFeeItemDisplayPrice = $currencySign . number_format(floatval($wfiUnitPrice), 2);
        $weightFeePriceDisplay = number_format(floatval($weightFeePrice), 2);
    }


    $weightFeesHtml = "<tr>
                            <td style='text-align:left;text-transform: capitalize;'>
                                <input type='hidden' value='$weightFeeItemID' id='weightFeeItem'>
                                <input type='hidden' value='$sumWeight' id='weightFeeItemQty'>
                                $weightFeesTitle
                            </td>
                            <td style='text-align:right;width:2000px;padding-left: 0px;'>
                                <span class='pull-left' style='text-transform: none'>$weightFeeItemDisplayPrice / $weightFeeItemUOM</span>
                                $currencySign
                            </td>
                                <td style='text-align:right;width:2000px;'>
                                <input type='hidden' value='$weightFeePrice' id='weightTotal'>
                                $weightFeePriceDisplay
                            </td>
                        </tr>";

    if ($includeVatOnPrice) {
        $weightFeesInclVAT = $weightFeesHtml;
    } else {
        $weightFeesElement = $weightFeesHtml;
    }
}


// ------------- WEIGHT FEE/------------------------


$subTotal = round($subTotal,2);
$discountTotal = round($discountTotal,2);
$vatTotal = round($vatTotal,2);


if($showPrices)
{
    $displaySubTotal = number_format(floatval($subTotal),2,'.',',');
    $displayVatTotal = number_format(floatval($vatTotal),2,'.',',');
    $displayGrandTotal = number_format(floatval($grandTotal),2,'.',',');
    $displayDeliveryFee=number_format(floatval($deliveryFee),2,'.',',');
    $displayDiscountTotal=number_format(floatval($discountTotal),2,'.',',');
}
else
{
    $displaySubTotal = "";
    $displayVatTotal = "";
    $displayGrandTotal = "";
    $displayDeliveryFee="";
    $displayDiscountTotal="";
}

$result = $result."
 
 <div class='col-md-4' id='totalsBox' style='padding:20px;background-color: ghostwhite;border: 1px solid #ebebeb;border-radius: 1%;'>";


$db4 = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db4->set_charset("utf8");

$stm4 = $db4->prepare("SELECT COUNT(category_id) FROM B2B_Categories_Promotions ");
$stm4->execute();
$stm4->bind_result($counter);
while ($stm4->fetch()) {
    if ($counter > 0) {


        $extraCreditResult = '';
        $db5 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db5->set_charset("utf8");
        $stm5 = $db5->prepare("SELECT B2B_Categories_Promotions.category_id,Categories.name,details,SUM(qty*unit_price) FROM Online_Order_Item,Items,Category_Item,B2B_Categories_Promotions,Categories WHERE Categories.category_id=B2B_Categories_Promotions.category_id AND B2B_Categories_Promotions.category_id=Category_Item.category_id AND Items.item_id=Category_Item.item_id AND  Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID' AND ( Online_Order_Item.promotion_number>0 OR Online_Order_Item.line_discount_percentage>0) GROUP BY B2B_Categories_Promotions.category_id");
        $stm5->execute();
        $stm5->bind_result($categoryID,$categoryName,$details,$subTotalCategory);
        while ($stm5->fetch()) {

            $subTotalCategory = number_format(floatval($subTotalCategory),2);
            $extraCreditResult .= "<li class='cop-category'>

                                                 <a style='font-weight:bold;width:70%;margin-right:0;display:inline-block;color:black;text-transform:uppercase' class='selectCategory pointer abc' data-trigger='hover' data-toggle='popover-x' data-target='#over1$categoryID' data-placement='top' data-index='$categoryID'>$categoryName</a><span style='width:20%;margin-left:5px;text-align: right;display:inline-block;color:#6796d3;font-weight:bold' id='promo$categoryID'>$subTotalCategory</span>
                                                 <div id='over1$categoryID' class='popover popover-x popover-default' style='min-width:500px'>
                   $details
                    ";




        }
        $stm5->close();
        if(strcmp($extraCreditResult,'')!=0) {
            $result = $result ."<h3 class='block-title'><span>$extraCreditTitle</span></h3>
                                <div class='widget shop-categories' >                                
                                    <div class='widget-content' id='promoCategoriesContainer' style='max-height:200px;overflow-y: auto;'>
                                        $extraCreditResult                            
                                    </div>
                                </div><br>";
        }
    }
}
$stm4->close();
if($useCoupons) {
    $result .= "<h3 class='block-title'><span>$couponBoxTitle</span></h3>
            <div class='widget shop-categories' style='max-height:200px;overflow-y: auto;'>                                
            <div class='widget-content' id='promoCategoriesContainer'>";
    $result .= "<table style='width: 100%'><tr>";

    $stm4 = $db4->prepare("SELECT promotion_code,promotion_name FROM Promotions WHERE valid_from <= NOW() AND valid_until >= NOW() AND status = 'yes' AND Promotions.description=? ORDER BY timestamp DESC LIMIT 1");
    $stm4-> bind_param('i',$userID);
    $stm4-> execute();
    $stm4-> bind_result($couponCode,$couponName);
    while ($stm4->fetch()) {}
    $stm4->close();

    if(strcmp("$couponCode",'')!=0 && $userID > 0){
        $result .= "<td colspan='2' style='width: 900px;'>
                        <button type='button' class='btn btn-theme' style='width: 100%;text-transform: capitalize; ' onclick='addCoupon()' >$couponName</button>
                        <input  type='hidden' id='couponBox' class='form-control' style='height: 47px;' name='couponBox' placeholder='$couponBoxLabel' value='$couponCode'/>
                    </td>";
    } else {
        $result .= "<td style='width: 80%;'><input type='text' autocomplete='off' id='couponBox' class='form-control' style='height: 47px;' name='couponBox' placeholder='$couponBoxLabel'/></td>";
        $result .= "<td style='width: 29%;'><button type='button' class='btn btn-theme' onclick='addCoupon()' >$useCouponButton</button></td>";
    }

    $result .= "</tr></table></div></div><br>";
}

if($useLoyalties && strcmp($loyaltyPointsLabel,'')!=0){
    if($loyaltyPointsType == '2'){

        $loyaltyPointsToCurrency = $customerLoyaltyAllowance/$loyaltyPointsMultiplier;
        $subtotalToLoyaltyPoints = $subTotal*$loyaltyPointsMultiplier;
        $loyaltyDiscountCurrencyTotal = $subTotal;

        if($subtotalToLoyaltyPoints > $customerLoyaltyAllowance){
            $subtotalToLoyaltyPoints = $customerLoyaltyAllowance;
            $loyaltyDiscountCurrencyTotal = $loyaltyPointsToCurrency;
        }

        $customerLoyaltyAllowanceCurrencyDisplay = number_format(floatval($loyaltyPointsToCurrency),2,'.',',');
        $customerLoyaltyAllowanceDisplay = number_format(floatval($customerLoyaltyAllowance),0,'.',',');
        $loyaltyDiscountCurrencyTotalDisplay = number_format(floatval($loyaltyDiscountCurrencyTotal),2,'.',',');
        $useDiscountFromSubtotalPointsDisplay = round(floatval($subtotalToLoyaltyPoints));

        $result .= "<h3 class='block-title' style='margin-bottom:1px;'><span style='font-size: 15px;'>$loyaltyPointsLabel ($customerLoyaltyAllowanceDisplay):&nbsp;&nbsp;&nbsp; $currencySign$customerLoyaltyAllowanceCurrencyDisplay</span></h3>";
        if($claimedLoyaltyPointsOfOrder > 0) {
            $claimedLoyaltyPointsOfOrderDisplay = number_format(floatval($claimedLoyaltyPointsOfOrder), 0, '.', ',');
            $result .= "<table style='width: 100%;'>
                            <tbody>
                                <tr>
                                    <td style='width: 80%;'>
                                        <h4>" . $langu['claimed'] . " $claimedLoyaltyPointsOfOrderDisplay $loyaltyPointsLabel</h4>
                                        <input type='hidden' step='1' autocomplete='off' id='customLoyaltyPoints' name='customPoints' class='form-control' onkeyup='calculateLoyaltyPoints(\"$subtotalToLoyaltyPoints\",\"$loyaltyPointsMultiplier\")'  max='0' style='height: 47px;'  placeholder='".ucfirst($langu['use'])." $loyaltyPointsLabel' value='0' >
                                    </td>
                                    <td style='width: 29%;'>
                                        <button type='button' class='btn btn-theme' onclick='useLoyaltyPoints(\"$subtotalToLoyaltyPoints\",\"$loyaltyPointsMultiplier\")'>".$langu['remove_loyalty_label']."</button>
                                    </td>
                                </tr>
                            </tbody>
                         </table>
                         <br>";
        } else  {
            $useDiscountFromSubtotalPointsDisplay = number_format(floatval($useDiscountFromSubtotalPointsDisplay), 0, '.', ',');
//            $result .= "<button type='button' class='btn btn-theme btn-block' onclick='useLoyaltyPoints(\"$subtotalToLoyaltyPoints\",\"$loyaltyPointsMultiplier\")' style='margin-bottom: 2px;'>".$langu['use']." $useDiscountFromSubtotalPointsDisplay $loyaltyPointsLabel (-$currencySign $loyaltyDiscountCurrencyTotalDisplay)</button>";
            $result .= "<table style='width: 100%;'>
                            <tbody>
                                <tr>
                                <td style='width: 80%;'>
                                    <input type='number' autocomplete='off' step='1' id='customLoyaltyPoints' name='customLoyaltyPoints' class='form-control' onkeyup='calculateLoyaltyPoints(\"$subtotalToLoyaltyPoints\",\"$loyaltyPointsMultiplier\")'  max='$subtotalToLoyaltyPoints' style='height: 47px;'  placeholder='".ucfirst($langu['use'])." $loyaltyPointsLabel' >
                                </td>
                                <td >
                                    <label  class='text-center' style='width: 100%;padding:7px;margin:0;font-size: 15px;'>".$currencySign."<span id='calculatedPointsToCurrency'>0</span></label>
                                </td>
                                <td style='width: 29%;'>
                                    <button type='button' class='btn btn-theme' onclick='useLoyaltyPoints(\"$subtotalToLoyaltyPoints\",\"$loyaltyPointsMultiplier\")'>".$langu['use']."</button>
                                </td>
                                </tr>
                            </tbody>
                         </table>
                         <br>";

        }

        $result .= '<script>
                    function calculateLoyaltyPoints(points,multiplier){
                        var customPoints = $("#customLoyaltyPoints").val();
                        
                        if(customPoints == ""){customPoints = 0;}
                        
                        points = parseInt(points);
                        customPoints = parseInt(customPoints);
                        multiplier = parseFloat(multiplier);

                        if(customPoints > points){customPoints = points;} 
                        
                        if(customPoints == 0){
                            $("#customLoyaltyPoints").val("");
                            $("#calculatedPointsToCurrency").html("0");
                        } else {
                            $("#customLoyaltyPoints").val(customPoints);
                            var calculatedPointsToCurrency = customPoints/multiplier;
                            $("#calculatedPointsToCurrency").html(calculatedPointsToCurrency);
                        }
                        
                       
                        
                    }
                    function useLoyaltyPoints(maxPoints,multiplier){
                           
                           var orderID = "'.$orderID.'";
                           var points = $("#customLoyaltyPoints").val();
                           
                           if(points == ""){points = 0;}
                           if(points > maxPoints){points = maxPoints;}
                           
                           $.ajax({
                                type: "POST",
                                url: "./dbaccess/updateOrderLoyaltyDiscount.php",
                                data: { "points": points,"points": points,"multiplier": multiplier,"orderID":orderID },
                                success: function (result) {
                                    console.log(result);
                                }
                           });
                                            
                            refreshCartInCheckout();                
                
                    }
                    </script>';

    } else {
        $result .= "<h3 class='block-title'><span style='font-size: 15px;'>".$langu['available']." $loyaltyPointsLabel :&nbsp;&nbsp;&nbsp; $customerLoyaltyAllowance</span></h3>";
    }
}
// =========== CHECKOUT ============== //
$result = $result . "         <h3 class='block-title'><span>$checkoutTitle</span></h3>$deliveryFeeNote
                                <div class='shopping-cart'>";
if($showPrices) {
    if($includeVatOnPrice){

        $displaySubTotalIncVat = number_format(floatval($subTotal+$vatTotal-(float)$weightFeeVat),2,'.',',');
        $hideTotals1 = "style='display:none;'";
        $hideTotals2 = "style='display:none;'";
        $totalsInclVAT = "<tr>
                                            <td style='text-align:left;text-transform: capitalize;'>$subTotalTitle</td>
                                            <td style='text-align:right;width:2000px;padding-left: 0px;'>$currencySign</td>
                                            <td id='subtotalincvat' style='text-align:right;width:2000px;'>$displaySubTotalIncVat</td>
                                        </tr>
                                        $weightFeesInclVAT
                                        <tr>
                                            <td style='text-align:left;text-transform: capitalize;'>$deliveryFeesTitle</td>
                                            <td style='text-align:right;width:2000px;padding-left: 0px;'>$currencySign</td>
                                            <td id='deliveryTotalincVat' style='text-align:right;width:2000px;'>$displayDeliveryFee</td>
                                        </tr>";
        $vatTotalInfoAmount = number_format(floatval($vatTotal) ,2);
        if($vatTotal > 0) {
            $vatInfo = "<tr style='background-color: #fbfce6;opacity: 0.5'>
                                    <td style='text-align:left;text-transform: capitalize;font-size:13px;color: #222222;padding-right: 3px !important;padding-top:2px;' colspan='3'>$vatInfoLabel <span class='pull-right'>$currencySign <span id='vatAmountInfo'>$vatTotalInfoAmount</span></span></td>                                           
                                </tr>";
//            $vatInfo = "<tr>
//                                  <td  style='font-size: 11px;text-align: center;color: darkgrey' colspan='3' >* $vatInfoLabel:&nbsp; $currencySign$vatTotalInfoAmount *</td>
//
//                                </tr>";
        }
    } else {
        $hideTotals1 = "style='text-align:left;text-transform: capitalize;'";
        $hideTotals2 = "style='text-align:right;width:2000px;padding-left: 0px;'";
    }

    if((float)$discountTotal ==0){
        $hideDiscountTotals1 = "style='display:none;'";
        $hideDiscountTotals2 = "style='display:none;'";
    } else {
        $hideDiscountTotals1 = "style='text-align:left;text-transform: capitalize;'";
        $hideDiscountTotals2 = "style='text-align:right;width:2000px;padding-left: 0px;'";
    }
    $defaultCurrency = getDefaultCurrency();
    $grandTotalBase = round($grandTotal / $defaultCurrency->rate,2);
    if($grandTotalBase != round($grandTotal,2)){
        $grandTotalBaseDisplay = number_format(floatval($grandTotalBase),2);
        $currencyCode = getCurrencyCode();
        $JCCcurrency = getCurrencyIso();
        $displayExchangeData = "style=''";
    } else {
        $displayExchangeData = "style='display:none;'";

    }
    $result = $result . "
                                    <table>
                                        $totalsInclVAT
                                        <tr>
                                            <td $hideTotals1>$subTotalTitle</td>
                                            <td $hideTotals2>$currencySign</td>
                                            <td id='subtotal' $hideTotals2>$displaySubTotal</td>
                                        </tr>
                                          $weightFeesElement
                                          <tr>
                                            <td $hideTotals1>$deliveryFeesTitle</td>
                                            <td $hideTotals2>$currencySign</td>
                                            <td id='deliveryTotal' $hideTotals2>$displayDeliveryFee</td>
                                        </tr>
                                        <tr>
                                            <td $hideDiscountTotals1>$discountTitle</td>
                                            <td $hideDiscountTotals2>$currencySign</td>
                                            <td id='discountTotal' $hideDiscountTotals2>$displayDiscountTotal</td>
                                        </tr>
                                        <tr>
                                            <td $hideTotals1>$vatTitle</td>
                                            <td $hideTotals2>$currencySign</td>
                                            <td id='vatAmount' $hideTotals2>$displayVatTotal</td>
                                            <input type='hidden' id='initialVAT' value='$displayVatTotal'>
                                        </tr>
                                        
                                        <tfoot>
                                            <tr>
                                                <td style='text-align: left;text-transform: capitalize;'>$grandTotalTitle</td>
                                                <td style='text-align: right;'>$currencySign</td>
                                                <td id='grandTotal' style='text-align: right;padding-left: 0px;'>$displayGrandTotal</td>
                                            </tr>
                                            <tr $displayExchangeData>
                                                <td style='text-align: left;text-transform: none;'>$currencyCode&nbsp;<i class='fa fa-arrow-right' style='font-weight: normal;'></i>&nbsp;$defaultCurrency->code</td>
                                                <td style='text-align: right;'>$defaultCurrency->sign</td>
                                                <td id='grandTotalBase' style='text-align: right;padding-left: 0px;'>$grandTotalBaseDisplay</td>
                                            </tr>
                                            $vatInfo
                                        </tfoot>
                                    </table>";
}


$deliveryMethods = '';
$deliveryMethodItems = array();
$hasSelectedMethod = false;
$firstDeliveryMethod = true;
$db->set_charset("utf8");
$stm = $db->prepare("SELECT Items.item_id,item_code,name,short_description,Vats.percentage FROM B2C_Configuration,Category_Item,Items,Vats WHERE Vats.vat_id=Items.vat_id AND Category_Item.category_id=B2C_Configuration.delivery_method_category_id AND B2C_Configuration.delivery_method_category_id > 0 AND Items.item_id = Category_Item.item_id ORDER BY Category_Item.position ASC");
$stm-> execute();
$stm-> bind_result($deliveryMethodItemID,$deliveryMethodItemCode,$deliveryMethodName,$deliveryMethodShortDescription,$vatPercent);
while ($stm->fetch()) {

    if($firstDeliveryMethod){$firstDeliveryMethod = false; $firstDeliveryMethodItemID = $deliveryMethodItemID;}

    if(strcmp($_SESSION['lang'] ,'el')==0 && strcmp($deliveryMethodShortDescription,'')!=0){$deliveryMethodName = $deliveryMethodShortDescription;}

    if (in_array($deliveryMethodItemID, $onlineOrderItemsID) && !$hasSelectedMethod) {$selected='selected';$hasSelectedMethod = true;}
    else {$selected='';}
    $itemPrice = number_format(getDefaultPrice($deliveryMethodItemID,$customerID),2);
    $vatAmount = $itemPrice*$vatPercent/100;

    $deliveryMethod = new stdClass();
    $deliveryMethod->id = $deliveryMethodItemID;
    $deliveryMethod->price = $itemPrice;
    $deliveryMethod->vat = $vatAmount;
    $deliveryMethod->name = $deliveryMethodName.' - '.$currencySign.' '.number_format(floatval($itemPrice+$vatAmount),2);
    $deliveryMethod->selected = $selected;
    array_push($deliveryMethodItems,$deliveryMethod);

}
$stm->close();

$db->set_charset("utf8");
$stm = $db->prepare("SELECT delivery_method,details FROM Online_Orders WHERE order_id=$orderID");
$stm-> execute();
$stm-> bind_result($selectedDeliverytMethodID,$orderNotes);
while ($stm->fetch()) {
    if(strcmp($selectedDeliverytMethodID,'')!=0) {
        $hasSelectedMethod = true;
    } else {
        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("UPDATE Online_Orders SET delivery_method=? WHERE order_id=?");
        $stm2->bind_param('ii',$firstDeliveryMethodItemID,$orderID);
        $stm2->execute();
        $stm2->close();
    }
}
$stm->close();

$selectedMethodCounter = 0;
foreach ( $deliveryMethodItems as $deliveryMethod) {
    $selectedMethodCounter++;
    if(!$hasSelectedMethod && $selectedMethodCounter == 1){
        $deliveryMethods .= "<option value='".$deliveryMethod->id."' data-price='".$deliveryMethod->price."' data-vat='".$deliveryMethod->vat."' selected >".$deliveryMethod->name."</option>";
    } else if(strcmp($selectedDeliverytMethodID,$deliveryMethod->id)==0) {
        $deliveryMethods .= "<option value='".$deliveryMethod->id."' data-price='".$deliveryMethod->price."' data-vat='".$deliveryMethod->vat."' selected >".$deliveryMethod->name."</option>";
    } else {
        $deliveryMethods .= "<option value='".$deliveryMethod->id."' data-price='".$deliveryMethod->price."' data-vat='".$deliveryMethod->vat."' ".$deliveryMethod->selected." >".$deliveryMethod->name."</option>";

    }

    $removeMethodsFromItems .= "productQuantityChanged($deliveryMethod->id,0);";

}
$result .= " <div class='form-group' style='margin-top:10px;'>
                   <textarea class='form-control' placeholder='$orderNotesHint' id='details'>$orderNotes</textarea>";

if($orderWithAttachment){
    $result .= "<style>
                    .orderAttachment-wrapper {position: relative;overflow: hidden;display: inline-block;cursor: pointer;margin-top: 10px;}
                    .orderAttachment-wrapper input[type='file'] {font-size: 1px;position: absolute;left: 0;top: 0;opacity: 0;}
                </style>
                   
                  <div class='form-control orderAttachment-wrapper'>
                    <input type='file' id='orderAttachment' accept='.pdf, image/*'  style='width: 100%;height: 100%;cursor: pointer;' />
                    <div id='orderAttachment-add-label' style='color: rgba(128,128,128,0.73);cursor: pointer;width: 100%;margin-bottom:3px;'>".$langu['add_order_attachment_label'] ." <span class='pull-right' style='text-decoration:none;'>(max 1.5MB)</span></div>
                  </div>
                  <button id='orderAttachment-clear-button' class='btn btn-theme' style='display:none;width: 100%;margin-top: -20px;padding:4px;padding-top:8px;border-color: lightgrey;border-top:0px;'>".$langu['remove_attachment_label'] ."</button>
                  
                  <script>
                    const fileInput = document.getElementById('orderAttachment');
                    const attachmentLabel = document.getElementById('orderAttachment-add-label');
                    const clearButton = document.getElementById('orderAttachment-clear-button');
                
                    fileInput.addEventListener('change', function() {

                        if (fileInput.files.length > 0) {
                            var filename = fileInput.files[0].name;
                            var filesize = ((fileInput.files[0].size/1024)/1024).toFixed(4); // MB
    
                        
                            if(filename.length > 17){
                                var firstFive = filename.substring(0, 7);
                                var lastFive = filename.substring(filename.length - 7);
                                filename = firstFive + '...' + lastFive;
                            }
                            if (filesize <= 1.5) {
                                attachmentLabel.textContent = 'Attachment: ' + filename;
                                clearButton.style.display = 'inline-block';
                            } else {
                                fileInput.value = '';
                                $('#orderAttachment-add-label').html('".$langu['file_size_exceeds_label'] ." 1.5MB ');
                                $('#orderAttachment-add-label').css('color', 'firebrick');
                                $('#orderAttachment-add-label').parent().css('border-color', 'firebrick');
                                setTimeout(function() {
                                    $('#orderAttachment-add-label').css('color', 'rgba(128,128,128,0.73)');
                                    $('#orderAttachment-add-label').parent().css('border-color', '');
                                    $('#orderAttachment-clear-button').click();
                                }, 2*1000);
                                clearButton.style.display = 'none';
                            }
                          } else {
                            attachmentLabel.textContent = '';
                            clearButton.style.display = 'none';
                          }
                    });
                    
                    clearButton.addEventListener('click', function() {
                      fileInput.value = '';
                      attachmentLabel.textContent = '".$langu['add_order_attachment_label'] ." 1.5 MB';
                      $('#orderAttachment-add-label').html('".$langu['add_order_attachment_label'] ." <span class=\'pull-right\' style=\'text-decoration:none;\'>(max 1.5MB)</span>');
                      clearButton.style.display = 'none';
                    });
                  </script>";
}

$result .=  "      <textarea class='form-control'  id='anonymousCheckoutUserInfo' style='display: none;'></textarea>
                 </div>";
if(strcmp($deliveryMethods,'')!=0 || $weightFeeItem > 0) {
    if(strcmp($deliveryMethods,'')!=0) {
        if ($includeVatOnPrice) {$deliveryTotalCalc = "+deliveryPrice + +deliveryPriceVat";} else {$deliveryTotalCalc = "+deliveryPrice";}

        $result .= "<div class='form-group' style='margin-top:10px;'>
                    <label>$DeliveryMethodLabel</label>
                    <select class='form-control'  id='deliveryMethod' name='deliveryMethod' style='background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;' >
                      $deliveryMethods
                    </select>";
    }
    if($showPrices) {
        $result .= "<script type='text/javascript'>

                                        function numberWithCommas(x) {
                                            return x.toString().replace(/\B(?=(\d{3})+(?!\d))/g, \",\");
                                        }
                                        
                                        function jsCalculateCartPrices() {
                                                                                     
                                            var subtotal =  $('#subtotal').html();
                                            var discountTotal = $('#discountTotal').html();
                                            var deliveryPrice = $('#deliveryMethod :selected').data('price');
                                            var deliveryPriceVat = $('#deliveryMethod :selected').data('vat');    
                                            var initialVATAmount = $('#initialVAT').val();  
                                            
                                            var weightPrice = $('#weightTotal').val();
                                            
                                            if (subtotal) {subtotal = subtotal.toString().replaceAll(',', '');} else {subtotal = 0;}
                                            if (discountTotal) {discountTotal = discountTotal.toString().replaceAll(',', '');}  else {discountTotal = 0;}
                                            if (deliveryPrice) {deliveryPrice = deliveryPrice.toString().replaceAll(',', '');}  else {deliveryPrice = 0;}
                                            if (deliveryPriceVat) {deliveryPriceVat = deliveryPriceVat.toString().replaceAll(',(', '');} else {deliveryPriceVat = 0;}
                                            if (initialVATAmount) {initialVATAmount = initialVATAmount.toString().replaceAll(',', '');} else {initialVATAmount = 0;}
                                            if (weightPrice) {weightPrice = weightPrice.toString().replaceAll(',', '');} else {weightPrice = 0;}
                                            
                                            var customDeliveryPrice = '$deliveryFee';
                                            deliveryPrice = parseFloat(deliveryPrice) + parseFloat(customDeliveryPrice);
                                            
                                            subtotal = parseFloat(subtotal).toFixed(2);
                                            discountTotal = parseFloat(discountTotal).toFixed(2);  
                                            deliveryPrice = parseFloat(deliveryPrice).toFixed(2);
                                            deliveryPriceVat = parseFloat(deliveryPriceVat).toFixed(2);
                                            initialVATAmount = parseFloat(initialVATAmount).toFixed(2);
                                            weightPrice = parseFloat(weightPrice).toFixed(2);

                                            var vatAmount = parseFloat(+initialVATAmount + +deliveryPriceVat).toFixed(2); 
                                            var grandTotal = parseFloat(+subtotal + +initialVATAmount + +deliveryPrice + +deliveryPriceVat + +weightPrice - +discountTotal).toFixed(2)
                                            var deliveryTotalincVat = parseFloat(+deliveryPrice + +deliveryPriceVat).toFixed(2);
                                            var grandTotalBase = parseFloat(+grandTotal / $defaultCurrency->rate).toFixed(2);
                                            
                                            
                                             
                                            
                                            $('#grandTotal').html(numberWithCommas(grandTotal));
                                            $('#grandTotalBase').html(numberWithCommas(grandTotalBase));
                                            $('#vatAmount').html(numberWithCommas(vatAmount)); 
                                            $('#vatAmountInfo').html(numberWithCommas(vatAmount));
                                            $('#deliveryTotal').html(numberWithCommas(deliveryPrice));
                                            $('#deliveryTotalincVat').html(numberWithCommas(deliveryTotalincVat));
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/getItemsInCartForOrder.php',
                                                data: {'type':'jsonTotal'},
                                                success: function (result) {
                                                   
                                                   $('#grandTotalBase').html(numberWithCommas(parseFloat(result).toFixed(2)));
                                                    
                                                },
                                                error: function(XMLHttpRequest, textStatus, errorThrown) { 
                                                }
                                                
                                                
                                            });
                                            
                                            
                                            var JCCPurchaseAmt = grandTotal.split('.').join(\"\");
                                            while (JCCPurchaseAmt.length < (12)) {JCCPurchaseAmt = '0' + JCCPurchaseAmt;}
                                            $('#JCCPurchaseAmt').val(JCCPurchaseAmt);
                                            
                                            var PurchaseAmt = $('#JCCPurchaseAmt').val();
                                            var JCCorderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/getEncriptedSignatureJCC.php',
                                                data: {
                                                    'JCCcurrency': '$JCCcurrency',
                                                    'JCCacquirerID': '$JCCacquirerID',
                                                    'PurchaseAmt': PurchaseAmt,
                                                    'JCCorderID': JCCorderID
                    
                                                },
                                                success: function (result) {
                                                   
                                                    $('#JCCSignature').val(result);
                                                    
                                                }
                                            });
                                            
                                        }
                                        jQuery(document).ready(function () {
                                           
                                            jsCalculateCartPrices();
                                           
                                        });
                                                
                                        $('#deliveryMethod').on('change', function() {  
                                            
                                            var deliveryMethodID = $('#deliveryMethod :selected').val();
                                            var orderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/updateOrderDeliveryMethod.php',
                                                data: { 'deliveryMethodID': deliveryMethodID,'orderID':orderID },
                                                success: function (result) {}
                                            });
                                            
                                            jsCalculateCartPrices();
                                        });
                                        
                                    </script>";
    }
    $result .=  "</div>";
}

$result .= "<div class=\"modal fade\" id=\"checkoutModal\" tabindex=\"-1\" role=\"dialog\" aria-labelledby=\"appInfoLabel\" aria-hidden=\"true\">
            <div class=\"modal-dialog\">
                <div class=\"modal-content\">
                    <div class=\"modal-header\">
                        <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\">&times;</button>
                        <h4 class='block-title' style=\"margin-left:10px;\" id='checkoutModalTitle'>".$langu['proceed_with_order_label'] ."</h4>
                    </div>

                    <div class=\"modal-body\" style=\"margin-top:5px;padding-top:5px;\">
";
$result = $result."<span id='anonymousCustomerInfoSpan' style='display:none;'></span>
                                    <div id='deliveryAddressDiv'>
                                     <label>$deliveryAddress</label>
                                     <table style='padding:0;margin:0;width: 100%;'><tr><td style='padding:0;'>
                                        <select class='form-control' title='Select' id='address' style='background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;'>";



$hasAddress = false;
$stm = $db->prepare("SELECT customer_address_id,address_line_1,address_line_2,postcode, primary_address From CustomerAddress WHERE customer_id='$customerID' AND NOT primary_address='deleted' ORDER BY primary_address DESC ");
$stm-> execute();
$stm-> bind_result($customerAddressID,$addressLine1,$addressLine2,$postCode,$primaryAddress);

$i = 0;
$subTotal=0;
$grandTotal=0;
$vatTotal=0;
$billingAddressSelection = '';
while ($stm->fetch()) {
    if($customerAddressID > 0){$hasAddress = true;}
    $selected = '';
    if(strcmp($primaryAddress,"yes") == 0){
        $selected ='selected';
    }
    $result.= "<option value='$customerAddressID' $selected>$addressLine1 $addressLine2  $postCode</option>";
    $billingAddressSelection.= "<option value='$customerAddressID' >$addressLine1 $addressLine2  $postCode</option>";
}
$stm->close();

$defaultDeliveryDate = date('Y-m-d',strtotime(date('Y-m-d') . "+$deliveryDaysAfter day"));
$deliveryDateValue = date('Y-m-d',strtotime(date('Y-m-d') . "+$deliveryDaysAfter day"));
$db->set_charset("utf8");
$stm = $db->prepare("SELECT delivery_date FROM Online_Orders WHERE order_id=$orderID");
$stm-> execute();
$stm-> bind_result($selectedDeliverytDate);
while ($stm->fetch()) {
    if(strcmp($selectedDeliverytDate,'0000-00-00')!=0){
        if($selectedDeliverytDate > $defaultDeliveryDate){
            $deliveryDateValue = $selectedDeliverytDate;
        }
    }
}
$stm->close();

if($B2CUser) {
    $addAddressButton = "</td><td style='padding:0;padding-left:5px;width: 1%;'><a href='./customer_address_form.php' class='btn btn-theme' style='padding: 9.2px 20px;'>".$langu['add_address_button']."</a>";
} else {
    $addAddressButton = '';
}

$billingAddressLabel = $langu['order_billing_address'];
if($useBillingAddress){
    $billingAddress = "<div id='billingAddressDiv' style='margin-top:10px;'>
                       <label>$billingAddressLabel</label>
                       <table style='padding:0;margin:0;width: 100%;'>
                       <tr><td style='padding:0;'>
                       <select class='form-control' title='Select' id='billAddress' style='background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;'>
                       $billingAddressSelection
                       </select>
                       $addAddressButton
                       </td></tr>
                       </table>
                       </div>
                       ";
}

$result.="</select>$addAddressButton</td></tr></table>
                                    </div>$billingAddress";

$result.="<div id='deliveryOptionsElement'></div>";

$result.="<div id='scheduledDeliveryOptionBox'><div class='form-group' style='margin-top:10px;' id='deliveryDateDiv'>
                                 <label id='deliveryDateLabel'>$deliveryDate</label>
                                  <input class='form-control deliveryDate' type='date' id='deliveryDate' name='deliveryDate' placeholder='yyyy-mm-dd' onChange='checkDate(false);' onkeydown='return false;' min='$defaultDeliveryDate' value='$deliveryDateValue' / >
                                     <script type='text/javascript'>
                                      jQuery(document).ready(function () {
                                          
                                        checkDate(true); 
                                                  
                                        $('#deliveryDate').on('change', function() {  
                                            
                                            var deliveryDate = $(this).val();
                                            var orderID = '$orderID';
                                            
                                            if(deliveryDate.localeCompare('')==0){
                                                $(this).val('$deliveryDateValue');
                                            }
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/updateOrderDeliveryDate.php',
                                                data: { 'deliveryDate': deliveryDate,'orderID':orderID },
                                                success: function (result) {}
                                            });
                                        });
                                       });
                                      
                                      $('#details').on('change', function() {  
                                            
                                            var details = $(this).val();
                                            var orderID = '$orderID';
                                            
                                            $.ajax({
                                                type: 'POST',
                                                url: './dbaccess/updateOrderNotes.php',
                                                data: { 'details': details,'orderID':orderID },
                                                success: function (result) {}
                                            });
                                        
                                       });
                                            
                                    </script>
                                    <div id='deliveryDateChanged' style='display:none'>
                                        <h2 style='font-size:14px;color:gray'><b> *".$langu['delivery_date_changed']."</b></h2>
                                    </div>
                                    </div>
                                   
                                    
                                ";

if($customTimeslots){
    $result.= "<div id='deliveryOptionSlotsWarning'><div id='noDeliverySlotsFound' class='form-control' style='width:100%;display:none'>
                    <center>
                        <h2 style='margin:2px;font-size:14px;color:firebrick'><b> *".$langu['no_delivery_slots_found']."*</b></h2>
                    </center>
                </div></div>
                <div id='timeSlotsElement' name='timeSlotsElement' class='notranslate'></div>
                <input type='hidden' id='timeSlotsDaysCounter' name='timeSlotsDaysCounter' value='0'>
                <script type='text/javascript'>
                    function getTimeSlots(){
                    
                        var deliveryDate = $('#deliveryDate').val();
                        var addressID = $('#address').val();
                        var timeSlotsText = $('#timeSlots option:selected').text();
                        
                        var postCode = $('#postcodeAnonymous').val();
                        var city = $('#cityAnonymous').val();
                    
                        $.ajax({
                              type: 'POST',
                              url: './dbaccess/getUserTimeSlot.php',
                              data: { 'deliveryDate': deliveryDate,'addressID':addressID,timeSlotsText:timeSlotsText,postCode:postCode,city:city },
                              success: function (json) {
                                  var obj = JSON.parse(json);
                                  var timeslotsElement = obj.timeslots;
                                  var deliveryOptionsElement = obj.deliveryOptions;
                                  var timeSlotsDaysCounter = $('#timeSlotsDaysCounter').val();
                                  
                                  $('#noDeliverySlotsFound').hide();
                                  $('#paymentModalFooter').show();
                                  $('#deliveryDate').show();
                                  $('#deliveryOptionsElement').html(deliveryOptionsElement);
                                  
                                  if(timeSlotsDaysCounter >= 6){
                                      
                                      $('#noDeliverySlotsFound').show();
                                      if(deliveryOptionsElement.localeCompare('')==0){
                                          $('#paymentModalFooter').hide();
                                          $('#deliveryDate').hide();
                                          $('#deliveryDateLabel').hide();
                                          $('#deliveryDateChanged').hide();
                                          $('#deliveryDate').val($('#deliveryDate').attr('min'));
                                          checkDate(true);
                                      }
                                      
                                  } else if(timeslotsElement ==  0){
                                      var curDate = new Date($('#deliveryDate').val());
                                      curDate.setDate(curDate.getDate() + 1);
                                      var dd = curDate.getDate();
                                      var mm = curDate.getMonth() + 1; //January is 0!
                                      var yyyy = curDate.getFullYear();
                                      if (dd < 10) {dd = '0' + dd;}
                                      if (mm < 10) {mm = '0' + mm;}
                                      var newDate = yyyy + '-' + mm + '-' + dd;
                                      $('#deliveryDate').val(newDate);
                                      $('#deliveryDate').trigger(\"change\");
                                      // $('#deliveryDate').attr('min', newDate);
                                      $('#deliveryDateChanged').show();
                                      $('#timeSlotsDaysCounter').val(parseInt($('#timeSlotsDaysCounter').val())+1);
                                  } else {
                                      $('#timeSlotsElement').html(timeslotsElement);                                      
                                  }
                              }
                          });
                          
                    }
                    
                    jQuery(document).ready(function () {
                        
                          getTimeSlots();
                                    
                          $('#deliveryDate').on('change', function() {
                              getTimeSlots();
                          });
                          
                          $('#address').on('change', function() {  
                              $('#timeSlotsDaysCounter').val(0);
                              getTimeSlots();
                          });
                          
                          $('#checkoutModalTrigger').click(function(){
                            getTimeSlots();
                            window.setInterval(function(){getTimeSlots();}, 60000);
                          });
                          
                          $('#placeAnonymousOrderButton').click(function(){
                            getTimeSlots();
                            window.setInterval(function(){getTimeSlots();}, 60000);
                          });
                      
                    });     
                      
                </script>";
}

if(true) {
    $hasJCC = false;
    $hasJCC_v2_saveCards = false; //allagh
    $paymentMethods = '';
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT payment_method_id,payment_method_code,name,alter_name,logo,allow_credit,merchant_id,acquirer_id,currency_iso_code,password,post_url,saving_cards FROM B2C_Payment_Methods WHERE active='yes' ORDER BY B2C_Payment_Methods.position ASC ");
    $stm->execute();
    $stm->bind_result($paymentMethodID, $paymentMethodCode, $paymentMethodName,$alterName, $paymentMethodLogo, $allowCredit, $merchantID, $acquirerID, $currencyISO, $paymentMethodPass, $paymentMethodFormURL,$savingCards);
    while ($stm->fetch()) {
        if(strcmp($_SESSION['lang'],'el')==0 && strcmp($alterName,'')!=0){$paymentMethodName = $alterName;}
        switch ($paymentMethodCode) {
            case "JCC":
                $JccSaveCardsFeature = false;
                if(strcmp($savingCards,'yes')==0){
                    $JccSaveCardsFeature = true;
                }
                $hasJCC = true;
                $JCCmerchantID = $merchantID;
                $JCCpassword = $paymentMethodPass;
                $JCCacquirerID = $acquirerID;
                if(strcmp($JCCcurrency,'')==0) {
                    $JCCcurrency = $currencyISO;
                }
                $JCCFormURL = $paymentMethodFormURL;
                $JCCDirectFormURL = str_replace('RedirectAuthLink','DirectAuthLink',$JCCFormURL);
                $payButtonFunction = "placeOrder();";
                $payButtonWithAttachmentFunction = "placeOrderWithAttachment();";
                $JCCformattedPurchaseAmt = str_pad(str_replace('.', '', $displayGrandTotal), 12, '0', STR_PAD_LEFT);
                break;
            case 'PAYPAL':
                $payButtonFunction = "placeOrder();";
                $payButtonWithAttachmentFunction = "placeOrderWithAttachment();";
                break;
            case 'STRIPE':
                $payButtonFunction = "placeOrder();";
                $payButtonWithAttachmentFunction = "placeOrderWithAttachment();";
                break;
            case 'SIX':
                $payButtonFunction = "placeOrder();";
                $payButtonWithAttachmentFunction = "placeOrderWithAttachment();";
                break;
            case 'JCC_V2':
                if(strcmp($savingCards,'yes')==0 && $userID>0 && $customerID>0){
                    $hasJCC_v2_saveCards = true; //allagh
                }
                $payButtonFunction = "placeOrder();";
                $payButtonWithAttachmentFunction = "placeOrderWithAttachment();";
                break;
        }
        if (strcmp($paymentMethodLogo, '') != 0 && file_exists(ROOT . "b2b/assets/img/$paymentMethodLogo")) {
            $paymentMethodLogo = "./assets/img/$paymentMethodLogo";
        } else {
            $paymentMethodLogo = "./assets/img/paymenticon.png";
        }
        if (strcmp($allowCredit, 'yes') != 0) {
            $allowCredit = 'no';
        }
        if(strcmp($allowCredit,'yes')==0 || $showPrices) {
            if($blockCreditOrders && strcmp($allowCredit,'yes')==0){

            } else {
                if (isset($_GET['pm']) && $_GET['pm'] == $paymentMethodID) {
                    $paymentMethods .= "<option value='$paymentMethodID' data-logo='$paymentMethodLogo' data-iscredit='$allowCredit' data-method='$paymentMethodCode' selected>  $paymentMethodName </option>";

                } else {
                    $paymentMethods .= "<option value='$paymentMethodID' data-logo='$paymentMethodLogo' data-iscredit='$allowCredit' data-method='$paymentMethodCode'>  $paymentMethodName </option>";

                }
            }

        }
    }
    $stm->close();


    if (strcmp($paymentMethods, '') != 0) {
        $paymentMethods = "<label id='paymentMethodLabel'>$paymentMethodLabel</label><br>
                       <select class='form-control'  id='paymentMethod' name='paymentMethod' style='width: 80%;display: inline-block;background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;' >
                       $paymentMethods
                       </select>
                       <img  id='paymentMethodLogo' class='form-control' height='auto' style='padding:0px;display: inline-block;width: 19%;' >";
    }

    $result .= "</div><div class='form-group' style='margin-top:10px;'>
                                 $paymentMethods
                                  </div>
                                  <script type='text/javascript'>
                                        jQuery(document).ready(function () {
                                            $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo'));
                                            var iscredit = $('#paymentMethod :selected').data('iscredit');
                                            var code = $('#paymentMethod :selected').data('method');

                                                if(!iscredit || iscredit.localeCompare('yes') === 0){
                                                    $('#placeOrderButton').show();
                                                    $('#payOrderButton').hide();
                                                    $('#paymentFormJCC').hide();
                                                    $('#cardSelectionTableV2').hide();
                                                } else {
                                                    $('#placeOrderButton').hide();
                                                    $('#payOrderButton').show();
                                                    $('#paymentFormJCC').show();
                                                    $('#cardSelectionTableV2').show();
                                                    
                                                }
                                            
                                                if(code && code.localeCompare('JCC') === 0){
                                                    $('#withJCCDirect').show();
                                                } else {
                                                    $('#withJCCDirect').hide();
                                                }
                                                
                                                if(code && code.localeCompare('JCC_V2') === 0){
                                                    $('#cardSelectionTableV2').show();
                                                } else {
                                                    $('#cardSelectionTableV2').hide();
                                                }
                                            
                                            $('#paymentMethod').on('change', function() {
                                                
                                                $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo')); 
                                                
                                                var iscredit = $('#paymentMethod :selected').data('iscredit');
                                                var code = $('#paymentMethod :selected').data('method');
                                                if(iscredit.localeCompare('yes') === 0){
                                                    $('#placeOrderButton').show();
                                                    $('#payOrderButton').hide();
                                                    $('#paymentFormJCC').hide();
                                                } else {
                                                    $('#placeOrderButton').hide();
                                                    $('#payOrderButton').show();
                                                    $('#paymentFormJCC').show();
                                                    
                                                }
                                                
                                                if(code.localeCompare('JCC') === 0){
                                                    $('#withJCCDirect').show();
                                                    $('#cardSelectionTable').show();
                                                } else {
                                                    $('#withJCCDirect').hide();
                                                    $('#cardSelectionTable').hide();
                                                }
                                                //allagh
                                                if(code.localeCompare('JCC_V2') === 0){
                                                    $('#cardSelectionTableV2').show();
                                                } else {
                                                    $('#cardSelectionTableV2').hide();
                                                }
                                                
                                                 $('#saveCardInputJCC2').change(function() { //allagh
                                                    if(this.checked) {
                                                        $('#scJccV2').val('yes');
                                                    } else {
                                                        $('#scJccV2').val('no');
                                                    }
                                                });
                                                
                                            });
                                        });
                                        
                                  </script>";
    if ($hasJCC) {
//    $JCCcurrency = "978";
//    $JCCacquirerID = "402971";
        $JCCorderID = $orderID;
        $captureFlag = "A"; // • A: automatically capture • M: do not automatically capture; will capture manually at a later stage
        $toEncrypt = $JCCpassword . $JCCmerchantID . $JCCacquirerID . $JCCorderID . $JCCformattedPurchaseAmt . $JCCcurrency;
        $sha1Signature = sha1($toEncrypt);
        $base64Sha1Signature = base64_encode(pack("H*", $sha1Signature));
        $result .= "    
            <style>
                .useCardCheck {text-transform: none;padding-right: 5px;font-size: 17px;color: transparent;}
                .cardSelector {border-left: 0px solid white;border-right: 0px solid white;}
                .cop-switch {position: relative;display: inline-block;width: 40px;height: 24px;}
                .cop-switch input {opacity: 0;width: 0;height: 0;}
                .cop-switch-slider { position: absolute;cursor: pointer;top: 0;left: 0;right: 0;bottom: 0;background-color: #ccc;-webkit-transition: .4s;transition: .4s;border-radius: 34px;}
                .cop-switch-slider:before {position: absolute;content: '';height: 16px;width: 16px;left: 4px;bottom: 4px;background-color: white;-webkit-transition: .4s;transition: .4s;border-radius: 50%;}
                input:checked + .cop-switch-slider {background-color: $themeColor;}
                input:focus + .cop-switch-slider {box-shadow: 0 0 1px $themeColor;}
                input:checked + .cop-switch-slider:before {-webkit-transform: translateX(16px);-ms-transform: translateX(16px);transform: translateX(16px);}
            </style> ";

        $result .= "
          <div class='form-group' style='margin-top:10px;'>
              <form method='post' name='paymentFormJCC' id='paymentFormJCC' action='$JCCFormURL'>";
        if($JccSaveCardsFeature) {
            $result .= "      
                <table style='width: 100%;background-color: ghostwhite;border-spacing: 0 2px;border: 2px solid whitesmoke;' class='pull-right' id='cardSelectionTable'>";
            $cardsResult = '';
            $saveCardLabel = $langu['save_card_label'];
            $newCardLabel = $langu['new_card_label'];
            $removeLabel = $langu['remove_label'];
            $payWithLabel = $langu['pay_with_label'];
            $cardsCounter=0;
            $db->set_charset("utf8");
            $stm = $db->prepare("SELECT padded_card_number,hash_value FROM B2B_User_Cards WHERE customer_id='$customerID' AND user_id='$userID'");
            $stm->execute();
            $stm->bind_result($paddedCardNumber, $hashValue);
            while ($stm->fetch()) {
                $firstDigit = substr($paddedCardNumber, 0, 1);
                $paddedCardNumber = str_replace('X', '*', $paddedCardNumber);
                switch ($firstDigit) {
                    case '3':
                        $cardBrandIcon = 'american-express-icon.png';
                        break;
                    case '4':
                        $cardBrandIcon = 'visa-card-icon.png';
                        break;
                    case '5':
                        $cardBrandIcon = 'master-card-icon.png';
                        break;
                    default:
                        $cardBrandIcon = 'generic-card-icon.png';
                }
                $cardsCounter++;
                $cardsResult .= "<tr class='cardSelector' id='cardSelector$cardsCounter' style='background-color: white;cursor: pointer'>
                                <td style='width: 1%;' onclick='selectCard(this,\"$hashValue\");'>
                                    <img src='./assets/img/$cardBrandIcon' width='auto' height='40'>
                                </td>
                                <td style='text-align: left;text-transform:none;font-size: 12px;' onclick='selectCard(this,\"$hashValue\");'>
                                    $paddedCardNumber
                                    <span class='useCardCheck' style='margin: 0px;font-size: 11px;' ><i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                                </td>
                                <td style='width: 30%;'>
                                    <div class='useCardCheck pull-right' style='margin: 0px;font-size: 13px;' ><i class='fa fa-trash-o' style='color: firebrick;' onclick='removeJccCard(this,\"$hashValue\",$customerID,$userID);'> $removeLabel</i></div>
                                </td>
                             </tr>";
            }
            $stm->close();
            $result .= "<tr><td colspan='3' style='text-align: left;text-transform:none;'><h3 style='text-transform: capitalize;margin: 0px;width: auto;'> $payWithLabel:</h3></td></tr>";
            $result .= $cardsResult;
            $result .= "<tr class='cardSelector' id='cardSelector0' style='cursor: pointer'>
                        <td style='width: 1%;'  onclick='selectCard(this,\"\");'><img src='./assets/img/generic-card-icon.png' width='auto' height='40'></i></td>
                        <td style='text-align: left;text-transform:none;font-size: 13px;' colspan='3' onclick='selectCard(this,\"\");'>
                            <span class='pull-left selectCardLabel' style='margin: 0px;font-size: 13px;' >$newCardLabel</span>
                            <span class='pull-left useCardCheck' style='display: inline-block'>$newCardLabel <i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                            <span class='pull-right useCardCheck' style='display: inline-block'>
                                <span style='padding-top:5px;font-size: 13px;'>$saveCardLabel</span>
                                <label class='cop-switch' style='padding:5px;margin-right: 2px;'>
                                    <input type='checkbox'  id='saveCardCheckbox'>            
                                    <span class='cop-switch-slider'></span>
                                </label>
                            </span>
                        </td>
                    </tr>
                </table>";
        }


        $result .= "<script>
                    $('#cardSelector$cardsCounter').children('td:first').click();
                    
                    function removeJccCard(element,value,cid,uid){
                        removeCardJCC(value,cid,uid);
                        $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"D\" />');
                        $('#MerRespURL').val('https://" . HTML_PATH . "/cop/b2b/dbaccess/JCCRedirect.php?removeCard=y&urds=$userID');
                        document.forms[\"paymentFormJCC\"].submit();
                        $('#checkoutContainer').empty();
                        $('#checkoutContainer').append('<div id=\"preloader\"><div id=\"preloader-status\"><div class=\"spinner\"><div class=\"rect1\"></div><div class=\"rect2\"></div><div class=\"rect3\"></div><div class=\"rect4\"></div><div class=\"rect5\"></div></div><div id=\"preloader-title\">$removeLabel</div></div>');
                        
                        
                    }
                    
                    
                    
                    function selectCard(td,hashValue){
                        var tr = $(td).closest('tr');
                        $(\".cardSelector\").css(\"border-color\",\"ghostwhite\");
                        $(\".cardSelector\").css(\"background-color\",\"white\");
                        $(\".cardSelector\").css(\"font-weight\",\"\");
                        $(\".useCardCheck\").css(\"color\",\"transparent\").hide();
                        $(\".selectCardLabel\").show();
                        $(tr).css(\"border-color\",\"lightgray\");
                        $(tr).css(\"background-color\",\"ghostwhite\");
                        $(tr).css(\"font-weight\",\"bolder\");
                        $(tr).find(\".useCardCheck\").css(\"color\",\"$themeColor\").show();
                        $(tr).find(\".selectCardLabel\").hide();
                        
                        if(hashValue.localeCompare('')!=0){
                            $('#saveCardCheckbox').prop('checked', false);
                            $('#paymentFormJCC').attr('action', '$JCCDirectFormURL');
                            $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"H\" /><br><input type=\"hidden\" name=\"hashValue\" value=\"'+hashValue+'\">');
                            
                        } else {
                            $('#paymentFormJCC').attr('action', '$JCCFormURL');
                            $('#saveCardInput').html('');
                        }
                        
                    }
                </script>
                <input type='hidden' name='Version' value='1.0.0'>
                <input type='hidden' name='MerID' value='$JCCmerchantID'>
                <input type='hidden' name='AcqID' value='$JCCacquirerID'>
                <input type='hidden' name='MerRespURL' id='MerRespURL' value='https://" . HTML_PATH . "/cop/b2b/dbaccess/JCCRedirect.php?urds=$userID'>
                <input type='hidden' name='PurchaseAmt' id='JCCPurchaseAmt' value='$JCCformattedPurchaseAmt'>
                <input type='hidden' name='PurchaseCurrency' value='$JCCcurrency'>
                <input type='hidden' name='PurchaseCurrencyExponent' value='2'>
                <input type='hidden' name='OrderID' id='JCCOrderID' value='$JCCorderID'> 
                <input type='hidden' name='CaptureFlag' value='$captureFlag'> 
                <input type='hidden' name='Signature' id='JCCSignature' value='$base64Sha1Signature'>
                <input type='hidden' name='SignatureMethod' value='SHA1'>
                <div id='saveCardInput'></div>";
        if (strpos($JCCFormURL, 'RedirectAuthLink') === false && strpos($JCCFormURL, 'DirectAuthLink') !== false ) {
            $result .= "
                <!-- Text fields for customer to enter his credit card details --> 
                <div style='width:100%;background-color: white;border: 2px solid whitesmoke;border-radius: 2px;margin-bottom: 10px;' class='pull-left' id='withJCCDirect'>
                    <div style='padding: 2px;margin:0px;border-bottom: 1px solid whitesmoke;background-color: ghostwhite'>
                    <h3 style='text-transform: capitalize;margin: 0px;width: auto;'>
                        <center>Payment Details</center>
                    </h3>
                    </div>
                
                <table style='width: 100%;'>

                <tr>
                <td  colspan='2' style='padding: 0px;'>
                <table>
                    <tr>
                        <td style='text-transform: capitalize;padding: 0px;padding-left: 6px;font-size: 14px;' ><div class='pull-left'>Card Number</div></td>
                    </tr> 
                    <tr>  
                        <td style='padding: 4px;'>
                            <div class='form-control' >
                                <table style='width: 100%;'>
                                    <tr >
                                        <td style='padding:0px;padding-left:5px;'>
                                            <input type='number' name='CardNo' style='width: auto;background-color:transparent;border-color:transparent;border: 0px;font-size: 14px;' class='pull-left' placeholder='Valid Card Number'>
                                        </td>
                                        <td style='padding:0px;padding-right: 5px;'><span class='pull-right'><i class='fa fa-credit-card'></i></span></td>
                                    </tr>
                                </table>
                            </div>
                        </td>   
                    </tr>
                </table>

                
                </td>
                </tr>
                <tr>
                <td style='text-transform: capitalize;padding: 0px;padding-left: 6px;font-size: 14px;'>
                <div class='pull-left'>Expiration Date</div>
                </td>
                <td style='padding: 0px;padding-left: 10px;font-size: 14px;'>
                <div class='pull-left'>CV <span style='text-transform: capitalize;'>Code</span></div>
                </td>
                </tr>
                <tr>
                <!-- Instead of Text box, Select fields could be used instead for a more user friendly form -->
                <td>
                <div class='form-control'>
                <table>
                    <tr >
                        <td style='padding:0px;'>
                            <select id='CardExpMonth' class='text-center' style='padding-right:5px;padding-left:0px;border: 0px;width: auto;-webkit-appearance: none;-moz-appearance: none;text-indent: 1px;text-overflow: \"\";'>
                                <option value='01'> 01 </option>
                                <option value='02'> 02 </option>
                                <option value='03'> 03 </option>
                                <option value='04'> 04 </option>
                                <option value='05'> 05 </option>
                                <option value='06'> 06 </option>
                                <option value='07'> 07 </option>
                                <option value='08'> 08 </option>
                                <option value='09'> 09 </option>
                                <option value='10'> 10 </option>
                                <option value='11'> 11 </option>
                                <option value='12'> 12 </option>
                            </select>
                        </td>
                        <td style='padding:0px;width:1%;'>&nbsp;/&nbsp;&nbsp;</td>
                        <td style='padding:0px;text-align: left;'>
                            <select id='CardExpYear' class='text-center' style='padding-right:5px;padding-left:0px;border: 0px;width: auto;-webkit-appearance: none;-moz-appearance: none;text-indent: 1px;text-overflow: \"\";'>";
            $year = date('Y');
            for ($i = 0; $i <= 10; $i++) {
                $yearOption = (int)$year + $i;
                $yearValue = $yearOption - 2000;
                $result .= "<option value='$yearValue'> $yearOption </option>";
            }
            $result .= "   
                            </select>
                        </td>
                        <td style='padding:0px;padding-left:5px;padding-right: 5px;'><i class='fa fa-calendar'></i></td>
                    </tr>
                </table>
                </div>
                <input type='hidden' id='CardExpDate' name='CardExpDate' placeholder='MMYY' class='text-center' style='border: 1px solid silver;border-radius: 10px;'>
                </td>

                <td>
                <div class='form-control'>
                <table>
                    <tr >
                        <td style='padding:0px;padding-left:5px;'><input type='text' name='CardCVV2' class='pull-left' placeholder='CVC / CVV' style='border: 0px;width: 80px;'></td>
                        <td style='padding:0px;padding-right: 5px;'><i class='fa fa-lock pull-right'></i></td>
                    </tr>
                </table>
                </div>
                
                </td>
                </tr>
                </table>
                </div>
                <script type='text/javascript'>
                    jQuery(document).ready(function () {
                        var JccCardMonth = $('#CardExpMonth').val();
                        var JccCardYear  = $('#CardExpYear').val();
                        $('#CardExpDate').val(JccCardMonth + '' + JccCardYear);
                        
                        $('#CardExpMonth').on('change', function() {
                            var JccCardMonth = $('#CardExpMonth').val();
                            var JccCardYear  = $('#CardExpYear').val();
                            $('#CardExpDate').val(JccCardMonth + '' + JccCardYear);
                        });
                        
                        $('#CardExpYear').on('change', function() {
                            var JccCardMonth = $('#CardExpMonth').val();
                            var JccCardYear  = $('#CardExpYear').val();
                            $('#CardExpDate').val(JccCardMonth + '' + JccCardYear);
                        });
                    });
              </script>";
        }
        $result .= "
              </form>
              <script>
                $('#saveCardCheckbox').change(function() {
                    if(this.checked) {
                        $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"R\" />');
                    } else {
                        $('#saveCardInput').html('');
                    }
                });
                
                
              </script>
          </div>";
    }

    if ($hasJCC_v2_saveCards){ //allagh
        $stm = $db->prepare("SELECT merchant_id,password,currency_iso_code,post_url,acquirer_id FROM B2C_Payment_Methods WHERE payment_method_code = 'JCC_V2'");
        $stm->execute();
        $stm->bind_result($userNameJCC, $passwordJCC, $currencyJCC,$postURL,$prefixClient);
        while ($stm->fetch()) {}
        $stm->close();
        $clientID = "$userID-$customerID-$prefixClient";
        $apiURL = "$postURL/rest/getBindings.do";

        $ch = curl_init();
        curl_setopt_array($ch, array(
            CURLOPT_URL => "$apiURL",
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => array('userName' => "$userNameJCC",'password' => "$passwordJCC",'clientId' => "$clientID",'bindingType' => 'C'),
        ));
        $response = curl_exec($ch);

        if (curl_errno($ch)) {
            echo 'Σφάλμα cURL: ' . curl_error($ch);
        } else {
            $body = json_decode($response, true);
            $saveCardsJCC_v2_array = $body['bindings'];
            if (true){
                $cardsCounterV2=0;
                $result .= "<table style='width: 100%;background-color: ghostwhite;border-spacing: 0 2px;border: 2px solid whitesmoke;' class='pull-right' id='cardSelectionTableV2'>";
                $result.="
                                     <style>
                                    .useCardCheck {text-transform: none;padding-right: 5px;font-size: 17px;color: transparent;}
                                    .cardSelector {border-left: 0px solid white;border-right: 0px solid white;}
                                    .cop-switch {position: relative;display: inline-block;width: 40px;height: 24px;}
                                    .cop-switch input {opacity: 0;width: 0;height: 0;}
                                    .cop-switch-slider { position: absolute;cursor: pointer;top: 0;left: 0;right: 0;bottom: 0;background-color: #ccc;-webkit-transition: .4s;transition: .4s;border-radius: 34px;}
                                    .cop-switch-slider:before {position: absolute;content: '';height: 16px;width: 16px;left: 4px;bottom: 4px;background-color: white;-webkit-transition: .4s;transition: .4s;border-radius: 50%;}
                                    input:checked + .cop-switch-slider {background-color: $themeColor;}
                                    input:focus + .cop-switch-slider {box-shadow: 0 0 1px $themeColor;}
                                    input:checked + .cop-switch-slider:before {-webkit-transform: translateX(16px);-ms-transform: translateX(16px);transform: translateX(16px);}
                                </style>
                                ";
                $cardsResult_v2 = '';
                $saveCardLabel = $langu['save_card_label'];
                $newCardLabel = $langu['new_card_label'];
                $removeLabel = $langu['remove_label'];
                $payWithLabel = $langu['pay_with_label'];
                foreach ($saveCardsJCC_v2_array as $savedCard){
                    $paymentSystem              = $savedCard['paymentSystem'];
                    $displayLabel               = $savedCard['displayLabel'];
                    $expiryDate                 = $savedCard['expiryDate'];
                    $maskedPan                  = $savedCard['maskedPan'];
                    $expiryDateFormat           = substr($expiryDate, 4, 6)."/".substr($expiryDate, 0, 4);

                    switch ($paymentSystem) {
                        case 'VISA':
                            $cardBrandIcon = 'visa-card-icon.png';
                            break;
                        case 'MASTERCARD':
                            $cardBrandIcon = 'master-card-icon.png';
                            break;
                        default:
                            $cardBrandIcon = 'generic-card-icon.png';
                    }
                    $cardsCounterV2++;
                    $cardsResult_v2 .= "<tr class='cardSelectorV2' id='cardSelectorV2$cardsCounterV2' style='background-color: white;cursor: pointer'>
                                <td style='width: 1%;' onclick='selectCardV2(this,\"$maskedPan\");'>
                                    <img src='./assets/img/$cardBrandIcon' width='auto' height='40'>
                                </td>
                                <td style='text-align: left;text-transform:none;font-size: 12px;' onclick='selectCardV2(this,\"$maskedPan\");'>
                                    $displayLabel
                                    <span class='useCardCheck' style='margin: 0px;font-size: 11px;' ><i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                                </td>
                                <td style='width: 10%;'>
                                    <div class='useCardCheck pull-right' style='margin: 0px;font-size: 13px;' >$expiryDateFormat</div>
                                </td>
                                <td style='width: 30%;'>
                                    <div class='useCardCheck pull-right' style='margin: 0px;font-size: 13px;' ><i class='fa fa-trash-o' style='color: firebrick;' onclick='removeJccV2Card(this,\"$maskedPan\",\"$clientID\",\"$cardsCounterV2\");'> $removeLabel</i></div>
                                </td>
                             </tr>";
                }
                $result .= "<tr><td colspan='3' style='text-align: left;text-transform:none;'><h3 style='text-transform: capitalize;margin: 0px;width: auto;'> $payWithLabel:</h3></td></tr>";
                $result .= $cardsResult_v2;
                $result .= "<tr class='cardSelectorV2' id='cardSelectorV20' style='cursor: pointer'>
                        <td style='width: 1%;'  onclick='selectCardV2(this,\"\");'><img src='./assets/img/generic-card-icon.png' width='auto' height='40'></i></td>
                        <td style='text-align: left;text-transform:none;font-size: 13px;' colspan='3' onclick='selectCardV2(this,\"\");'>
                            <span class='pull-left selectCardLabel' style='margin: 0px;font-size: 13px;' >$newCardLabel</span>
                            <span class='pull-left useCardCheck' style='display: inline-block'>$newCardLabel <i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                            <span class='pull-right useCardCheck' style='display: inline-block'>
                                <span style='padding-top:5px;font-size: 13px;'>$saveCardLabel</span>
                                <label class='cop-switch' style='padding:5px;margin-right: 2px;'>
                                    <input type='checkbox'  id='saveCardInputJCC2'>            
                                    <span class='cop-switch-slider'></span>
                                    <input id='scJccV2' value='no' type='hidden'>
                                </label>
                            </span>
                        </td>
                    </tr>
                </table>
                
                <input type='hidden' id='mpJssV2'>
                <input type='hidden' id='pwbJssV2'>";
                $result .="
                        <script>
                            jQuery(document).ready(function () {
                             $('#saveCardInputJCC2').change(function() {
                                    if(this.checked) {
                                        $('#scJccV2').val('yes');
                                    } else {
                                        $('#scJccV2').val('no');
                                    }
                                });
                             });
                            
                            $('#cardSelectorV2$cardsCounterV2').children('td:first').click();
                        
                            function removeJccV2Card(element,maskedPan,clientID,counterCards){
                                $.ajax({
                                    type: \"POST\",
                                    url: \"./dbaccess/removeJccCardV2.php\",
                                    data: { \"maskedPan\": maskedPan,\"clientID\": clientID},
                                    success: function (result) {
                                        $('#cardSelectorV20').children('td:first').click();
                                    }
                               });
                                elementCardRemove = document.getElementById('cardSelectorV2'+counterCards);
                                elementCardRemove.remove();
                            }
                            
                            function selectCardV2(td,maskpan){
                                var tr = $(td).closest('tr');
                                $(\".cardSelector\").css(\"border-color\",\"ghostwhite\");
                                $(\".cardSelector\").css(\"background-color\",\"white\");
                                $(\".cardSelector\").css(\"font-weight\",\"\");
                                $(\".useCardCheck\").css(\"color\",\"transparent\").hide();
                                $(\".selectCardLabel\").show();
                                $(tr).css(\"border-color\",\"lightgray\");
                                $(tr).css(\"background-color\",\"ghostwhite\");
                                $(tr).css(\"font-weight\",\"bolder\");
                                $(tr).find(\".useCardCheck\").css(\"color\",\"$themeColor\").show();
                                $(tr).find(\".selectCardLabel\").hide();
                                
                                if(maskpan.localeCompare('')!=0){
                                    $('#pwbJssV2').val('yes');
                                    $('#mpJssV2').val(maskpan);
                                    $('#saveCardInputJCC2').prop('checked', false);
                                    $('#scJccV2').val('no');
                                } else {
                                    $('#pwbJssV2').val('no');
                                    $('#mpJssV2').val('');
                                }
                            }
                        
                        </script>
                    ";
            }
        }
        curl_close($ch);
    }
    $result .= "</div>";
}

$result .= "<footer class=\"modal-footer\" id='paymentModalFooter' style='padding: 0px;border-top: 0px;' >";

if($B2CUser && !$hasAddress){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['address_required']."</center></h3></label>";
}

if($useLoyalties && $blockLoyaltyItemsBasedOnBalance && $customerLoyaltyAllowance < 0){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $customerLoyaltyAllowanceDisplay = abs($customerLoyaltyAllowance);
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['missing']." $customerLoyaltyAllowanceDisplay $loyaltyPointsLabel</center></h3></label>";
}

if($itemOverMaxStock && $denyOrderOverStock){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['insufficient_stock']."</center></h3></label>";

}
if($itemOverStock && $denyOrderOverStock){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['insufficient_stock']."</center></h3></label>";

}
if($hasInactiveItem){
    $hideButtons = "display:none;";
    $allowOrder = false;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3><center>".$langu['remove_not_available_products']."</center></h3></label>";
}
if($minimumOrder > str_replace(',','',$displayGrandTotal) && $showPrices){
    $minimumOrderDisplay = number_format("$minimumOrder","2",".",",");
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;text-transform: unset;' id='warningLabel'><h3><center>".$langu['minimum_order_warning'].": $currencySign$minimumOrderDisplay</center></h3></label>";

    $remainingQty = $minimumOrder - str_replace(',','',$displayGrandTotal);
    $qtyFilledPercent = str_replace(',','',$displayGrandTotal) / $minimumOrder * 100;
    $floatingLabelPercent = $qtyFilledPercent + 4;
    $remainingQtyDisplay = number_format("$remainingQty","2",".",",");


    $result .= "<div style='width: $floatingLabelPercent%;min-width:fit-content;max-width: 98%;margin-left: 1%;margin-right: 1%;margin-bottom: 11px;'>
                    <span class='pull-right percent-bubble' style='color: black;'>&nbsp;&nbsp;".$langu['minimum_price_left_warning']."&nbsp;&nbsp;<b>$currencySign$remainingQtyDisplay</b> &nbsp;</span>
                </div>
                <br>
                <div style='width: 98%;background-color: lightgrey;margin-left: 1%;margin-right: 1%;border-radius: 10px;' >
                    <div style='width: $qtyFilledPercent%;min-width:fit-content;height: 30px;padding:3px;background-color: $themeColor;margin-bottom: 5px;border-radius: 10px;'>
                        <span class='pull-right' style='color:$textColor;border-radius: 10px;'><b>$currencySign$displayGrandTotal</b>&nbsp;&nbsp;</span>
                    </div>
                </div>";

    $result .= "<style>
                .percent-bubble { position: relative;border: 1px solid $themeColor;color: #FFFFFF;text-align: center;width: fit-content;height: fit-content;border-radius: 10px;padding: 0px;}
                .percent-bubble:after {content: '';position: absolute;display: block;width: 0;z-index: 1;border-style: solid;border-color: $themeColor transparent;border-width: 10px 10px 0;bottom: -10px;left: 50%;margin-left: -10px;}
                </style>";

    $hideButtons = "display:none;";
    $allowOrder = false;
}
if($minimumOrderQty > $sumOFQties){
    $remainingQty = $minimumOrderQty - $sumOFQties;
    $qtyFilledPercent = $sumOFQties / $minimumOrderQty * 100;
    $floatingLabelPercent = $qtyFilledPercent + 4;
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;text-transform: unset;' id='warningLabel'><h3><center>".$langu['minimum_qty_order_warning'].": $minimumOrderQty</center></h3></label>";

    $result .= "<div style='width: $floatingLabelPercent%;min-width:fit-content;max-width: 98%;margin-left: 1%;margin-right: 1%;margin-bottom: 11px;'>
                    <span class='pull-right percent-bubble' style='color: black;'>&nbsp;&nbsp;".$langu['minimum_qty_left_warning'].":&nbsp;&nbsp;<b>$remainingQty</b> &nbsp;</span>
                </div>
                <br>
                <div style='width: 98%;background-color: lightgrey;margin-left: 1%;margin-right: 1%;border-radius: 10px;' >
                    <div style='width: $qtyFilledPercent%;min-width:fit-content;height: 30px;padding:3px;background-color: $themeColor;margin-bottom: 5px;border-radius: 10px;'>
                        <span class='pull-right' style='color:$textColor;border-radius: 10px;'><b>$sumOFQties</b>&nbsp;&nbsp;</span>
                    </div>
                </div>";

    $result .= "<style>
                .percent-bubble { position: relative;border: 1px solid $themeColor;color: #FFFFFF;text-align: center;width: fit-content;height: fit-content;border-radius: 10px;padding: 0px;}
                .percent-bubble:after {content: '';position: absolute;display: block;width: 0;z-index: 1;border-style: solid;border-color: $themeColor transparent;border-width: 10px 10px 0;bottom: -10px;left: 50%;margin-left: -10px;}
                </style>";

    $hideButtons = "display:none;";
    $allowOrder = false;
}
if($warnOverCreditLimit && !$hasInactiveItem){
    $stm = $db->prepare("SELECT credit_limit,balance From Customers WHERE customer_id='$customerID' AND customer_id LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($creditLimit,$runningBalance);
    while ($stm->fetch()) {}
    $stm->close();
    $creditCheck = (float)$runningBalance + (float)$displayGrandTotal;

    if($creditLimit < (float)$creditCheck && $creditLimit > 0){
        $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='warningLabel'><h3 style='color: firebrick;'><center>".$langu['over_credit_limit_warning']."</center></h3></label>";

        if($blockOrderOverCreditLimit) {
            $hideButtons = "display:none;";
            $allowOrder = false;
        }
    }

}
if($allowQuotation && $hasItem) {
    $result .= "<label style='width: 100%;color: firebrick; margin-top: 5px;' id='confirmTenderLabel'><h3><center>".$langu['confirm_tender_label']."</center></h3></label>";

    $result .= "<a class='btn btn-theme btn-tender' style='width:100%;margin-right:10px;margin-top:10px;height:42px;$hideButtons' href='#' id='requestQuotationButton' data-dismiss=\"modal\">$requestQuotationButtonTitle</a>";
}
if($allowOrder && $hasItem) {
    if($orderWithAttachment){
        $result .= "<a class='btn btn-theme' style='border-radius: 0px 0px 4px 4px;margin:0px;width:100%;margin-top:10px;$hideButtons' href='#' id='placeOrderWithAttachmentButton' onclick='placeOrderWithAttachment();' data-dismiss=\"modal\">$placeOrderButtonTitle</a>
                    <a class='btn btn-theme' style='border-radius: 0px 0px 4px 4px;margin:0px;width:100%;display:none;margin-top:10px;$hideButtons' href='#' id='payOrderWithAttachmentButton' onclick='$payButtonWithAttachmentFunction'  data-dismiss=\"modal\">$placeOrderButtonTitle</a>";
    } else {
        $result .= "<a class='btn btn-theme' style='border-radius: 0px 0px 4px 4px;margin:0px;width:100%;margin-top:10px;$hideButtons' href='#' id='placeOrderButton' data-dismiss=\"modal\">$placeOrderButtonTitle</a>
                    <a class='btn btn-theme' style='border-radius: 0px 0px 4px 4px;margin:0px;width:100%;display:none;margin-top:10px;$hideButtons' href='#' onclick='$payButtonFunction' id='payOrderButton' data-dismiss=\"modal\">$placeOrderButtonTitle</a>";
    }


}
else if($splitOrderQuotation && $hasItem){
    $result .= "<div style='color: firebrick;padding-left: 30px;padding-right: 30px;font-size: 14px;'>$placeSplitOrderDisclaimer</div>
                <a class='btn btn-theme' style='border-radius: 0px 0px 4px 4px;margin:0px;width:100%;margin-top:10px;$hideButtons' href='#' onclick='placeSplitOrder();' id='placeSplitOrderButton' data-dismiss=\"modal\">$placeSplitOrderButtonTitle</a>
                <a class='btn btn-theme' style='border-radius: 0px 0px 4px 4px;margin:0px;width:100%;display:none;margin-top:10px;$hideButtons' href='#' onclick='placeSplitOrder();' id='paySplitOrderButton' data-dismiss=\"modal\">$placeSplitOrderButtonTitle</a>";
}

$result .= " </div>

                    
                        
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->
";

if(isset($_GET['validated']) && strcmp($_GET['validated'],'y')==0){
    $apiOrder = false;
}
if($customerID != 0) {
    if($apiOrder){
        $result .= "<button id=\"apiCartCalculationTrigger\" class=\"btn btn-theme \" style='margin-top:10px;width:100%;' onclick='apiCartCalculation(0);'>".$langu['api_cart_calculation_button_lable']."</button>";
    } else {
        if($refreshPrices){
            $result .= "<button id=\"checkoutModalTrigger\" class=\"btn btn-danger \" style='margin-top:10px;width:100%;padding:12px 20px;text-transform: uppercase !important;' onclick='refreshCartPrices();'><span style='font-weight: bold;'>Refresh Prices</button>";
        } else {
            $result .= "<button id=\"checkoutModalTrigger\" data-toggle=\"modal\" data-target=\"#checkoutModal\" class=\"btn btn-theme \" style='margin-top:10px;width:100%;' onclick='quotationModal(0);'>" . $langu['proceed_with_order_label'] . "</button>";
        }
        if ($allowQuotation && $hasItem) {
            $result .= "<button id=\"checkoutModalTrigger\" data-toggle=\"modal\" data-target=\"#checkoutModal\" class=\"btn btn-theme btn-tender \" style='margin-top:10px;width:100%;' onclick='quotationModal(1);'>$requestQuotationButtonTitle</button>";

        }
    }
} else {
    if ($allowQuotation && $anonymousQuotation && $hasItem) {
        $result .= "<button id=\"anonymousCheckoutTrigger\" data-toggle=\"modal\" data-target=\"#anonymousCheckoutModal\" class=\"btn btn-theme btn-tender \" style='margin-top:10px;width:100%;' onclick='anonymousQuotationModal(1);'>$requestQuotationButtonTitle</button>";
    }
    if($anonymousCheckout && $allowOrder){
        $result .= "<button id=\"anonymousCheckoutTrigger\" data-toggle=\"modal\" data-target=\"#anonymousCheckoutModal\" class=\"btn btn-theme \" style='margin-top:10px;width:100%;' onclick='anonymousQuotationModal(0);' >" . $langu['proceed_with_order_label'] . "</button>";
    } else if($allowOrder){
        $result .= "<button id=\"loginTrigger\" data-toggle=\"modal\" data-target=\"#loginModal\" class=\"btn btn-theme \" style='margin-top:10px;width:100%;' >" . $langu['proceed_with_order_label'] . "</button>";
    }

}
$result.="</div>
          </div><script>addButtonListeners();</script>";

// =========== /CHECKOUT ============== //

if($addWatermark) {
    $result .= "<!--watermarks-->
    <script type='text/javascript'>
        $watermarks
    </script>

    ";
}

echo $result;

function getCustomerLoyaltyAllowance($customerID,$userID,$orderID){
    $loyalties = array();

    if($customerID > 0 && $orderID > 0) {
        global $username, $password, $database;
        $db11 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db11->set_charset("utf8");
        $activeLoyalties = array();
        $stm11 = $db11->prepare(" SELECT loyalty_type_id,type FROM Loyalty_Types WHERE status='yes' AND DATE(valid_from)<=DATE(NOW()) AND DATE(valid_until)>=DATE(NOW()) ORDER BY valid_from DESC,valid_until ASC");
        $stm11->execute();
        $stm11->bind_result($activeLotyaltyID,$activeLoyaltyType);
        while ($stm11->fetch()) {$activeLoyalties["$activeLoyaltyType"] = $activeLotyaltyID;}
        $stm11->close();


        if($activeLoyalties["2"] > 0){
            $activeLoyaltyType = 2;
            //================================================= LOYALTY POINTS CASH DISCOUNT ===================================================//
            $stm11 = $db11->prepare(" SELECT name, acquiring_points_multiplier,spending_points_multiplier
                                             FROM Loyalty_Types 
                                            WHERE  status='yes' 
                                              AND Loyalty_Types.type = '2'
                                              AND DATE(valid_from)<=DATE(NOW()) 
                                              AND DATE(valid_until)>=DATE(NOW())
                                              AND loyalty_type_id ='" . $activeLoyalties["2"] . "'
                                              LIMIT 1
                                            ");
            $stm11->execute();
            $stm11->bind_result($name, $aquiringMultiplier, $spendingMultiplier);
            while ($stm11->fetch()) { }
            $stm11->close();

            $calculatedPointsFromCart = array();
            $calculatedPintsForDisplay = array();
            $stm11 = $db11->prepare(" SELECT type_id,balance FROM Loyalty_Balances WHERE customer_id='$customerID' AND user_id='$userID' AND type_id='" . $activeLoyalties["2"]."'");
            $stm11->execute();
            $stm11->bind_result($typeID,$balance);
            while ($stm11->fetch()) {

                $calculatedPointsFromCart["$typeID"] += $balance;


            }
            $stm11->close();

            //================================================= LOYALTY POINTS CASH DISCOUNT/===================================================//
        } else if($activeLoyalties["1"] > 0){
            $activeLoyaltyType = 1;
            $spendingMultiplier = 1;
            //================================================= LOYALTY POINTS LIMITED ITEMS ===================================================//
            $stm11 = $db11->prepare(" SELECT name,type_id,Loyalty_Item.qty,acquiring_points,spending_points,Online_Order_Item.qty,Online_Order_Item.order_item_id 
                                             FROM Loyalty_Item,Loyalty_Types,Online_Order_Item 
                                            WHERE Loyalty_Item.type_id=Loyalty_Types.loyalty_type_id 
                                              AND Online_Order_Item.item_id=Loyalty_Item.item_id 
                                              AND status='yes' 
                                              AND Loyalty_Types.type = '1'
                                              AND DATE(valid_from)<=DATE(NOW()) 
                                              AND DATE(valid_until)>=DATE(NOW())
                                              AND Online_Order_Item.order_id='$orderID'
                                              ORDER BY Loyalty_Item.qty ASC
                                            ");
            $stm11->execute();
            $stm11->bind_result($name, $typeID, $checkQty, $acqPoints, $spendPoints, $qty, $orderItemID);
            while ($stm11->fetch()) {
                if ($qty >= $checkQty) {
                    $loyalties["$orderItemID"]["$typeID"] = $acqPoints * $qty - $spendPoints * $qty;
                }
            }
            $stm11->close();

            $calculatedPointsFromCart = array();
            $spendingItems = array();
            foreach ($loyalties as $onlineOrderID => $loyaltyOfItem) {

                foreach ($loyaltyOfItem as $typeID => $points) {
                    if($points < 0){array_push($spendingItems,$onlineOrderID);}
                    $calculatedPointsFromCart["$typeID"] += $points;

                }
            }
            $stm11 = $db11->prepare(" SELECT type_id,balance FROM Loyalty_Balances WHERE customer_id='$customerID' AND user_id='$userID' ");
            $stm11->execute();
            $stm11->bind_result($typeID,$balance);
            while ($stm11->fetch()) {

                $calculatedPointsFromCart["$typeID"] += $balance;


            }
            $stm11->close();
            //================================================= LOYALTY POINTS LIMITED ITEMS/===================================================//
        }



    }

    $finalPoints = 0;
    foreach($calculatedPointsFromCart as $typeID => $points){
        $finalPoints +=$points;
    }

    $result = new stdClass();
    $result->items  = $spendingItems;
    $result->name   = $name;
    $result->points = $finalPoints;
    $result->multiplier = $spendingMultiplier;
    $result->type = $activeLoyaltyType;
    return $result;
//    return "SELECT name,type_id,Loyalty_Item.qty,acquiring_points,spending_points,Online_Order_Item.qty,Online_Order_Item.order_item_id FROM Loyalty_Item,Loyalty_Types,Online_Order_Item WHERE Loyalty_Item.type_id=Loyalty_Types.loyalty_type_id AND Online_Order_Item.item_id=Loyalty_Item.item_id AND status='yes' AND DATE(valid_from)<=DATE(NOW())  AND DATE(valid_until)>=DATE(NOW()) AND Online_Order_Item.order_id='$orderID' ORDER BY Loyalty_Item.qty DESC";
}

?>