<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
require_once("../assets/mobiledetect/Mobile_Detect.php");
$detect = new Mobile_Detect;
$isMobile = false;
if ( $detect->isMobile() ) {
    $isMobile = true;
}

$currencySign = getCurrencySign();
$orderID=$_SESSION['orderID'];
$customerID=$_SESSION['customerID'];

if(isset($_SESSION['lang'])){
    include('../langs/'.$_SESSION['lang'].'.php');
} else {
    include('../langs/en.php');
}

$cartObject  = new stdClass();
$cartObject->vat  = 0;
$cartObject->subTotal  = 0;
$cartObject->grandTotal  = 0;
$cartObject->items = array();

$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice = false;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$addItemByUnits = true;
$stm = $db->prepare("SELECT use_packing,theme,primary_language,show_prices,show_prices_with_vat,logo_link,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($usePacking,$themeColor,$primaryLanguage,$showPrices,$showPricesIncludingVAT,$logoLink,$orderQtyBySubunits);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }

    $themeColor = strtolower($themeColor);
}
$stm-> close();

if(strcmp($themeColor,'')!=0){
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
        $themeColor = "firebrick";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
        $themeColor = "goldenrod";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
        $themeColor = "black";
        $textColor = "white";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }

} else {
    $themeColor = "#6796d3";
}

$result="<div class='cart-items' >
         <div class='cart-items-inner' >
         <div style='max-height:400px;overflow-y:auto' id='cart-items-app'>";

$result .= "<div class='media' style='padding-top:3px;padding-bottom:8px;'>
                                        <h3 class='media-heading item-title pull-left' style='text-transform: none;margin-top: 5px;font-size: 18px;'><b>Your Cart</b></h3>
                                        <a href='#' class='media-heading item-title pull-right' data-dismiss='modal' ><i class='fa fa-times' style='text-transform: none;font-size: 20px;'></i></a>
                          </div>";


$stm = $db->prepare("SELECT Online_Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,Items.short_description,Online_Order_Item.qty_picked,Online_Order_Item.qty_delivered FROM Online_Order_Item,Items WHERE Online_Order_Item.item_id=Items.item_id AND Online_Order_Item.order_id='$orderID'");
$stm-> execute();
$stm-> bind_result($itemID,$qty,$unitPrice,$vatID,$itemCode,$name,$shortDescription,$multiplier,$uomID);

$i = 0;
$subTotal=0;
$grandTotal=0;
$vatTotal=0;
while ($stm->fetch()) {
   $i++;
    $imageUrl = getDefaultImage($itemID);

    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }

    if($customerID > 0) {
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
    }

    $itemUOM = '';
    foreach (getItemUOMs($orderID,$itemID) as $uom) {
        if($uom->multiplier == 1){
            $itemUOM = "&nbsp;($uom->name)&nbsp;";
        }
    }
    $unitPrice = getDefaultPriceInclPriceTypes($itemID,$customerID,false,$qty);
    if($showPricesWithVAT) {
        $vatPercentage = getVatPercentage($vatID);
        $priceInclVAT = $unitPrice + $unitPrice * ($vatPercentage / 100);
        $inc = $langu['incl_label'];
        $vat = $langu['vat_label'];
        $priceInclVATText = " &nbsp;<span  style='font-size: 11px;color: #0aa66e; text-transform: capitalize; '>($currencySign".number_format(floatval($priceInclVAT),2)." &nbsp;$inc $vat)</span>";
    }
    $price=number_format(floatval($unitPrice),2);


    if($addItemByUnits) {
        $qty = $qty / floatval(getSubUnits($itemID));
        $lineTotal = $unitPrice*$qty;
    } else {
        $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
    }

    $subTotal +=$lineTotal;
    $lineVat = $lineTotal * getVatPercentage($vatID)/100;
    $vatTotal+=$lineVat;

    if((int)$uomID > 0 && (int)$multiplier > 1){
        $uomName = getUomName($uomID);
        $uomQtyDisplay = $qty/$multiplier;
        $name .= " ($uomQtyDisplay $uomName)";
    }







    if($showPrices)
    {
        $pricing=$price.$priceInclVATText;
        $displayLineTotal = number_format(floatval($lineTotal),2);
        if($includeVatOnPrice){
            $pricing = number_format(floatval($priceInclVAT),2);
            $displayLineTotal = number_format(floatval($lineTotal+$lineVat),2);

        }
    }
    else
    {
        $pricing="";
        $displayLineTotal= "";
    }

    $packing=1;
    if(strcmp($usePacking,'yes')==0)
    {
        $packing = getPacking($itemID);
    }

    $cartItemObject = new stdClass();
    $cartItemObject->itemID   = $itemID;
    $cartItemObject->itemName = str_replace("\"","",$name);
    $cartItemObject->itemName = str_replace("\n","",$name);
    $cartItemObject->imageUrl = $imageUrl;
    $cartItemObject->qty      = $qty;
    $cartItemObject->packing  = $packing;
    $cartItemObject->price    = $pricing;
    $cartItemObject->total    = $displayLineTotal;
    $cartItemObject->color    = $themeColor;
    array_push($cartObject->items,$cartItemObject);

    $itemCodeUrl = urlencode(str_replace('/','--CP2F--',$itemCode));

    if($addWatermark) {


        if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
        if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
        if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.3';}
        if(strcmp($imageUrl,'./assets/img/noimage.jpg')!=0) {
            $watermarks .= "
            watermark(['$imageUrl','$watermarkURL'])
            .image(watermark.image.$watermarkPosition($watermarkOpacity))
            .then(function (img) {
                img.id = 'watermark-img-cart-$itemID';
                img.style.cssText = document.getElementById('media-link-img-cart-$itemID').style.cssText;
                img.className = document.getElementById('media-link-img-cart-$itemID').className;
                document.getElementById('media-link-img-cart-$itemID').remove();
                document.getElementById('media-link-cart-$itemID').appendChild(img);
                document.getElementById('media-link-cart-$itemID').href = './products/$itemCodeUrl';
                delete document.getElementById('media-link-cart-$itemID').dataset.featherlight;
    
            });
    
            ";
        }

        $imageUrl = './assets/img/noimage.jpg';
    }


    $result = $result."  <div class='media' style='padding-top:3px;padding-bottom:3px;'>
                                    <a class='pull-left' href='./products/$itemCodeUrl' id='media-link-cart-$itemID'><img class='media-object item-image' id='media-link-img-cart-$itemID' style='min-width:40px;margin-top:8px;display:inline-block' src='$imageUrl' alt=''></a>
                                    <p class='pull-right item-price'>
                                    $currencySign$displayLineTotal
                                    <br>
                                    <i class='fa fa-trash pull-right' 
                                        style='font-size:22px;position:relative;z-index:99999;margin-top: 30px;color:$themeColor;cursor: pointer;' 
                                        onMouseOver=\"this.style.color='firebrick'\" 
                                        onMouseOut=\"this.style.color='$themeColor'\" 
                                        title='Remove' 
                                        onclick='productQuantityChanged($itemID, 0);openCart();'
                                    ></i>

                                    </p>

                                    <div class='media-body'>
                                        <label class='media-heading item-title' style='font-size:14px;text-transform: none'><b>$name</b></label>
                                        <label class='label' style='color:#4682B4;display:block;font-size:13px;text-align:left;padding-left:1px;'>$currencySign$pricing</label>

                                        <label class='media-heading item-title' style='font-size:14px;display:block;text-transform: none'>Qty: &nbsp;
                                        <a class='minusButton' href='#' data-value='$packing' onclick='setTimeout(function(){openCart();}, 100);'>
                                            <i class='fa fa-minus'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" style='border-radius: 50%;font-size: 10px;padding-top: 3px;padding-bottom: 2px;padding-right:4px;padding-left:4px;border: 1px solid $themeColor;color:$themeColor;margin-top: -3px;'></i>
                                        </a>
                                        <input type='hidden' value='$qty' data-value='$itemID' />
                                        <b>&nbsp;&nbsp;$qty&nbsp;&nbsp;</b>
                                        <a class='plusButton' href='#' data-value='$packing' onclick='setTimeout(function(){openCart();}, 100);'>
                                            <i class='fa fa-plus'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='';this.style.color='$themeColor'\" style='border-radius: 50%;font-size: 10px;padding-top: 3px;padding-bottom: 2px;padding-right:4px;padding-left:4px;border: 1px solid $themeColor;color:$themeColor;margin-top: -3px;'></i>
                                        </a>
                                        <b>$itemUOM</b>
                                        </label>
                                    </div>
                                     
                                    
                          </div>";



}
$stm-> close();
$result=$result."<div class='media' style='padding-top:3px;padding-bottom:3px;'></div></div>";

$subtotalLabel = $langu['subtotal_label'];
$VATLabel = $langu['vat_label'];
$grandTotalLabel = $langu['grand_total_label'];
$checkout = $langu['checkout_label'];
$close = $langu['close_label'];

$grandTotal = $subTotal+$vatTotal;
$displaySubTotal = number_format(floatval($subTotal),2);
$displayVatTotal = number_format(floatval($vatTotal),2);
$displayGrandTotal = number_format(floatval($grandTotal),2);

$cartObject->vat = $displayVatTotal;
$cartObject->subTotal = $displaySubTotal;
$cartObject->grandTotal = $displayGrandTotal;
$cartObject->showPrices = $showPrices;
$cartObject->includeVatOnPrice = $includeVatOnPrice;

if($showPrices) {
    if($includeVatOnPrice){
        $hideTotals = "style='display:none;'";
    }
    $result = $result . "  <div class='media' style='margin-top:0' id='cart-sub-app'>
                                    <p class='pull-right item-price' $hideTotals>$currencySign$displaySubTotal</p>
                                    <div class='media-body pull-right' $hideTotals>
                                        <h4 class='media-heading item-title summary ' style='margin-right:30px;text-transform: none'>$subtotalLabel</h4>
                                    </div>
                                </div>
                        <div class='media' $hideTotals id='cart-vat-app'>
                                    <p class='pull-right item-price'>$currencySign$displayVatTotal</p>
                                    <div class='media-body pull-right'>
                                        <h4 class='media-heading item-title summary ' style='margin-right:30px;text-transform: none'>$VATLabel</h4>
                                    </div>
                                </div>

                             <div class='media' id='cart-grand-app'>
                                    <p class='pull-right item-price'>$currencySign$displayGrandTotal</p>
                                    <div class='media-body pull-right'>
                                        <h4 class='media-heading item-title summary ' style='margin-right:30px;text-transform: none'>$grandTotalLabel</h4>
                                    </div>
                                </div>";


}

if($isMobile) {
    $result = $result . " <div class='media'>
                                            <a href='#' class='btn btn-theme btn-theme-transparent btn-block' data-dismiss='modal' style='text-transform: capitalize;display: inline-block;width: 48%'>$close</a>
                                            <a href='checkout.php' class='btn btn-theme btn-call-checkout btn-block pull-right' style='text-transform: capitalize;display: inline-block;width: 48%;margin-top: 0px;margin-left:0px;'>$checkout</a>
                                </div>
                            </div>
                        </div>

                        <script>
                        addButtonListeners();
                        $('#cartItems').css('margin-right','0px');
                        $('#cartItems').css('margin-top','25px');
                        $('#cartItems').css('width','100%');
                        $('#cartItems').parent().css('width','100%').css('margin-right','0px').addClass('pull-right');

                        </script>
                                ";
} else {
    $result = $result . " <div class='media'>
                                            <a href='#' class='btn btn-theme btn-theme-transparent btn-block' data-dismiss='modal' style='text-transform: capitalize;display: inline-block;width: 48%'>$close</a>
                                            <a href='checkout.php' class='btn btn-theme btn-call-checkout btn-block pull-right' style='text-transform: capitalize;display: inline-block;width: 48%;margin-top: 0px;margin-left:0px;'>$checkout</a>
                                </div>
                            </div>
                        </div>

                        <script>
                        addButtonListeners();
                        $('#cartItems').css('margin-right','100px');
                        $('#cartItems').css('margin-top','25px');
                        $('#cartItems').css('width','500px');
                        $('#cartItems').parent().css('width','500px').css('margin-right','100px').addClass('pull-right');

                        </script>
                                ";
}
if($addWatermark) {
    $result .= "<!--watermarks-->
    <script type='text/javascript'>
        $watermarks
    </script>

    ";
}
echo $result;
echo "<div style='display: none' id='cartJson'>".str_replace('<\/span>','',json_encode($cartObject))."</div>";
?>