<?php

include_once("../../param.php");
require("dbhelper.php");

global  $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$loggedInUserID = intval($_SESSION['userID']);
$loggedInCustomerID = intval($_SESSION['customerID']);

if(isset($loggedInUserID) && $loggedInUserID > 0 && isset($loggedInCustomerID) && $loggedInCustomerID > 0){
    $loggedin = true;
} else {
    $loggedin = false;
}

if (!$loggedin) {
    http_response_code(401);
    exit;
}


$customerID = $_SESSION['customerID'];
$stm = $db->prepare("SELECT type_id, type_code, type_name, color FROM SC_Types");
$stm->execute();
$stm->bind_result($typeID, $typeCode, $typeName, $color);

$serviceCallDetails = new stdClass();
$serviceCallDetails->types = array();

while ($stm->fetch()) {
    $type = new stdClass();
    $type->id = $typeID;
    $type->code = $typeCode;
    $type->name = $typeName;
    $type->color = $color;

    $serviceCallDetails->types[] = $type;
}
$stm->close();

//get serial numbers
$stm = $db->prepare("SELECT s.serial_number_id , s.serial_number, i.item_code, i.name
                            FROM Contracts AS c INNER JOIN Items AS i ON c.item_id = i.item_id
                            INNER JOIN Serial_Numbers as s ON s.serial_number_id = c.serial_number_id
                            WHERE valid = 'yes' AND customer_id =?");
$stm->bind_param("i", $customerID);
$stm->execute();
$stm->bind_result($serialNumberID,$serialNumber,$itemCode,$itemName);
$serviceCallDetails->serialNumbers = array();
while ($stm->fetch()) {
    $serialNum = new stdClass();
    $serialNum->id = $serialNumberID;
    $serialNum->number = $serialNumber;
    $serialNum->itemCode = $itemCode;
    $serialNum->itemName = $itemName;

    $serviceCallDetails->serialNumbers[] = $serialNum;


}
$stm->close();


echo json_encode($serviceCallDetails);




?>