<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");
include_once('emailOrder.php');

$showPrices=true;
$dropShip=false;
$addItemByUnits = true;

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices,drop_ship,max_stock_limit,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$isDropShip,$maxStockLimit,$orderQtyBySubunits);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }
    if(strcmp($isDropShip,"yes")==0){
        $dropShip=true;
    }
    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }
}
$stm-> close();

if(strcmp($_SESSION['lang'],"")!=0){
    include('../langs/'.$_SESSION['lang'].'.php');
} else if(strcmp($primaryLanguage,"")!=0){
    include('../langs/'.$_SESSION['lang'].'.php');
} else {
    include('../langs/en.php');
}

$onlineOrderID=$_SESSION['orderID'];
$customerID =$_SESSION['customerID'];
$companyID =$_SESSION['companyID'];
$salespersonID =$_SESSION['userID'];
$userID=$_SESSION['userID'];
$orderCode = getNextCode('Orders','order_code',"O","CLOUD",$db);
$tenderCode = getNextCode('Tenders','tender_code',"T","CLOUD",$db);

$dataPOST = trim(file_get_contents('php://input'));

$myfile = fopen("tata.txt", "w") or die("Unable to open file!");

fwrite($myfile, $dataPOST);
fwrite($myfile, "\n".$orderCode);
fclose($myfile);
$orderDate = date('Y/m/d', time());

$deliveryTotal=$_POST['deliveryTotal'];
$subtotal = $_POST['subtotal'];
$vatAmount=$_POST['vatAmount'];
$grandTotal=$_POST['grandTotal'];
$discountAmount=$_POST['discountTotal'];
$orderAddressID = $_POST['billAddress'];
$deliveryAddressID=$_POST['address'];
$deliveryDate=$_POST['deliveryDate'];
$deliveryFeeItem=trim(''.$_POST['deliveryFeeItem']);
$deliveryMethod=trim(''.$_POST['deliveryMethod']);
$onlineOrderItems = $_POST['onlineOrderItems'];

if(strcmp($orderAddressID,'')==0 || $orderAddressID == 0){
    $orderAddressID = $deliveryAddressID;
}

$anonymousCheckout = $_POST['anonymousCheckout'];
if($anonymousCheckout){
    if(isset($_POST['anonymousCheckoutCustomer']) && $_POST['anonymousCheckoutCustomer'] > 0){
        $customerID = $_POST['anonymousCheckoutCustomer'];
        $salespersonID = 0;
    }
}

if(strcmp($deliveryMethod,'')==0){
    $deliveryMethod="Not Set";
}


$isCredit = true;
if(isset($_POST['isCredit']) && strcmp($_POST['isCredit'],'no')==0){
    $isCredit = false;
}

if(isset($deliveryTotal)&& $deliveryTotal>0) {
    $subtotal+=$deliveryTotal;
}



if(isset($_POST['details'])) {
    $details = $_POST['details'];
}
else{
    $details="";
}
if($isCredit) {
    $status = "Placed";
} else {
    $status = "Payment Pending";
}
$printCount=0;
$paymentTypeID=1;
//$orderID= getNextKey("Orders","order_id");
$tenderID=$currencyID=$globalDiscountPercentage=$depositAmount=0;
$vatIE="E";
if(!isset($_POST['deliveryDate'])) {
    $deliveryDate = date('Y/m/d', time());
}

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT salesperson_for_order FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($defaultSalesPerson);
while ($stm->fetch()) {
    if(strcmp($defaultSalesPerson,'')!=0 && $defaultSalesPerson > 0){
        $salespersonID = $defaultSalesPerson;
    }

}
$stm->close();
if(strcmp($companyID,'')==0){$companyID=0;}

$splitOrderItems = array();
$splitTenderItems = array();

foreach ($onlineOrderItems as $onlineOrderItem) {

    $itemID = $onlineOrderItem['itemID'];
    $qty = $onlineOrderItem['Quantity'];
    $unitPrice = $onlineOrderItem['UP'];
    $vatID = $onlineOrderItem['vatID'];



    $stock = getStock($itemID);
    if($qty>$maxStockLimit || $qty>$stock){
        array_push($splitTenderItems,$onlineOrderItem);
    } else {
        array_push($splitOrderItems,$onlineOrderItem);
    }
}



$checkOrderItems = count($splitOrderItems);
$checkTenderItems = count($splitTenderItems);

if($checkOrderItems > 0) {


    $orderID=0;
    $stmt = $db->prepare("INSERT INTO Orders (order_id,order_code,company_id,online_order_id,customer_id,salesperson_id,paymenttype_id,order_date,subtotal,grand_total,vat_amount,discount_amount,print_count,order_address_id,delivery_address_id,tender_id,vat_i_or_e,delivery_date,deposit_amount,details,status,currency_id,global_discount_percentage,delivery_method,timestamp) VALUES(?,?,1,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('isiiiisddddiiiissdssids', $orderID,$orderCode, $onlineOrderID, $customerID, $salespersonID, $paymentTypeID, $orderDate, $subtotal, $grandTotal, $vatAmount, $discountAmount, $printCount, $orderAddressID, $deliveryAddressID, $tenderID, $vatIE, $deliveryDate, $depositAmount, $details, $status, $currencyID, $globalDiscountPercentage, $deliveryMethod);
    $stmt->execute();
    echo $stmt->error;
    $stmt->close();


    $stm = $db->prepare("SELECT order_id FROM Orders WHERE online_order_id='$onlineOrderID'");
    $stm->execute();
    $stm->bind_result($orderID);
    while ($stm->fetch()) {

    }
    $stm->close();

    // -------------- Order_Delivery_Details 10112023 --------------

    if(isset($_POST['timeSlotsFrom'])){$timeSlotsFrom = $deliveryDate . ' ' . $_POST['timeSlotsFrom'];}
    else {$timeSlotsFrom = "";}

    if(isset($_POST['timeSlotsTo'])){$timeSlotsTo = $deliveryDate . ' ' . $_POST['timeSlotsTo'];}
    else {$timeSlotsTo = "";}

    $serviceCallID = 0;
    $assignTo = 0;
    $deliveryStatus = "";
    $deliveryNotes = "";
    $paymentMethodID = intval($_POST['paymentMethodID']);
    $deliveryFeeItemID = intval($deliveryFeeItem);
    $weightFeeItemID = intval($weightFeeItem);
    $orderTime = date('Y-m-d H:i:s');
    $deliveryTime = "";
    $prepareDurationMinutes = 0;
    $b2bUserID = $_SESSION['userID'];

    $stm = $db->prepare("SELECT name FROM B2C_Payment_Methods WHERE payment_method_id='$paymentMethodID' LIMIT 1");
    $stm->execute();
    $stm->bind_result($paymentMethodDescription);
    while ($stm->fetch()) {}
    $stm->close();

    $paymentMethodDescription = "$paymentMethodDescription";

    $detailsPayment = explode("\nPayment Method:","$details");
    $deliveryNotes = $detailsPayment[0];
    $paymentMethodAndTimeslot = $detailsPayment[1];
    $paymentMethodAndTimeslot = explode("\nTime Slot:","$paymentMethodAndTimeslot");
    $paymentMethod = $paymentMethodAndTimeslot[0];
    $timeSlot = $paymentMethodAndTimeslot[1];
    $paymentMethodAndAnonymousCustomer = explode("\nCustomer: ","$paymentMethod");
    $addressLine1ANDCustomer = $paymentMethodAndAnonymousCustomer[1];
    $addressLine1ANDCustomer = explode("\nAddress: ","$addressLine1ANDCustomer");
    $anonymousCustomerName = $addressLine1ANDCustomer[0];
    $addressANDContact = $addressLine1ANDCustomer[1];
    $addressANDContact = explode("\nPhone: ","$addressANDContact");
    $anonymousAddress = $addressANDContact[0];
    $anonymousContact = $addressANDContact[1];

    if(strcmp($anonymousCustomerName,"")!=0) {
        $deliveryNotes .= "\nCustomer: $anonymousCustomerName\nAddress: $anonymousAddress\nPhone: $anonymousContact";
    }

    $deliveryNotes = str_replace("\n","#newline#",$deliveryNotes);


    $stmt = $db->prepare("INSERT INTO Order_Delivery_Details(order_id, service_call_id, assign_to, delivery_fee_item_id, weight_fee_item_id, time_slot_from, time_slot_to, order_time, delivery_time, prepare_duration_minutes, delivery_status, delivery_notes,payment_method_id,payment_method_description,user_id, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('iiiiisssssssisi', $orderID, $serviceCallID, $assignTo, $deliveryFeeItemID, $weightFeeItemID, $timeSlotsFrom, $timeSlotsTo, $orderTime, $deliveryTime, $prepareDurationMinutes, $deliveryStatus, $deliveryNotes,$paymentMethodID,$paymentMethodDescription,$b2bUserID);
    $stmt->execute();
    if (strcmp($stmt->error, "") != 0) {throw new Exception($stmt->error);}
    $stmt->close();

    // -------------- Order_Delivery_Details 10112023 --------------

    if($dropShip){

        $volume=trim("".$_POST['totalVolumetrics']);
        $weight=trim("".$_POST['totalWeight']);
        $distance=trim("".$_POST['distanceKm']);
        $from_lat=trim("".$_POST['latFrom']);
        $from_lng=trim("".$_POST['lngFrom']);
        $to_lat=trim("".$_POST['latTo']);
        $to_lng=trim("".$_POST['lngTo']);
        $to_address_line_1=trim("".$_POST['addressTo']);
        $to_address_line_2=trim("".$_POST['addressTo']);
        $to_address_area=trim("".$_POST['addressAreaTo']);
        $received_amount=trim("".$_POST['freightCollectAmount']);
        $label_1=trim($_POST['clientNameTo']);
        $text_1="";
        $text_2="";
        $text_3="";

        $stmt = $db->prepare("INSERT INTO B2B_Dropship_Orders_Extra(order_id, order_code, volume, weight, distance, from_lat, from_lng, to_lat, to_lng, to_address_line_1, to_address_line_2, to_address_area, received_amount, label_1, text_1, text_2, text_3, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isdddddddsssdssss', $orderID,$orderCode, $volume, $weight, $distance, $from_lat, $from_lng, $to_lat, $to_lng, $to_address_line_1, $to_address_line_2, $to_address_area, $received_amount, $label_1, $text_1, $text_2, $text_3);
        $stmt->execute();
        $stmt->close();
    }

    $lineTotals = 0;
    $vatTotals = 0;
    $lineDiscountTotals = 0;
    $itemCounter = 0;
    $totalDiscount = 0;
    $loyaltyPoints = array();
    foreach ($splitOrderItems as $onlineOrderItem) {

        $itemID = $onlineOrderItem['itemID'];
        $qty = $onlineOrderItem['Quantity'];
        $unitPrice = $onlineOrderItem['UP'];
        $vatID = $onlineOrderItem['vatID'];


        $attr = getItemAttributes($onlineOrderID,$itemID,$qty);

        //$orderItemID= getNextKey("Order_Item","order_item_id");
        if($addItemByUnits) {
            $qty = $qty * floatval(getSubUnits($itemID));
        }

        $lineTotal = $unitPrice * $qty;
        $vatAmount = $lineTotal * getVatPercentage($vatID) / 100;
        $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
        $description = "";
        $masterItem = $attr->masterItem;
        $lineDiscount = $attr->lineDiscount;
        $totalDiscount += (float)$lineDiscount;
        $lineDiscountPercentage = $attr->lineDiscountPercentage;
        $pricetypeID = getPriceType($itemID,$customerID,$unitPrice);
        if($pricetypeID > 0){}else{$pricetypeID=0;}

        if($dropShip){
            $onlineOrderItemID = $onlineOrderItem['onlineOrderItemID'];
            $itemCounter++;
            $itemVolumetrics = getVolumetrics($onlineOrderItemID);
            $masterItem='Pack';
            $description= "$orderCode-$itemCounter|$itemVolumetrics";
        }

        $lineTotals += $lineTotal;
        $lineDiscountTotals +=$lineDiscount;
        $vatTotals += $vatAmount;

        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
        $orderItemID = 0;
        $stmt1 = $db1->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,master_item,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt1->bind_param('iiiddddddddiiss', $orderItemID,$orderID, $itemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description,$masterItem);
        $stmt1->execute();
        $orderItemID = $stmt1->insert_id;
        $stmt1->close();

        $loyalties = calculateLoyaltyPoints($itemID,$customerID,$qty);
        foreach ($loyalties as $loyalty) {
            $loyaltyPoints["$loyalty->type"]["$loyalty->sign"]['points'] += $loyalty->points;
            $loyaltyPoints["$loyalty->type"]["$loyalty->sign"]['name'] = $loyalty->name;
        }

    }


    insertLoyaltyPoints($customerID,$loyaltyPoints, $orderID, $orderCode, $grandTotal, $userID, $companyID);


    if (isset($deliveryFeeItem) && $deliveryFeeItem > 0) {
        $itemID = $deliveryFeeItem;
        $vatID = getItemVatID($itemID);
        //$orderItemID= getNextKey("Order_Item","order_item_id");
        $qty = 1;
        $unitPrice = getDefaultPrice($itemID, $customerID);
        $vatAmount = getDeliveryVatAmount($deliveryTotal);
        $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
        $description = "";
        $pricetypeID = getPriceType($itemID,$customerID,$unitPrice);
        if($pricetypeID > 0){}else{$pricetypeID=0;}

        if ($unitPrice > 0) {

            $lineTotals += $lineTotal;
            $lineDiscountTotals +=$lineDiscount;
            $vatTotals += $vatAmount;

            $db1 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db1->set_charset("utf8");
            $orderItemID = 0;
            $stmt1 = $db1->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt1->bind_param('iiiddddddddiis',$orderItemID, $orderID, $itemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description);
            $stmt1->execute();
            $stmt1->close();
        }

    }

    if (isset($deliveryTotal) && $deliveryTotal > 0) {
        $itemID = getDeliveryItemID();
        $vatID = getItemVatID($itemID);
        //$orderItemID= getNextKey("Order_Item","order_item_id");
        $qty = 1;
        $unitPrice = $lineTotal = $deliveryTotal;
        $vatAmount = getDeliveryVatAmount($deliveryTotal);
        $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
        $description = "";
        $pricetypeID = getPriceType($itemID,$customerID,$unitPrice);
        if($pricetypeID > 0){}else{$pricetypeID=0;}

        $lineTotals += $lineTotal;
        $lineDiscountTotals +=$lineDiscount;
        $vatTotals += $vatAmount;

        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
        $orderItemID = 0;
        $stmt1 = $db1->prepare("INSERT INTO Order_Item (order_item_id,order_id,item_id,qty,qty_delivered,qty_invoiced,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt1->bind_param('iiiddddddddiis',$orderItemID, $orderID, $itemID, $qty, $qtyDelivered, $qtyInvoiced, $unitPrice, $lineDiscount, $globalDiscount, $lineDiscountPercentage, $vatAmount, $pricetypeID, $vatID, $description);
        $stmt1->execute();
        $stmt1->close();


    }

    $grandTotals = $lineTotals + $vatTotals - $lineDiscountTotals;
    $stmt = $db->prepare("UPDATE Orders SET subtotal =?,discount_amount=?,vat_amount=?,grand_total=? WHERE order_id=?");
    $stmt->bind_param('ddddi',$lineTotals,$lineDiscountTotals,$vatTotals,$grandTotals,$orderID);
    $stmt->execute();
    $stmt->close();


    $usedPromos = array();
    $stmt = $db->prepare("SELECT DISTINCT(Online_Order_Item.promotion_id) FROM Online_Order_Item,Promotions WHERE Online_Order_Item.promotion_id=Promotions.promotion_id AND Online_Order_Item.order_id='$onlineOrderID' AND Promotions.type > 2 AND Promotions.type < 6");
    $stmt-> execute();
    $stmt-> bind_result($usedPromoID);
    while ($stmt->fetch()) {array_push($usedPromos,$usedPromoID);}
    $stmt->close();

    foreach ($usedPromos as $usedPromoID){
        $stmt = $db->prepare("UPDATE Promotions SET status='no',description='Used' WHERE promotion_id='$usedPromoID'");
        $stmt->execute();
        $stmt->close();
    }

    $stmt = $db->prepare("DELETE FROM Online_Orders WHERE order_id='$onlineOrderID'");
    $stmt->execute();
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE order_id='$onlineOrderID'");
    $stmt->execute();
    $stmt->close();


    $_SESSION['orderID'] = getAvailableOrderID($customerID, $userID);


    if ($isCredit) {

        if($dropShip) {
            echo "

                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>" . $langu['place_order_message'] . "</h2>
                        </div>
                    </div>
                     <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dropShipPrintLabels.php' target='_blank'>
                           <input type='hidden' name='orderID' id='orderIDEmail' value='$orderID'/>
                           <input type='hidden' name='orderCode' value='$orderCode'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='Print Labels'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";
        }else{
            if ($showPrices) {
                echo "

                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>" . $langu['place_order_message'] . "</h2>
                        </div>
                    </div>
                     <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dbaccess/printOrderPDF.php' target='_blank'>
                           <input type='hidden' name='orderID' id='orderIDEmail' value='$orderID'/>
                           <input type='hidden' name='orderCode' value='$orderCode'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='" . $langu['print_order'] . "'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";

                $result = getOrderPDF($orderID);
                echo "$result";

            } else {
                echo "

<div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>" . $langu['place_order_message'] . " </h2>
                        </div>
                        </div>
                        <div>
                       
                        </div>
                        ";
            }
            if ($showPrices) {
                echo "<script>
                      $.ajax({
                        type:'POST',
                        url: './dbaccess/emailOrder.php',
                        data:{'orderID':'$orderID'},
                        success:function(result){}
                      });
                  </script>";

//            sendEmail($orderID);
            }
        }
    } else {
        echo $orderCode;
    }

}

if($checkTenderItems > 0) {
    $orderCode = $tenderCode;


    $tenderID = 0;
    $stmt = $db->prepare("INSERT INTO Tenders (tender_id,tender_code,company_id,customer_id,salesperson_id,tender_date,subtotal,grand_total,vat_amount,discount_amount,details,status,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
    $stmt->bind_param('isiiisddddss',$tenderID,$orderCode,$companyID,$customerID,$salespersonID,$orderDate,$subtotal,$grandTotal,$vatAmount,$discountAmount,$details,$status);
    $stmt->execute();
    $orderID=$stmt->insert_id;
    $stmt->close();



    $lineTotals = 0;
    $vatTotals = 0;
    $lineDiscountTotals = 0;
    $itemCounter = 0;
    $totalDiscount = 0;
    $loyaltyPoints = array();
    foreach ($splitTenderItems as $onlineOrderItem) {

        $itemID = $onlineOrderItem['itemID'];
        $qty = $onlineOrderItem['Quantity'];
        $unitPrice = $onlineOrderItem['UP'];
        $vatID = $onlineOrderItem['vatID'];


        $attr = getItemAttributes($onlineOrderID,$itemID,$qty);

        //$orderItemID= getNextKey("Order_Item","order_item_id");

        if($addItemByUnits) {
            $qty = $qty * floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }

        $vatAmount = $lineTotal * getVatPercentage($vatID) / 100;
        $qtyDelivered = $qtyInvoiced = $lineDiscount = $globalDiscount = $lineDiscountPercentage = 0;
        $description = "";
        $masterItem = $attr->masterItem;
        $lineDiscount = $attr->lineDiscount;
        $totalDiscount += (float)$lineDiscount;
        $lineDiscountPercentage = $attr->lineDiscountPercentage;
        $pricetypeID = getPriceType($itemID,$customerID,$unitPrice);
        if($pricetypeID > 0){}else{$pricetypeID=0;}

        $lineDiscount = (float)$lineDiscount;
        $lineDiscountPercentage = (float)$lineDiscountPercentage;

        if($dropShip){
            $onlineOrderItemID = $onlineOrderItem['onlineOrderItemID'];
            $itemCounter++;
            $itemVolumetrics = getVolumetrics($onlineOrderItemID);
            $masterItem='Pack';
            $description= "$orderCode-$itemCounter|$itemVolumetrics";
        }

        $lineTotals += $lineTotal;
        $lineDiscountTotals +=$lineDiscount;
        $vatTotals += $vatAmount;

        $db1 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
        $tender_item_id = 0;
        $stmt1 = $db1->prepare("INSERT INTO Tender_Item (tender_item_id,tender_id,item_id,qty,unit_price,line_discount,global_discount,line_discount_percentage,vat_amount,pricetype_id,vat_id,description,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt1->bind_param('iiiddddddiis',$tender_item_id,$orderID,$itemID,$qty,$unitPrice,$lineDiscount,$globalDiscount,$lineDiscountPercentage,$vatAmount,$pricetypeID,$vatID,$description);
        $stmt1->execute();
        $orderItemID=$stmt1->insert_id;
        $stmt1->close();

        $loyalties = calculateLoyaltyPoints($itemID,$customerID,$qty);
        foreach ($loyalties as $loyalty) {
            $loyaltyPoints["$loyalty->type"]["$loyalty->sign"]['points'] += $loyalty->points;
            $loyaltyPoints["$loyalty->type"]["$loyalty->sign"]['name'] = $loyalty->name;
        }

    }


    insertLoyaltyPoints($customerID,$loyaltyPoints, $orderID, $orderCode, $grandTotal, $userID, $companyID);

    $grandTotals = $lineTotals + $vatTotals - $lineDiscountTotals;
    $stmt = $db->prepare("UPDATE Tenders SET subtotal =?,discount_amount=?,vat_amount=?,grand_total=? WHERE tender_id=?");
    $stmt->bind_param('ddddi',$lineTotals,$lineDiscountTotals,$vatTotals,$grandTotals,$orderID);
    $stmt->execute();
    $stmt->close();

    $usedPromos = array();
    $stmt = $db->prepare("SELECT DISTINCT(Online_Order_Item.promotion_id) FROM Online_Order_Item,Promotions WHERE Online_Order_Item.promotion_id=Promotions.promotion_id AND Online_Order_Item.order_id='$onlineOrderID' AND Promotions.type > 2 AND Promotions.type < 6");
    $stmt-> execute();
    $stmt-> bind_result($usedPromoID);
    while ($stmt->fetch()) {array_push($usedPromos,$usedPromoID);}
    $stmt->close();

    foreach ($usedPromos as $usedPromoID){
        $stmt = $db->prepare("UPDATE Promotions SET status='no',description='Used' WHERE promotion_id='$usedPromoID'");
        $stmt->execute();
        $stmt->close();
    }

    $stmt = $db->prepare("DELETE FROM Online_Orders WHERE order_id='$onlineOrderID'");
    $stmt->execute();
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Online_Order_Item WHERE order_id='$onlineOrderID'");
    $stmt->execute();
    $stmt->close();


    $_SESSION['orderID'] = getAvailableOrderID($customerID, $userID);


    if($showPrices) {
        echo "
            <script>
            $('#home').removeClass('modal-open');
            </script>
                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>".$langu['place_quotation_message']." </h2>
                        </div>
                    </div>
                    <br>
                    <div>
                        <form style='margin:0 auto;width:50%;margin-bottom:20px;' method='POST' action='./dbaccess/printTenderPDF.php' target='_blank'>
                           <input type='hidden' name='tenderID' id='orderIDEmail' value='$orderID'/>
                           <input type='hidden' name='tenderCode' value='$orderCode'/>
                           <div style='margin: 0 auto;width:80%'><center>
                           <input type='submit' class='btn btn-theme btn-theme-dark' style='display:inline-block;margin-top:15px;text-transform: capitalize;'id='printOrderButton' value='" . $langu['print_order'] . "'/>
                           <a href='./' class='btn btn-theme' style='display:inline-block;margin-top:15px;text-transform: capitalize;'>" . $langu['back_to_catalogue_label'] . "</a>
                           </div>
                        </form>
                      </div>
                        ";
        echo getTenderPDF($orderID);
    } else {
        echo "
            <script>
            $('#home').removeClass('modal-open');
            </script>
                    <div class='message-box col-sm-8 col-sm-offset-2'>
                        <div class='message-box-inner'>
                            <h2 style='text-transform: capitalize; font-size:14px;font-family: Open Sans, Arial, Helvetica, Sans-Serif'>".$langu['place_quotation_message']."<br><br> $orderCode </h2>
                        </div>
                    </div>   
                    <div>
                    </div>
                        ";
    }

}

function calculateLoyaltyPoints($itemID,$customerID,$qty){
    $loyalties = array();
    $itemID = intval($itemID);
    $customerID = intval($customerID);
    $qty = floatval($qty);

    if($itemID > 0 && $customerID > 0 && $qty > 0) {
        global $username, $password, $database;
        $db11 = new mysqli('localhost', $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db11->set_charset("utf8");

        $hasAcqPoints = false;
        $hasSpendPoints = false;
        $stm11 = $db11->prepare(" SELECT name,type_id,qty,acquiring_points,spending_points 
                                         FROM Loyalty_Item,Loyalty_Types 
                                        WHERE Loyalty_Item.type_id=Loyalty_Types.loyalty_type_id 
                                          AND item_id='$itemID' 
                                          AND status='yes' 
                                          AND DATE(valid_from)<=DATE(NOW()) 
                                          AND DATE(valid_until)>=DATE(NOW())
                                          ORDER BY qty DESC
                                        ");
        $stm11->execute();
        $stm11->bind_result($name,$typeID, $checkQty, $acqPoints,$spendPoints);
        while ($stm11->fetch()) {
            if($qty >= $checkQty && !$hasAcqPoints){



                $hasAcqPoints = true;
                $loyalty = new stdClass();
                $loyalty->points = $acqPoints*$qty;
                $loyalty->type = $typeID;
                $loyalty->name = "$name";
                $loyalty->sign = "1";
                array_push($loyalties,$loyalty);

            }
            if($qty >= $checkQty &&  !$hasSpendPoints){

                $hasSpendPoints = true;
                $loyalty = new stdClass();
                $loyalty->points = $spendPoints*$qty;
                $loyalty->type = $typeID;
                $loyalty->name = "$name";
                $loyalty->sign = "-1";
                array_push($loyalties,$loyalty);

            }
            if($hasAcqPoints && $hasSpendPoints){break;}
        }
        $stm11->close();
    }


    return $loyalties;
}

function insertLoyaltyPoints($customerID,$loyalty,$orderID,$orderCode,$orderTotal,$userID,$companyID){

    foreach ($loyalty as $typeID => $loyaltyAndSign) {
        foreach ($loyaltyAndSign as $loyaltyTransactionSign => $loyaltyPropertiesArray) {
            $acqPoints = $loyaltyPropertiesArray['points'];
            $loyaltyName = $loyaltyPropertiesArray['name'];

            $action_type = "Order";
            $document_id = "$orderID";
            $document_code = "$orderCode";
            $document_total = "$orderTotal";
            $entry_date = date('Y-m-d H:i:s');
            $sign = "$loyaltyTransactionSign";
            $points = "$acqPoints";
            $user_id = "$userID";
            $company_id = "$companyID";
            $details = "$loyaltyName";

            global $username, $password, $database;
            $db12 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db12->set_charset("utf8");
            $stmt12 = $db12->prepare("INSERT INTO Loyalty_Transactions (type_id, action_type, document_id, document_code, document_total, entry_date, sign, points,customer_id, user_id, company_id, details, timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt12->bind_param('ssssssssssss', $typeID, $action_type, $document_id, $document_code, $document_total, $entry_date, $sign, $points,$customerID, $user_id, $company_id, $details);
            $stmt12->execute();
            $stmt12->close();

            $points = (int)$sign*(float)$points;

            $db12->set_charset("utf8");
            $stmt12 = $db12->prepare("INSERT INTO Loyalty_Balances (customer_id, user_id, type_id, balance,timestamp) VALUES(?,?,?,?,NOW()) ON DUPLICATE KEY UPDATE balance=balance+?");
            $stmt12->bind_param('iiidd', $customerID, $userID, $typeID, $points, $points);
            $stmt12->execute();
            $stmt12->close();
        }
    }
}

function getVolumetrics($itemID){
    global  $username,$password,$database;
    $db1 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db1->set_charset("utf8");

    $stm11 = $db1->prepare("SELECT description FROM Online_Order_Item WHERE order_item_id='$itemID'");
    $stm11-> execute();
    $stm11-> bind_result($result);
    while ($stm11->fetch()) {

    }
    $stm11->close();
    return "$result";
}

?>