<?php
session_start();
error_reporting(0);
include_once("../../param.php");
include_once 'dbhelper.php';
function getOrderForPrinting($orderID,$showBarcode=false,$excel = false,$showPrices = true)
{
    global $username, $password, $database;
    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,delivery_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id,delivery_address_id,delivery_method,details,discount_amount FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate,$deliveryDate, $subtotal, $grandTotal, $vatAmount,$customerID,$companyID,$orderAddressID,$deliveryAddressID,$deliveryMethod,$details,$discountAmount);

    while ($stm->fetch()) {

    }
    $stm->close();

    $anonymousCheckout = false;
    $addItemByUnits = true;
    $stm = $db->prepare("SELECT anonymous_checkout,anonymous_checkout_customer_id,show_prices_with_vat,order_qty_by_subunits FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($anonymousCheckoutCheck,$anonymousCheckoutCustomerID,$showPricesIncludingVAT,$orderQtyBySubunits);
    while ($stm->fetch()) {
        if(strcmp($anonymousCheckoutCheck,'yes')==0 && $anonymousCheckoutCustomerID == $customerID){
            $anonymousCheckout = true;
        }
        if(strcmp($orderQtyBySubunits,'yes')==0){
            $addItemByUnits = false;
        }
    }
    $stm->close();

    $orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
    $deliveryDate = date_format( date_create_from_format('Y-m-d', $deliveryDate), 'd-m-Y');

    $subtotal = B2B_CURRENCY_SYMBOL.' '.number_format(floatval($subtotal),2);
    $grandTotal = B2B_CURRENCY_SYMBOL.' '.number_format(floatval($grandTotal),2);
    $vatAmount = B2B_CURRENCY_SYMBOL.' '.number_format(floatval($vatAmount),2);

    $stm = $db->prepare("SELECT  subtotal_currency, grand_total_currency, vat_amount_currency, currency_id, currency_rate, currency_sign FROM Multi_Currency_Orders WHERE Multi_Currency_Orders.order_id='$orderID' LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($subtotalCurrency,$grandTotalCurrency,$vatAmountCurrency,$currencyID,$currencyRate,$currencySign);
    while ($stm->fetch()) {

        if($subtotalCurrency >  0){$subtotal = "$currencySign ".number_format(floatval($subtotalCurrency),2);}
        if($vatAmountCurrency >  0){$vatAmount = "$currencySign ".number_format(floatval($vatAmountCurrency),2);}
        if($grandTotalCurrency >  0){$grandTotal = "$currencySign ".number_format(floatval($grandTotalCurrency),2);}

    }

    if(strcmp($currencyRate,'')==0){$currencyRate = 1;}
    if(strcmp($currencySign,'')==0){$currencySign = B2B_CURRENCY_SYMBOL;}


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

    while ($stm->fetch()) {


    }
    $stm->close();

    if($anonymousCheckout){
        $detailsAndCustomerInfo = explode('Customer:',$details);
        $details = $detailsAndCustomerInfo[0];
        $customerCode = str_replace("\n","<br>",$detailsAndCustomerInfo[1]);
        $customerCode = str_replace("Address: ","",$customerCode);
        $customerCode = str_replace("Phone: ","",$customerCode);
        $customerCode = str_replace("Email: ","",$customerCode);
    } else {
        $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
        $stm->execute();
        $stm->bind_result($customerCode, $customerName);

        while ($stm->fetch()) {
            $customerCode = " - ".$customerCode;

        }
        $stm->close();


        $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
        $stm->execute();
        $stm->bind_result($addressLine1, $addressLine2,$postcode,$city,$landline);

        while ($stm->fetch()) {
            if(strcmp("$addressLine2",'')!=0 && strcmp("$city",'')!=0){$addressLine2 .= ",";}
            if(strcmp("$postcode",'')!=0 && strcmp("$city",'')!=0){$postcode .= ",";}
            if(strcmp("$landline",'')!=0 ){$landline = "Tel.: ".$landline;}
            $deliveryAddress = "<b>Address:&nbsp;</b></td><td align='left'>$addressLine1 $postcode $addressLine2 $city";
        }
        $stm->close();

        if($deliveryAddressID != 0 &&  $deliveryAddressID != $orderAddressID){


            $stm = $db->prepare("SELECT address_line_1,address_line_2,postcode,city,landline FROM CustomerAddress WHERE customer_address_id='$deliveryAddressID' LIMIT 1");
            $stm->execute();
            $stm->bind_result($addressLine1D, $addressLine2D,$postcodeD,$cityD,$landlineD);
            while ($stm->fetch()) {
                if(strcmp("$addressLine2D",'')!=0 && strcmp("$cityD",'')!=0){$addressLine2D .= ",";}
                if(strcmp("$postcodeD",'')!=0 && strcmp("$cityD",'')!=0){$postcodeD .= ",";}
                if(strcmp("$landlineD",'')!=0 ){$landlineD = "Tel.: ".$landlineD;}
                $deliveryAddress = "<b>Address:&nbsp;</b></td><td align='left'>$addressLine1D $postcodeD $addressLine2D $cityD";
            }
            $stm->close();


        }

        $stm = $db->prepare("SELECT product_code_to_show FROM B2B_Configuration");
        $stm->execute();
        $stm->bind_result($productCodeToShow);
        while ($stm->fetch()) {}
        $stm->close();
    }
    $displayDate =$orderDate;
    $displayDeliveryDate =$deliveryDate;

    $detailsPayment = explode("Payment Method:","$details");
    $details = $detailsPayment[0];
    $paymentMethod = $detailsPayment[1];

    $paymentMethodTimeSlots = explode("\nTime Slot:","$paymentMethod");
    $paymentMethod = $paymentMethodTimeSlots[0];
    $timeSlot = $paymentMethodTimeSlots[1];

    if(strcmp("$timeSlot",'')!=0){
        $timeslotLabel = "<b>Time Slot:&nbsp;</b></td><td align='left'>$timeSlot";
    }

    if(strcmp("$details",'')!=0 && strcmp($details,' ')!=0) {
        $details = "<tr><td colspan='3' align='left' style='padding:0mm;padding-left: 2mm;padding-right: 2mm;'>Notes: $details</td></tr>";
    }



    if(strcmp(trim("$deliveryMethod"),'')!=0){
        $deliveryMethod = "<b>Method:&nbsp;</b></td><td align='left'>$deliveryMethod";
    }
    if(strcmp(trim("$paymentMethod"),'')!=0){
        $paymentMethod = "<b>Payment:&nbsp;</b></td><td align='left'>$paymentMethod";
    }

    $stm = $db->prepare("SELECT logo_link FROM B2B_Configuration LIMIT 1");
    $stm->execute();
    $stm->bind_result($logoLink);
    while ($stm->fetch()) {}
    $stm->close();

    $result= "
<div class='row'>
<div  class='col-sm-8 col-sm-offset-2'>
";
    if($excel){
        $result .= "
         
    <table class='heading' style='width:100%;'>
        <tr>
            <td style='font-weight:bold' ><center><h3>Order Details</h3></td>
            <td style='font-weight:bold' ></td>
            <td style='font-weight:bold' ><center><h3>Customer Details</h3></td>
        </tr>
        <tr>
            <td >Order No.: </td><td>$orderCode</td>
            <td align='right' >$customerName $customerCode</td>
        </tr>
        <tr>
            <td >Order Type: </td><td>Online Order</td>
            <td align='right' >$addressLine1</td>
        </tr>
        <tr>
            <td >Order Date: </td><td>$displayDate</td>
            <td align='right' >$postcode $addressLine2 $city</td>
        </tr>
        <tr>
            <td >Delivery Date: </td><td>$displayDeliveryDate</td>
            <td align='right' >$landline</td>
        </tr>
        <tr>
            <td>Delivery Method:</td><td>$deliveryMethod</td><td></td>
        </tr>
        <tr>
            <td>Payment Method:</td><td>$paymentMethod</td><td></td>
        </tr>
        <tr>
            $details
        </tr>

    </table>
        ";

        $result.= "
<div id='invoice_body'>
    
     <table id='tableHeader' style='margin-top:10px;'>
            <tr style='background:#eee;'>
                <td style='width:8%' ><b>No.</b></td>
                <td style='width:17%'><b>Code</b></td>
                 <td style='width:30%'><b>Description</b></td>
                <td style='width:15%'><b>Quantity</b></td>
                <td style='width:15%' ><b>Unit Price</b></td>
                <td style='width:15%'><b>Total</b></td>
            </tr>
          

            ";
    }
    else {
        $result .= "
<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:14pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }


       @page {
            header: html_myHTMLHeader1;
            footer: html_myFooter1;
            margin: 0.5cm;
        }

        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>

<htmlpageheader name='myHTMLHeader1'>
    <table class='heading' >
          <tr>
              <td valign='top' style='width:30%'>
                  <img style='display:block;max-width: 200px;' src='.$logoLink'/>
              </td>
              <td  valign='top' style='width:40%' align='center'>
                 <p style='display:block;font-weight:bold; font-size:24px; width:100%'>Online Order</p>
              </td>
              <td valign='top' style='width:30%' align='right'>
                 <h1 class='heading' style='display:block;padding-top:2px;padding-bottom:2px;'>$line1</h1>
                            <h2 class='heading'>
                                $line2<br/>
                                $line3<br/>
                                $line4<br/>
                                $line5<br/>
                                $line6<br/>
                                $line7
                            </h2>
              </td>
           </tr>
      </table>
    
    <table class='heading' style='width:100%;'>
        <tr>

            <td  valign='top' align='left' style='padding:1mm;width: 28%'>
                <table>
                    <tr><td style='font-weight:bold' colspan='2'><h3>Order Details</h3></td></tr>
                    <tr><td >Order No.: </td><td>$orderCode</td></tr>
                    <tr><td >Order Type: </td><td>Online Order</td></tr>
                    <tr><td >Order Date: </td><td>$displayDate</td></tr>
                    <tr><td >Delivery Date: </td><td>$displayDeliveryDate</td></tr>
                </table>
            </td>
            <td valign='top' align='center' style='padding:1mm;width: 44%'>
                <table style='width: 85%;'>
                    <tr><td style='font-weight:bold' colspan='2' align='Center'><h3>Delivery Details</h3></td></tr>
                    <tr><td style='vertical-align:top;' align='left'>$deliveryAddress</td></tr>
                    <tr><td style='vertical-align:top;' align='left'>$deliveryMethod</td></tr>
                    <tr><td style='vertical-align:top;' align='left'>$paymentMethod</td></tr>
                    <tr><td style='vertical-align:top;' align='left'>$timeslotLabel</td></tr>

                </table>
            </td>
            <td class='customer' valign='top' align='right' style='padding:1mm;width: 28%'>
                <table >
                    <tr><td style='font-weight:bold'  align='right'><h3>Customer Details</h3></td></tr>
                    <tr><td align='right'>$customerName $customerCode</td></tr>
                    <tr><td align='right'>$addressLine1</td></tr>
                    <tr><td align='right'>$postcode $addressLine2 $city</td></tr>
                    <tr><td align='right'>$landline</td></tr>

                </table>
            </td>
        </tr>
        $details

    </table>
    </htmlpageheader>
    ";

        if($showPrices){

            $result.= "
    <div id='invoice_body'>
        
         <table id='tableHeader' style='margin-top:10px;'>
                <tr style='background:#eee;'>
                    <td style='width:8%' ><b>No.</b></td>
                    <td style='width:17%'><b>Code</b></td>
                     <td style='width:30%'><b>Description</b></td>
                    <td style='width:15%'><b>Quantity</b></td>
                    <td style='width:15%' ><b>Unit Price</b></td>
                    <td style='width:15%'><b>Total</b></td>
                </tr>
                </table>
    
    
                <table style='overflow:hidden;'>
    
                ";

        } else {
            $result.= "
    <div id='invoice_body'>
        
         <table id='tableHeader' style='margin-top:10px;'>
                <tr style='background:#eee;'>
                    <td style='width:10%' ><b>No.</b></td>
                    <td style='width:30%'><b>Code</b></td>
                     <td style='width:45%'><b>Description</b></td>
                    <td style='width:15%'><b>Quantity</b></td>

                </tr>
                </table>
    
    
                <table style='overflow:hidden;'>
    
                ";
        }
    }


    $vatsArray = Array();
    $stm = $db->prepare("SELECT vat_id,vat_code,percentage FROM Vats");
    $stm->execute();
    $stm->bind_result($vatID,$vatCode,$percentage);
    while ($stm->fetch()) {
        $vatObject= new stdClass();
        $vatObject->id=$vatID;
        $vatObject->code=$vatCode;
        $vatObject->percentage=$percentage;
        $vatObject->vatAmount=0;
        $vatObject->goods=0;
        array_push($vatsArray,$vatObject);
    }
    $stm->close();

    $counter = 0;
    $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name,Order_Item.description FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name,$description);



    while ($stm->fetch()) {

        $counter++;
        $unitPrice *= $currencyRate;

        if($addItemByUnits) {
            $qty = $qty / floatval(getSubUnits($itemID));
            $lineTotal = $unitPrice*$qty;
        } else {
            $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
        }

        $name .= " $description";

        if(strcmp("$productCodeToShow",'barcode')==0 || $showBarcode){
            global $username, $password, $database;
            $db2 = new mysqli('localhost', $username, $password, $database);
            if (mysqli_connect_errno()) {
                printf("Connect failed: %s\n", mysqli_connect_error());
                exit();
            }
            $db2->set_charset("utf8");

            $barcodeStatement= "SELECT barcode FROM Item_Barcode WHERE item_id = '$itemID' ORDER BY default_barcode DESC LIMIT 1";
            $stm2 = $db2->prepare($barcodeStatement);
            $stm2-> execute();
            $stm2-> bind_result($barcode);
            while ($stm2->fetch()) {}
            $stm2-> close();
            if(strcmp("$barcode",'')!=0 && !$showBarcode){
                $itemCode = $barcode;
            }
            if(strcmp("$barcode",'')!=0 && $showBarcode){
                if($excel){
                    $name .= ' - BC: '.$barcode.'';
                } else {
                    $name .= '&nbsp;<br>BC: '.$barcode.'';
                }
            }
        }

        $defaultPrice = getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID)/getPriceRate()*$currencyRate;

        if($defaultPrice > $unitPrice && $unitPrice > 0){
            $percentDiscount = round((1 - ($unitPrice/$defaultPrice))*100);
            $discountLabel = "<span class='pull-right' style='color: firebrick !important;' >(-$percentDiscount%)</span>";
        } else {
            $discountLabel = "";
        }

        $vatOnUnitPrice = 0;
        $vatLineAmount = 0;

        foreach($vatsArray as $vatObject)
        {
            if($vatObject->id==$vatID)
            {
                $vatOnUnitPrice = $vatObject->percentage * $unitPrice / 100;
                $vatLineAmount = $vatObject->percentage * $lineTotal / 100;
                $vatObject->vatAmount+=$vatLineAmount;
                $vatObject->goods+=$lineTotal;
            }
        }

        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $lineTotalDisplay = $currencySign.' '.number_format(floatval($lineTotal+$vatLineAmount),2);
            $unitPriceDisplay = $currencySign.' '.number_format(floatval($unitPrice+$vatOnUnitPrice),2);
        } else {
            $lineTotalDisplay = $currencySign.' '.number_format(floatval($lineTotal),2);
            $unitPriceDisplay = $currencySign.' '.number_format(floatval($unitPrice),2);
        }

        if($customerID > 0) {
            $name = getCustomerSynonym($customerID,$itemID,'name',$name);
            $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
        }


        if($showPrices){
            $result.= "<tr>
                <td style='width:8%'> $counter</td >
                <td style='width:17%;' > $itemCode  </td >
                <td style='width:30%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
                <td style='width:15%;text-align:right;padding-right:5px;' > $unitPriceDisplay $discountLabel</td >
                <td style='width:15%;text-align:right;padding-right:5px;'  > $lineTotalDisplay</td >
            </tr >";

        } else {
            $result.= "<tr>
                <td style='width:10%'> $counter</td >
                <td style='width:30%;' > $itemCode  </td >
                <td style='width:45%'> $name </td >
                <td style='width:15%;text-align:center;padding-right:5px;'  > $qty</td >
            </tr >";
        }

    }
    $stm->close();

    if($excel){
        if($showPrices){
            $result.= "<tr>
                        <td style='width:8%'></td >
                        <td style='width:17%;' ></td >
                        <td style='width:30%'></td >
                        <td style='width:15%;text-align:center;padding-right:5px;'  ></td >
                        <td style='width:15%;text-align:right;padding-right:5px;' ></td >
                        <td style='width:15%;text-align:right;padding-right:5px;'  ></td >
                    </tr >
                    <tr>
                        <td style='width:8%'></td >
                        <td style='width:17%;' ></td >
                        <td style='width:30%'></td >
                        <td style='width:15%;text-align:center;padding-right:5px;'  ></td >
                        <td style='width:15%;text-align:right;padding-right:5px;' ></td >
                        <td style='width:15%;text-align:right;padding-right:5px;'  ></td >
                    </tr >";
        } else {
            $result.= "<tr>
                        <td style='width:10%'></td >
                        <td style='width:30%;' ></td >
                        <td style='width:45%'></td >
                        <td style='width:15%;text-align:center;padding-right:5px;'  ></td >
                    </tr >
                    <tr>
                        <td style='width:10%'></td >
                        <td style='width:30%;' ></td >
                        <td style='width:45%'></td >
                        <td style='width:15%;text-align:center;padding-right:5px;'  ></td >
                    </tr >";
        }
    }

    $result.=
        "

        </table>
        </div>


        


    </div>



   

</div>
<htmlpagefooter name='myFooter1'>";
    if($showPrices){
        $result.=
            "
            <div id='invoice_total' style='margin-top:20px;border-top: 1px solid #222;border-bottom: 1px solid #222;'>
                <table style='width: 100%'>
                 <tr>
                   <td style='width:50%;'>
    
                   <table>
                      <tr>
                        <td style='text-align:center'>
                         <p style='display: inline;text-align:center;'><b> VAT Summary</b></p>
                        </td>
                     </tr>
                     </table>
                     <table>
                     <tr>
    
                       <td style='width:33%;text-align:center;font-weight: bold;'>
                         <p > Percent:</p>
                       </td>
                       <td style='width:33%;text-align:center;font-weight: bold;'>
                         <p > Goods:</p>
                       </td>
                       <td style='width:33%;text-align:center;font-weight: bold;'>
                         <p> VAT</p>
                       </td>
                     </tr>";


        foreach($vatsArray as $vatObject) {

            if($vatObject->goods>0) {

                $vatObject->goods = number_format(floatval($vatObject->goods),2);
                $vatObject->vatAmount = number_format(floatval($vatObject->vatAmount),2);
                $result .= "<tr>
                    <td style='width:33%;font-size:12px;text-align:center;' > $vatObject->percentage%  </td >
                    <td style='width:33%;font-size:12px;text-align:center;'>$currencySign $vatObject->goods </td >
                     <td style='width:33%;text-align:center;font-size:12px;'>$currencySign $vatObject->vatAmount</td >
                </tr >";
            }

        }


        if($excel){
            if($discountAmount > 0){
                $discountAmountDisplay = number_format(floatval($discountAmount),2);
                $discountAmountLabel = "<tr>
                        <td style='text-align:right;font-weight:bold' > Discount</td>
                        <td style='text-align:right;' >$currencySign $discountAmountDisplay</td>
                    </tr>";
            }
            $result .= "
                    <tr>
                    <td style='text-align:right;font-weight:bold;'></td>
                    <td style='text-align:right;font-weight:bold;'></td>
                    <td style='text-align:right;font-weight:bold;'></td>
                    </tr>
                    <tr>
                    <td style='text-align:right;font-weight:bold;'> Order Totals</td>
                    <td style='text-align:right;font-weight:bold;'></td>
                    <td style='text-align:right;font-weight:bold;'></td>
                    </tr>
                    <tr>
                        <td style='text-align:right;font-weight:bold;' > Subtotal</td>
                        <td style='text-align:right;' >$subtotal</td>
                    </tr>
                    $discountAmountLabel
                    <tr>
                        <td style='text-align:right;font-weight:bold' > Vat Total</td>
                        <td style='text-align:right;' >$vatAmount</td>
                    </tr>
                    <tr>
                        <td style='text-align:right;font-weight:bold' > Grand Total</td>
                        <td style='text-align:right;' >$grandTotal</td>
                    </tr>
                </table>
                  </td>
                </tr>
              </table>
              </td>
                  </tr>
                  </table>
            </div>
                </htmlpagefooter>
    
    
    ";
        } else {
            if($discountAmount > 0){
                $discountAmountDisplay = number_format(floatval($discountAmount),2);
                $discountAmountLabel = "<tr>
                        <td style='text-align:right;font-weight:bold'> Discount</td>
                        <td style='text-align:right;' >$currencySign $discountAmountDisplay</td>
                    </tr>";
            }
            $result .= "
                   </table>
    
                  </td>
                  <td style='width:20%'></td>
                  <td  style='width:30%;'>
                   <table>
                    <tr>
                        <td style='text-align:right;font-weight:bold;'> Subtotal</td>
                        <td style='text-align:right;' >$subtotal</td>
                    </tr>
                    $discountAmountLabel
                    <tr>
                        <td style='text-align:right;font-weight:bold'> Vat Total</td>
                        <td style='text-align:right;' >$vatAmount</td>
                    </tr>
                    <tr>
                        <td style='text-align:right;font-weight:bold'> Grand Total</td>
                        <td style='text-align:right;' >$grandTotal</td>
                    </tr>
                </table>
                  </td>
                </tr>
              </table>
            </div>
            <div style='margin-top: 2px;'>
              <p style='color:grey;margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce </p>
            </div>
                <table width='100%' style='margin-top: 10px;vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                    color: #000000;  '><tr>
                    <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                    <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                    <td width='33%' style='text-align: right; '>$orderCode</td>
                    </tr></table>
                </htmlpagefooter>
    
    
    ";

        }
    } else {
        if(!$excel){
            $result.="
        <div style='margin-top: 2px;'>
              <p style='color:grey;margin-top:5px;font-size:10px;font-family: Helvetica Neue, Helvetica, Arial, sans-serif'> Powered by Coprime Mobile Commerce </p>
            </div>
                <table width='100%' style='margin-top: 10px;vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                    color: #000000;  '><tr>
                    <td width='33%'><span style=''>{DATE d-m-Y}</span></td>
                    <td width='33%' align='center' style=''>{PAGENO} of {nbpg}</td>
                    <td width='33%' style='text-align: right; '>$orderCode</td>
                    </tr></table>
                </htmlpagefooter>";
        }
    }
    return $result;
}


$orderID =$_POST['orderID'];
$orderCode =$_POST['orderCode'];
$download =$_POST['download'];
$prices =$_POST['prices'];
$excel =$_POST['excel'];
$barcodes = $_POST['barcodes'];

if(strcmp($barcodes,'yes')==0){
    $showBarcodes = true;
} else {
    $showBarcodes = false;
}

if(strcmp($prices,'yes')==0){
    $showPrices = true;
} else {
    $showPrices = false;
}

if(strcmp($excel,'yes')==0){

    $result = getOrderForPrinting($orderID,$showBarcodes,true,$showPrices);

    require_once(ROOT . 'libs/phpexcel/vendor/autoload.php');

    // save $table inside temporary file that will be deleted later
    $tmpfile = tempnam(sys_get_temp_dir(), 'html');
    file_put_contents($tmpfile, $result);

    // insert $table into $objPHPExcel's Active Sheet through $excelHTMLReader
    $objPHPExcel     = new PHPExcel();
    $excelHTMLReader = PHPExcel_IOFactory::createReader('HTML');
    $excelHTMLReader->loadIntoExisting($tmpfile, $objPHPExcel);
    $objPHPExcel->getActiveSheet()->setTitle('Excel Export'); // Change sheet's title if you want

    foreach(range('B','Z') as $columnID) {
        $objPHPExcel->getActiveSheet()->getColumnDimension($columnID)->setAutoSize(true);
    }


    unlink($tmpfile); // delete temporary file because it isn't needed anymore

    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'); // header for .xlxs file
    header('Content-Disposition: attachment;filename='.$orderCode.'.xlsx'); // specify the download file name
    header('Cache-Control: max-age=0');

// Creates a writer to output the $objPHPExcel's content
    $writer = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
    $writer->save('php://output');
    exit;

} else {

    include_once("../MPDF57/mpdf.php");

    $result = getOrderForPrinting($orderID,$showBarcodes,false,$showPrices);

    $mpdf = new mPDF('utf8', 'A4');
    //$mpdf->SetHTMLHeaderByName('myHTMLHeader1');
    $mpdf->setAutoTopMargin = 'stretch';
    $mpdf->setAutoBottomMargin = 'stretch';
    $mpdf->keep_table_proportions = true;
    $mpdf->WriteHTML($result);

    if(strcmp($download,'yes')==0){
        $mpdf->Output("$orderCode.pdf", "D");
    } else {
        $mpdf->Output("$orderCode.pdf", "I");
    }

}


?>