<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once('../../param.php');
require_once("dbhelper.php");
include_once('getItemsInCartForOrder.php');

$customerID = $_SESSION['customerID'];
$points = $_POST['points'];
$multiplier = $_POST['multiplier'];
$orderID = $_POST['orderID'];

$discountAmount = round($points / $multiplier ,2);
$depositAmount = round($points);

//echo "points: " . $points . "<br>";
//echo "multiplier: " . $multiplier . "<br>";
//echo "orderID: " . $orderID . "<br>";
//echo "Discount Amount: " . $discountAmount . "<br>";

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$stmt = $db->prepare("UPDATE Online_Orders SET discount_amount=?,deposit_amount=? WHERE order_id=?");
$stmt->bind_param('ddi', $discountAmount,$depositAmount,$orderID);
$stmt->execute();
$stmt->close();


$dbOrder = getItemsInCartForOrder($orderID,$customerID);

echo "$dbOrder->subTotal\n";
echo json_encode($dbOrder);

$globalDiscount = $discountAmount/$dbOrder->subTotal*100;

foreach($dbOrder->items as $item)
{
    $globalDiscountOnLine = $item->lineTotal * $globalDiscount / 100;
    $stmt = $db->prepare("UPDATE Online_Order_Item SET global_discount=? WHERE order_id=? AND item_id=? AND qty=?");
    $stmt->bind_param('diid', $globalDiscountOnLine,$orderID,$item->itemID,$item->qty);
    $stmt->execute();
    $stmt->close();

}