<?php
session_start();
include_once("../../param.php");
require("dbhelper.php");

if(isset($_SESSION['lang'])){
    include('../langs/'.$_SESSION['lang'].'.php');
} else {
    include('../langs/en.php');
}

$singleOrderID=$_POST['orderID'];
$fromPayment=false;
$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$isAnonymousCheckout=false;

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

if(isset($_POST['p']) && isset($_POST['orderCode'])){
    $paymentOrderCode = $_POST['orderCode'];
    $stm = $db->prepare("SELECT order_id FROM Orders WHERE order_code = '$paymentOrderCode' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($paymentOrderID);

    while ($stm->fetch()) {}
    $stm-> close();
    $singleOrderID = $paymentOrderID;
    $paymentStatus = $_POST['p'];
    $fromPayment=true;

}

$addItemByUnits = true;
$stm = $db->prepare("SELECT primary_language,show_prices,show_prices_with_vat,css_theme,drop_ship,anonymous_checkout,anonymous_checkout_customer_id,order_qty_by_subunits FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPricesCheck,$showPricesIncludingVAT,$cssTheme,$dropShip,$anonymous_checkout,$anonymous_checkout_customer_id,$orderQtyBySubunits);
while ($stm->fetch()) {

    if(strcmp($anonymous_checkout,"yes")==0 || $_SESSION['customerID']==$anonymous_checkout_customer_id)
    {
        $isAnonymousCheckout=true;
    }

    if(strcmp($showPricesCheck,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }

    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }
}
$stm-> close();

$stm = $db->prepare("SELECT order_id,order_code,order_date,delivery_date,subtotal,vat_amount,grand_total,details,order_address_id,delivery_address_id,status,delivery_method,discount_amount FROM Orders WHERE Orders.order_id='$singleOrderID' AND customer_id='".$_SESSION['customerID']."'");
$stm-> execute();
$stm-> bind_result($resolvedOrderID,$orderCode,$orderDate,$deliveryDate,$subtotal,$vatAmount,$grandTotal,$details,$orderAddressID,$deliveryAddressID,$orderStatus,$deliveryMethod,$discountAmount);
while ($stm->fetch()) {

    $displaySubtotal = CURRENCY_SYMBOL.number_format(floatval($subtotal),2);
    $displayVatTotal = CURRENCY_SYMBOL.number_format(floatval($vatAmount),2);
    $displayGrandTotal = CURRENCY_SYMBOL.number_format(floatval($grandTotal),2);
    if(strpos($orderStatus,'JCC') !== false){$paymentStatus = 0;}
    if(strpos($orderStatus,'Payment Pending') !== false){$paymentStatus = 0;}
    else if(strpos($orderStatus,'Placed') !== false){$paymentStatus = 1;}

}

$stm-> close();

$stm = $db->prepare("SELECT  subtotal_currency, grand_total_currency, vat_amount_currency, currency_id, currency_rate, currency_sign FROM Multi_Currency_Orders WHERE Multi_Currency_Orders.order_id='$resolvedOrderID' LIMIT 1");
$stm-> execute();
$stm-> bind_result($subtotalCurrency,$grandTotalCurrency,$vatAmountCurrency,$currencyID,$orderCurrencyRate,$currencySign);
while ($stm->fetch()) {
    $multiCurrencyISO = getCurrencyIsoByID($currencyID);
    if($subtotalCurrency >  0){$displaySubtotal = "$currencySign".number_format(floatval($subtotalCurrency),2);}
    if($vatAmountCurrency >  0){$displayVatTotal = "$currencySign".number_format(floatval($vatAmountCurrency),2);}
    if($grandTotalCurrency >  0){$displayGrandTotal = "$currencySign".number_format(floatval($grandTotalCurrency),2);}
}
$stm-> close();

if(strcmp($orderCurrencyRate,'')==0){$orderCurrencyRate = 1;}
if(strcmp($currencySign,'')==0){$currencySign = B2B_CURRENCY_SYMBOL;}


if(strcmp($dropShip,'yes')==0){
    $stm = $db->prepare("SELECT to_address_line_1,label_1,received_amount FROM B2B_Dropship_Orders_Extra WHERE order_id='$singleOrderID' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($dropshipAddressLine1,$recepientName,$freightCollect);
    while ($stm->fetch()) {}
    $stm-> close();
    if(strcmp($recepientName,'')!=0){
        $recepient ="$recepientName, <br>";
    }
    $dropshipAddress = "</p><label>RECIPIENT: </label><p style='padding-top:10px;'>$recepient $dropshipAddressLine1 ";

    if($freightCollect > 0){
        $freightCollect = number_format(floatval($freightCollect),2);
        $dropshipAddress .="</p> <label>FREIGHT COLLECTION: </label><p style='padding-top:10px;'> $freightCollect </p>";

    }
}

$stm = $db->prepare("SELECT country, city, address_line_1, address_line_2, postcode, region, lat, lng, pobox, landline, fax, primary_address, timestamp FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
$stm->execute();
$stm->bind_result($country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
while ($stm->fetch()) {}
$stm->close();
$orderAddress = new stdClass();
$orderAddress->country = $country;
$orderAddress->city = $city;
$orderAddress->area = $region;
$orderAddress->addressLine1 = $addressLine1;
$orderAddress->addressLine2 = $addressLine2;
$orderAddress->postcode = $postcode;
$orderAddress->lat = $lat;
$orderAddress->lng = $lng;

$hasBillingAddress = false;
if($deliveryAddressID != 0 && $deliveryAddressID != $orderAddressID){
    $hasBillingAddress = true;

    $addressLine1D = $addressLine1;
    $addressLine2D = $addressLine2;
    $stm = $db->prepare("SELECT country, city, address_line_1, address_line_2, postcode, region, lat, lng, pobox, landline, fax, primary_address, timestamp FROM CustomerAddress WHERE customer_address_id='$deliveryAddressID'");
    $stm->execute();
    $stm->bind_result($country, $city, $addressLine1, $addressLine2, $postcode, $region, $lat, $lng, $pobox, $landline, $fax, $primaryAddress, $timestamp);
    while ($stm->fetch()) {}
    $stm->close();

    $billingAddress = new stdClass();
    $billingAddress->country = $country;
    $billingAddress->city = $city;
    $billingAddress->area = $region;
    $billingAddress->addressLine1 = $addressLine1;
    $billingAddress->addressLine2 = $addressLine2;
    $billingAddress->postcode = $postcode;
    $billingAddress->lat = $lat;
    $billingAddress->lng = $lng;
}

$AlternativePaymentMethodName = $langu['other_payment_methods'];
$hasCreditMethods = false;
$hasJCC = false;
$db->set_charset("utf8");
$stm = $db->prepare("SELECT payment_method_id,payment_method_code,name,logo,allow_credit,merchant_id,acquirer_id,currency_iso_code,password,post_url,saving_cards FROM B2C_Payment_Methods WHERE active='yes' ORDER BY B2C_Payment_Methods.position ASC ");
$stm-> execute();
$stm-> bind_result($paymentMethodID,$paymentMethodCode,$paymentMethodName,$paymentMethodLogo,$allowCredit,$merchantID,$acquirerID,$currencyISO, $paymentMethodPass,$paymentMethodFormURL,$savingCards);
while ($stm->fetch()) {

    switch ($paymentMethodCode){
        case "JCC":
            $JccSaveCardsFeature = false;
            if(strcmp($savingCards,'yes')==0){
                $JccSaveCardsFeature = true;
            }
            $hasJCC = true;
            $JCCmerchantID = $merchantID;
            $JCCpassword = $paymentMethodPass;
            $JCCacquirerID = $acquirerID;
            if($multiCurrencyISO > 0){
                $JCCcurrency = $multiCurrencyISO;
            } else {
                $JCCcurrency = $currencyISO;
            }
            $JCCFormURL = $paymentMethodFormURL;
            $JCCDirectFormURL = str_replace('RedirectAuthLink','DirectAuthLink',$JCCFormURL);
            $payButtonFunction = "placeOrder();";
            $grandTotal = number_format(floatval($grandTotal), 2, '.', '');
            $JCCformattedPurchaseAmt = str_pad(str_replace('.','',$grandTotal), 12, '0', STR_PAD_LEFT);
            break;
    }
    if(strcmp($paymentMethodLogo,'')!=0 && file_exists(ROOT."b2b/assets/img/$paymentMethodLogo")){
        $paymentMethodLogo =  "./assets/img/$paymentMethodLogo";
    } else {
        $paymentMethodLogo =  "./assets/img/paymenticon.png";
    }
    if(strcmp($allowCredit,'yes')!=0) {
        $paymentMethods .= "<option value='$paymentMethodID' data-logo='$paymentMethodLogo' data-iscredit='$allowCredit' data-method='$paymentMethodCode'>  $paymentMethodName </option>";
    } else {
        $hasCreditMethods = true;
    }

}
if($hasCreditMethods && !$isAnonymousCheckout) {
    $paymentMethods .= "<option value='0' data-logo='./assets/img/paymenticon.png' data-iscredit='yes' data-method='OTHER' data-iscredit='yes'>  $AlternativePaymentMethodName </option>";
}
$stm->close();
$paymentMethodLabel = $langu['payment_method_label'];
$paymentMethodsSelect = "         <center>
                                  <div style='height: 100px;width: 90%' >
                                  <h3>$paymentMethodLabel</h3>
                                  <select class='form-control'  id='paymentMethod' name='paymentMethod' style='width: 79%;display: inline-block;background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;' >
                                     $paymentMethods
                                  </select>
                                  <img  id='paymentMethodLogo' class='form-control' height='auto' style='padding:0px;display: inline-block;width: 19%;' >
                                  </div>
                                  </center>
                                  <script type='text/javascript'>
                                        jQuery(document).ready(function () {
                                            $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo'));
                                            var code = $('#paymentMethod :selected').data('method');
                                            $('#payNowButton').html('".$langu['proceed_with_label']." ').show();
                                            
                                            $('#paymentMethod').on('change', function() {
                                                
                                                $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo')); 
                                                
                                                $('#payNowButton').html('".$langu['proceed_with_label']." ').show();
                                                
                                                var code = $('#paymentMethod :selected').data('method');

                                                if(code.localeCompare('JCC') === 0){
                                                    $('#withJCCDirect').show();
                                                    $('#cardSelectionTable').show();
                                                } else {
                                                    $('#withJCCDirect').hide();
                                                    $('#cardSelectionTable').hide();
                                                }
                                                

                                            });
                                        });
                                        
                                  </script>";


$detailsPayment = explode("\nPayment Method:","$details");
$details = $detailsPayment[0];
$paymentMethod = $detailsPayment[1];

$paymentMethodTimeSlots = explode("\nTime Slot:","$paymentMethod");
$paymentMethod = $paymentMethodTimeSlots[0];
$timeSlot = $paymentMethodTimeSlots[1];

$subTotal=0;
$grandTotal=0;
$vatTotal=0;
$orderLines = array();
$stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,Items.short_description,Items.subunits,Order_Item.description FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$resolvedOrderID' AND Order_Item.order_id > 0");
$stm-> execute();
$stm-> bind_result($itemID,$qty,$unitPrice,$vatID,$itemCode,$name,$shortDescription, $subUnits,$description);
while ($stm->fetch()) {
    $unitPrice *= $orderCurrencyRate;


    $imageUrl = getDefaultImage($itemID);
    $price = number_format(floatval($unitPrice),2);

    if($addItemByUnits) {
        $qty = $qty / floatval(getSubUnits($itemID));
        $lineTotal = $unitPrice*$qty;
    } else {
        $lineTotal = $unitPrice*$qty / floatval(getSubUnits($itemID));
    }


    $subTotal += $lineTotal;
    $lineVat = $lineTotal * getVatPercentage($vatID) / 100;
    $vatTotal += $lineVat;

    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
    {
        $name=$shortDescription;
    }

    $customerID = $_SESSION['customerID'];
    if($customerID > 0) {
        $name = getCustomerSynonym($customerID,$itemID,'name',$name);
        $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
    }

    $name .= " $description";

    if($showPrices)
    {
        $displayLineTotal = $currencySign."".number_format(floatval($lineTotal),2);

        if($showPricesWithVAT){

            $inc = $langu['incl_label'];
            $vat = $langu['vat_label'];
            $displayLineTotalIncVat= "$currencySign".number_format(floatval($lineTotal + $lineVat),2)." $inc $vat";

            if($includeVatOnPrice){
                $displayLineTotal= $currencySign."".number_format(floatval($lineTotal + $lineVat),2);
                $displayLineTotalIncVat = '';

            }
        }
    }
    else
    {
        $displayLineTotal = "";
    }

    $orderItem = new stdClass();
    $orderItem->itemID = $itemID;
    $orderItem->qty = $qty;
    $orderItem->itemCode = $itemCode;
    $orderItem->itemName = trim($name);
    $orderItem->imageUrl = $imageUrl;
    $orderItem->lineTotal = $displayLineTotal;
    $orderItem->includedVatLabel = $displayLineTotalIncVat;
    array_push($orderLines,$orderItem);


}
$stm = $db->prepare("SELECT order_time,delivery_time,time_slot_from,time_slot_to,delivery_status,payment_method_description,delivery_notes FROM Order_Delivery_Details WHERE order_id=? LIMIT 1");
$stm->bind_param('i',$resolvedOrderID);
$stm->execute();
$stm->bind_result($orderTime,$deliveryTime,$timeSlotFrom,$timeSlotTo,$deliveryStatus,$paymentMethodDescription,$deliveryNotes);
while ($stm->fetch()) {}
$stm->close();

$deliveryDetails = new stdClass();
$deliveryDetails->orderTime = $orderTime;
$deliveryDetails->deliveryTime = $deliveryTime;
$deliveryDetails->timeSlotFrom = $timeSlotFrom;
$deliveryDetails->timeSlotTo = $timeSlotTo;
$deliveryDetails->deliveryStatus = $deliveryStatus;
$deliveryDetails->paymentMethodDescription = $paymentMethodDescription;
$deliveryDetails->deliveryNotes = $deliveryNotes;

$jsonObject = new stdClass();
$jsonObject->showPrices = $showPrices;
$jsonObject->showPricesWithVAT = $showPricesWithVAT;
$jsonObject->includeVatOnPrice = $includeVatOnPrice;
$jsonObject->hasBillingAddress = $hasBillingAddress;
$jsonObject->orderID = $resolvedOrderID;
$jsonObject->orderCode = $orderCode;
$jsonObject->orderDate = $orderDate;
$jsonObject->deliveryDate = $deliveryDate;
$jsonObject->orderStatus = $orderStatus;
$jsonObject->subtotal = $displaySubtotal;
$jsonObject->vatAmount = $displayVatTotal;
$jsonObject->grandTotal = $displayGrandTotal;
$jsonObject->deliveryMethod = trim($deliveryMethod);
$jsonObject->paymentMethod = trim($paymentMethod);
$jsonObject->timeSlot = trim($timeSlot);
$jsonObject->orderNotes = trim($details);
$jsonObject->orderAddress = $orderAddress;
$jsonObject->billingAddress = $billingAddress;
$jsonObject->orderLines = $orderLines;
$jsonObject->deliveryDetails = $deliveryDetails;

echo json_encode($jsonObject);
return'';
?>

<body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div id='cartItems' class="container">

                    </div>
                </div>
            </div>

            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area">

                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container" id="checkoutContainer">
                        <h3 class="block-title alt" style="margin-bottom: 7px;"><i class="fa fa-angle-down"></i><?php echo $langu['account_view_order_information_title'] ?></h3>
                        <div id="checkoutCartContainer">
                            <div class='col-md-12' style="margin: 0px;padding: 0px;" >
                                <table class="table table-bordered" style="margin: 0px;border: solid 3px rgba(35, 35, 35, 0.1);">
                                    <tr><td style="<?php if (strcmp($lang, 'en') == 0){echo 'width: 150px;';}else{echo 'width: 250px;';}?>"><h4 style="color:black;margin: 1px;"><b><?php echo $langu['account_view_order_code'] ?>:&nbsp;&nbsp; </b></h4></td><td><h4 style="color:black;margin: 1px;"><?php echo" $orderCode"?></h4></td></tr>
                                    <tr><td><h4 style="color:black;margin: 1px;"><b><?php echo $langu['account_view_order_date'] ?>:&nbsp;&nbsp; </b></h4></td><td><h4 style="color:black;margin: 1px;"><?php echo" $orderDate"?></h4></td></tr>
                                    <tr><td><h4 style="color:black;margin: 1px;"><b><?php echo $langu['account_view_order_delivery_date'] ?>:&nbsp;&nbsp; </b></h4></td><td><h4 style="color:black;margin: 1px;"><?php echo" $deliveryDate"?></h4></td></tr>
                                <?php
                                $orderStatusLabel = $langu['order_status_label'];
                                if(isset($paymentStatus) && $paymentStatus < 1){
                                    echo "<tr><td><h4 style=\"color:black;margin: 1px;\"><b>$orderStatusLabel: </b></h4></td><td><h4 style='color:black;margin: 1px;'><b style=\"color:firebrick;\">$orderStatus</b></h4></td></tr>";
                                } else if(isset($paymentStatus) && $paymentStatus == 1){
                                    echo "<tr><td><h4 style=\"color:black;margin: 1px;\"><b>$orderStatusLabel: </b></h4></td><td><h4 style='color:black;margin: 1px;'><b style=\"color:green;\">$orderStatus</b></h4></td></tr>";
                                } else {
                                    echo "<tr><td><h4 style=\"color:black;margin: 1px;\"><b>$orderStatusLabel: </b></h4></td><td><h4 style='color:black;margin: 1px;'><b style=\"color:black;\">$orderStatus</b></h4></td></tr>";
                                }
                                ?>
                                </table>
                            </div><br>
                            <div class='row orders block'>
                                <div class='col-md-8'  style="margin-top:5px;">
                                    <table class='table' style="border: solid 3px rgba(35, 35, 35, 0.1);padding: 1px;margin-bottom: -7px;">
                                        <thead style="background-color:ghostwhite;color: black">
                                        <tr>
                                            <th ><b><?php echo $langu['account_view_order_image'] ?></th>
                                            <th style='text-align: center'><b><?php echo $langu['account_view_order_quantity'] ?></th>
                                            <th><b><?php echo $langu['account_view_order_product_name'] ?></th>
                                            <th><b><?php if($showPrices){ echo $langu['account_view_order_total']; }?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                     <?php

                                     $db = new mysqli('localhost',$username,$password,$database);
                                     if (mysqli_connect_errno()) {
                                         printf("Connect failed: %s\n", mysqli_connect_error());
                                         exit();
                                     }
                                     $db->set_charset("utf8");

                                     $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,Items.short_description,Items.subunits,Order_Item.description FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$resolvedOrderID' AND Order_Item.order_id > 0");
                                     $stm-> execute();
                                     $stm-> bind_result($itemID,$qty,$unitPrice,$vatID,$itemCode,$name,$shortDescription, $subUnits,$description);

                                     $i = 0;
                                     $subTotal=0;
                                     $grandTotal=0;
                                     $vatTotal=0;
                                     while ($stm->fetch()) {
                                         $unitPrice *= $orderCurrencyRate;
                                         $i++;
//                                         if(strcmp($subUnits,'')!=0 && $subUnits > 1){
//                                             $qty = $qty/$subUnits;
//                                         }

                                         $imageUrl = getDefaultImage($itemID);
                                         $price = number_format(floatval($unitPrice),2);

                                         $lineTotal = $unitPrice * $qty;
                                         $subTotal += $lineTotal;
                                         $lineVat = $lineTotal * getVatPercentage($vatID) / 100;
                                         $vatTotal += $lineVat;

                                         if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
                                         {
                                             $name=$shortDescription;
                                         }

                                         $customerID = $_SESSION['customerID'];
                                         if($customerID > 0) {
                                             $name = getCustomerSynonym($customerID,$itemID,'name',$name);
                                             $itemCode = getCustomerSynonym($customerID,$itemID,'code',$itemCode);
                                         }

                                         $name .= " $description";

                                         if($showPrices)
                                         {
                                            $displayLineTotal = $currencySign." ".number_format(floatval($lineTotal),2);

                                            if($showPricesWithVAT){

                                                $inc = $langu['incl_label'];
                                                $vat = $langu['vat_label'];
                                                $displayLineTotalIncVat= "<br><span  style='font-size: 11px;color: #0aa66e '>$currencySign ".number_format(floatval($lineTotal + $lineVat),2)." &nbsp;$inc $vat</span>";

                                                if($includeVatOnPrice){
                                                    $displayLineTotal= $currencySign." ".number_format(floatval($lineTotal + $lineVat),2);
                                                    $displayLineTotalIncVat = '';

                                                }
                                            }
                                         }
                                         else
                                         {
                                            $displayLineTotal = "";
                                         }



                                         echo "
                                        <tr class='itemRow'>
                                            <td class='image'><a class='media-link' href='#'><img style='width:50px;height:50px;' src='$imageUrl' alt='' width='50px' height='50px;'/></a></td>
                                            <td class='quantity' style='text-align: center'>$qty</td>
                                            <td class='description'>
                                                <h4><a href='product-details.php?code=$itemID'>$name</a></h4>
                                                $itemCode
                                            </td>
                                            <td class='total'>$displayLineTotal $displayLineTotalIncVat</td>
                                        </tr>";

                                     }
echo "
                                        </tbody>
                                    </table>
                                </div>";

echo "              
                            <div class='col-md-4 ' id='totalsBox' style='margin-top:5px'>
                                <div class='shopping-cart'>";
                                     if($showPrices) {

                                         $subtotalTitleString = $langu['subtotal_label'];
                                         $vatTitleString = $langu['vat_label'];
                                         $grandTotalTitleString = $langu['grand_total_label'];
                                         $discountTitleString = $langu['discount_label'];
                                     if($includeVatOnPrice){
                                         $hideTotals1 = $hideTotals2 = "style='display:none;'";
                                         $tfoot = '';
                                     } else {
                                         $hideTotals1 = "style='text-align:left;text-transform: capitalize;'";
                                         $hideTotals2 = "style='text-align:right;width:2000px;'";
                                     }

                                         if($discountAmount > 0){
                                             $discountAmountDisplay = number_format(floatval($discountAmount),2);
                                             $discountAmountLabel = "<tr>
                                            <td style='text-align:left;text-transform: capitalize;'>$discountTitleString</td>
                                            <td id='discount' $hideTotals2>$currencySign$discountAmountDisplay</td>
                                        </tr>
                    ";
                                         }

                                    echo "     
                                    <table style='width: 100%;margin-bottom: 3px;'>
                                        <tr>
                                            <td $hideTotals1>$subtotalTitleString</td>
                                            <td id='subtotal' $hideTotals2>$displaySubtotal</td>
                                        </tr>
                                        $discountAmountLabel
                                        <tr>
                                            <td $hideTotals1>$vatTitleString</td>
                                            <td id='vatAmount' $hideTotals2>$displayVatTotal</td>
                                        </tr>
                                        <tfoot>
                                        <tr style='border-bottom: 1px solid grey;'>
                                            <td style='text-align:left;text-transform: capitalize;'>$grandTotalTitleString</td>
                                            <td style='text-align:right;' id='grandTotal'>$displayGrandTotal</td>
                                        </tr>
                                        </tfoot>
                                    </table>";
                                     }

                                     $notesTitleString = $langu['account_view_order_notes'];
                                     $deliveryTitleString = $langu['delivery_method_label'];
                                     $paymentTitleString = $langu['payment_method_label'];
                                     $addressTitleString = $langu['account_view_order_address'];
                                     $reorderLabel = $langu['reorder_label'];

//                                     $details = str_replace("\n","<br>","$details");
                                     $detailsPayment = explode("\nPayment Method:","$details");
                                     $details = $detailsPayment[0];
                                     $paymentMethod = $detailsPayment[1];

                                     $paymentMethodTimeSlots = explode("\nTime Slot:","$paymentMethod");
                                     $paymentMethod = $paymentMethodTimeSlots[0];
                                     $timeSlot = $paymentMethodTimeSlots[1];

                                     if(strcmp($timeSlot,'')!=0){
                                         $timeslotLabel = "<p style='padding-top:0px;margin-bottom: 5px;'><label>Time Slot: </label> <span class='pull-right'>$timeSlot</span> </p>";
                                     }

                                     if($isAnonymousCheckout){
                                         $paymentMethodAndAnonymousCustomer = explode("\nCustomer: ","$paymentMethod");
                                         $paymentMethod = $paymentMethodAndAnonymousCustomer[0];

                                         $addressLine1ANDCustomer = $paymentMethodAndAnonymousCustomer[1];
                                         $addressLine1ANDCustomer = explode("\nAddress: ","$addressLine1ANDCustomer");
                                         $anonymousCustomerName = $addressLine1ANDCustomer[0];

                                         $addressANDContact = $addressLine1ANDCustomer[1];
                                         $addressANDContact = explode("\nPhone: ","$addressANDContact");
                                         $anonymousAddress = $addressANDContact[0];

                                         $anonymousContact = $addressANDContact[1];

                                         $anonymousContact = str_replace("Email: ","",$anonymousContact);
                                         $anonymousContact = str_replace("\n","<br>",$anonymousContact);

                                         $addressLine1 = "$anonymousAddress<br>$anonymousCustomerName<br>$anonymousContact";
                                     }

                                     if($hasBillingAddress){
                                         $billingAddress = "<p style='padding-top:0px;margin-bottom: 5px;'><label>".$langu['account_view_order_billing_address'].": </label> <span class='pull-right' style='text-align: right'>$addressLine1D $addressLine2D</span></p>";
                                     }

                                     $addressLine1 = str_replace("<br>"," ","$addressLine1");
                                     $addressLine2 = str_replace("<br>"," ","$addressLine2");
                                     $dropshipAddress = str_replace("<br>"," ","$dropshipAddress");

                                     echo "  
                                        <p style='padding-top:0px;margin-bottom: 5px;'><label>$deliveryTitleString: </label> <span class='pull-right'>$deliveryMethod</span> </p>

                                        <p style='padding-top:0px;margin-bottom: 5px;'><label>$paymentTitleString: </label> <span class='pull-right'>$paymentMethod</span> </p>
                                        
                                        $timeslotLabel
                                        
                                        $billingAddress

                                        <p style='padding-top:0px;margin-bottom: 5px;border-bottom: 1px solid gray'><label>$addressTitleString: </label> <span class='pull-right' style='text-align: right'>$addressLine1 $addressLine2 $dropshipAddress</span></p>
                                        
                                        
                                        <label>$notesTitleString: </label>  
                                        <p style='padding:3px;border: 1px solid gray;min-height: 80px;'>$details </p>
                                     </div><footer>";
                                     if($resolvedOrderID > 0) {
                                         if (strcmp($dropShip, "yes") == 0) {
                                             echo "";
                                             echo "<form action='./dropShipPrintLabels.php' method='post'  id='labels' name='labels' target='_blank'>
                                                    <input type='hidden' name='orderID' value='$singleOrderID'>
                                                    <input type='hidden' name='orderCode' value='$orderCode'>
                                                    <footer>
                                                    <br>
                                                    <button type='submit' class='btn btn-primary'  ><i class='fa fa-file-text'></i>&nbsp; Print Labels</button>
                                               ";
                                             if (isset($paymentStatus) && $paymentStatus < 1) {
                                                 echo "<button type='button' class='btn btn-success pull-right' data-toggle='modal' data-target='#saveModal' onclick='window.scrollTo(0,0);'><i class='fa fa-money'></i>&nbsp; " . $langu['proceed_with_payment'] . "</button>";
                                             }
                                         } else {

                                             if(isset($paymentStatus) && $paymentStatus < 1){
                                                 echo "<form action='./dbaccess/cancelorder.php' method='post' class='smart-form client-form' id='cancelorderForm' name='cancelorderForm'>
                                                <input type=\"hidden\" name='Cancel' value='$singleOrderID'/>
                                                <br>
                                                <button type='submit' class='btn btn-danger pull-left' ><i class='fa fa-times'></i>&nbsp; ".$langu['cancel_order']."</button>
                                                </form>
                                                <form action='./dbaccess/reorder.php' method='post' class='smart-form client-form' id='reorderForm' name='reorderForm'>
                                                <input type=\"hidden\" name='orderIDToCopy' value='$singleOrderID'/>
                                                <input type=\"hidden\" name='cancelPreviousOrder' id='cancelPreviousOrder' value='yes'/>
                                                <input type=\"hidden\" name='newPaymentMethod' id='newPaymentMethod' value=''/>
                                                </form>";

                                                 echo "<button type='button' class='btn btn-success pull-right' data-toggle='modal' data-target='#saveModal' onclick='window.scrollTo(0,0);'><i class='fa fa-money'></i>&nbsp; ".$langu['proceed_with_payment']."</button>";

                                             } else {
                                                 if(!$isAnonymousCheckout) {
                                                     echo "
                                                         <form action='./dbaccess/reorder.php' method='post' class='smart-form client-form' id='reorderForm' name='reorderForm' style='display: inline-block'>
                                                        <input type=\"hidden\" name='orderIDToCopy' value='$singleOrderID'/>
                                                        <input type=\"hidden\" name='cancelPreviousOrder' id='cancelPreviousOrder' value='no'/>
                                                        <input type=\"hidden\" name='newPaymentMethod' id='newPaymentMethod' value=''/>
                                                        
                                                        
                                                        <br>
                                                        <button type='submit' class='btn btn-primary'>
                                                            <i class='fa fa-refresh'></i> $reorderLabel
                                                        </button>
                                                        </form>";

                                                     if($showPrices){$hidePricesInput = "<input type='hidden' name='prices' value='yes'/>";}
                                                     else{$hidePricesInput = "<input type='hidden' name='prices' value='no'/>";}

                                                     echo "<form  method='POST' action='./dbaccess/printOrderPDF.php' target='_blank' style='display: inline-block;margin-left: 10px;'>
                                                               <input type='hidden' name='orderID' id='orderIDEmail' value='$singleOrderID'/>
                                                               <input type='hidden' name='orderCode' value='$orderCode'/>
                                                               $hidePricesInput
                                                               <input type='hidden' name='download' value='yes'/>
                                                               <button type='submit' class='btn btn-danger' id='printOrderButton' ><i class='fa fa-file-pdf-o'></i>&nbsp; PDF</button>
                                                            </form>";
                                                     echo "<form  method='POST' action='./dbaccess/printOrderPDF.php' target='_blank' style='display: inline-block;margin-left: 10px;'>
                                                               <input type='hidden' name='orderID' id='orderIDEmail' value='$singleOrderID'/>
                                                               <input type='hidden' name='orderCode' value='$orderCode'/>
                                                               $hidePricesInput
                                                               <input type='hidden' name='excel' value='yes'/>
                                                               <input type='hidden' name='barcodes' value='yes'/>
                                                               <button type='submit' class='btn btn-success' id='printOrderButton' ><i class='fa fa-file-excel-o'></i>&nbsp; Excel</button>
                                                            </form>";
                                                 }
                                             }
                                         }




                                     }



                                     echo "
                                        </footer>
                                     </form>
                                   </div>
                                </div>";



?>

                        <div class="overflowed">
                            <a class="btn btn-theme btn-theme-dark" href="./order-history.php" <?php if($isAnonymousCheckout){ echo "style='display:none;'";}?>><?php echo $langu['account_view_order_back_to_orders_button'] ?></a>

                        </div>



                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <footer class="footer">
                <div class="footer-meta">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6" style="margin-top:20px;font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- Modal -->
        <div class="modal fade" id="saveModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;"><i class='fa fa-money'></i><strong style="padding-left:5px;">&nbsp; <?php echo $langu['proceed_with_payment']; ?></strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                        <?php echo $paymentMethodsSelect; ?>
                    </div>


                    <?php

                    if($hasJCC) {
                        $JCCorderID = $orderCode;
                        $captureFlag = "A"; // • A: automatically capture • M: do not automatically capture; will capture manually at a later stage
                        $toEncrypt = $JCCpassword.$JCCmerchantID.$JCCacquirerID.$JCCorderID.$JCCformattedPurchaseAmt.$JCCcurrency;
                        $sha1Signature = sha1($toEncrypt);
                        $base64Sha1Signature = base64_encode(pack("H*",$sha1Signature));
                        $userID=$_SESSION['userID'];
                        $customerID = $_SESSION['customerID'];

                        echo "  <style>
                                    .useCardCheck {text-transform: none;padding-right: 5px;font-size: 17px;color: transparent;}
                                    .cardSelector {border-left: 0px solid white;border-right: 0px solid white;}
                                    .cop-switch {position: relative;display: inline-block;width: 40px;height: 24px;}
                                    .cop-switch input {opacity: 0;width: 0;height: 0;}
                                    .cop-switch-slider { position: absolute;cursor: pointer;top: 0;left: 0;right: 0;bottom: 0;background-color: #ccc;-webkit-transition: .4s;transition: .4s;border-radius: 34px;}
                                    .cop-switch-slider:before {position: absolute;content: '';height: 16px;width: 16px;left: 4px;bottom: 4px;background-color: white;-webkit-transition: .4s;transition: .4s;border-radius: 50%;}
                                    input:checked + .cop-switch-slider {background-color: $themeColor;}
                                    input:focus + .cop-switch-slider {box-shadow: 0 0 1px $themeColor;}
                                    input:checked + .cop-switch-slider:before {-webkit-transform: translateX(16px);-ms-transform: translateX(16px);transform: translateX(16px);}
                                </style> ";

                        echo "    <div class='form-group' style='margin-top:10px;'>
                          <form method='post' name='paymentFormJCC' id='paymentFormJCC' action='$JCCFormURL' >";
                        if($JccSaveCardsFeature) {
                            echo "<div class='modal-footer' style='margin-top:5px;padding-top:25px;' id='cardSelectionTable'>      
                <table style='width: 100%;background-color: ghostwhite;border-spacing: 0 2px;border: 2px solid whitesmoke;display: block' class='pull-right' >";
                            $cardsResult = '';
                            $saveCardLabel = $langu['save_card_label'];
                            $newCardLabel = $langu['new_card_label'];
                            $removeLabel = $langu['remove_label'];
                            $payWithLabel = $langu['pay_with_label'];
                            $cardsCounter=0;
                            $db->set_charset("utf8");
                            $stm = $db->prepare("SELECT padded_card_number,hash_value FROM B2B_User_Cards WHERE customer_id='$customerID' AND user_id='$userID'");
                            $stm->execute();
                            $stm->bind_result($paddedCardNumber, $hashValue);
                            while ($stm->fetch()) {
                                $firstDigit = substr($paddedCardNumber, 0, 1);
                                $paddedCardNumber = str_replace('X', '*', $paddedCardNumber);
                                switch ($firstDigit) {
                                    case '3':
                                        $cardBrandIcon = 'american-express-icon.png';
                                        break;
                                    case '4':
                                        $cardBrandIcon = 'visa-card-icon.png';
                                        break;
                                    case '5':
                                        $cardBrandIcon = 'master-card-icon.png';
                                        break;
                                    default:
                                        $cardBrandIcon = 'generic-card-icon.png';
                                }
                                $cardsCounter++;
                                $cardsResult .= "<tr class='cardSelector' id='cardSelector$cardsCounter' style='background-color: white;cursor: pointer'>
                                <td style='width: 1%;' onclick='selectCard(this,\"$hashValue\");'>
                                    <img src='./assets/img/$cardBrandIcon' width='auto' height='40'>
                                </td>
                                <td style='text-align: left;text-transform:none;font-size: 12px;' onclick='selectCard(this,\"$hashValue\");'>
                                    $paddedCardNumber
                                    <span class='useCardCheck' style='margin: 0px;font-size: 11px;' ><i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                                </td>
                                <td style='width: 30%;'>
                                    <div class='useCardCheck pull-right' style='margin: 0px;font-size: 13px;' ><i class='fa fa-trash-o' style='color: firebrick;' onclick='removeJccCard(this,\"$hashValue\",$customerID,$userID);'> $removeLabel</i></div>
                                </td>
                             </tr>";
                            }
                            $stm->close();
                            echo  "<tr><td colspan='3' style='text-align: left;text-transform:none;'><h3 style='text-transform: capitalize;margin: 0px;width: auto;'> $payWithLabel:</h3></td></tr>";
                            echo  "$cardsResult";
                            echo  "<tr class='cardSelector' id='cardSelector0' style='cursor: pointer'>
                        <td style='width: 1%;'  onclick='selectCard(this,\"\");'><img src='./assets/img/generic-card-icon.png' width='auto' height='40'></i></td>
                        <td style='text-align: left;text-transform:none;font-size: 13px;' colspan='3' onclick='selectCard(this,\"\");'>
                            <span class='pull-left selectCardLabel' style='margin: 0px;font-size: 13px;' >$newCardLabel</span>
                            <span class='pull-left useCardCheck' style='display: inline-block'>&nbsp;&nbsp; $newCardLabel <i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                            <span class='pull-right useCardCheck' style='display: inline-block'>
                                <span style='padding-top:5px;font-size: 13px;'>$saveCardLabel</span>
                                <label class='cop-switch' style='padding:5px;margin-right: 2px;'>
                                    <input type='checkbox'  id='saveCardCheckbox'>            
                                    <span class='cop-switch-slider'></span>
                                </label>
                            </span>
                        </td>
                    </tr>
                </table>
                </div>";
                        }
                        echo "<script>
                                
                                $('#cardSelector$cardsCounter').children('td:first').click();
                                
                                function removeJccCard(element,value,cid,uid){
                                    removeCardJCC(value,cid,uid);
                                    $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"D\" />');
                                    $('#MerRespURL').val('https://" . HTML_PATH . "/cop/b2b/dbaccess/JCCRedirect.php?removeCard=y&urds=$userID');
                                    document.forms[\"paymentFormJCC\"].submit();
                                    $('#checkoutContainer').empty();
                                    $('#checkoutContainer').append('<div id=\"preloader\"><div id=\"preloader-status\"><div class=\"spinner\"><div class=\"rect1\"></div><div class=\"rect2\"></div><div class=\"rect3\"></div><div class=\"rect4\"></div><div class=\"rect5\"></div></div><div id=\"preloader-title\">$removeLabel</div></div>');
                                    
                                    
                                }
                                
                                function selectCard(td,hashValue){
                                    var tr = $(td).closest('tr');
                                    $(\".cardSelector\").css(\"border-color\",\"ghostwhite\");
                                    $(\".cardSelector\").css(\"background-color\",\"white\");
                                    $(\".cardSelector\").css(\"font-weight\",\"\");
                                    $(\".useCardCheck\").css(\"color\",\"transparent\").hide();
                                    $(\".selectCardLabel\").show();
                                    $(tr).css(\"border-color\",\"lightgray\");
                                    $(tr).css(\"background-color\",\"ghostwhite\");
                                    $(tr).css(\"font-weight\",\"bolder\");
                                    $(tr).find(\".useCardCheck\").css(\"color\",\"$themeColor\").show();
                                    $(tr).find(\".selectCardLabel\").hide();
                                    
                                    if(hashValue.localeCompare('')!=0){
                                        $('#saveCardCheckbox').prop('checked', false);
                                        $('#paymentFormJCC').attr('action', '$JCCDirectFormURL');
                                        $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"H\" /><br><input type=\"hidden\" name=\"hashValue\" value=\"'+hashValue+'\">');
                                        
                                    } else {
                                        $('#paymentFormJCC').attr('action', '$JCCFormURL');
                                        $('#saveCardInput').html('');
                                    }
                                    
                                }
                            </script>
                            <input type='hidden' name='Version' value='1.0.0'>
                            <input type='hidden' name='MerID' value='$JCCmerchantID'>
                            <input type='hidden' name='AcqID' value='$JCCacquirerID'>
                            <input type='hidden' name='MerRespURL' value='https://".HTML_PATH."/cop/b2b/dbaccess/JCCRedirect.php?urds=$userID&existing=1'>
                            <input type='hidden' name='PurchaseAmt' id='JCCPurchaseAmt' value='$JCCformattedPurchaseAmt'>
                            <input type='hidden' name='PurchaseCurrency' value='$JCCcurrency'>
                            <input type='hidden' name='PurchaseCurrencyExponent' value='2'>
                            <input type='hidden' name='OrderID' id='JCCOrderID' value='$JCCorderID'> 
                            <input type='hidden' name='CaptureFlag' value='$captureFlag'> 
                            <input type='hidden' name='Signature' id='JCCSignature' value='$base64Sha1Signature'>
                            <input type='hidden' name='SignatureMethod' value='SHA1'>
                            <div id='saveCardInput'></div>
                          </form> 
                          <script>
                            $('#saveCardCheckbox').change(function() {
                                if(this.checked) {
                                    $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"R\" />');
                                } else {
                                    $('#saveCardInput').html('');
                                }
                            });
                          </script>
                      </div>";
                    }
                    ?>



                    <footer class="modal-footer" >
                        <button onclick="$('#saveModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;"><?php echo $langu['close_label'];?></button>
                        <button id="payNowButton" onclick="payOrder();" class="btn btn-success" style="display: none;"></button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->

        <!-- Modal -->
        <div class="modal fade" id="paymentStatusModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;"><strong style="padding-left:5px;">&nbsp;</strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                        <center><br><br>
                        <?php
                        if(isset($_POST['p']) && $_POST['p'] < 0){
                            $methodName = $_POST['methodLabel'];
                            echo "<h4 style=\"color:black\"><b></b><b style=\"color:firebrick\">Something went wrong with $methodName payment method.<br>Please select other payment method or contact us.</b></h4>";
                        } else if(isset($paymentStatus) && $paymentStatus < 1){
                            echo "<h4 style=\"color:black\"><b></b><b style=\"color:firebrick\">$orderStatus</b></h4>";
                        } else if(isset($paymentStatus) && $paymentStatus == 1){
                            echo "<h4 style=\"color:black\"><b></b><b style=\"color:green\">".$langu['place_order_message']."</b></h4>";
                        } else {
                            echo "<h4 style=\"color:black\"><b>".$langu['account_order_status'].": </b><b style=\"color:black\">$orderStatus</b></h4>";
                        }
                        ?>
                        </center><br><br>
                    </div>

                    <footer class="modal-footer" >
                        <button onclick="$('#paymentStatusModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;"><?php echo $langu['close_label'];?></button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->




        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

        <script src="assets/js/waitMe.min.js"></script>

        <script type="text/javascript">
            jQuery(document).ready(function () {

                initThemeParameters();

                <?php
                if($fromPayment){
                    echo "$('#paymentStatusModal').modal('toggle');";
                }?>
            });



            function payOrder() {
                switch ($('#paymentMethod option:selected').data('method')) {
                    case 'JCC':
                        document.forms["paymentFormJCC"].submit();
                        break;
                    case "VIVA":
                        window.location.href="./dbaccess/createPaymentOrderVIVA.php?oid=<?php echo $orderCode?>";
                        break;
                    case 'PAYPAL':
                        window.location.href="./payPaypalOrder.php?p=0&oid=<?php echo $orderCode?>";
                        break;
                    case 'STRIPE':
                        window.location.href="./stripe/stripeCheckout.php?p=0&oid=<?php echo $orderCode?>";
                        break;
                    case 'SIX':
                        window.location.href="./dbaccess/createPaymentOrderSIX.php?oid=<?php echo $orderCode?>";
                        break;
                    case 'JCC_V2':
                        window.location.href="./dbaccess/createPaymentOrderJCCv2.php?oid=<?php echo $orderCode?>";
                        break;
                    default:
                        var isCredit = $('#paymentMethod option:selected').data('iscredit');

                        if(isCredit.localeCompare('yes')==0){
                            $('#cancelPreviousOrder').val('yes');
                            $('#newPaymentMethod').val($('#paymentMethod option:selected').val());
                            document.forms["reorderForm"].submit();

                        }

                }
            }


        </script>

    </body>
</html>