<?php

session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("./login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");

$fromPayment=false;
if(isset($_GET['p']) && isset($_GET['oid'])){
    $paymentOrderCode = $_GET['oid'];
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT order_id FROM Orders WHERE order_code = '$paymentOrderCode' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($singleOrderID);

    while ($stm->fetch()) {}
    $stm-> close();

    $paymentStatus = $_GET['p'];

    $fromPayment=false;

}

include_once("headerImports.php");
$showPrices=true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$isAnonymousCheckout=false;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices,show_prices_with_vat,css_theme,drop_ship,anonymous_checkout,anonymous_checkout_customer_id FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$showPricesIncludingVAT,$cssTheme,$dropShip,$anonymous_checkout,$anonymous_checkout_customer_id);

while ($stm->fetch()) {

    if(strcmp($anonymous_checkout,"yes")==0 || $_SESSION['customerID']==$anonymous_checkout_customer_id)
    {
        $isAnonymousCheckout=true;
    }

    if(strcmp($showPrices,"no")==0 || $_SESSION['showPrices']==false)
    {
        $showPrices=false;
    }

    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();
$stm = $db->prepare("SELECT order_id,order_code,order_date,delivery_date,subtotal,vat_amount,grand_total,details,order_address_id,status,delivery_method FROM Orders WHERE Orders.order_id='$singleOrderID' AND customer_id='".$_SESSION['customerID']."' AND NOT status='Canceled' AND NOT status='Placed'");
$stm-> execute();
$stm-> bind_result($resolvedOrderID,$orderCode,$orderDate,$deliveryDate,$subtotal,$vatAmount,$grandTotal,$details,$orderAddressID,$orderStatus,$deliveryMethod);
while ($stm->fetch()) {

    $displaySubTotal = "".number_format(floatval($subtotal),2);
    $displayVatTotal = "".number_format(floatval($vatAmount),2);
    $displayGrandTotal = "".number_format(floatval($grandTotal),2);
    if(strpos($orderStatus,'Payment Pending') !== false){$paymentStatus = 0;}
    else if(strpos($orderStatus,'Placed') !== false){$paymentStatus = 1;}


}

$stm-> close();

if(strcmp($dropShip,'yes')==0){
    $stm = $db->prepare("SELECT to_address_line_1,label_1,received_amount FROM B2B_Dropship_Orders_Extra WHERE order_id='$singleOrderID' AND customer_id='".$_SESSION['customerID']."'");
    $stm-> execute();
    $stm-> bind_result($dropshipAddressLine1,$recepientName,$freightCollect);
    while ($stm->fetch()) {}
    $stm-> close();
    if(strcmp($recepientName,'')!=0){
        $recepient ="$recepientName, <br>";
    }
    $dropshipAddress = "</p><label>RECIPIENT: </label><p style='padding-top:10px;'>$recepient $dropshipAddressLine1 ";

    if($freightCollect > 0){
        $freightCollect = number_format(floatval($freightCollect),2);
        $dropshipAddress .="</p> <label>FREIGHT COLLECTION: </label><p style='padding-top:10px;'> $freightCollect </p>";

    }
}

$stm = $db->prepare("SELECT address_line_1,address_line_2 FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
$stm->execute();
$stm->bind_result($addressLine1, $addressLine2);

while ($stm->fetch()) {

}
$stm->close();
$AlternativePaymentMethodName = $langu['other_payment_methods'];
$hasCreditMethods = false;
$hasJCC = false;
$db->set_charset("utf8");
$stm = $db->prepare("SELECT payment_method_id,payment_method_code,name,logo,allow_credit,merchant_id,acquirer_id,currency_iso_code,password,post_url,saving_cards FROM B2C_Payment_Methods WHERE active='yes' ORDER BY B2C_Payment_Methods.position ASC ");
$stm-> execute();
$stm-> bind_result($paymentMethodID,$paymentMethodCode,$paymentMethodName,$paymentMethodLogo,$allowCredit,$merchantID,$acquirerID,$currencyISO, $paymentMethodPass,$paymentMethodFormURL,$savingCards);
while ($stm->fetch()) {

    switch ($paymentMethodCode){
        case "JCC":
            $JccSaveCardsFeature = false;
            if(strcmp($savingCards,'yes')==0){
                $JccSaveCardsFeature = true;
            }
            $hasJCC = true;
            $JCCmerchantID = $merchantID;
            $JCCpassword = $paymentMethodPass;
            $JCCacquirerID = $acquirerID;
            $JCCcurrency = $currencyISO;
            $JCCFormURL = $paymentMethodFormURL;
            $JCCDirectFormURL = str_replace('RedirectAuthLink','DirectAuthLink',$JCCFormURL);
            $payButtonFunction = "placeOrder();";
            $grandTotal = number_format(floatval($grandTotal), 2, '.', '');
            $JCCformattedPurchaseAmt = str_pad(str_replace('.','',$grandTotal), 12, '0', STR_PAD_LEFT);
            break;
    }
    if(strcmp($paymentMethodLogo,'')!=0 && file_exists(ROOT."b2b/assets/img/$paymentMethodLogo")){
        $paymentMethodLogo =  "./assets/img/$paymentMethodLogo";
    } else {
        $paymentMethodLogo =  "./assets/img/paymenticon.png";
    }
    if(strcmp($allowCredit,'yes')!=0) {
        $paymentMethods .= "<option value='$paymentMethodID' data-logo='$paymentMethodLogo' data-iscredit='$allowCredit' data-method='$paymentMethodCode'>  $paymentMethodName </option>";
    } else {
        $hasCreditMethods = true;
    }

}
if($hasCreditMethods && !$isAnonymousCheckout) {
    $paymentMethods .= "<option value='0' data-logo='./assets/img/paymenticon.png' data-iscredit='yes' data-method='OTHER' data-iscredit='yes'>  $AlternativePaymentMethodName </option>";
}
$stm->close();
$paymentMethodLabel = $langu['payment_method_label'];
$paymentMethodsSelect = "         <center>
                                  <div style='height: 100px;width: 90%' >
                                  <h3>$paymentMethodLabel</h3>
                                  <select class='form-control'  id='paymentMethod' name='paymentMethod' style='width: 79%;display: inline-block;background-image:linear-gradient(45deg, transparent 50%, gray 50%),linear-gradient(135deg, gray 50%, transparent 50%),linear-gradient(to right, #ccc, #ccc);background-position:calc(100% - 20px) calc(1em + 2px),calc(100% - 15px) calc(1em + 2px),calc(100% - 2.5em) 0.5em;background-size:5px 5px,5px 5px,1px 1.5em;background-repeat: no-repeat;' >
                                     $paymentMethods
                                  </select>
                                  <img  id='paymentMethodLogo' class='form-control' height='auto' style='padding:0px;display: inline-block;width: 19%;' >
                                  </div>
                                  </center>
                                  <script type='text/javascript'>
                                        jQuery(document).ready(function () {
                                            $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo'));
                                            var code = $('#paymentMethod :selected').data('method');
                                            $('#payNowButton').html('".$langu['proceed_with_label']." ').show();
                                            
                                            $('#paymentMethod').on('change', function() {
                                                
                                                $('#paymentMethodLogo').attr('src',$('#paymentMethod :selected').data('logo')); 
                                                
                                                $('#payNowButton').html('".$langu['proceed_with_label']." ').show();
                                                
                                                var code = $('#paymentMethod :selected').data('method');

                                                if(code.localeCompare('JCC') === 0){
                                                    $('#withJCCDirect').show();
                                                    $('#cardSelectionTable').show();
                                                } else {
                                                    $('#withJCCDirect').hide();
                                                    $('#cardSelectionTable').hide();
                                                }
                                                

                                            });
                                        });
                                        
                                  </script>";


$orderDate = date_format( date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');
$deliveryDate = date_format( date_create_from_format('Y-m-d', $deliveryDate), 'd-m-Y');



$db->set_charset("utf8");
$stm = $db->prepare("SELECT currency_iso_code,merchant_id FROM B2C_Payment_Methods WHERE payment_method_code = 'PAYPAL' LIMIT 1");
$stm->bind_result($isoCode,$paypalClientID);
$stm->execute();
while ($stm->fetch()) {}
$stm->close();
if((int)$isoCode > 0){
    $paypalCurrencyCode = getCurrencyCodeFromISO($isoCode);
}


function getCurrencyCodeFromISO($isoCode){

    $array = array('EUR'=>'978','AFN'=>'971','ALL'=>'8','DZD'=>'12','AOA'=>'973','ARS'=>'32','AMD'=>'51','AWG'=>'533','AZN'=>'944','BSD'=>'44','BHD'=>'48','BDT'=>'50','BBD'=>'52','BYN'=>'933','BZD'=>'84','BMD'=>'60','BTN'=>'64','BOB'=>'68','BOV'=>'984','BAM'=>'977','BWP'=>'72','BRL'=>'986','BND'=>'96','BGN'=>'975','BIF'=>'108','CVE'=>'132','KHR'=>'116','CAD'=>'124','KYD'=>'136','CLF'=>'990','CLP'=>'152','CNY'=>'156','COP'=>'170','COU'=>'970','KMF'=>'174','CDF'=>'976','CRC'=>'188','HRK'=>'191','CUC'=>'931','CUP'=>'192','CZK'=>'203','DJF'=>'262','DOP'=>'214','EGP'=>'818','SVC'=>'222','ERN'=>'232','ETB'=>'230','FKP'=>'238','FJD'=>'242','XAF'=>'950','GMD'=>'270','GEL'=>'981','GHS'=>'936','GIP'=>'292','DKK'=>'208','GTQ'=>'320','GNF'=>'324','GYD'=>'328','HTG'=>'332','HNL'=>'340','HKD'=>'344','HUF'=>'348','ISK'=>'352','INR'=>'356','IDR'=>'360','XDR'=>'960','IRR'=>'364','IQD'=>'368','ILS'=>'376','JMD'=>'388','JPY'=>'392','JOD'=>'400','KZT'=>'398','KES'=>'404','KPW'=>'408','KRW'=>'410','KWD'=>'414','KGS'=>'417','LAK'=>'418','LBP'=>'422','LSL'=>'426','LRD'=>'430','LYD'=>'434','MOP'=>'446','MGA'=>'969','MWK'=>'454','MYR'=>'458','MVR'=>'462','MRU'=>'929','MUR'=>'480','XUA'=>'965','MXN'=>'484','MXV'=>'979','MDL'=>'498','MNT'=>'496','MZN'=>'943','MMK'=>'104','NAD'=>'516','NPR'=>'524','NIO'=>'558','NGN'=>'566','OMR'=>'512','PKR'=>'586','PAB'=>'590','PGK'=>'598','PYG'=>'600','PEN'=>'604','PHP'=>'608','PLN'=>'985','QAR'=>'634','MKD'=>'807','RON'=>'946','RUB'=>'643','RWF'=>'646','SHP'=>'654','XCD'=>'951','WST'=>'882','STN'=>'930','SAR'=>'682','RSD'=>'941','SCR'=>'690','SLL'=>'694','SGD'=>'702','ANG'=>'532','XSU'=>'994','SBD'=>'90','SOS'=>'706','ZAR'=>'710','SSP'=>'728','LKR'=>'144','SDG'=>'938','SRD'=>'968','NOK'=>'578','SZL'=>'748','SEK'=>'752','CHE'=>'947','CHF'=>'756','CHW'=>'948','SYP'=>'760','TWD'=>'901','TJS'=>'972','TZS'=>'834','THB'=>'764','XOF'=>'952','NZD'=>'554','TOP'=>'776','TTD'=>'780','TND'=>'788','TRY'=>'949','TMT'=>'934','AUD'=>'36','UGX'=>'800','UAH'=>'980','AED'=>'784','GBP'=>'826','USN'=>'997','UYI'=>'940','UYU'=>'858','UZS'=>'860','VUV'=>'548','VEF'=>'937','VED'=>'926','VND'=>'704','USD'=>'840','XPF'=>'953','MAD'=>'504','YER'=>'886','ZMW'=>'967','ZWL'=>'932');
    $result = array_search ((int)$isoCode, $array);
    return "$result";
}



?>

<body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div id='cartItems' class="container">

                    </div>
                </div>
            </div>

            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
                <?php
                $topmenu = "topMenuCheckout$cssTheme.php";

                if(strcmp($topmenu,"topMenuCheckout2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenuCheckout.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area">

                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container" id="checkoutContainer">
                        <h3 class="block-title alt" style="margin-bottom: 7px;"><i class="fa fa-angle-down"></i><?php echo $langu['account_view_order_information_title'] ?></h3>
                        <div id="checkoutCartContainer">
                            <br>
                            <div class='row orders block'>
                                <div class='col-md-5 ' id='totalsBox' style='margin-top:5px;'>
                                    <?php
                                    if($singleOrderID > 0){
                                        echo '<br><div id="paypal-button-container"></div>';
                                        echo '<input type="hidden" id="paypalOrder">';
                                        echo "<center>";


                                        echo "<form action='./dbaccess/reorder.php' method='post' style='margin: 0;padding: 0;' id='reorderForm' name='reorderForm'>
                                                <input type=\"hidden\" name='orderIDToCopy' value='$singleOrderID'/>
                                                <input type=\"hidden\" name='cancelPreviousOrder' id='cancelPreviousOrder' value='yes'/>
                                                <input type=\"hidden\" name='newPaymentMethod' id='newPaymentMethod' value=''/>
                                                <button type='submit' class='btn btn-theme btn-block' style='max-width: 100%;border-radius: 4px;text-transform: none;margin-bottom: 14px;font-size: 18px;font-weight: unset'><i class='fa fa-pencil-square-o' style='font-size: 22px;'></i>&nbsp;".$langu['edit_order']."</button>
                                                
                                              </form>";

                                        echo "<form action='./dbaccess/cancelorder.php' method='post' style='margin: 0;padding: 0;' id='cancelorderForm' name='cancelorderForm'>
                                                <input type=\"hidden\" name='Cancel' value='$singleOrderID'/>
                                                <button type='submit' class='btn btn-theme btn-block btn-theme-transparent' style='max-width: 100%;border-radius: 4px;text-transform: none;margin-bottom: 14px;font-size: 18px;'><i class='fa fa-times' style='font-size: 22px;'></i>&nbsp;".$langu['cancel_order']."</button>
                                              </form>";

                                    }
                                    ?>
                                </div>
                                <div class='col-md-7'  style="margin-top:5px;">

                                        <div class="shopping-cart" style="padding: 1px;">
                                            <?php
                                            $notesTitleString = $langu['account_view_order_notes'];
                                            $deliveryTitleString = $langu['delivery_method_label'];
                                            $paymentTitleString = $langu['payment_method_label'];
                                            $addressTitleString = $langu['account_view_order_address'];
                                            $reorderLabel = $langu['reorder_label'];

                                            //                                     $details = str_replace("\n","<br>","$details");
                                            $detailsPayment = explode("Payment Method:","$details");
                                            $details = $detailsPayment[0];
                                            $paymentMethod = $detailsPayment[1];

                                            if($isAnonymousCheckout){
                                                $paymentMethodAndAnonymousCustomer = explode("\nCustomer: ","$paymentMethod");
                                                $paymentMethod = $paymentMethodAndAnonymousCustomer[0];

                                                $addressLine1ANDCustomer = $paymentMethodAndAnonymousCustomer[1];
                                                $addressLine1ANDCustomer = explode("\nAddress: ","$addressLine1ANDCustomer");
                                                $anonymousCustomerName = $addressLine1ANDCustomer[0];

                                                $addressANDContact = $addressLine1ANDCustomer[1];
                                                $addressANDContact = explode("\nPhone: ","$addressANDContact");
                                                $anonymousAddress = $addressANDContact[0];

                                                $anonymousContact = $addressANDContact[1];

                                                $anonymousContact = str_replace("Email: ","",$anonymousContact);
                                                $anonymousContact = str_replace("\n","<br>",$anonymousContact);

                                                $addressLine1 = "$anonymousAddress<br>$anonymousCustomerName<br>$anonymousContact";
                                            }
                                            echo"
                                            <p style='padding-left:8px;padding-right:8px;margin: 0px;'><label style='text-transform: none !important;margin: 0;font-size: 14px;'>".$langu['account_view_order_code'].": </label> <span class='pull-right'>$orderCode</span> </p>
                                            <p style='padding-left:8px;padding-right:8px;margin: 0px;'><label style='text-transform: none !important;margin: 0;font-size: 14px;'>".$langu['account_view_order_date'].": </label> <span class='pull-right'>$orderDate</span> </p>
                                            <p style='padding-left:8px;padding-right:8px;margin: 0px;'><label style='text-transform: none !important;margin: 0;font-size: 14px;'>".$langu['account_view_order_delivery_date'].": </label> <span class='pull-right'>$deliveryDate</span> </p>
                                            <p style='padding-left:8px;padding-right:8px;margin: 0px;'><label style='text-transform: none !important;margin: 0;font-size: 14px;'>$deliveryTitleString: </label> <span class='pull-right'>$deliveryMethod</span> </p>
                                            <p style='padding-left:8px;padding-right:8px;margin: 0px;'><label style='text-transform: none !important;margin: 0;font-size: 14px;'>$addressTitleString: </label> <span class='pull-right' style='text-align: right'>$addressLine1 $addressLine2 $dropshipAddress</span></p>
                                            
                                      
                                            ";
                                            ?>


                                        <table class='table' style="border: solid 2px rgba(35, 35, 35, 0.1);border-left:0;border-right:0;padding: 3px;margin: 0;">
                                        <thead style="background-color:ghostwhite;color: black">
                                        <tr>
                                            <th style='padding: 5px;text-align: center;font-size: 13px;'><b><?php echo $langu['account_view_order_quantity'] ?></th>
                                            <th style='padding: 5px;text-align: left;font-size: 13px;'><b><?php echo $langu['account_view_order_product_name'] ?></th>
                                            <th style="padding: 5px;text-align: right;font-size: 13px;padding-right:8px;"><b><?php if($showPrices){ echo $langu['account_view_order_total']; }?></th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                     <?php

                                     $db = new mysqli('localhost',$username,$password,$database);
                                     if (mysqli_connect_errno()) {
                                         printf("Connect failed: %s\n", mysqli_connect_error());
                                         exit();
                                     }
                                     $db->set_charset("utf8");

                                     $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,Items.item_code,Items.name,Items.short_description,Items.subunits FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$resolvedOrderID' AND Order_Item.order_id > 0");
                                     $stm-> execute();
                                     $stm-> bind_result($itemID,$qty,$unitPrice,$vatID,$itemCode,$name,$shortDescription, $subUnits);

                                     $i = 0;
                                     $subTotal=0;
                                     $grandTotal=0;
                                     $vatTotal=0;
                                     while ($stm->fetch()) {
                                         $i++;

                                         $imageUrl = getDefaultImage($itemID);
                                         $price = number_format(floatval($unitPrice),2);

                                         $lineTotal = $unitPrice * $qty;
                                         $subTotal += $lineTotal;
                                         $lineVat = $lineTotal * getVatPercentage($vatID) / 100;
                                         $vatTotal += $lineVat;

                                         if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 )
                                         {
                                             $name=$shortDescription;
                                         }

                                         if($showPrices)
                                         {
                                            $displayLineTotal = "".number_format(floatval($lineTotal),2);

                                            if($showPricesWithVAT){

                                                $inc = $langu['incl_label'];
                                                $vat = $langu['vat_label'];
                                                $displayLineTotalIncVat= "<br><span  style='font-size: 11px;color: #0aa66e '>".number_format(floatval($lineTotal + $lineVat),2)." &nbsp;$inc $vat</span>";

                                                if($includeVatOnPrice){
                                                    $displayLineTotal= "".number_format(floatval($lineTotal + $lineVat),2);
                                                    $displayLineTotalIncVat = '';

                                                }
                                            }
                                         }
                                         else
                                         {
                                            $displayLineTotal = "";
                                         }



                                         echo "
                                        <tr class='itemRow'>
                                            <td  style='text-align: center;font-size: 13px;width: 3%'>$qty</td>
                                            <td  style='text-align: left;font-size: 13px;'>$name</td>
                                            <td  style='text-align: right;font-size: 13px;padding-left:8px;padding-right:8px;margin: 0px;width: 3%'>$displayLineTotal $displayLineTotalIncVat</td>
                                        </tr>";

                                     }
                                     ?>

                                        </tbody>
                                    </table>


                                        <?php

                                        if($showPrices) {

                                            $subtotalTitleString = $langu['subtotal_label'];
                                            $vatTitleString = $langu['vat_label'];
                                            $grandTotalTitleString = $langu['grand_total_label'];
                                            if($includeVatOnPrice){
                                                $hideTotals1 = $hideTotals2 = "style='display:none;'";
                                                $tfoot = '';
                                            } else {
                                                $hideTotals1 = "style='text-align:left;text-transform: capitalize;padding-left:8px;padding-right:8px;margin: 0px;'";
                                                $hideTotals2 = "style='text-align:right;width:2000px;padding-left:8px;padding-right:8px;margin: 0px;'";
                                            }
                                            $displaySubTotal = "".number_format(floatval($subtotal),2);

                                            echo "     
                                    <table style='width: 100%;margin-bottom: 3px;'>
                                        <tr>
                                            <td $hideTotals1>$subtotalTitleString</td>
                                            <td id='subtotal' $hideTotals2>$displaySubTotal</td>
                                        </tr>
                                        <tr>
                                            <td $hideTotals1>$vatTitleString</td>
                                            <td id='vatAmount' $hideTotals2>$displayVatTotal</td>
                                        </tr>
                                        <tfoot>
                                        <tr style='border-bottom: 1px solid grey;background-color:ghostwhite;'>
                                            <td style='text-align:left;text-transform: capitalize;padding-left:8px;padding-right:8px;margin: 0px;'>$grandTotalTitleString</td>
                                            <td style='text-align:right;padding-left:8px;padding-right:8px;margin: 0px;' id='grandTotal'>$displayGrandTotal</td>
                                        </tr>
                                        </tfoot>
                                    </table>";
                                        }



                                        echo "  
                                        <label style='text-transform: none !important;padding-left:8px;padding-right:8px;font-size: 13px;'>$notesTitleString: </label>  
                                        <p style='padding:3px;border: 1px solid silver;min-height: 50px;margin: 8px;margin-top:0;'>$details </p>
                                        ";

;



                                        ?>
                                        </div>
                                </div>
                            </div>



                        <div class="overflowed">
                            <!--<a class="btn btn-theme btn-theme-dark" href="./order-history.php" <?php if($isAnonymousCheckout){ echo "style='display:none;'";}?>><?php echo $langu['account_view_order_back_to_orders_button'] ?></a>-->

                        </div>



                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <footer class="footer">
                <div class="footer-meta">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6" style="margin-top:20px;font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- Modal -->
        <div class="modal fade" id="saveModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;"><i class='fa fa-money'></i><strong style="padding-left:5px;">&nbsp; <?php echo $langu['proceed_with_payment']; ?></strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                        <?php echo $paymentMethodsSelect; ?>
                    </div>


                    <?php

                    if($hasJCC) {
                        $JCCorderID = $orderCode;
                        $captureFlag = "A"; // • A: automatically capture • M: do not automatically capture; will capture manually at a later stage
                        $toEncrypt = $JCCpassword.$JCCmerchantID.$JCCacquirerID.$JCCorderID.$JCCformattedPurchaseAmt.$JCCcurrency;
                        $sha1Signature = sha1($toEncrypt);
                        $base64Sha1Signature = base64_encode(pack("H*",$sha1Signature));
                        $userID=$_SESSION['userID'];
                        $customerID = $_SESSION['customerID'];

                        echo "  <style>
                                    .useCardCheck {text-transform: none;padding-right: 5px;font-size: 17px;color: transparent;}
                                    .cardSelector {border-left: 0px solid white;border-right: 0px solid white;}
                                    .cop-switch {position: relative;display: inline-block;width: 40px;height: 24px;}
                                    .cop-switch input {opacity: 0;width: 0;height: 0;}
                                    .cop-switch-slider { position: absolute;cursor: pointer;top: 0;left: 0;right: 0;bottom: 0;background-color: #ccc;-webkit-transition: .4s;transition: .4s;border-radius: 34px;}
                                    .cop-switch-slider:before {position: absolute;content: '';height: 16px;width: 16px;left: 4px;bottom: 4px;background-color: white;-webkit-transition: .4s;transition: .4s;border-radius: 50%;}
                                    input:checked + .cop-switch-slider {background-color: $themeColor;}
                                    input:focus + .cop-switch-slider {box-shadow: 0 0 1px $themeColor;}
                                    input:checked + .cop-switch-slider:before {-webkit-transform: translateX(16px);-ms-transform: translateX(16px);transform: translateX(16px);}
                                </style> ";

                        echo "    <div class='form-group' style='margin-top:10px;'>
                          <form method='post' name='paymentFormJCC' id='paymentFormJCC' action='$JCCFormURL' >";
                        if($JccSaveCardsFeature) {
                            echo "<div class='modal-footer' style='margin-top:5px;padding-top:25px;' id='cardSelectionTable'>      
                <table style='width: 100%;background-color: ghostwhite;border-spacing: 0 2px;border: 2px solid whitesmoke;display: block' class='pull-right' >";
                            $cardsResult = '';
                            $saveCardLabel = $langu['save_card_label'];
                            $newCardLabel = $langu['new_card_label'];
                            $removeLabel = $langu['remove_label'];
                            $payWithLabel = $langu['pay_with_label'];
                            $cardsCounter=0;
                            $db->set_charset("utf8");
                            $stm = $db->prepare("SELECT padded_card_number,hash_value FROM B2B_User_Cards WHERE customer_id='$customerID' AND user_id='$userID'");
                            $stm->execute();
                            $stm->bind_result($paddedCardNumber, $hashValue);
                            while ($stm->fetch()) {
                                $firstDigit = substr($paddedCardNumber, 0, 1);
                                $paddedCardNumber = str_replace('X', '*', $paddedCardNumber);
                                switch ($firstDigit) {
                                    case '3':
                                        $cardBrandIcon = 'american-express-icon.png';
                                        break;
                                    case '4':
                                        $cardBrandIcon = 'visa-card-icon.png';
                                        break;
                                    case '5':
                                        $cardBrandIcon = 'master-card-icon.png';
                                        break;
                                    default:
                                        $cardBrandIcon = 'generic-card-icon.png';
                                }
                                $cardsCounter++;
                                $cardsResult .= "<tr class='cardSelector' id='cardSelector$cardsCounter' style='background-color: white;cursor: pointer'>
                                <td style='width: 1%;' onclick='selectCard(this,\"$hashValue\");'>
                                    <img src='./assets/img/$cardBrandIcon' width='auto' height='40'>
                                </td>
                                <td style='text-align: left;text-transform:none;font-size: 12px;' onclick='selectCard(this,\"$hashValue\");'>
                                    $paddedCardNumber
                                    <span class='useCardCheck' style='margin: 0px;font-size: 11px;' ><i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                                </td>
                                <td style='width: 30%;'>
                                    <div class='useCardCheck pull-right' style='margin: 0px;font-size: 13px;' ><i class='fa fa-trash-o' style='color: firebrick;' onclick='removeJccCard(this,\"$hashValue\",$customerID,$userID);'> $removeLabel</i></div>
                                </td>
                             </tr>";
                            }
                            $stm->close();
                            echo  "<tr><td colspan='3' style='text-align: left;text-transform:none;'><h3 style='text-transform: capitalize;margin: 0px;width: auto;'> $payWithLabel:</h3></td></tr>";
                            echo  "$cardsResult";
                            echo  "<tr class='cardSelector' id='cardSelector0' style='cursor: pointer'>
                        <td style='width: 1%;'  onclick='selectCard(this,\"\");'><img src='./assets/img/generic-card-icon.png' width='auto' height='40'></i></td>
                        <td style='text-align: left;text-transform:none;font-size: 13px;' colspan='3' onclick='selectCard(this,\"\");'>
                            <span class='pull-left selectCardLabel' style='margin: 0px;font-size: 13px;' >$newCardLabel</span>
                            <span class='pull-left useCardCheck' style='display: inline-block'>&nbsp;&nbsp; $newCardLabel <i class='fa fa-check useCardCheck' style='margin-left:2px;'></i></span>
                            <span class='pull-right useCardCheck' style='display: inline-block'>
                                <span style='padding-top:5px;font-size: 13px;'>$saveCardLabel</span>
                                <label class='cop-switch' style='padding:5px;margin-right: 2px;'>
                                    <input type='checkbox'  id='saveCardCheckbox'>            
                                    <span class='cop-switch-slider'></span>
                                </label>
                            </span>
                        </td>
                    </tr>
                </table>
                </div>";
                        }
                        echo "<script>
                                
                                $('#cardSelector$cardsCounter').children('td:first').click();
                                
                                function removeJccCard(element,value,cid,uid){
                                    removeCardJCC(value,cid,uid);
                                    $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"D\" />');
                                    $('#MerRespURL').val('https://" . HTML_PATH . "/cop/b2b/dbaccess/JCCRedirect.php?removeCard=y&urds=$userID');
                                    document.forms[\"paymentFormJCC\"].submit();
                                    $('#checkoutContainer').empty();
                                    $('#checkoutContainer').append('<div id=\"preloader\"><div id=\"preloader-status\"><div class=\"spinner\"><div class=\"rect1\"></div><div class=\"rect2\"></div><div class=\"rect3\"></div><div class=\"rect4\"></div><div class=\"rect5\"></div></div><div id=\"preloader-title\">$removeLabel</div></div>');
                                    
                                    
                                }
                                
                                function selectCard(td,hashValue){
                                    var tr = $(td).closest('tr');
                                    $(\".cardSelector\").css(\"border-color\",\"ghostwhite\");
                                    $(\".cardSelector\").css(\"background-color\",\"white\");
                                    $(\".cardSelector\").css(\"font-weight\",\"\");
                                    $(\".useCardCheck\").css(\"color\",\"transparent\").hide();
                                    $(\".selectCardLabel\").show();
                                    $(tr).css(\"border-color\",\"lightgray\");
                                    $(tr).css(\"background-color\",\"ghostwhite\");
                                    $(tr).css(\"font-weight\",\"bolder\");
                                    $(tr).find(\".useCardCheck\").css(\"color\",\"$themeColor\").show();
                                    $(tr).find(\".selectCardLabel\").hide();
                                    
                                    if(hashValue.localeCompare('')!=0){
                                        $('#saveCardCheckbox').prop('checked', false);
                                        $('#paymentFormJCC').attr('action', '$JCCDirectFormURL');
                                        $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"H\" /><br><input type=\"hidden\" name=\"hashValue\" value=\"'+hashValue+'\">');
                                        
                                    } else {
                                        $('#paymentFormJCC').attr('action', '$JCCFormURL');
                                        $('#saveCardInput').html('');
                                    }
                                    
                                }
                            </script>
                            <input type='hidden' name='Version' value='1.0.0'>
                            <input type='hidden' name='MerID' value='$JCCmerchantID'>
                            <input type='hidden' name='AcqID' value='$JCCacquirerID'>
                            <input type='hidden' name='MerRespURL' value='https://".HTML_PATH."/cop/b2b/dbaccess/JCCRedirect.php?urds=$userID&existing=1'>
                            <input type='hidden' name='PurchaseAmt' id='JCCPurchaseAmt' value='$JCCformattedPurchaseAmt'>
                            <input type='hidden' name='PurchaseCurrency' value='$JCCcurrency'>
                            <input type='hidden' name='PurchaseCurrencyExponent' value='2'>
                            <input type='hidden' name='OrderID' id='JCCOrderID' value='$JCCorderID'> 
                            <input type='hidden' name='CaptureFlag' value='$captureFlag'> 
                            <input type='hidden' name='Signature' id='JCCSignature' value='$base64Sha1Signature'>
                            <input type='hidden' name='SignatureMethod' value='SHA1'>
                            <div id='saveCardInput'></div>
                          </form> 
                          <script>
                            $('#saveCardCheckbox').change(function() {
                                if(this.checked) {
                                    $('#saveCardInput').html('<input type=\"hidden\" name=\"trxType\" value=\"R\" />');
                                } else {
                                    $('#saveCardInput').html('');
                                }
                            });
                          </script>
                      </div>";
                    }
                    ?>



                    <footer class="modal-footer" >
                        <button onclick="$('#saveModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;"><?php echo $langu['close_label'];?></button>
                        <button id="payNowButton" onclick="payOrder();" class="btn btn-success" style="display: none;"></button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->

        <!-- Modal -->
        <div class="modal fade" id="paymentStatusModal" tabindex="-1" role="dialog" aria-labelledby="appInfoLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
                        <h4 class="modal-title" style="margin-left:10px;"><strong style="padding-left:5px;">&nbsp;</strong></h4>
                    </div>

                    <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                        <center><br><br>
                        <?php
                        if(isset($paymentStatus) && $paymentStatus < 1){
                            echo "<h4 style=\"color:black\"><b></b><b style=\"color:firebrick\">$orderStatus</b></h4>";
                        } else if(isset($paymentStatus) && $paymentStatus == 1){
                            echo "<h4 style=\"color:black\"><b></b><b style=\"color:green\">".$langu['place_order_message']."</b></h4>";
                        } else {
                            echo "<h4 style=\"color:black\"><b>".$langu['account_order_status'].": </b><b style=\"color:black\">$orderStatus</b></h4>";
                        }
                        ?>
                        </center><br><br>
                    </div>

                    <footer class="modal-footer" >
                        <button onclick="$('#paymentStatusModal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;"><?php echo $langu['close_label'];?></button>
                    </footer>
                </div><!-- /.modal-content -->
            </div><!-- /.modal-dialog -->
        </div><!-- /.modal -->




        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->

        <script src="assets/js/waitMe.min.js"></script>

        <script src="https://www.paypal.com/sdk/js?client-id=<?php echo $paypalClientID; ?>&currency=<?php echo $paypalCurrencyCode; ?>"></script>


        <script type="text/javascript">
            jQuery(document).ready(function () {

                initThemeParameters();
                updatePayPalOrder();

                paypal.Buttons({
                    // Sets up the transaction when a payment button is clicked
                    createOrder: (data, actions) => {
                        return actions.order.create(JSON.parse($('#paypalOrder').val()));
                    },
                    // Finalize the transaction after payer approval
                    onApprove: (data, actions) => {
                        return actions.order.capture().then(function(orderData) {
                            // Successful capture! For dev/demo purposes:
                            console.log('Capture result', orderData, JSON.stringify(orderData, null, 2));
                            const transaction = orderData.purchase_units[0].payments.captures[0];



                            // When ready to go live, remove the alert and show a success message within this page. For example:
                            // const element = document.getElementById('paypal-button-container');
                            // element.innerHTML = '<h3>Thank you for your payment!</h3>';

                            actions.redirect('https://<?php echo HTML_PATH ?>/cop/b2b/paypal/paypalOrderHelper.php?oid=<?php echo $singleOrderID; ?>&cid=<?php echo $customerID; ?>&status=1');
                        });
                    }
                }).render('#paypal-button-container');

                <?php
                if($resolvedOrderID > 0){
                    echo "$('#checkoutCartContainer').show();";
                } else {
                    echo "$('#checkoutCartContainer').hide();";
                }
                ?>
            });


            function updatePayPalOrder() {
                $.ajax({
                    type: "POST",
                    url: './paypal/paypalOrderHelper.php',
                    data: {
                        'orderID': <?php echo $singleOrderID; ?>,
                        'customerID': <?php echo $customerID; ?>,
                        'currencyCode': '<?php echo $paypalCurrencyCode; ?>'


                    },

                    success: function (result) {
                        // console.log(result);
                        $('#paypalOrder').val(result);

                    }
                });
            }



        </script>

    </body>
</html>