<?php
if(isset($_GET['products'])){
    $seoPathUrlGet = $_GET['products'];
    $seoPathUrlArray = explode("/",$seoPathUrlGet);
    if(count($seoPathUrlArray)>0){
        $_GET['product'] = array_pop($seoPathUrlArray);
        $_GET['product'] = str_replace('--CP2F--','/',$_GET['product']);
    }
}

session_start();
include_once("../param.php");
include_once("headerImports.php");
require("./dbaccess/dbhelper.php");

global $username,$password,$database,$langu;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$userID = intval($_SESSION['userID']);
$customerID = intval($_SESSION['customerID']);
$currencySign = getCurrencySign();

$isB2C = false;
$useMaxStock=false;
$denyOrderOverStock = true;
$showPricesWithVAT=false;
$includeVatOnPrice=false;
$usePackingOnItem = false;
$showAnonymousPrices = false;
$allowAnonymousOrder = false;
$enableAddToCartButtonOnFirstClick = false;
$showDiscountBubble = true;
$showPrevPrice = true;



$addWatermark = false;
$stm = $db->prepare("SELECT watermark_id,file_url,position,opacity FROM B2B_Image_Watermark WHERE watermark_id=1 AND active='yes'");
$stm-> execute();
$stm-> bind_result($watermarkID,$watermarkURL,$watermarkPosition,$watermarkOpacity);
while ($stm->fetch()) {
    if($watermarkID > 0){$addWatermark = true;}
}
$stm->close();

$stm = $db->prepare("SELECT allow_anonymous,use_max_stock_on_item,allow_order_over_stock,max_stock_limit,show_prices_with_vat,use_as_b2c,css_theme,theme,use_packing,show_prices_anonymous,anonymous_order,logo_link,show_discount_bubble FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($anonymous,$useMaxStockOnItem,$allowOrderOverStockOnItem,$maxStockLimit,$showPricesIncludingVAT,$useAsB2C,$cssTheme,$labelThemeColor,$usePacking,$showB2BAnonymousPrices,$anonymousOrder,$logoLink,$show_discount_bubble);

while ($stm->fetch()) {

    switch ($show_discount_bubble) {
        case "no":
            $showDiscountBubble = false;
            $showPrevPrice = false;
            break;
        case 'bubble':
            $showDiscountBubble = true;
            $showPrevPrice = false;
            break;
        case 'price':
            $showDiscountBubble = false;
            $showPrevPrice = true;
            break;
        default:
            $showDiscountBubble = true;
            $showPrevPrice = true;
    }

    if(strcmp($showB2BAnonymousPrices,'yes')==0){
        $showAnonymousPrices = true;
    }
    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
    }

    if(strcmp($usePacking,'yes')==0){
        $usePackingOnItem = true;
    }
    if(strcmp($useMaxStockOnItem,'yes')==0){
        $useMaxStock = true;
    }
    if(strcmp($allowOrderOverStockOnItem,'yes')==0){
        $denyOrderOverStock = false;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0 || strcmp($showPricesIncludingVAT,"both")==0)
    {
        $showPricesWithVAT=true;
        if(strcmp($showPricesIncludingVAT,"yes")==0){
            $includeVatOnPrice = true;
        }
    }
    if(strcmp($useAsB2C,"yes")==0){$isB2C = true;}

    if($cssTheme <= 1){
        $cssTheme = '';
    }

}
$stm-> close();
$textColor = "white";
if(strcmp($labelThemeColor,'')!=0){
    if(strcmp($labelThemeColor,'red')==0 || strcmp($labelThemeColor,'Red')==0 ){
        $labelThemeColor = "firebrick";
    } else if(strcmp($labelThemeColor,'NavyBlue')==0 || strcmp($labelThemeColor,'NavyBlue')==0){
        $labelThemeColor = "#000080";
    } else if(strcmp($labelThemeColor,'black')==0 || strcmp($labelThemeColor,'Black')==0){
        $labelThemeColor = "black";
    } else if(strcmp($labelThemeColor,'gold')==0 || strcmp($labelThemeColor,'Gold')==0){
        $labelThemeColor = "goldenrod";
    } else if(strcmp($labelThemeColor,'yellow')==0 || strcmp($labelThemeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else if(strcmp($labelThemeColor,'DarkSlateBlue')==0 || strcmp($labelThemeColor,'DarkSlateBlue')==0){
        $labelThemeColor = "DarkSlateBlue";
    } else {
        if(strpos($labelThemeColor,'#')===false && strcmp($labelThemeColor,'Yellow')!=0) {
            $labelThemeColor = "dark$labelThemeColor";
        }
    }

} else {
    $labelThemeColor = "#6796d3";
}

$isB2CUser = '';
if(isset($_SESSION['userID'])) {

    $stm = $db->prepare("SELECT username,email,first_name,last_name,mobile,B2C_User FROM B2B_User WHERE b2b_user_id=? LIMIT 1");
    $stm->bind_param('i', $userID);
    $stm->execute();
    $stm->bind_result($userName, $email, $firstName, $lastName, $mobile, $isB2CUser);
    while ($stm->fetch()) {}
    $stm->close();
}

if(strcmp($isB2CUser,"yes")==0 && $isB2C){$isB2CUser = true;}else{$isB2CUser = false;}

if(strcmp($anonymous,'no')==0) {
    if (!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) {
        redirect("login.php");
    }
}



function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}



if(!isset($_SESSION['customerID']))
{
    $_SESSION['customerID']=0;
}
if(isset($_SESSION['orderID'])){$orderID=$_SESSION['orderID'];}

$customerID=$_SESSION['customerID'];



$result="";
$showPrices=true;


$stm = $db->prepare("SELECT primary_language,show_prices,footer FROM B2B_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPricesConfig,$footerLabel);

while ($stm->fetch()) {
    if(strcmp($showPricesConfig,"no")==0 || (isset($_SESSION['showPrices']) && $_SESSION['showPrices']==false))
    {
        $showPrices=false;
    }
}
$stm-> close();





$stm = $db->prepare("SELECT recommended_retail_price,numeric_stock,stock_warning_qty,show_add_to_cart_button,product_details_configuration_json,show_non_stock_items,allow_user_favorites,allow_product_history FROM B2B_Page_Catalogue LIMIT 1");
$stm-> execute();
$stm-> bind_result($recommendedRetailPrice,$numericStock,$stockWarningQty,$showAddToCartButton,$pageConfigJson,$show_non_stock_items,$allowUserFavorites,$allowOrderProductHistory);

while ($stm->fetch()) {
    if(strcmp($showAddToCartButton,'yes')==0){
        $enableAddToCartButtonOnFirstClick = true;
    }

    if(strcmp($allowUserFavorites,"yes")==0) {
        $favoritesShow=true;
    } else {
        $favoritesShow=false;
    }

    if(intval($userID)==0 || intval($customerID)==0) {
        $historyShow = false;
    }
    else {
        if (strcmp($allowOrderProductHistory, "yes") == 0) {
            $historyShow = true;
        } else {
            $historyShow = false;
        }
    }

}
$stm-> close();




$availableItem = false;

$itemID = 0;

if(isset($_GET['code'])) {
    $itemID = intval($_GET['code']);
}

if(isset($_GET['product']) && strcmp(''.$_GET['product'],'')!=0){
    $itemCode = urldecode("".$_GET['product']);
    $stm = $db->prepare("SELECT item_id FROM Items WHERE item_code = ? AND NOT status='inactive' AND NOT sellable='no' LIMIT 1");
    $stm->bind_param('s', $itemCode);
    $stm-> execute();
    $stm-> bind_result($selectedItemID);
    while ($stm->fetch()) {if($selectedItemID > 0){$itemID = $selectedItemID;}}
    $stm-> close();
}

$stm = $db->prepare("SELECT item_code,name,short_description,long_description,packing,item_sku,max_stock,vat_id,status,sellable  FROM Items WHERE item_id = ? AND NOT status='inactive' AND NOT sellable='no' LIMIT 1");
$stm->bind_param('i', $itemID);
$stm-> execute();
$stm-> bind_result($itemCode,$itemName,$shortDescription,$longDescription,$packing,$sku,$maxStockOfItem,$vatID,$status,$b2bAvailable);
while ($stm->fetch()) {
   $itemCodeString =$itemCode;
   $itemNameString =$itemName;
   $isFavorite = isItemFavorite($itemID,$userID,$customerID);

    if(is_numeric(trim($longDescription))){$longDescription = '';}

    $longDescription = str_replace("*NEW**NEW*","*NEW*",$longDescription);
    $longDescription = str_replace("*NEW*","<br>",$longDescription);
    $longDescription = str_replace('#newline#'."\n" ,'#newline#',$longDescription);
    $longDescription = str_replace('#newline#' ,'<br>',$longDescription);
    $longDescription = str_replace("\n" ,'<br>',$longDescription);

    $shortDescription = str_replace("*NEW**NEW*","*NEW*",$shortDescription);
    $shortDescription = str_replace("*NEW*","<br>",$shortDescription);
    $shortDescription = str_replace('#newline#'."\n" ,'#newline#',$shortDescription);
    $shortDescription = str_replace('#newline#' ,'<br>',$shortDescription);
    $shortDescription = str_replace("\n" ,'<br>',$shortDescription);

    $stock = getStock($itemID);

    if(strcmp("$show_non_stock_items","no")==0 && $stock <=0){
        $status = 'inactive';
    } else if(strcmp("$show_non_stock_items","notavailable")==0 && $stock <=0){
        $b2bAvailable = 'notavailable';
    }


    if(strcmp($status,'inactive')==0){
        $isInactive = true;
    } else {
        $isInactive = false;
    }
    if(strcmp($b2bAvailable,'notavailable')==0){
        $isInactive = true;
        $nonStock = true;
    } else if(strcmp($b2bAvailable,'nonstock')==0){
        $nonStock = true;
    } else {
        $nonStock = false;
    }
    $availableItem = true;
}
$stm-> close();

if(!$availableItem){
    redirect("index.php");
}



if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($shortDescription) && strcmp($shortDescription,'')!=0 ) {

    $temp = $itemNameString;
    $itemNameString=$shortDescription;
    $shortDescription = $temp;
    $temp = '';
}





$stm = $db->prepare("SELECT image_name,image_url FROM Item_Images WHERE item_id = ? ORDER BY image_order ASC, timestamp DESC ");
$stm->bind_param('i', $itemID);
$stm-> execute();
$stm-> bind_result($imageName,$imageUrl);

$imagesArray = array();

while ($stm->fetch()) {
    $fullImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$imageUrl.jpg";
    $rz = ROOT."/media/productImages/$imageUrl.jpg";

    if(!file_exists($rz))
    {
        $fullImageUrl = "//" . HTML_PATH . "/cop/media/productImages/$imageUrl.png";
        $rz = ROOT."/media/productImages/$imageUrl.png";

    }
    if(file_exists($rz))
    {
        array_push($imagesArray,$fullImageUrl);
    }

}
$stm-> close();

if(count($imagesArray)==0)
{
    $fullImageUrl = "./assets/img/noimage.jpg";
    array_push($imagesArray,$fullImageUrl);
}


$stm = $db->prepare("SELECT barcode FROM Item_Barcode WHERE item_id = ? LIMIT 1");
$stm->bind_param('i', $itemID);
$stm-> execute();
$stm-> bind_result($barcode);

while ($stm->fetch()) {

}

$stm-> close();

if(isset($orderID)) {
    $qty = getQtyFromCart($orderID, $itemID);
} else {
    $qty = 0;
}

if(isset($userID) && $userID > 0){
    $oldPrice = getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID,false,$qty);
    $price =getDefaultPriceInclPriceTypes($itemID,$customerID,false,$qty);
} else {
    $oldPrice = getDefaultPriceInclPriceTypesNoOffer($itemID,$customerID,true,$qty);
    $price = getDefaultPriceInclPriceTypes($itemID,$customerID,true,$qty);
}






if($oldPrice > $price && $oldPrice > 0 && !$isB2CUser){
    $prevPrice = number_format(floatval($oldPrice),2);
} else {
    $prevPrice = '';
}


if($showPricesWithVAT) {
    $vatPercentage = getVatPercentage($vatID);
    $priceWithVAT = (float)$price + (float)$price*($vatPercentage/100);
    $oldPriceWithVAT = (float)$oldPrice + (float)$oldPrice*($vatPercentage/100);

    $inc = $langu['incl_label'];
    $vat = $langu['vat_label'];
    $PriceWithVatText = "&nbsp;<div  style='font-size:17px;color: #0aa66e '>($currencySign".number_format(floatval($priceWithVAT),2)." &nbsp;$inc $vat)</div>";
    if($includeVatOnPrice){
        $PriceWithVatText='';
        $price= $priceWithVAT;
        $oldPrice= $oldPriceWithVAT;

    }
}

if($oldPrice > $price){
    $percentDiscount = round((1 - ($price/$oldPrice))*100);
    $price = number_format(floatval($price),2);
    $oldPrice = number_format(floatval($oldPrice),2);
    if($showDiscountBubble) {
        $discountBubble = "<span style='color: $textColor;background-color: $labelThemeColor;border-radius: 10%;margin-left: 20px;'>&nbsp;-$percentDiscount%&nbsp;</span>";
    }
    if($showPrevPrice) {
        $deletedPrevPrice = "<del style='color: grey;font-size: 26px;'>$currencySign" . $oldPrice . "</del><br>";
    }
    $price = $deletedPrevPrice.$currencySign.$price.$discountBubble;
} else {
    if(isset($prevPrice) && $prevPrice > $price && $showPrevPrice){
        $percentDiscount = round((1 - ($price/$prevPrice))*100);
        $price = number_format(floatval($price),2);
        $prevPrice = number_format(floatval($prevPrice),2);
        if($showDiscountBubble) {
            $discountBubble = "<span style='color: $textColor;background-color: $labelThemeColor;border-radius: 10%;margin-left: 20px;'>&nbsp;-$percentDiscount%&nbsp;</span>";
        }
        if($showPrevPrice) {
            $deletedPrevPrice = "<del style='color: grey;font-size: 26px;'>$currencySign" . $prevPrice . "</del><br>";
        }
        $price = $deletedPrevPrice.$currencySign.$price.$discountBubble;
    } else {
        $price = number_format(floatval($price),2);
        $price = "$currencySign" . $price;
    }
}

//if(isset($_COOKIE['currentCategory']) && $_COOKIE['currentCategory'] > 0){
//    $categoryStatementCategoryFilter = ' WHERE Categories.category_id = \''.$_COOKIE['currentCategory'].'\'';
//} else {
    $categoryStatementCategoryFilter = " WHERE category_id IN(SELECT category_id AS category_id FROM Category_Item WHERE item_id = '$itemID') AND (Categories.category_id IN (SELECT category_id FROM B2B_Categories) OR Categories.category_id IN(SELECT subcategory_id FROM Subcategories,B2B_Categories WHERE Subcategories.category_id=B2B_Categories.category_id))";
//}
$categoryStatement= "SELECT category_id,category_code,name,description FROM Categories $categoryStatementCategoryFilter";

$stm = $db->prepare($categoryStatement);
$stm-> execute();
$stm-> bind_result($categoryid,$categoryCode,$categoryName,$categoryDescription);

while ($stm->fetch()) {
    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($categoryDescription) && strcmp($categoryDescription,'')!=0 )
    {
        $categoryName=$categoryDescription;
    }
    $_SESSION['cc'] = $categoryCode;
}

$stm-> close();
if(isset($orderID)) {
    $itemsLabel = $langu['item'];
    $stm = $db->prepare("SELECT SUM(qty) FROM Online_Order_Item WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($count);

    while ($stm->fetch()) {
    //    $cartCounter="<input id='cartCounter' value='$count $itemsLabel' type='hidden'/>";
    }
    $stm->close();
}

$stm = $db->prepare("SELECT custom_form_id,custom_form_code,custom_form_name FROM  ZA_Custom_Form_Definition,ZA_Custom_Form_Usage WHERE ZA_Custom_Form_Definition.custom_form_definition_id=ZA_Custom_Form_Usage.custom_form_id  AND linked_table='Items'");
$stm->execute();
$stm->bind_result($customFormID,$customFormCode,$customFormName);
while ($stm->fetch()) {

    //include_once("../backend/dbhelper.php");


    $db2= new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno())
    {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $columns = array();
    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT ZA_Custom_Field_Definition.custom_field_id,custom_field_name,type,values_range,css_style,position,required,editable,class FROM  ZA_Custom_Field_Definition,ZA_Custom_Form_Custom_Field WHERE ZA_Custom_Field_Definition.custom_field_id=ZA_Custom_Form_Custom_Field.custom_field_id  AND ZA_Custom_Form_Custom_Field.custom_form_id='$customFormID' ORDER BY position");
    $stm2->execute();
    $stm2->bind_result($customFieldID,$customFieldName,$type,$valuesRange,$cssStyle,$position,$required,$editable,$class);
    while ($stm2->fetch()) {


       $formatter = getLastValueOfCustomForm($customFormID, $customFieldID, "Items", $itemID);



        $column['field'] = $customFieldName;
        $column['value'] = $formatter;

        array_push($columns,$column);
    }
    $stm2->close();

}
$stm->close();

$stm = $db->prepare("SELECT category_id FROM B2B_Brands WHERE slider_position='variants' AND category_id IN (SELECT category_id FROM Category_Item WHERE item_id = '$itemID') ORDER BY position ASC LIMIT 1");
$stm->execute();
$stm->bind_result($brandID);
while ($stm->fetch()) {}
$stm->close();

if($brandID > 0 && strcmp($_GET['singleVariant'],'yes')!=0){

    redirect("index.php?variants=$brandID");
}

function addElementToCustomizationArray($array,$key,$type,$label,$value){
    $array["$key"]['type'] = $type;
    $array["$key"]['label'] = $label;
    $array["$key"]['value'] = $value;
    return $array;
}


$b2bCategories = getB2BCategories($db);
$categoryTreeArray = array();
$stm = $db->prepare("SELECT name,category_code,description,category_id FROM Categories WHERE category_id IN (SELECT category_id FROM Category_Item WHERE item_id = '$itemID') AND category_id IN (".implode(',',$b2bCategories).") ORDER BY level ASC,custom_order ASC");
$stm->execute();
$stm->bind_result($categoryTreeName,$categoryTreeCode,$categoryTreeDescription,$relatedCategoryID);
while ($stm->fetch()) {
    if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($categoryTreeDescription) && strcmp($categoryTreeDescription,'')!=0 ) {
        $categoryTreeName=$categoryTreeDescription;
    }
    $categoryTreeCode = urlencode($categoryTreeCode);
    $categoryTreeName = ucwords(strtolower($categoryTreeName));
    $categoryTreeName = "<a href='//".HTML_PATH."/cop/b2b/catalogue/$categoryTreeCode' style='color:inherit !important;' class='underlineOnHover'>$categoryTreeName</a>";
    array_push($categoryTreeArray,$categoryTreeName);
}
$stm->close();



if(count($categoryTreeArray)>1){
    $categoryLabel = $langu['categories_label'];
    if(strcmp($categoryLabel,"Κατηγοριες")==0){$categoryLabel = "Κατηγορίες";}
} else {
    $categoryLabel = $langu['category_label'];
}

if($categoryid >0){
    $categoryPathURL = '';
    $stm = $db->prepare("SELECT name FROM Categories WHERE category_id=? LIMIT 1");
    $stm->bind_param('i', $categoryid);
    $stm->execute();
    $stm->bind_result($categoryName);
    while ($stm->fetch()) {
        $categoryName = make_greeklish($categoryName);
        $categoryName = transliterateString($categoryName);
        $categoryName = str_replace(' ','-',strtolower($categoryName));
        $categoryName = str_replace('&','and',$categoryName);
        $categoryName = preg_replace('/[^A-Za-z0-9\-]/', '', $categoryName);


        $categoryPathURL = "$categoryName/";
    }
    $stm->close();

} else {

    $stm = $db->prepare("SELECT Categories.category_code FROM Categories,Category_Item WHERE Categories.category_id=Category_Item.category_id AND Categories.category_id IN (".implode(',',$b2bCategories).") AND Category_Item.item_id = ? ORDER BY Categories.level ASC,Categories.custom_order LIMIT 1");
    $stm->bind_param('i', $itemID);
    $stm->execute();
    $stm->bind_result($categoryCode);
    while ($stm->fetch()) {}
    $stm->close();
}
function make_greeklish($text) {
    $expressions = array(
        '/[αΑ][ιίΙΊ]/u' => 'e',
        '/[οΟΕε][ιίΙΊ]/u' => 'i',
        '/[αΑ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'af$1',
        '/[αΑ][υύΥΎ]/u' => 'av',
        '/[εΕ][υύΥΎ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'ef$1',
        '/[εΕ][υύΥΎ]/u' => 'ev',
        '/[οΟ][υύΥΎ]/u' => 'ou',
        '/(^|\s)[μΜ][πΠ]/u' => '$1b',
        '/[μΜ][πΠ](\s|$)/u' => 'b$1',
        '/[μΜ][πΠ]/u' => 'mp',
        '/[νΝ][τΤ]/u' => 'nt',
        '/[τΤ][σΣ]/u' => 'ts',
        '/[τΤ][ζΖ]/u' => 'tz',
        '/[γΓ][γΓ]/u' => 'ng',
        '/[γΓ][κΚ]/u' => 'gk',
        '/[ηΗ][υΥ]([θΘκΚξΞπΠσςΣτTφΡχΧψΨ]|\s|$)/u' => 'if$1',
        '/[ηΗ][υΥ]/u' => 'iu',
        '/[θΘ]/u' => 'th',
        '/[χΧ]/u' => 'ch',
        '/[ψΨ]/u' => 'ps',
        '/[αά]/u' => 'a',
        '/[βΒ]/u' => 'v',
        '/[γΓ]/u' => 'g',
        '/[δΔ]/u' => 'd',
        '/[εέΕΈ]/u' => 'e',
        '/[ζΖ]/u' => 'z',
        '/[ηήΗΉ]/u' => 'i',
        '/[ιίϊΙΊΪ]/u' => 'i',
        '/[κΚ]/u' => 'k',
        '/[λΛ]/u' => 'l',
        '/[μΜ]/u' => 'm',
        '/[νΝ]/u' => 'n',
        '/[ξΞ]/u' => 'x',
        '/[οόΟΌ]/u' => 'o',
        '/[πΠ]/u' => 'p',
        '/[ρΡ]/u' => 'r',
        '/[σςΣ]/u' => 's',
        '/[τΤ]/u' => 't',
        '/[υύϋΥΎΫ]/u' => 'i',
        '/[φΦ]/iu' => 'f',
        '/[ωώ]/iu' => 'o',
    );

    $text = preg_replace( array_keys($expressions), array_values($expressions), $text);
    return $text;
}

function transliterateString($txt) {
    $transliterationTable = array('á' => 'a', 'Á' => 'A', 'à' => 'a', 'À' => 'A', 'ă' => 'a', 'Ă' => 'A', 'â' => 'a', 'Â' => 'A', 'å' => 'a', 'Å' => 'A', 'ã' => 'a', 'Ã' => 'A', 'ą' => 'a', 'Ą' => 'A', 'ā' => 'a', 'Ā' => 'A', 'ä' => 'ae', 'Ä' => 'AE', 'æ' => 'ae', 'Æ' => 'AE', 'ḃ' => 'b', 'Ḃ' => 'B', 'ć' => 'c', 'Ć' => 'C', 'ĉ' => 'c', 'Ĉ' => 'C', 'č' => 'c', 'Č' => 'C', 'ċ' => 'c', 'Ċ' => 'C', 'ç' => 'c', 'Ç' => 'C', 'ď' => 'd', 'Ď' => 'D', 'ḋ' => 'd', 'Ḋ' => 'D', 'đ' => 'd', 'Đ' => 'D', 'ð' => 'dh', 'Ð' => 'Dh', 'é' => 'e', 'É' => 'E', 'è' => 'e', 'È' => 'E', 'ĕ' => 'e', 'Ĕ' => 'E', 'ê' => 'e', 'Ê' => 'E', 'ě' => 'e', 'Ě' => 'E', 'ë' => 'e', 'Ë' => 'E', 'ė' => 'e', 'Ė' => 'E', 'ę' => 'e', 'Ę' => 'E', 'ē' => 'e', 'Ē' => 'E', 'ḟ' => 'f', 'Ḟ' => 'F', 'ƒ' => 'f', 'Ƒ' => 'F', 'ğ' => 'g', 'Ğ' => 'G', 'ĝ' => 'g', 'Ĝ' => 'G', 'ġ' => 'g', 'Ġ' => 'G', 'ģ' => 'g', 'Ģ' => 'G', 'ĥ' => 'h', 'Ĥ' => 'H', 'ħ' => 'h', 'Ħ' => 'H', 'í' => 'i', 'Í' => 'I', 'ì' => 'i', 'Ì' => 'I', 'î' => 'i', 'Î' => 'I', 'ï' => 'i', 'Ï' => 'I', 'ĩ' => 'i', 'Ĩ' => 'I', 'į' => 'i', 'Į' => 'I', 'ī' => 'i', 'Ī' => 'I', 'ĵ' => 'j', 'Ĵ' => 'J', 'ķ' => 'k', 'Ķ' => 'K', 'ĺ' => 'l', 'Ĺ' => 'L', 'ľ' => 'l', 'Ľ' => 'L', 'ļ' => 'l', 'Ļ' => 'L', 'ł' => 'l', 'Ł' => 'L', 'ṁ' => 'm', 'Ṁ' => 'M', 'ń' => 'n', 'Ń' => 'N', 'ň' => 'n', 'Ň' => 'N', 'ñ' => 'n', 'Ñ' => 'N', 'ņ' => 'n', 'Ņ' => 'N', 'ó' => 'o', 'Ó' => 'O', 'ò' => 'o', 'Ò' => 'O', 'ô' => 'o', 'Ô' => 'O', 'ő' => 'o', 'Ő' => 'O', 'õ' => 'o', 'Õ' => 'O', 'ø' => 'oe', 'Ø' => 'OE', 'ō' => 'o', 'Ō' => 'O', 'ơ' => 'o', 'Ơ' => 'O', 'ö' => 'oe', 'Ö' => 'OE', 'ṗ' => 'p', 'Ṗ' => 'P', 'ŕ' => 'r', 'Ŕ' => 'R', 'ř' => 'r', 'Ř' => 'R', 'ŗ' => 'r', 'Ŗ' => 'R', 'ś' => 's', 'Ś' => 'S', 'ŝ' => 's', 'Ŝ' => 'S', 'š' => 's', 'Š' => 'S', 'ṡ' => 's', 'Ṡ' => 'S', 'ş' => 's', 'Ş' => 'S', 'ș' => 's', 'Ș' => 'S', 'ß' => 'SS', 'ť' => 't', 'Ť' => 'T', 'ṫ' => 't', 'Ṫ' => 'T', 'ţ' => 't', 'Ţ' => 'T', 'ț' => 't', 'Ț' => 'T', 'ŧ' => 't', 'Ŧ' => 'T', 'ú' => 'u', 'Ú' => 'U', 'ù' => 'u', 'Ù' => 'U', 'ŭ' => 'u', 'Ŭ' => 'U', 'û' => 'u', 'Û' => 'U', 'ů' => 'u', 'Ů' => 'U', 'ű' => 'u', 'Ű' => 'U', 'ũ' => 'u', 'Ũ' => 'U', 'ų' => 'u', 'Ų' => 'U', 'ū' => 'u', 'Ū' => 'U', 'ư' => 'u', 'Ư' => 'U', 'ü' => 'ue', 'Ü' => 'UE', 'ẃ' => 'w', 'Ẃ' => 'W', 'ẁ' => 'w', 'Ẁ' => 'W', 'ŵ' => 'w', 'Ŵ' => 'W', 'ẅ' => 'w', 'Ẅ' => 'W', 'ý' => 'y', 'Ý' => 'Y', 'ỳ' => 'y', 'Ỳ' => 'Y', 'ŷ' => 'y', 'Ŷ' => 'Y', 'ÿ' => 'y', 'Ÿ' => 'Y', 'ź' => 'z', 'Ź' => 'Z', 'ž' => 'z', 'Ž' => 'Z', 'ż' => 'z', 'Ż' => 'Z', 'þ' => 'th', 'Þ' => 'Th', 'µ' => 'u', 'а' => 'a', 'А' => 'a', 'б' => 'b', 'Б' => 'b', 'в' => 'v', 'В' => 'v', 'г' => 'g', 'Г' => 'g', 'д' => 'd', 'Д' => 'd', 'е' => 'e', 'Е' => 'E', 'ё' => 'e', 'Ё' => 'E', 'ж' => 'zh', 'Ж' => 'zh', 'з' => 'z', 'З' => 'z', 'и' => 'i', 'И' => 'i', 'й' => 'j', 'Й' => 'j', 'к' => 'k', 'К' => 'k', 'л' => 'l', 'Л' => 'l', 'м' => 'm', 'М' => 'm', 'н' => 'n', 'Н' => 'n', 'о' => 'o', 'О' => 'o', 'п' => 'p', 'П' => 'p', 'р' => 'r', 'Р' => 'r', 'с' => 's', 'С' => 's', 'т' => 't', 'Т' => 't', 'у' => 'u', 'У' => 'u', 'ф' => 'f', 'Ф' => 'f', 'х' => 'h', 'Х' => 'h', 'ц' => 'c', 'Ц' => 'c', 'ч' => 'ch', 'Ч' => 'ch', 'ш' => 'sh', 'Ш' => 'sh', 'щ' => 'sch', 'Щ' => 'sch', 'ъ' => '', 'Ъ' => '', 'ы' => 'y', 'Ы' => 'y', 'ь' => '', 'Ь' => '', 'э' => 'e', 'Э' => 'e', 'ю' => 'ju', 'Ю' => 'ju', 'я' => 'ja', 'Я' => 'ja');
    return str_replace(array_keys($transliterationTable), array_values($transliterationTable), $txt);
}

function getB2BCategories($db){

    $categoriesArray = array();
    $counterOfCategories = 0;
    $categoryID = 0;

    if(isset($_SESSION['userID'])) {
        $user=$_SESSION['userID'];
        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();
        if($counterOfCategories>0)
        {
            $query="SELECT Categories.category_id FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }
    } else {
        $query="SELECT Categories.category_id FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID);
    while ($stm->fetch()) {
        $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($categoryID,$categoriesArray)));
    }
    $stm->close();

    return $categoriesArray;
}

function getSubCategories($categoryID,$categoriesArray){

    if(!in_array($categoryID,$categoriesArray)){
        array_push($categoriesArray,$categoryID);
    }

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db2->set_charset("utf8");
    $stm2 = $db2->prepare("SELECT Categories.category_id FROM Categories,Subcategories WHERE  Subcategories.category_id =\"$categoryID\" AND Categories.category_id=Subcategories.subcategory_id ");
    $stm2-> execute();
    $stm2-> bind_result($subCategoryID);
    while ($stm2->fetch()) {
        if(!in_array($subCategoryID,$categoriesArray)){
            array_push($categoriesArray,$subCategoryID);
            $categoriesArray = array_unique(array_merge($categoriesArray,getSubCategories($subCategoryID,$categoriesArray)));
        }
    }
    $stm2-> close();

    return $categoriesArray;

}

function getContractPricesPerQty($itemID,$customerID,$currencySign, $userID,$vatPercentage, $includeVatOnPrice){

    if(isset($userID) && $userID > 0){
        $singlePrice = getDefaultPriceInclPriceTypes($itemID,$customerID,false,1);
    } else {
        $singlePrice = getDefaultPriceInclPriceTypes($itemID,$customerID,true,1);
    }

    if($includeVatOnPrice){
        $singlePrice = floatval($singlePrice) + floatval($singlePrice*($vatPercentage/100));
    }

    $singlePrice = $currencySign.number_format(floatval($singlePrice), 2);

    global $username,$password,$database;
    $db2 = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db2->set_charset("utf8");

    $contractPricesRows = '';
    $contractPricesTable = '';
    $stm2 = $db2->prepare("SELECT min_qty,price FROM ContractPrices WHERE item_id = ? AND (customer_id = ? OR customer_id = 1) AND DATE(valid_from) <= DATE(NOW()) AND DATE(valid_until) >= DATE(NOW()) AND min_qty > 1 ORDER BY min_qty ASC");
    $stm2->bind_param('ii', $itemID,$customerID);
    $stm2-> execute();
    $stm2-> bind_result($minQty,$price);
    while ($stm2->fetch()) {

        if($price > 0) {
            $price = $price / getPriceRate();

            if($includeVatOnPrice){
                $price = floatval($price) + floatval($price*($vatPercentage/100));
            }

            $price = number_format(floatval($price), 2);
            $contractPricesRows .= "<tr style='border: 1px solid rgb(221,221,221)'><td>$minQty pcs:</td><td style='text-align: right'>$currencySign$price</td></tr>";
        }
    }
    $stm2-> close();

    if(strcmp($contractPricesRows,'')!=0){
        $contractPricesTable = "<table class='table table-condensed' style='width: fit-content;white-space: nowrap;'>
                                    <tbody>
                                    <tr style='border: 1px solid rgb(221,221,221)'><td>1 pcs:</td><td style='text-align: right'>$singlePrice</td>
                                    $contractPricesRows
                                    </tbody>
                                </table>";
    }
    return $contractPricesTable;
}
?>

    <style>
        .underlineOnHover:hover {
            text-decoration: underline;
        }
    </style>
    <body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div id='cartItems' class="container">

                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- Popup: Videos -->
            <div class="modal fade video-modal" id="video-modal" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog" >
                    <div class="modal-content" >
                        <div class="modal-body" style="margin-top:5px;padding-top:5px;">
                            <div  id='divVideo' >
                                <center>
                                <video autoplay loop controls style="display: block;width: 95%;margin: 0 auto; " >
                                    <source src="" />
                                </video>
                                </center>
                            </div>
                            <div  id='divYoutube' >
                                <center>
                                    <iframe height="450" id="youtubePlayer" src="" style="width: 95%;" ></iframe>
                                </center>
                            </div>
                            <footer class="modal-footer" >

                                <button onclick="$('#video-modal').modal('toggle');" class="btn btn-default" type="button" style="margin-right:10px;">
                                    Close
                                </button>
                            </footer>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Videos -->


            <!--Modal show order history of the item -->
            <div class="modal fade" id="showOrderHistoryModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">

                <div class="modal-dialog modal-dialog-centered"  role="document">
                    <div class="modal-content" style="z-index: 9999999 !important; max-height: 70vh;  overflow-y: auto; ">
                        <div class="modal-header" style="padding:12px;">
                            <center><h3 class="block-title" style="padding: 0px;margin:0px;color:<?php echo $labelThemeColor; ?>;"></h3></center>
                        </div>
                        <div class="modal-body" style="padding:2px;"> </div>
                        <div class="modal-footer" style="padding:10px;border-top: 1px solid transparent;">
                            <button type="button" class="btn btn-theme-transparent" data-dismiss="modal"><?php echo $langu['close_label']; ?></button>
                        </div>
                    </div>
                </div>
            </div>


            <!-- HEADER -->

                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }
                include_once("$topmenu");

                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }

                if(count($categoryTreeArray)>0){
                    global $themeColor;
                    $categoryName = implode(";|bubbleBreak|;",$categoryTreeArray);
                    $_SESSION['cc'] = '';
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area" style="min-height:805px;">
                <input type="hidden" id="relatedCategory" value="<?php echo intval($relatedCategoryID); ?>">
                <!-- PAGE -->
                <section class="page-section">
                    <div class="container" style="width: 90%">

                        <div class="row product-single">
                            <div class="back-to-category" style="margin: 20px;">
                                <span class="link"><a href="./catalogue/<?php echo urlencode("$categoryCode");?>" style="font-weight: bolder;font-size: 16px;"><i class="fa fa-angle-left"></i> <?php echo $langu['back_to_catalogue_label'];?></a></span>
                                <div class="pull-right">
                                    <?php
                                    $hasNextProduct  = false;
                                    $stm = $db->prepare("SELECT item_id,item_code FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryid') AND NOT Items.item_id = '$itemID' AND Items.item_code > '$itemCode' AND NOT status ='inactive' AND NOT sellable='no' ORDER BY item_code ASC LIMIT 1");
                                    $stm->execute();
                                    $stm->bind_result($nextItemId,$nextItemCode);
                                    while ($stm->fetch()) {$hasNextProduct= true;}
                                    $stm->close();
                                    if(!$hasNextProduct){$nextItemId = $itemID;$nextItemCode=$itemCode;}

                                    $hasPreviousProduct  = false;
                                    $stm = $db->prepare("SELECT item_id,item_code FROM Items WHERE item_id IN (SELECT item_id AS item_id FROM Category_Item WHERE category_id='$categoryid') AND NOT Items.item_id = '$itemID' AND Items.item_code < '$itemCode' AND NOT status ='inactive' AND NOT sellable='no' ORDER BY item_code DESC  LIMIT 1");
                                    $stm->execute();
                                    $stm->bind_result($previousItemId,$previousItemCode);
                                    while ($stm->fetch()) {$hasPreviousProduct= true;}
                                    $stm->close();
                                    if(!$hasPreviousProduct){$previousItemId = $itemID;$previousItemCode=$itemCode;}
                                    $nextItemCode = urlencode("$nextItemCode");
                                    $previousItemCode = urlencode("$previousItemCode");


                                    ?>
                                    <a class="btn btn-theme btn-theme-transparent btn-previous" style="<?php if($hasPreviousProduct){echo "display:inline-block;";}else{ echo "display:none;";}?>" href="<?php echo "./products/$categoryPathURL$previousItemCode";?>"><i class="fa fa-angle-left"></i></a>
                                    <a class="btn btn-theme btn-theme-transparent btn-next" style="<?php if($hasNextProduct){echo "display:inline-block;";}else{ echo "display:none;";}?>" href="<?php echo "./products/$categoryPathURL$nextItemCode";?>"><i class="fa fa-angle-right"></i></a>
                                </div>
                            </div>
                            <div class="col-md-1 hidden-xs hidden-sm">
                                <div class="row product-thumbnails" >
                                    <?php
                                    $counter = 0;

                                    foreach($imagesArray as $image) {
                                        if($addWatermark) {

                                            if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
                                            if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
                                            if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
                                            if(strcmp($image,'./assets/img/noimage.jpg')!=0) {
                                                $watermarks .= "
                                                watermark(['$image','$watermarkURL'])
                                                .image(watermark.image.$watermarkPosition($watermarkOpacity))
                                                .then(function (img) {
                                                    img.id = 'thmImage$counter';
                                                    img.style.cssText = document.getElementById('thmImage$counter').style.cssText;
                                                    document.getElementById('thmImage$counter').remove();
                                                    document.getElementById('thm$counter').appendChild(img);
                                        
                                                });
                                        
                                                ";
                                            }

                                            $imageUrl = './assets/img/noimage.jpg';
                                        }

                                        echo " <div class='col-xs-12 col-sm-12 col-md-12 pull-right' style='width: 90%;margin: 1px;'><a href='#' class='thm' onclick='assignTrigger($counter);' id='thm$counter' style='border: 2px solid lightgrey;border-radius: 15%;'><img src='$image' alt='' id='thmImage$counter' style='border-radius: 15%'/></a></div>";
                                        $counter++;
                                    }
                                    ?>

                                </div>
                            </div>
                            <div class="col-md-5">

                                <div class="badges">
<!--                                    <div class="hot">hot</div>-->
<!--                                    <div class="new">new</div>-->
                                </div>
                                <div class="img-carousel-manual" id="single-image-carousel">
                                    <?php
                                    $counter = 0;
                                    foreach($imagesArray as $image) {

                                        if($addWatermark) {

                                            if(strcmp($watermarkURL,'')==0){$watermarkURL = $logoLink;};
                                            if(strcmp($watermarkPosition,'')==0){$watermarkPosition = 'center';}
                                            if(strcmp($watermarkOpacity,'')==0){$watermarkOpacity = '0.5';}
                                            if(strcmp($image,'./assets/img/noimage.jpg')!=0) {
                                                $watermarks .= "
                                                    watermark(['$image','$watermarkURL'])
                                                    .image(watermark.image.$watermarkPosition($watermarkOpacity))
                                                    .then(function (img) {
                                                        img.id = 'thmDisplay$counter';
//                                                        img.style.cssText = document.getElementById('thmDisplay$counter').style.cssText;
                                                        document.getElementById('thmDisplay$counter').remove();
                                                        document.getElementById('thmDisplayParent$counter').appendChild(img);
                                            
                                                    });
                                            
                                                    ";
                                            }
                                            $imageUrl = './assets/img/noimage.jpg';
                                        }

                                        echo "<div class='item' id='thmDisplayParent$counter'>
                                                <a href='$image' data-gal='prettyPhoto'><img class='img-responsive' id='thmDisplay$counter' src='$image' alt='' style='max-height:700px;width:auto; display: block;margin-left: auto;margin-right: auto;'/></a>
                                              </div>";

                                        $counter++;
                                    }
                                    ?>

                                </div>

                            </div>
                            <div class="col-md-6">



                                    <?php

                                    $stm = $db->prepare("SELECT brochure_name FROM Item_Brochures WHERE item_id='$itemID'");
                                    $stm-> execute();
                                    $stm-> bind_result($brochureName);
                                    while ($stm->fetch()) {

                                        $brochures .="&nbsp;<a  target='_blank' href='//" . HTML_PATH . "/cop/media/brochures/$brochureName'><img style='height:40px;width:40px;' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/pdficon.png' alt='Attachment' title='$brochureName'/></a>";

                                    }
                                    $stm-> close();


                                    $stm = $db->prepare("SELECT video_url FROM Item_Videos WHERE item_id='$itemID'");
                                    $stm-> execute();
                                    $stm-> bind_result($videoName);
                                    while ($stm->fetch()) {
                                        if(strpos($videoName,'youtu')!=false && strpos($videoName,'be')!=false){
                                             $videoID = substr($videoName, -11);

                                                $videoURL = "https://www.youtube.com/embed/".$videoID."?autoplay=1 ";
                                            $videos .= "<button onclick=\"playVideo('$videoURL',true)\" class='btn btn-theme btn-theme' style='border-radius: 50%;width: 44px;height: 44px;font-size: 16px;padding-left: 14px;padding-top: 11px;'><i class='fa fa-play'></i></button> ";

                                        }else {
                                            $videoFile = "../media/productVideos/$videoName";
                                            if (file_exists($videoFile)) {
                                                $videos .= "<button onclick=\"playVideo('$videoFile',false)\" class='btn btn-theme btn-theme' style='border-radius: 50%;width: 44px;height: 44px;font-size: 16px;padding-left: 14px;padding-top: 11px;'><i class='fa fa-play'></i></button> ";
                                            }
                                        }
                                    }
                                    $stm-> close();


                                    if($nonStock){
                                        $stock = 0;
                                        $useMaxStock = 0;
                                        $maxStockOfItem = 0;
                                        $denyOrderOverStock = true;
                                    }

                                    if($denyOrderOverStock && $maxStockLimit > 0 && $useMaxStock){
                                        if($maxStockOfItem > $maxStockLimit || $maxStockOfItem == 0){
                                            $maxStockOfItem = $maxStockLimit;
                                            $useMaxStock = true;
                                        }
//
                                    } else if ($denyOrderOverStock && !$useMaxStock && $maxStockLimit > 0) {
                                        if($stock > $maxStockLimit){
                                            $maxStockOfItem = $maxStockLimit;
                                            $useMaxStock = true;
                                        }
                                    } else {
                                        $maxStockOfItem = $stock;

                                    }

                                    $displayStock = '<table>';
                                    if($_SESSION['showStock'])
                                    {
                                        if(strcmp($numericStock,"yes")==0) {
                                            $label = $langu['product_available_stock'];
                                            $displayStock .= " <tr>
                                        <td class='title' style='color:#008080'>$label:</td>
                                        <td style='color:#008080;font-size:15px;font-weight:bold;'>$stock</td>
                                    </tr>";
                                        }
                                        else
                                        {
                                            if ($stock < $stockWarningQty && $stock > 0) {
                                                $label = $langu['product_available_stock'];
                                                $displayStock .= " <tr>
                                        <td class='title' style='color:#B98502FF'>$label :</td>
                                        <td style='color:#B98502FF;font-size:15px;font-weight:bold;'><span style='color: #B98502FF;font-weight:bold;display:inline-block;'><h6 style='height: 12px;width: 12px;background-color: #B98502FF;border-radius: 50%;display:inline-block;margin:-1px !important;margin-right: 0px !important;' class='dot'></h6> $stock</td>
                                    </tr>";
                                            } else if($stock>0)
                                            {
                                                $label = $langu['product_available_stock'];
                                                $displayStock .= " <tr>
                                        <td class='title' style='color:#008080'>$label :</td>
                                        <td style='color:#008080;font-size:15px;font-weight:bold;'><span style='height: 12px;width: 12px;background-color: #008080;border-radius: 50%;display:inline-block;' class='dot'></span></td>
                                    </tr>";
                                            }
                                            else
                                            {
                                                $label = $langu['product_out_of_stock'];
                                                $displayStock .= " <tr>
                                        <td class='title' style='color:#b22222'>$label:</td>
                                        <td style='color:#b22222;font-size:15px;font-weight:bold;'> <span style='height: 12px;width: 12px;background-color: #b22222;border-radius: 50%;display:inline-block;' class='dot'></span></td>
                                    </tr>";
                                            }

                                        }
                                    }
                                    $displayStock .= '</table>';

                                    if($nonStock){$stock = -1;}




                                $stockLabel = "<div class='pull-right' style='font-size: 18px;font-weight: bolder;margin-right: 30px;'>$displayStock</div>";

                                $priceLabel = "";
                                if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0 && $showPrices && $customerID!=0 && $showPrices && !$isB2CUser) {
                                    $priceLabel .= "<div>".$langu['column_price_label'] ."</div>";
                                }


                                $priceLabel .= '<div class="product-price">';
                                if($customerID!=0&&$showPrices) {
                                    $priceLabel .= "$price $PriceWithVatText";
                                } else if($showAnonymousPrices){
                                    $priceLabel .= "$price $PriceWithVatText";
                                }
                                $priceLabel .= '</div>';




                                if(isset($recommendedRetailPrice)&& $recommendedRetailPrice>0 && $showPrices && !$isB2CUser) {
                                    $recommendedRetailPriceDouble = getPriceFromPriceType($itemID, $recommendedRetailPrice);
                                    $recommendedRetailPriceDouble = number_format(floatval($recommendedRetailPriceDouble),2);

                                    if($showPricesWithVAT) {
                                        $vatPercentage = getVatPercentage($vatID);
                                        $priceWithVAT = (float)$recommendedRetailPriceDouble + (float)$recommendedRetailPriceDouble*($vatPercentage/100);
                                        $priceWithVAT = number_format(floatval($priceWithVAT),2);
                                        $inc = $langu['incl_label'];
                                        $vat = $langu['vat_label'];
                                        $recommendedPriceWithVatText = "&nbsp;<div  style='font-size:17px;color: #0aa66e '>($currencySign$priceWithVAT &nbsp;$inc $vat)</div>";
                                        if($includeVatOnPrice){
                                            $recommendedPriceWithVatText="&nbsp;<span  style='font-size:14px;color: #0aa66e '>*$inc $vat</span>";
                                            $recommendedRetailPriceDouble= $priceWithVAT;
                                        }
                                    }
                                    $recommendedRetailPriceLabel  = "<div style='margin-top: 4px;font-weight: bold;'>".$langu['recommended_retail_price'] ."</div>";
                                    $recommendedRetailPriceLabel .= "<div class=\"product-price\">$currencySign$recommendedRetailPriceDouble $recommendedPriceWithVatText</div>";

                                }




                                $customColumnsLabel = '';
                                foreach ($columns as $column) {
                                    if(strcmp($column['value'],'')!=0) {
                                        $customColumnsLabel .= "<tr style='padding: 0px 15px;'>
                                                                <td class='title' style='font-size: 18px;width: 1%;white-space: nowrap;' >" . $column['field'] . ": </td>
                                                                <td>" . $column['value'] . "</td>
                                                             </tr>";
                                    }
                                }

                                if(strcmp($customColumnsLabel,'')!=0){
                                    $customColumnsLabel = "$customColumnsLabel";
                                }



if($useMaxStock && $maxStockOfItem > 0 && $maxStockOfItem < $qty){
    $stockForError = "<input style='display:none;' type='hidden' id='max' value='$maxStockOfItem'>" ;
    $overMessage = "<span style='color: firebrick;font-weight:bolder;width: 100%;font-size:17px;margin-left:15px;display:inline-block;' class='insStock' id='maxError'>".$langu['insufficient_stock']."</span>";
} else if($denyOrderOverStock && $stock < $qty && $qty > 0) {
    $stockForError = "<input style='display:none;' type='hidden' id='max' value='$stock'>" ;
    $overMessage = "<span style='color: firebrick;font-weight:bolder;width: 100%;font-size:17px;margin-left:15px;display:inline-block;' class='insStock' id='maxError'>".$langu['insufficient_stock']."!</span>";
} else if(!$denyOrderOverStock){
    $stockForError = "" ;
    $overMessage = "";
} else if($denyOrderOverStock && $maxStockLimit > 0) {
    if($stock < $maxStockLimit){$maxStockLimit = $stock;}
    $stockForError = "<input style='display:none;' type='hidden' id='max' value='$maxStockLimit'>" ;
    $overMessage = "<span style='color: firebrick;font-weight:bolder;width: 100%;font-size:17px;margin-left:15px;display:none;' class='insStock' id='maxError'>".$langu['insufficient_stock']."!</span>";
}

if($customerID!=0 || $allowAnonymousOrder)
{

    if($usePackingOnItem){
        $packingAttr= "data-packing='$packing'";
    } else {
        $packingAttr='';
    }
    if($isInactive){
        $buyProductButton = "<h3>* ".$langu['product_not_available']."</h3>";
    } else {

        $uomQty = 0;
        if(true) {
            $itemUOMs = getItemUOMs($orderID,$itemID);
            if (!empty($itemUOMs)) {
                $itemUomElement = "<div style='height: 30px;margin-bottom:5px;'><select class='uom-element' style='display: inline-block;border: 2px solid $themeColor;border-radius: 3px;color: $themeColor;font-size: 18px;background-color: transparent;padding: 1px;' onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='transparent';this.style.color='$themeColor'\">";
                foreach ($itemUOMs as $uom) {
                    $itemUomElement .= "<option value='$uom->name' data-multiplier='$uom->multiplier' data-id='$uom->id' $uom->selected>$uom->name&nbsp;</option>";
                    $uomQty = $uom->qty;
                }
                $itemUomElement .= "</select></div>";
            } else {
                $itemUomElement = "<div style='height: 30px;'>
                                    <select class='uom-element pull-right' style='display: none;' >
                                        <option  value='' data-multiplier='1' data-id='0' selected></option>
                                    </select>
                                </div>";
            }
            if($uomQty > 0){$qty = $uomQty;}
        }

        if($enableAddToCartButtonOnFirstClick) {
            if ($qty > 0) {
                $hideAddButton = "display:none;";
                $hideButtonsDiv = "";
            } else {
                $hideAddButton = "";
                $hideButtonsDiv = "display:none;";
            }
            $addToCartButton = "<button type='button' class='btn btn-block btn-theme addButton' onclick='$(this).siblings(\"div.quantity\").show();$(\"#plusButtonSingleProduct\").click();$(this).hide();' style='text-transform: none !important;border-radius: 3px;width: 80%;min-width:fit-content;max-width:170px;padding:15px 10px;display:inline-block;margin-right:15px;$hideAddButton'><i class='fa fa-shopping-cart'></i>&nbsp;&nbsp; ".$langu['add_to_cart']."</button>";

        }
        $favoriteButton ="";
        if($favoritesShow) {
            if(intval($userID)!=0 && intval($customerID)!=0) {

                if ($isFavorite) {$iconColor = "color:red;-webkit-text-stroke:0px;";}
                else {$iconColor = "color:white;-webkit-text-stroke:1px black;";}

                $favoriteButton .= "<div id= 'favoriteText$itemID' onclick='updateFavorites($itemID);' style='color:black;display:inline-block;'>
                                        <i id ='favoriteIcon$itemID' class='fa fa-heart' style='vertical-align: middle;cursor:pointer;font-size:30px !important;$iconColor'></i> &nbsp; 
                                    </div>";
            }
        }

        $historyButton = "";
        if($historyShow) {
            if(intval($userID)!=0 && intval($customerID)!=0) {
                $historyButton = "<div  id='showHistoryModal' onclick='showOrderHistory($itemID);'  style='cursor:pointer;color:black;padding-top:15px;display:inline-block;padding-left:10px'>
                                    <i class='fa fa-history' style='vertical-align: middle;cursor:pointer;font-size:30px !important;'></i> &nbsp; 
                                  </div>";
            }
        }
        

        $buyProductButton = "<div class='buttons' style='margin-bottom: 15px;'>$itemUomElement$addToCartButton$favoriteButton$historyButton
                                    <div class='quantity' style='border: 2px solid $themeColor;border-radius: 5%;$hideButtonsDiv'>
                                        <button id='minusButtonSingleProduct' class='btn btn-theme btn-theme-transparent' style='display:inline-block;width:40px;height:45px;margin: 0px;padding:0px;font-weight:bolder;font-size:18px;border: 1px solid transparent;color:$themeColor;background-color: transparent'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='white';this.style.color='$themeColor'\" $packingAttr><i class='fa fa-minus'></i></button>
                                        <input id='productQtyInput' class='form-control qty' data-value='$itemID' style='display:inline-block;width:80px;height:45px;margin: 0px;text-align: center;font-weight:bolder;border: 3px solid transparent ;background-color:white;color:black;font-size:16px;border-radius: 15px;'  $packingAttr type='number' name='quantity' value='$qty' title='Qty'>
                                        <button id='plusButtonSingleProduct'  class='btn btn-theme btn-theme-transparent' style='display:inline-block;width:40px;height:45px;margin: 0px;padding:0px;font-weight:bolder;font-size:18px;border: 1px solid transparent;color:$themeColor;background-color: transparent'  onMouseOver=\"this.style.background='$themeColor';this.style.color='white'\"  onMouseOut=\"this.style.background='white';this.style.color='$themeColor'\" $packingAttr><i class='fa fa-plus'></i></button>
                                    </div>
                                   
                                </div>$overMessage$stockForError";
    }


}






                                $userID = $_SESSION['userID'];
                                if(strcmp($pageConfigJson,'')==0) {
                                    $pageConfigJson = '{
                                    "name":{"name":"name","visible_login":"yes","visible_logout":"yes","position":"1","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "category":{"name":"category","visible_login":"yes","visible_logout":"yes","position":"2","hide_Empty":"yes","show_label":"yes","show_box":"yes","primary_Language":"","alter_Language":""},
                                    "code":{"name":"code","visible_login":"yes","visible_logout":"yes","position":"3","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "sku":{"name":"sku","visible_login":"yes","visible_logout":"yes","position":"4","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "barcode":{"name":"barcode","visible_login":"yes","visible_logout":"yes","position":"5","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "packing":{"name":"packing","visible_login":"yes","visible_logout":"yes","position":"6","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "custom_form":{"name":"Custom Form","visible_login":"yes","visible_logout":"yes","position":"7","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "brochures":{"name":"brochures","visible_login":"yes","visible_logout":"yes","position":"8","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "videos":{"name":"videos","visible_login":"yes","visible_logout":"yes","position":"9","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "contract_prices":{"name":"Pricing","visible_login":"yes","visible_logout":"yes","position":"10","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "stock":{"name":"Stock","visible_login":"yes","visible_logout":"yes","position":"11","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "price":{"name":"Price","visible_login":"yes","visible_logout":"yes","position":"12","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "recommended_price":{"name":"Recommended Retail Price","visible_login":"yes","visible_logout":"yes","position":"13","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "short_description":{"name":"short description","visible_login":"yes","visible_logout":"yes","position":"14","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "button":{"name":"long description","visible_login":"yes","visible_logout":"yes","position":"15","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""},
                                    "long_description":{"name":"long description","visible_login":"yes","visible_logout":"yes","position":"16","hide_Empty":"yes","show_label":"yes","show_box":"no","primary_Language":"","alter_Language":""}
                                    }';
                                }

                                if($customerID > 0) {
                                    $itemNameString = getCustomerSynonym($customerID,$itemID,'name',$itemNameString);
                                    $itemCodeString = getCustomerSynonym($customerID,$itemID,'code',$itemCodeString);
                                }


                                $contractPricesPerQtyTable = getContractPricesPerQty($itemID,$customerID,$currencySign,$userID,$vatPercentage, $includeVatOnPrice);

                                $customElementsArray = array();
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'button','Button','',"$buyProductButton");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'name','Title','',"$itemNameString");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'category','Info',$categoryLabel,"$categoryName");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'code','Info',$langu['product_code'],"$itemCodeString");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'barcode','Info',$langu['product_barcode'],"$barcode");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'sku','Info','SKU',"$sku");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'brochures','Media','Brochures',"$brochures");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'videos','Media','Videos',"$videos");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'short_description','Paragraph','',"$shortDescription");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'long_description','Paragraph',$langu['product_details'],"$longDescription");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'recommended_price','Button','',"$recommendedRetailPriceLabel");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'price','Button','',"$priceLabel");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'custom_form','CustomRow','',"$customColumnsLabel");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'stock','Button','',"$stockLabel");
                                $customElementsArray = addElementToCustomizationArray($customElementsArray,'contract_prices','Paragraph','Pricing',"$contractPricesPerQtyTable");

                                $pageElements = json_decode($pageConfigJson);
                                $positionedElements = array();
                                $displayElements = '';



                                foreach ($pageElements as $key => $object){
                                    $positionedElements[(int)$object->position][$key] = $object;
                                }

                                ksort($positionedElements);

                                foreach($positionedElements as $pageElements) {

                                    foreach ($pageElements as $key => $object) {

                                        $object->value = $customElementsArray["$key"]['value'];
                                        $object->label = $customElementsArray["$key"]['label'];
                                        $object->type  = $customElementsArray["$key"]['type'];

                                        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0) {
                                            if(strcmp($object->alter_Language,'')!=0) {$object->label = $object->alter_Language;}
                                        } else {
                                            if(strcmp($object->primary_Language,'')!=0) {$object->label = $object->primary_Language;}
                                        }

                                        if($userID > 0){
                                            if(strcmp($object->visible_login,'no')==0){continue;}
                                        } else {
                                            if(strcmp($object->visible_logout,'no')==0){continue;}
                                        }

                                        if(strcmp($object->hide_Empty,'yes')==0 && strcmp(trim($object->value), '') == 0){continue;}

                                        if(strcmp($object->show_label,'no')==0){$object->label = '';}
                                        if(strcmp(trim($object->label), '') != 0) {$object->label .= ":";}


                                        switch ($object->type) {
                                            case 'Title':
                                                if(strcmp($object->show_box,'yes')==0){$object->value = "<p style='white-space: nowrap;padding: 7px 17px;text-align:center;border-radius:10px;color: $textColor;background-color: $themeColor;'>$object->value</p>";}

                                                global $isMobile;
                                                if($isMobile){$titleFontSize = "font-size: 25px;";}
                                                else {$titleFontSize = "font-size: 36px;";}

                                                $displayElement = "<tr>
                                                                       <td colspan='2' >
                                                                        <h1 class='product-title' style='font-weight: bolder;font-size: 36px;$titleFontSize'>
                                                                            $object->label $object->value
                                                                        </h1>
                                                                       </td>
                                                                   </tr>";
                                                break;
                                            case 'Paragraph':
                                                if(strcmp($object->show_box,'yes')==0){$object->value = "<p style='text-align:left !important;width:fit-content;white-space: nowrap;padding: 7px 17px;border-radius:10px;color: $textColor;background-color: $themeColor;'>$object->value</p>";}

                                                $displayElement = "<tr>
                                                                         <td colspan='2'>
                                                                             <hr class='page-divider' style='margin-bottom: 15px;margin-top: 15px;'/>
                                                                             <h4 style='color:black;font-size:24px;margin-top:0px;margin-bottom: 15px;'>
                                                                                $object->label
                                                                             </h4>
                                                                             <div>
                                                                                <span style='color:#222'>
                                                                                    $object->value
                                                                                </span>
                                                                             </div>
                                                                             <hr class='page-divider'  style='margin-bottom: 15px;margin-top: 15px;'/>
                                                                         </td> 
                                                                     </tr>";
                                                break;
                                            case 'Button':
                                                if(strcmp($object->show_box,'yes')==0){$object->value = "<div style='width:fit-content;white-space: nowrap;padding: 7px 17px;border-radius:10px;color: $textColor;background-color: $themeColor;'>$object->value</div>";}

                                                $displayElement = "<tr>
                                                                       <td colspan='2' >
                                                                            $object->value
                                                                       </td>
                                                                   </tr>";
                                                break;
                                            case 'CustomRow':
                                                if(strcmp($object->show_box,'yes')==0){$object->value = "<p style='width:fit-content;white-space: nowrap;padding: 7px 17px;text-align:center;border-radius:10px;color: $textColor;background-color: $themeColor;'>$object->value</p>";}

                                                $displayElement = "$object->value";
                                                break;
                                            case 'Media':
                                                if(strcmp($object->show_box,'yes')==0){$object->value = "<p style='width:fit-content;white-space: nowrap;padding: 7px 17px;text-align:center;border-radius:10px;color: $textColor;background-color: $themeColor;'>$object->value</p>";}

                                                $displayElement = "<tr>
                                                                       <td class='title' style='font-size: 18px;width:1%;white-space: nowrap;'>$object->label</td>
                                                                       <td style='padding: 5px 0px;'>$object->value</td>
                                                                   </tr>";
                                                break;
                                            default:
                                                if(strcmp($object->show_box,'yes')==0){
                                                    $object->value = "<span style='width:fit-content;white-space: nowrap;padding: 7px 17px;text-align:center;border-radius:10px;color: $textColor;background-color: $themeColor;'>$object->value</span>";
                                                    if(strpos($object->value,';|bubbleBreak|;')!==false){
                                                        $object->value = str_replace(';|bubbleBreak|;',"</span>&nbsp;&nbsp;<span style='width:fit-content;white-space: nowrap;padding: 7px 17px;text-align:center;border-radius:10px;color: $textColor;background-color: $themeColor;'>",$object->value);
                                                    }
                                                } else {
                                                    if(strpos($object->value,';|bubbleBreak|;')!==false){
                                                        $object->value = str_replace(';|bubbleBreak|;',"&nbsp;,&nbsp;&nbsp;",$object->value);
                                                    }
                                                }



                                                $displayElement = "<tr>
                                                                       <td class='title' style='font-size: 18px;width:1%;white-space: nowrap;'>$object->label</td>
                                                                       <td style='padding: 5px 0px;'>$object->value</td>
                                                                   </tr>";
                                                break;
                                        }

                                        $displayElements .= $displayElement;

                                    }

                                }

                                $resultHtml  = "<table style='width: 100%;'>";
                                $resultHtml .= $displayElements;
                                $resultHtml .="</table>";

                                echo $resultHtml;


                                ?>



                            </div>
                        </div>

                    </div>
                </section>
                <!-- /PAGE -->

                <!-- PAGE -->

                <?php

                    $label = $langu['related_products_label'];
                    echo" <section class='page-section'>
                    <div class='container'>
                        <h2 class='section-title section-title-lg'><span>$label</span></h2>
                        <div class='featured-products-carousel'>
                            <div class='owl-carousel' id='featured-products-carousel'>
                            </div>
                        </div>
                        <hr class='page-divider half'/>

                    </div>
                </section>";

                ?>

                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <?php
            if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
            if(strcmp($topmenu,"topMenu2.php")==0 || strcmp($topmenu,"topMenu3.php")==0) {
                echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: '.$textColor.';border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            } else {
                echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
            }

            ?>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/owl-carousel2/owl.carousel.min.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>
        <script src="assets/js/watermark.min.js"></script>


        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <script src="assets/js/waitMe.min.js"></script>
        <!--<![endif]-->

    <script>
        function showOrderHistory(itemID) {
            $.ajax({
                type: 'POST',
                url: './dbaccess/getItemHistory.php',
                data: { itemID: itemID},
                dataType: 'json',
                success: function (response) {

                    if(response) {
                        $("#showOrderHistoryModal .modal-body").html(response.body);
                        $("#showOrderHistoryModal .block-title").html(response.header);
                        $("#showOrderHistoryModal").modal("show");
                    }

                },
                error: function () {
                    console.log('error');
                }
            });
        }


        function updateFavorites(itemID) {
            $.ajax({
                type: 'POST',
                url: './dbaccess/updateFavorites.php',
                data: { itemID: itemID},
                success: function (response) {
                    var icon = $('#favoriteIcon' + itemID);
                    if (response === "1") {
                        icon.css('color', 'red').css('-webkit-text-stroke', '0px');
                    } else if (response === "0") {
                        icon.css('color', 'white').css('-webkit-text-stroke', '1px black');
                    }
                },
                error: function () {

                }
            });

        }

        jQuery(document).ready(function () {

            initThemeParameters();

            <?php

            $stm = $db->prepare("SELECT related_item_id FROM Related_Items WHERE item_id='$itemID' ORDER BY related_item_id DESC LIMIT 1");
            $stm-> execute();
            $stm-> bind_result($relatedTableCheck);
            while ($stm->fetch()) {}
            $stm-> close();

            if($relatedTableCheck > 0){
                echo "getItemRelatedItems($itemID);";
            } else {
                echo "getRelatedItems($('#relatedCategory').val());";
            }

            ?>

            addButtonListenersProductDetails();
            setItemsCartCounter();
            assignTrigger(0);

            var owlCarousel = $('.img-carousel-manual').owlCarousel({loop: false,responsive: { 0: {items: 1}}});
            owlCarousel.trigger('refresh.owl.carousel');

            <?php
            if($addWatermark) {


                echo $watermarks;
            }
            ?>

        });

        function playVideo(src, youtube){
            if(youtube){
                $('#divVideo').hide();
                $('#divYoutube').show();

                $('#youtubePlayer').attr('src', '');
                $('#youtubePlayer').attr('src', src);
                $('#video-modal').modal('toggle');
                $('#video-modal').on('hidden.bs.modal', function () {
                    $('#youtubePlayer').attr('src', '');
                });
            } else {
                $('#divYoutube').hide();
                $('#divVideo').show();

                $('#divVideo video source').attr('src', '');
                $('#divVideo video source').attr('src', src);
                $("#divVideo video").load();
                $('#video-modal').modal('toggle');
                $('#video-modal').on('hidden.bs.modal', function () {
                    $('#divVideo video source').attr('src', '');
                    $("#divVideo video").load();
                });
            }
        }

        function assignTrigger(start)
        {
            $('.img-carousel-manual').trigger('to.owl.carousel', [start, 300]);
            $('.thm').css('border', '2px solid lightgrey');
            $('#thm'+start).css('border', '2px solid <?php echo $themeColor; ?>');
        }

        function setItemsCartCounter()
        {
            $("#modalCartButtonText").html( $('#cartCounter').val());
        }

    </script>

    </body>
</html>