<?php
include_once("headerImports.php");
include_once("../param.php");

global $username,$password,$database;
$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT allow_anonymous,css_theme,theme,footer,primary_language FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($anonymous,$cssTheme,$themeColor,$footerLabel,$primaryLanguage);

while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
    $topmenu = "topMenu$cssTheme.php";
    $themeColor = strtolower($themeColor);
}
$stm-> close();

if(strcmp($themeColor,'')!=0){
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
        $themeColor = "firebrick";
    }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    }  else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
        $themeColor = "goldenrod";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
        $themeColor = "black";
        $textColor = "white";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }

} else {
    $themeColor = "#6796d3";
}



// ----------- LOGIN ------------
if(!isset($_SESSION['lang']))
{
    $_SESSION['lang'] = 'en';
}
if(isset($_SESSION['B2C']))
{
    $isB2C =  $_SESSION['B2C'];
}
if(file_exists('../langs/'.$_SESSION['lang'].'.php')) {
    include('../langs/' . $_SESSION['lang'] . '.php');
}
$loginTitle = $langu['login_page_login_title'];
$welcomeMessage = $langu['login_page_welcome_text'];
$usernameHint = $langu['login_page_username_hint'];
$passwordHint = $langu['login_page_password_hint'];
$loginButton = $langu['login_page_login_button'];
$registerButton = $langu['login_page_register_button'];

$loginModal = '<div class="container" style="margin:15px;padding: 15px;">
                        <div class="row">
                            <div class="col-sm-6  col-md-offset-3 col-sm-offset-3" style="background-color: white;padding: 20px;">
                                <h3 class="block-title"><span class="pull-left">'.$loginTitle.'</span></h3>
                                <form method="POST" action="./dbaccess/b2b_login.php" class="form-login" id="formLogin">
                                    <div class="row">
                                        <div class="col-md-12 hello-text-wrap">
                                            <span class="hello-text text-thin pull-left">'.$welcomeMessage.'</span>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group"><input name="username" class="form-control" type="text" placeholder="'.$usernameHint.'"></div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group"><input name="password" class="form-control" type="password" placeholder="'.$passwordHint.'"></div>
                                        </div>
                                        <div class="col-md-12" style="display: none">
                                            <div class="form-group"><input name="promoID" id="loginPromoID" class="form-control" type="hidden"></div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group pull-left"> <a href="forgotpassword.php" target="_blank">  Forgot password?</a></div>
                                        </div>
                                        <div class="col-md-6 " align="right">
                                            <button type="button" class="btn btn-theme btn-block " onclick="loginQuestionNoButtonPressed();">'.$registerButton.'</button>
                                        </div>
                                        <div class="col-md-6 ">
                                              <input type="button" class="btn btn-theme btn-block" href="#" onclick="rememberMe();" value="'.$loginButton.'"/>
                                        </div>  
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>';

// ============= REGISTER -------------
$stm = $db->prepare("SELECT customer_activation_method FROM B2C_Configuration LIMIT 1");
$stm-> execute();
$stm-> bind_result($activationMethod);
while ($stm->fetch()) {}
$stm-> close();

$registerButton = $langu['login_page_register_button'];
$registerTitle  = $langu['login_page_register_button'];
$companyNameTitle  = $langu['company_name_title'];
$firstNameTitle  = $langu['first_name_title'];
$lastNameTitle  = $langu['last_name_title'];
$phoneTitle  = $langu['phone_number_title'];
$emailTitle  = $langu['email_title'];
$cityTitle  = $langu['city_title'];
$areaTitle  = $langu['area_title'];
$streetTitle  = $langu['street_address_title'];
$postCodeTitle  = $langu['postcode_title'];
$enterPassTitle  = $langu['enter_password_title'];
$confirmPassTitle  = $langu['confirm_password_title'];
$countryTitle = $langu['country_title'];
$invalidEmailHint = $langu['invalid_email_hint'];
$emailExistsHint = $langu['email_exists_hint'];
$passMismatch = $langu['Password_mismatch'];
$companyExistsHint = $langu['company_exists_hint'];
$passRequirementsHint = $langu['password_requirements_hint'];
$userInfoTitle = $langu['user_info_title'];
$userAddressTitle =  $langu['user_address_title'];
$userPasswordTitle =  $langu['user_password_title'];
$confirmationNotice = $langu['account_created_notice'];
$activationNotice = $langu['email_activation_notice'];
$followLinkNotice = $langu['follow_link_notice'];
$loginButton = $langu['login_page_login_button'];
$accountActivatedTitle = $langu['account_active_notice'];
$contactUsNoEmail = $langu['no_email_contact_notice'];
$contactForActivation = $langu['contact_us_for_activation'];
$findActivationEmail = $langu['find_activation_email_notice'];
$accountInactive = $langu['account_inactive_notice'];
$contactUsButton = $langu['contact_us_title_label_left'];
$resendEmail = $langu['resend_email'];
$findAddressHint = $langu['find_your_location'];

$requiredFieldTitle   = "<i class='fa fa-asterisk' style='color: #d68170;font-size: 12px;'>&nbsp;".$langu['required_field_notice']."</i>";
$loginRedirection     = " <button type='button' class='btn btn-theme btn-block ' onclick='loginRedirect()'>$loginButton</button>";
$contactUsRedirection = " <button type='button' class='btn btn-theme btn-block ' onclick='contactUsRedirect()'>$contactUsButton</button>";

if(strcmp($activationMethod,'contact')!=0) {
    $resendEmail = "<button type='button' class='btn btn-theme btn-block ' onclick='resendEmail()'>$resendEmail</button>";
    $inactiveBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$accountInactive</h2><br>$findActivationEmail<br>$contactUsNoEmail</center><br><br>$contactUsRedirection $resendEmail</div>";

} else {
    $inactiveBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$accountInactive</h2><br>$contactForActivation</center><br><br>$contactUsRedirection</div>";

}

$confirmationBox = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$confirmationNotice</h2><br>$activationNotice<br>$followLinkNotice</center><br><br>$loginRedirection</div>";
$activeBox       = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$accountActivatedTitle</h2><br></center><br><br>$loginRedirection</div>";
$contactBox      = "<div class='block-title' align='center' style='font-weight: bold;text-transform: initial'><center><h2>$confirmationNotice</h2><br>$contactForActivation</center><br><br>$contactUsRedirection</div>";


$registerModal = '<div class="container">
                <div class="row">
                    <div class="col-sm-9 col-md-offset-2 " id="registrationForm" style="background-color: white;padding: 20px;">
                        <h3 class="block-title"><span class="pull-left">'.$userInfoTitle.'</span></h3>
                            <div class="row">

                                <div class="col-md-12"><span class="pull-left">&nbsp;&nbsp;'.$companyNameTitle.'</span>
                                    <div class="form-group"><span id="companyNameHint" class="pull-right" style="font-size: 15px;font-weight: bold"></span><input name="companyName" id="companyName" class="form-control" type="text" placeholder="'.$companyNameTitle.'"></div>

                                    <div class="form-group">
                                        <table style="width: 100%">
                                            <tr>
                                                <td>
                                                    <span class="pull-left">&nbsp;&nbsp;'.$firstNameTitle.' '.$requiredFieldTitle.'</span>
                                                    <input name="firstName" id="firstName" class="form-control" type="text" placeholder="'.$firstNameTitle.'" required>
                                                </td>
                                                <td style="width: 2%;"> </td>
                                                <td>
                                                    <span class="pull-left">&nbsp;&nbsp;'.$lastNameTitle.' '.$requiredFieldTitle.'</span>
                                                    <input name="lastName" id="lastName" class="form-control" type="text" placeholder="'.$lastNameTitle.'" required>
                                                 </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class="form-group">
                                        <span class="pull-left">&nbsp;&nbsp;'.$phoneTitle.' '.$requiredFieldTitle.'</span>
                                        <input name="phone" id="phone" class="form-control" type="number" placeholder="'.$phoneTitle.'" required>
                                    </div>

                                    <div class="form-group">
                                        <span class="pull-left">&nbsp;&nbsp;'.$emailTitle.' '.$requiredFieldTitle.'</span>
                                        <span id="emailHint" class="pull-right" style="font-size: 15px;font-weight: bold"></span>
                                        <input name="email" id="email" class="form-control" type="email" placeholder="'.$emailTitle.'" required>
                                    </div>

                                    <br><h3 class="block-title">
                                    <span class="pull-left">'.$userAddressTitle.'</span></h3>
                                    <span class="pull-left">&nbsp;&nbsp;'.$findAddressHint.'</span><br>
                                    <input id="search" class="controls form-control" type="text" placeholder="Search for address" style="height: 35px;font-weight: bold">
                                    <div class="google_maps" style="height:220px;margin-bottom:10px;" id="map" ></div>

                                    <div class="form-group">
                                        <span class="pull-left">&nbsp;&nbsp;'.$countryTitle.'</span>
                                        <select name="country" id="country" class="form-control" required>
                                            <option selected>Cyprus</option>
                                        </select>
                                    </div>

                                    <div class="form-group">
                                        <table style="display: none;">
                                            <tr>
                                                <td>

                                                    <input name="lat" id="lat" class="form-control" type="number" placeholder="Lat" value="" >
                                                </td>
                                                <td style="width: 2%"></td>
                                                <td>

                                                    <input name="lng" id="lng" class="form-control" type="number" placeholder="Lng" value="">
                                                </td>
                                            </tr>
                                        </table>
                                        <table style="width: 100%">
                                            <tr>
                                                <td>
                                                    <span class="pull-left">&nbsp;&nbsp;'.$cityTitle.' '.$requiredFieldTitle.'</span>
                                                    <input name="city" id="city" class="form-control" type="text" placeholder="'.$cityTitle.'" required>
                                                </td>
                                                <td style="width: 2%"></td>
                                                <td>
                                                    <span class="pull-left">&nbsp;&nbsp;'.$areaTitle.'</span>
                                                    <input name="area" id="area" class="form-control" type="text" placeholder="'.$areaTitle.'">
                                                </td>
                                            </tr>
                                        </table>
                                    </div>

                                    <div class="form-group"><span class="pull-left">&nbsp;&nbsp;'.$streetTitle.' '.$requiredFieldTitle.'</span><input name="streetAddress" id="streetAddress" class="form-control" type="text" placeholder="'.$streetTitle.'" required></div>

                                    <div class="form-group"><span class="pull-left">&nbsp;&nbsp;'.$postCodeTitle.' '.$requiredFieldTitle.'</span><input name="postcode" id="postcode" class="form-control" type="number" placeholder="'.$postCodeTitle.'" required></div>

                                    <br><h3 class="block-title"><span class="pull-left">&nbsp;&nbsp;'.$userPasswordTitle.'</span></h3>

                                    <div class="form-group"><span class="pull-left">&nbsp;&nbsp;'.$enterPassTitle.' '.$requiredFieldTitle.'</span><span id="passHint" class="pull-right" style="font-size: 15px;font-weight: bold"></span><input name="password" id="password" class="form-control" type="password" placeholder="'.$enterPassTitle.'" required></div>

                                    <div class="form-group"><span class="pull-left">&nbsp;&nbsp;'.$confirmPassTitle.' '.$requiredFieldTitle.'</span><input name="passwordConfirmation" id="passwordConfirmation" class="form-control" type="password" placeholder="'.$confirmPassTitle.'" required></div>
                                    <div class="form-group"><input name="promoID" id="promoID" class="form-control" type="hidden"></div>
                                </div>

                                <div class="col-md-6 col-md-offset-3">
                                    <input type="button" class="btn btn-theme btn-block" onclick="validateRegistration()" value="'.$registerButton.'"/>
                                </div>
                                

                            </div>
                    </div>
                </div>
            </div>
            
            <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyAonEryABOdRQBcgEfH51-nOoXTca3XlWs&language=en&callback=initAutocomplete&libraries=places&v=weekly" async></script>
            <script>
                let map;
                let service;
                let infowindow;
                
                 function initAutocomplete()
                 {   
                    var map = new google.maps.Map(document.getElementById(\'map\'), {
                        center: {lat: 34.92, lng: 33.63},
                        zoom: 13,
                        mapTypeId: "roadmap",
                        // mapTypeControl: false,
                        disableDefaultUI: true,
                    });
            
                    var input = document.getElementById(\'search\');
                    map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
            
                    var autocomplete = new google.maps.places.Autocomplete(input);
                    autocomplete.bindTo(\'bounds\', map);
            
                    var infowindow = new google.maps.InfoWindow();
            
                    if (navigator.geolocation) {
                        navigator.geolocation.getCurrentPosition(
                            (position) => {
                                const pos = {
                                    lat: 34.92, 
                                    lng: 33.63
                                };
            
                                map.setCenter(pos);
                            },
                            () => {
                                handleLocationError(true, infowindow, map.getCenter());
                            }
                        );
                    }
            
                    var marker = new google.maps.Marker({
                        map: map,
                        anchorPoint: new google.maps.Point(0, -29),
                        draggable: true,
                    });
                    
            
            
                    autocomplete.addListener(\'place_changed\', function () {
                        infowindow.close();
                        marker.setVisible(false);
                        var place = autocomplete.getPlace();
                        if (!place.geometry) {
                            window.alert("Autocomplete\'s returned place contains no geometry");
                            return;
                        }
            
                        if (place.geometry.viewport) {
                            map.fitBounds(place.geometry.viewport);
                        } else {
                            map.setCenter(place.geometry.location);
                            map.setZoom(17);
                        }
            
                        marker.setPosition(place.geometry.location);
                        marker.setVisible(true);
                        var location = place.geometry.location;
            
                        $(\'#lat\').val(location.lat());
                        $(\'#lng\').val(location.lng());
                        fillInAddress();
                    });
            
                    marker.addListener(\'mouseout\', function () {
                        var newLat = marker.getPosition().lat();
                        var newLng = marker.getPosition().lng();
                        $(\'#lat\').val(newLat);
                        $(\'#lat\').trigger(\'change\');
                        $(\'#lng\').val(newLng);
                        $(\'#lng\').trigger(\'change\');
                    });
            
                    function fillInAddress() {
                        var componentForm = {
                            street_number: \'short_name\',
                            route: \'long_name\',
                            locality: \'long_name\',
                            administrative_area_level_1: \'short_name\',
                            postal_code: \'short_name\',
                            country: \'long_name\'
                        };
            
                        var place = autocomplete.getPlace();
            
                        for (var i = 0; i < place.address_components.length; i++) {
            
                            var addressType = place.address_components[i].types[0];
                            if (componentForm[addressType]) {
            
                                if (addressType == \'street_number\') {
                                    var streetNumber = place.address_components[i][componentForm[addressType]];
                                }
            
                                if (addressType == \'route\') {
                                    var route = place.address_components[i][componentForm[addressType]];
                                }
            
                                if (addressType == \'locality\') {
                                    var locality = place.address_components[i][componentForm[addressType]];
                                }
            
                                if (addressType == \'administrative_area_level_1\') {
                                    var state = place.address_components[i][componentForm[addressType]];
                                }
            
                                if (addressType == \'postal_code\') {
                                    var zipcode = place.address_components[i][componentForm[addressType]];
                                }
                                if (addressType == \'country\') {
                                    var country = place.address_components[i][componentForm[addressType]];
                                }
            
                            }
            
                        }
            
                        if (streetNumber == null) {
                            streetNumber = \'\';
                        }
                        if (route == null) {
                            route = \'\';
                        }
                        if (locality == null) {
                            locality = \'\';
                        }
                        if (state == null) {
                            state = \'\';
                        }
                        if (zipcode == null) {
                            zipcode = \'\';
                        }
                        if (country == null) {
                            country = \'\';
                        }
            
                        $(\'#streetAddress\').val(streetNumber + \' \' + route)
                        $(\'#city\').val(state)
                        $(\'#area\').val(locality)
                        $(\'#postcode\').val(zipcode)
            
                        var o = new Option(country, country);
                        $(o).html(country);
                        $("#country").append(o);
                        $("#country").val(country);
                        $("#country").trigger(\'change\');
                        $(\'#search\').val(\'\');
                    }
        
                 }
            </script>
            ';

// -------- LOGIN AND REGISTER MODAL ---------------------

$loginIframe = "     <b style='color:$themeColor;'>
                        <center>
                        <div id='loginQuestionDiv'>
                        <table >
                            <tr>
                                <td colspan='3'>
                                    <center>
                                        <br>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <td colspan='3'>
                                    <center>
                                        <span style='font-family: Helvetica; font-size: 3.5vw;'>Are you a Registered User?</span><br><br>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <td>
                                    <center>
                                        <button type='button' class='btn btn-theme' onclick='loginQuestionYesButtonPressed();' style='padding-top:7px;padding-bottom:7px;padding-left: 30px;padding-right: 30px;font-size: 2.0vw;' ><b>YES</b></button>
                                    </center>
                                </td>
                                <td>
                                    <center>
                                        <button type='button' class='btn btn-theme' onclick='loginQuestionNoButtonPressed();' style='padding-top:7px;padding-bottom:7px;padding-left: 30px;padding-right: 30px;font-size: 2.0vw;' ><b>NO</b></button>
                                    </center>
                                </td>
                            </tr>
                            <tr>
                                <td colspan='3'>
                                    <center>
                                        <br>
                                    </center>
                                </td>
                            </tr>
                            
                        </table>
                        </div>
                        <br>
                        <div id='loginDiv' style='display: none;'>
                        $loginModal
                        </div>
                         <div id='registerDiv' style='display: none;'>
                        $registerModal
                        </div>
                        </center>
                    </b>
                    ";

$promoExpiredIframe = "<center><br><span style='font-family: Helvetica; font-size: 3.5vw;line-height: 1;color:$themeColor;'>We are really sorry..<br>This promotion has Expired.</span><br><br> </center>";

?>


<body id="home" class="wide">
<!-- PRELOADER -->
<div id="preloader">
    <div id="preloader-status">
        <div class="spinner">
            <div class="rect1"></div>
            <div class="rect2"></div>
            <div class="rect3"></div>
            <div class="rect4"></div>
            <div class="rect5"></div>
        </div>
        <div id="preloader-title">Loading</div>
    </div>
</div>
<!-- /PRELOADER -->

<!-- WRAPPER -->
<div class="wrapper">


    <div class="content-area" style="margin-bottom: 0px;padding-bottom: 0px;">
        <?php
         $promoName = '';
         $sliders = array();
         $today = date('Y-m-d H:i:s');
         $promoUrlCode = trim($_GET['promo']);
         $stm = $db->prepare("SELECT slider_number,COUNT(featured_id),featured_title,featured_text,featured_image_url,featured_width,featured_height,featured_link_url,iframe FROM B2B_Promotion_Page WHERE active ='yes' AND valid_from <= '$today' AND valid_until >= '$today' AND featured_code='$promoUrlCode' GROUP BY slider_number ORDER BY slider_number ASC");
         $stm->execute();
         $stm->bind_result($sliderNumber, $countImages,$featured_title, $featured_text, $featured_image_url,$sliderWidth,$sliderHeight,$featured_link_url,$iframe);
         while ($stm->fetch()) {
             $slider = new stdClass();
             $slider->number = $sliderNumber;
             $slider->imagesCount = $countImages;

             if(strcmp($iframe,'login')==0){
                 if(strcmp($featured_link_url,'')!=0) {
                     $promoName=$featured_link_url;
                     global $username,$password,$database;
                     $db2 = new mysqli('localhost',$username,$password,$database);
                     if (mysqli_connect_errno()) {
                         printf("Connect failed: %s\n", mysqli_connect_error());
                         exit();
                     }
                     $promoRedeemID = 0;
                     $db2->set_charset("utf8");
                     $stm2 = $db2->prepare("SELECT promotion_id,type FROM Promotions WHERE (description IS null OR description = '') AND valid_from <= NOW() AND valid_until >= NOW() AND status = 'yes' AND promotion_name='$featured_link_url' ORDER BY promotion_code ASC LIMIT 1");
                     $stm2->execute();
                     $stm2->bind_result($promoRedeemID,$promoType);
                     while ($stm2->fetch()) {}
                     $stm2->close();
                     if($promoType == 9){
                         $promoLabel = 'enter';
                         $promoLabelLogin = "Login to enter $featured_link_url!";
                         $promoLabelRegister = "Fill in the registration form and enter<br>$featured_link_url!";
                     } else {
                         $promoLabelLogin = "Login to receive $featured_link_url<br>on your next online order!";
                         $promoLabelRegister = "Fill in the registration form and receive<br>$featured_link_url on your next online order!";
                     }
                     if($promoRedeemID > 0) {
                         $featured_text = $loginIframe;
                         $featured_text .= "<script>
                                                function loginQuestionYesButtonPressed(){
                                                    $('#loginQuestionDiv').html('<center><br><span style=\"font-family: Helvetica; font-size: 3.5vw;line-height:1\">$promoLabelLogin</span></center>');
                                                    $('#loginDiv').show();
                                                    $('#registerDiv').hide();
                                                    $('#promoID').val('$promoRedeemID');
                                                    $('#loginPromoID').val('$promoRedeemID');
                                                    $('html, body').animate({
                                                        scrollTop: $(\"#loginQuestionDiv\").offset().top
                                                    }, 500);
                                                }
                                                function loginQuestionNoButtonPressed(){
                                                    $('#loginQuestionDiv').html('<center><br><span style=\"font-family: Helvetica; font-size: 3.5vw;line-height:1\">$promoLabelRegister</span></center>');
                                                    $('#loginDiv').hide();
                                                    $('#registerDiv').show();
                                                    $('#promoID').val('$promoRedeemID');
                                                    $('#loginPromoID').val('$promoRedeemID');
                                                    $('html, body').animate({
                                                        scrollTop: $(\"#loginQuestionDiv\").offset().top
                                                    }, 500);
                                                }
                                            </script>";

                         if(isset($_GET['wlg']) && strcmp($_GET['wlg'],'y')==0){
                             $invalidLoginFlag = "loginQuestionYesButtonPressed();";
                         }
                     } else {
                         $featured_text = $promoExpiredIframe;
                     }
                 }
             }

             if(strcmp($featured_link_url,'')!=0 && strcmp($iframe,'') == 0){
                 $slider->staticImage = "<a href='$featured_link_url' ><img class='slide-img' src='assets/promoslider/$featured_image_url' alt=''  style='height: $sliderHeight;width: $sliderWidth;'/><div class='mainslidersection slide-img'  style='background-image: url(\"assets/promoslider/$featured_image_url\");background-size: 100% 100%;height: $sliderHeight;width: $sliderWidth;padding: 0px !important;margin-bottom: 0px !important;font-size: 2.5vw !important;'><div class='caption-content' >$featured_text</div></div></a>";
             } else if(strcmp($iframe,'') != 0){
                 $slider->staticImage = "<div style='text-align: center;width: 100%;background-image: url(\"assets/promoslider/$featured_image_url\");' id='loginRegisterDiv'>$featured_text</div>";
             } else {
                 $slider->staticImage = "<div style='position: relative;' style='height: $sliderHeight;width: $sliderWidth;'><img class='slide-img' src='assets/promoslider/$featured_image_url' alt=''  style='height: $sliderHeight;width: $sliderWidth;'/><div style='position: absolute;top:0px;left: 0px;height: auto;width: 100%;padding: 10px;font-size: 2.5vw !important;'>$featured_text</div></div>";
             }
             array_push($sliders,$slider);
         }
         $stm->close();

         if(count($sliders)==0){header('Location: index.php');}

         foreach($sliders AS $slider) {
             if($slider->imagesCount >= 2) {

                 echo "<section class='page-section no-padding slider mainslidersection  main-content-section' style='margin: 0px;'>
                            <div class='container full-width'>
                            <div class='main-slider' >
                            <div class='owl-carousel main-slider-box' id='main-slider-$slider->number'>";

                 $stm = $db->prepare("SELECT featured_id,featured_code,featured_title,featured_text,featured_image_url,featured_width,featured_height,featured_link_url,iframe FROM B2B_Promotion_Page WHERE slider_number ='$slider->number' AND featured_code='$promoUrlCode' AND active ='yes' ORDER BY position ASC");
                 $stm->execute();
                 $stm->bind_result($featured_id, $featured_code, $featured_title, $featured_text, $featured_image_url,$sliderWidth,$sliderHeight,$featured_link_url,$iframe);
                 while ($stm->fetch()) {
                     if (strcmp($featured_link_url, '') != 0 && strcmp($iframe,'') == 0) {
                         echo "<a href='" . $featured_link_url . "' >";
                     }
                     if (strcmp($featured_title, '') != 0 || strcmp($featured_text, '') != 0) {
                         $dark = "";
                     } else {
                         $dark = "";
                     }

                     if(strcmp($iframe,'login')==0){
                         $featured_text = $loginIframe;
                     }

                                            echo "
                                                <div class='item slide3 $dark' >
                                                    <center>
                                                    <img class='slide-img' src='assets/promoslider/$featured_image_url' alt=''  style='height: $sliderHeight;width: $sliderWidth;'/>
                                                    </center>
                                                    <div class='caption'>
                                                    $featured_text
                                                    </div>
                                                </div>
                                                  ";
                     if (strcmp($featured_link_url, '') != 0) {
                         echo "</a>";
                     }
                 }
                 $stm->close();

                 echo "</div>
                       </div>
                       </div>
                       </section>";

             } else if ($slider->imagesCount == 1) {
                 echo $slider->staticImage;
             }
         }
        ?>
    </div>






<!-- FOOTER -->
<?php
if(strcmp($footerLabel,'')==0){$footerLabel = 'Powered by Coprime - 25311504';}
if(strcmp($topmenu,"topMenu2.php")==0 || strcmp($topmenu,"topMenu3.php")==0) {
    echo '<footer class="footer" style="border: 0px;" >
                            <div class="footer-meta footer-custom" style="background: linear-gradient(to bottom, white  0%, whitesmoke 5%, '.$themeColor.' 15%);border: 0px;">
                                <div class="container" style="width: 100%" >
                                    <div class="row" >
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" style="color: whitesmoke;border-color: transparent">
                                                 '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
} else {
    echo '<footer class="footer">
                            <div class="footer-meta footer-custom">
                                <div class="container">
                                    <div class="row">
            
                                        <div class="col-sm-6 footer-copyright-outer" >
                                            <div class="copyright footer-copyright-text" >
                                                '.$footerLabel.'
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </footer>';
}
?>
<!-- /FOOTER -->

<div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

</div>
<!-- /WRAPPER -->

<!-- JS Global -->
<script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="assets/plugins/superfish/js/superfish.min.js"></script>
<script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
<script src="assets/plugins/owl-carousel2/owl.carousel.min.js"></script>
<script src="assets/plugins/jquery.sticky.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.smoothscroll.min.js"></script>
<script src="assets/plugins/smooth-scrollbar.min.js"></script>
<script src="assets/plugins/jsencrypt/bin/jsencrypt.min.js"></script>

<!-- JS Page Level -->
<script src="assets/js/theme.js"></script>

<!--[if (gte IE 9)|!(IE)]><!-->
<script src="assets/plugins/jquery.cookie.js"></script>
<script src="assets/js/waitMe.min.js"></script>


<script>
    //  -------- LOGIN FUNCTIONS -----------



    function rememberMe(){
        var encrypt = new JSEncrypt();
        encrypt.setPublicKey('MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDu22a3sQheNF31dOKgWxOD26u8\n' +
            'yNZDAtiPL1DdsiCYoqBvIoFjuMnTdfjPxjSVxuG110HtQ5jxPdy6IoeKgQYZ3yFF\n' +
            'NOTbctobZOO/szk6epNjaPU6MPR037wQb6ixB0v6YLJEjupHs/yxNx3JYmUl+9n5\n' +
            'rWW7W8jwX/fFXk6VaQIDAQAB');
        var pagingData = encrypt.encrypt($('input[name="password"]').val());
        var pageIndex = encrypt.encrypt($('input[name="username"]').val());
        document.cookie = "pageIndex="+pageIndex;
        document.cookie = "pagingData="+pagingData;

        $.ajax({
            type: 'POST',
            url: './dbaccess/getNextValidPromoCode.php',
            data: {
                'promo': '<?php echo $promoName;?>'
            },
            success: function (result) {
                if(result > 0){
                    $('#promoID').val(result);
                    $('#loginPromoID').val(result);
                    $('#formLogin').submit();
                } else {
                    $('#loginRegisterDiv').html("<?php echo $promoExpiredIframe; ?>");
                }
            }
        });

    }

    //  -------- LOGIN FUNCTIONS -----------

    function resendEmail(){
        var resend = true;
        var customerID = "<?php echo trim($_GET['token']);?>";
        var email = "<?php echo trim($_GET['mail']);?>";
        $.ajax({
            type: "POST",
            url: './dbaccess/b2c_register.php',
            data: {
                'resend': resend,
                'email': email,
                'customerID': customerID
            },
            success: function (result) {
                window.location.href = "login.php";
            }
        });
    }

    function contactUsRedirect() {window.location.href = "contact.php";}

    function loginRedirect(){window.location.href = "login.php";}

    function scrollIntoView(element){

        var offset = $(element).offset();

        offset.left -= 20;
        offset.top -= 80;

        $('html, body').animate({
            scrollTop: offset.top,
            scrollLeft: offset.left
        });
    }

    function ValidateEmail(mail) {
        if (/^\w+([\.-]?\w+)*@\w+([\.-]?\w+)*(\.\w{2,3})+$/.test(mail))
        {
            return (true)
        }
        return (false)
    }

    function ValidatePassword(pass,passConfirm) {
        if(/^(?=.*\d)(?=.*[a-z])(?=.*[A-Z]).{6,20}$/.test(pass))
        {
            if (pass == passConfirm) {
                return true;
            } else {
                $('#password').css("color", "firebrick");
                $('#passwordConfirmation').css("color", "firebrick");
                $('#passHint').css("color", "firebrick").html('<?php echo $passMismatch?>');
                scrollIntoView('#passHint');
            }
        }
        else
        {

            $('#passHint').css("color", "firebrick").html('<?php echo $passRequirementsHint?>');
            scrollIntoView('#passHint');
            return false;
        }
    }

    function validateRegistration(){

        $("input").css("border-color", "");
        $('#emailHint').css("color", "").html('');
        $('#passHint').css("color", "").html('');
        $('#companyNameHint').css("color", "").html('');

        var companyName          = $('#companyName').val();
        var email                = $('#email').val();
        var password             = $('#password').val();
        var passwordConfirmation = $('#passwordConfirmation').val();

        var validation           = true;
        var scrolled             = false;

        if(validation) {
            if (!$('#companyName').val()) {}
            else {
                $.ajax({
                    type: "POST",
                    url: './dbaccess/b2c_company_validation.php',
                    data: {'companyName': companyName},
                    success: function (result) {
                        if (result != 0) {
                            $('#companyName').css("border-color", "firebrick");
                            $('#companyNameHint').css("color", "firebrick").html('<?php echo $companyExistsHint?>');
                            scrollIntoView('#companyName');
                            validation = false;
                            if (!scrolled) {
                                scrolled = true;
                                scrollIntoView('#companyName');
                            }
                        }
                    }
                });
            }
            if (!$('#firstName').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#firstName');
                }
                validation = false;
                $('#firstName').css("border-color", "firebrick");
            }
            if (!$('#lastName').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#lastName');
                }
                validation = false;
                $('#lastName').css("border-color", "firebrick");
            }
            if (!$('#phone').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#phone');
                }
                validation = false;
                $('#phone').css("border-color", "firebrick");
            }
            if (!$('#email').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#email');
                }
                validation = false;
                $('#email').css("border-color", "firebrick");
            }
            if (!$('#country').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#country');
                }
                validation = false;
                $('#country').css("border-color", "firebrick");
            }
            if (!$('#city').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#city');
                }
                validation = false;
                $('#city').css("border-color", "firebrick");
            }
            if (!$('#streetAddress').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#streetAddress');
                }
                validation = false;
                $('#streetAddress').css("border-color", "firebrick");
            }
            if (!$('#postcode').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#postcode');
                }
                validation = false;
                $('#postcode').css("border-color", "firebrick");
            }
            if (!$('#password').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#password');
                }
                validation = false;
                $('#password').css("border-color", "firebrick");
            }
            if (!$('#passwordConfirmation').val()) {
                if (!scrolled) {
                    scrolled = true;
                    scrollIntoView('#passwordConfirmation');
                }
                validation = false;
                $('#passwordConfirmation').css("border-color", "firebrick");
            }
        }

        if(validation){
            if(ValidateEmail(email)) {
                validation = false;
                $.ajax({
                    type: "POST",
                    url: './dbaccess/b2c_email_validation.php',
                    data: {'email': email},
                    success: function (result) {
                        if(result == 0){

                            registerUser(ValidatePassword(password,passwordConfirmation));

                        } else {
                            $('#email').css("border-color", "firebrick");
                            $('#emailHint').css("color", "firebrick").html('<?php echo $emailExistsHint?>');
                            scrollIntoView('#email');

                        }
                    }
                });
            } else {
                $('#email').css("border-color", "firebrick");
                $('#emailHint').css("color", "firebrick").html('<?php echo $invalidEmailHint?>');
                scrollIntoView('#email');
                validation = false;
            }
        }


    }

    function registerUser(validation){
        if(validation){
            var companyName          = $('#companyName').val();
            var firstName            = $('#firstName').val();
            var lastName             = $('#lastName').val();
            var phone                = $('#phone').val();
            var email                = $('#email').val();
            var country              = $('#country').val();
            var city                 = $('#city').val();
            var area                 = $('#area').val();
            var streetAddress        = $('#streetAddress').val();
            var postcode             = $('#postcode').val();
            var password             = $('#password').val();
            var lat                  = $('#lat').val();
            var lng                  = $('#lng').val();
            var promoID              = $('#promoID').val();
            var register             = true;

            $.ajax({
                type: 'POST',
                url: './dbaccess/getNextValidPromoCode.php',
                data: {
                    'promo': '<?php echo $promoName;?>'
                },
                success: function (result) {
                    if(result > 0){
                        $('#promoID').val(result);
                        $('#loginPromoID').val(result);

                        $.ajax({
                            type: "POST",
                            url: './dbaccess/b2c_register.php',
                            data: {
                                'companyName': companyName,
                                'firstName': firstName,
                                'lastName': lastName,
                                'phone': phone,
                                'email': email,
                                'country': country,
                                'city': city,
                                'area': area,
                                'streetAddress': streetAddress,
                                'postcode': postcode,
                                'lat': lat,
                                'lng': lng,
                                'register': register,
                                'promoID': promoID,
                                'password': password
                            },
                            success: function (result) {
                                if (result == 1) {
                                    $('#registrationForm').html("<?php echo $activeBox ?>");
                                } else if (result == 2) {
                                    $('#registrationForm').html("<?php echo $confirmationBox ?>");
                                } else if (result == 404) {
                                    alert('Something went Wrong..Please try again');
                                } else {
                                    $('#registrationForm').html("<?php echo $contactBox ?>");
                                }
                                scrollIntoView('#registrationForm');
                            }
                        });

                    } else {
                        $('#loginRegisterDiv').html("<?php echo $promoExpiredIframe; ?>");
                    }
                }
            });




        }
    }

    jQuery(document).ready(function () {

        initThemeParameters();
        <?php echo $invalidLoginFlag; ?>

    });


</script>
