<?php
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");
include_once("headerImports.php");

$customerID = $_SESSION['customerID'];
$userID     = $_SESSION['userID'];
$today      = date('Y-m-d');
$time       = '00:00';

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme FROM B2B_Configuration LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($cssTheme);
while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm->close();

?>

<body id="home" class="wide" >
<!-- PRELOADER -->
<div id="preloader">
    <div id="preloader-status">
        <div class="spinner">
            <div class="rect1"></div>
            <div class="rect2"></div>
            <div class="rect3"></div>
            <div class="rect4"></div>
            <div class="rect5"></div>
        </div>
        <div id="preloader-title">Loading</div>
    </div>
</div>
<!-- /PRELOADER -->

<!-- WRAPPER -->
<div class="wrapper">

    <!-- Popup: Shopping cart items -->
    <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="container">
                <div class="cart-items">

                </div>
            </div>
        </div>
    </div>
    <!-- /Popup: Shopping cart items -->

    <!-- HEADER -->
        <?php
        $topmenu = "topMenu$cssTheme.php";

        if(strcmp($topmenu,"topMenu2.php")==0){
            echo '<header class="header fixed" style="border: 0px;">';
        } else {
            echo '<header class="header fixed" >';
        }

        include_once("$topmenu");
        if(strcmp($topmenu,"topMenu.php")==0) {
            include_once("navigationMenu.php");
        }
        ?>
    </header>
    <!-- /HEADER -->

    <!-- CONTENT AREA -->
    <div class="content-area">

        <!-- PAGE -->
        <section class="page-section color">
            <div class="container" id="checkoutContainer">
                <h3 class="block-title alt"><i class="fa fa-angle-down"></i><?php echo $langu['timesheet_title_label']?></h3>
                <div class="row">
                    <div class="col-md-10">

                        <table id="datatable_fixed_column" class="table table-striped table-hover dataTable" width="100%" border="0" cellpadding="0" cellspacing="0">

                            <thead>

                            <tr>
                                <th class='text-center'></th>
                                <th class='text-center'>#</th>
                                <th class='text-center'>Date</th>
                                <th class='text-center'>Time From</th>
                                <th class='text-center'>Time To</th>
                                <th class='text-center' style="width: 6%">Hours</th>
                                <th class='text-center' style="display:none">projectID</th>
                                <th class='text-center'>Project</th>
                                <th class='text-center' style="display:none">activityID</th>
                                <th class='text-center'>Activity</th>


                            </tr>
                            </thead>

                            <tbody>
                            <?php

                            $popoverText = "";
                            $popoverTextExtras = "";
                            $dateHrsSum = array();

                            $db->set_charset("utf8");
                            $stm = $db->prepare("SELECT Items.name, Items.item_id, Online_Waybill_Item.date_from, Online_Waybill_Item.date_to,  Projects.project_name, Projects.project_id
                                                         FROM  Online_Waybills,Online_Waybill_Item, Items, Projects
                                                         WHERE Online_Waybills.waybill_id = Online_Waybill_Item.waybill_id 
                                                         AND   Online_Waybill_Item.item_id = Items.item_id
                                                         AND   Projects.project_id = Online_Waybill_Item.warehouse_id 
                                                         AND   Online_Waybills.customer_id ='$customerID'
                                                         AND   salesperson_id ='$userID'");
                            $stm->execute();
                            $stm->bind_result($itemName,$itemID, $dateFrom, $dateTo, $projectName,  $projectID);
                            $i = 1;
                            while ($stm->fetch()) {

                                $date =  date("Y-m-d", strtotime($dateFrom) );
                                $from =  date("H:i", strtotime($dateFrom) );
                                $to   =  date("H:i", strtotime($dateTo  ) );

                                $dateFrom      = date("Y-m-d H:i:s",strtotime($date.' '.$from));
                                $dateTo        = date("Y-m-d H:i:s",strtotime($date.' '.$to));
                                $qty           = round(abs(strtotime($date.' '.$to) - strtotime($date.' '.$from) )) ;
                                $timeInMin     =  $qty / 60;
                                $hrs           = floor($timeInMin / 60);
                                $mins          = (($timeInMin/60) - $hrs)*60;

                                if($mins < 10 ) {$mins = "0".$mins;}
                                $shownTime  = $hrs.':'.$mins;

                                $dateObject="";
                                $dateObject->date = $date;
                                $dateObject->time  = $timeInMin;
                                $dateHrsSum = array_push($dateHrsSum,$dateObject);


                                echo "<tr>";

                                echo "<td><img class='deleteRowButton' src='../backend/platform/img/deleteicon.png' style='width:20px;height:20px;'/></td>";
                                echo "<td class='index text-center' style='width:3%'><strong>$i</strong></td>";

                                echo "<td><input style='width:100%' class='dateClass form-control' id='date' name='date' type='date' min='2001-01-01' max='2100-12-31' value='$date' /></td>";
                                echo "<td><input style='width:100%;text-align: center;' class='timeFromClass form-control' id='timeFrom' name='timeFrom' type='text' value='$from' /></td>";
                                echo "<td ><input style='width:100%;text-align: center;' class='timeToClass form-control' id='timeTo' name='timeTo' type='text' value=$to' /></td>";

                                echo "<td><label style='width:100%; text-align: center;border-radius: 20px;background-color: transparent;font-size: 16px;' class='timeClass form-control' name='hrs' id='hrs'  >$shownTime</label></td>";

                                echo "<td style='display:none;'><input id='projectID' name='projectID' type='hidden' value='$projectID'></td>";
                                echo "<td><input style='width:100%;' class='projectName text-center form-control' id='projectName' name='projectName' type='text' value='$projectName'></td>";

                                echo "<td style='display:none;'><input id='activityID' name='activityID' type='hidden' value='$itemID'></td>";
                                echo "<td ><input style='width:100%;' class='activityName text-center form-control' id='activityName' name='activityName' type='text' value='$itemName'></td>";

                                echo "</tr>";
                                $i++;
                            }
                            $stm->close();

                            $emptyRecord = "<tr>

                                                <td><img class='deleteRowButton' src='../backend/platform/img/deleteicon.png' style='width:20px;height:20px;'/></td>
                                                <td class='index text-center' style='width:3%'><strong>$i</strong></td>
            
                                                <td><input style='width:100%' class='dateClass form-control' id='date' name='date' type='date' value='$today' /></td>
                                                <td><input style='width:100%;text-align: center;' class='timeFromClass form-control'  id='timeFrom' name='timeFrom' type='text' value='$time' /></td>
                                                <td><input style='width:100%;text-align: center;' class='timeToClass form-control' id='timeTo' name='timeTo' type='text' value='$time'  /></td>
            
                                                <td><label style='width:100%; text-align: center;border-radius: 20px;background-color: transparent;font-size: 16px;' class='timeClass form-control' name='hrs' id='hrs'  ></label></td>
            
                                                <td style='display:none;'><input id='projectID' name='projectID' type='hidden' value=''></td>
                                                <td><input style='width:100%;' class='projectName text-center form-control' id='projectName' name='projectName' type='text' value=''></td>
            
                                                <td style='display:none;'><input id='activityID' name='activityID' type='hidden' value=''></td>
                                                <td ><input style='width:100%;' class='activityName text-center form-control' id='activityName' name='activityName' type='text' value=''></td>
            
                                            </tr>";

                            if ($i < 2) {

                                for ($i = 1; $i <= 2; $i++) {

                                    echo $emptyRecord;
                                }

                            } else {

                                echo $emptyRecord;
                            }

                            ?>

                            </tbody>

                        </table>

                        <button style="width: 127px;margin-bottom:10px;display: inline-block;" target="_blank" id="newLineButton" name='newLineButton' class="btn btn-primary btn-block newLineButton">
                            <i class="fa fa-plus"></i>&nbsp; New Line
                        </button>

                        <button style="width: 140px;margin-bottom:10px;float: right;display: inline-block;" target="_blank" id="saveButton" name='saveButton' onclick="saveDraft();" class="btn btn-primary btn-block saveButton">
                            <i class="fa fa-check"></i>&nbsp; Save Draft
                        </button>

                    </div>

                    <div class="col-md-2" style="margin-top: 38px;text-align: center;">
                        Total Hours <label class="cummMin form-control" style='width:100%; text-align: center;border-radius: 20px;background-color: transparent;font-size: 16px;'> </label>
<!--                        Invalid Records <pre class="invRec form-control" style='width:100%; height: 100%; text-align: center;border-radius: 20px;background-color: transparent;font-size: 13px;'></pre>-->
                        <a class="btn btn-success" data-toggle="modal" id="saveFinal" data-target="#sendFinalModal" style="margin-left:0px; width: 100%;">Submit</a>
                    </div>

            </div>
        </section>
        <!-- /PAGE -->

    </div>
    <!-- /CONTENT AREA -->

    <!-- Modal -->
    <div class="modal fade" id="sendFinalModal" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
        <div class="modal-dialog" role="document" style="margin-top:20%">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h4 style="color:black;" class="modal-title" id="myModalLabel">Submit Time Sheet</h4>
                </div>
                <div class="modal-body">
                    Are you sure you want to Submit Time Sheet?<br>
                    <pre class="invRowsClass">Invalid Records will not be saved.</pre>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                    <button type="button" class="btn btn-primary" onclick="saveFinal()">Submit</button>
                </div>
            </div>
        </div>
    </div>

    <!-- FOOTER -->
    <footer class="footer">
        <div class="footer-meta">
            <div class="container">
                <div class="row">
                    <div class="col-sm-6" style="font-size:16px;">
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- /FOOTER -->

    <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

</div>
<!-- /WRAPPER -->

<!-- JS Global -->
<script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
<script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
<script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
<script src="assets/plugins/superfish/js/superfish.min.js"></script>
<script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
<script src="assets/plugins/jquery.sticky.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.easing.min.js"></script>
<script src="assets/plugins/jquery.smoothscroll.min.js"></script>
<script src="assets/plugins/smooth-scrollbar.min.js"></script>
<script src="assets/js/jquery-scrolltofixed-min.js"></script>
<script src="../backend/b2bAdmin/js/plugin/select2/select2.min.js"></script>
<script src="../backend/b2bAdmin/js/notification/SmartNotification.min.js"></script>
<script src="../backend/b2bAdmin/js/jquery.tabletojson.js"></script>
<script src="../backend/platform/js/jqueryui/jquery-ui.min.js" type="text/javascript"></script>
<link rel="stylesheet" href="../backend/platform/js/jqueryui/themes/base/theme.css">
<link href="assets/popover/bootstrap-popover-x.min.css" media="all" rel="stylesheet" type="text/css" />
<script src="assets/popover/bootstrap-popover-x.min.js" type="text/javascript"></script>
<!-- JS Page Level -->
<script src="assets/js/theme.js"></script>
<!--[if (gte IE 9)|!(IE)]><!-->
<script src="assets/plugins/jquery.cookie.js"></script>
<script src="assets/js/waitMe.min.js"></script>
<script src="../backend/platform/js/plugin/masked-input/jquery.maskedinput.min.js"></script>







<script>

    function updateTrNumbering() {
        var $i = 0;
        $('#datatable_fixed_column tr').each(function (i, row) {

            // reference all the stuff you need first
            var $row = $(row);

            $row.find("td.index").text($i);
            $i++;
        });
    }

    function initProjectAutocomplete() {


            $(".projectName").autocomplete({
                source: "../backend/platform/project_autocomplete.php",
                minLength: 0,
                autoFocus: true,
                open: function(){
                    var $itemRow = $(this).closest('tr');
                    $itemRow.find('#projectID').val(""); // Hidden input on form
                    $itemRow.find('#projectName').css("border-color", "#B22222");
                    $('.ui-autocomplete').css('width', '200px');
                    $( ".projectName" ).keyup(function(e) {
                        if (e.keyCode !== 13 && e.keyCode !== 9 ) {
                            var $itemRow = $(this).closest('tr');
                            $itemRow.find('#projectID').val(""); // Hidden input on form
                            $itemRow.find('#projectName').css("border-color", "#B22222");
                        }
                    });
                },
                select: function (event, ui) {

                    var $itemRow = $(this).closest('tr');

                    // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                    $itemRow.find('#projectID').val(ui.item.project_id); // Hidden input on form
                    $itemRow.find('#projectName').val(ui.item.label);
                    $itemRow.find('#projectName').css("border-color", "#90EE90");
                    setTimeout(function() { $itemRow.find('#projectName').css('border-color', '');}, 1000);
                    if($itemRow.find( ".timeClass" ).text() === ""){
                        $itemRow.find( ".timeClass" ).css("border-color", "#B22222");
                    }
                }
            }).on('focus', function() { $(this).keydown();$(this).keydown(); });

    }

    function initActivityAutocomplete() {



        $(".activityName").autocomplete({
                source: "../backend/platform/activity_autocomplete.php",
                minLength: 0,
                autoFocus: false,
                open: function(){
                    var $itemRow = $(this).closest('tr');
                    $itemRow.find('#activityID').val(""); // Hidden input on form
                    $itemRow.find('#activityName').css("border-color", "#B22222");
                    $('.ui-autocomplete').css('width', '200px');
                    $( ".activityName" ).keyup(function(e) {
                        if (e.keyCode !== 13 && e.keyCode !== 9 ) {
                            var $itemRow = $(this).closest('tr');
                            $itemRow.find('#activityID').val(""); // Hidden input on form
                            $itemRow.find('#activityName').css("border-color", "#B22222");
                        }
                    });
                },
                select: function (event, ui) {

                    var $itemRow = $(this).closest('tr');

                    // Modify this  information to match the information coming from assets/ajax-services/fetch-inventory.php
                    $itemRow.find('#activityID').val(ui.item.item_id); // Hidden input on form
                    $itemRow.find('#activityName').val(ui.item.label);
                    $itemRow.find('#activityName').css("border-color", "#90EE90");
                    setTimeout(function() { $itemRow.find('#activityName').css('border-color', '');}, 1000);
                    if($itemRow.find( ".timeClass" ).text() === ""){
                        $itemRow.find( ".timeClass" ).css("border-color", "#B22222");
                    }
                }
            }).on('focus', function() { $(this).keydown();$(this).keydown(); });

        }

    function addNewLine(date) {


        $lastTr = $('tr:last', $('#datatable_fixed_column'));
        $lastTd = $('td:last', $lastTr);
        $newTr = $lastTr.clone();
        $lastTr.after($newTr);
        $newTr.find("label").text("").css("border-color", "");
        $newTr.find("#date").val(date);
        $newTr.find("#timeFrom").mask('23:59');
        $newTr.find("#timeTo").mask('23:59');
        $newTr.find("#timeFrom").val('00:00');
        $newTr.find("#timeTo").val('00:00');
        $newTr.find("#projectName").val('').css("border-color", "");
        $newTr.find("#activityName").val('').css("border-color", "");
        $newTr.find("#projectID").val('');
        $newTr.find("#activityID").val('');


        $i = $newTr.find("td.index").text();
        $i++;
        $newTr.find("td.index").text($i);


        $( ".deleteRowButton" ).click(function() {
            deleteRow(this);
        });

        initProjectAutocomplete();
        initActivityAutocomplete();
        initTimeAutocomplete();
        initSumCalculation();

    }

    function initTimeAutocomplete(){

        $( ".dateClass" ).change(function() {

            var date = $(this).closest('tr').find( ".dateClass" ).val();
            var to   = $(this).closest('tr').find( ".timeToClass" ).val();
            var from = $(this).closest('tr').find( ".timeFromClass" ).val();

            if(date === ""){
                $(this).closest('tr').find( ".dateClass" ).val('<?php echo $today?>');
                date = $(this).closest('tr').find( ".dateClass" ).val();
            }

            var timeFrom = new Date(date + " " + from).getTime();
            var timeTo   = new Date(date + " " + to).getTime();


            var timeDiff = timeTo-timeFrom;
            var timeInMins = Math.floor(timeDiff / 60000);
            var hrs  = Math.floor(timeInMins / 60);
            var mins = timeInMins - hrs*60;
            if(mins < 10 ) {mins = "0"+mins;}

            if (isNaN(hrs) || isNaN(mins)){
                hrs = "0";
                mins = "00";
            }

            $(this).closest('tr').find( ".timeClass" ).text(hrs+':'+mins);



            if(hrs <= 0 && mins <= 0){
                $(this).closest('tr').find( ".timeClass" ).css("border-color", "#B22222");
            } else {
                $(this).closest('tr').find( ".timeClass" ).css("border-color", "");
            }
            initSumCalculation();
        });

        $( ".timeToClass" ).change(function() {

            var date = $(this).closest('tr').find( ".dateClass" ).val();
            var to   = $(this).closest('tr').find( ".timeToClass" ).val();
            var from = $(this).closest('tr').find( ".timeFromClass" ).val();

            var timeFrom = new Date(date + " " + from).getTime();
            var timeTo   = new Date(date + " " + to).getTime();

            if(isNaN(timeTo)){
                $(this).closest('tr').find( ".timeToClass" ).val('00:00');
                to   = $(this).closest('tr').find( ".timeToClass" ).val();
                timeTo = new Date(date + " " + to).getTime();
            }

            var timeDiff = timeTo-timeFrom;
            var timeInMins = Math.floor(timeDiff / 60000);
            var hrs  = Math.floor(timeInMins / 60);
            var mins = timeInMins - hrs*60;
            if(mins < 10 ) {mins = "0"+mins;}

            if (isNaN(hrs) || isNaN(mins)){
                hrs = "0";
                mins = "00";
            }

            $(this).closest('tr').find( ".timeClass" ).text(hrs+':'+mins);

            if(hrs <= 0 && mins <= 0){
                $(this).closest('tr').find( ".timeClass" ).css("border-color", "#B22222");
            } else {
                $(this).closest('tr').find( ".timeClass" ).css("border-color", "");
            }
            initSumCalculation();
        });

        $( ".timeFromClass" ).change(function() {
            var date = $(this).closest('tr').find( ".dateClass" ).val();
            var to   = $(this).closest('tr').find( ".timeToClass" ).val();
            var from = $(this).closest('tr').find( ".timeFromClass" ).val();

            var timeFrom = new Date(date + " " + from).getTime();
            var timeTo   = new Date(date + " " + to).getTime();


            if(isNaN(timeFrom)){
                $(this).closest('tr').find( ".timeFromClass" ).val('00:00');
                from   = $(this).closest('tr').find( ".timeFromClass" ).val();
                timeFrom = new Date(date + " " + from).getTime();
            }

            var timeDiff = timeTo-timeFrom;
            var timeInMins = Math.floor(timeDiff / 60000);
            var hrs  = Math.floor(timeInMins / 60);
            var mins = timeInMins - hrs*60;
            if(mins < 10 ) {mins = "0"+mins;}

            if (isNaN(hrs) || isNaN(mins)){
                hrs = "0";
                mins = "00";
            }

            $(this).closest('tr').find( ".timeClass" ).text(hrs+':'+mins);

            if(hrs <= 0 && mins <= 0){
                $(this).closest('tr').find( ".timeClass" ).css("border-color", "#B22222");
            } else {
                $(this).closest('tr').find( ".timeClass" ).css("border-color", "");
            }
            initSumCalculation();

        });




    }

    function initSumCalculation(){

        var sum = 0;

        $( ".timeClass" ).each(function () {
            var value = $(this).text();
            var split = value.split(':');
            var hr    = parseInt(split[0]);
            var min   = parseFloat(split[1]/60);
            var time  = hr+min;

            if(Number.isNaN(time) !== true ) {
                sum += parseFloat(time);
            }
        });

        var shownTimeHr  = Math.floor(sum);
        var shownTimeMin = Math.round((sum-shownTimeHr)*60);
        if(shownTimeMin < 10 ) {shownTimeMin = "0"+shownTimeMin;}
        $('.cummMin').text(shownTimeHr+':'+shownTimeMin);



    }

    function deleteRow(row) {
        var rowCount = $('#datatable_fixed_column tr').length;

        if (rowCount > 2) {
            $(row).parents('tr').remove();
        }
        updateTrNumbering();
        initSumCalculation();
    }

    function saveDraft() {

        var buttonTextOn = '<i class="fa fa-check"></i>&nbsp; Save Draft';
        var buttonTextOff = '<i class="fa fa-circle"></i>&nbsp; Saving';

        $("#saveButton").attr("disabled", true);
        $("#saveButton").html(buttonTextOff);
        $("#saveButton").removeClass("btn btn-success btn-block saveButton").addClass("btn btn-warning btn-block saveButton");

        var salesPersonID = '<?php echo $userID?>';
        var customerID    = '<?php echo $customerID?>';

        var waybillItems = $('#datatable_fixed_column').tableToJSON(
            {
                ignoreColumns: [0,1],
                textExtractor : {
                    0 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    1 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    2 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    3 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    4 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    5 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    6 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    7 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    8 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    }
                },
                ignoreHiddenRows: false,
                ignoreEmptyRows: false
            }
        );



        $.ajax({
            type: "POST",
            url: 'edit_timesheet.php',
            data: {
                'salesPersonID': salesPersonID,
                'customerID': customerID,
                'waybillItems': waybillItems
            },
            success: function (result) {

                $("#saveButton").attr("disabled", false);
                $("#saveButton").html(buttonTextOn);
                $("#saveButton").removeClass("btn btn-warning btn-block saveButton").addClass("btn btn-primary btn-block saveButton");

                var hours         = $('.cummMin').text();
                var noHours       ='0:00';
                if(hours.localeCompare(noHours) === 0){
                    $('#saveFinal').hide();
                } else {
                    $('#saveFinal').show();
                }

            }

        });

    }

    function saveFinal() {


        var salesPersonID = '<?php echo $userID?>';
        var customerID    = '<?php echo $customerID?>';

        var waybillItems = $('#datatable_fixed_column').tableToJSON(
            {
                ignoreColumns: [0,1],
                textExtractor : {
                    0 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    1 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    2 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    3 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    4 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    5 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    6 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    7 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    },
                    8 : function(cellIndex, $cell) {
                        return $cell.find('input').val();
                    }
                },
                ignoreHiddenRows: false,
                ignoreEmptyRows: false
            }
        );



        $.ajax({
            type: "POST",
            url: 'edit_timesheet.php',
            data: {
                'salesPersonID': salesPersonID,
                'customerID': customerID,
                'waybillItems': waybillItems
            },
            success: function (result) {

                $.ajax({
                    type: "POST",
                    url: './dbaccess/send_final_timesheet.php',
                    data: {
                        'salesPersonID': salesPersonID,
                        'customerID': customerID
                    },
                    success: function (result) {

                        $('#sendFinalModal').toggle();
                        location.reload();

                    }

                });

            }

        });

    }

    // function countInvalidRows(){
    //
    //     var invInput = "";
    //
    //     $( "td.index" ).each(function () {
    //         var dateTime  = $(this).closest('tr').find( ".timeClass" ).text();
    //         var activity  = $(this).closest('tr').find( "#activityID" ).val();
    //         var project   = $(this).closest('tr').find( "#projectID" ).val();
    //         var invDate = "";
    //         var invAct = "";
    //         var invPro = "";
    //
    //         if(dateTime === "" || dateTime === "0:00" || dateTime.includes("-")){
    //              invDate = "Invalid Date/Time.";
    //         }
    //
    //         if(activity === ""){
    //              invAct = "Invalid Activity.";
    //         }
    //
    //         if(project === ""){
    //              invPro = "Invalid Project.";
    //         }
    //
    //         if(invDate.includes("Invalid") || invAct.includes("Invalid") || invPro.includes("Invalid")){
    //             invInput += "Record #"+$(this).text()+" "+invDate+" "+invAct+" "+invPro+" \n";
    //         }
    //
    //     });
    //
    //
    //
    //     if(invInput === ""){
    //         invInput = "All records valid"
    //     }
    //
    //     $(".invRec").text(invInput);
    //     return invInput;
    // }

    $(document).ready(function() {

        window.setInterval(function(){saveDraft()}, 5*60*1000);

        $.mask.definitions['2'] = "[0-2]";
        $.mask.definitions['3'] = "[0-9]";
        $.mask.definitions['5'] = "[0-5]";
        $.mask.definitions['9'] = "[0-9]";

        $('.timeToClass').mask('23:59');
        $('.timeFromClass').mask('23:59');
        $('#saveFinal').hide();

        $("input").change(function(){
            $('#saveFinal').hide();
        });

        initSumCalculation();

        var today = new Date();
        var date = today.getFullYear() + '-' + ('0' + (today.getMonth() + 1)).slice(-2) + '-' + ('0' + today.getDate()).slice(-2);

        $('#datatable_fixed_column').on('keydown', 'input', function (e) {

            var $itemRow = $(this).closest('tr');
            if($itemRow.find('#activityID').val() === "") {
                $itemRow.find('#activityName').css("border-color", "#B22222");
            }
            if($itemRow.find('#projectID').val() === "") {
                $itemRow.find('#projectName').css("border-color", "#B22222");
            }
            if($itemRow.find('#hrs').text() === "") {
                $itemRow.find('#hrs').css("border-color", "#B22222");
            }

            var keyCode = e.keyCode;
            if (keyCode !== 9) return;
            var $this = $(this),
                $lastTr = $('tr:last', $('#datatable_fixed_column')),
                $lastTd = $('td:last', $lastTr);
            if (($(e.target).closest('td')).is($lastTd)) {


                $newTr = $lastTr.clone();
                $lastTr.after($newTr);
                $newTr.find("label").text("").css("border-color", "");
                $newTr.find("#date").val(date);
                $newTr.find("#timeFrom").mask('23:59');
                $newTr.find("#timeTo").mask('23:59');
                $newTr.find("#timeFrom").val('00:00');
                $newTr.find("#timeTo").val('00:00');
                $newTr.find("#projectName").val('').css("border-color", "");
                $newTr.find("#activityName").val('').css("border-color", "");
                $newTr.find("#projectID").val('');
                $newTr.find("#activityID").val('');

                $i = $newTr.find("td.index").text();
                $i++;
                $newTr.find("td.index").text($i);

                initProjectAutocomplete();
                initActivityAutocomplete();
                initTimeAutocomplete();
                initThemeParameters();

                $( ".deleteRowButton" ).click(function() {
                    deleteRow(this);
                });
            }
        });

        $('#datatable_fixed_column').on('keydown', 'input', function (e) {
            var keyCode = e.keyCode;
            if (keyCode !== 13) return;
            var $this = $(this);

            var $thisTd = $(e.target).closest('tr');
            $lastTd = $('td:last', $thisTd);

            if (($(e.target).closest('td')).is($lastTd)) {
                $newTr = $thisTd.clone();
                $thisTd.after($newTr);
                $newTr.find("label").text("").css("border-color", "");
                $newTr.find("#date").val(date);
                $newTr.find("#timeFrom").mask('23:59');
                $newTr.find("#timeTo").mask('23:59');
                $newTr.find("#timeFrom").val('00:00');
                $newTr.find("#timeTo").val('00:00');
                $newTr.find("#projectName").val('').css("border-color", "");
                $newTr.find("#activityName").val('').css("border-color", "");
                $newTr.find("#projectID").val('');
                $newTr.find("#activityID").val('');

                $i = $newTr.find("td.index").text();
                $i++;
                $newTr.find("td.index").text($i);


                initProjectAutocomplete();
                initActivityAutocomplete();
                initTimeAutocomplete();

                $(".deleteRowButton").click(function () {
                    deleteRow(this);
                });
            }
            updateTrNumbering();

        });

        $( "#newLineButton" ).click(function() {
            addNewLine(date);
        });

        $( ".deleteRowButton" ).click(function() {
            deleteRow(this);
        });

        initProjectAutocomplete();
        initActivityAutocomplete();
        initTimeAutocomplete();

        var fixHelperModified = function(e, tr) {
                var $originals = tr.children();
                var $helper = tr.clone();
                $helper.children().each(function(tr) {
                    $(this).width($originals.eq(tr).width())
                });
                return $helper;
            },
            updateIndex = function(e, ui) {
                $('td.index', ui.item.parent()).each(function (i) {
                    $(this).text(i + 1);
                });
            };

        $("#datatable_fixed_column tbody").sortable({
            helper: fixHelperModified,
            stop: updateIndex
        });

    })


</script>

</body>
</html>