<?php
include_once("../param.php");
require_once("./dbaccess/dbhelper.php");
require_once("./assets/mobiledetect/Mobile_Detect.php");

$detect = new Mobile_Detect;
$isMobile = false;
if ( $detect->isMobile() ) {
    $isMobile = true;
}

if (isset($_GET['currency']) && $_GET['currency'] > 0) {
    $_SESSION['currency'] = $_GET['currency'];
}
if (isset($_SESSION['currency'])) {
    $sessionCurrencyID = $_SESSION['currency'];
}

if(isset($_SESSION['orderID'])) {
    $orderID = $_SESSION['orderID'];
}
$customerID=$_SESSION['customerID'];
$displayGreeting = '';



$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

if($sessionCurrencyID > 0 && isset($_SESSION['customerID']) && isset($_SESSION['orderID'])){
    $stm2 = $db->prepare("UPDATE Online_Orders SET currency_id=? WHERE customer_id=? AND order_id=?");
    $stm2-> bind_param('iii',$sessionCurrencyID,$customerID,$orderID);
    $stm2-> execute();
    $stm2->close();
}

$allowAnonymousOrder = false;
$includeVatOnPrice = false;
$showCustomerLogo = false;
$showCurrencies = false;
$addItemByUnits = true;
$db->set_charset("utf8");
$stm = $db->prepare("SELECT css_theme,theme,anonymous_order,show_prices_with_vat,show_customer_logo,multi_currency,order_qty_by_subunits FROM B2B_Configuration LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($cssTheme,$themeColor,$anonymousOrder,$showPricesIncludingVAT,$showCustomerLogoSetting,$multiCurrency,$orderQtyBySubunits);
while ($stm->fetch()) {
    if($cssTheme <= 1){
        $cssTheme = '';
    }
    $themeColor = strtolower($themeColor);

    if(strcmp($anonymousOrder,'yes')==0){
        $allowAnonymousOrder = true;
    }
    if(strcmp($showPricesIncludingVAT,"yes")==0){
        $includeVatOnPrice = true;
    }
    if(strcmp($showCustomerLogoSetting,"yes")==0){
        $showCustomerLogo = true;
    }
    if(strcmp($multiCurrency,"yes")==0){
        $showCurrencies = true;
    }

    if(strcmp($orderQtyBySubunits,'yes')==0){
        $addItemByUnits = false;
    }

}
$stm->close();

// user favorites
$favoritesShow = false;
$stm = $db->prepare("SELECT allow_user_favorites FROM B2B_Page_Catalogue LIMIT 1 ");
$stm-> execute();
$stm-> bind_result($allowUserFavorites);
while ($stm->fetch()) {
    if(strcmp($allowUserFavorites,'yes')==0){
        $favoritesShow = true;
    }
}
$stm->close();


$logoLinkHeader = $logoLink;
if($showCustomerLogo) {
    if (isset($_SESSION['customerID']) && $_SESSION['customerID'] > 0) {

        $db->set_charset("utf8");
        $stm = $db->prepare("SELECT logo FROM Customers WHERE customer_id='". $_SESSION['customerID']."' AND customer_id > 0 LIMIT 1");
        $stm->execute();
        $stm->bind_result($customerLogo);
        while ($stm->fetch()) {
            if(strcmp($customerLogo,'')!=0 && file_exists('../media/customersLogos/'.$customerLogo)){
                $logoLinkHeader = '../media/customersLogos/'.$customerLogo;
            }
        }
        $stm->close();

    }
}
if(isset($_SESSION['orderID'])) {
    $currencyRate = getPriceRate();
    $count = 0;
    $itemCounter = 0;
    $subtotal = 0;
    $netTotalLabel = $langu['column_total_label'];
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT qty,unit_price,Items.vat_id,Online_Order_Item.item_id FROM Online_Order_Item,Items WHERE  Online_Order_Item.item_id=Items.item_id AND order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($ordQty,  $ordlineUnitPrice,$ordVatID,$ordItemID);
    while ($stm->fetch()) {


        if($addItemByUnits) {
            $ordQty = $ordQty / floatval(getSubUnits($ordItemID));
            $subtotalLine = $ordlineUnitPrice*$ordQty;
        } else {
            $subtotalLine = $ordlineUnitPrice*$ordQty / floatval(getSubUnits($ordItemID));
        }

        $count += $ordQty;
        $itemCounter++;

        if($includeVatOnPrice) {
            $vatPercentage = getVatPercentage($ordVatID);
            $subtotal += $subtotalLine + $subtotalLine * ($vatPercentage / 100);
        } else {
            $subtotal += $subtotalLine;
        }
    }
    $stm->close();

}

if(strcmp($showPrices,'no')==0 || (isset($_SESSION['showPrices']) && $_SESSION['showPrices']==false) || $showPrices==false){
    $showPrices = false;
    $showCurrencies = false;
} else {
    $showPrices = true;
}

if (!(!isset($_SESSION['customerID'])||$_SESSION['customerID']==0)) {

    global $username, $password, $database;

    $checkoutLabel = $langu['checkout_label'];
    $greeting = $langu['greeting'];

    $userId =  $_SESSION['userID'];
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT username,first_name FROM B2B_User WHERE b2b_user_id='$userId'");
    $stm-> execute();
    $stm-> bind_result($userName,$fname);
    while ($stm->fetch()) {
        if(strcmp(trim($fname),'')!=0){$userName=$fname;}
        if($isMobile){
            $displayGreetingMobile = "<label class='pull-right' style='padding-top: 14px;color: white;margin-right:-3px;font-weight: bolder'>$userName</label>";
        } else {
            $displayGreeting = "<label class='hidden-xs' style='padding-top: 13px;color: white;font-weight: bolder'>$greeting $userName</label>";
        }
    }
    $stm-> close();
    $claimedCoupon = "&nbsp;";
    $stm4 = $db->prepare("SELECT promotion_code,promotion_name,type FROM B2B_User,Promotions WHERE b2b_user_id=? AND Promotions.promotion_id=B2B_User.acceptance2 AND valid_from <= NOW() AND valid_until >= NOW() AND status = 'yes'  ORDER BY Promotions.timestamp DESC LIMIT 1");
    $stm4-> bind_param('i',$userId);
    $stm4-> execute();
    $stm4-> bind_result($couponCode,$couponName,$couponType);
    while ($stm4->fetch()) {
        if($couponType == 9){
            $claimedCoupon = "<span class='hidden-xs' style='padding-top: 13px;color: lime;font-weight: bold'> &nbsp;(You are in $couponName!)</span>";
        } else {
            $claimedCoupon = "<span class='hidden-xs' style='padding-top: 13px;color: lime;font-weight: bold'> &nbsp;(You have $couponName!)</span>";
        }

    }
    $stm4->close();




}

$textColor = "white";
if(strcmp($themeColor,'')!=0){
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0 ){
        $themeColor = "firebrick";
    }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    }  else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0){
        $themeColor = "goldenrod";
    } else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    }  else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
        $themeColor = "black";
        $textColor = "white";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
        $textColor = "black";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }

} else {
    $themeColor = "#6796d3";
}
$themeColorGradient = " background: -moz-linear-gradient(bottom,  $themeColor  0%, white 10%, whitesmoke 60%);
                        background: -webkit-gradient(linear, left top, left bottom, from($themeColor), to(white));
                        filter: progid:DXImageTransform.Microsoft.gradient(startColorstr='#cfddac', endColorstr='#ffffff');
                        background: linear-gradient(to bottom, $themeColor  0%, white 10%, whitesmoke 60%);";

$db->set_charset("utf8");
$stm = $db->prepare("SELECT facebook_link,instagram_link,twitter_link FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($facebookLink,$instagramLink,$twitterLink);
while ($stm->fetch()) {}
$stm-> close();
?>

<div class="header-wrapper" style="padding-top:0px;padding-bottom:0px;margin-left: 0px;margin-right: 20px;width: 100%;margin-bottom: 0px;">
    <div class="header-theme container" style="width: 100%;height: 10px;padding: 0px;">
        <div class="col-xs-6 col-sm-6  hidden-md  hidden-lg  pull-left">
            <!--<a href='#' class='menu-toggle btn btn-theme-transparent pull-left' style="border-color: transparent;color: <?php echo $textColor;?>; font-weight: bolder;margin-left: -15px;"><i class='fa fa-bars'></i></a>-->
            <button onclick="openNav();" class='btn btn-theme-transparent pull-left' style="padding: 4px 10px;margin: 3px;background-color: rgba(245,245,245,0.2);border-radius: 5px;border-color: transparent;color: <?php echo $textColor;?>; font-weight: bolder;margin-left: -12px;"><i class='fa fa-bars'></i></button>
            <a href="index.php"><img class="pull-right" style="display: block;margin-top:5px;margin-left: 0px;margin-right: auto;max-height:30px;" src="<?php echo $logoLinkHeader ?>" alt="Coprime"/></a>
        </div>
        <div class="col-sm-6 col-xs-6 col-md-12 col-lg-12">
            <?php echo $displayGreeting ;?>
            <table class="pull-right" style="margin-top: 3px;margin-left: 10px;">
                <tr>
                    <td class="hidden-xs hidden-sm">
                        <ul  style="display:inline-block;margin-bottom: 0px;margin-top: 0px;">
                            <?php
                            if(strcmp($facebookLink,'')!=0){
                                echo "<li style='display:inline-block'><a target='_blank' href='$facebookLink' class='btn btn-theme-transparent' style='margin-right: 1px;border: 0px;border-radius: 50%'>&nbsp;<i class='fa fa-facebook' style='color: $textColor'></i>&nbsp;</a></li>";
                            }
                            if(strcmp($instagramLink,'')!=0){
                                echo "<li style='display:inline-block'><a target='_blank' href='$instagramLink' class='btn btn-theme-transparent' style='margin-right: 1px;border: 0px;border-radius: 50%'>&nbsp;<i class='fa fa-instagram' style='color: $textColor'></i>&nbsp;</a></li>";
                            }
                            if(strcmp($twitterLink,'')!=0) {
                                echo "<li style='display:inline-block'><a target='_blank' href='$twitterLink'  class='btn btn-theme-transparent' style='border: 0px;border-radius: 50%'><i class='fa fa-twitter' style='color: $textColor'></i></a></li>";
                            }
                            ?>
                        </ul>
                    </td>
                    <td style="vertical-align: top;">

                        <?php
                        global $isMobile;


                        if($showCurrencies) {

                            $currencySelection = '';
                            $db->set_charset("utf8");
                            $stm = $db->prepare("SELECT currency_code,currency_sign,currency_id FROM Display_Currency ORDER BY default_currency DESC ");
                            $stm->execute();
                            $stm->bind_result($currencySelectionOptionCode, $currencySelectionOptionSign, $currencySelectionOptionID);
                            while ($stm->fetch()) {

                                if($isMobile){
                                    if ($sessionCurrencyID == $currencySelectionOptionID) {
                                        $currencySelection .= "<option value='$currencySelectionOptionID' selected>$currencySelectionOptionCode&nbsp;&nbsp;&nbsp;$currencySelectionOptionSign</option>";
                                    } else {
                                        $currencySelection .= "<option value='$currencySelectionOptionID'>$currencySelectionOptionCode&nbsp;&nbsp;&nbsp;$currencySelectionOptionSign</option>";
                                    }
                                } else {
                                    if ($sessionCurrencyID == $currencySelectionOptionID) {
                                        $currencySelection .= "<option value='$currencySelectionOptionID' selected>$currencySelectionOptionCode&nbsp;&nbsp;&nbsp;$currencySelectionOptionSign</option>";
                                    } else {
                                        $currencySelection .= "<option value='$currencySelectionOptionID'>$currencySelectionOptionCode&nbsp;&nbsp;&nbsp;$currencySelectionOptionSign</option>";
                                    }
                                }


                            }
                            $stm->close();

                            if (strcmp($currencySelection, '') != 0) {
                                if($isMobile){
                                    $dropDownPagesCurrency .= "<li><select id='currencySelect' class='btn-theme-transparent' onchange='setCurrency()' style='width:auto;display:inline-block;height:33px;margin-left: 8px;color: $textColor;border: 4px solid transparent;'>$currencySelection</select></li>";
                                } else {
                                    echo "<select id='currencySelect' class='btn-theme-transparent pull-right' onchange='setCurrency()' style='width:80px;display:inline-block;height:33px;margin-left: 5px;color: $textColor;border: 4px solid transparent;'>$currencySelection</select>";
                                }
                            }
                        } else {
                            if(isset($_SESSION['currency'])){
                                unset($_SESSION['currency']);
                            }
                        }


                        $showLanguages = $_SESSION['show_language_selection'];
                        $lang = $_SESSION['lang'];
                        if(isset($_SESSION['langname'])) {
                            $langName = $_SESSION['langname'];
                        }
                        if($showLanguages) {

                            if($isMobile){
                                $dropDownPagesLanguage .= "<li><select id='languageSelect' class='btn-theme-transparent' onchange='setLanguage()' style='width:auto;display:inline-block;height:33px;margin-left: 7px;color: $textColor;border: 4px solid transparent;'>";

                                if (strcmp($lang, 'en') == 0) {
                                    $dropDownPagesLanguage .= "<option value='en'><strong>English</strong></option>";
                                    $dropDownPagesLanguage .= "<option value='el'><strong>Greek</strong></option>";
                                } else {
                                    $dropDownPagesLanguage .= "<option value='el'>Greek</option>";
                                    $dropDownPagesLanguage .= "<option value='en'>English</option>";
                                }
                                $dropDownPagesLanguage .= "</select></li>";
                            } else {

                                echo "<select id='languageSelect' class='btn-theme-transparent pull-right' onchange='setLanguage()' style='width:80px;display:inline-block;height:33px;margin-left: 5px;color: $textColor;border: 4px solid transparent;'>";

                                if (strcmp($lang, 'en') == 0) {
                                    echo "<option value='en'><strong>English</strong></option>";
                                    echo "<option value='el'><strong>Greek</strong></option>";
                                } else {
                                    echo "<option value='el'>Greek</option>";
                                    echo "<option value='en'>English</option>";
                                }
                                echo "</select>";

                            }
                        }




                        ?>


                    </td>
                </tr>
            </table>
            <?php echo $claimedCoupon;?>
            <nav class='navigation closed clearfix pull-right'>
                <a href='#' class='menu-toggle-close btn' id="sidemenuclosebutton"><i class='fa fa-times'></i></a>
                <ul class='nav <?php if(!$isMobile){echo "sf-menu";}?>' style="height: 34px;color: white;line-height: 1.72;text-align: left;" id="navUl">
                    <?php

                    $db = new mysqli('localhost', $username, $password, $database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }
                    $db->set_charset("utf8");
                    $stm = $db->prepare("SELECT page_id,page_name_display,page_name_display_gr,page_name_code,menu_position,show_if_logged_in,show_if_logged_out,function_to_call FROM B2B_Pages WHERE active='yes' ORDER BY menu_position");
                    $stm->execute();
                    $stm->bind_result($pageID,$pageName,$pageGreekName,$pagePhp,$position,$showIfLoggedIn,$showIfLoggedOut,$functionToCall);

                    while ($stm->fetch()) {
                        $pageNameURL = str_replace(' ','-',$pageName);
                        $pageNameURL = urlencode($pageNameURL);
                        if($position==1)
                        {
                            $class ="class='active '";
                        } else {
                            $class ="class=''";
                        }


                        if(strcmp($_SESSION['lang'],'el')==0)
                        {
                            $value = $langu['pages'][$pageName];

                            if(isset($value))
                            {
                                $pageName = $langu['pages'][$pageName];
                            }
                            if(strcmp($pageGreekName,'')!=0){
                                $pageName = $pageGreekName;
                            }
                        }

                        if ((strcmp($showIfLoggedOut, 'yes') == 0 && $_SESSION['customerID'] == 0) || (strcmp($showIfLoggedIn, 'yes') == 0 && $_SESSION['customerID'] != 0)) {

                            $msg = "";
                            if (strcmp($functionToCall, "") != 0) {
                                $msg = "(" . call_user_func($functionToCall) . ")";
                            }

                            if(!$isMobile) {
                                if (isset($len) && substr($pagePhp, 0, $len) === "http") {
                                    echo "  <li ><a $class target='_blank' href='$pagePhp' style='height: 40px;color: $textColor;padding-top: 8px;'>$pageName$msg </a></li>";
                                } else {
//                                if (strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']), $pagePhp) != 0 || strcmp($pagePhp,'index.php') !=0) {
                                    $pagePhp=str_replace("dynamic_page.php?id=","./pages/$pageNameURL/", $pagePhp);
                                    echo "  <li><a $class href='$pagePhp' style='height: 40px;color: $textColor;vertical-align: middle;padding-top: 8px;'>$pageName$msg</a></li>";

//                                }
                                }
                            }

                            if(isset($len) && substr($pagePhp, 0, $len) === "http") {
                                $dropDownPages .= "  <li><a  target='_blank' href='$pagePhp' style='vertical-align: middle;color: $textColor;padding-top: 8px;'>$pageName$msg</a></li>";
                            } else {
                                $dropDownPages .= "  <li><a  href='$pagePhp' style='color: $textColor;vertical-align: middle;padding-top: 8px;'>$pageName$msg</a></li>";
                            }
                        }

                    }
                    $stm->close();

                    if(strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'b2b')==0 || strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'index.php')==0 || strpos($_SERVER['REQUEST_URI'] , '.php') === false){
                        echo "<style>   

                                #navUl{
                                height: auto !important;
                                }                     
                                /*VERTICAL MENU*/
                                #categoriesContainerMobile {
                                  position:relative !important;
                                }
                                
                                /* ALL UL */
                                #categoriesContainerMobile  ul{
                                  list-style: none !important;
                                }
                                /* ALL LI */
                                #categoriesContainerMobile  li{
                                  position:relative !important;
                                }
                                /* ALL A */
                                #categoriesContainerMobile  a{
                                  display:block !important;
                                  color:#eee !important;
                                  text-decoration:none !important;
                                  padding:10px 15px !important;
                                  transition:0.02s !important;
                                }
           
                                
                                /* INNER UL HIDE */
                                #categoriesContainerMobile  ul ul{
                                  padding-left:20px !important;
                                  transition: max-height 0.02s ease-out !important;
                                  max-height:0 !important;
                                  overflow:hidden !important;
                                }
//                                /* INNER UL SHOW */
//                                #categoriesContainerMobile  li:hover > ul{
//                                  max-height:500px !important;
//                                  transition: max-height 0.25s ease-in !important;
//                                }
                                /* INNER UL HIDE */
                                #categoriesContainerMobile  ul{
                                  padding-left:20px !important;
                                  transition: max-height 0.02s ease-out !important;
                                  max-height:0 !important;
                                  overflow:hidden !important;
                                }
                                /* INNER UL SHOW */
                                #categoriesContainerMobile:hover > ul{
                                  max-height:35000px !important;
                                  transition: max-height 0.25s ease-in !important;
                                }
                                #categoriesContainerMobile a:hover{
                                  color: $themeColor !important;
                                }
                                </style>";

                                echo "<script>
                                        function viewCategoryMobile(element,active){
                                            if(active > 0){
                                                $(element).parent().find('ul').attr('style', 'max-height:5000px !important;transition: max-height 0.25s ease-in !important;');
                                                $(element).parent().find('ul').children('li').find('ul').attr('style', 'padding-left:20px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                                $(element).parent().find('ul').find('li').find('a').attr('onclick','viewCategoryMobile(this,1);return false;');
                                                $(element).attr('onclick','viewCategoryMobile(this,0);return false;');
                                            } else {
                                                $(element).parent().find('ul').attr('style', 'padding-left:20px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                                $(element).attr('onclick','viewCategoryMobile(this,1);return false;');  
                                            }
                                            
                                        }  
                                        
                                        
                                  </script>";

                        echo "<li style='border-top: 2px solid transparent;border-bottom: 2px solid transparent;padding-top: 10px;padding-bottom: 10px;' class='hidden-lg hidden-md' id='categoriesContainerMobile'><a>". $langu['categories_label'] ."</a></li>";

                    }

                    ?>
                </ul>
            </nav>

            <?php

            if($isMobile) {

                echo "<div class='dropdownPages pull-right' style='margin-right:-25px;'>
                                      <button class='btn btn-theme-transparent  pull-right' id='dropDownPagesButton' onclick='openDropDownPages();' style='padding: 4px 10px;margin: 3px;background-color: rgba(245,245,245,0.2);border-radius: 7px;border-color: transparent;'><i class='fa fa-user' style='font-size:20px;color: $textColor'></i></button>
                                          <div class='dropdownPages-content' id='dropDownPagesContainer' style='position: absolute;right: 0px;top: 35px;text-align: left;border-bottom: 3px solid black;border-top: 3px solid black;border-radius: 14px 0 0 14px  !important;z-index: 101 !important;'>
                                            <ul style='margin-bottom: 0px;width: 180px;'>
                                                $dropDownPages
                                                $dropDownPagesLanguage
                                                $dropDownPagesCurrency
                                            </ul>
                                          </div>
                                    </div>
                                    <style>
                                    /* The container <div> - needed to position the dropdown content */
                                    .dropdownPages {
                                      position: relative;
                                      display: inline-block;
                                    }
                                    
                                    /* Dropdown Content (Hidden by Default) */
                                    .dropdownPages-content {
                                      display: none;
                                      position: absolute;
                                      background-color: $themeColor;
                                      min-width: 160px;
                                      box-shadow: 0px 8px 16px 0px rgba(0,0,0,0.2);
                                      z-index: 1000;
                                    }
                                    
                                    /* Links inside the dropdown */
                                    .dropdownPages-content a {
                                      color: black;
                                      padding: 12px 16px;
                                      text-decoration: none;
                                      display: block;
                                    }
                                    
                                    /* Change color of dropdown links on hover */
                                    .dropdownPages-content a:hover {
                                        background-color: black;
                                        color: $themeColor;
                                        }
                                    
                                    /* Show the dropdown menu on hover */
                                    .dropdownPages:hover .dropdownPages-content {display: block;}
                                    
                                    /* Change the background color of the dropdown button when the dropdown content is shown */
                                    .dropdownPages:hover .dropbtn {background-color: #3e8e41;}
                                    </style>
                                    <script>
                                        $('#dropDownPagesContainer').hide();
                                        function openDropDownPages() {
                                           $('#dropDownPagesButton').css('background-color','black');
                                           $('#dropDownPagesButton').attr('onclick','closeDropDownPages();');
                                           $('#dropDownPagesContainer').slideDown(\"fast\");
                                        }
                                        function closeDropDownPages() {
                                           $('#dropDownPagesContainer').slideUp(\"fast\");
                                           $('#dropDownPagesButton').css('background-color','rgba(245,245,245,0.2)');
                                           $('#dropDownPagesButton').attr('onclick','openDropDownPages();');
                                           
                                        }
                                    </script>
                                    ";

                echo $displayGreetingMobile;
            }

            ?>


        </div>

        <div class="col-sm-12 col-xs-12 hidden-md  hidden-lg">
            <?php
            global $isMobile;
            $urlFile = explode('?',basename($_SERVER['REQUEST_URI']))[0];
            if((strcmp($urlFile,'index.php')==0 || strcmp($urlFile,'b2b')==0 || strpos($urlFile , '.php') === false) && $isMobile )
            {
                if($allowAnonymousOrder || $customerID !=0){$allowOrderWidth = 'width: 80%;';}else{$allowOrderWidth = 'width: 100%;';}
                echo '        
                            <div class="widget-search widget-searchbox" style="margin-top: 12px;display: inline-block;'.$allowOrderWidth.'margin-bottom: 15px;z-index: 100;position:relative;">
                                <input id = "searchButton" name = "searchButton" class="form-control widget_searchbox_input deletable " type="search" placeholder = "'. $langu['searchbox_hint'] .'" >
                            <div id = "suggesstion-box" ></div >
                            <button style = "display:none;position:absolute;right:60px;color: black;" class="widget-close" id = "searchButtonIconClose" ><i class="fa fa-times" ></i ></button >
                            <button id = "searchButtonIcon" ><i class="fa fa-search" ></i ></button >
                            </div >
                        ';
                if($allowAnonymousOrder || $customerID !=0){
                echo "            <div class='header-cart  pull-right' style='margin-top: 12px;display: inline-block;width: 19%;z-index: 100;position:relative;'>      
                <div class='cart-wrapper pull-right' style=''>
                  <label style='display:block;font-size: 7px;' class='hidden-xs'>&nbsp;</label>
                    <!--<a href='checkout.php'  class='btn btn-theme-transparent  pull-right' style='margin-left: 5px;'><span>$checkoutLabel</span></a>-->
                    <a href='#'  class='btn btn-theme-transparent  pull-right' onclick='openCart()' data-toggle='modal' data-target='#popup-cart'><i class='fa fa-shopping-cart'></i> <span class='hidden-xs' id='modalCartButtonText'> $itemCounter $itemsLabel - $qtyLabel $count"; if($showPrices){ echo " $netTotalLabel: $displaySubTotal";} echo "</span> <i class='fa fa-angle-down'></i></a>
                    <!-- Mobile menu toggle button -->
                   
                </div>
                </div>";
                }

            }


            ?>
        </div>
    </div>

    <div class="container" style="width: 100%;padding: 0px;margin:0px;border:0px;">
        <div class='navigation-wrapper  closed clearfix ' style="width: 100%;height:60px;padding-bottom: 2px;border: 0px solid transparent;<?php echo $themeColorGradient; ?> ;">

        <!-- Logo -->
        <div class="hidden-xs hidden-sm col-md-3 col-lg-3">
            <a href="index.php"><img class="pull-left" style="display: block;margin-top:5px;margin-left: 0px;margin-right: auto;max-height:60px;" src="<?php echo $logoLinkHeader ?>" alt="Coprime"/></a>
        </div>




        <div class="col-sm-6 col-xs-5 col-md-5 col-lg-5" >
            <?php
            $urlFile = explode('?',basename($_SERVER['REQUEST_URI']))[0];
            $urlAll = $_SERVER['REQUEST_URI'];
            $urlExplode = explode('/', $urlAll);
            $lastDir = $urlExplode[sizeof($urlExplode)-2].'/'.$urlExplode[sizeof($urlExplode)-1];
            if((strcmp($urlFile,'index.php')==0 || strpos($urlAll, "b2b/catalogue") !== false || strcmp($lastDir, "b2b/") == 0) && !$isMobile)
            {
                echo ' <center>
                            <div class="widget-search widget-searchbox" style="margin-top: 12px;position: absolute;left: 72px;z-index: 100 !important;background-color: whitesmoke !important;">
                                <input id = "searchButton" name = "searchButton" class="form-control widget_searchbox_input deletable  " type = "search" placeholder = "'. $langu['searchbox_hint'] .'" >
                            <div id = "suggesstion-box" ></div >
                            <button style = "display:none;position:absolute;right:60px;" class="widget-close" id = "searchButtonIconClose" ><i class="fa fa-times" ></i ></button >
                            <button id = "searchButtonIcon" ><i class="fa fa-search" ></i ></button >
                            </div >
                            
                        </center>';


            }


            ?>
        </div>



        <?php

      if (!(!isset($_SESSION['customerID'])||$_SESSION['customerID']==0) || $allowAnonymousOrder) {

          global $username, $password, $database;

          $userId =  $_SESSION['userID'];
          $db = new mysqli('localhost',$username,$password,$database);
          if (mysqli_connect_errno()) {
              printf("Connect failed: %s\n", mysqli_connect_error());
              exit();
          }
          $db->set_charset("utf8");

          $stm = $db->prepare("SELECT username,first_name FROM B2B_User WHERE b2b_user_id='$userId'");
          $stm-> execute();
          $stm-> bind_result($userName,$fname);

          while ($stm->fetch()) {
              if(strcmp(trim($fname),'')!=0){$userName=$fname;}
          }
          $stm-> close();

          $checkoutLabel = $langu['checkout_label'];
          $displaySubTotal = number_format(floatval($subtotal),2);

          $greeting = $langu['greeting'];


          $show = true;

          $stm = $db->prepare("SELECT category_id, count(category_id) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$userId'");
          $stm->execute();
          $stm->bind_result($categoryID, $counter);
          while ($stm->fetch()) {
          }
          $stm->close();

          if($counter == 1 && $categoryID == 2){$show = false;}
          else if($counter == 1 && $categoryID == 14){$show = false;$_GET['category_id']=$categoryID;}

          $_SESSION['show'] = $show;
          $itemsLabel = $langu['item'];
          $qtyLabel = $langu['qty'];

          $favoriteIcon = "";
          if($favoritesShow) {
              $userID = intval($_SESSION["userID"]);
              $customerID = intval($_SESSION["customerID"]);

              if ($userID == 0 || $customerID == 0) {
                  $onclick = "onclick=\"$('#loginModal').modal('show');\"";
              } else {
                  $onclick = "onclick=\"getItemsInCategory(28,1,96);\"";
              }

              $favoriteIcon = "<a href='#' $onclick class='btn btn-theme-transparent pull-right' style='padding-top:8px;margin-left: 5px;'>
                    <i class='fa fa-heart '></i>
                 </a>";
          }

          if(!$isMobile) {
                echo "

                 <!-- Header shopping cart -->
        
                    <div class='header-cart  pull-right' style='margin-top: 0px;'>      
                        <div class='cart-wrapper pull-right' style=''>
                          <label style='display:block;font-size: 7px;' class='hidden-xs'>&nbsp;</label>
                            <a href='checkout.php'  class='btn btn-theme-transparent  pull-right ' style='margin-left: 5px;'><span>$checkoutLabel</span></a>
                            <a href='#' style='margin-left: 5px;' class='btn btn-theme-transparent  pull-right' onclick='openCart()' data-toggle='modal' data-target='#popup-cart'><i class='fa fa-shopping-cart'></i> <span class='hidden-xs' id='modalCartButtonText'> $itemCounter $itemsLabel - $qtyLabel $count";if ($showPrices) {echo " $netTotalLabel: $displaySubTotal";}echo "</span> <i class='fa fa-angle-down'></i></a>
                            <!-- Mobile menu toggle button -->
                           $favoriteIcon
                        </div>
                    </div>
        
                ";
          }
     }
?>


        <style>
            @media (max-width: 600px) {
                .header-cart {
                    width:70%;
                }
            }
        </style>

        <script>

            function setLanguage()
            {
                var language = $('#languageSelect').val();

                var currenthref = window.location.href;
                var newhref = '';

                if(currenthref.indexOf('?lang=') > -1)
                {
                    newhref = window.location.href.split('?lang=')[0];
                }
                else if(currenthref.indexOf('lang=') > -1)
                {
                    newhref = window.location.href.split('lang=')[0];
                }
                else {
                    newhref = window.location.href;
                }

                if (newhref.substring(newhref.length-1) == "&")
                {
                    newhref = newhref.substring(0, newhref.length-1);
                }

                if(newhref.indexOf('?') > -1)
                {
                    window.location.href=newhref + "&lang=" + language;
                }
                else
                {
                    window.location.href=newhref + "?lang=" + language;
                }

            }

            function setCurrency()
            {
                var currency = $('#currencySelect').val();

                var currenthref = window.location.href;
                var newhref = '';

                if(currenthref.indexOf('?currency=') > -1)
                {
                    newhref = window.location.href.split('?currency=')[0];
                }
                else if(currenthref.indexOf('currency=') > -1)
                {
                    newhref = window.location.href.split('currency=')[0];
                }
                else {
                    newhref = window.location.href;
                }

                if (newhref.substring(newhref.length-1) == "&")
                {
                    newhref = newhref.substring(0, newhref.length-1);
                }

                if(newhref.indexOf('?') > -1)
                {
                    window.location.href=newhref + "&currency=" + currency;
                }
                else
                {
                    window.location.href=newhref + "?currency=" + currency;
                }

            }

        </script>
        </div>
    </div>
</div>




        <?php

            if($isMobile) {
                echo '</div>';

//            echo '<div class="hidden-md hidden-lg horizontal-scroll" id="mobileHorizontalCategoriesDiv" style="position: sticky;z-index: 9 !important;top: 0;padding-top: 7px;padding-bottom: 8px;border-top: 2px solid lightgrey;border-bottom: 2px solid lightgrey;background-color: white;">';
//            echo getCategories();
//            echo '</div>';

                $db->set_charset("utf8");
                $stm = $db->prepare("SELECT primary_language FROM B2B_Configuration");
                $stm->execute();
                $stm->bind_result($primaryLanguage);
                while ($stm->fetch()) {
                }
                $stm->close();

                $syncCategoriesAfterMinutes = 5;
                $slidingCategories = true;

                if($syncCategoriesAfterMinutes > 0) {

                    if (strcmp($_SESSION['categoriesJson'], '') == 0 || strcmp($_SESSION['categoriesJsonExpiry'], '') == 0) {
                        $_SESSION['categoriesJson'] = getCategoriesJson();
                        $_SESSION['categoriesJsonExpiry'] = date('Y-m-d h:i:s');
                    } else {
                        $dbtimestamp = strtotime($_SESSION['categoriesJsonExpiry']);
                        if (time() - $dbtimestamp > 5 * 60) {
                            $_SESSION['categoriesJson'] = getCategoriesJson();
                            $_SESSION['categoriesJsonExpiry'] = date('Y-m-d h:i:s');
                            $_SESSION['timeLeft'] = time() - $dbtimestamp;
                        }
                    }
                } else {
                    $_SESSION['categoriesJson'] = getCategoriesJson();
                }


                $categoriesJson = $_SESSION['categoriesJson'];

                if($slidingCategories){
                    $sideCategories = categoriesUlListWithPagingFromArray(json_decode($categoriesJson), $primaryLanguage, $themeColor, $langu['categories_label']);
                } else {
                    $sideCategories = categoriesUlListFromArray(json_decode($categoriesJson), $primaryLanguage, $themeColor, $langu['categories_label']);
                }



                echo "<ul class='jsonCat'>" . $sideCategories . "</ul>";
            }

        ?>




<?php

function getCategories(){


    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT primary_language FROM B2B_Configuration");
    $stm-> execute();
    $stm-> bind_result($primaryLanguage);
    while ($stm->fetch()) {}
    $stm-> close();

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT css_theme,theme,footer FROM B2B_Configuration LIMIT 1 ");
    $stm-> execute();
    $stm-> bind_result($cssTheme,$themeColor,$footerLabel);
    while ($stm->fetch()) {
        if($cssTheme <= 1){$cssTheme = '';}
        if(strcmp($themeColor,'')==0){$themeColor='#6796d3';}
    }
    $stm->close();

    $themeColor = strtolower($themeColor);
    if(strcmp($themeColor,'red')==0 || strcmp($themeColor,'Red')==0){
        $themeColor = "firebrick";
    } else if(strcmp($themeColor,'gold')==0 || strcmp($themeColor,'Gold')==0) {
        $themeColor = "goldenrod";
    }  else if(strcmp($themeColor,'darkslateblue')==0 || strcmp($themeColor,'darkSlateBlue')==0) {
        $themeColor = "#1d4f9c";
    } else if(strcmp($themeColor,'navyblue')==0 || strcmp($themeColor,'NavyBlue')==0){
        $themeColor = "#000080";
    } else if(strcmp($themeColor,'black')==0 || strcmp($themeColor,'Black')==0){
        $themeColor = "black";
    } else if(strcmp($themeColor,'yellow')==0 || strcmp($themeColor,'Yellow')==0){
        $themeColor = "yellow";
    } else {
        if(strpos($themeColor,'#')===false ) {
            $themeColor = str_replace('darkdark','dark',"dark$themeColor");
        }
    }
    $stm-> close();
    $result = "<nav >";
    $counterOfCategories = 0;

    if(isset($_SESSION['userID'])) {

        $user=$_SESSION['userID'];

        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();

        if($counterOfCategories>0) {
            $query="SELECT Categories.category_id,name,description FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id,name,description FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }

    } else {
        $query="SELECT Categories.category_id,name,description FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $countCategories = 0;
    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID,$name,$description);
    while ($stm->fetch()) {
        $countCategories++;
        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 && isset($description) && strcmp($description,'')!=0 ) {
            $name=$description;
        }

        if(strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'b2b')==0 || strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'index.php')==0 || strpos($_SERVER['REQUEST_URI'] , '.php') === false){
            $result .= "<a style='font-size:15px;padding: 10px;text-transform:capitalize;color: $themeColor;font-weight: bolder' class='selectCategoryStandard pointer nav-item' data-index='$categoryID'>$name</a>";
        } else {
            $result .= "<a style='font-size:15px;padding: 10px;text-transform:capitalize;color: $themeColor;font-weight: bolder' class='selectCategoryStandard pointer nav-item' href='./index.php?gcid=$categoryID'>$name</a>";
        }



    }
    $result .= '</nav>';

    $result .= "<style>
                    .horizontal-scroll {
                        color: $themeColor !important;
                        white-space: nowrap; /* [1] */
                        overflow-x: auto; /* [2] */
                        -webkit-overflow-scrolling: touch; /* [3] */
                        -ms-overflow-style: -ms-autohiding-scrollbar; /* [4] */ 
                        position: relative;
                        z-index: 999;
                    }
                                
                    .horizontal-scroll::-webkit-scrollbar {
                        display: none; 
                    }
                    
                    .nav-item.active {
                      color: #fff;
                      box-shadow: -1px 0 #727c87, 1px 0 #727c87;
                      background-color: #727c87; }
                    
                    .submenu {
                      height: 0;
                      opacity: 0; }
                    
                    .submenu.active {
                      height: auto;
                      opacity: 1; }
                 </style>";
    
    return $result;
}

function getCategoriesJson(){

    $categoriesArray = array();
    $level = 1;

    global $username,$password,$database;
    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $splitSubcategories = false;
    $stm = $db->prepare("SELECT sub_categories_with_items FROM B2B_Page_Catalogue");
    $stm-> execute();
    $stm-> bind_result($sub_categories_with_items);
    while ($stm->fetch()) {
        if(strcmp($sub_categories_with_items,'yes')==0){
            $splitSubcategories = true;
        }
    }
    $stm-> close();

    if(isset($_SESSION['userID'])) {

        $user=$_SESSION['userID'];

        $stm = $db->prepare("SELECT COUNT(*) FROM B2B_Allow_Categories_User WHERE b2b_user_id='$user'");
        $stm-> execute();
        $stm-> bind_result($counterOfCategories);
        while ($stm->fetch()) {}
        $stm-> close();

        if($counterOfCategories>0) {
            $query="SELECT Categories.category_id,name,description FROM Categories INNER JOIN B2B_Allow_Categories_User ON(Categories.category_id=B2B_Allow_Categories_User.category_id) LEFT JOIN B2B_Categories ON (Categories.category_id=B2B_Categories.category_id) WHERE b2b_user_id='$user' ORDER BY B2B_Categories.position,category_code";
        } else {
            $query="SELECT Categories.category_id,name,description FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id ORDER BY B2B_Categories.position,category_code";
        }

    } else {
        $query="SELECT Categories.category_id,name,description FROM Categories,B2B_Categories WHERE Categories.category_id=B2B_Categories.category_id AND Categories.category_id > 100 ORDER BY B2B_Categories.position,category_code";
    }

    $stm = $db->prepare($query);
    $stm-> execute();
    $stm-> bind_result($categoryID,$name,$description);
    while ($stm->fetch()) {

        $categoryObject = new stdClass();
        $categoryObject->categoryID = $categoryID;
        $categoryObject->name = $name;
        $categoryObject->description = $description;
        $categoryObject->level = $level;
        array_push($categoriesArray, $categoryObject);

    }
    $stm-> close();

    foreach ($categoriesArray as $categoryObject){
        $categoryID = $categoryObject->categoryID;
        if(!$splitSubcategories) {
            $categoryObject->subCategories = getSubCategoriesJson($db, $categoryID, $splitSubcategories, $level);
        } else {
            $categoryObject->subCategories = array();
        }
    }


    return json_encode($categoriesArray);
}

function getSubCategoriesJson($db,$categoryID,$splitSubcategories,$level){

    $level++;
    $subCategoriesArray = array();

    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT Categories.category_id,name,description FROM Subcategories,Categories WHERE  Subcategories.category_id ='$categoryID' AND Categories.category_id=Subcategories.subcategory_id ORDER BY name");
    $stm-> execute();
    $stm-> bind_result($subCategoryID,$subName,$descriptionSub);
    while ($stm->fetch()) {

        $subCategoryObject = new stdClass();
        $subCategoryObject->categoryID = $subCategoryID;
        $subCategoryObject->name = $subName;
        $subCategoryObject->description = $descriptionSub;
        $subCategoryObject->level = $level;
        array_push($subCategoriesArray, $subCategoryObject);

    }
    $stm-> close();

    foreach ($subCategoriesArray as $subCategoryObject){
        $subCategoryID = $subCategoryObject->categoryID;
        $subCategoryObject->subCategories = getSubCategoriesJson($db,$subCategoryID,$splitSubcategories,$level);
    }


    return $subCategoriesArray;

}

function categoriesUlListFromArray($array,$primaryLanguage,$themeColor,$categoriesLabel,$mainLevel = true){
    $result = '';

    if($mainLevel){
        $result .= "<div  id='categoriesGlobalNav' class='globalNav' style='margin-left: -7px;z-index: 10000 !important;'>
        <a href='javascript:void(0)' class='closebtn' style='width: 100%;' onclick='closeNav()'>
            <span class='pull-left closelabel' id='globalCategoriesNavTitle' style='color: $themeColor !important;' >&nbsp;&nbsp;<b>$categoriesLabel</b></span>
            <span class='pull-right ' style='margin-top:0px;color: $themeColor !important;' onclick='closeNav()'>&times;</span>
        </a><br>
        <ul style='text-transform:capitalize;margin-left: -18px;'>";
    }


    if(strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'b2b')==0 || strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'index.php')==0 || strpos($_SERVER['REQUEST_URI'] , '.php') === false) {
        $onIndexPage = true;
    } else {
        $onIndexPage = false;
    }

    foreach ($array as $category) {
        $categoryID = $category->categoryID;
        $name = $category->name;
        $description = $category->description;
        $subCategories = $category->subCategories;
        $thisLevel = $category->level;
        $nextLevel = $category->level + 1;

        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($description) && strcmp($description,'')!=0 ) {
            $name=$description;
        }

        $result .= "<li class='cop-category' style='padding-top:8px;padding-bottom:4px;display: block;text-transform:capitalize;box-shadow: rgba(0, 0, 0, 0.04) 0px 20px 25px -5px, rgba(0, 0, 0, 0.04) 0px 10px 10px -5px;'>";
        if(empty($subCategories)){
            if($onIndexPage) {
                $result .= "<a  class='selectCategoryStandard pointer' data-index='$categoryID' onclick='closeNav()'>$name</a>";
            } else {
                $result .= "<a  class='selectCategoryStandard pointer' href='./index.php?gcid=$categoryID' onclick='closeNav()'>$name</a>";
            }
        } else {
            if($onIndexPage) {
                $result .= "<a  class='selectCategoryStandard pointer' data-index='$categoryID' onclick='toggleSubCategoryDisplay(this,1);'><span style='width: fit-content !important;display: inline;' onclick='closeNav()'>$name</span>&nbsp;&nbsp;&nbsp;&nbsp;<span style='display: inline;' id='categoryToggleTriangle' ><i class=\"fa fa-sort-desc\"></i></span></a>";
            } else {
                $result .= "<a  class='selectCategoryStandard pointer' onclick='toggleSubCategoryDisplay(this,1);' ><span style='width: fit-content !important;display: inline;' onclick='closeNav();window.location.href=\"./index.php?gcid=$categoryID\"'>$name</span>&nbsp;&nbsp;&nbsp;&nbsp;<span style='display: inline;' id='categoryToggleTriangle' ><i class=\"fa fa-sort-desc\"></i></span></a>";
            }
            $result .= "<ul class='children level$nextLevel' style='text-transform:capitalize;max-height:0 !important;overflow:hidden !important;'>";
            $result .= categoriesUlListFromArray($subCategories,$primaryLanguage,$themeColor,$categoriesLabel,false);
            $result .= "</ul>";
        }
        $result .= "</li>";
    }

    if($mainLevel){
        $result .= "</ul></div>";
        $result .= "<style>
                        
                        .globalNav {height: 100%;width: 0;position: fixed;z-index: 1;top: 0;left: 0;background-color: ghostwhite;overflow-x: hidden;transition: 0.5s;padding-top: 60px;}
            
                        .globalNav a {padding: 8px 8px 8px 20px;text-decoration: none;font-size: 15px !important;color: dimgrey;display: block;transition: 0.3s;}
                        
                        .globalNav a:hover {color: dimgrey;background-color: whitesmoke}
                        
                        .globalNav .closebtn {position: absolute;top: 0;right: 0px;font-size: 36px !important;padding-top: 0px;padding-right: 20px;}
                        
                        .globalNav .closelabel {position: absolute;top: 14px;left: 7px;font-size: 20px !important;padding-top: 0px;padding-right: 20px;color: $themeColor;background-color: transparent;}
                        
                        .globalNav .closebtn:hover {color: $themeColor;background-color: transparent;font-weight: bolder;}
                        
                        @media screen and (max-height: 450px) {.globalNav {padding-top: 15px;}.globalNav a {font-size: 16px;}}
            
            
                    </style>";

        $result .= "<script type='text/javascript' >
                        function toggleSubCategoryDisplay(element,active){

                            if(active > 0){
                                $(element).parent().find('ul').attr('style', 'max-height:5000px !important;transition: max-height 0.25s ease-in !important;');
                                $(element).parent().find('ul').find('li').find('ul').attr('style', 'padding-left:20px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                $(element).attr('onclick','toggleSubCategoryDisplay(this,0);');
                                $(element).find('#categoryToggleTriangle').html('<i class=\"fa fa-sort-asc\"></i>');
                            } else {
                                $(element).parent().find('ul').attr('style', 'padding-left:20px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                $(element).attr('onclick','toggleSubCategoryDisplay(this,1);');  
                                $(element).find('#categoryToggleTriangle').html('<i class=\"fa fa-sort-desc\"></i>');
                            }
                        }
                        
                        function openNav() {
                            $('#categoriesGlobalNav').css('width','102%');           
                            $('#globalCategoriesNavTitle').css('opacity','0').stop().delay(400).animate({opacity: 1},200);
                        }
                        
                        function closeNav() {
                            $('#categoriesGlobalNav').css('width','0');           
                            $('#globalCategoriesNavTitle').animate({opacity: 0},100);
                        }
                        
                        $('.selectCategoryStandard').unbind('click').click(function () {
                            var valueCategry = $(this).data('index');
                            var categoryName = $(this).text();

                            $('.mainslidersection').css('display', 'none');
                            if (screen.width <= 480) {
                                $('.content-area').css('margin-top', '5px');
                                document.getElementById('productGrid').scrollIntoView();
                            } else {
                                $('.content-area').css('margin-top', '75px');
                            }

                            $('#categoryPath').hide();

                            $.cookie('currentCategoryName', categoryName);

                            $.cookie('currentCategory', valueCategry);
                            $.cookie('pageNumber', 1);
                            getItemsInCategory(valueCategry, 1, recordsPerPage);
                            $('#promoCategoriesContainer').show();
                            $(this).parent().find('.arrow').click();
                        });
                    </script>";
    }


    return $result;

}

function categoriesUlListWithPagingFromArray($array,$primaryLanguage,$themeColor,$categoriesLabel,$mainLevel = true){
    $result = '';

    if($mainLevel){
        $result .= "<div  id='categoriesGlobalNav' class='globalNav' style='margin-left: -7px;z-index: 10000 !important;'>
        <a href='javascript:void(0)' class='closebtn' style='width: 100%;box-shadow: rgba(0, 0, 0, 0.02) 0px 20px 25px -5px, rgba(0, 0, 0, 0.02) 0px 10px 10px -5px;' onclick='closeNav()'>
            <span class='pull-left closelabel' id='globalCategoriesNavTitle' style='color: $themeColor !important;' >&nbsp;&nbsp;<b>$categoriesLabel</b></span>
            <span class='pull-right ' style='margin-top:0px;color: $themeColor !important;' onclick='closeNav()'>&times;</span>
        </a><br>
        
        <ul style='text-transform:capitalize;margin-left: -18px;'>
        <li class='cop-category'  id='thisMobileCategoryLink' style='padding-top:8px;padding-bottom:4px;display: block;text-transform:capitalize;box-shadow: rgba(0, 0, 0, 0.02) 0px 20px 25px -5px, rgba(0, 0, 0, 0.02) 0px 10px 10px -5px;'></li>";
    }


    if(strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'b2b')==0 || strcmp(basename($_SERVER['REQUEST_URI'], '?' . $_SERVER['QUERY_STRING']),'index.php')==0 || strpos($_SERVER['REQUEST_URI'] , '.php') === false) {
        $onIndexPage = true;
    } else {
        $onIndexPage = false;
    }

    foreach ($array as $category) {
        $categoryID = $category->categoryID;
        $name = $category->name;
        $description = $category->description;
        $subCategories = $category->subCategories;
        $thisLevel = $category->level;
        $nextLevel = $category->level + 1;
        $prevLevel = $category->level - 1;

        if(strcmp($_SESSION['lang'],$primaryLanguage)!=0 &&isset($description) && strcmp($description,'')!=0 ) {
            $name=$description;
        }

        $result .= "<li class='cop-category categoryLevel$thisLevel ' style='padding-top:8px;padding-bottom:4px;display: block;text-transform:capitalize;box-shadow: rgba(0, 0, 0, 0.02) 0px 20px 25px -5px, rgba(0, 0, 0, 0.02) 0px 10px 10px -5px;'>";
        if(empty($subCategories)){
            if($onIndexPage) {
                $result .= "<a  class='selectCategoryStandard pointer' id='categoryIdentifier$categoryID' data-level='$thisLevel' data-index='$categoryID' onclick='closeNav()'>$name</a>";
            } else {
                $result .= "<a  class='selectCategoryStandard pointer' id='categoryIdentifier$categoryID' data-level='$thisLevel' href='./index.php?gcid=$categoryID' onclick='closeNav()'>$name</a>";
            }
        } else {
            if($onIndexPage) {
                $result .= "<a  class='selectCategoryStandard pointer categoryLevel$thisLevel' id='categoryIdentifier$categoryID' data-level='$thisLevel' data-index='$categoryID' onclick='toggleSubCategorySlideDisplay(this,1,$categoryID,\"$name\");'><span style='width: fit-content !important;display: inline;' id='categoryName$categoryID' >$name</span><span style='width: fit-content !important;margin-top:-".$thisLevel."px;display: none;' id='categorybackButton$categoryID' ><i class=\"fa fa-angle-double-left\"></i>&nbsp;&nbsp;BACK</span>&nbsp;&nbsp;&nbsp;&nbsp;<span style='display: inline;' id='categoryToggleTriangle' ><i class=\"fa fa-angle-right\"></i></span></a>";
            } else {
                $result .= "<a  class='selectCategoryStandard pointer categoryLevel$thisLevel' id='categoryIdentifier$categoryID' data-level='$thisLevel' onclick='toggleSubCategorySlideDisplay(this,1,$categoryID,\"$name\");' ><span style='width: fit-content !important;display: inline;' id='categoryName$categoryID' >$name</span><span style='width: fit-content !important;margin-top:-".$thisLevel."px;display: none;' id='categorybackButton$categoryID' ><i class=\"fa fa-angle-double-left\"></i>&nbsp;&nbsp;BACK</span>&nbsp;&nbsp;&nbsp;&nbsp;<span style='display: inline;' id='categoryToggleTriangle' ><i class=\"fa fa-angle-right\"></i></span></a>";
            }
            $result .= "<ul class='children level$nextLevel categoryLevel$thisLevel' style='padding-left: 0px !important;text-transform:capitalize;max-height:0 !important;overflow:hidden !important;'>";
            $result .= categoriesUlListWithPagingFromArray($subCategories,$primaryLanguage,$themeColor,$categoriesLabel,false);
            $result .= "</ul>";
        }
        $result .= "</li>";
    }

    if($mainLevel){
        $result .= "</ul></div>";
        $result .= "<style>
                        
                        .globalNav {height: 100%;width: 0;position: fixed;z-index: 1;top: 0;left: 0;background-color: ghostwhite;overflow-x: hidden;transition: 0.2s;padding-top: 60px;}
            
                        .globalNav a {padding: 8px 8px 8px 20px;text-decoration: none;font-size: 15px !important;color: dimgrey;display: block;transition: 0.2s;}
                        
                        .globalNav a:hover {color: dimgrey;}
                        
                        .globalNav .closebtn {position: absolute;top: 0;right: 0px;font-size: 36px !important;padding-top: 0px;padding-right: 20px;}
                        
                        .globalNav .closelabel {position: absolute;top: 14px;left: 7px;font-size: 20px !important;padding-top: 0px;padding-right: 20px;color: $themeColor;background-color: transparent;}
                        
                        .globalNav .closebtn:hover {color: $themeColor;background-color: transparent;font-weight: bolder;}
                        
                        .back-active {box-shadow: rgba(0, 0, 0, 0.02) 0px 20px 25px -5px, rgba(0, 0, 0, 0.02) 0px 10px 10px -5px;}
                        
                        @media screen and (max-height: 450px) {.globalNav {padding-top: 15px;}.globalNav a {font-size: 16px;}}
            
            
                    </style>";

        $result .= "<script type='text/javascript' >
                        function toggleSubCategorySlideDisplay(element,active,id,title){
                            
                            var onIndexID = $(element).data('index');
                            var level = $(element).data('level');
                            var prevLevel   = level - 1;
                            if(onIndexID != id){
                                $('#thisMobileCategoryLink').html('<a href=\"./index.php?gcid='+id+'\" style=\"font-size:15px;padding: 10px;text-transform:capitalize;color: $themeColor;font-weight: bolder\">&nbsp;'+title+'&nbsp;&nbsp;<i class=\"fa fa-angle-right\"></i></a>');
                            } else {
                                $('#thisMobileCategoryLink').html('<a class=\"selectCategoryStandard pointer\" data-index=\"'+id+'\" onclick=\"closeNav()\" style=\"font-size:15px;padding: 10px;text-transform:capitalize;color: $themeColor;font-weight: bolder\">&nbsp;'+title+'&nbsp;&nbsp;<i class=\"fa fa-angle-right\"></i></a>');
                                bindCategoriesMobile();
                            }
                            
                            $('.back-active').hide();
                            
                            
                            if(active > 0){
                                $('.back-active-'+prevLevel).hide();
                                $('.categoryLevel'+level).hide();
                                $('#categoryIdentifier'+id).show();
                                $(element).parent().show();
                                $(element).parent().find('ul').attr('style', 'padding-left:0px !important;max-height:5000px !important;transition: max-height 0.25s ease-in !important;');
                                $(element).parent().find('ul').find('li').find('ul').attr('style', 'padding-left:0px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                $(element).attr('onclick','toggleSubCategorySlideDisplay(this,0,'+id+',\"'+title+'\");');  
                                $(element).find('#categoryToggleTriangle').html('');
                                $(element).find('#categorybackButton'+id).show();
                                $(element).find('#categoryName'+id).hide();
                                $(element).addClass('back-active');
                                $(element).addClass('back-active-'+level);
                            } else {
                                $('.back-active-'+prevLevel).show();
                                $('.categoryLevel'+level).show();
                                $('#categoryIdentifier'+id).show();
                                $(element).parent().show();
                                $(element).parent().find('ul').attr('style', 'padding-left:0px !important;transition: max-height 0.02s ease-out !important;max-height:0 !important;overflow:hidden !important;');
                                $(element).attr('onclick','toggleSubCategorySlideDisplay(this,1,'+id+',\"'+title+'\");');  
                                $(element).find('#categoryToggleTriangle').html('<i class=\"fa fa-angle-right\"></i>');
                                $(element).find('#categorybackButton'+id).hide();
                                $(element).find('#categoryName'+id).show();
                                $(element).removeClass('back-active');
                                $(element).removeClass('back-active-'+level);

                            }
                            

                        }
                        
                        
                        function openNav() {
                            $('#categoriesGlobalNav').css('width','102%');           
                            $('#globalCategoriesNavTitle').css('opacity','0').stop().delay(100).animate({opacity: 1},100);
                            $('.globalNav a').css('opacity','0').stop().delay(100).animate({opacity: 1},100);
                        }
                        
                        function closeNav() {
                            $('#categoriesGlobalNav').css('width','0');           
                            $('#globalCategoriesNavTitle').animate({opacity: 0},100);
                            $('.globalNav a').css('opacity','0');
                        }
                        
                        function bindCategoriesMobile(){
                        
                            $('.selectCategoryStandard').unbind('click').click(function () {
                                var valueCategry = $(this).data('index');
                                var categoryName = $(this).text();
    
                                $('.mainslidersection').css('display', 'none');
                                if (screen.width <= 480) {
                                    $('.content-area').css('margin-top', '5px');
                                    document.getElementById('productGrid').scrollIntoView();
                                } else {
                                    $('.content-area').css('margin-top', '75px');
                                }
    
                                $('#categoryPath').hide();
    
                                $.cookie('currentCategoryName', categoryName);
    
                                $.cookie('currentCategory', valueCategry);
                                $.cookie('pageNumber', 1);
                                getItemsInCategory(valueCategry, 1, recordsPerPage);
                                $('#promoCategoriesContainer').show();
                                $(this).parent().find('.arrow').click();
                            });
                        }
                        
                        bindCategoriesMobile();
                        
                    </script>";
    }


    return $result;

}


?>