<?php
session_start();
if(!isset($_SESSION['customerID']) ) {
    redirect("login.php");
}
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
include_once("../param.php");
require("./dbaccess/dbhelper.php");
$serviceCallID=$_POST['serviceCallID'];
include_once("headerImports.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");
$stm = $db->prepare("SELECT primary_language,show_prices,css_theme FROM B2B_Configuration");
$stm-> execute();
$stm-> bind_result($primaryLanguage,$showPrices,$cssTheme);

while ($stm->fetch()) {
    if(strcmp($showPrices,"no")==0)
    {
        $showPrices=false;
    }
    if($cssTheme <= 1){
        $cssTheme = '';
    }
}
$stm-> close();
$stm = $db->prepare("SELECT service_call_id,service_call_code,topic,details,status_name FROM Service_Call, SC_Status WHERE SC_Status.status_id=SC_Status.status_id AND service_call_id='$serviceCallID' AND customer_id='".$_SESSION['customerID']."'");
$stm-> execute();
$stm-> bind_result($resolverServiceCallID,$serviceCallCode,$topic,$details,$status);
while ($stm->fetch()) {}
$stm-> close();

?>

<body id="home" class="wide">
        <!-- PRELOADER -->
        <div id="preloader">
            <div id="preloader-status">
                <div class="spinner">
                    <div class="rect1"></div>
                    <div class="rect2"></div>
                    <div class="rect3"></div>
                    <div class="rect4"></div>
                    <div class="rect5"></div>
                </div>
                <div id="preloader-title">Loading</div>
            </div>
        </div>
        <!-- /PRELOADER -->

        <!-- WRAPPER -->
        <div class="wrapper">

            <!-- Popup: Shopping cart items -->
            <div class="modal fade popup-cart" id="popup-cart" tabindex="-1" role="dialog" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="container">
                        <div class="cart-items">

                        </div>
                    </div>
                </div>
            </div>
            <!-- /Popup: Shopping cart items -->

            <!-- HEADER -->
            <header class="header fixed">
                <?php
                $topmenu = "topMenu$cssTheme.php";

                if(strcmp($topmenu,"topMenu2.php")==0){
                    echo '<header class="header fixed" style="border: 0px;">';
                } else {
                    echo '<header class="header fixed" >';
                }

                include_once("$topmenu");
                if(strcmp($topmenu,"topMenu.php")==0) {
                    include_once("navigationMenu.php");
                }
                ?>
            </header>
            <!-- /HEADER -->

            <!-- CONTENT AREA -->
            <div class="content-area">

                <!-- PAGE -->
                <section class="page-section color">
                    <div class="container" id="checkoutContainer">
                        <h3 class="block-title alt"><i class="fa fa-angle-down"></i>Service Call</h3>
                        <div id="checkoutCartContainer">
                            <div class='col-md-12' style="padding-top:10px;padding-left:0">
                                <h4 style="color:black"><b>Code   :</b>  <?php echo" $serviceCallCode"?></h4>
                                <h4 style="color:black"><b>Topic  :</b><?php echo" $topic"?></h4>
                                <h4 style="color:black"><b>Status :</b><?php echo" $status"?></h4>
                            </div>
                            <div class='row orders'>
                                <div class='col-md-12'  style="margin-top:5px">
                                    <table id="datatable_fixed_column_responses" class="table table-striped table-hover dataTable" width="100%">
                                        <thead style="border: solid 1px #888">
                                        <tr>
                                            <th class='text-center'></th>
                                            <th class='text-center'>Date</th>
                                            <th class='text-center'>User</th>
                                            <th class='text-center'>Reply Type</th>
                                            <th class='text-center'>Text</th>
                                        </tr>
                                        </thead>
                                    </table>
                                </div>
                            </div>

                        <div class="overflowed">
                            <a class="btn btn-theme btn-theme-dark" href="./serviceCall-history.php">Back to Service Calls</a>

                        </div>



                    </div>
                </section>
                <!-- /PAGE -->

            </div>
            <!-- /CONTENT AREA -->

            <!-- FOOTER -->
            <footer class="footer">
                <div class="footer-meta">
                    <div class="container">
                        <div class="row">
                            <div class="col-sm-6" style="margin-top:20px;font-size:16px;">

                            </div>
                        </div>
                    </div>
                </div>
            </footer>
            <!-- /FOOTER -->

            <div id="to-top" class="to-top"><i class="fa fa-angle-up"></i></div>

        </div>
        <!-- /WRAPPER -->

        <!-- JS Global -->
        <script src="assets/plugins/jquery/jquery-1.11.1.min.js"></script>
        <script src="assets/plugins/bootstrap/js/bootstrap.min.js"></script>
        <script src="assets/plugins/bootstrap-select/js/bootstrap-select.min.js"></script>
        <script src="assets/plugins/superfish/js/superfish.min.js"></script>
        <script src="assets/plugins/prettyphoto/js/jquery.prettyPhoto.js"></script>
        <script src="assets/plugins/jquery.sticky.min.js"></script>
        <script src="assets/plugins/jquery.easing.min.js"></script>
        <script src="assets/plugins/jquery.smoothscroll.min.js"></script>
        <script src="assets/plugins/smooth-scrollbar.min.js"></script>

        <script src="assets/js/jquery-scrolltofixed-min.js"></script>

        <!-- JS Page Level -->
        <script src="assets/js/theme.js"></script>

        <!--[if (gte IE 9)|!(IE)]><!-->
        <script src="assets/plugins/jquery.cookie.js"></script>
        <!--<![endif]-->
        <script src="//cdn.datatables.net/1.10.12/js/jquery.dataTables.min.js"></script>
        <link href="//cdn.datatables.net/1.10.12/css/jquery.dataTables.min.css" rel="stylesheet">

        <script src="assets/js/waitMe.min.js"></script>

<script  type="text/javascript">

    $(document).ready(function() {

        var responsiveHelper_datatable_fixed_column = undefined;

        $('#datatable_fixed_column_responses').DataTable({
            "sDom": "<<f><l>r>"+
                "t"+
                "<p>",
            "autoWidth" : true,
            "order": [[ 0, "desc" ]],
            "processing": true,
            "serverSide": true,
            "ajax": "dbaccess/getServiceCallRepliesForB2BServiceCall.php?serviceCallID=<?php echo $resolverServiceCallID?>",
            "columns": [
                { "data": "img" },
                { "data": "date" },
                { "data": "salesperson" },
                { "data": "replytype" },
                { "data": "text" }
            ],
            "order": [[ 1, "desc" ]],
            "deferRender": true
        });

    })
</script>


    </body>
</html>