<?php

include_once("../../../../param.php");
require(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID = $_SESSION['companyID'];
$orderID   = 0;
$invoiceID = 0;

$bank           = trim(''.$_POST['bank']);
$notes          = trim(''.$_POST['notes']);
$branch         = trim(''.$_POST['branch']);
$amount         = trim(''.$_POST['amount']);
$customerID     = trim(''.$_POST['customerID']);
$chequeDate     = trim(''.$_POST['chequeDate']);
$receiptDate    = trim(''.$_POST['receiptDate']);
$chequeNumber   = trim(''.$_POST['chequeNumber']);
$cashDiscount   = trim(''.$_POST['cashDiscount']);
$salespersonID  = trim(''.$_POST['salesperson']);
$paymentMethod  = trim(''.$_POST['paymentMethod']);
$receiptAddress = trim(''.$_POST['receiptAddress']);
$serviceCallID  = trim(''.$_POST['serviceCallID']);

$checkedInvoices =  array();
$checkedInvoices = $_POST['checkedInvoices'];

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $receiptID   = getNextKeySingleTransaction("Receipts", "receipt_id", $db);
    $receiptCode = getNextCodeSingleTransaction("Receipts", "receipt_code", "R", "CLOUD", $db);

    if (strcmp($receiptCode, '') == 0) {
        $receiptCode = getNextReceiptCode("CLOUD", $db);
    }

    $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiiidsdssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes);
    $stmt->execute();
    if(strcmp("$stmt->error","")!=0) {throw new Exception();}
    $stmt->close();

    lockDocumentSingleTransaction($receiptID, "Receipts", $db);

    $detailsTra    = "Receipt $receiptCode";
    $receiptAmount = floatval($amount) + floatval($cashDiscount);

    foreach ($checkedInvoices as $invoice) {

        $stmt = $db->prepare("SELECT Invoices.grand_total, sum(Invoice_Receipt.amount) FROM Invoices LEFT JOIN Invoice_Receipt ON (Invoices.invoice_id = Invoice_Receipt.invoice_id) WHERE Invoices.invoice_id='$invoice'");
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->bind_result($invoiceTotal, $invoicePaid);
        while ($stmt->fetch()) {
        }
        $stmt->close();

        $pendingPayment = floatval($invoiceTotal) - floatval($invoicePaid);

        if ($receiptAmount != 0) {

            if ($pendingPayment > $receiptAmount) {
                $payment = $receiptAmount;
                $receiptAmount = 0;
//                $cashDiscount = 0;
                $status = "Partially Paid";
            } else {
                $payment = $pendingPayment;
                $receiptAmount -= $pendingPayment;
                $status = "Paid";
            }

            $stmt = $db->prepare("INSERT INTO Invoice_Receipt (receipt_id, invoice_id, amount) VALUES(?,?,?)");
            $stmt->bind_param('iid', $receiptID, $invoice, $payment);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

            $stmt = $db->prepare("UPDATE Invoices SET status=? WHERE invoice_id=?");
            $stmt->bind_param('si', $status, $invoice);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();

        }

    }

    if ($amount > 0) {

        $sign = -1;
        $payment -= floatval($cashDiscount);
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        updateCustomerBalance($customerID, $amount, $db);
    }

    if (floatval($cashDiscount) > 0) {

        $sign = -1;
        $detailsTra .= " Receipt Discount";
        $receiptCodeCD = $receiptCode . "-D";
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $cashDiscount, $detailsTra);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        updateCustomerBalance($customerID, $cashDiscount, $db);

    }

    if (intval($serviceCallID) > 0) {
        date_default_timezone_set('Europe/Athens');
        $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
        $status = 0;
        $timezone = 2;
        $date = date("Y-m-d H:i:s");
        $replyTypeID = 3;
        $details = "New Receipt Issued";
        $documentType = "Receipts";
        $salespersonTo = 0;
        $emailResponse = "";
        $priorityID = 0;
        $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonID, $status, $date, $replyTypeID, $details, $receiptID, $documentType, $salespersonTo, $emailResponse, $priorityID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();
    }

    $custTable = new CustomTable('Receipts', $receiptID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    if (intval($serviceCallID) > 0) {
        echo "$receiptID&service_call_id=$serviceCallID";
    } else {
        echo "$receiptID";
    }

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Receipts',$receiptID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}


			
			
						
 
				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>