<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ERROR);

$contractID= intval($_GET['contract_id']);


if(strcmp($contractID,'')!=0 && $contractID > 0) {

    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $contracts = array();
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT customer_id, customer_address_id, item_id, serial_number_id, salesperson_id, contract_type_id, serial_number_transaction_log_id, start_date, end_date, price, due_date, valid, payment_type_id, payment_date, way_of_payment_id, technician_id, attachment_id, notes, troubleshooting_id, date_of_purchase, price2, price3, total1, total2, timestamp FROM Contracts WHERE contract_id =? LIMIT 1");
    $stm->bind_param('i', $contractID);
    $stm->execute();
    $stm->bind_result($customer_id, $customer_address_id, $item_id, $serial_number_id, $salesperson_id, $contract_type_id, $serial_number_transaction_log_id, $start_date, $end_date, $price, $due_date, $valid, $payment_type_id, $payment_date, $way_of_payment_id, $technician_id, $attachment_id, $notes, $troubleshooting_id, $date_of_purchase, $price2, $price3, $total1, $total2, $timestamp);
    while ($stm->fetch()) {
        $contract = new stdClass();
        $contract->contract_id = $contractID;
        $contract->customer_id = $customer_id;
        $contract->customer_address_id = $customer_address_id;
        $contract->item_id = $item_id;
        $contract->serial_number_id = $serial_number_id;
        $contract->salesperson_id = $salesperson_id;
        $contract->contract_type_id = $contract_type_id;
        $contract->serial_number_transaction_log_id = $serial_number_transaction_log_id;
        $contract->start_date = $start_date;
        $contract->end_date = $end_date;
        $contract->price = $price;
        $contract->due_date = $due_date;
        $contract->valid = $valid;
        $contract->payment_type_id = $payment_type_id;
        $contract->payment_date = $payment_date;
        $contract->way_of_payment_id = $way_of_payment_id;
        $contract->technician_id = $technician_id;
        $contract->attachment_id = $attachment_id;
        $contract->notes = $notes;
        $contract->troubleshooting_id = $troubleshooting_id;
        $contract->date_of_purchase = $date_of_purchase;
        $contract->price2 = $price2;
        $contract->price3 = $price3;
        $contract->total1 = $total1;
        $contract->total2 = $total2;
        $contract->timestamp = $timestamp;
        array_push($contracts, $contract);

    }
    $stm->close();

    foreach ($contracts as $contract) {
        $prev_contract_id = intval($contract->contract_id);
        $customer_id = intval($contract->customer_id);
        $customer_address_id = intval($contract->customer_address_id);
        $item_id = intval($contract->item_id);
        $serial_number_id = intval($contract->serial_number_id);
        $salesperson_id = intval($contract->salesperson_id);
        $contract_type_id = intval($contract->contract_type_id);
        $serial_number_transaction_log_id = intval($contract->serial_number_transaction_log_id);
        $start_date = "$contract->start_date";
        $end_date = "$contract->end_date";
        $price = "$contract->price";
        $due_date = "$contract->due_date";
        $valid = "$contract->valid";
        $payment_type_id = intval($contract->payment_type_id);
        $payment_date = "$contract->payment_date";
        $way_of_payment_id = intval($contract->way_of_payment_id);
        $technician_id = intval($contract->technician_id);
        $attachment_id = intval($contract->attachment_id);
        $notes = "$contract->notes";
        $troubleshooting_id = intval($contract->troubleshooting_id);
        $date_of_purchase = "$contract->date_of_purchase";
        $price2 = "$contract->price2";
        $price3 = "$contract->price3";
        $total1 = "$contract->total1";
        $total2 = "$contract->total2";
        $timestamp = "$contract->timestamp";

        $valid = 'no';

        if(strcmp($start_date,'')!=0 && strcmp($end_date,'')!=0){
            $contract_period_days = (strtotime($end_date) - strtotime($start_date)) / (60 * 60 * 24);
            $contract_period_days = intval($contract_period_days);
            $contract_period_days++;

            $new_start_date = date('Y-m-d', strtotime($end_date . ' + 1 days'));
            $new_end_date = date('Y-m-d', strtotime($new_start_date . ' + ' . $contract_period_days . ' days'));

            $start_date = "$new_start_date";
            $end_date = "$new_end_date";
        }

        $entryDate = date('Y-m-d');
        $serial_number_transaction_type_id=3;

        $serial_number_transaction_log_id = getNextKey("Serial_Number_Transaction_Log","serial_number_transaction_log_id");
        $stmt = $db->prepare("INSERT INTO Serial_Number_Transaction_Log (serial_number_transaction_log_id,serial_number_id,customer_id,customer_address_id,entry_date,start_date,end_date,serial_number_transaction_type_id,timestamp) VALUES(?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiisssi', $serial_number_transaction_log_id, $serial_number_id, $customer_id, $customer_address_id, $entryDate, $start_date, $end_date, $serial_number_transaction_type_id);
        $stmt->execute();
        $stmt->close();

        $contract_id = getNextKeySingleTransaction('Contracts','contract_id',$db);
        $stmt = $db->prepare("INSERT INTO Contracts (contract_id,customer_id,customer_address_id,item_id,serial_number_id,salesperson_id,contract_type_id,serial_number_transaction_log_id,start_date,end_date,price,due_date,valid,payment_type_id,payment_date,way_of_payment_id,technician_id,troubleshooting_id,notes,timestamp) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('iiiiiiiissdssisiiis', $contract_id, $customer_id, $customer_address_id, $item_id, $serial_number_id, $salesperson_id, $contract_type_id, $serial_number_transaction_log_id, $start_date, $end_date, $price, $due_date, $valid, $payment_type_id, $payment_date, $way_of_payment_id, $technician_id, $troubleshooting_id, $notes);
        $stmt->execute();
        echo $stmt->error;
        $stmt->close();

        $contractSchedules = array();
        $stm =$db->prepare("SELECT contract_schedule_id, service_call_id, contract_type_id, assign_salesperson_id,referred_salespersons, type_of_schedule, start_date, start_time, end_time, days, months, days_of_month, last_run_date, next_run_date, details, schedule_status,service_call_type_id, timestamp FROM Contract_Schedules WHERE contract_id = ?");
        $stm->bind_param('i',$prev_contract_id);
        $stm-> execute();
        $stm-> bind_result($contract_schedule_id, $service_call_id, $contract_type_id, $assign_salesperson_id,$referred_salespersons, $type_of_schedule, $start_date, $start_time, $end_time, $days, $months, $days_of_month, $last_run_date, $next_run_date, $details, $schedule_status,$scTypeID, $timestamp);
        while ($stm->fetch()) {
            $contractSchedule = new stdClass();
            $contractSchedule->contract_schedule_id = $contract_schedule_id;
            $contractSchedule->service_call_id = $service_call_id;
            $contractSchedule->contract_type_id = $contract_type_id;
            $contractSchedule->assign_salesperson_id = $assign_salesperson_id;
            $contractSchedule->referred_salespersons = $referred_salespersons;
            $contractSchedule->type_of_schedule = $type_of_schedule;
            $contractSchedule->start_date = $start_date;
            $contractSchedule->start_time = $start_time;
            $contractSchedule->end_time = $end_time;
            $contractSchedule->days = $days;
            $contractSchedule->months = $months;
            $contractSchedule->days_of_month = $days_of_month;
            $contractSchedule->last_run_date = $last_run_date;
            $contractSchedule->next_run_date = $next_run_date;
            $contractSchedule->details = $details;
            $contractSchedule->schedule_status = $schedule_status;
            $contractSchedule->service_call_type_id = $scTypeID;
            $contractSchedule->timestamp = $timestamp;
            array_push($contractSchedules, $contractSchedule);
        }
        $stm-> close();

        foreach ($contractSchedules as $contractSchedule) {
            $serviceCallID = intval($contractSchedule->service_call_id);
            $contractTypeID = intval($contractSchedule->contract_type_id);
            $salespersonID = intval($contractSchedule->assign_salesperson_id);
            $scheduleScReferred = "$contractSchedule->referred_salespersons";
            $scheduleType = "$contractSchedule->type_of_schedule";
            $scheduleStartDate = "$contractSchedule->start_date";
            $scheduleStartDateTime = "$contractSchedule->start_time";
            $scheduleEndDateTime = "$contractSchedule->end_time";
            $scheduleDays = "$contractSchedule->days";
            $scheduleMonths = "$contractSchedule->months";
            $daysOfMonth = "$contractSchedule->days_of_month";
            $lastRunDate = "$contractSchedule->last_run_date";
            $nextExecutionDateTime = "$contractSchedule->next_run_date";
            $scheduleName = "$contractSchedule->details";
            $scheduleStatus = "$contractSchedule->schedule_status";
            $scheduleScType = intval($contractSchedule->service_call_type_id);

            $contractScheduleID = getNextKeySingleTransaction("Contract_Schedules", "contract_schedule_id",$db);
            $stmt = $db->prepare("INSERT INTO Contract_Schedules (contract_schedule_id, contract_id, service_call_id, contract_type_id, assign_salesperson_id, referred_salespersons, type_of_schedule, start_date, start_time, end_time, days, months, days_of_month, last_run_date, next_run_date, details, schedule_status,service_call_type_id, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
            $stmt->bind_param('iiissssssssssssssi', $contractScheduleID, $contract_id, $serviceCallID, $contractTypeID, $salespersonID,$scheduleScReferred, $scheduleType, $scheduleStartDate, $scheduleStartDateTime, $scheduleEndDateTime, $scheduleDays, $scheduleMonths, $daysOfMonth, $lastRunDate, $nextExecutionDateTime, $scheduleName, $scheduleStatus,$scheduleScType);
            $stmt->execute();
            $error = $stmt->error;
            $stmt->close();
        }

        $customTable = new CustomTable('Contracts',$prev_contract_id);
        $customTable->copyCustomTableValues($contract_id,$db);

        redirect("//".HTML_PATH."/cop/backend/core/views/addedit/new_contract.php?contract_id=$contract_id");
        break;

    }
}







function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}
?>