<?php


use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

include_once("../../../param.php");
require_once(ROOT . "concc/dbhelper.php");

//include_once(ROOT . "libs/emailer/PHPMailer/PHPMailer.php");
//include_once(ROOT . "libs/emailer/PHPMailer/Exception.php");
//include_once(ROOT . "libs/emailer/PHPMailer/SMTP.php");

include_once(ROOT . "libs/emailer/PHPMailer8/vendor/autoload.php");

$db = new mysqli('localhost',$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$db->set_charset("utf8");
$stm = $db->prepare("SELECT order_id, email FROM Orders, SalesPersons WHERE Orders.salesperson_id = SalesPersons.salesperson_id AND tender_id='0'");
$stm->execute();
$stm->bind_result($orderID, $email);
while ($stm->fetch()) {

    $sent = sendEmail($email,$emailCC,generateOrder($orderID),"Order");
    echo "Sending Email( $email , Order ID: $orderID ) ->";

    if($sent){

        echo " SENT. <br/> UPDATE Orders SET tender_id='1' WHERE order_id='$orderID' ->";

        $db2 = new mysqli('localhost',$username,$password,$database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }

        $db2->set_charset("utf8");
        $stmt2 = $db2->prepare("UPDATE Orders SET tender_id='1' WHERE order_id='$orderID'");
        $stmt2->execute();
        $stmt2->close();

        echo " DONE<br/><br/>";
        sleep(2);
    }



}
$stm->close();






function sendEmail($email,$emailCC,$emailHtml,$emailSubject)
{
    global $username;
    global $password;
    global $database;

    $db = new mysqli('localhost',$username,$password,$database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $stm = $db->prepare("SELECT email_host, email_from, email_username, email_password, company_name FROM B2B_Configuration LIMIT 1");
    $stm-> execute();
    $stm-> bind_result($emailHost,$emailFrom,$emailUsername,$emailPassword,$companyName);
    while ($stm->fetch()) {}
    $stm-> close();

    $mail = new PHPMailer(true);                              // Passing `true` enables exceptions

    try {

        //Server settings
//      $mail->SMTPDebug = 2;                                 // Enable verbose debug output
        $mail->isSMTP();                                      // Set mailer to use SMTP
        $mail->Host = $emailHost;                             // Specify main and backup SMTP servers
        $mail->SMTPAuth = true;                               // Enable SMTP authentication
        $mail->Username = $emailUsername;                     // SMTP username
        $mail->Password = $emailPassword;                     // SMTP password
        $mail->SMTPSecure = 'tls';                            // Enable TLS encryption, `ssl` also accepted
        $mail->Port = 587;                                    // TCP port to connect to

        //Recipients
        $mail->setFrom($emailFrom, $companyName);

        $mail->addAddress($email, $email);

        $ccArray = explode(';',$emailCC);

        foreach ($ccArray as $cc){
            if(strcmp($cc,'') != 0) {
                $mail->addCC($cc);
            }
        }

        //Content
        $mail->CharSet = 'UTF-8';
        $mail->Encoding = "base64";
        $mail->isHTML(true);                                  // Set email format to HTML
        $mail->Subject = $emailSubject;
        $mail->Body = $emailHtml;
        // $mail->AltBody = 'This is the body in plain text for non-HTML mail clients';

        return $mail->send();


    }catch (Exception $ex){
//        echo " - exception ".$ex;

//        $fp = fopen('email_function_error.txt', 'w');
//        fwrite($fp, "\nException: ".$ex);
//        fclose($fp);

        echo "<br/>Exception:".$ex."</br>";

        return false;

    }
}


function generateOrder($orderID)
{

    global $username;
    global $password;
    global $database;

    $db = new mysqli('localhost', $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT order_code,order_date,subtotal,grand_total,vat_amount,customer_id,company_id,order_address_id FROM Orders WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($orderCode, $orderDate, $subtotal, $grandTotal, $vatAmount, $customerID, $companyID, $orderAddressID);

    while ($stm->fetch()) {


    }
    $stm->close();

    $orderDate = date_format(date_create_from_format('Y-m-d', $orderDate), 'd-m-Y');

    $subtotal = number_format($subtotal,2);
    $grandTotal = number_format($grandTotal,2);
    $vatAmount = number_format($vatAmount,2);


    $stm = $db->prepare("SELECT line1,line2,line3,line4,line5,line6,line7 FROM Companies WHERE company_id='$companyID'");
    $stm->execute();
    $stm->bind_result($line1, $line2, $line3, $line4, $line5, $line6, $line7);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT customer_code,customer_company_name FROM Customers WHERE customer_id='$customerID'");
    $stm->execute();
    $stm->bind_result($customerCode, $customerName);

    while ($stm->fetch()) {


    }
    $stm->close();


    $stm = $db->prepare("SELECT address_line_1,address_line_2 FROM CustomerAddress WHERE customer_address_id='$orderAddressID'");
    $stm->execute();
    $stm->bind_result($addressLine1, $addressLine2);

    while ($stm->fetch()) {


    }
    $stm->close();
    $displayDate = $orderDate;
    $itemsOnPage = 15;


    $counter = 0;
    $stm = $db->prepare("SELECT COUNT(*) FROM Order_Item WHERE order_id='$orderID'");
    $stm->execute();
    $stm->bind_result($counter);

    $maxLoop = 0;
    while ($stm->fetch()) {

        $maxLoop = intval($counter / $itemsOnPage);
        if ($counter % $itemsOnPage > 0) {
            $maxLoop++;

        }

    }

    $stm->close();
    $result = "
        <div class='row'>
<div  class='col-sm-8 col-sm-offset-2'>

<style>




        *
        {
            margin:0;
            padding:0;
            font-family:Arial;
            font-size:10pt;
            color:#000;
        }
        body
        {
            width:100%;
            font-family:Arial;
            font-size:10pt;
            margin:0;
            padding:0;
        }

        p
        {
            margin:0;
            padding:0;
        }

        #wrapper
        {
            width:180mm;
            margin:0 15mm;
        }

        .page
        {
            height:297mm;
            width:210mm;

            page-break-after:always;
        }

        table.bordered
        {
            border-left: 1px solid #ddd;
            border-top: 1px solid #ddd;

            border-spacing:0;
            border-collapse: collapse;

        }

        table.bordered td
        {
            border-right: 1px solid #ddd;
            border-bottom: 1px solid #ddd;
            padding: 2mm;
        }

        table.heading
        {
            height:50mm;
        }

        h1.heading
        {
            font-size:14pt;
            color:#000;
            font-weight:normal;
        }

        h2.heading
        {
            font-size:9pt;
            color:#000;
            font-weight:normal;
        }

        hr
        {
            color:#ccc;
            background:#ccc;
        }

        #invoice_bodyr
        {
            height: 149mm;
        }

        #invoice_body , #invoice_total, #tableHeader
        {
            width:100%;
        }
        #invoice_body table , #tableHeader table
        {
            width:100%;
            border-left: 1px solid #ccc;
            border-top: 1px solid #ccc;

            border-spacing:0;
            border-collapse: collapse;
            margin-left: 30px;


        }

        #invoice_total table {
          width:100%;
        }

        #invoice_body table td , #tableHeader table td
        {
            text-align:center;
            font-size:9pt;
  border-right: 1px solid #ccc;
            border-bottom: 1px solid #ccc;
            padding:2mm 0;
        }

        #invoice_body table td.mono  , #invoice_total table td.mono, #tableHeader table td.mono
        {
            font-family:monospace;
            text-align:right;
            padding-right:3mm;
            font-size:10pt;
        }

        #footer
        {
            width:180mm;
            margin:0 15mm;
            padding-bottom:3mm;
        }
        #footer table
        {
            width:100%;
            background:#eee;

        }
        #footer table td
        {
            width:25%;
            text-align:center;
            font-size:9pt;
        }



        .customer {
           font-family: 'Helvetica Neue', Helvetica, Arial, sans-serif;
           font-weight: 400;
        }

    </style>";

    $counter = 0;
    for ($i = 0; $i < $maxLoop; $i++) {
        $result .= " <p style='text-align:center; font-weight:bold; font-size:22px;padding-top:10px;'>Order $orderCode</p><br/>";
        if($i < 1) {
            $result .= "

    <table class='heading' style='width:100%; margin-bottom: 5px;'>
        <tr>
            <td style='width:100mm;'>
                <h1 class='heading' style='padding-top:2px;padding-bottom:2px;'>$line1</h1>
                <h2 class='heading'>
                    $line2<br/>
                    $line3<br/>
                    $line4<br/>
                    $line5<br/>
                    $line6<br/>
                    $line7
                </h2>
            </td>
            <td rowspan='2' valign='top' align='right' style='padding:3mm;'>
                <table>
                    <tr><td style='font-weight:bold'>Order: </td><td> $orderCode</td></tr>
                    <tr><td style='font-weight:bold'>Date: </td><td> $displayDate</td></tr>
                    <tr><td style='font-weight:bold'>Type: </td><td>Order</td></tr>
                </table>
            </td>
        </tr>
        <tr>
            <td><br /><br />
                <b>Customer</b> :<br />
                <h2>$customerCode -  $customerName</h2><br />
            </td>
        </tr>
    </table>
    <br />";
        } else {
            $itemsOnPage = 20;
        }
$result .= "
    <div id='item_table' style='height:100%;'>

   <div style='height:500px;'>

     <table id='tableHeader' style='border-top: 1px solid #a7c6f9;border-bottom: 1px solid #a7c6f9;padding:0;background:#cadbf7;'>
            <tr>
                <td style='width:5%' ><b>No.</b></td>
                <td style='width:15%'><b>Code</b></td>
                <td style='width:45%'><b>Description</b></td>
                <td style='width:17%;text-align:center;'><b>Qty</b></td>
                <td style='width:17%;text-align:center;'><b>Notes</b></td>
                
            </tr>
            </table>


            <table style='overflow:hidden;width:100%' >

            ";

        if($i<=1) {
            $pageStart = ($i) * $itemsOnPage;
        }else{
            $pageStart = ($i-1) * $itemsOnPage +15;
        }
        $stm = $db->prepare("SELECT Order_Item.item_id,qty,unit_price,Items.vat_id,item_code,name,sales_units FROM Order_Item,Items WHERE Order_Item.item_id=Items.item_id AND Order_Item.order_id='$orderID' ORDER BY Order_Item.order_item_id  LIMIT $pageStart,$itemsOnPage");
        $stm->execute();
        $stm->bind_result($itemID, $qty, $unitPrice, $vatID, $itemCode, $name, $uom);

        $unitPrice = number_format($unitPrice,2);

        while ($stm->fetch()) {
            $counter++;
            $lineTotal = $unitPrice * $qty;

            $lineTotal = number_format($lineTotal,2);

            $result .= "<tr style='margin-top:4px;'>
                <td style='width:5%;height: 38px;font-size:12px'><b>$counter</b></td >
                <td style='width:15%;font-size:12px' > $itemCode  </td >
                <td style='width:45%;font-size:12px'> $name - $uom</td >
                <td style='width:17%;text-align:center;font-size:12px' > $qty</td >
                <td style='width:17%;text-align:center;font-size:12px; border: 1px solid lightslategray;'></td >      
            </tr ><tr style='margin-top:4px;'><td colspan='5' style='background-color: lightslategray;height: 2px;'></td></tr>";

        }
        $stm->close();
        $page = $i + 1;

        if ($i + 1 == $maxLoop) {


            $result .=
                "

</table>

<htmlpagefooter name='myFooter1' class='footer'>

        <div style='margin-top:30px;width:100%;'>
           <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''></span></td>
                <td width='33%' align='center' style=''>Page $page of $maxLoop</td>
                <td width='33%' style='text-align: right; '></td>
                </tr><tr><td width='33%'><span style=''></span></td>
                </tr></table>

        </div>
<br/>
            
 </htmlpagefooter>

<pagebreak/>

";
        } else {
            $result .=
                "


        </table>
          <htmlpagefooter name='myFooter1' class='footer'>

        <div style='margin-top:30px;width:100%;'>
           <table width='100%' style='vertical-align: bottom; font-family: Helvetica Neue, Helvetica, Arial, sans-serif; font-size: 8pt;
                color: #000000;  '><tr>
                <td width='33%'><span style=''></span></td>
                <td width='33%' align='center' style=''>Page $page of $maxLoop</td>
                <td width='33%' style='text-align: right; '></td>
                </tr><tr><td width='33%'><span style=''></span></td>
                </tr></table>

        </div>

    <br/>        
 </htmlpagefooter>
        <pagebreak/><br/>
        ";


        }
    }
    return $result;
}


?>