<?php
include_once("../../../../param.php");

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$barcodeSchemaID = $_POST['barcodeSchemaID'];
$barcodeSchemaCode = trim($_POST['barcodeSchemaCode']);
$barcodeSchemaText = trim($_POST['barcodeSchemaText']);
$prefix = trim($_POST['prefix']);
$codeStart = trim($_POST['codeStart']);
$codeEnd = trim($_POST['codeEnd']);
$qtyStart = trim($_POST['qtyStart']);
$qtyEnd = trim($_POST['qtyEnd']);
$priceStart = trim($_POST['priceStart']);
$priceEnd = trim($_POST['priceEnd']);
$qtyFactor = trim($_POST['qtyFactor']);
$priceFactor = trim($_POST['priceFactor']);

if(empty($barcodeSchemaCode)) {
    echo "emptyFields";
    return;
}
$stm = $db->prepare("SELECT barcode_schema_id FROM Barcode_Schema WHERE NOT barcode_schema_id=? AND barcode_schema_code=? LIMIT 1");
$stm->bind_param("is", $barcodeSchemaID, $barcodeSchemaCode);
$stm->execute();
$stm->bind_result($existingCodeID);
$stm->fetch();
$stm->close();

$existingCodeID = intval($existingCodeID);

if($existingCodeID > 0) {
    echo "existingCode";
    return;
}

$stm = $db->prepare("UPDATE Barcode_Schema SET barcode_schema_code=?, barcode_schema_text=?, prefix=?, code_start=?, code_end=?, qty_start=?, qty_end=?, price_start=?, price_end=?, qty_factor=?, price_factor=? WHERE barcode_schema_id=?");
$stm->bind_param("ssiiiiiiiddi", $barcodeSchemaCode, $barcodeSchemaText, $prefix, $codeStart, $codeEnd, $qtyStart, $qtyEnd, $priceStart, $priceEnd, $qtyFactor, $priceFactor, $barcodeSchemaID);

if ($stm->execute()) {
    echo "success";
} else {
    echo "error";
}

$stm->close();
$db->close();
?>