<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$invoiceID = trim(''.$_POST['invoiceID']);
$invoiceCode=trim(''.$_POST['invoiceCode']);
$companyID = $_SESSION['companyID'];
$customerID= trim(''.$_POST['customerID']);
$deliveryAddress= trim(''.$_POST['deliveryAddress']);
$billingAddress= trim(''.$_POST['billingAddress']);
$invoiceType= trim(''.$_POST['invoiceType']);
$invoiceDate= trim(''.$_POST['invoiceDate']);
$orderID = trim(''.$_POST['orderID']);
$currencyID = trim(''.$_POST['currencyID']);
$warehouseSearch= trim(''.$_POST['warehouseSearch']);
$subtotal= trim(''.$_POST['subtotal']);
$discount= trim(''.$_POST['discount']);
$vatTotal= trim(''.$_POST['vatTotal']);
$grandTotal= trim(''.$_POST['grandTotal']);
$details= trim(''.$_POST['details']);
$isDraft= trim(''.$_POST['isDraft']);
$paymentMethod= trim(''.$_POST['paymentMethod']);
$salespersonSearch= trim(''.$_POST['salespersonSearch']);
$dueDate = trim(''.$_POST['dueDate']);

$invoiceItems = array();
$invoiceItems        = json_decode($_POST['invoiceItems'], true);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    if (isset($invoiceDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $invoiceDate);
        $invoiceDate = $date->format('Y-m-d');
    }

    if (isset($dueDate) and strcmp($dueDate, "") != 0) {
        $date = DateTime::createFromFormat('d/m/Y', $dueDate);
        $dueDate = $date->format('Y-m-d');
    }

    if (strpos($discount, '%') !== false) {
        $globalDiscountPercentage = str_replace("%", "", $discount);
        $discount = $subtotal * $globalDiscountPercentage / 100;
    } else {
        $globalDiscountPercentage = 0;
    }

    if (strcmp($invoiceType, 'Cash') == 0) {
        $status = "Paid";
    } else {
        $status = "Not Paid";
    }

    $prevTypesArray = array();
    $stmt = $db->prepare("SELECT invoice_type,grand_total,customer_id  FROM Invoices WHERE invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($previousType, $previousTotal, $previousCustomerID);
    while ($stmt->fetch()) {
        $prevTypeObject = new stdClass();
        $prevTypeObject->previousType = $previousType;
        $prevTypeObject->previousTotal = $previousTotal;
        $prevTypeObject->previousCustomerID = $previousCustomerID;
        array_push($prevTypesArray, $prevTypeObject);
    }
    $stmt->close();

    foreach ($prevTypesArray as $previousTypeObject) {
        $previousType = $prevTypeObject->previousType;
        $previousTotal = $prevTypeObject->previousTotal;
        $previousCustomerID = $prevTypeObject->previousCustomerID;
        if (strcmp($previousType, "Credit") == 0) {
            updateCustomerBalance($previousCustomerID, -$previousTotal, $db);
        }
    }

    lockDocumentSingleTransaction($invoiceID, "Invoices", $db);

    $stmt = $db->prepare("SELECT status FROM Invoices WHERE invoice_id='$invoiceID'");
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($prevStatus);
    while ($stmt->fetch()) {if(strcmp($prevStatus,'')!=0){$status=$prevStatus;}}
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Invoices WHERE invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);

    $statement = "DELETE FROM Invoices WHERE invoice_id=$invoiceID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("INSERT INTO Invoices (invoice_id,invoice_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,invoice_address_id,delivery_address_id,invoice_date,due_date,details,invoice_type,global_discount_percentage,status,order_id,currency_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiissssdsii', $invoiceID, $invoiceCode, $companyID, $customerID, $salespersonSearch, $paymentMethod, $subtotal, $grandTotal, $vatTotal, $discount, $billingAddress, $deliveryAddress, $invoiceDate, $dueDate, $details, $invoiceType, $globalDiscountPercentage, $status, $orderID, $currencyID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $detailsTra = "Invoice $invoiceCode";

    $stmt = $db->prepare("DELETE FROM Transactions WHERE transaction_code=?");
    $stmt->bind_param('s', $invoiceCode);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);

    $statement = "DELETE FROM Transactions WHERE transaction_code=\"$invoiceCode\"";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    if (strcmp($invoiceType, "Credit") == 0) {
        $sign = 1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $invoiceCode, $customerID, $invoiceDate, $invoiceDate, $invoiceCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->close();
        updateCustomerBalance($customerID, $grandTotal, $db);
    } else {
        $sign = 1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $invoiceCode, $customerID, $invoiceDate, $invoiceDate, $invoiceCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->close();
        $sign = -1;
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $invoiceCode, $customerID, $invoiceDate, $invoiceDate, $invoiceCode, $sign, $grandTotal, $detailsTra);
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->close();
    }


    $invoiceItemsForSockArray = getStockUpdateLinesOfDocument($db, 5, $invoiceID);

    foreach ($invoiceItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Edit Invoice (Remove)', 0, null, null, 0, null);
        if(!$insertStockUpdateStatementResult){throw new Exception();}

        $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');
        if(!$insertStockStatementResult){throw new Exception();}

    }

    $invoiceOrderItemsForSockArray = getStockUpdateLinesOfConnectedDocument($db, 5, $invoiceID,2);

    foreach ($invoiceOrderItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, 0, 0, 0, 0, 0, 0, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Invoice Order (Remove)', 2, $itemObject->fromActionID,  $itemObject->fromActionCode,  -$itemObject->fromActionQty,  $itemObject->fromActionField);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $linkedForReservedItems = array();
        $stmt = $db->prepare("SELECT order_item_id,qty_invoiced FROM Order_Item WHERE order_id=? AND item_id=?");
        $stmt->bind_param('ii',  $itemObject->fromActionID,$itemObject->itemID);
        $stmt->execute();
        $stmt->bind_result($linkedOrderItemID,$linkedForReserved);
        while ($stmt->fetch()) {

            if($linkedForReserved <= $itemObject->fromActionQty){
                $reverseFromActionQty = $linkedForReserved;
                $itemObject->fromActionQty -= $reverseFromActionQty;
            } else {
                $reverseFromActionQty = $itemObject->fromActionQty;
                $itemObject->fromActionQty = 0;
            }

            $lineReservation = new stdClass();
            $lineReservation->lineID = $linkedOrderItemID;
            $lineReservation->reserved = $reverseFromActionQty;

            array_push($linkedForReservedItems,$lineReservation);

        }
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        foreach ($linkedForReservedItems as $lineReservation){

            $reverseFromActionQty=-$lineReservation->reserved;

            $stmt = $db->prepare("UPDATE Order_Item SET ".$itemObject->fromActionField." = ".$itemObject->fromActionField."+? WHERE order_item_id = ?");
            $stmt->bind_param('di', $reverseFromActionQty, $lineReservation->lineID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        }

    }

    $invoiceWaybillItemsForSockArray = getStockUpdateLinesOfConnectedDocument($db, 5, $invoiceID,3);

    foreach ($invoiceWaybillItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, 0, 0, 0, 0, 0, 0, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Invoice Waybill (Remove)', 3, $itemObject->fromActionID,  $itemObject->fromActionCode,  -$itemObject->fromActionQty,  $itemObject->fromActionField);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $linkedForReservedItems = array();
        $stmt = $db->prepare("SELECT waybill_item_id,qty_invoiced FROM Waybill_Item WHERE waybill_id=? AND item_id=?");
        $stmt->bind_param('ii',  $itemObject->fromActionID,$itemObject->itemID);
        $stmt->execute();
        $stmt->bind_result($linkedWaybillItemID,$linkedForReserved);
        while ($stmt->fetch()) {

            if($linkedForReserved <= $itemObject->fromActionQty){
                $reverseFromActionQty = $linkedForReserved;
                $itemObject->fromActionQty -= $reverseFromActionQty;
            } else {
                $reverseFromActionQty = $itemObject->fromActionQty;
                $itemObject->fromActionQty = 0;
            }

            $lineReservation = new stdClass();
            $lineReservation->lineID = $linkedWaybillItemID;
            $lineReservation->reserved = $reverseFromActionQty;

            array_push($linkedForReservedItems,$lineReservation);

        }
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        foreach ($linkedForReservedItems as $lineReservation){

            $reverseFromActionQty=-$lineReservation->reserved;

            $stmt = $db->prepare("UPDATE Waybill_Item SET ".$itemObject->fromActionField." = ".$itemObject->fromActionField."+? WHERE waybill_item_id = ?");
            $stmt->bind_param('di', $reverseFromActionQty, $lineReservation->lineID);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        }

    }

    $stmt = $db->prepare("DELETE FROM Invoice_Item WHERE invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID  = getNextKeySingleTransaction("Deletes", "delete_id", $db);
    $statement = "DELETE FROM Invoice_Item WHERE invoice_id=$invoiceID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $lineTotals = 0;
    $lineDiscountTotals = 0;
    $itemsCounter = 0;

    if (count($invoiceItems) == 0) {throw new Exception();}

    foreach ($invoiceItems as $invoiceItem) {

        $itemID = $invoiceItem['itemID'];

        if ($itemID > 0) {
            $itemsCounter++;

            $itemNotes      = $invoiceItem['Notes'];
            $qty            = $invoiceItem['Qty'];
            $unitPrice      = $invoiceItem['UP'];
            $lineDiscount   = $invoiceItem['LD'];
            $priceType      = $invoiceItem['PC'];
            $globalDiscount = $invoiceItem['globalDiscount'];
            $vatTotal       = $invoiceItem['vatLine'];
            $vatCode        = $invoiceItem['VAT'];

            $vatID    = getVatID($vatCode, $db);
            $subunits = getSubUnits($itemID, $db);

            if (strpos($lineDiscount, '%') !== false) {
                $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
            } else {
                $lineDiscountSelectedPercentage = 0;
            }

            $lineTotals += $unitPrice * $qty / $subunits;
            $lineDiscountTotals += $lineDiscount;
            $batchNumber = '0';

            $invoiceItemID = getNextKeySingleTransaction("Invoice_Item", "invoice_item_id", $db);

            $stmt = $db->prepare("INSERT INTO Invoice_Item (invoice_item_id,invoice_id,item_id,warehouse_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description,batch_number) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiidddddiidss', $invoiceItemID, $invoiceID, $itemID, $warehouseSearch, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes,$batchNumber);
            $stmt->execute();
            if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
            $stmt->close();

            $custTable = new CustomTable('Invoice_Item', $invoiceItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($invoiceItem, $code->tableCode, $db);
            }

        }

    }

    $stockInvoicedItems = array();
    $stmt = $db->prepare("SELECT item_id,batch_number,warehouse_id,SUM(qty) FROM Invoice_Item WHERE invoice_id=? GROUP BY item_id,batch_number,warehouse_id");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($itemID,$batchNumber,$warehouseID,$qty);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = $warehouseID;
        $object->itemID = $itemID;
        $object->batchNumber = $batchNumber;
        $object->available = $qty;
        $object->reserved = $qty;
        $object->delivered = $qty;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = 0;
        $object->fromActionQty = 0;
        $object->fromActionID = 0;
        $object->fromActionCode = '';
        $object->fromActionField = '';

        array_push($stockInvoicedItems,$object);
    }
    $stmt->close();

    $orderedItemObjects = array();
    $stmt = $db->prepare("SELECT order_item_id,Order_Item.order_id,order_code,delivery_method,item_id,qty,qty_delivered,qty_invoiced FROM Order_Invoice,Orders,Order_Item WHERE Order_Invoice.order_id=Order_Item.order_id AND Orders.order_id=Order_Invoice.order_id AND Order_Invoice.invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($orderItemID,$orderID,$orderCode,$warehouseID,$itemID,$qty,$qtyDelivered,$qtyInvoiced);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = $warehouseID;
        $object->itemID = $itemID;
        $object->batchNumber = "0";
        $object->available = $qty - $qtyDelivered - $qtyInvoiced;
        $object->reserved = 0;
        $object->delivered = $qtyDelivered;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = $qtyInvoiced;
        $object->fromActionQty = 0;
        $object->fromActionID = $orderID;
        $object->fromActionCode = $orderCode;
        $object->fromActionField = 'qty_invoiced';
        $object->fromActionLineID = $orderItemID;


        array_push($orderedItemObjects,$object);
    }
    $stmt->close();

    $waybillItemObjects = array();
    $stmt = $db->prepare("SELECT Waybill_Item.waybill_id,waybill_code,waybill_item_id,warehouse_id,item_id,qty,qty_invoiced FROM Waybill_Invoice,Waybills,Waybill_Item WHERE Waybill_Invoice.waybill_id=Waybill_Item.waybill_id AND Waybills.waybill_id=Waybill_Invoice.waybill_id AND Waybill_Invoice.invoice_id=?");
    $stmt->bind_param('i', $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($waybillID,$waybillCode,$waybillItemID,$warehouseID,$itemID,$qty,$qtyInvoiced);
    while ($stmt->fetch()) {
        $object = new stdClass();
        $object->warehouseID = $warehouseID;
        $object->itemID = $itemID;
        $object->batchNumber = "0";
        $object->available = $qty - $qtyInvoiced;
        $object->reserved = 0;
        $object->delivered = 0;
        $object->onOrder = 0;
        $object->requested = 0;
        $object->sold = $qtyInvoiced;
        $object->fromActionQty = 0;
        $object->fromActionID = $waybillID;
        $object->fromActionCode = $waybillCode;
        $object->fromActionField = 'qty_invoiced';
        $object->fromActionLineID = $waybillItemID;


        array_push($waybillItemObjects,$object);
    }
    $stmt->close();


    foreach ($orderedItemObjects as $orderedItemObject) {

        foreach ($stockInvoicedItems as $stockInvoicedItem){

            if(strcmp($orderedItemObject->itemID,$stockInvoicedItem->itemID)==0
                && strcmp($orderedItemObject->warehouseID,$stockInvoicedItem->warehouseID)==0
                && strcmp($orderedItemObject->batchNumber,$stockInvoicedItem->batchNumber)==0)
            {

                if($orderedItemObject->available <= $stockInvoicedItem->reserved){
                    $reserved  = $orderedItemObject->available;
                    $objectReserved  = $stockInvoicedItem->reserved - $orderedItemObject->available;
                } else {
                    $reserved  = $stockInvoicedItem->reserved;
                    $objectReserved  = 0;
                }

                $stockInvoicedItem->reserved = $objectReserved;
                $delivered = $reserved;
                $fromActionQty = $reserved;
                $reserved  = -$reserved;

                $stmt = $db->prepare("UPDATE Order_Item SET qty_invoiced=qty_invoiced+? WHERE order_item_id=?");
                $stmt->bind_param('di', $delivered, $orderedItemObject->fromActionLineID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();




                $insertStockStatementResult = insertStockRecord($db, $orderedItemObject->warehouseID, $orderedItemObject->itemID, $orderedItemObject->batchNumber, 0, $reserved, 0, 0, 0, 0, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $orderedItemObject->warehouseID, $orderedItemObject->itemID, $orderedItemObject->batchNumber, 0, $reserved, 0, 0, 0, 0, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Edit Invoice (Add)', 2, $orderedItemObject->fromActionID, $orderedItemObject->fromActionCode, "$fromActionQty", 'qty_invoiced');
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            }

        }

    }


    foreach ($waybillItemObjects as $waybillItemObject) {

        foreach ($stockInvoicedItems as $stockInvoicedItem){

            if(strcmp($waybillItemObject->itemID,$stockInvoicedItem->itemID)==0
            && strcmp($waybillItemObject->warehouseID,$stockInvoicedItem->warehouseID)==0
            && strcmp($waybillItemObject->batchNumber,$stockInvoicedItem->batchNumber)==0)
            {

                if($waybillItemObject->available <= $stockInvoicedItem->available){
                    $available  = $stockInvoicedItem->available - $waybillItemObject->available;
                    $invoiced = $waybillItemObject->available;
                } else {
                    $available  = 0;
                    $invoiced = $stockInvoicedItem->available;
                }

                $stockInvoicedItem->available = $available;
                $delivered = -$invoiced;
                $fromActionQty = $invoiced;

                $stmt = $db->prepare("UPDATE Waybill_Item SET qty_invoiced=qty_invoiced+? WHERE waybill_item_id=?");
                $stmt->bind_param('di', $invoiced, $waybillItemObject->fromActionLineID);
                $stmt->execute();
                if(strcmp("$stmt->error","")!=0) {throw new Exception($stmt->error);}
                $stmt->close();


                $insertStockStatementResult = insertStockRecord($db, $waybillItemObject->warehouseID, $stockInvoicedItem->itemID, $waybillItemObject->batchNumber, 0, 0, $delivered, 0, 0, $invoiced, '0000-00-00');
                if(!$insertStockStatementResult){throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $waybillItemObject->warehouseID, $stockInvoicedItem->itemID, $waybillItemObject->batchNumber, 0, 0, $delivered, 0, 0, $invoiced, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Edit Invoice', 3, $waybillItemObject->fromActionID, $waybillItemObject->fromActionCode, "$fromActionQty", 'qty_invoiced');
                if(!$insertStockUpdateStatementResult){throw new Exception();}

            }

        }

    }


    foreach ($stockInvoicedItems as $stockInvoicedItem) {

        if($stockInvoicedItem->available > 0){

            $batchNumber = $stockInvoicedItem->batchNumber;
            $available = -$stockInvoicedItem->available;
            $sold      = $stockInvoicedItem->available;

            $insertStockStatementResult = insertStockRecord($db, $stockInvoicedItem->warehouseID, $stockInvoicedItem->itemID, $stockInvoicedItem->batchNumber, $available, 0, 0, 0, 0, $sold, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $stockInvoicedItem->warehouseID, $stockInvoicedItem->itemID, $stockInvoicedItem->batchNumber, $available, 0, 0, 0, 0, $sold, "0000-00-00", 5, $invoiceID, $invoiceCode, 'Edit Invoice', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}

        }

    }
    $discount = floatval($discount);
    $discount += floatval($lineDiscountTotals);

    $stmt = $db->prepare("UPDATE  Invoices SET subtotal =? ,discount_amount=? WHERE invoice_id=?");
    $stmt->bind_param('ddi', $lineTotals, $discount, $invoiceID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $custTable = new CustomTable('Invoices', $invoiceID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    $db->commit(true);

    echo "$invoiceID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}


$custForm = new CustomForm('Invoices',$invoiceID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}




						
 
				
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance + ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>