<?php
include_once("../../../../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$promotionID = intval($_POST['promotionID']);
$promotionCode = trim($_POST['promotionCode']);
$promotionName = trim($_POST['promotionName']);
$promotionDescription = trim($_POST['promotionDescription']);
$promoType = intval($_POST['promoType']);
$primaryItemID = intval($_POST['primaryItemID'] );
$primaryItemPriceType = intval($_POST['primaryItemPriceType']);
$promoStartDate = trim($_POST['promoStartDate']);
$promoEndDate = trim($_POST['promoEndDate']);
$quantity = intval($_POST['quantity']);
$fixedDiscAmount = floatval($_POST['fixedDiscAmount']);
$fixedDiscPercent = floatval($_POST['fixedDiscPercent']);
$price = floatval($_POST['price']);
$discountQty = floatval($_POST['discountQty']);
$discountPercentQty = floatval($_POST['discountPercentQty']);
$status = $_POST['promoStatus'];

$customers =$_POST['customers'];
$salesPersons =$_POST['salesPersons'];
$customerGroups =$_POST['customerGroups'];

$extraItems = isset($_POST['extraItems']) ? $_POST['extraItems'] : [];
$matchingRules = isset($_POST['matchingRules']) ? $_POST['matchingRules'] : [];

$all_customers = '';
$all_salespersons = '';
if (strpos($customers, 'all_customers') !== false) {
    $all_customers = 'yes';
    $customers ='';
}

if (strpos($salesPersons, 'all_salespersons') !== false) {
    $all_salespersons = 'yes';
    $salesPersons ='';
}



global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);

if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}

$db->set_charset("utf8");

// Check if promotion code already exists with a different ID
$stm = $db->prepare("SELECT promotion_id FROM Promotions WHERE NOT promotion_id = ? AND promotion_code LIKE ? LIMIT 1");
$stm->bind_param("is", $promotionID, $promotionCode);
$stm->execute();
$stm->bind_result($existingCodeID);
$stm->fetch();
$stm->close();

$existingCodeID = intval($existingCodeID);

if ($existingCodeID > 0) {
    echo "existingCode";
} else {
    $stmt = $db->prepare("UPDATE Promotions SET promotion_code=?, promotion_name=?, description=?, type=?, item_id=?, qty=?, fixed_discount_amount=?, fixed_discount_percent=?, pricetype_id=?, price=?, discount_qty=?, discount_percent_on_qty=?,  valid_from=?, valid_until=?, status=?, all_customers=?, all_salespersons=?  WHERE promotion_id=?");
    $stmt->bind_param('sssiiiddidddsssssi', $promotionCode, $promotionName, $promotionDescription, $promoType, $primaryItemID, $quantity, $fixedDiscAmount, $fixedDiscPercent, $primaryItemPriceType, $price, $discountQty, $discountPercentQty, $promoStartDate, $promoEndDate, $status,$all_customers,$all_salespersons,$promotionID);
    $stmt->execute();
    $stmt->close();

    if (in_array($promoType, [1, 7]) && !empty($extraItems)) {
        $stmt = $db->prepare("DELETE FROM Promotion_Extra_Item WHERE promotion_id = ?");
        $stmt->bind_param("i", $promotionID);
        $stmt->execute();
        $stmt->close();

        foreach ($extraItems as $extraItem) {
            $stmt = $db->prepare("INSERT INTO Promotion_Extra_Item (promotion_id, item_id, pricetype_id, timestamp) VALUES (?, ?, ?, NOW())");
            $itemID = intval($extraItem['itemID']);
            $pricetypeID = intval($extraItem['priceTypeID']);
            $stmt->bind_param('iii', $promotionID, $itemID, $pricetypeID);
            $stmt->execute();
            $stmt->close();
        }
    }

    if (in_array($promoType, [3, 7]) && !empty($matchingRules)) {
        $stmt = $db->prepare("DELETE FROM Promotion_Matching_Rule WHERE promotion_id = ?");
        $stmt->bind_param("i", $promotionID);
        $stmt->execute();
        $stmt->close();

        foreach ($matchingRules as $matchingRule) {
            $categoryID = intval($matchingRule['categoryID']);
            $itemID = intval($matchingRule['itemID']);
            $creditLimit = floatval($matchingRule['creditLimit']);
            $matchingRuleValue = floatval($matchingRule['matchingRuleValue']);

            $stmt = $db->prepare("INSERT INTO Promotion_Matching_Rule (promotion_id, category_id, item_id, credit_limit, value, timestamp) VALUES (?, ?, ?, ?, ?, NOW())");
            $stmt->bind_param('iiidi', $promotionID, $categoryID, $itemID, $creditLimit, $matchingRuleValue);
            $stmt->execute();
            $stmt->close();
        }
    }

    if($all_customers!='yes' && !empty($customers)) {
        $customersArray = explode(",", $customers);
        $stmt = $db->prepare("DELETE FROM Promotion_Customer WHERE promotion_id = ?");
        $stmt->bind_param("i", $promotionID);
        $stmt->execute();
        $stmt->close();

        foreach ($customersArray as $customerID) {
            $stmt = $db->prepare("INSERT  INTO Promotion_Customer (customer_id, promotion_id) VALUES (?, ?)");
            $stmt->bind_param('ii', $customerID, $promotionID);
            $stmt->execute();
            $stmt->close();
        }
    }

    if(!empty($customerGroups)) {
        $customersGroupsArray = explode(",", $customerGroups);
        $stmt = $db->prepare("DELETE FROM Promotion_Customer_Group WHERE promotion_id = ?");
        $stmt->bind_param("i", $promotionID);
        $stmt->execute();
        $stmt->close();

        foreach ($customersGroupsArray as $groupID) {
            $stmt = $db->prepare("INSERT  INTO Promotion_Customer_Group (group_id, promotion_id) VALUES (?, ?)");
            $stmt->bind_param('ii', $groupID, $promotionID);
            $stmt->execute();
            $stmt->close();
        }
    }

    if($all_salespersons!='yes' && !empty($salesPersons)) {
        $salesPersonsArray = explode(",", $salesPersons);
        $stmt = $db->prepare("DELETE FROM Promotion_Salesperson WHERE promotion_id = ?");
        $stmt->bind_param("i", $promotionID);
        $stmt->execute();
        $stmt->close();

        foreach ($salesPersonsArray as $salesPersonID) {
            $stmt = $db->prepare("INSERT  INTO Promotion_Salesperson ( salesperson_id, promotion_id,timestamp) VALUES (?, ?,NOW())");
            $stmt->bind_param('ii', $salesPersonID, $promotionID);
            $stmt->execute();
            $stmt->close();
        }
    }

    echo $promotionID;

}
?>
