<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$orderID = trim(''.$_POST['orderID']);
$orderCode=trim(''.$_POST['orderCode']);
$companyID = $_SESSION['companyID'];
$customerID= trim(''.$_POST['customerID']);
$deliveryAddress= trim(''.$_POST['deliveryAddress']);
$billingAddress= trim(''.$_POST['billingAddress']);
$orderDate= trim(''.$_POST['orderDate']);
$paymentMethod= trim(''.$_POST['paymentMethod']);
$salespersonSearch= trim(''.$_POST['salespersonSearch']);
$warehouseSearch= trim(''.$_POST['warehouseSearch']);
$subtotal= trim(''.$_POST['subtotal']);
$discount= trim(''.$_POST['discount']);
$vatTotal= trim(''.$_POST['vatTotal']);
$grandTotal= trim(''.$_POST['grandTotal']);
$details= trim(''.$_POST['details']);

$orderItems = array();
$orderItems =$_POST['orderItems'];

$status = "Placed";

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    ini_set('display_errors', 1);
    ini_set('display_startup_errors', 1);
    error_reporting(E_ERROR);

    if(isset($orderDate)) {
        $orderDate = date_format( date_create_from_format('d/m/Y', $orderDate), 'Y-m-d');
    }

    $dueDate = trim($_POST['dueDate']);

    if(isset($dueDate) AND strcmp($dueDate,"")!=0) {
        $dueDate = date_format( date_create_from_format('d/m/Y', $dueDate), 'Y-m-d');
    }

    if(strpos($discount, '%') !== false) {
        $globalDiscountPercentage=str_replace("%","",$discount);
        $discount=$subtotal*$globalDiscountPercentage/100;
    } else {
        $globalDiscountPercentage=0;
    }

    lockDocumentSingleTransaction($orderID,"Purchase_Orders",$db);

    $stmt = $db->prepare("DELETE FROM Purchase_Orders WHERE order_id=?");
    $stmt->bind_param('i',$orderID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $statement ="DELETE FROM Purchase_Orders WHERE order_id=$orderID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is',$deleteID,$statement);
    $stmt->execute();
    $stmt->close();

    $stmt = $db->prepare("INSERT INTO Purchase_Orders (order_id,order_code,company_id,customer_id,salesperson_id,paymenttype_id,subtotal,grand_total,vat_amount,discount_amount,order_address_id,delivery_address_id,order_date,delivery_date,details,global_discount_percentage,status, delivery_method) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiddddiisssdss',$orderID,$orderCode,$companyID,$customerID,$salespersonSearch,$paymentMethod,$subtotal,$grandTotal,$vatTotal,$discount,$billingAddress,$deliveryAddress,$orderDate,$dueDate,$details,$globalDiscountPercentage,$status,$warehouseSearch);
    $stmt->execute();
    $stmt->close();

    $lineTotals =0;
    $lineDiscountTotals =0;



    $orderItemsForSockArray = getStockUpdateLinesOfDocument($db, 9, $orderID);

    foreach ($orderItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 9, $orderID, $orderCode, 'Edit P.Order (Remove)', 0, null, null, 0, null);
        if(!$insertStockUpdateStatementResult){throw new Exception();}


        $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');
        if(!$insertStockStatementResult){throw new Exception();}

    }


    $stmt = $db->prepare("DELETE FROM Purchase_Order_Item WHERE order_id=?");
    $stmt->bind_param('i',$orderID);
    $stmt->execute();
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
    $statement ="DELETE FROM Purchase_Order_Item WHERE order_id=$orderID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is',$deleteID,$statement);
    $stmt->execute();
    $stmt->close();

    foreach($orderItems as $orderItem)
    {

        $itemID = $orderItem['itemID'];
        if($itemID > 0) {
            $itemNotes = $orderItem['Notes'];
            $qty = floatval($orderItem['Qty']);
            $unitPrice = floatval($orderItem['UP']);
            $lineDiscount = $orderItem['LD'];
            $priceType = $orderItem['PC'];
            $globalDiscount = $orderItem['globalDiscount'];
            $vatTotal = $orderItem['vatLine'];
            $vatCode = $orderItem['VAT'];

            $vatID = getVatID($vatCode,$db);
            $subunits=getSubUnits($itemID,$db);

            if(floatval($subunits)==0) {
                $subunits=1;
            }

            if(strpos("$lineDiscount", '%') !== false) {
                $lineDiscountSelectedPercentage=str_replace("%","",$lineDiscount);
                $lineDiscount = ($qty/$subunits)*$unitPrice *($lineDiscountSelectedPercentage/100);
            } else {
                $lineDiscountSelectedPercentage=0;
            }
            echo "$unitPrice*$qty/$subunits\n";
            $lineTotals += $unitPrice*$qty/$subunits;
            $lineDiscountTotals +=$lineDiscount;

            $orderItemID = getNextKeySingleTransaction("Purchase_Order_Item", "order_item_id",$db);

            $batchNumber='0';

            $stmt = $db->prepare("INSERT INTO Purchase_Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID,$lineDiscountSelectedPercentage,$itemNotes);
            $stmt->execute();
            $stmt->close();

            $onorder=$qty;
            $insertStockStatementResult = insertStockRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, 0, 0, $onorder, 0, 0, '0000-00-00');
            if(!$insertStockStatementResult){throw new Exception();}

            $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseSearch, $itemID, $batchNumber, 0, 0, 0, $onorder, 0, 0, "0000-00-00", 9, $orderID, $orderCode, 'Edit P.Order (Add)', 0, null, null, 0, null);
            if(!$insertStockUpdateStatementResult){throw new Exception();}

            $custTable = new CustomTable('Purchase_Order_Item',$orderItemID);
            $codes = array();
            $codes = $custTable->getCustomTableCodes($db);
            foreach ($codes as $code) {
                $custTable->insertVariablesToCustomTableLine($orderItem, $code->tableCode,$db);
            }
        }

    }

    $discount+=$lineDiscountTotals;

    $stmt = $db->prepare("UPDATE  Purchase_Orders SET subtotal =? ,discount_amount=? WHERE order_id=?");
    $stmt->bind_param('ddi',$lineTotals,$discount,$orderID);
    $stmt->execute();
    $stmt->close();


    $custTable = new CustomTable('Purchase_Orders',$orderID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode,$db);
    }

    $db->commit(true);


    echo"$orderID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Purchase_Orders',$orderID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}
	
	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode,$db){

 $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
 $stm1-> execute();
 $stm1-> bind_result($counter);
 while ($stm1->fetch()) {
  $z=$counter;
 }
 $stm1->close();


 return $z;



}

function getSubUnits($itemID,$db) {
 $subunits = 1;
 $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
 $stm1-> execute();
 $stm1-> bind_result($sub);
 while ($stm1->fetch()) {
  return $sub;
 }
 $stm1->close();
 return $subunits;


}

function updateCustomerBalance($customerID,$amount,$db)
{

 $stmt = $db->prepare("UPDATE  Suppliers SET balance = balance + ? WHERE customer_id=?");
 $stmt->bind_param('di',$amount,$customerID);
 $stmt->execute();
 $stmt->close();

}
?>