<?php
include_once("../../../../param.php");
require_once(ROOT . "concc/dbhelpers/dbhelper.php");
require_once(ROOT . "backend/core/model/CustomForm.php");
require_once(ROOT . "backend/core/model/CustomTable.php");

$companyID = $_SESSION['companyID'];
$orderID   = 0;
$invoiceID = 0;

$bank           = trim(''.$_POST['bank']);
$notes          = trim(''.$_POST['notes']);
$branch         = trim(''.$_POST['branch']);
$amount         = trim(''.$_POST['amount']);
$customerID     = trim(''.$_POST['customerID']);
$chequeDate     = trim(''.$_POST['chequeDate']);
$receiptDate    = trim(''.$_POST['receiptDate']);
$chequeNumber   = trim(''.$_POST['chequeNumber']);
$cashDiscount   = trim(''.$_POST['cashDiscount']);
$salespersonID  = trim(''.$_POST['salesperson']);
$paymentMethod  = trim(''.$_POST['paymentMethod']);
$receiptAddress = trim(''.$_POST['receiptAddress']);
$serviceCallID  = trim(''.$_POST['serviceCallID']);
$receiptID      = trim(''.$_POST['receiptID']);
$receiptCode    = trim(''.$_POST['receiptCode']);

$receiptItems = array();
$receiptItems = $_POST['receiptItems'];

$checkedInvoices =  array();
$checkedInvoices = $_POST['checkedInvoices'];

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

try {
    $db->begin_transaction();

    $receiptAmount = floatval($amount) + floatval($cashDiscount);
    $prevCustomerBalances = array();
    $stmt = $db->prepare("SELECT amount,cash_discount,customer_id FROM Receipts WHERE receipt_id=?");
    $stmt->bind_param('i', $receiptID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->bind_result($previousAmount, $previousDiscount,$prevCustomerID);
    while ($stmt->fetch()) {
        $prevCustomerBalance = new stdClass();
        $prevCustomerBalance->previousAmount = $previousAmount;
        $prevCustomerBalance->previousDiscount = $previousDiscount;
        $prevCustomerBalance->prevCustomerID = $prevCustomerID;
        array_push($prevCustomerBalances,$prevCustomerBalance);

    }
    $stmt->close();

    foreach ($prevCustomerBalances as $prevCustomerBalance) {
        $previousAmount   = $prevCustomerBalance->previousAmount;
        $previousDiscount = $prevCustomerBalance->previousDiscount;
        $prevCustomerID   = $prevCustomerBalance->prevCustomerID;

        $previousTotal    = $previousAmount + $previousDiscount;
        updateCustomerBalance($prevCustomerID, -$previousTotal, $db);
    }

    lockDocumentSingleTransaction($receiptID, "Receipts", $db);

    $stmt = $db->prepare("DELETE FROM Receipts WHERE receipt_id=?");
    $stmt->bind_param('i', $receiptID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);

    $statement = "DELETE FROM Receipts WHERE receipt_id=$receiptID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("INSERT INTO Receipts (receipt_id, receipt_code, customer_id, company_id, salesperson_id, order_id, invoice_id, address_id, amount, payment_method, cash_discount, bank, branch, cheque_number, cheque_date, receipt_date, notes) VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiiiidsdssssss', $receiptID, $receiptCode, $customerID, $companyID, $salespersonID, $orderID, $invoiceID, $receiptAddress, $amount, $paymentMethod, $cashDiscount, $bank, $branch, $chequeNumber, $chequeDate, $receiptDate, $notes);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $stmt = $db->prepare("DELETE FROM Transactions WHERE transaction_code=?");
    $stmt->bind_param('s', $receiptCode);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);
    $statement = "DELETE FROM Transactions WHERE transaction_code=\"$receiptCode\"";

    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();


    $sign = -1;
    $detailsTra = "Receipt $receiptCode";
    $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);

    $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $amount, $detailsTra);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    updateCustomerBalance($customerID, $amount, $db);

    if (floatval($cashDiscount) > 0) {
        $sign = -1;
        $detailsTra .= " Receipt Discount";
        $receiptCodeCD = $receiptCode . "-D";
        $transactionID = getNextKeySingleTransaction("Transactions", "transaction_id", $db);
        $stmt = $db->prepare("INSERT INTO Transactions (transaction_id,transaction_code,account_id,transaction_date,entry_date,action_code,sign,amount,details) VALUES(?,?,?,?,?,?,?,?,?)");
        $stmt->bind_param('isisssids', $transactionID, $receiptCode, $customerID, $receiptDate, $receiptDate, $receiptCode, $sign, $cashDiscount, $detailsTra);
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->close();

        updateCustomerBalance($customerID, $cashDiscount, $db);
    }


    foreach ($checkedInvoices as $invoice) {

        $stmt = $db->prepare("SELECT Invoices.grand_total, sum(Invoice_Receipt.amount) FROM Invoices LEFT JOIN Invoice_Receipt ON (Invoices.invoice_id = Invoice_Receipt.invoice_id) WHERE Invoices.invoice_id='$invoice'");
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->bind_result($invoiceTotal, $invoicePaid);
        while ($stmt->fetch()) {}
        $stmt->close();

        $pendingPayment = floatval($invoiceTotal) - floatval($invoicePaid);

        if (floatval($receiptAmount) >= 0) {

            if (floatval($pendingPayment) > floatval($receiptAmount)) {
                $payment = $receiptAmount;
                $receiptAmount = 0;
//                $cashDiscount = 0;
                $status = "Partially Paid";
            } else {
                $payment = $pendingPayment;
                $receiptAmount -= $pendingPayment;
                $status = "Paid";
            }

            $stmt = $db->prepare("INSERT INTO Invoice_Receipt (receipt_id, invoice_id, amount) VALUES(?,?,?)");
            $stmt->bind_param('iid', $receiptID, $invoice, $payment);
            $stmt->execute();
            if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
            $stmt->close();

            $stmt = $db->prepare("UPDATE Invoices SET status=? WHERE invoice_id=?");
            $stmt->bind_param('si', $status, $invoice);
            $stmt->execute();
            if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
            $stmt->close();

        }

    }

    $custTable = new CustomTable('Receipts', $receiptID);
    $codes = array();
    $codes = $custTable->getCustomTableCodes($db);
    foreach ($codes as $code) {
        $custTable->insertVariablesToCustomTable($_POST[$code->formCode], $code->tableCode, $db);
    }

    //Receipt Item Lines
    if (strcmp($paymentMethod,'Multiple')==0){
        $stmt = $db->prepare("DELETE FROM Receipt_Item WHERE receipt_id=?");
        $stmt->bind_param('i', $receiptID);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        $deleteID = getNextKeySingleTransaction("Deletes", "delete_id",$db);
        $statement = "DELETE FROM Receipt_Item WHERE receipt_id=?";
        $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
        $stmt->bind_param('is', $deleteID, $statement);
        $stmt->execute();
        if(strcmp("$stmt->error","")!=0) {throw new Exception();}
        $stmt->close();

        foreach ($receiptItems as $receiptItem) {
            $receiptLineAmount = $receiptItem['Amount'];
            $receiptLineBank = $receiptItem['Bank'];
            $receiptLineBranch = $receiptItem['Branch'];
            $receiptLineCash_Discount = $receiptItem['Cash Discount'];
            $receiptLineCheque_Date = $receiptItem['Cheque Date'];
            $receiptLineCheque_Number = $receiptItem['Cheque Number'];
            $receiptLineNotes = $receiptItem['Notes'];
            $receiptLineType = $receiptItem['Type'];

            $receiptItemID    = getNextKeySingleTransaction( "Receipt_Item", "receipt_item_id",$db);
            $stmt = $db->prepare("INSERT INTO Receipt_Item (receipt_item_id,receipt_id,amount,payment_method,cash_discount,bank,branch,cheque_number,cheque_date,notes) VALUES(?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iidsdsssss', $receiptItemID,$receiptID,$receiptLineAmount,$receiptLineType,$receiptLineCash_Discount,$receiptLineBank,$receiptLineBranch,$receiptLineCheque_Number,$receiptLineCheque_Date,$receiptLineNotes);
            $stmt->execute();
            if(strcmp("$stmt->error","")!=0) {throw new Exception();}
            $stmt->close();
        }

    }

    $db->commit(true);

    echo "$receiptID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}

$custForm = new CustomForm('Receipts',$receiptID);
$codes = array();
$codes = $custForm->getFormCodes();
foreach ($codes as $code) {
    $custForm->insertVariablesToCustomForm($_POST[$code], $code);
}




//redirect('./platform/manage_customers.php');


			
			
						
 
				
	
	

	
function redirect($url)
{
    if (headers_sent())
    {
        die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
    }
    else
    {
        header('Location: ' . $url);
        die();
    }
}

function getVatID($vatCode,$db)
{

    $z="";
    $stm1 = $db->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
    $stm1-> execute();
    $stm1-> bind_result($counter);
    while ($stm1->fetch()) {
        $z=$counter;
    }
    $stm1->close();


    return $z;



}

function getSubUnits($itemID,$db) {

    $stm1 = $db->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $sub;


}

function updateCustomerBalance($customerID,$amount,$db)
{

    $stmt = $db->prepare("UPDATE  Customers SET balance = balance - ? WHERE customer_id=?");
    $stmt->bind_param('di',$amount,$customerID);
    $stmt->execute();
    $stmt->close();

}
?>