<?php
include_once("../../../../param.php");
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

$name = trim(''.$_POST['name']);
$code = trim(''.$_POST['code']);
if(isset($_POST['id'])){
    $couponID = intval(trim(''.$_POST['id']));
}
else{
    $couponID=0;
}


if(empty($name) || empty($code)){
    echo 'error';
    exit();
}

global $username, $password, $database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$stm = $db->prepare("SELECT coupon_id FROM Receipt_Coupons WHERE NOT coupon_id=? AND coupon_code LIKE ? LIMIT 1");
$stm->bind_param("is", $couponID,$code);
$stm->execute();
$stm->bind_result($existingCodeID);
$stm->fetch();
$stm->close();

$existingCodeID = intval($existingCodeID);

if($existingCodeID > 0) {
    echo "existingCode";
    return;
}

if($couponID > 0){

    $stmt = $db->prepare("UPDATE Receipt_Coupons SET coupon_code = ?,coupon_name = ? WHERE coupon_id = ?");
    $stmt->bind_param('ssi',$code,$name,$couponID);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();
} else {
    $stmt = $db->prepare("SELECT MAX(coupon_id) FROM Receipt_Coupons");
    $stmt->execute();
    $stmt->bind_result($maxID);
    $stmt->fetch();
    $stmt->close();

    $nextID = $maxID + 1;
    $stmt = $db->prepare("INSERT INTO Receipt_Coupons (coupon_id,coupon_code,coupon_name, timestamp) VALUES (?,?,?,NOW())");
    $stmt->bind_param('iss',$nextID,$code,$name);
    $stmt->execute();
    $error = $stmt->error;
    $stmt->close();

}


if($error){
    echo 'error';
    exit();
}





?>