<?php
include_once("../../../../param.php");
include_once(ROOT . "concc/dbhelpers/dbhelper.php");

$companyID = $_SESSION['companyID'];
$salespersonID= trim(''.$_POST['salespersonSearch']);
$warehouseIDFrom= trim(''.$_POST['warehouseIDFrom']);
$warehouseIDTo= trim(''.$_POST['warehouseIDTo']);
$details= trim(''.$_POST['details']);
$wtDate= trim(''.$_POST['wtDate']);
$serviceCallID = trim(''.$_POST['serviceCallID']);
$convertedOrderID = trim(''.$_POST['fromOrderID']);
$supplierID = trim(''.$_POST['supplierID']);

$wtItems = json_decode($_POST['orderItems'], true);

$transactionType="Transfer";

$wtCode=trim($_POST['warehouseTransactionCode']);
$wtID=trim($_POST['wtID']);

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
     printf("Connect failed: %s\n", mysqli_connect_error());
     exit();
}
$db->set_charset("utf8");
try {
    $db->begin_transaction();

    if (isset($wtDate)) {
        $date = DateTime::createFromFormat('d/m/Y', $wtDate);
        $wtDate = $date->format('Y-m-d');
    }


    $stmt = $db->prepare("SELECT warehouse_id_from,warehouse_id_to FROM Warehouse_Transactions WHERE warehouse_transaction_id=?");
    $stmt->bind_param('i', $wtID);
    $stmt->execute();
    $stmt->bind_result($previousFrom, $previousTo);
    while ($stmt->fetch()) {
    }
    $stmt->close();

    lockDocumentSingleTransaction($wtID, "Warehouse_Transactions", $db);

    $stmt = $db->prepare("DELETE FROM Warehouse_Transactions WHERE warehouse_transaction_id=?");
    $stmt->bind_param('i', $wtID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);
    $statement = "DELETE FROM Warehouse_Transactions WHERE warehouse_transaction_id=$wtID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();


    $stmt = $db->prepare("INSERT INTO Warehouse_Transactions (warehouse_transaction_id,warehouse_transaction_code,warehouse_id_from,warehouse_id_to,company_id,salesperson_id,type,transaction_date,details) VALUES(?,?,?,?,?,?,?,?,?)");
    $stmt->bind_param('isiiiisss', $wtID, $wtCode, $warehouseIDFrom, $warehouseIDTo, $companyID, $salespersonID, $transactionType, $wtDate, $details);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();


    $transferItemsForSockArray = getStockUpdateLinesOfDocument($db, 7, $wtID);

    foreach ($transferItemsForSockArray as $itemObject) {

        $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, "0000-00-00", 7, $wtID, $wtCode, 'Edit Transfer (Remove)', 0, null, null, 0, null);
        if (!$insertStockUpdateStatementResult) {throw new Exception();}


        $insertStockStatementResult = insertStockRecord($db, $itemObject->warehouseID, $itemObject->itemID, $itemObject->batchNumber, -$itemObject->available, -$itemObject->reserved, -$itemObject->delivered, -$itemObject->onOrder, -$itemObject->requested, -$itemObject->sold, '0000-00-00');
        if (!$insertStockStatementResult) {throw new Exception();}

    }


    $stmt = $db->prepare("DELETE FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id=?");
    $stmt->bind_param('i', $wtID);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $deleteID = getNextKeySingleTransaction("Deletes", "delete_id", $db);
    $statement = "DELETE FROM Warehouse_Transaction_Item WHERE warehouse_transaction_id=$wtID";
    $stmt = $db->prepare("INSERT INTO Deletes (delete_id,statement) VALUES(?,?)");
    $stmt->bind_param('is', $deleteID, $statement);
    $stmt->execute();
    if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
    $stmt->close();

    $purchaseItems = array();
    foreach ($wtItems as $wtItem) {

        $itemID = $wtItem['itemID'];
        if ($itemID > 0) {
            $qty = $wtItem['Qty'];
            $batchNumber = $wtItem['Batch Number'];
            $binLocation = $wtItem['Bin Location'];
            $expiryDate = $wtItem['Expiry Date'];
            $fromOrderItemID = $wtItem['docItemID'];
            $purchaseOrder = $wtItem['P. Order'];
            $isPurchaseOrder = false;
            if (strcmp($purchaseOrder, 'yes') == 0) {
                $isPurchaseOrder = true;
            }

            if ($isPurchaseOrder) {

                $purchaseItem = new stdClass();
                $purchaseItem->id = $itemID;
                $purchaseItem->qty = $qty;
                $purchaseItem->orderItemID = $fromOrderItemID;

                array_push($purchaseItems, $purchaseItem);
                $isPurchaseOrder = false;

            } else {


                $warehouseItemID = getNextKeySingleTransaction("Warehouse_Transaction_Item", "warehouse_transaction_item_id", $db);

                if (strcmp($batchNumber, '') == 0 || !isset($batchNumber)) {
                    $batchNumber = '0';
                    $expiryDate = '0000-00-00';
                }

                if(strcmp("$binLocation",'')!=0) {
                    $batchNumber = $batchNumber . ';BIN;' . $binLocation;
                }

                $stmt = $db->prepare("INSERT INTO Warehouse_Transaction_Item (warehouse_transaction_item_id,warehouse_transaction_id,item_id,warehouse_id,qty,batch_number) VALUES(?,?,?,?,?,?)");
                $stmt->bind_param('iiiids', $warehouseItemID, $wtID, $itemID, $warehouseIDFrom, $qty, $batchNumber);
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
                $stmt->close();


                $available = -$qty;
                $insertStockStatementResult = insertStockRecord($db, $warehouseIDFrom, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate);
                if (!$insertStockStatementResult) {throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseIDFrom, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate, 7, $wtID, $wtCode, 'Edit Transfer', 0, null, null, 0, null);
                if (!$insertStockUpdateStatementResult) {throw new Exception();}

                $available = $qty;
                $insertStockStatementResult = insertStockRecord($db, $warehouseIDTo, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate);
                if (!$insertStockStatementResult) {throw new Exception();}

                $insertStockUpdateStatementResult = insertStockUpdateRecord($db, $warehouseIDTo, $itemID, $batchNumber, $available, 0, 0, 0, 0, 0, $expiryDate, 7, $wtID, $wtCode, 'Edit Transfer', 0, null, null, 0, null);
                if (!$insertStockUpdateStatementResult) {throw new Exception();}
            }
        }

    }

    if (!empty($purchaseItems)) {
        require_once(ROOT . "concc/dbhelpers/classes/DBItem.php");
        $dbHelperItem = new DBItem();


        $orderID = getNextKeySingleTransaction("Purchase_Orders", "order_id", $db);
        $orderCode = getNextCodeSingleTransaction("Purchase_Orders", "order_code", "PO", "CLOUD", $db);

        if (strcmp($orderCode, '') == 0) {
            $orderCode = getNextPurchaseOrderCode("CLOUD", $db);
        }

        $customerID = $supplierID;
        if (strcmp($customerID, '') == 0) {
            $customerID = 0;
        }
        $paymentMethod = 0;
        $subtotal = 0;
        $grandTotal = 0;
        $vatTotal = 0;
        $discountAmount = 0;
        $billingAddress = 0;
        $deliveryAddress = 0;
        $orderDate = date('Y-m-d');
        $dueDate = "0000-00-00";
        $details = ' ';
        $globalDiscountPercentage = 0;
        $status = "Placed";
        $warehouseID = 0;
        $tenderID = 0;
        $printCount = 0;
        $vatIorE = 'i';
        $depositAmount = 0;
        $currencyID = 1;
        $deliveryMethod = "Not Set";

        $stmt = $db->prepare("INSERT INTO Purchase_Orders(order_id, order_code, company_id, customer_id, salesperson_id, paymenttype_id, order_date, subtotal, grand_total,vat_amount, discount_amount, print_count, order_address_id, delivery_address_id, tender_id, vat_i_or_e, delivery_date, deposit_amount, details, status, currency_id, global_discount_percentage, delivery_method, timestamp) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())");
        $stmt->bind_param('isiiiisddddiiiissdssids', $orderID, $orderCode, $companyID, $customerID, $salespersonID, $paymentMethod, $orderDate, $subtotal, $grandTotal, $vatTotal, $discountAmount, $printCount, $billingAddress, $deliveryAddress, $tenderID, $vatIorE, $dueDate, $depositAmount, $details, $status, $currencyID, $globalDiscountPercentage, $deliveryMethod);
        $stmt->execute();
        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
        $stmt->close();

        lockDocumentSingleTransaction($orderID, "Purchase_Orders", $db);


        $lineTotals = 0;
        $lineDiscountTotals = 0;
        foreach ($purchaseItems as $orderItem) {

            $itemID = $orderItem->id;
            $itemNotes = '';
            if ($itemID > 0) {

                $qty = $orderItem->qty;
                $fromOrderItemID = $orderItem->orderItemID;
                $item = $dbHelperItem->getItemByID($itemID);
                $unitPrice = 0;
                $lineDiscount = 0;
                $subunits = getSubUnits($itemID, $db);
                if (strpos($lineDiscount, '%') !== false) {
                    $lineDiscountSelectedPercentage = str_replace("%", "", $lineDiscount);
                    $lineDiscount = ($qty / $subunits) * $unitPrice * ($lineDiscountSelectedPercentage / 100);
                } else {
                    $lineDiscountSelectedPercentage = 0;
                }
                $priceType = 0;
                $globalDiscount = 0;
                $vatTotal = 0;
                $vatID = $item->vatID;

                $lineTotals += $unitPrice * $qty / $subunits;
                $lineDiscountTotals += $lineDiscount;

                $orderItemID = getNextKeySingleTransaction("Purchase_Order_Item", "order_item_id", $db);


                $stmt = $db->prepare("INSERT INTO Purchase_Order_Item (order_item_id,order_id,item_id,qty,unit_price,line_discount,global_discount,vat_amount,pricetype_id,vat_id,line_discount_percentage,description) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
                $stmt->bind_param('iiidddddiids', $orderItemID, $orderID, $itemID, $qty, $unitPrice, $lineDiscount, $globalDiscount, $vatTotal, $priceType, $vatID, $lineDiscountSelectedPercentage, $itemNotes);
                $stmt->execute();
                if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
                $stmt->close();

                if (isset($convertedOrderID) && $convertedOrderID > 0) {
                    if ($fromOrderItemID > 0) {
                        $stmt = $db->prepare("UPDATE Order_Item SET master_item = 'PO:$qty' WHERE order_item_id=?  ");
                        $stmt->bind_param('i', $fromOrderItemID);
                        $stmt->execute();
                        if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
                        $stmt->close();
                    }

                }

            }

        }
        setNextOrderCodeSingleTransaction("CLOUD", $db);

        if ($serviceCallID > 0) {

            $serviceCallReplyID = getNextKeySingleTransaction("Service_Call_Reply", "service_call_reply_id", $db);
            $status = 0;
            $timezone = 2;
            date_default_timezone_set('Europe/Athens');
            $date = date("Y-m-d H:i:s");
            $replyTypeID = 3;
            $details = "New Purchase Order Issued";
            $documentType = "Purchase_Order";
            $salespersonTo = 0;
            $emailResponse = "";
            $priorityID = 0;
            $stmt = $db->prepare("INSERT INTO Service_Call_Reply (service_call_reply_id,service_call_id,salesperson_id,status_id,date,reply_type_id,details,document_id,document_type,salesperson_to,email_response,priority_id) VALUES(?,?,?,?,?,?,?,?,?,?,?,?)");
            $stmt->bind_param('iiiisisisisi', $serviceCallReplyID, $serviceCallID, $salespersonID, $status, $date, $replyTypeID, $details, $orderID, $documentType, $salespersonTo, $emailResponse, $priorityID);
            $stmt->execute();
            if (strcmp("$stmt->error", "") != 0) {throw new Exception();}
            $stmt->close();
        }
    }


    $db->commit(true);

    echo "$wtID";

} catch (Exception  $e) {
    echo 'error';
    $db->rollback();
}







	

	
function redirect($url)
{
	if (headers_sent())
	{
		die('<script type="text/javascript">window.location.href="' . $url . '";</script>');
	}
	else
	{
		header('Location: ' . $url);
		die();
	}    
}

function getVatID($vatCode)
{
 global $username;
 global $password;
 global $database;
 $z="";
 $db1 = new mysqli(localhost,$username,$password,$database);
 if (mysqli_connect_errno()) {
  printf("Connect failed: %s\n", mysqli_connect_error());
  exit();
 }
 $db1->set_charset("greek");

 $stm1 = $db1->prepare("SELECT vat_id FROM Vats WHERE vat_code='$vatCode'");
 $stm1-> execute();
 $stm1-> bind_result($counter);
 while ($stm1->fetch()) {
  $z=$counter;
 }
 $stm1->close();


 return $z;



}

function getSubUnits($itemID,$db1='') {

    if(is_string($db1) && strcmp($db1,'')==0) {
        global $username, $password, $database;
        $db1 = new mysqli(localhost, $username, $password, $database);
        if (mysqli_connect_errno()) {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db1->set_charset("utf8");
    }
    $subunits=1;
    $stm1 = $db1->prepare("SELECT subunits FROM Items WHERE item_id='$itemID'");
    $stm1-> execute();
    $stm1-> bind_result($sub);
    while ($stm1->fetch()) {
        return $sub;
    }
    $stm1->close();
    return $subunits;


}


?>