<?php


include_once("../../../../param.php");

$stockTakingIDs =$_POST['stockTakingIDs'];
$selectedFields  =$_POST['selectedFields'];
$selectedFields = explode(',', $selectedFields);

$delimiter = trim($_POST['delimiter']);
$fileExtension = trim($_POST['fileExtension']);
$includeHeaders= true;
if(!isset($_POST['includeHeaders'])){
    $includeHeaders=false;
}

//shared database connection
global $username,$database,$password;
$db2 = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db2->set_charset("utf8");

$myfile = fopen("ssdsdsdsdsdsdsdsdsdsds.txt", "w") or die("Unable to open file!");

fwrite($myfile,$stockTakingIDs."\n");

if(strcmp($delimiter,"")==0)
{
    $delimiter="\t";
}


if(strcmp($fileExtension,"")==0)
{
    $fileExtension=".txt";
}
fclose($myfile);

if(strcmp($stockTakingIDs,"")!=0) {

    $myfile = fopen("stocktake" . $fileExtension, "w") or die("Unable to open file!");

    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    if ($includeHeaders) {
        writeHeaders($myfile,$delimiter,$selectedFields);
    }

    $batchNumberIncluded = false;
    if (in_array('batchNumber', $selectedFields)) {
        $batchNumberIncluded = true;
    }

    $warehouseCode = "01";
    $stm = $db->prepare("SELECT si.item_id,SUM(si.qty),si.batch_number, s.stock_taking_code, s.warehouse_id,description FROM Stock_Taking_Item AS si INNER JOIN Stock_Taking AS s ON s.stock_taking_id = si.stock_taking_id WHERE s.stock_taking_id IN($stockTakingIDs) GROUP BY si.item_id ");
    $stm->execute();
    $stm->bind_result($itemID, $qty,$batchNumber,$stockTakingCode,$warehouseID,$description);
    while ($stm->fetch()) {

        $itemData = getItemFields($itemID,$db2);
        $itemCode= $itemData['itemCode'];
        $itemName = $itemData['itemName'];
        $itemName = str_replace($delimiter, ' ', $itemName);

        $itemBarcode = $itemData['itemBarcode'];

        $warehouseData = getWarehouseFields($warehouseID,$db2);
        $warehouseCode = $warehouseData['warehouseCode'];
        $warehouseName = $warehouseData['warehouseName'];
        $warehouseName = str_replace($delimiter, ' ', $warehouseName);



        $currentQty = getStockAvailable($itemID,$warehouseID,$batchNumber,$batchNumberIncluded,$db2);

        $line = '';

        if (in_array('warehouseCode', $selectedFields)) {
            $line .= $warehouseCode .$delimiter;
        }

        if (in_array('warehouseName', $selectedFields)) {
            $line .= $warehouseName .$delimiter;
        }

        if (in_array('stockTakingCode', $selectedFields)) {
            $line .= $stockTakingCode .$delimiter;
        }
        if (in_array('itemCode', $selectedFields)) {
            $line .= $itemCode .$delimiter;
        }
        if (in_array('barcode', $selectedFields)) {
            $line .= $itemBarcode.$delimiter;
        }
        if (in_array('itemName', $selectedFields)) {
            $line .= $itemName .$delimiter;
        }
        if (in_array('currentQuantity', $selectedFields)) {
            $line .= $currentQty .$delimiter;
        }
        if (in_array('countedQuantity', $selectedFields)) {
            $line .= $qty .$delimiter;
        }
        if (in_array('batchNumber', $selectedFields)) {
            $line .= $batchNumber . $delimiter;
        }
        if (in_array('notes', $selectedFields)) {
            $line .= $description. $delimiter;
        }

        //remove last delimiter
        $line = substr($line, 0, strlen($line) - strlen($delimiter));

        fwrite($myfile, $line . "\r\n");
    }
    $stm->close();


    fclose($myfile);

    $file = "stocktake" . $fileExtension;
    if (file_exists($file)) {
        header('Content-Description: File Transfer');
        header('Content-Type: application/octet-stream');
        header('Content-Disposition: attachment; filename="' . basename($file) . '"');
        header('Expires: 0');
        header('Cache-Control: must-revalidate');
        header('Pragma: public');
        header('Content-Length: ' . filesize($file));
        readfile($file);
        exit;
    }
}
else{
    //redirect("//" . HTML_PATH . "/cop/backend/core/views/exports/export_warehouse_stock_takings.php");
}

function writeHeaders($myfile,$delimiter,$selectedFields){

    $headers = [];
    if (in_array('warehouseCode', $selectedFields)) {
        $headers[] = 'Warehouse Code';
    }
    if (in_array('warehouseName', $selectedFields)) {
        $headers[] = 'Warehouse Name';
    }
    if (in_array('stockTakingCode', $selectedFields)) {
        $headers[] = 'Stock Taking Code';
    }
    if (in_array('itemCode', $selectedFields)) {
        $headers[] = 'Item Code';
    }
    if (in_array('barcode', $selectedFields)) {
        $headers[] = 'Barcode';
    }
    if (in_array('itemName', $selectedFields)) {
        $headers[] = 'Item Name';
    }
    if (in_array('currentQuantity', $selectedFields)) {
        $headers[] = 'Current Quantity';
    }
    if (in_array('countedQuantity', $selectedFields)) {
        $headers[] = 'Counted Quantity';
    }
    if (in_array('batchNumber', $selectedFields)) {
        $headers[] = 'Batch Number';
    }
    if (in_array('notes', $selectedFields)) {
        $headers[] = 'Notes';
    }
    fwrite($myfile, implode($delimiter, $headers) . "\r\n");
}

function getItemFields($itemID,$db2){
    $stm2 = $db2->prepare('SELECT i.item_code, i.name,b.barcode FROM Items as i LEFT JOIN Item_Barcode as b ON i.item_id=b.item_id WHERE i.item_id=? LIMIT 1');
    $stm2-> bind_param("i",$itemID);
    $stm2-> execute();
    $stm2-> bind_result($itemCode,$itemName, $itemBarcode);
    $result = array();
    if ($stm2->fetch()) {
        $result = array(
            'itemCode' => $itemCode,
            'itemName' => $itemName,
            'itemBarcode' => $itemBarcode
        );
    }
    $stm2-> close();
    return $result;
}

function getWarehouseFields($warehouseID,$db2){
    $stm2 = $db2->prepare("SELECT warehouse_code, name FROM Warehouses WHERE warehouse_id=? LIMIT 1");
    $stm2-> bind_param("i",$warehouseID);
    $stm2-> execute();
    $stm2-> bind_result($warehouseCode,$name);
    if ($stm2->fetch()) {
        $result = array(
            'warehouseCode' => $warehouseCode,
            'warehouseName' => $name
        );
    }
    $stm2-> close();
    return $result;

}

function getStockAvailable($itemID,$warehouseID,$batchNumber,$batchNumberIncluded,$db2){

    if($batchNumberIncluded){
        $stm2 = $db2->prepare("SELECT available FROM Stock WHERE item_id = ? AND warehouse_id = ? AND batch_number=? LIMIT 1  ");
        $stm2-> bind_param("iis",$itemID,$warehouseID,$batchNumber);
        $stm2-> execute();
        $stm2-> bind_result($available);
        if ($stm2->fetch()) {}
        $stm2-> close();

    }
    else {
        $stm2 = $db2->prepare("SELECT SUM(available) FROM Stock WHERE item_id = ? AND warehouse_id = ? ");
        $stm2->bind_param("ii", $itemID, $warehouseID);
        $stm2->execute();
        $stm2->bind_result($available);
        if ($stm2->fetch()) {
        }
        $stm2->close();
    }

    return $available;
}
?>