<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Tenders';
 
// Table's primary key
$primaryKey = "tender_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`t`.`tender_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image-padding tender center-canvas" src="./img/tendericon.png" width="30" height="30"></td>';},
        'field' => 'tender_code' ),

     array( 'db' => '`t`.`tender_code`', 'dt' =>  'code', 'field' =>'tender_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
     array( 'db' => '`t`.`tender_date`', 'dt' => 'date' , 'field' => 'tender_date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
             array( 'db' => '`t`.`valid_until`', 'dt' => 'valid', 'field' => 'valid_until' ),
             array( 'db' => '`t`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return round($d, 2);}, 
          'field' => 'grand_total' ),
         
     array( 'db' => '`t`.`tender_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form id="'.$d.'"action="//' .  HTML_PATH . '/cop/backend/core/views/view/view_tender.php" method="post">
           		<input type="hidden" name="tender_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-tender" value="View" style="width:60px">
			</form>';}, 
            'field' => 'tender_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => 'caga_user',
    'pass' => 'alexis01',
    'db'   => 'caga_data',
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Tenders` AS `t` LEFT JOIN `Customers` AS `c` ON (`t`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`t`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery)
     );
     
     ?>