<?php
include_once("../../../../param.php");

$warehouseID = intval($_GET['warehouseID']);

$table = 'Warehouse_BinLocations';
$primaryKey = "bin_location_id";

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$columns = array(
    array( 'db' => '`t`.`bin_location_id`', 'dt' =>  'bin_location_id','formatter' => function( $d, $row ){$GLOBALS['bin_location_id']=$d; return $d;}, 'field' =>'bin_location_id' ),
    array( 'db' => '`t`.`warehouse_id`', 'dt' =>  'stock','formatter' => function( $d, $row ) use ($db) {

        $location = $GLOBALS['location'];
        $whID = intval($d);
        $return = "<table style='width: 100%;'>";

        $batchNumber = "%;BIN;".$location;
        $hasStock = false;

        $stm = $db->prepare("SELECT item_code,SUM(available),SUM(reserved) FROM Stock,Items WHERE Stock.item_id=Items.item_id AND warehouse_id=? AND batch_number LIKE ? GROUP BY Stock.item_id");
        $stm->bind_param('is',$whID,$batchNumber);
        $stm->execute();
        $stm->bind_result($binItemCode,$available,$reserved);
        while ($stm->fetch()) {
            if($available > 0){
                $return .= "<tr  class='badge' style='background-color: #77956a;padding: 10px;margin: 2px;'><td> $binItemCode </td><td>&nbsp; Stock: &nbsp;</td><td> $available </td></tr>";
                $hasStock = true;
            }

            if($reserved > 0){
                $return .= "<tr  class='badge' style='background-color: darkgoldenrod;padding: 10px;margin: 2px;'><td> $binItemCode </td><td>&nbsp; Reserved: &nbsp;</td><td> $reserved </td></tr>";
                $hasStock = true;
            }
        }
        $stm->close();

        $return .= "</table>";

        $GLOBALS['hasStock'] = $hasStock;

        if(!$hasStock){return "<center>-</center>";}

        return "<center>".$return."</center>";

    }, 'field' =>'warehouse_id' ),
    array( 'db' => '`t`.`warehouse_id`', 'dt' =>  'warehouse_id', 'formatter' => function( $d, $row ){$GLOBALS['warehouse_id']=$d; return $d;}, 'field' =>'warehouse_id' ),
    array( 'db' => '`t`.`bin_location_code`', 'dt' =>  'location_code', 'field' =>'bin_location_code' ),
    array( 'db' => '`t`.`bin_location`', 'dt' => 'location','formatter' => function( $d, $row ){
        $GLOBALS['location']=$d;
        $hasStock = $GLOBALS['hasStock'];
        $binLocationID = intval($GLOBALS['bin_location_id']);
        $warehouseID = intval($GLOBALS['warehouse_id']);
        if(!$hasStock){
            if(strpos($d,"'") !== false){
                return "<input type='text' class='form-control text-center' value=\"$d\" onchange='updateBinLocation(this,\"location\",$binLocationID,$warehouseID)'>";
            } else {
                return "<input type='text' class='form-control text-center' value='$d' onchange='updateBinLocation(this,\"location\",$binLocationID,$warehouseID)'>";
            }
        }else{
            return "<b>$d</b>";
        }
    }, 'field' => 'bin_location' ),
    array( 'db' => '`t`.`description`', 'dt' => 'description','formatter' => function( $d, $row ){
        $hasStock = $GLOBALS['hasStock'];
        $binLocationID = intval($GLOBALS['bin_location_id']);
        $warehouseID = intval($GLOBALS['warehouse_id']);
        if(!$hasStock){
            if(strpos($d,"'") !== false){
                return "<input type='text' class='form-control text-center' value=\"$d\" style='width: 100%;cursor: ' onchange='updateBinLocation(this,\"description\",$binLocationID,$warehouseID)'>";
            } else {
                return "<input type='text' class='form-control text-center' value='$d' style='width: 100%;' onchange='updateBinLocation(this,\"description\",$binLocationID,$warehouseID)'>";
            }
        }else{
            return "<b>$d</b>";
        }
    }, 'field' => 'description' ),
    array( 'db' => '`t`.`position`', 'dt' => 'position','formatter' => function( $d, $row ){
        $binLocationID = intval($GLOBALS['bin_location_id']);
        $warehouseID = intval($GLOBALS['warehouse_id']);
        return "<input type='text' class='form-control text-center' value='$d' onchange='updateBinLocation(this,\"position\",$binLocationID,$warehouseID)'>";
    } , 'field' => 'position' ),
    array( 'db' => '`t`.`bin_location_id`', 'dt' => 'delete','formatter' => function( $d, $row ){
        $binLocationID = intval($GLOBALS['bin_location_id']);
        $warehouseID = intval($GLOBALS['warehouse_id']);
        $hasStock = $GLOBALS['hasStock'];

        if(!$hasStock){
            return "<img class='deleteRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;cursor: pointer;' onclick='deleteLocation($binLocationID,$warehouseID)' />";

        } else {
            return "<img class='deleteRowButton' src='//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/deleteicon.png' style='width:20px;height:20px;opacity: 0;cursor: no-drop;-webkit-filter: grayscale(100%);filter: grayscale(100%);opacity:0.4'   />";
        }

    } , 'field' => 'bin_location_id' ),
);

global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

$joinQuery = "FROM `Warehouse_BinLocations` AS `t` ";
$extraWhere = "`t`.`warehouse_id` = '$warehouseID'";

require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$extraWhere));



?>