<?php
include_once("../../../../param.php");

$docTypes = array('1'=>'Tender','2'=>'Order','3'=>'Waybill','4'=>'Return','5'=>'Invoice','6'=>'Receipt','7'=>'Transfer');

$typeFilter = $_GET['typeFilter'];
$codeFilter = $_GET['codeFilter'];

// DB table to use
$table = 'Documents_Status';

// Table's primary key
$primaryKey = "id";

$customerID =$_GET['customerID'];

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(


    array( 'db' => '`s`.`id`', 'dt' => 'id', 'formatter' => function( $d, $row ) {$GLOBALS['id']=$d;return $d;}, 'field' => 'id' ),
    array( 'db' => '`s`.`type`', 'dt' => 'type', 'formatter' => function( $d, $row ) {
        global $docTypes;
        if(strcmp($docTypes[$d],'Transfer')==0){
            $class = "invoice";
            $table = "Warehouse_Transactions";
            $fileView = "warehouse_transaction";
            $fileEdit = "warehouse_transfer";
            $codeColumn = "warehouse_transaction_code";
            $idColumn = 'warehouse_transaction_id';
        } else {
            $class = strtolower($docTypes[$d]);
            $table = $docTypes[$d]."s";
            $codeColumn = strtolower($docTypes[$d])."_code";
            $idColumn = strtolower($docTypes[$d]).'_id';
            $fileEdit = $fileView = $class;
        }

        $GLOBALS['type']=$d;
        $GLOBALS['class']=$class;
        $GLOBALS['table']=$table;
        $GLOBALS['idColumn']=$idColumn;
        $GLOBALS['codeColumn']=$codeColumn;
        $GLOBALS['fileEdit']=$fileEdit;
        $GLOBALS['fileView']=$fileView;

        global $typeFilter;

        if(strcmp($typeFilter,'')!=0) {
            if(strpos(strtolower($docTypes[$d]), strtolower($typeFilter)) !== false) {
                return $docTypes[$d];
            } else {
                return 'hideRow';
            }
        } else {
            return $docTypes[$d];
        }


    }, 'field' => 'type' ),
    array( 'db' => '`s`.`status`', 'dt' => 'status', 'formatter' => function( $d, $row ) {$GLOBALS['status']=$d;return $d;}, 'field' => 'status' ),
    array( 'db' => '`s`.`reason`', 'dt' => 'reason', 'formatter' => function( $d, $row ) {$GLOBALS['reason']=$d;return $d;}, 'field' => 'reason' ),
    array( 'db' => '`s`.`timestamp`', 'dt' => 'timestamp', 'formatter' => function( $d, $row ) {return date_format( date_create_from_format('Y-m-d H:i:s', $d), 'd-m-Y H:i');}, 'field' => 'timestamp' ),

    array( 'db' => '`s`.`id`', 'dt' => 'img', 'formatter' => function( $d, $row ) {
        global $docTypes;
        $docType = $GLOBALS['type'];
        $class = $GLOBALS['class'];
        $codeColumn = $GLOBALS['codeColumn'];


        return "<img class='custom-rounded-image ".$class." center-canvas' src='//".HTML_PATH."/cop/backend/themes/smartadmin/img/".strtolower($docTypes[$docType])."icon.png' width='30' height='30'>";

    }, 'field' => 'id' ),

    array( 'db' => '`s`.`id`', 'dt' => 'code', 'formatter' => function( $d, $row ) {


        $idColumn = $GLOBALS['idColumn'];
        $table = $GLOBALS['table'];
        $codeColumn = $GLOBALS['codeColumn'];

        global $codeFilter;

        if(strcmp($codeFilter,'')!=0){
            $where = " AND $codeColumn LIKE '%$codeFilter%'";
        } else {
            $where = '';
        }


        global $username,$password,$database;
        $db2 = new mysqli(localhost,$username,$password,$database);
        if (mysqli_connect_errno())
        {
            printf("Connect failed: %s\n", mysqli_connect_error());
            exit();
        }
        $db2->set_charset("utf8");
        $stm2 = $db2->prepare("SELECT $codeColumn FROM $table WHERE $idColumn = $d $where LIMIT 1");
        $stm2->execute();
        $stm2->bind_result($docCode);
        while ($stm2->fetch()) {}
        $stm2->close();

        if(strcmp($codeFilter,'')!=0){
            if(strcmp($docCode,'')!=0){
                return $docCode;
            } else {
                return 'hideRow';
            }
        } else {
            return $docCode;
        }

    }, 'field' => 'id' ),

    array( 'db' => '`s`.`id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {

        $docID = $GLOBALS['id'];
        $fileView = $GLOBALS['fileView'];
        $fileEdit = $GLOBALS['fileEdit'];
        $idColumn = $GLOBALS['idColumn'];
        $docType = $GLOBALS['type'];

        $buttons = '<form id="'.$docID.'" action="//' . HTML_PATH . '/cop/backend/core/views/view/view_'.$fileView.'.php" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="'.$idColumn.'" value="'.$docID.'">	           			                   
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-return yearly" value="View" >
                                                    </form>';

        $buttons .= '<form id="'.$docID.'" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/create_'.$fileEdit.'.php" method="post" target="_blank" style="display: inline-block; margin: 2px;">
                                                        <input type="hidden" name="'.$idColumn.'" value="'.$docID.'">
                                                        <input style="font-size:13px;width:55px;" type="submit" class="btn btn-primary" value="Edit" >
                                                    </form>';

        $buttons .= '<button type="button" class="btn btn-danger" id="deleteButton'.$docID.'" onclick="deleteRecord('.$docID.','.$docType.')" style="display: inline-block; margin: 2px;">Resend Record </button>';

        $buttons .= '<button type="button" class="btn btn-invoice" id="markButton'.$docID.'" onclick="markRecordOK('.$docID.','.$docType.')" style="display: inline-block; margin: 2px;">&nbsp;&nbsp;&nbsp;Mark as OK&nbsp;&nbsp;&nbsp;</button>';

        return $buttons;

    }, 'field' => 'id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Documents_Status` AS `s`";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

$where = str_replace('%20',' ',$_GET['filter']);


if(strcmp(trim("$codeFilter"),"") != 0) {

    global $username,$password,$database;
    $db2 = new mysqli(localhost,$username,$password,$database);
    if (mysqli_connect_errno()) {printf("Connect failed: %s\n", mysqli_connect_error());exit();}
    $db2->set_charset("utf8");
    $ids = array();

    foreach ($docTypes as $key => $value) {

        if(strcmp("$value",'Transfer')==0){
            $table = "Warehouse_Transactions";
            $codeColumn = "warehouse_transaction_code";
            $idColumn = 'warehouse_transaction_id';
        } else {
            $table = $value."s";
            $codeColumn = strtolower($value)."_code";
            $idColumn = strtolower($value).'_id';
        }

        $codeFilter = str_replace("'",'',$codeFilter);

        $stm2 = $db2->prepare("SELECT $idColumn FROM $table WHERE $codeColumn LIKE '%".trim($codeFilter)."%' ");
        $stm2->execute();
        $stm2->bind_result($id);
        while ($stm2->fetch()) {
            array_push($ids,$id);
        }
        $stm2->close();
    }

    if(is_array($ids) && count($ids)>0){
        $ids = array_unique($ids);
        $where .= " AND `s`.`id` IN (".implode(',',$ids).") ";
    } else {
        $where .= " AND 0=1 ";
    }
}

if(strcmp(trim("$typeFilter"),"") != 0) {
    foreach ($docTypes as $key => $value) {
        if(strpos(strtolower($value), strtolower($typeFilter)) !== false) {
            $where .= " AND `s`.`type` = $key ";
        }
    }
}


echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>