<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Items';

// Table's primary key
$primaryKey = "item_code";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns=array();



array_push($columns, array( 'db' => 'i.item_id', 'dt' => 'image', 'formatter' => function( $d, $row ) {

    $GLOBALS['itemID']=$d;

    global $username, $password, $database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");
    $check = false;
    $stm = $db->prepare("SELECT image_name FROM Item_Images WHERE item_id='$d' LIMIT 1");
    $stm->execute();
    $stm->bind_result($imgName);

    while ($stm->fetch()) {
        $d = "//" . HTML_PATH . "/cop/media/productImages/$imgName.jpg";
        if(file_exists(ROOT . "media/productImages/$imgName.jpg")) {
            $check = true;
        }


    }
    $stm->close();
    if(!$check) {
        if(file_exists(ROOT . "media/pdfimage/itemimg.png")){
            $d = "//" . HTML_PATH . "/cop/media/pdfimage/itemimg.png";
        }else{
            $d = "//" . HTML_PATH . "/cop/backend/themes/" . THEME_NAME . "/img/itemdefaulticon.jpg";
        }

    }
    return '<img class="img-responsive img-rounded center-canvas" src="'.$d.'" width="32" height="32"></td>';},
    'field' => 'item_id' ));

array_push($columns, array( 'db' => 'i.status', 'dt' => 'status', 'formatter' => function( $d, $row ) {
    if(strcmp($d,'inactive')==0){
        return "<span style='color: firebrick;font-weight: bold'>Inactive</span>";
    } else {
        return "<span style='color: #0ca30a;font-weight: bold'>Active</span>";
    }
}, 'field' => 'status' ));


array_push($columns, array( 'db' => 'i.item_code', 'dt' =>  'code', 'field' =>'item_code' ));
array_push($columns, array( 'db' => 'i.name', 'dt' => 'name', 'field' => 'name' ));
array_push($columns, array( 'db' => 'i.item_sku', 'dt' => 'sku' , 'field' => 'item_sku' ));



array_push($columns,   array( 'db' => 'i.item_id', 'dt' => 'form', 'formatter' => function( $d, $row ) {

    if(!isset($_GET['itemID']) ){
        $itemID = 0;
    }
    else{
        $itemID = $_GET['itemID'];
    }

    global $username,$password,$database;
    $db = new mysqli(localhost, $username, $password, $database);
    if (mysqli_connect_errno()) {
        printf("Connect failed: %s\n", mysqli_connect_error());
        exit();
    }
    $db->set_charset("utf8");

    $stm = $db->prepare("SELECT COUNT(*) FROM Related_Items WHERE item_id = '$itemID' AND related_item_id='$d'");
    $stm->execute();
    $stm->bind_result($counter);

    while ($stm->fetch()) {}
    $stm->close();

    if($counter>0)
    {
        return '
			<button   id="action-btn-'.$d.'" class="btn btn-danger" onclick="deactivateButtonClicked('.$d.');" style="width:100px">Remove</button>
			';
    }
    else{
        return '
			<button  id="action-btn-'.$d.'"  class="btn btn-success" onclick="activateButtonClicked('.$d.');"  style="width:100px">Add</button>
			';
    }



},
    'field' => 'item_id' ));


// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$itemID= $_GET['itemID'];
if( $_GET['showAll']==0) {
    $joinQuery = "FROM Items AS i INNER JOIN Related_Items AS r ON (i.item_id = r.related_item_id)";
    $where =" r.item_id='$itemID' ";
}
else{
    $joinQuery = "FROM Items AS i"; // return all the items as possible related items to choose
    $where ="i.item_id != '$itemID'";
}

require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>