<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once("../../../../param.php");
// DB table to use
$table = 'Service_Call';

// Table's primary key
$primaryKey = "service_call_id";

$serialNumberID = $_GET['serialNumberID'];

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image monthly center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/settingsicon.png" width="30" height="30"></td>';},
        'field' => 'service_call_code' ),
    array( 'db' => '`s`.`service_call_code`', 'dt' => 'code', 'field' => 'service_call_code' ),

    array( 'db' => '`t`.`type_name`', 'dt' => 'type', 'field' => 'type_name' ),
    array( 'db' => '`s`.`date`', 'dt' =>  'date', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    }, 'field' =>'date' ),
    array( 'db' => '`s`.`due_date`', 'dt' => 'duedate', 'formatter' => function( $d, $row ) {

        if(strcmp($d,"0000-00-00 00:00:00") == 0)
        {
            return "";
        }

        $d = date('d-m-Y H:i:s',strtotime($d));

        $d = str_replace("00:00:00", "", $d);

        return $d;
    },'field' => 'due_date' ),
    array( 'db' => '`s`.`topic`', 'dt' => 'topic' , 'field' => 'topic' ),

    array( 'db' => '`sa`.`salesperson_code`', 'dt' => 'salespersonid', 'field' => 'salesperson_code' ),

    array( 'db' => '`st`.`status_name`', 'dt' => 'statusid', 'field' => 'status_name' ),
    array( 'db' => '`s`.`service_call_id`', 'dt' => 'actions', 'formatter' => function( $d, $row ) {

        return '<form id="'.$d.'" class="tableRowForm" target="_blank" action="//' .  HTML_PATH . '/cop/backend/modules/service/views/service_call.php" method="post" style="display:inline;">
           		<input type="hidden" name="service_call_id" value="'.$d.'">		
			</form>
			'

            ;},
        'field' => 'service_call_id' )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Service_Call` AS `s` LEFT JOIN `SC_Types` AS `t` ON (`s`.`type_id` = `t`.`type_id` ) LEFT JOIN `SC_Status` AS `st` ON (`s`.`status_id` = `st`.`status_id` ) LEFT JOIN `Customers` AS `c` ON (`c`.`customer_id` = `s`.`customer_id`) LEFT JOIN `SalesPersons` AS `sa` ON (`s`.`salesperson_id` = `sa`.`salesperson_id` )";
require( ROOT.'backend/core/controllers/ssp2.class.php' );

if($serialNumberID!="" && isset($serialNumberID) && intval($serialNumberID) > 0) {
    $where = "s.serial_number_id = $serialNumberID";
} else {
    $where="1=0";
}





echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
);

?>