<?php
include_once("../../../../param.php");

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

$data = null;

if (isset($_POST['customerId']) && isset($_POST['subcustomerId']) && isset($_POST['type'])) {
    $customerId = intval($_POST['customerId']);
    $subcustomerId = intval($_POST['subcustomerId']);
    $type = $_POST['type'];

    $stm = $db->prepare("SELECT customer_id, subcustomer_id, type, position, notes, date_added 
                         FROM SubCustomers 
                         WHERE customer_id = ? AND subcustomer_id = ? AND type = ? 
                         LIMIT 1");
    $stm->bind_param("iis", $customerId, $subcustomerId, $type);
    $stm->execute();
    $stm->bind_result($customerId, $subcustomerId, $type, $position, $notes, $dateAdded);

    while ($stm->fetch()) {
        $data = new stdClass();
        $data->customer_id = $customerId;
        $data->subcustomer_id = $subcustomerId;
        $data->type = $type;
        $data->position = $position;
        $data->notes = $notes;
        $data->date_added = $dateAdded;
    }
    $stm->close();
}

if ($data != null) {
    echo json_encode($data);
} else {
    echo null;
}