<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'ApksPurchasing';

// Table's primary key
$primaryKey = "id";



// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names

global $username,$password,$database;
$db = new mysqli(localhost,$username,$password,$database);
if (mysqli_connect_errno())
{
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");


$stm = $db->prepare("SELECT coprime_user,master_user FROM Admin WHERE id='".$_SESSION['adminID']."'");
$stm->execute();
$stm->bind_result($copUserFlag,$masterUserFlag);
while ($stm->fetch()) {
    $copUserFlag = strtolower($copUserFlag);
    $masterUserFlag = strtolower($masterUserFlag);

}
$stm->close();

$coprimeUser = false;
if (strcmp( $copUserFlag,"yes")==0) {
    $coprimeUser = true;
}

$masterUser = false;
if (strcmp( $masterUserFlag,"yes")==0) {
    $masterUser = true;
}

$columns = array(
    array(
        'db' => 'a.id',
        'dt' => 'id',
        'field' => 'id'
        ),
    array(
        'db' => 'a.version',
        'dt' => 'version',
        'field' => 'version',
        'formatter' => function($d, $row) use($coprimeUser){
            if(!$coprimeUser){
                return $d;
            }
            $uniqueID = $row['id'] ;
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $fieldName = 'version';

            return "
        <div id='editable-$uniqueID' 
             data-field-name='$fieldName' 
             data-id='$uniqueID' 
             style='position: relative; cursor: pointer;'
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
             onclick='openEditField(\"$uniqueID\", \"$fieldName\", this);'>
            <span id='value-$fieldName-$uniqueID'>$displayValue</span>
            <span id='pen-$fieldName-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
            <div  style='white-space: nowrap;'>
	        <input type='number' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;'>
	        <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'>
            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
        </button>
</div>
        ";
        }
    ),

    array(
        'db' => 'a.url',
        'dt' => 'url',
        'field' => 'url',
        'formatter' => function($d, $row) use($coprimeUser){
            if(!$coprimeUser){
                return $d;
            }
            $uniqueID = $row['id'] ;
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $fieldName = 'url';

            return "
        <div id='editable-$uniqueID' 
             data-field-name='$fieldName' 
             data-id='$uniqueID' 
             style='position: relative; cursor: pointer;'
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
             onclick='openEditField(\"$uniqueID\", \"$fieldName\", this);'>
            <span id='value-$fieldName-$uniqueID'>$displayValue</span>
            <span id='pen-$fieldName-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
            <div  style='white-space: nowrap;'>
	        <input type='text' class='form-control text-center' id='input-$fieldName-$uniqueID' value='' style='display:none;width: 80%;' >
	        <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'>
            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
        </button>
</div>
        ";
        }
    ),

    array(
        'db' => 'a.force_update',
        'dt' => 'force_update',
        'field' => 'force_update',
        'formatter' => function($d, $row) use($coprimeUser,$masterUser){
            if(!$coprimeUser && !$masterUser){
                return $d;
            }
            $uniqueID = $row['id'] ;
            $displayValue = !empty($d) ? $d : '&nbsp;';
            $fieldName = 'force_update';

            return "
        <div id='editable-$uniqueID' 
             data-field-name='$fieldName' 
             data-id='$uniqueID' 
             style='position: relative; cursor: pointer;'
             onmouseover='$(this).find(\".fa-pencil\").show();'
             onmouseleave='$(this).find(\".fa-pencil\").hide();'
             onclick='openEditField(\"$uniqueID\", \"$fieldName\", this);'>
            <span id='value-$fieldName-$uniqueID'>$displayValue</span>
            <span id='pen-$fieldName-$uniqueID'><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
        </div>
            <div  style='white-space: nowrap;'>
            <select id='input-$fieldName-$uniqueID' style='display:none;'  class='form-control text-center'> 
                    <option value='no' " . ($d == 'no' ? 'selected' : '') . ">no</option>
                    <option value='optional' " . ($d == 'optional' ? 'selected' : '') . ">optional</option>
                    <option value='yes' " . ($d == 'yes' ? 'selected' : '') . ">yes</option>


              </select>
	        <button id='save-$fieldName-$uniqueID' class='btn btn-success' style='display:none;'>
            <i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i>
        </button>
</div>
        ";
        }
    )


);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `ApksPurchasing` AS `a`";
$where = '';


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
