<?php
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */


include_once('../../../../param.php');

// DB table to use
$table = 'Company_Bank_Details';

// Table's primary key
$primaryKey = "company_bank_id";

// Array of database columns which should be read and sent back to DataTables.
$columns = array(
    array(
        'db' => 'CONCAT(c.company_code," - ",c.company_name)',
        'dt' => 'company',
        'field' => 'company_code',
        'as'=>'company_code'
    ),
    array(
        'db' => 'b.type',
        'dt' => 'type',
        'field' => 'type'
    ),
    array(
        'db' => 'b.bank_name',
        'dt' => 'bank_name',
        'field' => 'bank_name'
    ),
    array(
        'db' => 'b.sort_code',
        'dt' => 'sort_code',
        'field' => 'sort_code'
    ),
    array(
        'db' => 'b.account_number',
        'dt' => 'account_number',
        'field' => 'account_number'
    ),
    array(
        'db' => 'b.iban',
        'dt' => 'iban',
        'field' => 'iban'
    ),
    array(
        'db' => 'b.bic',
        'dt' => 'bic',
        'field' => 'bic'
    ),
    array(
        'db' => 'p.payment_term_code',
        'dt' => 'paymentCode',
        'field' => 'payment_term_code'
    ),
    array(
        'db' => 'b.position',
        'dt' => 'position',
        'field' => 'position'
    ),
    array(
        'db' => 'b.details',
        'dt' => 'details',
        'field' => 'details'
    ),
    array(
        'db' => 'b.company_bank_id',
        'dt' => 'form',
        'formatter' => function ($d, $row) {
            $editButton = '<form id="edit_' . $d . '" action="//' . HTML_PATH . '/cop/backend/core/views/addedit/new_company_bank_details.php" method="post" style="display:inline;">
                <input type="hidden" name="companyBankID" value="' . $d . '">
                <input type="submit" class="btn btn-primary" value="Edit"> 
            </form>';

            return $editButton;
        },
        'field' => 'company_bank_id'
    )
);

// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM Company_Bank_Details as b
                LEFT JOIN Companies AS c ON b.company_id = c.company_id
                LEFT JOIN Payment_Terms as p ON b.payment_term_id = p.payment_term_id";
$where = ''; // Add any specific where clauses if needed

require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple($_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where)
);
?>