<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'GPS_Log';

// Table's primary key
$primaryKey = "gps_log_id";

// Array of database columns which should be read and sent back to DataTables.
// The db parameter represents the column name in the database, while the dt
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => " g.lat",
        'dt' => 'lat',
        'field' => 'lat'
    ),
    array(
        'db' => "g.lng",
        'dt' => 'lng',
        'field' => 'lng'
    ),
    array(
        'db' => 'g.time',
        'dt' => 'time',
        'field' => 'time'
    ),
    array(
        'db' => "CONCAT(s.salesperson_code,' - ',s.first_name,' ',s.last_name)",
        'dt' => 'salesperson',
        'field' => 'salesperson',
        'as'=> 'salesperson'
    ),
    array(
        'db' => "soa.action_type",
        'dt' => 'schedule_action',
        'field' => 'action_type'
    ),
    array(
        'db' => "soa.action_type",
        'dt' => 'schedule_action',
        'field' => 'action_type'
    )


);
global $username,$password,$database;
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM GPS_Log AS g
                LEFT JOIN SalesPersons as s ON s.salesperson_id = g.salesperson_id
                LEFT JOIN Schedule_Object_Actions as soa ON soa.schedule_object_action_id = g.schedule_object_action_id
             ";
$where = '';


require(ROOT . 'backend/core/controllers/ssp2.class.php');

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>
