<?php
include_once("../../../../param.php");
// DB table to use
$table = 'Invoices';
 
// Table's primary key
$primaryKey = "invoice_code";
$receiptID = trim(''.$_GET['receiptID']);
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`i`.`invoice_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image invoice center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/invoiceicon.png" width="30" height="30"></td>';},
        'field' => 'invoice_code' ),
     array( 'db' => '`i`.`invoice_code`', 'dt' =>  'code', 'field' =>'invoice_code' ),
       array( 'db' => '`c`.`customer_code`', 'dt' => 'customercode', 'field' => 'customer_code' ),
       array( 'db' => '`i`.`status`', 'dt' => 'status', 'field' => 'status' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
     array( 'db' => '`i`.`invoice_date`', 'dt' => 'date' ,'formatter' => function( $d, $row ) {
         return date('d-m-Y',strtotime($d));}, 'field' => 'invoice_date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
             array( 'db' => '`i`.`invoice_type`', 'dt' => 'type', 'field' => 'invoice_type' ),
             array( 'db' => '`i`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return currencySymbol . number_format($d,2);},
          'field' => 'grand_total' ),
         
     array( 'db' => '`i`.`invoice_id`', 'dt' => 'remaining', 'formatter' => function( $d, $row ) {

             global  $username, $password, $database;
             $db = new mysqli(localhost, $username, $password, $database);
             if (mysqli_connect_errno()) {
                 printf("Connect failed: %s\n", mysqli_connect_error());
                 exit();
             }
             $stm = $db->prepare("SELECT Invoices.grand_total, sum(Invoice_Receipt.amount) FROM Invoices LEFT JOIN Invoice_Receipt ON (Invoices.invoice_id = Invoice_Receipt.invoice_id) WHERE Invoices.invoice_id='$d'");
             $stm->execute();
             $stm->bind_result( $total, $invoicePaid);
             while ($stm->fetch()) {}
             $stm->close();
             $remaining = $total - $invoicePaid;
             return currencySymbol . strval(number_format($remaining,2)); },

            'field' => 'invoice_id' ),
array( 'db' => '`i`.`invoice_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return "<input type='checkbox' class='form-control' name='invoice' id='$d' style='width: 20%;' disabled checked>";},
            'field' => 'invoice_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Invoice_Receipt` AS `r` LEFT JOIN `Invoices` AS `i` ON (`i`.`invoice_id` = `r`.`invoice_id`) LEFT JOIN `Customers` AS `c` ON (`i`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`i`.`salesperson_id` = `s`.`salesperson_id`)";
$where = " `r`.`receipt_id` =  '$receiptID' ";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>