<?php
include_once('../../../../param.php');

$splitOrdersToPicks = false;
if(isset($_GET['splitOrdersToPicks']) && strcmp($_GET['splitOrdersToPicks'],'true')==0) {
    $splitOrdersToPicks = true;
}

global $username, $password, $database;
$db = new mysqli(localhost, $username, $password, $database);
if (mysqli_connect_errno()) {
    printf("Connect failed: %s\n", mysqli_connect_error());
    exit();
}
$db->set_charset("utf8");

// DB table to use
$table = 'Orders';
 
// Table's primary key
$primaryKey = "order_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`o`.`order_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image order center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/ordericon.png" width="30" height="30"></td>';},
        'field' => 'order_code' ),
     array( 'db' => '`o`.`order_code`', 'dt' =>  'code', 'field' =>'order_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
    array( 'db' => '`o`.`order_id`', 'dt' => 'partiallyPicked' , 'formatter' => function( $d, $row ) use($splitOrdersToPicks,$db) {

        if($splitOrdersToPicks) {
            $lines = array();
            $stmt = $db->prepare("SELECT Order_Item.order_item_id,Order_Item.item_id,Items.item_code,Items.name,Order_Item.description,SUM(qty) FROM Order_Item,Items WHERE Order_Item.item_id = Items.item_id AND order_id = ? GROUP BY Order_Item.item_id ");
            $stmt->bind_param('i', $d);
            $stmt->execute();
            $stmt->bind_result($order_item_id, $item_id, $item_code, $name, $description, $qty);
            while ($stmt->fetch()) {

                $line = new stdClass();
                $line->order_item_id = $order_item_id;
                $line->item_id = $item_id;
                $line->item_code = $item_code;
                $line->name = $name;
                $line->description = $description;
                $line->qty = $qty;

                array_push($lines, $line);
            }
            $stmt->close();

            $pickLines = array();
            $stmt = $db->prepare("SELECT Pick_Item.item_id,SUM(Pick_Item.qty_to_pick),pick_code FROM Pick_Item,Pick,Pick_Order WHERE Pick_Order.pick_id = Pick.pick_id AND Pick_Item.pick_id=Pick.pick_id AND Pick_Order.order_id = ? AND Pick.status NOT LIKE 'Cancelled' GROUP BY Pick_Item.item_id");
            $stmt->bind_param('i', $d);
            $stmt->execute();
            $stmt->bind_result($item_id, $qty_to_pick, $pickCode);
            while ($stmt->fetch()) {
                $pickLines[$item_id]['qty'] = $qty_to_pick;
                $pickLines[$item_id]['pick'] = $pickCode;
            }
            $stmt->close();


            if (count($pickLines) == 0) {
                $pickedFlag = 0;
            } else if (count($pickLines) == count($lines)) {
                $pickedFlag = 2;
            } else {
                $pickedFlag = 1;
            }
        } else {
            $pickedFlag = 0;
        }

        $GLOBALS['pickedFlag'] = $pickedFlag;

        return $pickedFlag;


    },'field' => 'order_id' ),
     array( 'db' => '`o`.`order_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
         return date('d-m-Y',strtotime($d));},'field' => 'order_date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson', 'field' => 'salesperson_code' ),
             array( 'db' => '`o`.`delivery_date`', 'dt' => 'delivery', 'formatter' => function( $d, $row ) {
                 return date('d-m-Y',strtotime($d));},'field' => 'delivery_date' ),
             array( 'db' => '`o`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return currencySymbol . number_format($d,2);},
          'field' => 'grand_total' ),
         
     array( 'db' => '`o`.`order_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) use($splitOrdersToPicks) {

            if($splitOrdersToPicks){
                $pickedFlag = $GLOBALS['pickedFlag'];
                if(intval($pickedFlag) == 2){
                    $button = '<button type="button" class="btn btn-success" style="font-size:12px; width: 110px; margin-top: 3px;" onclick="splitToPicks('.$d.')">View Pick(s)</button>';
                } else {
                    $button = '<button type="button" class="btn btn-visit" style="font-size:12px; width: 110px; margin-top: 3px;" onclick="splitToPicks('.$d.')">Split to Picks</button>';
                }
            } else {
                $button = '<button type="button" class="btn btn-success" style="font-size:12px; width: 110px; margin-top: 3px;" onclick="releaseOrder('.$d.')">Ready to Pick</button>';
            }

                return '<form style="display:inline;" target="_blank" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_order.php" method="post">
           		<input type="hidden" name="order_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-primary" value="View" style="width:60px">
			</form>
			<form style="display:inline;" target="_blank" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_order.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="padding: 5px 20px 5px 20px;font-size:14px;width:50px;padding-left:10px;" type="submit" class="btn btn-invoice" value="Edit">
			</form>
			'.$button.'
			

			<!-- <form style="display:inline;" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_invoice.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="" type="submit" class="btn btn-invoice" value="Convert To Invoice">
			</form>
			<form style="display:inline;" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_warehouse_transfer.php" method="post">
           		<input type="hidden" class="orderID" name="order_id" value="'.$d.'">
			<input style="" type="submit" class="btn btn-invoice" value="Convert To WT">
			</form> -->
						
			';},
            'field' => 'order_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Orders` AS `o` LEFT JOIN `Customers` AS `c` ON (`o`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`o`.`salesperson_id` = `s`.`salesperson_id`)";
if($splitOrdersToPicks) {
    $where = "  `o`.`status` IN ('Placed','Partially Picked')";
} else {
    $where = "  `o`.`status` NOT LIKE 'Cancelled' AND ( `o`.`order_id` NOT IN (SELECT `po`.`order_id` FROM `Pick_Order` AS `po`) OR `o`.`order_id` NOT IN(SELECT `po`.`order_id` FROM `Pick_Order` AS `po` INNER JOIN `Pick` AS `p` ON(`po`.`pick_id` =`p`.`pick_id` ) WHERE `p`.`status` NOT LIKE 'Cancelled' GROUP BY `po`.`order_id`))";
}
if(isset($_SESSION['Allow_Customers']) && strcmp($_SESSION['Allow_Customers'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= "`c`.`customer_id` IN (".$_SESSION['Allow_Customers'].")";
}
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `o`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>