<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Purchase_Invoices';
 
// Table's primary key
$primaryKey = "invoice_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array( 'db' => '`i`.`invoice_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image invoice center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/invoiceicon.png" width="30" height="30"></td>';},
        'field' => 'invoice_code' ),
     array( 'db' => '`i`.`invoice_code`', 'dt' =>  'code', 'field' =>'invoice_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
     array( 'db' => '`i`.`invoice_date`', 'dt' => 'date' , 'formatter' => function( $d, $row ) {
         return date('d-m-Y',strtotime($d));},'field' => 'invoice_date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',
                'formatter' => function( $d, $row ) {


                    global $username;
                    global $password;
                    global $database;
                    $db1 = new mysqli(localhost,$username,$password,$database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }

                    $db1->set_charset("utf8");
                    $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
                    $stm1-> execute();
                    $stm1-> bind_result($fname,$lname);
                    while ($stm1->fetch()) {

                    }
                    $stm1->close();

                    return "$d - $fname $lname";



                },'field' => 'salesperson_code' ),
             array( 'db' => '`i`.`invoice_type`', 'dt' => 'type', 'field' => 'invoice_type' ),
             array( 'db' => '`i`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return currencySymbol . number_format($d,2);},
          'field' => 'grand_total' ),
         
     array( 'db' => '`i`.`invoice_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form  style="display:inline;"  class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_purchase_invoice.php" method="post">
           		<input type="hidden" class="invoiceID" name="invoice_id" value="'.$d.'">
			<input style="font-size:14px;width: 60px;" type="submit" class="btn btn-invoice" value="View" >
			</form>
			<form style="display:inline;" class="tableRowForm" id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/addedit/create_purchase_invoice.php" method="post">
           		<input type="hidden" class="invoiceID" name="invoice_id" value="'.$d.'">
			<input style="font-size:14px;" type="submit" class="btn btn-primary" value="Edit">
			</form>
			';},
            'field' => 'invoice_id' )
);
 
// SQL server connection information
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Purchase_Invoices` AS `i` LEFT JOIN `Suppliers` AS `c` ON (`i`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`i`.`salesperson_id` = `s`.`salesperson_id`)";
$where = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `i`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
require( ROOT.'backend/core/controllers/ssp2.class.php' );
 
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>