<?php
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');
// DB table to use
$table = 'Purchase_Quotations';
 
// Table's primary key
$primaryKey = "tender_code";
 
// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(

    array( 'db' => '`t`.`tender_code`', 'dt' => 'img', 'formatter' => function( $d, $row ) {

        return '<img class="custom-rounded-image-padding tender center-canvas" src="//' . HTML_PATH . '/cop/backend/themes/' . THEME_NAME . '/img/tendericon.png" width="30" height="30"></td>';},
        'field' => 'tender_code' ),

     array( 'db' => '`t`.`tender_code`', 'dt' =>  'code', 'field' =>'tender_code' ),
       array( 'db' => '`c`.`customer_company_name`', 'dt' => 'customer', 'field' => 'customer_company_name' ),
     array( 'db' => '`t`.`tender_date`', 'dt' => 'date' , 'field' => 'tender_date' ),
    
            array( 'db' => '`s`.`salesperson_code`', 'dt' => 'salesperson',
                'formatter' => function( $d, $row ) {


                    global $username;
                    global $password;
                    global $database;
                    $db1 = new mysqli(localhost,$username,$password,$database);
                    if (mysqli_connect_errno()) {
                        printf("Connect failed: %s\n", mysqli_connect_error());
                        exit();
                    }

                    $db1->set_charset("utf8");
                    $stm1 = $db1->prepare("SELECT first_name,last_name FROM SalesPersons WHERE salesperson_code='$d'");
                    $stm1-> execute();
                    $stm1-> bind_result($fname,$lname);
                    while ($stm1->fetch()) {

                    }
                    $stm1->close();

                    return "$d - $fname $lname";



                },'field' => 'salesperson_code' ),
             array( 'db' => '`t`.`valid_until`', 'dt' => 'valid', 'field' => 'valid_until' ),
             array( 'db' => '`t`.`grand_total`', 'dt' => 'grand', 'formatter' => function( $d, $row ) {
                return round($d, 2);}, 
          'field' => 'grand_total' ),
         
     array( 'db' => '`t`.`tender_id`', 'dt' => 'form', 'formatter' => function( $d, $row ) {
                return '<form id="'.$d.'" action="//'.HTML_PATH .'/cop/backend/core/views/view/view_tender.php" method="post">
           		<input type="hidden" name="tender_id" value="'.$d.'">	           			                   
			<input style="font-size:13px;" type="submit" class="btn btn-tender" value="View" style="width:60px">
			</form>';}, 
            'field' => 'tender_id' )
);

$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database ,
    'host' => 'localhost'
);
 
 
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `Purchase_Quotations` AS `t` LEFT JOIN `Customers` AS `c` ON (`t`.`customer_id` = `c`.`customer_id`) LEFT JOIN `SalesPersons` AS `s` ON (`t`.`salesperson_id` = `s`.`salesperson_id`)";
require( ROOT.'backend/core/controllers/ssp2.class.php' );
$where = '';
if(isset($_SESSION['Allow_Salespersons']) && strcmp($_SESSION['Allow_Salespersons'],'')!=0){
    if(strcmp($where,'')!=0){$where.= " AND ";}
    $where .= " `t`.`salesperson_id` IN (".$_SESSION['Allow_Salespersons'].")";
}
echo json_encode(
       SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns,$joinQuery,$where)
     );
     
     ?>