<?php

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Easy set variables
 */
include_once('../../../../param.php');

// DB table to use
$table = 'SC_Status';

// Table's primary key
$primaryKey = "status_id";

// Array of database columns which should be read and sent back to DataTables.
// The `db` parameter represents the column name in the database, while the `dt`
// parameter represents the DataTables column identifier. In this case object
// parameter names
$columns = array(
    array(
        'db' => '`s`.`status_code`',
        'dt' => 'code',
        'field' => 'status_code'
    ),

    
    array(
        'db' => '`s`.`status_name`',
        'dt' => 'name',
        'field' => 'status_name'
    ),
    
    array(
        'db' => '`s`.`position`',
        'dt' => 'position',
        'field' => 'position'
    ),
    array(
    'db' => '`s`.`calendar_fixed`',
    'dt' => 'calendar_fixed',
    'field' => 'calendar_fixed'
),
    array(
    'db' => '`s`.`visible`',
    'dt' => 'visible',
    'field' => 'visible'
),
    array(
    'db' => '`s`.`status_color`',
    'dt' => 'status_color',
    'field' => 'status_color'
),


    array(
    'db' => '`s`.`status_id`',
    'dt' => 'form',
    'field' => 'status_id'
    ),
    array(
        'db' => '`s`.`status_code`',
        'dt' => 'code_with_edit',
        'formatter' => function( $d, $row ) {
            $statusID = $row['status_id'];
            $statusField = 'code';
            $displayValue = !empty($d) ? $d :'&nbsp;';
           return "
           <div 
           id='editable-$statusID' 
           data-field-name='status_code' 
           data-id='$statusID' 
           style='position: relative; cursor: pointer;'
           onmouseover='$(this).find(\".fa-pencil\").show();'
           onmouseleave='$(this).find(\".fa-pencil\").hide();'
           onclick='openEditField($statusID, \"$statusField\", this);'>
               <span id='value-$statusField-$statusID'>$displayValue</span>
               <span id='pen-$statusField-$statusID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <input type='text' class='form-control text-center' id='input-$statusField-$statusID' value='' style='display:none;'>
           <button id='save-$statusField-$statusID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'status_code'
    ),
    
    array(
        'db' => '`s`.`status_name`',
        'dt' => 'name_with_edit',
        'formatter' => function( $d, $row ) {
            $statusID = $row['status_id'];
            $statusField = 'name';
            $displayValue = !empty($d) ? $d : '&nbsp;';

          return "
          <div 
          id='editable-$statusID' 
          data-id='$statusID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($statusID, \"$statusField\", this);'>
              <span id='value-$statusField-$statusID'>$displayValue</span>
              <span id='pen-$statusField-$statusID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <input type='text' class='form-control text-center' id='input-$statusField-$statusID' value='' style='display:none;'>
          <button id='save-$statusField-$statusID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'status_name'
    ),
    
    array(
        'db' => '`s`.`position`',
        'dt' => 'position_with_edit',
        'formatter' => function( $d, $row ) {
            $statusID = $row['status_id'];
            $statusField = 'position';
          return "
          <div 
          id='editable-$statusID' 
          data-id='$statusID' 
          style='position: relative; cursor: pointer;'
          onmouseover='$(this).find(\".fa-pencil\").show();'
          onmouseleave='$(this).find(\".fa-pencil\").hide();'
          onclick='openEditField($statusID, \"$statusField\", this);'>
              <span id='value-$statusField-$statusID'>$d</span>
              <span id='pen-$statusField-$statusID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <input type='number' class='form-control text-center' id='input-$statusField-$statusID' value='' style='display:none;'>
          <button id='save-$statusField-$statusID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
        },
        'field' => 'position'
    ),
    array(
            'db' => '`s`.`calendar_fixed`',
            'dt' => 'calendar_fixed_with_edit',
            'formatter' => function( $d, $row ) {
                $statusID = $row['status_id'];
                $statusField = 'calendar';
              return "
              <div 
              id='editable-$statusID' 
              data-id='$statusID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='openEditField($statusID, \"$statusField\", this);'>
                  <span id='value-$statusField-$statusID'>$d</span>
                  <span id='pen-$statusField-$statusID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
              </div>
              <select id='input-$statusField-$statusID' style='display:none;' class='form-control' >
                    <option value='yes' " . ($d == 'yes' ? 'selected' : '') . ">yes</option>
                    <option value='no' " . ($d == 'no' ? 'selected' : '') . ">no</option>
                    <option value='hide' " . ($d == 'hide' ? 'selected' : '') . ">hide</option>

              </select>
              <button id='save-$statusField-$statusID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>";
            },
            'field' => 'calendar_fixed'
        ),
array(
        'db' => 's.visible',
        'dt' => 'visible_with_edit',
        'formatter' => function( $d, $row ) {
            $statusID = $row['status_id'];
            $statusField = 'visible';
            $isChecked = $d == 'yes' ? 'checked' : '';
          return "
          <div 
              id='editable-$statusID' 
              data-id='$statusID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='openEditField($statusID, \"$statusField\", this);'>
                    <span id='value-$statusField-$statusID'>$d</span>
                    <span id='pen-$statusField-$statusID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
          </div>
          <select id='input-$statusField-$statusID' style='display:none;'  class='form-control'  >
            <option value='yes' " . ($d == 'yes' ? 'selected' : '') . ">yes</option>
            <option value='no' " . ($d == 'no' ? 'selected' : '') . ">no</option>
          </select>                          
          <button id='save-$statusField-$statusID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
          ";
        },
        'field' => 'visible'
    ),
    
array(
        'db' => '`s`.`status_color`',
        'dt' => 'status_color_with_edit',
        'formatter' => function( $d, $row ) {
            $statusID = $row['status_id'];
            $statusField = 'color';
            $colorisChecked = empty($d) ? 'checked' : '';
            $displayValue = !empty($d) ? $d : '#ffffff'; 
            $displayColor = !empty($d) ? $d : 'transparent'; 


          return "
          <div 
              id='editable-$statusID' 
              data-id='$statusID' 
              style='position: relative; cursor: pointer;'
              onmouseover='$(this).find(\".fa-pencil\").show();'
              onmouseleave='$(this).find(\".fa-pencil\").hide();'
              onclick='initColorChange(\"noColor-$statusField-$statusID\",\"statusColor-$statusField-$statusID\",\"input-$statusField-$statusID\");openEditField($statusID, \"$statusField\", this);'>
                  <span style='color:$displayColor;background-color:$displayColor;border: 1px solid black;width:100px; !important' class='form-control' id='value-$statusField-$statusID'>$displayValue</span>
                  <span id='pen-$statusField-$statusID' ><i class='fa fa-pencil' style='display:none; cursor:pointer; margin-left:4px;'></i></span>
           </div>
           <div id='inputDiv-$statusField-$statusID' style='display:none;'>
                <label >No Color:<input type='checkbox' id='noColor-$statusField-$statusID' style='margin: 0 5px;vertical-align: middle;width:35px;height:20px;' $colorisChecked > </label>
                <input type='color' class='form-control' id='statusColor-$statusField-$statusID' style='width: 25%;' value='$displayValue'>
                <input type='hidden' class='form-control text-center' id='input-$statusField-$statusID' value='' style='display:none;'>
              <button id='save-$statusField-$statusID' class='btn btn-success' style='display:none;'><i class='fa fa-save' style='cursor:pointer; margin-left:4px;'></i></button>
           <div>
          ";
        },
        'field' => 'status_color'
    )
);

// SQL server connection information
global $username,$password,$database;
$sql_details = array(
    'user' => $username,
    'pass' => $password,
    'db'   => $database,
    'host' => 'localhost'
);

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * If you just want to use the basic configuration for DataTables with PHP
 * server-side, there is no need to edit below this line.
 */
$joinQuery = "FROM `SC_Status` AS `s`";  // No joins needed for SC_Status table in this case
$where = ''; // Add any specific where clauses if needed


require( ROOT.'backend/core/controllers/ssp2.class.php' );

echo json_encode(
    SSP::simple( $_GET, $sql_details, $table, $primaryKey, $columns, $joinQuery, $where )
);

?>